/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.config.jpa;

import com.google.gson.Gson;
import com.penpower.worldcard.team.Utils.DatabaseCreationTimeUtil;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.HardwareIdUtil;
import com.penpower.worldcard.team.config.jpa.DatabaseConfigurator;
import com.penpower.worldcard.team.config.jpa.FlywayDecorator;
import com.penpower.worldcard.team.config.jpa.JpaConfig;
import com.penpower.worldcard.team.config.jpa.MySqlConfigurator;
import com.penpower.worldcard.team.config.jpa.PostgreSqlConfigurator;
import com.penpower.worldcard.team.config.jpa.SqlServerConfigurator;
import com.penpower.worldcard.team.config.property.SystemConstantProperties;
import com.penpower.worldcard.team.dto.WctInfo;
import com.penpower.worldcard.team.enums.DatabaseType;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.restore.DatabaseConnectionInfo;
import com.penpower.worldcard.team.restore.PostgreSqlJdbcUtils;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.EntityManagerFactory;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.flywaydb.core.Flyway;
import org.hibernate.FlushMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@Profile(value={"Prod"})
@EnableTransactionManagement
@EnableJpaRepositories(basePackages={"com.penpower.worldcard.team.dao"})
class JpaConfig {
    private static final Logger LOG = LoggerFactory.getLogger(JpaConfig.class);
    private static final String DEFAULT_PERSISTENCE_UNITNAME = "WorldCardTeamJpaContext";
    private static final String DEFAULT_ENTITY_SCAN_PACKAGE = "com.penpower.worldcard.team.entity";
    public static final AtomicReference<String> CLOUD_VERSION_DB_NAME = new AtomicReference<String>("");
    @Autowired
    private Environment env;
    @Value(value="${developmentEnv:false}")
    private boolean developmentEnv;
    @Value(value="${softwareVersion:false}")
    private boolean softwareVersion;
    @Autowired
    private DatabaseCreationTimeUtil databaseCreationTimeUtil;
    @Autowired
    private ServletContext context;
    @Value(value="${Servertype}")
    private String serverType;

    JpaConfig() {
    }

    @Bean(name={"databaseName"})
    public String databaseName() {
        String cloudDatabaseName = this.getCloudDbName();
        CLOUD_VERSION_DB_NAME.set(cloudDatabaseName);
        LOG.info("get databaseName from wct_info.json:{}", (Object)cloudDatabaseName);
        return cloudDatabaseName;
    }

    @Bean(name={"searchEngineIndex"})
    @DependsOn(value={"databaseName"})
    public String searchEngineIndex() {
        if (((String)CLOUD_VERSION_DB_NAME.get()).equals("worldcardteam")) {
            return "contact";
        }
        return (String)CLOUD_VERSION_DB_NAME.get();
    }

    public ServerType GetServerType() {
        LOG.debug("JpaConfig ServerType={}", (Object)this.serverType);
        ServerType svrType = ServerType.valueOf((String)this.serverType);
        LOG.debug("JpaConfig ServerTypeA={}", (Object)svrType);
        GlobalUtils.setServerType((ServerType)svrType);
        return svrType;
    }

    @Bean
    @DependsOn(value={"databaseName"})
    public DataSource dataSource() {
        LOG.info("developmentEnv : {} ", (Object)this.developmentEnv);
        LOG.info("softwareVersion : {} ", (Object)this.softwareVersion);
        DatabaseConfigurator configurator = this.createConfigurator();
        if (HardwareIdUtil.linuxSystem()) {
            Path restorTmpFile;
            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ServerType[this.GetServerType().ordinal()]) {
                case 1: {
                    restorTmpFile = SystemConstantProperties.RESTORE_CHECK_TMP_FILE_SYNOLOGY_NAS;
                    break;
                }
                case 2: {
                    restorTmpFile = SystemConstantProperties.RESTORE_CHECK_TMP_FILE_QNAP_NAS;
                    break;
                }
                default: {
                    restorTmpFile = SystemConstantProperties.RESTORE_CHECK_TMP_FILE;
                }
            }
            boolean restoreTmpFileExists = Files.exists(restorTmpFile, new LinkOption[0]);
            try {
                List<String> allLines = Files.readAllLines(restorTmpFile);
                int lineSize = allLines.size();
                LOG.info("restoreTmpFileExists : {} ", (Object)restoreTmpFileExists);
                LOG.info("lineSize : {} ", (Object)lineSize);
                if (restoreTmpFileExists && lineSize > 0) {
                    String serverPort;
                    String serverIpAddress;
                    String rootUrlFormat;
                    if (this.GetServerType() == ServerType.ASUSTOR_NAS) {
                        rootUrlFormat = "%s%s:%s/";
                        serverIpAddress = this.env.getProperty("dataSource.nas.ip");
                        serverPort = this.env.getProperty("dataSource.nas.port");
                        String dbUserName = this.env.getProperty("dataSource.nas.username");
                        String dbPassword = this.env.getProperty("dataSource.nas.password");
                        DatabaseConnectionInfo databaseConnectionInfo = new DatabaseConnectionInfo(rootUrlFormat, serverIpAddress, serverPort, dbUserName, dbPassword);
                        PostgreSqlJdbcUtils restoreJdbcUtils = new PostgreSqlJdbcUtils(databaseConnectionInfo);
                        restoreJdbcUtils.cleanDatabaseSessions("worldcardteam");
                        restoreJdbcUtils.deleteDatabase("worldcardteam");
                    } else if (this.GetServerType() == ServerType.SYNOLOGY_NAS) {
                        rootUrlFormat = "%s%s:%s/";
                        serverIpAddress = this.env.getProperty("dataSource.synology_nas.ip");
                        serverPort = this.env.getProperty("dataSource.synology_nas.port");
                        String dbUserName = this.env.getProperty("dataSource.synology_nas.username");
                        String dbPassword = this.env.getProperty("dataSource.synology_nas.password");
                        DatabaseConnectionInfo databaseConnectionInfo = new DatabaseConnectionInfo(rootUrlFormat, serverIpAddress, serverPort, dbUserName, dbPassword);
                        PostgreSqlJdbcUtils restoreJdbcUtils = new PostgreSqlJdbcUtils(databaseConnectionInfo);
                        restoreJdbcUtils.cleanDatabaseSessions("worldcardteam");
                        restoreJdbcUtils.deleteDatabase("worldcardteam");
                    }
                }
            }
            catch (IOException e) {
                LOG.warn("fail to read all lines from restoreTmpFile..", (Throwable)e);
            }
        }
        configurator.createDatabase();
        HikariConfig config = configurator.createHikariConfig();
        String connectionTestQuery = this.env.getProperty("dataSource.connectionTestQuery");
        String connectionTimeout = this.env.getProperty("dataSource.connectionTimeout");
        String idleTimeout = this.env.getProperty("dataSource.idleTimeout");
        String maxLifetime = this.env.getProperty("dataSource.maxLifetime");
        String maximumPoolSize = this.env.getProperty("dataSource.maximumPoolSize");
        String minimumIdle = this.env.getProperty("dataSource.minimumIdle");
        config.setAutoCommit(false);
        config.setConnectionTestQuery(connectionTestQuery);
        config.setConnectionTimeout(Long.parseLong(connectionTimeout));
        config.setIdleTimeout(Long.parseLong(idleTimeout));
        config.setMaxLifetime(Long.parseLong(maxLifetime));
        config.setMaximumPoolSize(Integer.parseInt(maximumPoolSize));
        config.setMinimumIdle(Integer.parseInt(minimumIdle));
        config.setAllowPoolSuspension(true);
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("useServerPrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        config.addDataSourceProperty("useUnicode", (Object)"true");
        config.addDataSourceProperty("characterEncoding", (Object)"utf8");
        return new HikariDataSource(config);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCloudDbName() {
        Path wctServerInfoPath = Paths.get(this.context.getRealPath(""), new String[0]).getParent();
        Gson gson = new Gson();
        LOG.info("getCloudDbName wctServerInfoPath {}", (Object)wctServerInfoPath);
        if (!Files.exists(wctServerInfoPath, new LinkOption[0])) return "worldcardteam";
        Path wctInfoFile = wctServerInfoPath.resolve("wct_info.json");
        LOG.info("getCloudDbName wctInfoFile {}", (Object)wctInfoFile);
        try (FileReader fr = new FileReader(wctInfoFile.toFile());){
            WctInfo wctInfo = (WctInfo)gson.fromJson((Reader)fr, WctInfo.class);
            LOG.info("getCloudDbName wctInfo {}", (Object)wctInfo);
            String string = wctInfo.getDatabaseName();
            return string;
        }
        catch (IOException ex) {
            return "worldcardteam";
        }
    }

    private DatabaseConfigurator createConfigurator() {
        DatabaseType type = this.getDatabaseType();
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$DatabaseType[type.ordinal()]) {
            case 1: {
                return new SqlServerConfigurator(this.developmentEnv, this.softwareVersion, this.env);
            }
            case 2: {
                return new MySqlConfigurator(this.developmentEnv, this.softwareVersion, this.env);
            }
        }
        return new PostgreSqlConfigurator(this.developmentEnv, this.softwareVersion, this.env);
    }

    private DatabaseType getDatabaseType() {
        String databaseType = null;
        databaseType = this.softwareVersion ? this.env.getProperty("dataSource.software.type") : (this.developmentEnv ? this.env.getProperty("dataSource.dev.type") : this.env.getProperty("dataSource.nas.type"));
        DatabaseType type = DatabaseType.valueOf((String)databaseType);
        return type;
    }

    @Bean(initMethod="migrate")
    Flyway flyway() {
        LOG.debug("flyway migration start.......");
        DatabaseType type = this.getDatabaseType();
        LOG.info("type : {} ", (Object)type);
        FlywayDecorator flyway = new FlywayDecorator(this.databaseCreationTimeUtil);
        if (DatabaseType.MYSQL.equals((Object)type)) {
            flyway.setLocations(new String[]{"classpath:db/migrations/mysql"});
        } else if (DatabaseType.MSSQL.equals((Object)type)) {
            flyway.setLocations(new String[]{"classpath:db/migrations/sqlserver"});
        } else {
            flyway.setLocations(new String[]{"classpath:db/migrations/postgresql"});
        }
        flyway.setDataSource(this.dataSource());
        return flyway;
    }

    @Bean
    @DependsOn(value={"flyway"})
    public EntityManagerFactory entityManagerFactory() {
        String dialect = this.getHibernateDialect();
        LOG.info("hibernate dialect : {}", (Object)dialect);
        String hbm2ddlAuto = this.env.getProperty("hibernate.hbm2ddl.auto");
        String showSql = this.env.getProperty("hibernate.show_sql");
        String formatSql = this.env.getProperty("hibernate.format_sql");
        LocalContainerEntityManagerFactoryBean entityManagerFactoryBean = new LocalContainerEntityManagerFactoryBean();
        entityManagerFactoryBean.setDataSource(this.dataSource());
        entityManagerFactoryBean.setPersistenceUnitName(DEFAULT_PERSISTENCE_UNITNAME);
        entityManagerFactoryBean.setPackagesToScan(new String[]{DEFAULT_ENTITY_SCAN_PACKAGE});
        entityManagerFactoryBean.setJpaVendorAdapter((JpaVendorAdapter)new HibernateJpaVendorAdapter());
        Properties jpaProperties = new Properties();
        jpaProperties.put("hibernate.dialect", dialect);
        jpaProperties.put("hibernate.hbm2ddl.auto", hbm2ddlAuto);
        jpaProperties.put("hibernate.show_sql", showSql);
        jpaProperties.put("hibernate.format_sql", formatSql);
        jpaProperties.put("hibernate.query.plan_cache_max_size", "128");
        jpaProperties.put("hibernate.query.plan_parameter_metadata_max_size", "16");
        jpaProperties.put("hibernate.flushMode", FlushMode.ALWAYS);
        jpaProperties.put("org.hibernate.flushMode", FlushMode.ALWAYS);
        jpaProperties.put("jadira.usertype.autoRegisterUserTypes", "true");
        entityManagerFactoryBean.setJpaProperties(jpaProperties);
        entityManagerFactoryBean.afterPropertiesSet();
        return entityManagerFactoryBean.getObject();
    }

    private String getHibernateDialect() {
        DatabaseType type = this.getDatabaseType();
        LOG.info("db type : {} ", (Object)type);
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$DatabaseType[type.ordinal()]) {
            case 1: {
                String version = "2005";
                version = this.softwareVersion ? this.env.getProperty("dataSource.software.sqlserver.version") : (this.developmentEnv ? this.env.getProperty("dataSource.nas.sqlserver.version") : this.env.getProperty("dataSource.dev.sqlserver.version"));
                if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{version})) {
                    return "org.hibernate.dialect.SQLServer2012Dialect";
                }
                switch (version) {
                    case "2005": {
                        return "org.hibernate.dialect.SQLServer2005Dialect";
                    }
                    case "2008": {
                        return "org.hibernate.dialect.SQLServer2008Dialect";
                    }
                }
                return "org.hibernate.dialect.SQLServer2012Dialect";
            }
            case 2: {
                return "org.hibernate.dialect.MySQLDialect";
            }
        }
        return "org.hibernate.dialect.PostgreSQL82Dialect";
    }

    @Bean
    public PlatformTransactionManager transactionManager() {
        JpaTransactionManager txManager = new JpaTransactionManager();
        txManager.setEntityManagerFactory(this.entityManagerFactory());
        return txManager;
    }
}

