/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.config;

import com.penpower.worldcard.team.config.property.ApplicationProperties;
import com.penpower.worldcard.team.config.property.DatabasePropertiesLoader;
import com.penpower.worldcard.team.config.property.HardCodePropertiesLoader;
import com.penpower.worldcard.team.config.property.PropertiesLoader;
import com.penpower.worldcard.team.config.property.SystemOptionPropertiesLoader;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.enums.ContactImageTransferStatus;
import com.penpower.worldcard.team.enums.DatabaseType;
import com.penpower.worldcard.team.service.AccountSecurityService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import java.security.Security;
import org.elasticsearch.client.RestHighLevelClient;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.env.Environment;

@Configuration
@ComponentScan(basePackages={"com.penpower.worldcard.team"}, excludeFilters={@ComponentScan.Filter(type=FilterType.REGEX, pattern={"com.penpower.worldcard.team.web.*"})})
@PropertySources(value={@PropertySource(value={"classpath:application.properties"}, encoding="UTF-8"), @PropertySource(value={"classpath:datasource.properties"}, encoding="UTF-8"), @PropertySource(value={"classpath:system.properties"}, encoding="UTF-8")})
@EnableAspectJAutoProxy(proxyTargetClass=true, exposeProxy=true)
public class ApplicationConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationConfig.class);
    public static final String DATE_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS");
    @Autowired
    private Environment env;
    @Autowired
    private AccountSecurityService accountSecurityService;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private RestHighLevelClient client;
    @Value(value="${developmentEnv:false}")
    private boolean developmentEnv;
    @Value(value="${softwareVersion:false}")
    private boolean softwareVersion;

    @Bean
    public ApplicationProperties initApplicationProperties() {
        LOG.info(" **** create ApplicationProperties bean instance");
        Security.setProperty("crypto.policy", "unlimited");
        this.configureGlobalInfo();
        HardCodePropertiesLoader hardCodePropertiesLoader = new HardCodePropertiesLoader(this.env);
        DatabasePropertiesLoader databasePropertiesLoader = new DatabasePropertiesLoader(this.globalInfoService);
        SystemOptionPropertiesLoader systemOptionPropertiesLoader = new SystemOptionPropertiesLoader();
        ApplicationProperties applicationProperties = new ApplicationProperties(new PropertiesLoader[]{hardCodePropertiesLoader, databasePropertiesLoader, systemOptionPropertiesLoader});
        applicationProperties.printAllProperties();
        LOG.info("Set default DateTimeZone to UTC");
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.UTC);
        return applicationProperties;
    }

    private void configureGlobalInfo() {
        Globalinfo maxCompanyCount;
        Globalinfo contactImageTransferStatus;
        Globalinfo databaseType;
        Globalinfo elasticSearchIndexingStatus;
        Globalinfo serverNeedToRestart;
        Globalinfo DatabaseBuildingTime;
        Globalinfo maxContactCount;
        LOG.info("Configure global properties....");
        Globalinfo smptServerHost = this.globalInfoService.getPropertiesByKey("PENPOWER_SMPT_SERVER");
        if (smptServerHost == null) {
            this.globalInfoService.createNewProperties("PENPOWER_SMPT_SERVER", "mail.worldcardteam.com");
            this.globalInfoService.createNewProperties("PENPOWER_SMPT_ACCOUNT", "smtp@mail1.penpower.com.tw");
            this.globalInfoService.createNewProperties("PENPOWER_SMPT_SENDER_MAIL_ADDRESS", "WorldCard Team Service<wctservice@mail.worldcardteam.com>");
        }
        if ((maxContactCount = this.globalInfoService.getPropertiesByKey("MAX_CONTACT_COUNT_IN_PRIVATE")) == null) {
            this.globalInfoService.createNewProperties("MAX_CONTACT_COUNT_IN_PRIVATE", Integer.toString(25000));
        }
        if ((DatabaseBuildingTime = this.globalInfoService.getPropertiesByKey("DB_BUILD_TIME")) == null) {
            DateTime datetimeNow = new DateTime();
            this.globalInfoService.createNewProperties("DB_BUILD_TIME", datetimeNow.toString(DATE_FORMAT_STRING).toUpperCase());
        }
        if ((serverNeedToRestart = this.globalInfoService.getPropertiesByKey("SERVER_NEED_TO_RESTART")) == null) {
            this.globalInfoService.createNewProperties("SERVER_NEED_TO_RESTART", "false");
        } else {
            LOG.info("SetProperty IN serverNeedToRestart={}", (Object)serverNeedToRestart);
            serverNeedToRestart.setConfigValue("false");
            this.globalInfoService.updatePropertyValue(serverNeedToRestart.getGuid(), "false");
        }
        maxContactCount = this.globalInfoService.getPropertiesByKey("MAX_CONTACT_COUNT_IN_DB");
        if (maxContactCount == null) {
            this.globalInfoService.createNewProperties("MAX_CONTACT_COUNT_IN_DB", Long.toString(360000L));
        }
        if ((elasticSearchIndexingStatus = this.globalInfoService.getPropertiesByKey("ELASTIC_SEARCH_INDEXING_COMPLETE")) == null) {
            this.globalInfoService.createNewProperties("ELASTIC_SEARCH_INDEXING_COMPLETE", "false");
        }
        if ((databaseType = this.globalInfoService.getPropertiesByKey("DATABASE_TYPE")) == null) {
            DatabaseType type = this.getDatabaseType();
            this.globalInfoService.createNewProperties("DATABASE_TYPE", type.toString());
        }
        if ((contactImageTransferStatus = this.globalInfoService.getPropertiesByKey("CONTACT_IMAGE_TRANSFER_STATUS")) == null) {
            this.globalInfoService.createNewProperties("CONTACT_IMAGE_TRANSFER_STATUS", ContactImageTransferStatus.IN_PROGRESS.toString());
        }
        if ((maxCompanyCount = this.globalInfoService.getPropertiesByKey("MAX_COMPANY_COUNT")) == null) {
            this.globalInfoService.createNewProperties("MAX_COMPANY_COUNT", Integer.toString(1));
        } else {
            this.globalInfoService.updatePropertyValue(maxCompanyCount.getGuid(), Integer.toString(1));
        }
        this.accountSecurityService.createAccountSecuritySetting();
    }

    public void reConfigureGlobalInfo() {
        this.configureGlobalInfo();
    }

    private DatabaseType getDatabaseType() {
        String databaseType = null;
        databaseType = this.softwareVersion ? this.env.getProperty("dataSource.software.type") : (this.developmentEnv ? this.env.getProperty("dataSource.dev.type") : this.env.getProperty("dataSource.nas.type"));
        DatabaseType type = DatabaseType.valueOf((String)databaseType);
        return type;
    }
}

