/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.backup;

import com.fatboyindustrial.gsonjodatime.Converters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.penpower.worldcard.team.backup.BackupControlFile;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupFileManager {
    private static final Logger LOG = LoggerFactory.getLogger(BackupFileManager.class);
    public static final String BACKUP_FILE_FOLDER = "worldcardteam_backup";
    public static final String BACKUP_CONTROL_FILE_NAME = "wct_backup.json";
    private String storagePath;
    private Gson gson;
    private Path backupFilesRoot;
    private Path backupFilesFolder;
    private Path controlerFile;

    public BackupFileManager(String storagePath) {
        this.storagePath = storagePath;
        this.gson = Converters.registerDateTime((GsonBuilder)new GsonBuilder()).create();
        Path storage = Paths.get(storagePath, new String[0]);
        this.backupFilesRoot = storage.resolve(BACKUP_FILE_FOLDER);
        TimeZone tz = TimeZone.getDefault();
        DateTime now = DateTime.now((DateTimeZone)DateTimeZone.forTimeZone((TimeZone)tz));
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy_MMdd_HHmmss");
        String dateFormate = now.toString(formatter);
        LOG.debug("Default timeZone : {} ", (Object)tz);
        LOG.debug("now to dateFormate with timeZone  : {}", (Object)dateFormate);
        this.backupFilesFolder = this.backupFilesRoot.resolve(dateFormate);
        this.controlerFile = this.backupFilesFolder.resolve(BACKUP_CONTROL_FILE_NAME);
        LOG.debug("this.backupFilesFolder: {}", (Object)this.backupFilesFolder);
        LOG.debug("this.controlerFile: {}", (Object)this.controlerFile);
    }

    public final void createDirectorys() throws IOException {
        LOG.debug("create all parent folders , path : {}", (Object)this.backupFilesFolder);
        Files.createDirectories(this.backupFilesFolder, new FileAttribute[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final BackupControlFile readControlFileJsonObject() {
        if (!Files.exists(this.controlerFile, new LinkOption[0])) return null;
        try (FileReader fr = new FileReader(this.controlerFile.toFile());){
            BackupControlFile controlFile;
            BackupControlFile backupControlFile = controlFile = (BackupControlFile)this.gson.fromJson((Reader)fr, BackupControlFile.class);
            return backupControlFile;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final BackupControlFile readRestoreControlFileJsonObject() {
        Path restorePath = this.getRestoreFolder();
        LOG.debug("restorePath : {} ", (Object)restorePath);
        if (restorePath == null) {
            return null;
        }
        if (!Files.exists(restorePath, new LinkOption[0])) return null;
        Path controlFilePath = restorePath.resolve(BACKUP_CONTROL_FILE_NAME);
        try (FileReader fr = new FileReader(controlFilePath.toFile());){
            BackupControlFile controlFile;
            BackupControlFile backupControlFile = controlFile = (BackupControlFile)this.gson.fromJson((Reader)fr, BackupControlFile.class);
            return backupControlFile;
        }
        catch (IOException ex) {
            throw new ItemNotFoundException("There is no restore job running.....");
        }
    }

    public final void writeControlFileJsonObject(BackupControlFile controlFile) throws IOException {
        try (FileWriter writer = new FileWriter(this.controlerFile.toFile(), false);){
            this.gson.toJson((Object)controlFile, (Appendable)writer);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Path getRestoreFolder() {
        LOG.debug("this.backupFilesRoot : {} ", (Object)this.backupFilesRoot);
        if (!Files.exists(this.backupFilesRoot, new LinkOption[0])) return null;
        LOG.debug("this.backupFilesRoot  exists...");
        List<Object> files = new ArrayList();
        try (Stream<Path> pathStream = Files.list(this.backupFilesRoot);){
            Path restorePath;
            files = pathStream.filter(p -> Files.isDirectory(p, new LinkOption[0])).sorted().map(p -> p.toString()).collect(Collectors.toList());
            int count = files.size();
            LOG.debug("files : {} ", files);
            LOG.debug("count : {}", (Object)count);
            Path path = restorePath = Paths.get((String)files.get(count - 1), new String[0]);
            return path;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public Gson getGson() {
        return this.gson;
    }

    public Path getBackupFilesRoot() {
        return this.backupFilesRoot;
    }

    public Path getBackupFilesFolder() {
        return this.backupFilesFolder;
    }

    public Path getControlerFile() {
        return this.controlerFile;
    }
}

