/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.auth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.entity.Token;
import com.penpower.worldcard.team.enums.Platform;
import com.penpower.worldcard.team.enums.PlatformCategory;
import io.swagger.annotations.ApiModelProperty;
import org.joda.time.DateTime;
import org.springframework.format.annotation.DateTimeFormat;

public class TokenInfo {
    @ApiModelProperty(dataType="java.lang.String", required=true, example="1970-01-01 11:22:33.999")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    private final DateTime createdTime;
    @ApiModelProperty(dataType="java.lang.String", required=true, example="1970-01-01 11:22:33.999")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    private final DateTime expiredTime;
    @ApiModelProperty(dataType="java.lang.String", required=true, example="1970-01-01 11:22:33.999")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    private final DateTime invalidTime;
    private final String token;
    @JsonIgnore
    private final String userGuid;
    private final Platform platform;
    private final PlatformCategory platformCategory;
    private String ip;
    private String hostname;
    @JsonIgnore
    private String deviceId;

    public TokenInfo(Token token) {
        this.token = token.getToken();
        this.createdTime = token.getCreatedtime();
        this.expiredTime = token.getExpiredtime();
        this.invalidTime = token.getInvalidtime();
        this.userGuid = token.getUserguid();
        this.platform = token.getPlatform();
        this.platformCategory = token.getPlatformcategory();
        this.ip = token.getIp();
        this.deviceId = token.getDeviceid();
        this.hostname = token.getHostname();
    }

    public TokenInfo(String token, String userGuid) {
        this.token = token;
        this.createdTime = new DateTime(System.currentTimeMillis());
        this.expiredTime = this.createdTime.plusMinutes(30);
        this.invalidTime = this.createdTime.plusMinutes(43200);
        this.userGuid = userGuid;
        this.platform = Platform.WEB;
        this.platformCategory = GlobalUtils.getPlatformCategory((Platform)this.platform);
    }

    public TokenInfo(String token, String userGuid, Platform platform) {
        this.token = token;
        this.createdTime = new DateTime(System.currentTimeMillis());
        this.expiredTime = this.createdTime.plusMinutes(30);
        this.invalidTime = this.createdTime.plusMinutes(43200);
        this.userGuid = userGuid;
        this.platform = platform;
        this.platformCategory = GlobalUtils.getPlatformCategory((Platform)this.platform);
    }

    public TokenInfo(String token, DateTime createdTime, DateTime exipredTime, DateTime invalidTime, String userGuid, Platform platform) {
        this.token = token;
        this.createdTime = createdTime;
        this.expiredTime = exipredTime;
        this.invalidTime = invalidTime;
        this.userGuid = userGuid;
        this.platform = platform;
        this.platformCategory = GlobalUtils.getPlatformCategory((Platform)this.platform);
    }

    public TokenInfo(String token, String userGuid, Platform platform, String ip, String deviceId) {
        this.token = token;
        this.createdTime = new DateTime(System.currentTimeMillis());
        this.expiredTime = this.createdTime.plusMinutes(30);
        this.invalidTime = this.createdTime.plusMinutes(43200);
        this.userGuid = userGuid;
        this.platform = platform;
        this.platformCategory = GlobalUtils.getPlatformCategory((Platform)this.platform);
        this.ip = ip;
        this.deviceId = deviceId;
    }

    public String getToken() {
        return this.token;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public DateTime getCreatedTime() {
        return this.createdTime;
    }

    public DateTime getExpiredTime() {
        return this.expiredTime;
    }

    public DateTime getInvalidTime() {
        return this.invalidTime;
    }

    public String getUserGuid() {
        return this.userGuid;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public PlatformCategory getPlatformCategory() {
        return this.platformCategory;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TokenInfo other = (TokenInfo)obj;
        if (this.token == null) {
            if (other.token != null) {
                return false;
            }
        } else {
            if (!this.token.equals(other.token)) {
                return false;
            }
            if (this.token.equals(other.token)) {
                return true;
            }
        }
        return super.equals(obj);
    }

    public String toString() {
        return "TokenInfo [createdTime=" + new DateTime((Object)this.createdTime).toString("yyyy-MM-dd HH:mm:ss") + ", expiredTime=" + new DateTime((Object)this.expiredTime).toString("yyyy-MM-dd HH:mm:ss") + ", invalidTime=" + new DateTime((Object)this.invalidTime).toString("yyyy-MM-dd HH:mm:ss") + ", userGuid=" + this.userGuid + ", platform=" + this.platform + ", hostname=" + this.hostname + ", token=" + this.token + "]";
    }
}

