/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.auth;

import com.google.gson.Gson;
import com.penpower.worldcard.team.Utils.NetworkUtil;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.auth.ReadOnlyStatusManager;
import com.penpower.worldcard.team.auth.TokenInfo;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.enums.AccountLockedIssue;
import com.penpower.worldcard.team.enums.Platform;
import com.penpower.worldcard.team.enums.UserRole;
import com.penpower.worldcard.team.enums.VerifySource;
import com.penpower.worldcard.team.exception.AccessWithUnbindingDeviceOrNotAllowedIpException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.exception.SubscriptionOutOfTSubscripException;
import com.penpower.worldcard.team.service.AccountSecurityService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.web.api.vo.response.ErrorResponseInfoResult;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;
import org.springframework.web.util.UrlPathHelper;

public class AccountSecurityFilter
extends GenericFilterBean {
    private static final Logger LOG = LoggerFactory.getLogger(AccountSecurityFilter.class);
    private AccountSecurityService accountSecurityService;
    private AccountService accountService;

    public AccountSecurityFilter(AccountSecurityService accountSecurityService, AccountService accountService) {
        this.accountSecurityService = accountSecurityService;
        this.accountService = accountService;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestURI = httpRequest.getRequestURI();
        LOG.debug("AccountSecurityFilter url={} ", (Object)requestURI);
        try {
            if (!this.fromWebsocketRequestURI(requestURI) && SecurityContextHolder.getContext().getAuthentication() != null) {
                TokenInfo tokenInfo = SecurityUtils.getCurrentLoginUserToken();
                String deviceId = tokenInfo.getDeviceId();
                Platform platform = tokenInfo.getPlatform();
                String ipAddress = NetworkUtil.getClientIp((HttpServletRequest)httpRequest);
                String accountGuid = tokenInfo.getUserGuid();
                LOG.debug("AccountSecurityFilter tokenInfo={} ", (Object)tokenInfo);
                this.accountSecurityService.verifyAccountSecurity(VerifySource.API, accountGuid, ipAddress, deviceId, null, platform, new DateTime());
            }
            if (SecurityContextHolder.getContext().getAuthentication() != null) {
                this.checkSubscription(request, response, chain);
            }
            chain.doFilter(request, response);
        }
        catch (ItemNotFoundException ex) {
            SecurityContextHolder.clearContext();
            httpResponse.setContentType("application/json;charset=UTF-8");
            httpResponse.setStatus(200);
            String message = "Resource item not found in system. <BR>";
            int errorCode = HttpStatus.NOT_FOUND.value();
            String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
            Gson gson = new Gson();
            String unAuthorizedMessage = gson.toJson((Object)result);
            try (ServletOutputStream ServletOutputStream2 = response.getOutputStream();){
                ServletOutputStream2.println(unAuthorizedMessage);
            }
        }
        catch (RequestArgumentNotValidException | IllegalArgumentException ex) {
            SecurityContextHolder.clearContext();
            httpResponse.setContentType("application/json;charset=UTF-8");
            httpResponse.setStatus(200);
            String message = "Request required parameters not valid. <BR>";
            int errorCode = 422;
            String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
            Gson gson = new Gson();
            String unAuthorizedMessage = gson.toJson((Object)result);
            try (ServletOutputStream ServletOutputStream3 = response.getOutputStream();){
                ServletOutputStream3.println(unAuthorizedMessage);
            }
        }
        catch (AccessWithUnbindingDeviceOrNotAllowedIpException ex) {
            SecurityContextHolder.clearContext();
            httpResponse.setContentType("application/json;charset=UTF-8");
            httpResponse.setStatus(200);
            String message = "Access with unbinding device or not-allowed IP address";
            int errorCode = 469;
            String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
            Gson gson = new Gson();
            String unAuthorizedMessage = gson.toJson((Object)result);
            try (ServletOutputStream ServletOutputStream4 = response.getOutputStream();){
                ServletOutputStream4.println(unAuthorizedMessage);
            }
        }
        catch (SubscriptionOutOfTSubscripException ex) {
            LOG.debug("SubscriptionAuthenticationProvider in api in list ");
            SecurityContextHolder.clearContext();
            httpResponse.setContentType("application/json;charset=UTF-8");
            httpResponse.setStatus(200);
            String message = "Subscription mode out of subscription";
            int errorCode = 486;
            String errorMessage = "TEMPLATE_INVALIDATE user locked";
            ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
            Gson gson = new Gson();
            String unAuthorizedMessage = gson.toJson((Object)result);
            try (ServletOutputStream ServletOutputStream5 = response.getOutputStream();){
                LOG.debug("respone ={}", (Object)unAuthorizedMessage);
                ServletOutputStream5.println(unAuthorizedMessage);
            }
        }
    }

    void checkSubscription(ServletRequest request, ServletResponse response, FilterChain chain) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String path = new UrlPathHelper().getPathWithinApplication(httpRequest);
        LOG.debug("SubscriptionAuthenticationProvider path ={}", (Object)path);
        TokenInfo tokenInfo = SecurityUtils.getCurrentLoginUserToken();
        String deviceId = tokenInfo.getDeviceId();
        Platform platform = tokenInfo.getPlatform();
        String ipAddress = NetworkUtil.getClientIp((HttpServletRequest)httpRequest);
        String accountGuid = tokenInfo.getUserGuid();
        LOG.debug("AccountSecurityFilter accountGuid={} ", (Object)accountGuid);
        AccountInfo accountInfo = null;
        try {
            accountInfo = this.accountService.getAccountInfo(accountGuid, null);
        }
        catch (ItemNotFoundException e) {
            return;
        }
        LOG.debug("SubscriptionAuthenticationProvider accountInfo ={}", (Object)accountInfo);
        if (accountInfo != null && accountInfo.getLockedIssue() != AccountLockedIssue.NO_ISSUE) {
            LOG.debug("SubscriptionAuthenticationProvider in TEMPLATE_INVALIDATE ");
            if (path.compareToIgnoreCase("/api/user/account/change_password") == 0) {
                if (accountInfo.getRole() != UserRole.ADMIN) {
                    throw new SubscriptionOutOfTSubscripException("TEMPLATE_INVALIDATE user locked");
                }
                return;
            }
            if (ReadOnlyStatusManager.SUBSCRIPTION_TEMPLATE_READONLY_FORCE_ACCESS_PATH.contains(path)) {
                return;
            }
            if (ReadOnlyStatusManager.SUBSCRIPTION_TEMPLATE_READONLY_CANNOT_ACCESS_PATHS.contains(path)) {
                throw new SubscriptionOutOfTSubscripException("TEMPLATE_INVALIDATE user locked");
            }
            for (String url : ReadOnlyStatusManager.SUBSCRIPTION_TEMPLATE_READONLY_CANNOT_ACCESS_PATH_GROUP) {
                if (path.indexOf(url, 0) != 0) continue;
                throw new SubscriptionOutOfTSubscripException("TEMPLATE_INVALIDATE user locked");
            }
        }
    }

    private boolean fromWebsocketRequestURI(String requestURI) {
        return StringUtils.isNotEmpty((CharSequence)requestURI) && requestURI.indexOf("/webSocket") >= 0;
    }
}

