/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.Utils;

import com.penpower.worldcard.team.auth.AuthenticationWithToken;
import com.penpower.worldcard.team.auth.TokenInfo;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.enums.AccountLockedIssue;
import com.penpower.worldcard.team.enums.AccountSubscriptionStatus;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.exception.AuthenticationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class SecurityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);

    public static final AccountInfo getCurrentLoginUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        try {
            AccountInfo accountInfo = (AccountInfo)authentication.getPrincipal();
            return accountInfo;
        }
        catch (Exception ex) {
            LOG.debug("fail to get user ", (Throwable)ex);
            throw new AuthenticationFailedException("Fail to get current login user object", (Throwable)ex);
        }
    }

    public static final TokenInfo getCurrentLoginUserToken() {
        AuthenticationWithToken authenticationWithToken = (AuthenticationWithToken)SecurityContextHolder.getContext().getAuthentication();
        TokenInfo tokenInfo = (TokenInfo)authenticationWithToken.getDetails();
        return tokenInfo;
    }

    public static final boolean validSubscribUser(AccountSubscriptionStatus accountSubscriptionStatus) {
        boolean validUser = AccountSubscriptionStatus.IN_SUBSCRIPTION.equals((Object)accountSubscriptionStatus);
        return validUser;
    }

    public static final boolean validUser(UserStatus userStatus) {
        boolean validUser = UserStatus.ACTIVE.equals((Object)userStatus) || UserStatus.INACTIVE.equals((Object)userStatus) || UserStatus.UNVERTIFY.equals((Object)userStatus);
        return validUser;
    }

    public static final boolean validLock(AccountLockedIssue accountLockedIssue) {
        boolean validLock = AccountLockedIssue.NO_ISSUE.equals((Object)accountLockedIssue);
        return validLock;
    }

    public static final String getCurrentLoginUserIp() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return "";
        }
        Object details = authentication.getDetails();
        if (!(details instanceof WebAuthenticationDetails)) {
            return "";
        }
        WebAuthenticationDetails webDetails = (WebAuthenticationDetails)details;
        return webDetails.getRemoteAddress();
    }
}

