/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.Utils;

import com.penpower.worldcard.team.Utils.EasyEncoderJNI;
import com.penpower.worldcard.team.Utils.RegistryInformationUtil;
import com.penpower.worldcard.team.dto.RegistryDto;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.exception.IncorrectRegistrationInformationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RegistryInformationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryInformationUtil.class);

    public static final String ResponeDataToString(String registryDataByteString, String macAddressKey, ServerType serverType) {
        int nReceiveDataSize = registryDataByteString.getBytes().length;
        String resultText = "";
        if (nReceiveDataSize % 2 == 0) {
            boolean doDataVaild = true;
            for (int i = 0; i < nReceiveDataSize; ++i) {
                byte getByte = registryDataByteString.getBytes()[i];
                if (getByte >= 97 && getByte <= 102 || getByte >= 65 && getByte <= 70 || getByte >= 48 && getByte <= 57) continue;
                doDataVaild = false;
                break;
            }
            if (doDataVaild) {
                int count = 0;
                byte[] getData = new byte[nReceiveDataSize * 2 + 10];
                if (getData != null) {
                    for (int i = 0; i < nReceiveDataSize; i += 2) {
                        getData[count] = (byte)(RegistryInformationUtil.Hex2Value((byte)registryDataByteString.getBytes()[i]) << 4 & 0xF0);
                        int n = count++;
                        getData[n] = (byte)(getData[n] | RegistryInformationUtil.Hex2Value((byte)registryDataByteString.getBytes()[i + 1]) & 0xF);
                    }
                }
                LOG.debug("acount ={} MACADDR={} getData ={}", new Object[]{count, macAddressKey, getData});
                byte[] resultBytesA = null;
                switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ServerType[serverType.ordinal()]) {
                    default: {
                        resultBytesA = new EasyEncoderJNI().ServerEasyDecodeEx_Bin("".getBytes(), getData, count, macAddressKey.toCharArray());
                        if (resultBytesA == null) {
                            return null;
                        }
                        LOG.debug("resultBytesa ={}", (Object)resultBytesA);
                        resultText = new String(resultBytesA);
                        LOG.debug(",resultText={}", (Object)resultText);
                        break;
                    }
                    case 8: {
                        new EasyEncoderJNI();
                        resultBytesA = EasyEncoderJNI.ServerEasyDecodeEx_Bin_win((byte[])"".getBytes(), (byte[])getData, (int)count, (char[])macAddressKey.toCharArray());
                        if (resultBytesA == null) {
                            return null;
                        }
                        LOG.debug("resultBytesa ={}", (Object)resultBytesA);
                        resultText = RegistryInformationUtil.ConvertByteArrayToString((byte[])resultBytesA);
                        LOG.debug("resultText ={}", (Object)resultText);
                        break;
                    }
                }
            } else {
                throw new IncorrectRegistrationInformationException("Registration data invalid.");
            }
        }
        return resultText;
    }

    public static String ConvertByteArrayToString(byte[] bytes) {
        String strall = "";
        block5: for (int i = 0; i < bytes.length; ++i) {
            char cc = (char)bytes[i];
            switch (cc) {
                case '\r': {
                    strall = strall + "\r";
                    continue block5;
                }
                case '\n': {
                    strall = strall + "\n";
                    continue block5;
                }
                case '\u0000': {
                    continue block5;
                }
                default: {
                    String s = String.format("%c", Character.valueOf(cc));
                    strall = strall + s;
                }
            }
        }
        return strall;
    }

    public static final RegistryDto getRegistryInfomationFromString(String resultText) {
        LOG.debug("getRegistryInfomationFromString resultText={}", (Object)resultText);
        char[] chars = resultText.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (char c : chars) {
            String hexString = Integer.toHexString(c);
            if ("0".equals(hexString)) continue;
            sb.append(c);
        }
        if (sb.toString().toLowerCase().indexOf("ng:") >= 0) {
            return null;
        }
        RegistryDto registryDto = null;
        LOG.debug("getRegistryInfomation sb={}", (Object)sb.toString());
        try {
            registryDto = new RegistryDto(sb.toString());
        }
        catch (Exception ee) {
            LOG.debug("getRegistryInfomationFromString Exception={}", (Object)ee.getMessage());
        }
        return registryDto;
    }

    public static final RegistryDto getRegistryInfomation(String registryDataByteString, String macAddressKey, ServerType serverType) {
        if (registryDataByteString == null || registryDataByteString.length() < 10) {
            return null;
        }
        if (registryDataByteString.indexOf("ng:") >= 0) {
            return null;
        }
        int nReceiveDataSize = registryDataByteString.getBytes().length;
        LOG.debug("getRegistryInfomation registryDataByteString={}", (Object)registryDataByteString);
        if (nReceiveDataSize % 2 == 0) {
            boolean doDataVaild = true;
            for (int i = 0; i < nReceiveDataSize; ++i) {
                byte getByte = registryDataByteString.getBytes()[i];
                if (getByte >= 97 && getByte <= 102 || getByte >= 65 && getByte <= 70 || getByte >= 48 && getByte <= 57) continue;
                doDataVaild = false;
                break;
            }
            LOG.debug("getRegistryInfomation 1");
            if (doDataVaild) {
                int count = 0;
                byte[] getData = new byte[nReceiveDataSize * 2 + 10];
                if (getData != null) {
                    for (int i = 0; i < nReceiveDataSize; i += 2) {
                        getData[count] = (byte)(RegistryInformationUtil.Hex2Value((byte)registryDataByteString.getBytes()[i]) << 4 & 0xF0);
                        int n = count++;
                        getData[n] = (byte)(getData[n] | RegistryInformationUtil.Hex2Value((byte)registryDataByteString.getBytes()[i + 1]) & 0xF);
                    }
                }
                LOG.debug("count ={} MACADDR={} getData ={}", new Object[]{count, macAddressKey, getData});
                for (int retryTime = 0; retryTime < 6; ++retryTime) {
                    String resultText = "";
                    switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ServerType[serverType.ordinal()]) {
                        default: {
                            byte[] resultBytesa = new EasyEncoderJNI().ServerEasyDecodeEx_Bin("".getBytes(), getData, count, macAddressKey.toCharArray());
                            LOG.debug("resultBytesa ={}", (Object)resultBytesa);
                            if (resultBytesa == null) {
                                return null;
                            }
                            resultText = new String(resultBytesa);
                            break;
                        }
                        case 8: {
                            new EasyEncoderJNI();
                            byte[] resultBytesaWin = EasyEncoderJNI.ServerEasyDecodeEx_Bin_win((byte[])"".getBytes(), (byte[])getData, (int)count, (char[])macAddressKey.toCharArray());
                            LOG.debug("resultBytesa ={}", (Object)resultBytesaWin);
                            if (resultBytesaWin == null) {
                                return null;
                            }
                            resultText = RegistryInformationUtil.ConvertByteArrayToString((byte[])resultBytesaWin);
                        }
                    }
                    char[] chars = resultText.toCharArray();
                    StringBuilder sb = new StringBuilder();
                    for (char c : chars) {
                        String hexString = Integer.toHexString(c);
                        if ("0".equals(hexString)) continue;
                        sb.append(c);
                    }
                    if (sb.toString().toLowerCase().indexOf("ng:") >= 0) {
                        return null;
                    }
                    LOG.debug("resultText={}", (Object)resultText);
                    RegistryDto registryDto = null;
                    LOG.debug("sb ={}", (Object)sb.toString());
                    try {
                        registryDto = new RegistryDto(sb.toString());
                        return registryDto;
                    }
                    catch (Exception ee) {
                        LOG.debug("getRegistryInfomationFromString Exception={}", (Object)ee.getMessage());
                        continue;
                    }
                }
            } else {
                LOG.debug("getRegistryInfomation IncorrectRegistrationInformationException");
                return null;
            }
        }
        return null;
    }

    private static String getTokenStringValue(String token) {
        String originalToken = token;
        String[] tokenSplit = originalToken.split(":");
        String tokenValue = tokenSplit[tokenSplit.length - 1];
        return tokenValue;
    }

    private static int getTokenIntValue(String token) {
        LOG.debug("token={}", (Object)token);
        LOG.debug("tokenlength={}", (Object)token.length());
        String originalToken = token;
        String[] tokenSplit = originalToken.split(":");
        String valueString = tokenSplit[tokenSplit.length - 1];
        LOG.debug("tokenSplit={}", (Object)tokenSplit[0]);
        LOG.debug("tokenSplitlength={}", (Object)tokenSplit[0].length());
        LOG.debug("valueString={}", (Object)valueString);
        LOG.debug("valueStringlength={}", (Object)valueString.length());
        int tokenValue = Integer.parseInt(valueString);
        LOG.debug("tokenValue={}", (Object)tokenValue);
        return tokenValue;
    }

    private static int Hex2Value(byte input) {
        if (input >= 48 && input <= 57) {
            input = (byte)(input - 48);
        } else if (input >= 97 && input <= 122) {
            input = (byte)(input - 97 + 10);
        } else if (input >= 65 && input <= 90) {
            input = (byte)(input - 65 + 10);
        }
        return input;
    }
}

