/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.Utils;

import com.penpower.worldcard.team.enums.CountryCode;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PenpowerCountryMapperUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PenpowerCountryMapperUtil.class);
    private static final Map<String, CountryCode> COUNTRY_NAME_TO_CODE = new HashMap();
    private static final Map<CountryCode, String[]> COUNTRY_CODE_TO_NAME = new EnumMap(CountryCode.class);
    private static final int LANGUAGE_COUNT = 34;
    private static final int ENGLISH_COUNTRY_NAME_INDEX = 2;

    public static final CountryCode getCountryCode(String countryName) {
        return (CountryCode)COUNTRY_NAME_TO_CODE.get(countryName);
    }

    public static final String getEnglishCountryName(String countryCode) {
        try {
            String[] countryNames = (String[])COUNTRY_CODE_TO_NAME.get(CountryCode.valueOf((String)countryCode.toUpperCase()));
            return countryNames[2];
        }
        catch (Exception ex) {
            LOG.error("get countryNames failed", (Throwable)ex);
            return "";
        }
    }

    static {
        COUNTRY_CODE_TO_NAME.put(CountryCode.BI, "bi,\u84b2\u9686\u5730,Burundi,Burundi,Burundi,\u30d6\u30eb\u30f3\u30b8,Burundi,Burundi,Burundi,Burundi,Burundi,Burundi,Burundi,Burundi,Burundi,\ubd80\ub8ec\ub514,\u5e03\u9686\u8fea,\u0411\u0443\u0440\u0443\u043d\u0434\u0438,Burundi,Burundi,\u0411\u0443\u0440\u0443\u043d\u0434\u0456,\u0628\u0648\u0631\u0648\u0646\u062f\u064a,Burundi,Burundi,\u039c\u03c0\u03bf\u03c5\u03c1\u03bf\u03cd\u03bd\u03c4\u03b9,\u05d1\u05d5\u05e8\u05d5\u05e0\u05d3\u05d9,Burundi,Burundi,\u0e1a\u0e38\u0e23\u0e38\u0e19\u0e14\u0e35,Burundi,Burundi,Burundi,Burundi,Bu-run-\u0111i".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.DJ, "dj,\u5409\u5e03\u5730,Djibouti,Djibouti,Dschibuti,\u30b8\u30d6\u30c1,Djibouti,Gibuti,Yibuti,Djibuti,Djibuti,Djibouti,Djibouti,Djibouti,Djibouti,\uc9c0\ubd80\ud2f0,\u5409\u5e03\u63d0,\u0414\u0436\u0438\u0431\u0443\u0442\u0438,D\u017cibuti,Cibuti,\u0414\u0436\u0456\u0431\u0443\u0442\u0456,\u062c\u064a\u0628\u0648\u062a\u064a,D\u017eibuti,D\u017eibuti,\u03a4\u03b6\u03b9\u03bc\u03c0\u03bf\u03c5\u03c4\u03af,\u05d2\u05f3\u05d9\u05d1\u05d5\u05d8\u05d9,Djibouti,D\u017eibuti,\u0e08\u0e34\u0e1a\u0e39\u0e15\u0e35,Jibuti,Djibouti,Djibouti,Dzsibuti,Gi-bu-ti".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.ER, "er,\u5384\u5229\u5782\u4e9e,Eritrea,\u00c9rythr\u00e9e,Eritrea,\u30a8\u30ea\u30c8\u30ea\u30a2,Eritrea,Eritrea,Eritrea,Eritreia,Eritreia,Eritrea,Eritrea,Eritrea,Eritrea,\uc5d0\ub9ac\ud2b8\ub9ac\uc544,\u5384\u7acb\u7279\u91cc\u4e9a,\u042d\u0440\u0438\u0442\u0440\u0435\u044f,Erytrea,Eritre,\u0415\u0440\u0438\u0442\u0440\u0435\u044f,\u0627\u0631\u064a\u062a\u0631\u064a\u0627,Eritreja,Eritrea,\u0395\u03c1\u03c5\u03b8\u03c1\u03b1\u03af\u03b1,\u05d0\u05e8\u05d9\u05ea\u05e8\u05d0\u05d4,Eritreea,Eritrea,\u0e40\u0e2d\u0e23\u0e34\u0e40\u0e17\u0e23\u0e35\u0e22,Eritrea,Eritrea,Eritrea,Eritrea,\u00ca-ri-t\u01a1-r\u00ea-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.ET, "et,\u8863\u7d22\u6bd4\u4e9e,Ethiopia,\u00c9thiopie,\u00c4thiopien,\u30a8\u30c1\u30aa\u30d4\u30a2,Ethiopi\u00eb,Etiopia,Etiop\u00eda,Eti\u00f3pia,Eti\u00f3pia,Etiopien,Etiopia,Etiopia,Etiopien,\uc774\ub514\uc624\ud53c\uc544,\u57c3\u585e\u4fc4\u6bd4\u4e9a,\u042d\u0444\u0438\u043e\u043f\u0438\u044f,Etiopia,Etiyopya,\u0415\u0444\u0456\u043e\u043f\u0456\u044f,\u0627\u062b\u064a\u0648\u0628\u064a\u0627,Etiopija,Etiopie,\u0391\u03b9\u03b8\u03b9\u03bf\u03c0\u03af\u03b1,\u05d0\u05ea\u05d9\u05d5\u05e4\u05d9\u05d4,Etiopia,Eti\u00f3pia,\u0e40\u0e2d\u0e18\u0e34\u0e42\u0e2d\u0e40\u0e1b\u0e35\u0e22,Ethiopia,Ethiopia,Eti\u00f2pia,Eti\u00f3pia,\u00ca-ti-\u00f4-pi-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.KE, "ke,\u80af\u4e9e,Kenya,Kenya,Kenia,\u30b1\u30cb\u30a2,Kenia,Kenya,Kenia,Qu\u00eania,Qu\u00e9nia,Kenya,Kenia,Kenya,Kenya,\ucf00\ub0d0,\u80af\u5c3c\u4e9a,\u041a\u0435\u043d\u0438\u044f,Kenia,Kenya,\u041a\u0435\u043d\u0456\u044f,\u0643\u064a\u0646\u064a\u0627,Kenija,Ke\u0148a,\u039a\u03ad\u03bd\u03c5\u03b1,\u05e7\u05e0\u05d9\u05d4,Kenya,Ke\u0148a,\u0e40\u0e04\u0e19\u0e22\u0e32,Kenya,Kenya,Kenya,Kenya,K\u00ea-ni-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.KM, "km,\u79d1\u6469\u7f85\u7fa4\u5cf6,Comoros,Comores,Komoren,\u30b3\u30e2\u30ed,Comoren,Comore,Comoras,Comores,Comores,Comorerne,Komorit,Komorene,Komorerna,\ucf54\ubaa8\ub85c\uc2a4,\u79d1\u6469\u7f57,\u041a\u043e\u043c\u043e\u0440\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430,Komory,Komorlar,\u041a\u043e\u043c\u043e\u0440\u0441\u044c\u043a\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438,\u062c\u0632\u0631 \u0627\u0644\u0642\u0645\u0631,Komori,Komory,\u039a\u03bf\u03bc\u03cc\u03c1\u03bf\u03c2,\u05e7\u05d5\u05de\u05d5\u05e8\u05d5\u05e1,Comore,Komory,\u0e04\u0e2d\u0e42\u0e21\u0e42\u0e23\u0e2a,Komoros,Comoros,Comores,Comore-szigetek,C\u00f4-m\u00f4".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.MG, "mg,\u99ac\u9054\u52a0\u65af\u52a0,Madagascar,Madagascar,Madagaskar,\u30de\u30c0\u30ac\u30b9\u30ab\u30eb,Madagaskar,Madagascar,Madagascar,Madagascar,Madag\u00e1scar,Madagaskar,Madagaskar,Madagaskar,Madagaskar,\ub9c8\ub2e4\uac00\uc2a4\uce74\ub974,\u9a6c\u8fbe\u52a0\u65af\u52a0,\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440,Madagaskar,Madagaskar,\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440,\u0645\u062f\u063a\u0634\u0642\u0631,Madagaskar,Madagaskar,\u039c\u03b1\u03b4\u03b1\u03b3\u03b1\u03c3\u03ba\u03ac\u03c1\u03b7,\u05de\u05d3\u05d2\u05e1\u05e7\u05e8,Madagascar,Madagaskar,\u0e21\u0e32\u0e14\u0e32\u0e01\u0e31\u0e2a\u0e01\u0e32\u0e23\u0e4c,Madagaskar,Madagascar,Madagascar,Madagaszk\u00e1r,Ma-\u0111a-g\u00e1t-xca".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.MU, "mu,\u6a21\u91cc\u897f\u65af,Mauritius,Maurice,Mauritius,\u30e2\u30fc\u30ea\u30b7\u30e3\u30b9,Mauritius,Mauritius,Mauricio,Maur\u00edcio,Maur\u00edcias,Mauritius,Mauritius,Mauritius,Mauritius,\ubaa8\ub9ac\uc154\uc2a4,\u6bdb\u91cc\u6c42\u65af,\u041c\u0430\u0432\u0440\u0438\u043a\u0438\u0439,Mauritius,Mauritius,\u041c\u0430\u0432\u0440\u0438\u043a\u0456\u0439,\u0645\u0648\u0631\u064a\u0634\u064a\u0648\u0633,Mauricijus,Mauricius,\u039c\u03b1\u03c5\u03c1\u03af\u03ba\u03b9\u03bf\u03c2,\u05de\u05d0\u05d5\u05e8\u05d9\u05e6\u05d9\u05d5\u05e1,Mauritius,Maur\u00edcius,\u0e21\u0e2d\u0e23\u0e34\u0e40\u0e0a\u0e35\u0e22\u0e2a,Mauritius,Mauritius,Maurici,Mauritius,M\u00f4-ri-x\u01a1".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.MW, "mw,\u99ac\u62c9\u5a01,Malawi,Malawi,Malawi,\u30de\u30e9\u30a6\u30a3,Malawi,Malawi,Malaui,Malawi,Malavi,Malawi,Malawi,Malawi,Malawi,\ub9d0\ub77c\uc704,\u9a6c\u62c9\u7ef4,\u041c\u0430\u042c\u0430\u0432\u0438,Malawi,Malavi,\u041c\u0430\u042c\u0430\u0432\u0456,\u0645\u0644\u0627\u0648\u064a,Malavi,Malawi,\u039c\u03b1\u03bb\u03ac\u03bf\u03c5\u03b9,\u05de\u05dc\u05d0\u05d5\u05d5\u05d9,Malawi,Malawi,\u0e21\u0e32\u0e25\u0e32\u0e27\u0e35,Malawi,Malawi,Malawi,Malawi,Ma-la-uy".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.MZ, "mz,\u83ab\u4e09\u6bd4\u514b,Mozambique,Mozambique,Mosambik,\u30e2\u30b6\u30f3\u30d3\u30fc\u30af,Mozambique,Mozambico,Mozambique,Mo\u00e7ambique,Mo\u00e7ambique,Mozambique,Mosambik,Mosambik,Mo\u00e7ambique,\ubaa8\uc7a0\ube44\ud06c,\u83ab\u6851\u6bd4\u514b,\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a,Mozambik,Mozambik,\u041c\u043e\u0437\u0430\u043c\u0431\u0456\u043a,\u0645\u0648\u0632\u0645\u0628\u064a\u0642,Mozambik,Mosambik,\u039c\u03bf\u03b6\u03b1\u03bc\u03b2\u03af\u03ba\u03b7,\u05de\u05d5\u05d6\u05de\u05d1\u05d9\u05e7,Mozambic,Mozambik,\u0e42\u0e21\u0e0b\u0e31\u0e21\u0e1a\u0e34\u0e01,Mozambique,Mozambique,Mo\u00e7ambic,Mozambik,M\u00f4-d\u0103m-b\u00edch".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.RW, "rw,\u76e7\u5b89\u9054,Rwanda,Rwanda,Ruanda,\u30eb\u30ef\u30f3\u30c0,Rwanda,Ruanda,Ruanda,Ruanda,Ruanda,Rwanda,Ruanda,Rwanda,Rwanda,\ub974\uc644\ub2e4,\u5362\u65fa\u8fbe,\u0420\u0443\u0430\u043d\u0434\u0430,Rwanda,Ruanda,\u0420\u0443\u0430\u043d\u0434\u0430,\u0631\u0648\u0627\u0646\u062f\u0627,Ruanda,Rwanda,\u03a1\u03bf\u03c5\u03ac\u03bd\u03c4\u03b1,\u05e8\u05d5\u05d0\u05e0\u05d3\u05d4,Rwanda,Rwanda,\u0e23\u0e27\u0e31\u0e19\u0e14\u0e32,Rwanda,Rwanda,Rwanda,Ruanda,Ru-an-\u0111a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.SC, "sc,\u585e\u5e2d\u723e,Seychelles,Seychelles,Seychellen,\u30bb\u30fc\u30b7\u30a7\u30eb,Seychellen,Seychelles,Seychelles,Seychelles,Seicheles,Seychellerne,Seychellit,Seychellene,Seychellerna,\uc250\uc774\uc258,\u585e\u820c\u5c14\u7fa4\u5c9b,\u0421\u0435\u0439\u0448\u0435\u042c\u044c\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430,Seszele,Sey\u015feller,\u0421\u0435\u0439\u0448\u0435\u042c\u0438,\u0633\u064a\u0634\u0644,Sej\u0161eli,Seychely,\u03a3\u03b5\u03cb\u03c7\u03ad\u03bb\u03bb\u03b5\u03c2,\u05d0\u05d9\u05d9 \u05e1\u05d9\u05d9\u05e9\u05dc,Seychelles,Seychelsk\u00e9 ostrovy,\u0e40\u0e0b\u0e40\u0e0a\u0e25\u0e2a\u0e4c,Seychelles,Seychelles,Seychelles,Seychelle-szigetek,X\u00e2y-sen".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.SO, "so,\u7d22\u99ac\u5229\u4e9e,Somalia,Somalie,Somalia,\u30bd\u30de\u30ea\u30a2,Somali\u00eb,Somalia,Somalia,Som\u00e1lia,Som\u00e1lia,Somalia,Somalia,Somalia,Somalia,\uc18c\ub9d0\ub9ac\uc544,\u7d22\u9a6c\u91cc,\u0421\u043e\u043c\u0430\u042c\u0438,Somalia,Somali,\u0421\u043e\u043c\u0430\u042c\u0456,\u0627\u0644\u0635\u0648\u0645\u0627\u0644,Somalija,Som\u00e1lsko,\u03a3\u03bf\u03bc\u03b1\u03bb\u03af\u03b1,\u05e1\u05d5\u05de\u05dc\u05d9\u05d4,Somalia,Som\u00e1lsko,\u0e42\u0e0b\u0e21\u0e32\u0e40\u0e25\u0e35\u0e22,Somalia,Somalia,Som\u00e0lia,Szom\u00e1lia,X\u00f4-ma-li".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.TZ, "tz,\u5766\u5c1a\u5c3c\u4e9e,Tanzania,Tanzanie,Tansania,\u30bf\u30f3\u30b6\u30cb\u30a2,Tanzania,Tanzania,Tanzania,Tanz\u00e2nia,Tanz\u00e2nia,Tanzania,Tansania,Tanzania,Tanzania,\ud0c4\uc790\ub2c8\uc544,\u5766\u6851\u5c3c\u4e9a,\u0422\u0430\u043d\u0437\u0430\u043d\u0438\u044f,Tanzania,Tanzanya,\u0422\u0430\u043d\u0437\u0430\u043d\u0456\u044f,\u062a\u0627\u0646\u0632\u0627\u0646\u064a\u0627,Tanzanija,Tanzanie,\u03a4\u03b1\u03bd\u03b6\u03b1\u03bd\u03af\u03b1,\u05d8\u05e0\u05d6\u05e0\u05d9\u05d4,Tanzania,Tanz\u00e1nia,\u0e41\u0e17\u0e19\u0e0b\u0e32\u0e40\u0e19\u0e35\u0e22,Tanzania,Tanzania,Tanz\u00e0nia,Tanz\u00e1nia,Tan-da-ni-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.UG, "ug,\u70cf\u5e72\u9054,Uganda,Ouganda,Uganda,\u30a6\u30ac\u30f3\u30c0,Oeganda,Uganda,Uganda,Uganda,Uganda,Uganda,Uganda,Uganda,Uganda,\uc6b0\uac04\ub2e4,\u4e4c\u5e72\u8fbe,\u0423\u0433\u0430\u043d\u0434\u0430,Uganda,Uganda,\u0423\u0433\u0430\u043d\u0434\u0430,\u0623\u0648\u063a\u0646\u062f\u0627,Uganda,Uganda,\u0390\u03c5\u03b3\u03ba\u03ac\u03bd\u03c4\u03b1,\u05d0\u05d5\u05d2\u05e0\u05d3\u05d4,Uganda,Uganda,\u0e22\u0e39\u0e01\u0e31\u0e19\u0e14\u0e32,Uganda,Uganda,Uganda,Uganda,U-gan-\u0111a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.ZM, "zm,\u5c1a\u6bd4\u4e9e,Zambia,Zambie,Sambia,\u30b6\u30f3\u30d3\u30a2,Zambia,Zambia,Zambia,Z\u00e2mbia,Z\u00e2mbia,Zambia,Sambia,Zambia,Zambia,\uc7a0\ube44\uc544,\u8d5e\u6bd4\u4e9a,\u0417\u0430\u043c\u0431\u0438\u044f,Zambia,Zambiya,\u0417\u0430\u043c\u0431\u0456\u044f,\u0632\u0627\u0645\u0628\u064a\u0627,Zambija,Zambie,\u0396\u03ac\u03bc\u03c0\u03b9\u03b1,\u05d6\u05de\u05d1\u05d9\u05d4,Zambia,Zambia,\u0e41\u0e0b\u0e21\u0e40\u0e1a\u0e35\u0e22,Zambia,Zambia,Z\u00e0mbia,Zambia,D\u0103m-bi-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.ZW, "zw,\u8f9b\u5df4\u5a01,Zimbabwe,Zimbabwe,Simbabwe,\u30b8\u30f3\u30d0\u30d6\u30a8,Zimbabwe,Zimbabwe,Zimbabue,Zimb\u00e1bue,Zimbabwe,Zimbabwe,Zimbabwe,Zimbabwe,Zimbabwe,\uc9d0\ubc14\ube0c\uc6e8,\u6d25\u5df4\u5e03\u97e6,\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435,Zimbabwe,Zimbabve,\u0417\u0456\u043c\u0431\u0430\u0431\u0432\u0435,\u0632\u064a\u0645\u0628\u0627\u0628\u0648\u064a,Zimbabve,Zimbabwe,\u0396\u03b9\u03bc\u03c0\u03ac\u03bc\u03c0\u03bf\u03c5\u03b5,\u05d6\u05d9\u05de\u05d1\u05d0\u05d1\u05d5\u05d5\u05d4,Zimbabwe,Zimbabwe,\u0e0b\u0e34\u0e21\u0e1a\u0e31\u0e1a\u0e40\u0e27,Zimbabwe,Zimbabwe,Zimbabwe,Zimbabwe,Dim-ba-bu-\u00ea".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.AO, "ao,\u5b89\u54e5\u62c9,Angola,Angola,Angola,\u30a2\u30f3\u30b4\u30e9,Angola,Angola,Angola,Angola,Angola,Angola,Angola,Angola,Angola,\uc559\uace8\ub77c,\u5b89\u54e5\u62c9,\u0410\u043d\u0433\u043e\u042c\u0430,Angola,Angola,\u0410\u043d\u0433\u043e\u042c\u0430,\u0623\u0646\u063a\u0648\u0644\u0627,Angola,Angola,\u0391\u03bd\u03b3\u03ba\u03cc\u03bb\u03b1,\u05d0\u05e0\u05d2\u05d5\u05dc\u05d4,Angola,Angola,\u0e41\u0e2d\u0e07\u0e42\u0e01\u0e25\u0e32,Angola,Angola,Angola,Angola,\u0102ng-g\u00f4-la".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.CD, "cd,\u525b\u679c\uff08\u91d1\u590f\u6c99\uff09,Congo - Kinshasa,R\u00e9publique d\u00e9mocratique du Congo,Demokratische Republik Kongo,\u30b3\u30f3\u30b4\u6c11\u4e3b\u5171\u548c\u56fd (\u30ad\u30f3\u30b7\u30e3\u30b5),Congo-Kinshasa,Repubblica Democratica del Congo,Rep\u00fablica Democr\u00e1tica del Congo,Congo-Kinshasa,Congo-Kinshasa,Congo-Kinshasa,Kongon demokraattinen tasavalta,Kongo-Kinshasa,Kongo-Kinshasa,\ucf69\uace0 \ubbfc\uc8fc\uacf5\ud654\uad6d,\u521a\u679c\uff08\u91d1\uff09,\u0414\u0435\u043c\u043e\u043a\u0440\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u042c\u0438\u043a\u0430 \u041a\u043e\u043d\u0433\u043e,Demokratyczna Republika Konga,Kongo - Kin\u015fasa,\u041a\u043e\u043d\u0491\u043e - \u041a\u0456\u043d\u0448\u0430\u0441\u0430,\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u0643\u0648\u0646\u063a\u0648 \u0627\u0644\u062f\u064a\u0645\u0642\u0631\u0627\u0637\u064a\u0629,Demokratska Republika Kongo,Demokratick\u00e1 republika Kongo,\u039a\u03bf\u03bd\u03b3\u03ba\u03cc - \u039a\u03b9\u03bd\u03c3\u03ac\u03c3\u03b1,\u05e7\u05d5\u05e0\u05d2\u05d5 - \u05e7\u05d9\u05e0\u05e9\u05d0\u05e1\u05d4,Republica Democrat\u0103 Congo,Kon\u017esk\u00e1 demokratick\u00e1 republika,\u0e04\u0e2d\u0e07\u0e42\u0e01-\u0e01\u0e34\u0e19\u0e0a\u0e32\u0e0b\u0e32,Republik Demokratik Kongo,Congo - Kinshasa,Congo - Kinshasa,Kong\u00f3 - Kinshasa,C\u1ed9ng ho\u00e0 d\u00e2n ch\u1ee7 C\u00f4ng\u00f4".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.CF, "cf,\u4e2d\u975e\u5171\u548c\u570b,Central African Republic,R\u00e9publique centrafricaine,Zentralafrikanische Republik,\u4e2d\u592e\u30a2\u30d5\u30ea\u30ab\u5171\u548c\u56fd,Centraal-Afrikaanse Republiek,Repubblica Centrafricana,Rep\u00fablica Centroafricana,Rep\u00fablica Centro-Africana,Rep\u00fablica Centro-Africana,Centralafrikanske Republik,Keski-Afrikan tasavalta,Den sentralafrikanske republikk,Centralafrikanska republiken,\uc911\uc559 \uc544\ud504\ub9ac\uce74 \uacf5\ud654\uad6d,\u4e2d\u975e\u5171\u548c\u56fd,\u0426\u0435\u043d\u0442\u0440\u0430\u042c\u044c\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u042c\u0438\u043a\u0430,Republika \u015arodkowoafryka\u0144ska,Orta Afrika Cumhuriyeti,\u0426\u0435\u043d\u0442\u0440\u0430\u042c\u044c\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u042c\u0456\u043a\u0430,\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0641\u0631\u064a\u0642\u064a\u0627 \u0627\u0644\u0648\u0633\u0637\u0649,Srednjoafri\u010dka Republika,St\u0159edoafrick\u00e1 republika,\u039a\u03b5\u03bd\u03c4\u03c1\u03bf\u03b1\u03c6\u03c1\u03b9\u03ba\u03b1\u03bd\u03b9\u03ba\u03ae \u0394\u03b7\u03bc\u03bf\u03ba\u03c1\u03b1\u03c4\u03af\u03b1,\u05d4\u05e8\u05e4\u05d5\u05d1\u05dc\u05d9\u05e7\u05d4 \u05e9\u05dc \u05de\u05e8\u05db\u05d6 \u05d0\u05e4\u05e8\u05d9\u05e7\u05d4,Republica Centrafrican\u0103,Stredoafrick\u00e1 republika,\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e01\u0e25\u0e32\u0e07,Republik Afrika Tengah,Central African Republic,Rep\u00fablica Centreafricana,K\u00f6z\u00e9p-afrikai K\u00f6zt\u00e1rsas\u00e1g,C\u1ed9ng h\u00f2a Trung Phi".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.CG, "cg,\u525b\u679c\uff08\u5e03\u62c9\u85a9\uff09,Republic of Congo,R\u00e9publique du Congo,Kongo-Brazzaville,\u30b3\u30f3\u30b4\u5171\u548c\u56fd (\u30d6\u30e9\u30b6\u30d3\u30eb),Congo,Congo,Congo - Brazzaville,Congo-Brazzaville,Congo-Brazzaville,Congo,Kongon tasavalta,Kongo-Brazzaville,Kongo-Brazzaville,\ucf69\uace0,\u521a\u679c\uff08\u5e03\uff09,\u041a\u043e\u043d\u0433\u043e,Kongo,Kongo - Brazavil,\u041a\u043e\u043d\u0491\u043e - \u0411\u0440\u0430\u0437\u0437\u0430\u0432\u0456\u042c\u044c,\u0627\u0644\u0643\u0648\u0646\u063a\u0648 - \u0628\u0631\u0627\u0632\u0627\u0641\u064a\u0644,Kongo - Brazzaville,Kongo,\u039a\u03bf\u03bd\u03b3\u03ba\u03cc - \u039c\u03c0\u03c1\u03b1\u03b6\u03b1\u03b2\u03af\u03bb,\u05e7\u05d5\u05e0\u05d2\u05d5 - \u05d1\u05e8\u05d6\u05d0\u05d5\u05d9\u05dc,Congo,Kongo,\u0e04\u0e2d\u0e07\u0e42\u0e01-\u0e1a\u0e23\u0e32\u0e0b\u0e0b\u0e32\u0e27\u0e34\u0e25,Kongo - Republik,Congo - Brazzaville,Congo - Brazzaville,Kong\u00f3 - Brazzaville,C\u00f4ng-g\u00f4".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.CM, "cm,\u5580\u9ea5\u9686,Cameroon,Cameroun,Kamerun,\u30ab\u30e1\u30eb\u30fc\u30f3,Kameroen,Camerun,Camer\u00fan,Rep\u00fablica dos Camar\u00f5es,Rep\u00fablica dos Camar\u00f5es,Cameroun,Kamerun,Kamerun,Kamerun,\uce74\uba54\ub8ec,\u5580\u9ea6\u9686,\u041a\u0430\u043c\u0435\u0440\u0443\u043d,Kamerun,Kamerun,\u041a\u0430\u043c\u0435\u0440\u0443\u043d,\u0627\u0644\u0643\u0627\u0645\u064a\u0631\u0648\u0646,Kamerun,Kamerun,\u039a\u03b1\u03bc\u03b5\u03c1\u03bf\u03cd\u03bd,\u05e7\u05de\u05e8\u05d5\u05df,Camerun,Kamerun,\u0e41\u0e04\u0e40\u0e21\u0e2d\u0e23\u0e39\u0e19,Kamerun,Cameroon,Camerun,Kamerun,Ca-m\u01a1-run".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.GA, "ga,\u52a0\u5f6d,Gabon,Gabon,Gabun,\u30ac\u30dc\u30f3,Gabon,Gabon,Gab\u00f3n,Gab\u00e3o,Gab\u00e3o,Gabon,Gabon,Gabon,Gabon,\uac00\ubd09,\u52a0\u84ec,\u0413\u0430\u0431\u043e\u043d,Gabon,Gabon,\u0413\u0430\u0431\u043e\u043d,\u0627\u0644\u062c\u0627\u0628\u0648\u0646,Gabon,Gabon,\u0393\u03ba\u03b1\u03bc\u03c0\u03cc\u03bd,\u05d2\u05d0\u05d1\u05d5\u05df,Gabon,Gabon,\u0e01\u0e32\u0e1a\u0e2d\u0e07,Gabon,Gabon,Gabon,Gabon,Ga-b\u00f4ng".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.GQ, "gq,\u8d64\u9053\u5e7e\u5167\u4e9e,Equatorial Guinea,Guin\u00e9e \u00e9quatoriale,\u00c4quatorialguinea,\u8d64\u9053\u30ae\u30cb\u30a2,Equatoriaal-Guinea,Guinea Equatoriale,Guinea Ecuatorial,Guin\u00e9 Equatorial,Guin\u00e9 Equatorial,\u00c6kvatorialguinea,P\u00e4iv\u00e4ntasaajan Guinea,Ekvatorial-Guinea,Ekvatorialguinea,\uc801\ub3c4 \uae30\ub2c8,\u8d64\u9053\u51e0\u5185\u4e9a,\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0430\u042c\u044c\u043d\u0430\u044f \u0413\u0432\u0438\u043d\u0435\u044f,Gwinea R\u00f3wnikowa,Ekvator Ginesi,\u0415\u043a\u0432\u0430\u0442\u043e\u0440\u0456\u0430\u042c\u044c\u043d\u0430 \u0413\u0432\u0456\u043d\u0435\u044f,\u063a\u064a\u0646\u064a\u0627 \u0627\u0644\u0627\u0633\u062a\u0648\u0627\u0626\u064a\u0629,Ekvatorska Gvineja,Rovn\u00edkov\u00e1 Guinea,\u0399\u03c3\u03b7\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1,\u05d2\u05d9\u05e0\u05d9\u05d0\u05d4 \u05d4\u05de\u05e9\u05d5\u05d5\u05e0\u05d9\u05ea,Guineea Ecuatorial\u0103,Rovn\u00edkov\u00e1 Guinea,\u0e2d\u0e34\u0e40\u0e04\u0e27\u0e17\u0e2d\u0e40\u0e23\u0e35\u0e22\u0e25\u0e01\u0e34\u0e19\u0e35,Guinea Khatulistiwa,Equatorial Guinea,Guinea Equatorial,Egyenl\u00edt\u0151i-Guinea,Ghi-n\u00ea X\u00edch-\u0111\u1ea1o".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.ST, "st,\u8056\u591a\u7f8e\u53ca\u666e\u6797\u897f\u6bd4,Sao Tome and Principe,Sao Tom\u00e9-et-Principe,S\u00e3o Tom\u00e9 und Pr\u00edncipe,\u30b5\u30f3\u30c8\u30e1\u30fb\u30d7\u30ea\u30f3\u30b7\u30da,Sao Tom\u00e9 en Principe,Sao Tom\u00e9 e Pr\u00edncipe,Santo Tom\u00e9 y Pr\u00edncipe,S\u00e3o Tom\u00e9 e Pr\u00edncipe,S\u00e3o Tom\u00e9 e Pr\u00edncipe,Sao Tome og Principe,S\u00e3o Tom\u00e9 ja Pr\u00edncipe,S\u00e3o Tom\u00e9 og Pr\u00edncipe,S\u00e3o Tom\u00e9 och Pr\u00edncipe,\uc0c1\ud22c\uba54 \ud504\ub9b0\uc2dc\ud398,\u5723\u591a\u7f8e\u548c\u666e\u6797\u897f\u6bd4,\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0438 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438,Wyspy \u015awi\u0119tego Tomasza i Ksi\u0105\u017c\u0119ca,Sao Tome ve Principe,\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0456 \u041f\u0440\u0456\u043d\u0441\u0456\u043f\u0456,\u0633\u0627\u0648 \u062a\u0648\u0645\u064a \u0648\u0628\u0631\u064a\u0646\u0633\u064a\u0628\u064a,Sveti Toma i Prinsipe,Svat\u00fd Tom\u00e1\u0161,\u03a3\u03ac\u03bf \u03a4\u03bf\u03bc\u03ad \u03ba\u03b1\u03b9 \u03a0\u03c1\u03af\u03bd\u03c3\u03b9\u03c0\u03b5,\u05e1\u05d0\u05d5 \u05d8\u05d5\u05de\u05d4 \u05d5\u05e4\u05e8\u05d9\u05e0\u05e1\u05d9\u05e4\u05d4,Sao Tome \u0219i Principe,Sv\u00e4t\u00fd Tom\u00e1\u0161 a Princove ostrovy,\u0e40\u0e0b\u0e32\u0e15\u0e39\u0e40\u0e21\u0e41\u0e25\u0e30\u0e1b\u0e23\u0e34\u0e19\u0e0b\u0e34\u0e1b\u0e35,Sao Tome dan Principe,S\u00e3o Tom\u00e9 and Pr\u00edncipe,S\u00e3o Tom\u00e9 i Pr\u00edncipe,Sao Tom\u00e9 \u00e9s Pr\u00edncipe,Xao T\u00f4-m\u00ea v\u00e0 Prin-xi-p\u00ea".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.TD, "td,\u67e5\u5fb7,Chad,Tchad,Tschad,\u30c1\u30e3\u30c9,Tsjaad,Ciad,Chad,Chade,Chade,Tchad,T\u0161ad,Tsjad,Tchad,\ucc28\ub4dc,\u4e4d\u5f97,\u0427\u0430\u0434,Czad,\u00c7ad,\u0427\u0430\u0434,\u062a\u0634\u0627\u062f,\u010cad,\u010cad,\u03a4\u03c3\u03b1\u03bd\u03c4,\u05e6\u05f3\u05d0\u05d3,Ciad,\u010cad,\u0e0a\u0e32\u0e14,Chad,Chad,Txad,Cs\u00e1d,S\u00e1t".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.DZ, "dz,\u963f\u723e\u53ca\u5229\u4e9e,Algeria,Alg\u00e9rie,Algerien,\u30a2\u30eb\u30b8\u30a7\u30ea\u30a2,Algerije,Algeria,Argelia,Arg\u00e9lia,Arg\u00e9lia,Algeriet,Algeria,Algerie,Algeriet,\uc54c\uc81c\ub9ac,\u963f\u5c14\u53ca\u5229\u4e9a,\u0410\u042c\u0436\u0438\u0440,Algieria,Cezayir,\u0410\u042c\u0436\u0438\u0440,\u0627\u0644\u062c\u0632\u0627\u0626\u0631,Al\u017eir,Al\u017e\u00edrsko,\u0391\u03bb\u03b3\u03b5\u03c1\u03af\u03b1,\u05d0\u05dc\u05d2\u05f3\u05d9\u05e8\u05d9\u05d4,Algeria,Al\u017e\u00edrsko,\u0e41\u0e2d\u0e25\u0e08\u0e35\u0e40\u0e23\u0e35\u0e22,Algeria,Algeria,Alg\u00e8ria,Alg\u00e9ria,An-gi\u00ea-ri".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.EG, "eg,\u57c3\u53ca,Egypt,\u00c9gypte,\u00c4gypten,\u30a8\u30b8\u30d7\u30c8,Egypte,Egitto,Egipto,Egito,Egipto,Egypten,Egypti,Egypt,Egypten,\uc774\uc9d1\ud2b8,\u57c3\u53ca,\u0415\u0433\u0438\u043f\u0435\u0442,Egipt,M\u0131s\u0131r,\u0404\u0433\u0438\u043f\u0435\u0442,\u0645\u0635\u0631,Egipat,Egypt,\u0391\u03af\u03b3\u03c5\u03c0\u03c4\u03bf\u03c2,\u05de\u05e6\u05e8\u05d9\u05dd,Egipt,Egypt,\u0e2d\u0e35\u0e22\u0e34\u0e1b\u0e15\u0e4c,Mesir,Egypt,Egipte,Egyiptom,Ai C\u1eadp".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.LY, "ly,\u5229\u6bd4\u4e9e,Libya,Libye,Libyen,\u30ea\u30d3\u30a2,Libi\u00eb,Libia,Libia,L\u00edbia,L\u00edbia,Libyen,Libya,Libya,Libyen,\ub9ac\ube44\uc544,\u5229\u6bd4\u4e9a,\u041b\u0438\u0432\u0438\u044f,Libia,Libya,\u041b\u0456\u0432\u0456\u044f,\u0644\u064a\u0628\u064a\u0627,Libija,Libye,\u039b\u03b9\u03b2\u03cd\u03b7,\u05dc\u05d5\u05d1,Libia,L\u00fdbijsk\u00e1 arabsk\u00e1 d\u017eamah\u00edrija,\u0e25\u0e34\u0e40\u0e1a\u0e35\u0e22,Libia,Libya,L\u00edbia,L\u00edbia,Li-bi".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.MA, "ma,\u6469\u6d1b\u54e5,Morocco,Maroc,Marokko,\u30e2\u30ed\u30c3\u30b3,Marokko,Marocco,Marruecos,Marrocos,Marrocos,Marokko,Marokko,Marokko,Marocko,\ubaa8\ub85c\ucf54,\u6469\u6d1b\u54e5,\u041c\u0430\u0440\u043e\u043a\u043a\u043e,Maroko,Fas,\u041c\u0430\u0440\u043e\u043a\u043a\u043e,\u0627\u0644\u0645\u063a\u0631\u0628,Maroko,Maroko,\u039c\u03b1\u03c1\u03cc\u03ba\u03bf,\u05de\u05e8\u05d5\u05e7\u05d5,Maroc,Maroko,\u0e42\u0e21\u0e23\u0e47\u0e2d\u0e01\u0e42\u0e01,Maroko,Morocco,Marroc,Marokk\u00f3,Ma-r\u1ed1c".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.SD, "sd,\u8607\u4e39,Sudan,Soudan,Sudan,\u30b9\u30fc\u30c0\u30f3,Soedan,Sudan,Sud\u00e1n,Sud\u00e3o,Sud\u00e3o,Sudan,Sudan,Sudan,Sudan,\uc218\ub2e8,\u82cf\u4e39,\u0421\u0443\u0434\u0430\u043d,Sudan,Sudan,\u0421\u0443\u0434\u0430\u043d,\u0627\u0644\u0633\u0648\u062f\u0627\u0646,Sudan,S\u00fad\u00e1n,\u03a3\u03bf\u03c5\u03b4\u03ac\u03bd,\u05e1\u05d5\u05d3\u05df,Sudan,Sud\u00e1n,\u0e0b\u0e39\u0e14\u0e32\u0e19,Sudan,Sudan,Sudan,Szud\u00e1n,Xu-\u0111\u0103ng".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.TN, "tn,\u7a81\u5c3c\u897f\u4e9e,Tunisia,Tunisie,Tunesien,\u30c1\u30e5\u30cb\u30b8\u30a2,Tunesi\u00eb,Tunisia,T\u00fanez,Tun\u00edsia,Tun\u00edsia,Tunesien,Tunisia,Tunisia,Tunisien,\ud280\ub2c8\uc9c0,\u7a81\u5c3c\u65af,\u0422\u0443\u043d\u0438\u0441,Tunezja,Tunus,\u0422\u0443\u043d\u0456\u0441,\u062a\u0648\u0646\u0633,Tunis,Tunisko,\u03a4\u03c5\u03bd\u03b7\u03c3\u03af\u03b1,\u05ea\u05d5\u05e0\u05d9\u05e1\u05d9\u05d4,Tunisia,Tunisko,\u0e15\u0e39\u0e19\u0e34\u0e40\u0e0b\u0e35\u0e22,Tunisia,Tunisia,Tun\u00edsia,Tun\u00e9zia,Tuy-ni-di".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.BW, "bw,\u6ce2\u672d\u90a3,Botswana,Botswana,Botsuana,\u30dc\u30c4\u30ef\u30ca,Botswana,Botswana,Botsuana,Botsuana,Botsuana,Botswana,Botswana,Botswana,Botswana,\ubcf4\uce20\uc640\ub098,\u535a\u8328\u74e6\u7eb3,\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0430,Botswana,Botsvana,\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0430,\u0628\u062a\u0633\u0648\u0627\u0646\u0627,Bocvana,Botswana,\u039c\u03c0\u03bf\u03c4\u03c3\u03bf\u03c5\u03ac\u03bd\u03b1,\u05d1\u05d5\u05d8\u05e1\u05d5\u05d5\u05d0\u05e0\u05d4,Botswana,Botswana,\u0e1a\u0e2d\u0e15\u0e2a\u0e27\u0e32\u0e19\u0e32,Botswana,Botswana,Botswana,Botswana,B\u1ed1t-xoa-na".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.LS, "ls,\u8cf4\u7d22\u6265,Lesotho,Lesotho,Lesotho,\u30ec\u30bd\u30c8,Lesotho,Lesotho,Lesoto,Lesoto,Lesoto,Lesotho,Lesotho,Lesotho,Lesotho,\ub808\uc18c\ud1a0,\u83b1\u7d22\u6258,\u041b\u0435\u0441\u043e\u0442\u043e,Lesotho,Lesoto,\u041b\u0435\u0441\u043e\u0442\u043e,\u0644\u064a\u0633\u0648\u062a\u0648,Lesoto,Lesotho,\u039b\u03b5\u03c3\u03cc\u03c4\u03bf,\u05dc\u05e1\u05d5\u05d8\u05d5,Lesotho,Lesotho,\u0e40\u0e25\u0e42\u0e0b\u0e42\u0e17,Lesotho,Lesotho,Lesotho,Lesotho,L\u00ea-x\u00f4-th\u00f4".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.NA, "na,\u7d0d\u7c73\u6bd4\u4e9e,Namibia,Namibie,Namibia,\u30ca\u30df\u30d3\u30a2,Namibi\u00eb,Namibia,Namibia,Nam\u00edbia,Nam\u00edbia,Namibia,Namibia,Namibia,Namibia,\ub098\ubbf8\ube44\uc544,\u7eb3\u7c73\u6bd4\u4e9a,\u041d\u0430\u043c\u0438\u0431\u0438\u044f,Namibia,Namibya,\u041d\u0430\u043c\u0456\u0431\u0456\u044f,\u0646\u0627\u0645\u064a\u0628\u064a\u0627,Namibija,Namibie,\u039d\u03b1\u03bc\u03af\u03bc\u03c0\u03b9\u03b1,\u05e0\u05de\u05d9\u05d1\u05d9\u05d4,Namibia,Nam\u00edbia,\u0e19\u0e32\u0e21\u0e34\u0e40\u0e1a\u0e35\u0e22,Namibia,Namibia,Nam\u00edbia,Nam\u00edbia,Nam-mi-bi-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.SZ, "sz,\u53f2\u74e6\u6fdf\u862d,Swaziland,Swaziland,Swasiland,\u30b9\u30ef\u30b8\u30e9\u30f3\u30c9,Swaziland,Swaziland,Suazilandia,Suazil\u00e2ndia,Suazil\u00e2ndia,Swaziland,Swazimaa,Swaziland,Swaziland,\uc2a4\uc640\uc9c8\ub79c\ub4dc,\u65af\u5a01\u58eb\u5170,\u0421\u0432\u0430\u0437\u0438\u042c\u0435\u043d\u0434,Suazi,Svaziland,\u0421\u0432\u0430\u0437\u0456\u042c\u0435\u043d\u0434,\u0633\u0648\u0627\u0632\u064a\u0644\u0627\u0646\u062f,Svazi,Svazijsko,\u0396\u03bf\u03c5\u03b1\u03b6\u03b7\u03bb\u03ac\u03bd\u03b4\u03b7,\u05e1\u05d5\u05d5\u05d6\u05d9\u05dc\u05e0\u05d3,Swaziland,Svazijsko,\u0e2a\u0e27\u0e32\u0e0b\u0e34\u0e41\u0e25\u0e19\u0e14\u0e4c,Swaziland,Swaziland,Swazil\u00e0ndia,Szv\u00e1zif\u00f6ld,Xoa-di-len".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.ZA, "za,\u5357\u975e,South Africa,Afrique du Sud,S\u00fcdafrika,\u5357\u30a2\u30d5\u30ea\u30ab,Zuid-Afrika,Sudafrica,Sud\u00e1frica,\u00c1frica do Sul,\u00c1frica do Sul,Sydafrika,Etel\u00e4-Afrikka,S\u00f8r-Afrika,Sydafrika,\ub0a8\uc544\ud504\ub9ac\uce74,\u5357\u975e,\u042e\u0410\u0420,Republika Po\u0142udniowej Afryki,G\u00fcney Afrika,\u041f\u0410\u0420,\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u062c\u0646\u0648\u0628 \u0627\u0641\u0631\u064a\u0642\u064a\u0627,Ju\u017enoafri\u010dka Republika,Jihoafrick\u00e1 republika,\u039d\u03cc\u03c4\u03b9\u03b1 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae,\u05d3\u05e8\u05d5\u05dd \u05d0\u05e4\u05e8\u05d9\u05e7\u05d4,Africa de Sud,Ju\u017en\u00e1 Afrika,\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e43\u0e15\u0e49,Afrika Selatan,South Africa,Rep\u00fablica de Sud-\u00e0frica,D\u00e9l-afrikai K\u00f6zt\u00e1rsas\u00e1g,Nam Phi".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.BF, "bf,\u5e03\u5409\u7d0d\u6cd5\u7d22,Burkina Faso,Burkina Faso,Burkina Faso,\u30d6\u30eb\u30ad\u30ca\u30d5\u30a1\u30bd,Burkina Faso,Burkina Faso,Burkina Faso,Burquina Faso,Burkina-Faso,Burkina Faso,Burkina Faso,Burkina Faso,Burkina Faso,\ubd80\ub974\ud0a4\ub098\ud30c\uc18c,\u5e03\u57fa\u7eb3\u6cd5\u7d22,\u0411\u0443\u0440\u043a\u0438\u043d\u0430 \u0424\u0430\u0441\u043e,Burkina Faso,Burkina Faso,\u0411\u0443\u0440\u043a\u0456\u043d\u0430-\u0424\u0430\u0441\u043e,\u0628\u0648\u0631\u0643\u064a\u0646\u0627 \u0641\u0627\u0633\u0648,Burkina Faso,Burkina Faso,\u039c\u03c0\u03bf\u03c5\u03c1\u03ba\u03af\u03bd\u03b1 \u03a6\u03ac\u03c3\u03bf,\u05d1\u05d5\u05e8\u05e7\u05d9\u05e0\u05d4 \u05e4\u05d0\u05e1\u05d5,Burkina Faso,Burkina Faso,\u0e1a\u0e39\u0e23\u0e4c\u0e01\u0e34\u0e19\u0e32\u0e1f\u0e32\u0e42\u0e0b,Burkina Faso,Burkina Faso,Burkina Faso,Burkina Faso,Bu\u1ed1c-ki-na Pha-x\u00f4".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.BJ, "bj,\u8c9d\u5357,Benin,B\u00e9nin,Benin,\u30d9\u30cb\u30f3,Benin,Benin,Ben\u00edn,Benin,Benim,Benin,Benin,Benin,Benin,\ubca0\ub0c9,\u8d1d\u5b81,\u0411\u0435\u043d\u0438\u043d,Benin,Benin,\u0411\u0435\u043d\u0456\u043d,\u0628\u0646\u064a\u0646,Benin,Benin,\u039c\u03c0\u03b5\u03bd\u03af\u03bd,\u05d1\u05e0\u05d9\u05df,Benin,Benin,\u0e40\u0e1a\u0e19\u0e34\u0e19,Benin,Benin,Ben\u00edn,Benin,B\u00ea-nanh".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.CI, "ci,\u79d1\u7279\u8fea\u74e6,Ivory Coast,C\u00f4te d\u2019Ivoire,C\u00f4te d\u2019Ivoire,\u30b3\u30fc\u30c8\u30b8\u30dc\u30ef\u30fc\u30eb,Ivoorkust,Costa d\u2019Avorio,Costa de Marfil,Costa do Marfim,Costa do Marfim,Elfenbenskysten,Norsunluurannikko,Elfenbenskysten,Elfenbenskusten,\ucf54\ud2b8\ub514\ubd80\uc544\ub974,\u8c61\u7259\u6d77\u5cb8,\u041a\u043e\u0442 \u0434\u2019\u0418\u0432\u0443\u0430\u0440,Wybrze\u017ce Ko\u015bci S\u0142oniowej,Fildi\u015fi Sahili,\u041a\u043e\u0442 \u0434\u2019\u0406\u0432\u0443\u0430\u0440,\u0633\u0627\u062d\u0644 \u0627\u0644\u0639\u0627\u062c,Obala Bjelokosti,Pob\u0159e\u017e\u00ed slonoviny,\u0391\u03ba\u03c4\u03ae \u0395\u03bb\u03b5\u03c6\u03b1\u03bd\u03c4\u03bf\u03c3\u03c4\u03bf\u03cd,\u05d7\u05d5\u05e3 \u05d4\u05e9\u05e0\u05d4\u05d1,Coasta de Filde\u0219,Pobre\u017eie Slonoviny,\u0e44\u0e2d\u0e27\u0e2d\u0e23\u0e35\u0e48\u0e42\u0e04\u0e2a\u0e15\u0e4c,Cote d'Ivoire,C\u00f4te d\u2019Ivoire,Costa d\u2019Ivori,Elef\u00e1ntcsontpart,B\u1edd Bi\u1ec3n Ng\u00e0".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.CV, "cv,\u7dad\u5fb7\u89d2,Cape Verde,Cap-Vert,Kap Verde,\u30ab\u30fc\u30dc\u30d9\u30eb\u30c7,Kaapverdi\u00eb,Capo Verde,Cabo Verde,Cabo Verde,Cabo Verde,Kap Verde,Kap Verde,Kapp Verde,Kap Verde,\uae4c\ubf40\ubca0\ub974\ub370,\u4f5b\u5f97\u89d2,\u041e\u0441\u0442\u0440\u043e\u0432\u0430 \u0417\u0435\u042c\u0435\u043d\u043e\u0433\u043e \u041c\u044b\u0441\u0430,Republika Zielonego Przyl\u0105dka,Cape Verde,\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435,\u0627\u0644\u0631\u0623\u0633 \u0627\u0644\u0623\u062e\u0636\u0631,Zeleni Rt,Kapverdy,\u03a0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf \u0391\u03ba\u03c1\u03c9\u03c4\u03ae\u03c1\u03b9\u03bf,\u05db\u05e3 \u05d5\u05e8\u05d3\u05d4,Capul Verde,Kapverdy,\u0e40\u0e04\u0e1b\u0e40\u0e27\u0e34\u0e23\u0e4c\u0e14,Tanjung Verde,Cape Verde,Cap Verd,Z\u00f6ld-foki K\u00f6zt\u00e1rsas\u00e1g,C\u00e1p-ve".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.GM, "gm,\u7518\u6bd4\u4e9e,Gambia,Gambie,Gambia,\u30ac\u30f3\u30d3\u30a2,Gambia,Gambia,Gambia,G\u00e2mbia,G\u00e2mbia,Gambia,Gambia,Gambia,Gambia,\uac10\ube44\uc544,\u5188\u6bd4\u4e9a,\u0413\u0430\u043c\u0431\u0438\u044f,Gambia,Gambiya,\u0413\u0430\u043c\u0431\u0456\u044f,\u063a\u0627\u0645\u0628\u064a\u0627,Gambija,Gambie,\u0393\u03ba\u03ac\u03bc\u03c0\u03b9\u03b1,\u05d2\u05de\u05d1\u05d9\u05d4,Gambia,Gambia,\u0e41\u0e01\u0e21\u0e40\u0e1a\u0e35\u0e22,Gambia,Gambia,G\u00e0mbia,Gambia,G\u0103m-bi-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.GN, "gn,\u5e7e\u5167\u4e9e,Guinea,Guin\u00e9e,Guinea,\u30ae\u30cb\u30a2,Guinee,Guinea,Guinea,Guin\u00e9,Guin\u00e9,Guinea,Guinea,Guinea,Guinea,\uae30\ub2c8,\u51e0\u5185\u4e9a,\u0413\u0432\u0438\u043d\u0435\u044f,Gwinea,Gine,\u0413\u0432\u0456\u043d\u0435\u044f,\u063a\u064a\u0646\u064a\u0627,Gvineja,Guinea,\u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1,\u05d2\u05d9\u05e0\u05d9\u05d0\u05d4,Guineea,Guinea,\u0e01\u0e34\u0e19\u0e35,Guinea,Guinea,Guinea,Guinea,Ghi-n\u00ea".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.GW, "gw,\u5e7e\u5167\u4e9e\u6bd4\u7d22,Guinea-Bissau,Guin\u00e9e-Bissau,Guinea-Bissau,\u30ae\u30cb\u30a2\u30d3\u30b5\u30a6,Guinee-Bissau,Guinea-Bissau,Guinea-Bissau,Guin\u00e9 Bissau,Guin\u00e9-Bissau,Guinea-Bissau,Guinea-Bissau,Guinea-Bissau,Guinea-Bissau,\uae30\ub124\ube44\uc3d8,\u51e0\u5185\u4e9a\u6bd4\u7ecd,\u0413\u0432\u0438\u043d\u0435\u044f-\u0411\u0438\u0441\u0430\u0443,Gwinea Bissau,Gine-Bissau,\u0413\u0432\u0456\u043d\u0435\u044f-\u0411\u0456\u0441\u0441\u0430\u0443,\u063a\u064a\u0646\u064a\u0627 \u0628\u064a\u0633\u0627\u0648,Gvineja Bisau,Guinea-Bissau,\u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1-\u039c\u03c0\u03b9\u03c3\u03ac\u03bf\u03c5,\u05d2\u05d9\u05e0\u05d9\u05d0\u05d4-\u05d1\u05d9\u05e1\u05d0\u05d5,Guineea-Bissau,Guinea-Bissau,\u0e01\u0e34\u0e19\u0e35-\u0e1a\u0e34\u0e2a\u0e40\u0e0b\u0e32,Guinea-Bissau,Guinea-Bissau,Guinea Bissau,Guinea-Bissau,Ghi-n\u00ea B\u00edt-xao".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.LR, "lr,\u8cf4\u6bd4\u745e\u4e9e,Liberia,Lib\u00e9ria,Liberia,\u30ea\u30d9\u30ea\u30a2,Liberia,Liberia,Liberia,Lib\u00e9ria,Lib\u00e9ria,Liberia,Liberia,Liberia,Liberia,\ub77c\uc774\ubca0\ub9ac\uc544,\u5229\u6bd4\u91cc\u4e9a,\u041b\u0438\u0431\u0435\u0440\u0438\u044f,Liberia,Liberya,\u041b\u0456\u0431\u0435\u0440\u0456\u044f,\u0644\u064a\u0628\u064a\u0631\u064a\u0627,Liberija,Lib\u00e9rie,\u039b\u03b9\u03b2\u03b5\u03c1\u03af\u03b1,\u05dc\u05d9\u05d1\u05e8\u05d9\u05d4,Liberia,Lib\u00e9ria,\u0e44\u0e25\u0e1a\u0e35\u0e40\u0e23\u0e35\u0e22,Liberia,Liberia,Lib\u00e8ria,Lib\u00e9ria,Li-b\u00ea-ri-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.ML, "ml,\u99ac\u5229,Mali,Mali,Mali,\u30de\u30ea,Mali,Mali,Mali,Mali,Mali,Mali,Mali,Mali,Mali,\ub9d0\ub9ac,\u9a6c\u91cc,\u041c\u0430\u042c\u0438,Mali,Mali,\u041c\u0430\u042c\u0456,\u0645\u0627\u0644\u064a,Mali,Mali,\u039c\u03ac\u03bb\u03b9,\u05de\u05d0\u05dc\u05d9,Mali,Mali,\u0e21\u0e32\u0e25\u0e35,Mali,Mali,Mali,Mali,Ma-li".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.MR, "mr,\u8305\u5229\u5854\u5c3c\u4e9e,Mauritania,Mauritanie,Mauretanien,\u30e2\u30fc\u30ea\u30bf\u30cb\u30a2,Mauritani\u00eb,Mauritania,Mauritania,Maurit\u00e2nia,Maurit\u00e2nia,Mauretanien,Mauritania,Mauritania,Mauretanien,\ubaa8\ub9ac\ud0c0\ub2c8,\u6bdb\u91cc\u5854\u5c3c\u4e9a,\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438\u044f,Mauretania,Moritanya,\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0456\u044f,\u0645\u0648\u0631\u064a\u062a\u0627\u0646\u064a\u0627,Mauritanija,Maurit\u00e1nie,\u039c\u03b1\u03c5\u03c1\u03b9\u03c4\u03b1\u03bd\u03af\u03b1,\u05de\u05d0\u05d5\u05e8\u05d9\u05d8\u05e0\u05d9\u05d4,Mauritania,Maurit\u00e1nia,\u0e21\u0e2d\u0e23\u0e34\u0e40\u0e15\u0e40\u0e19\u0e35\u0e22,Mauritania,Mauritania,Maurit\u00e0nia,Maurit\u00e1nia,M\u00f4-ri-ta-ni".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.NE, "ne,\u5c3c\u65e5,Niger,Niger,Niger,\u30cb\u30b8\u30a7\u30fc\u30eb,Niger,Niger,N\u00edger,N\u00edger,N\u00edger,Niger,Niger,Niger,Niger,\ub2c8\uc81c\ub974,\u5c3c\u65e5\u5c14,\u041d\u0438\u0433\u0435\u0440,Niger,Nijer,\u041d\u0456\u0433\u0435\u0440,\u0627\u0644\u0646\u064a\u062c\u0631,Niger,Niger,\u039d\u03af\u03b3\u03b7\u03c1\u03b1\u03c2,\u05e0\u05d9\u05d6\u05f3\u05e8,Niger,Niger,\u0e44\u0e19\u0e40\u0e08\u0e2d\u0e23\u0e4c,Niger,Niger,N\u00edger,Niger,Ni-gi\u00ea".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.NG, "ng,\u5948\u53ca\u5229\u4e9e,Nigeria,Nig\u00e9ria,Nigeria,\u30ca\u30a4\u30b8\u30a7\u30ea\u30a2,Nigeria,Nigeria,Nigeria,Nig\u00e9ria,Nig\u00e9ria,Nigeria,Nigeria,Nigeria,Nigeria,\ub098\uc774\uc9c0\ub9ac\uc544,\u5c3c\u65e5\u5229\u4e9a,\u041d\u0438\u0433\u0435\u0440\u0438\u044f,Nigeria,Nijerya,\u041d\u0456\u0433\u0435\u0440\u0456\u044f,\u0646\u064a\u062c\u064a\u0631\u064a\u0627,Nigerija,Nig\u00e9rie,\u039d\u03b9\u03b3\u03b7\u03c1\u03af\u03b1,\u05e0\u05d9\u05d2\u05e8\u05d9\u05d4,Nigeria,Nig\u00e9ria,\u0e44\u0e19\u0e08\u0e35\u0e40\u0e23\u0e35\u0e22,Nigeria,Nigeria,Nig\u00e8ria,Nig\u00e9ria,Ni-gi\u00ea-ri-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.SH, "sh,\u8056\u8d6b\u52d2\u62ff\u5cf6,Saint Helena,Sainte-H\u00e9l\u00e8ne,St. Helena,\u30bb\u30f3\u30c8\u30d8\u30ec\u30ca,Sint-Helena,Sant\u2019Elena,Santa Elena,Santa Helena,Santa Helena,St. Helena,Saint Helena,St. Helena,S:t Helena,\uc138\uc778\ud2b8\ud5ec\ub808\ub098,\u5723\u8d6b\u52d2\u62ff,\u041e\u0441\u0442\u0440\u043e\u0432 \u0421\u0432\u044f\u0442\u043e\u0439 \u0415\u042c\u0435\u043d\u044b,Wyspa \u015awi\u0119tej Heleny,Saint Helena,\u041e\u0441\u0442\u0440\u0456\u0432 \u0421\u0432\u044f\u0442\u043e\u0457 \u0404\u042c\u0435\u043d\u0438,\u0633\u0627\u0646\u062a \u0647\u064a\u0644\u0646\u0627,Sveta Helena,Svat\u00e1 Helena,\u0391\u03b3\u03af\u03b1 \u0395\u03bb\u03ad\u03bd\u03b7,\u05e1\u05e0\u05d8 \u05d4\u05dc\u05e0\u05d4,Sf\u00e2nta Elena,Sv\u00e4t\u00e1 Helena,\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e40\u0e2e\u0e40\u0e25\u0e19\u0e32,Saint Helena,Saint Helena,Saint Helena,Szent Helena,Saint Helena".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.SL, "sl,\u7345\u5b50\u5c71,Sierra Leone,Sierra Leone,Sierra Leone,\u30b7\u30a8\u30e9\u30ec\u30aa\u30cd,Sierra Leone,Sierra Leone,Sierra Leona,Serra Leoa,Serra Leoa,Sierra Leone,Sierra Leone,Sierra Leone,Sierra Leone,\uc2dc\uc5d0\ub77c\ub9ac\uc628,\u585e\u62c9\u5229\u6602,\u0421\u044c\u0435\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435,Sierra Leone,Sierra Leone,\u0421\u044c\u0454\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435,\u0633\u064a\u0631\u0627\u0644\u064a\u0648\u0646,Sijera Leone,Sierra Leone,\u03a3\u03b9\u03ad\u03c1\u03b1 \u039b\u03b5\u03cc\u03bd\u03b5,\u05e1\u05d9\u05d9\u05e8\u05d4 \u05dc\u05d0\u05d5\u05e0\u05d4,Sierra Leone,Sierra Leone,\u0e40\u0e0b\u0e35\u0e22\u0e23\u0e4c\u0e23\u0e32\u0e25\u0e35\u0e42\u0e2d\u0e19,Sierra Leone,Sierra Leone,Sierra Leone,Sierra Leone,Xi-\u00ea-ra L\u00ea-\u00f4n".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.SN, "sn,\u585e\u5167\u52a0\u723e,Senegal,S\u00e9n\u00e9gal,Senegal,\u30bb\u30cd\u30ac\u30eb,Senegal,Senegal,Senegal,Senegal,Senegal,Senegal,Senegal,Senegal,Senegal,\uc138\ub124\uac08,\u585e\u5185\u52a0\u5c14,\u0421\u0435\u043d\u0435\u0433\u0430\u042c,Senegal,Senegal,\u0421\u0435\u043d\u0435\u0433\u0430\u042c,\u0627\u0644\u0633\u0646\u063a\u0627\u0644,Senegal,Senegal,\u03a3\u03b5\u03bd\u03b5\u03b3\u03ac\u03bb\u03b7,\u05e1\u05e0\u05d2\u05dc,Senegal,Senegal,\u0e40\u0e0b\u0e40\u0e19\u0e01\u0e31\u0e25,Senegal,Senegal,Senegal,Szeneg\u00e1l,X\u00ea-n\u00ea-gan".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.TG, "tg,\u591a\u54e5\u5171\u548c\u570b,Togo,Togo,Togo,\u30c8\u30fc\u30b4,Togo,Togo,Togo,Togo,Togo,Togo,Togo,Togo,Togo,\ud1a0\uace0,\u591a\u54e5,\u0422\u043e\u0433\u043e,Togo,Togo,\u0422\u043e\u0433\u043e,\u062a\u0648\u062c\u0648,Togo,Togo,\u03a4\u03cc\u03b3\u03ba\u03bf,\u05d8\u05d5\u05d2\u05d5,Togo,Togo,\u0e42\u0e15\u0e42\u0e01,Togo,Togo,Togo,Togo,T\u00f4-g\u00f4".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.BZ, "bz,\u8c9d\u91cc\u65af,Belize,Belize,Belize,\u30d9\u30ea\u30fc\u30ba,Belize,Belize,Belice,Belize,Belize,Belize,Belize,Belize,Belize,\ubca8\ub9ac\uc988,\u4f2f\u5229\u5179,\u0411\u0435\u042c\u0438\u0437,Belize,Belize,\u0411\u0435\u042c\u0456\u0437,\u0628\u0644\u064a\u0632,Belize,Belize,\u039c\u03c0\u03b5\u03bb\u03af\u03c3\u03b5,\u05d1\u05dc\u05d9\u05d6,Belize,Belize,\u0e40\u0e1a\u0e25\u0e35\u0e0b,Belize,Belize,Belize,Belize,B\u00ea-li-x\u00ea".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.CR, "cr,\u54e5\u65af\u5927\u9ece\u52a0,Costa Rica,Costa Rica,Costa Rica,\u30b3\u30b9\u30bf\u30ea\u30ab,Costa Rica,Costa Rica,Costa Rica,Costa Rica,Costa Rica,Costa Rica,Costa Rica,Costa Rica,Costa Rica,\ucf54\uc2a4\ud0c0\ub9ac\uce74,\u54e5\u65af\u8fbe\u9ece\u52a0,\u041a\u043e\u0441\u0442\u0430-\u0420\u0438\u043a\u0430,Kostaryka,Kosta Rika,\u041a\u043e\u0441\u0442\u0430-\u0420\u0438\u043a\u0430,\u0643\u0648\u0633\u062a\u0627\u0631\u064a\u0643\u0627,Kostarika,Kostarika,\u039a\u03cc\u03c3\u03c4\u03b1 \u03a1\u03af\u03ba\u03b1,\u05e7\u05d5\u05e1\u05d8\u05d4 \u05e8\u05d9\u05e7\u05d4,Costa Rica,Kostarika,\u0e04\u0e2d\u0e2a\u0e15\u0e32\u0e23\u0e34\u0e01\u0e32,Kosta Rika,Costa Rica,Costa Rica,Costa Rica,C\u1ed1t-xta Ri-ca".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.GT, "gt,\u74dc\u5730\u99ac\u62c9,Guatemala,Guatemala,Guatemala,\u30b0\u30a2\u30c6\u30de\u30e9,Guatemala,Guatemala,Guatemala,Guatemala,Guatemala,Guatemala,Guatemala,Guatemala,Guatemala,\uacfc\ud14c\ub9d0\ub77c,\u5371\u5730\u9a6c\u62c9,\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u042c\u0430,Gwatemala,Guatemala,\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u042c\u0430,\u062c\u0648\u0627\u062a\u064a\u0645\u0627\u0644\u0627,Gvatemala,Guatemala,\u0393\u03bf\u03c5\u03b1\u03c4\u03b5\u03bc\u03ac\u03bb\u03b1,\u05d2\u05d5\u05d0\u05d8\u05de\u05dc\u05d4,Guatemala,Guatemala,\u0e01\u0e31\u0e27\u0e40\u0e15\u0e21\u0e32\u0e25\u0e32,Guatemala,Guatemala,Guatemala,Guatemala,Goa-t\u00ea-ma-la".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.HN, "hn,\u5b8f\u90fd\u62c9\u65af,Honduras,Honduras,Honduras,\u30db\u30f3\u30b8\u30e5\u30e9\u30b9,Honduras,Honduras,Honduras,Honduras,Honduras,Honduras,Honduras,Honduras,Honduras,\uc628\ub450\ub77c\uc2a4,\u6d2a\u90fd\u62c9\u65af,\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441,Honduras,Honduras,\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441,\u0647\u0646\u062f\u0648\u0631\u0627\u0633,Honduras,Honduras,\u0390\u03bd\u03b4\u03bf\u03cd\u03c1\u03b1,\u05d4\u05d5\u05e0\u05d3\u05d5\u05e8\u05e1,Honduras,Honduras,\u0e2e\u0e2d\u0e19\u0e14\u0e39\u0e23\u0e31\u0e2a,Honduras,Honduras,Hondures,Honduras,H\u00f4n-\u0111u-r\u00e1t".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.MX, "mx,\u58a8\u897f\u54e5,Mexico,Mexique,Mexiko,\u30e1\u30ad\u30b7\u30b3,Mexico,Messico,M\u00e9xico,M\u00e9xico,M\u00e9xico,Mexico,Meksiko,Mexico,Mexiko,\uba55\uc2dc\ucf54,\u58a8\u897f\u54e5,\u041c\u0435\u043a\u0441\u0438\u043a\u0430,Meksyk,Meksika,\u041c\u0435\u043a\u0441\u0438\u043a\u0430,\u0627\u0644\u0645\u0643\u0633\u064a\u0643,Meksiko,Mexiko,\u039c\u03b5\u03be\u03b9\u03ba\u03cc,\u05de\u05e7\u05e1\u05d9\u05e7\u05d5,Mexic,Mexiko,\u0e40\u0e21\u0e47\u0e01\u0e0b\u0e34\u0e42\u0e01,Mexico,Mexico,M\u00e8xic,Mexik\u00f3,M\u00ea-hi-c\u00f4".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.NI, "ni,\u5c3c\u52a0\u62c9\u74dc,Nicaragua,Nicaragua,Nicaragua,\u30cb\u30ab\u30e9\u30b0\u30a2,Nicaragua,Nicaragua,Nicaragua,Nicar\u00e1gua,Nicar\u00e1gua,Nicaragua,Nicaragua,Nicaragua,Nicaragua,\ub2c8\uce74\ub77c\uacfc,\u5c3c\u52a0\u62c9\u74dc,\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430,Nikaragua,Nikaragua,\u041d\u0456\u043a\u0430\u0440\u0430\u0433\u0443\u0430,\u0646\u064a\u0643\u0627\u0631\u0627\u063a\u0648\u0627,Nikaragva,Nikaragua,\u039d\u03b9\u03ba\u03b1\u03c1\u03ac\u03b3\u03bf\u03c5\u03b1,\u05e0\u05d9\u05e7\u05e8\u05d2\u05d5\u05d0\u05d4,Nicaragua,Nikaragua,\u0e19\u0e34\u0e01\u0e32\u0e23\u0e32\u0e01\u0e31\u0e27,Nikaragua,Nicaragua,Nicaragua,Nicaragua,Ni-ca-ra-goa".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.PA, "pa,\u5df4\u62ff\u99ac,Panama,Panama,Panama,\u30d1\u30ca\u30de,Panama,Panama,Panam\u00e1,Panam\u00e1,Panam\u00e1,Panama,Panama,Panama,Panama,\ud30c\ub098\ub9c8,\u5df4\u62ff\u9a6c,\u041f\u0430\u043d\u0430\u043c\u0430,Panama,Panama,\u041f\u0430\u043d\u0430\u043c\u0430,\u0628\u0646\u0645\u0627,Panama,Panama,\u03a0\u03b1\u03bd\u03b1\u03bc\u03ac\u03c2,\u05e4\u05e0\u05de\u05d4,Panama,Panama,\u0e1b\u0e32\u0e19\u0e32\u0e21\u0e32,Panama,Panama,Panam\u00e0,Panama,Pa-na-ma".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.SV, "sv,\u85a9\u723e\u74e6\u591a,El Salvador,El Salvador,El Salvador,\u30a8\u30eb\u30b5\u30eb\u30d0\u30c9\u30eb,El Salvador,El Salvador,El Salvador,El Salvador,El Salvador,El Salvador,El Salvador,El Salvador,El Salvador,\uc5d8\uc0b4\ubc14\ub3c4\ub974,\u8428\u5c14\u74e6\u591a,\u0421\u0430\u042c\u044c\u0432\u0430\u0434\u043e\u0440,Salwador,El Salvador,\u0421\u0430\u042c\u044c\u0432\u0430\u0434\u043e\u0440,\u0627\u0644\u0633\u0644\u0641\u0627\u062f\u0648\u0631,El Salvador,El Salvador,\u0395\u03bb \u03a3\u03b1\u03bb\u03b2\u03b1\u03b4\u03cc\u03c1,\u05d0\u05dc \u05e1\u05dc\u05d1\u05d3\u05d5\u05e8,El Salvador,Salvador,\u0e40\u0e2d\u0e25\u0e0b\u0e31\u0e25\u0e27\u0e32\u0e14\u0e2d\u0e23\u0e4c,El Salvador,El Salvador,El Salvador,Salvador,En-san-va-\u0111o".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.BM, "bm,\u767e\u6155\u9054,Bermuda,Bermudes,Bermuda,\u30d0\u30df\u30e5\u30fc\u30c0,Bermuda,Bermuda,Bermudas,Bermudas,Bermudas,Bermuda,Bermuda,Bermuda,Bermuda,\ubc84\ubba4\ub2e4,\u767e\u6155\u5927,\u0411\u0435\u0440\u043c\u0443\u0434\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430,Bermudy,Bermuda,\u0411\u0435\u0440\u043c\u0443\u0434\u0438,\u0628\u0631\u0645\u0648\u062f\u0627,Bermuda,Bermudy,\u0392\u03b5\u03c1\u03bc\u03bf\u03cd\u03b4\u03b5\u03c2,\u05d1\u05e8\u05de\u05d5\u05d3\u05d4,Bermuda,Bermudy,\u0e40\u0e1a\u0e2d\u0e23\u0e4c\u0e21\u0e34\u0e27\u0e14\u0e32,Bermuda,Bermuda,Bermudes,Bermuda,\u767e\u6155\u9054".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.CA, "ca,\u52a0\u62ff\u5927,Canada,Canada,Kanada,\u30ab\u30ca\u30c0,Canada,Canada,Canad\u00e1,Canad\u00e1,Canad\u00e1,Canada,Kanada,Canada,Kanada,\uce90\ub098\ub2e4,\u52a0\u62ff\u5927,\u041a\u0430\u043d\u0430\u0434\u0430,Kanada,Kanada,\u041a\u0430\u043d\u0430\u0434\u0430,\u0643\u0646\u062f\u0627,Kanada,Kanada,\u039a\u03b1\u03bd\u03b1\u03b4\u03ac\u03c2,\u05e7\u05e0\u05d3\u05d4,Canada,Kanada,\u0e41\u0e04\u0e19\u0e32\u0e14\u0e32,Kanada,Canada,Canad\u00e0,Kanada,Ca-na-\u0111a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.GL, "gl,\u683c\u9675\u862d,Greenland,Groenland,Gr\u00f6nland,\u30b0\u30ea\u30fc\u30f3\u30e9\u30f3\u30c9,Groenland,Groenlandia,Groenlandia,Gro\u00eanlandia,Gronel\u00e2ndia,Gr\u00f8nland,Gr\u00f6nlanti,Gr\u00f8nland,Gr\u00f6nland,\uadf8\ub9b0\ub780\ub4dc,\u683c\u9675\u5170,\u0413\u0440\u0435\u043d\u042c\u0430\u043d\u0434\u0438\u044f,Grenlandia,Gr\u00f6nland,\u0413\u0440\u0435\u043d\u042c\u0430\u043d\u0434\u0456\u044f,\u063a\u0631\u064a\u0646\u0644\u0627\u0646\u062f,Grenland,Gr\u00f3nsko,\u0393\u03c1\u03bf\u03b9\u03bb\u03b1\u03bd\u03b4\u03af\u03b1,\u05d2\u05e8\u05d9\u05e0\u05dc\u05e0\u05d3,Groenlanda,Gr\u00f3nsko,\u0e01\u0e23\u0e35\u0e19\u0e41\u0e25\u0e19\u0e14\u0e4c,Grinlandia,Greenland,Grenl\u00e0ndia,Gr\u00f6nland,B\u0103ng \u0110\u1ea3o".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.US, "us,\u7f8e\u570b,United States,\u00c9tats-Unis,USA,\u30a2\u30e1\u30ea\u30ab\u5408\u8846\u56fd,Verenigde Staten,Stati Uniti d'America,Estados Unidos,Estados Unidos,Estados Unidos,USA,Yhdysvallat,USA,USA,\ubbf8\uad6d,\u7f8e\u56fd,\u0421\u0428\u0410,Stany Zjednoczone,Amerika Birle\u015fik Devletleri,\u0421\u0428\u0410,\u0627\u0644\u0648\u0644\u0627\u064a\u0627\u062a \u0627\u0644\u0645\u062a\u062d\u062f\u0629 \u0627\u0644\u0623\u0645\u0631\u064a\u0643\u064a\u0629,Sjedinjene Dr\u017eave,Spojen\u00e9 st\u00e1ty,\u0397\u03bd\u03c9\u03bc\u03ad\u03bd\u03b5\u03c2 \u03a0\u03bf\u03bb\u03b9\u03c4\u03b5\u03af\u03b5\u03c2 \u03c4\u03b7\u03c2 \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae\u03c2,\u05d0\u05e8\u05e6\u05d5\u05ea \u05d4\u05d1\u05e8\u05d9\u05ea,Statele Unite ale Americii,Spojen\u00e9 \u0161t\u00e1ty,\u0e2a\u0e2b\u0e23\u0e31\u0e10\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32,Amerika Serikat,United States,Estats Units,Egyes\u00fclt \u00c1llamok,Hoa K\u1ef3".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.AR, "ar,\u963f\u6839\u5ef7,Argentina,Argentine,Argentinien,\u30a2\u30eb\u30bc\u30f3\u30c1\u30f3,Argentini\u00eb,Argentina,Argentina,Argentina,Argentina,Argentina,Argentiina,Argentina,Argentina,\uc544\ub974\ud5e8\ud2f0\ub098,\u963f\u6839\u5ef7,\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430,Argentyna,Arjantin,\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430,\u0627\u0644\u0623\u0631\u062c\u0646\u062a\u064a\u0646,Argentina,Argentina,\u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae,\u05d0\u05e8\u05d2\u05e0\u05d8\u05d9\u05e0\u05d4,Argentina,Argent\u00edna,\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e08\u0e19\u0e15\u0e34\u0e19\u0e32,Argentina,Argentina,Argentina,Argent\u00edna,\u00c1c-hen-ti-na".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.BO, "bo,\u73bb\u5229\u7dad\u4e9e,Bolivia,Bolivie,Bolivien,\u30dc\u30ea\u30d3\u30a2,Bolivia,Bolivia,Bolivia,Bol\u00edvia,Bol\u00edvia,Bolivia,Bolivia,Bolivia,Bolivia,\ubcfc\ub9ac\ube44\uc544,\u73bb\u5229\u7ef4\u4e9a,\u0411\u043e\u042c\u0438\u0432\u0438\u044f,Boliwia,Bolivya,\u0411\u043e\u042c\u0456\u0432\u0456\u044f,\u0628\u0648\u0644\u064a\u0641\u064a\u0627,Bolivija,Bol\u00edvie,\u0392\u03bf\u03bb\u03b9\u03b2\u03af\u03b1,\u05d1\u05d5\u05dc\u05d9\u05d1\u05d9\u05d4,Bolivia,Bol\u00edvia,\u0e42\u0e1a\u0e25\u0e34\u0e40\u0e27\u0e35\u0e22,Bolivia,Bolivia,Bol\u00edvia,Bol\u00edvia,B\u00f4-li-vi-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.BR, "br,\u5df4\u897f,Brazil,Br\u00e9sil,Brasilien,\u30d6\u30e9\u30b8\u30eb,Brazili\u00eb,Brasile,Brasil,Brasil,Brasil,Brasilien,Brasilia,Brasil,Brasilien,\ube0c\ub77c\uc9c8,\u5df4\u897f,\u0411\u0440\u0430\u0437\u0438\u042c\u0438\u044f,Brazylia,Brezilya,\u0411\u0440\u0430\u0437\u0438\u042c\u0456\u044f,\u0627\u0644\u0628\u0631\u0627\u0632\u064a\u0644,Brazil,Braz\u00edlie,\u0392\u03c1\u03b1\u03b6\u03b9\u03bb\u03af\u03b1,\u05d1\u05e8\u05d6\u05d9\u05dc,Brazilia,Braz\u00edlia,\u0e1a\u0e23\u0e32\u0e0b\u0e34\u0e25,Brazil,Brazil,Brasil,Braz\u00edlia,Bra-xin".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.CL, "cl,\u667a\u5229,Chile,Chili,Chile,\u30c1\u30ea,Chili,Cile,Chile,Chile,Chile,Chile,Chile,Chile,Chile,\uce60\ub808,\u667a\u5229,\u0427\u0438\u042c\u0438,Chile,\u015eili,\u0427\u0438\u042c\u0456,\u0634\u064a\u0644\u064a,\u010cile,Chile,\u03a7\u03b9\u03bb\u03ae,\u05e6\u05f3\u05d9\u05dc\u05d4,Chile,\u010cile,\u0e0a\u0e34\u0e25\u0e35,Cile,Chile,Xile,Chile,Chi-l\u00ea".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.CO, "co,\u54e5\u502b\u6bd4\u4e9e,Colombia,Colombie,Kolumbien,\u30b3\u30ed\u30f3\u30d3\u30a2,Colombia,Colombia,Colombia,Col\u00f4mbia,Col\u00f4mbia,Colombia,Kolumbia,Colombia,Colombia,\ucf5c\ub86c\ube44\uc544,\u54e5\u4f26\u6bd4\u4e9a,\u041a\u043e\u042c\u0443\u043c\u0431\u0438\u044f,Kolumbia,Kolombiya,\u041a\u043e\u042c\u0443\u043c\u0431\u0456\u044f,\u0643\u0648\u0644\u0648\u0645\u0628\u064a\u0627,Kolumbija,Kolumbie,\u039a\u03bf\u03bb\u03bf\u03bc\u03b2\u03af\u03b1,\u05e7\u05d5\u05dc\u05d5\u05de\u05d1\u05d9\u05d4,Columbia,Kolumbia,\u0e42\u0e04\u0e25\u0e2d\u0e21\u0e40\u0e1a\u0e35\u0e22,Kolombia,Colombia,Col\u00f2mbia,Kolumbia,C\u00f4-l\u00f4m-bi-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.EC, "ec,\u5384\u74dc\u591a\u723e,Ecuador,\u00c9quateur,Ecuador,\u30a8\u30af\u30a2\u30c9\u30eb,Ecuador,Ecuador,Ecuador,Equador,Equador,Ecuador,Ecuador,Ecuador,Ecuador,\uc5d0\ucf70\ub3c4\ub974,\u5384\u74dc\u591a\u5c14,\u042d\u043a\u0432\u0430\u0434\u043e\u0440,Ekwador,Ekvador,\u0415\u043a\u0432\u0430\u0434\u043e\u0440,\u0627\u0644\u0625\u0643\u0648\u0627\u062f\u0648\u0631,Ekvador,Ekv\u00e1dor,\u0395\u03ba\u03bf\u03c5\u03b1\u03b4\u03cc\u03c1,\u05d0\u05e7\u05d5\u05d5\u05d3\u05d5\u05e8,Ecuador,Ekv\u00e1dor,\u0e40\u0e2d\u0e01\u0e27\u0e32\u0e14\u0e2d\u0e23\u0e4c,Ekuador,Ecuador,Equador,Ecuador,\u00ca-cu-a-\u0111o".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.FK, "fk,\u798f\u514b\u862d\u7fa4\u5cf6,Falkland Islands,\u00celes Malouines,Falklandinseln,\u30d5\u30a9\u30fc\u30af\u30e9\u30f3\u30c9\u8af8\u5cf6,Falklandeilanden,Isole Falkland,Islas Malvinas,Ilhas Malvinas,Ilhas Falkland,Falklands\u00f8erne,Falklandinsaaret,Falklands\u00f8yene,Falklands\u00f6arna,\ud3ec\ud074\ub79c\ub4dc \uc81c\ub3c4,\u798f\u514b\u5170\u7fa4\u5c9b,\u0424\u043e\u042c\u043a\u042c\u0435\u043d\u0434\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430,Falklandy,Falkland Adalar\u0131,\u0424\u043e\u042c\u043a\u042c\u0435\u043d\u0434\u0441\u044c\u043a\u0456 \u043e\u0441\u0442\u0440\u043e\u0432\u0438,\u062c\u0632\u0631 \u0641\u0648\u0643\u0644\u0627\u0646\u062f,Falklandski Otoci,Falklandsk\u00e9 ostrovy,\u039d\u03ae\u03c3\u03bf\u03b9 \u03a6\u03ce\u03ba\u03bb\u03b1\u03bd\u03c4,\u05d0\u05d9\u05d9 \u05e4\u05d5\u05e7\u05dc\u05e0\u05d3,Insulele Falkland,Falklandsk\u00e9 ostrovy,\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e1f\u0e2d\u0e25\u0e4c\u0e01\u0e41\u0e25\u0e19\u0e14\u0e4c,Kepulauan Malvinas,Falkland Islands,Illes Malvines,Falkland-szigetek,Qu\u1ea7n \u0110\u1ea3o Falkland".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.GY, "gy,\u84cb\u4e9e\u7d0d,Guyana,Guyana,Guyana,\u30ac\u30a4\u30a2\u30ca,Guyana,Guyana,Guyana,Guiana,Guiana,Guyana,Guyana,Guyana,Guyana,\uac00\uc774\uc544\ub098,\u572d\u4e9a\u90a3,\u0413\u0430\u0439\u0430\u043d\u0430,Gujana,Guyana,\u0413\u0430\u0439\u0430\u043d\u0430,\u063a\u064a\u0627\u0646\u0627,Gvajana,Guyana,\u0393\u03bf\u03c5\u03b9\u03ac\u03bd\u03b1,\u05d2\u05d9\u05d0\u05e0\u05d4,Guyana,Guayana,\u0e01\u0e32\u0e22\u0e2d\u0e32\u0e19\u0e32,Guyana,Guyana,Guyana,Guyana,Guy-a-na".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.PE, "pe,\u79d8\u9b6f,Peru,P\u00e9rou,Peru,\u30da\u30eb\u30fc,Peru,Per\u00f9,Per\u00fa,Peru,Peru,Peru,Peru,Peru,Peru,\ud398\ub8e8,\u79d8\u9c81,\u041f\u0435\u0440\u0443,Peru,Peru,\u041f\u0435\u0440\u0443,\u0628\u064a\u0631\u0648,Peru,Peru,\u03a0\u03b5\u03c1\u03bf\u03cd,\u05e4\u05e8\u05d5,Peru,Peru,\u0e40\u0e1b\u0e23\u0e39,Peru,Peru,Per\u00fa,Peru,P\u00ea-ru".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.PY, "py,\u5df4\u62c9\u572d,Paraguay,Paraguay,Paraguay,\u30d1\u30e9\u30b0\u30a2\u30a4,Paraguay,Paraguay,Paraguay,Paraguai,Paraguai,Paraguay,Paraguay,Paraguay,Paraguay,\ud30c\ub77c\uacfc\uc774,\u5df4\u62c9\u572d,\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439,Paragwaj,Paraguay,\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439,\u0628\u0627\u0631\u0627\u063a\u0648\u0627\u064a,Paragvaj,Paraguay,\u03a0\u03b1\u03c1\u03b1\u03b3\u03bf\u03c5\u03ac\u03b7,\u05e4\u05e8\u05d2\u05d5\u05d5\u05d0\u05d9,Paraguay,Paraguaj,\u0e1b\u0e32\u0e23\u0e32\u0e01\u0e27\u0e31\u0e22,Paraguay,Paraguay,Paraguai,Paraguay,Pa-ra-goay".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.SR, "sr,\u8607\u5229\u5357,Suriname,Suriname,Suriname,\u30b9\u30ea\u30ca\u30e0,Suriname,Suriname,Surinam,Suriname,Suriname,Surinam,Surinam,Surinam,Surinam,\uc218\ub9ac\ub0a8,\u82cf\u91cc\u5357,\u0421\u0443\u0440\u0438\u043d\u0430\u043c,Surinam,Surinam,\u0421\u0443\u0440\u0438\u043d\u0430\u043c,\u0633\u0648\u0631\u064a\u0646\u0627\u0645,Surinam,Surinam,\u03a3\u03bf\u03c5\u03c1\u03b9\u03bd\u03ac\u03bc,\u05e1\u05d5\u05e8\u05d9\u05e0\u05dd,Surinam,Surinam,\u0e0b\u0e39\u0e23\u0e34\u0e19\u0e32\u0e40\u0e21,Suriname,Suriname,Surinam,Suriname,Xu-ri-nam".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.UY, "uy,\u70cf\u62c9\u572d,Uruguay,Uruguay,Uruguay,\u30a6\u30eb\u30b0\u30a2\u30a4,Uruguay,Uruguay,Uruguay,Uruguai,Uruguai,Uruguay,Uruguay,Uruguay,Uruguay,\uc6b0\ub8e8\uacfc\uc774,\u4e4c\u62c9\u572d,\u0423\u0440\u0443\u0433\u0432\u0430\u0439,Urugwaj,Uruguay,\u0423\u0440\u0443\u0433\u0432\u0430\u0439,\u0623\u0648\u0631\u063a\u0648\u0627\u064a,Urugvaj,Uruguay,\u0390\u03c5\u03c1\u03bf\u03c5\u03b3\u03bf\u03c5\u03ac\u03b7,\u05d0\u05d5\u05e8\u05d5\u05d2\u05d5\u05d5\u05d0\u05d9,Uruguay,Uruguaj,\u0e2d\u0e38\u0e23\u0e38\u0e01\u0e27\u0e31\u0e22,Uruguay,Uruguay,Uruguai,Uruguay,U-ru-goay".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.VE, "ve,\u59d4\u5167\u745e\u62c9,Venezuela,Venezuela,Venezuela,\u30d9\u30cd\u30ba\u30a8\u30e9,Venezuela,Venezuela,Venezuela,Venezuela,Venezuela,Venezuela,Venezuela,Venezuela,Venezuela,\ubca0\ub124\uc218\uc5d8\ub77c,\u59d4\u5185\u745e\u62c9,\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u042c\u0430,Wenezuela,Venezuela,\u0412\u0435\u043d\u0435\u0441\u0443\u0435\u042c\u0430,\u0641\u0646\u0632\u0648\u064a\u0644\u0627,Venezuela,Venezuela,\u0392\u03b5\u03bd\u03b5\u03b6\u03bf\u03c5\u03ad\u03bb\u03b1,\u05d5\u05e0\u05e6\u05d5\u05d0\u05dc\u05d4,Venezuela,Venezuela,\u0e40\u0e27\u0e40\u0e19\u0e0b\u0e38\u0e40\u0e2d\u0e25\u0e32,Venezuela,Venezuela,Vene\u00e7uela,Venezuela,V\u00ea-n\u00ea-zu-\u00ea-la".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.KG, "kg,\u5409\u723e\u5409\u65af,Kyrgyzstan,Kirghizistan,Kirgisistan,\u30ad\u30eb\u30ae\u30b9\u30bf\u30f3,Kirgizi\u00eb,Kirghizistan,Kirguist\u00e1n,Quirguist\u00e3o,Quirguizist\u00e3o,Kirgisistan,Kirgisia,Kirgisistan,Kirgizistan,\ud0a4\ub974\uae30\uc2a4\uc2a4\ud0c4,\u5409\u5c14\u5409\u65af\u65af\u5766,\u041a\u0438\u0440\u0433\u0438\u0437\u0438\u044f,Kirgistan,K\u0131rg\u0131zistan,\u041a\u0438\u0440\u0433\u0438\u0437\u0441\u0442\u0430\u043d,\u0642\u0631\u063a\u064a\u0632\u0633\u062a\u0627\u0646,Kirgistan,Kyrgyzst\u00e1n,\u039a\u03b9\u03c1\u03b3\u03b9\u03c3\u03c4\u03ac\u03bd,\u05e7\u05d9\u05e8\u05d2\u05d9\u05d6\u05e1\u05d8\u05df,K\u00e2rg\u00e2zstan,Kirgizsko,\u0e04\u0e35\u0e23\u0e4c\u0e01\u0e35\u0e0b\u0e2a\u0e16\u0e32\u0e19,Kirgistan,Kyrgyzstan,Kirguizistan,Kirgiziszt\u00e1n,C\u01b0-r\u01a1-g\u01b0-xtan".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.KZ, "kz,\u54c8\u85a9\u514b,Kazakhstan,Kazakhstan,Kasachstan,\u30ab\u30b6\u30d5\u30b9\u30bf\u30f3,Kazachstan,Kazakistan,Kazajist\u00e1n,Casaquist\u00e3o,Cazaquist\u00e3o,Kasakhstan,Kazakstan,Kasakhstan,Kazakstan,\uce74\uc790\ud750\uc2a4\ud0c4,\u54c8\u8428\u514b\u65af\u5766,\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d,Kazachstan,Kazakistan,\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d,\u0643\u0627\u0632\u0627\u062e\u0633\u062a\u0627\u0646,Kazakstan,Kazachst\u00e1n,\u039a\u03b1\u03b6\u03b1\u03ba\u03c3\u03c4\u03ac\u03bd,\u05e7\u05d6\u05d7\u05e1\u05d8\u05df,Kazahstan,Kazachstan,\u0e04\u0e32\u0e0b\u0e31\u0e04\u0e2a\u0e16\u0e32\u0e19,Kazakstan,Kazakhstan,Kazakhstan,Kazahszt\u00e1n,Ka-d\u1eafc-xtan".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.TJ, "tj,\u5854\u5409\u514b,Tajikistan,Tadjikistan,Tadschikistan,\u30bf\u30b8\u30ad\u30b9\u30bf\u30f3,Tadzjikistan,Tagikistan,Tayikist\u00e1n,Tadjiquist\u00e3o,Tajiquist\u00e3o,Tadsjikistan,Tad\u017eikistan,Tadsjikistan,Tadzjikistan,\ud0c0\uc9c0\ud0a4\uc2a4\ud0c4,\u5854\u5409\u514b\u65af\u5766,\u0422\u0430\u0434\u0436\u0438\u043a\u0438\u0441\u0442\u0430\u043d,Tad\u017cykistan,Tacikistan,\u0422\u0430\u0434\u0436\u0438\u043a\u0438\u0441\u0442\u0430\u043d,\u0637\u0627\u062c\u0643\u0633\u062a\u0627\u0646,Tad\u017eikistan,T\u00e1d\u017eikist\u00e1n,\u03a4\u03b1\u03c4\u03b6\u03b9\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd,\u05d8\u05d2\u05f3\u05d9\u05e7\u05d9\u05e1\u05d8\u05df,Tadjikistan,Tad\u017eikistan,\u0e17\u0e32\u0e08\u0e34\u0e01\u0e34\u0e2a\u0e16\u0e32\u0e19,Tajikistan,Tajikistan,Tadjikistan,Tadzsikiszt\u00e1n,T\u00e1t-gi-ki-xtan".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.TM, "tm,\u571f\u5eab\u66fc,Turkmenistan,Turkm\u00e9nistan,Turkmenistan,\u30c8\u30eb\u30af\u30e1\u30cb\u30b9\u30bf\u30f3,Turkmenistan,Turkmenistan,Turkmenist\u00e1n,Turcomenist\u00e3o,Turquemenist\u00e3o,Turkmenistan,Turkmenistan,Turkmenistan,Turkmenistan,\ud22c\ub974\ud06c\uba54\ub2c8\uc2a4\ud0c4,\u571f\u5e93\u66fc\u65af\u5766,\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441\u0442\u0430\u043d,Turkmenistan,T\u00fcrkmenistan,\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441\u0442\u0430\u043d,\u062a\u0631\u0643\u0645\u0627\u0646\u0633\u062a\u0627\u0646,Turkmenistan,Turkmenist\u00e1n,\u03a4\u03bf\u03c5\u03c1\u03ba\u03bc\u03b5\u03bd\u03b9\u03c3\u03c4\u03ac\u03bd,\u05d8\u05d5\u05e8\u05e7\u05de\u05e0\u05d9\u05e1\u05d8\u05df,Turkmenistan,Turkm\u00e9nsko,\u0e40\u0e15\u0e34\u0e23\u0e4c\u0e01\u0e40\u0e21\u0e19\u0e34\u0e2a\u0e16\u0e32\u0e19,Turkmenistan,Turkmenistan,Turkmenistan,T\u00fcrkmeniszt\u00e1n,Tu\u1ed1c-m\u00ea-ni-xtan".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.UZ, "uz,\u70cf\u8332\u5225\u514b,Uzbekistan,Ouzb\u00e9kistan,Usbekistan,\u30a6\u30ba\u30d9\u30ad\u30b9\u30bf\u30f3,Oezbekistan,Uzbekistan,Uzbekist\u00e1n,Uzbequist\u00e3o,Uzbequist\u00e3o,Usbekistan,Uzbekistan,Usbekistan,Uzbekistan,\uc6b0\uc988\ubca0\ud0a4\uc2a4\ud0c4,\u4e4c\u5179\u522b\u514b\u65af\u5766,\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d,Uzbekistan,\u00d6zbekistan,\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d,\u0623\u0648\u0632\u0628\u0643\u0633\u062a\u0627\u0646,Uzbekistan,Uzbekist\u00e1n,\u0390\u03c5\u03b6\u03bc\u03c0\u03b5\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd,\u05d0\u05d5\u05d6\u05d1\u05e7\u05d9\u05e1\u05d8\u05df,Uzbekistan,Uzbekistan,\u0e2d\u0e38\u0e0b\u0e40\u0e1a\u0e01\u0e34\u0e2a\u0e16\u0e32\u0e19,Uzbekistan,Uzbekistan,Uzbekistan,\u00dczbegiszt\u00e1n,U-d\u01a1-b\u00ea-ki-xtan".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.CN, "cn,\u4e2d\u570b,China,Chine,China,\u4e2d\u56fd,China,Cina,China,China,China,Kina,Kiina,Kina,Kina,\uc911\uad6d,\u4e2d\u56fd,\u041a\u0438\u0442\u0430\u0439,Chiny,\u00c7in,\u041a\u0438\u0442\u0430\u0439,\u0627\u0644\u0635\u064a\u0646,Kina,\u010c\u00edna,\u039a\u03af\u03bd\u03b1,\u05e1\u05d9\u05df,China,\u010c\u00edna,\u0e08\u0e35\u0e19,Cina,China,Xina,K\u00edna,Trung Qu\u1ed1c".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.HK, "hk,\u9999\u6e2f,Hong Kong,Hong-Kong,Hongkong,\u4e2d\u56fd\u9999\u6e2f\u7279\u5225\u884c\u653f\u533a,Hongkong,Hong Kong,Hong-Kong,Hong Kong,Regi\u00e3o Administrativa Especial de Hong Kong,SAR Hongkong,Hongkong \u2013 Kiinan e.h.a.,Hongkong S.A.R. Kina,Hongkong (S.A.R. Kina),\ud64d\ucf69, \uc911\uad6d \ud2b9\ubcc4\ud589\uc815\uad6c,\u9999\u6e2f,\u0413\u043e\u043d\u043a\u043e\u043d\u0433 (\u043e\u0441\u043e\u0431\u044b\u0439 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u044b\u0439 \u0440\u0430\u0439\u043e\u043d \u041a\u041d\u0420),Hongkong SAR,Hong Kong SAR - \u00c7in,\u0413\u043e\u043d\u043a\u043e\u043d\u0491 \u041e.\u0410.\u0420. \u041a\u0438\u0442\u0430\u044e,\u0647\u0648\u0646\u062c \u0643\u0648\u0646\u062c \u0627\u0644\u0635\u064a\u0646\u064a\u0629,Hong Kong S.A.R. Kine,Hongkong, zvl\u00e1\u0161tn\u00ed administrativn\u00ed oblast \u010c\u00edny,\u03a7\u03bf\u03bd\u03b3\u03ba \u039a\u03bf\u03bd\u03b3\u03ba \u0395\u0394\u03a0 \u039a\u03af\u03bd\u03b1\u03c2,\u05d4\u05d5\u05e0\u05d2 \u05e7\u05d5\u05e0\u05d2 - \u05de\u05d7\u05d5\u05d6 \u05de\u05e0\u05d4\u05dc\u05d9 \u05de\u05d9\u05d5\u05d7\u05d3 \u05e9\u05dc \u05e1\u05d9\u05df,R.A.S. Hong Kong a Chinei,Hong Kong S.A.R. \u010c\u00edny,\u0e2e\u0e48\u0e2d\u0e07\u0e01\u0e07 \u0e40\u0e02\u0e15\u0e1b\u0e01\u0e04\u0e23\u0e2d\u0e07\u0e1e\u0e34\u0e40\u0e28\u0e29\u0e1b\u0e23\u0e30\u0e40\u0e17\u0e28\u0e08\u0e35\u0e19,Hong Kong SAR China,Hong Kong SAR China,Regi\u00f3 administrativa especial xinesa de Hong Kong,Hongkong SAR K\u00edna,\u0110\u1eb7c khu h\u00e0nh ch\u00ednh H\u1ed3ng K\u00f4ng thu\u1ed9c CHND Trung Hoa".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.JP, "jp,\u65e5\u672c,Japan,Japon,Japan,\u65e5\u672c,Japan,Giappone,Jap\u00f3n,Jap\u00e3o,Jap\u00e3o,Japan,Japani,Japan,Japan,\uc77c\ubcf8,\u65e5\u672c,\u042f\u043f\u043e\u043d\u0438\u044f,Japonia,Japonya,\u042f\u043f\u043e\u043d\u0456\u044f,\u0627\u0644\u064a\u0627\u0628\u0627\u0646,Japan,Japonsko,\u0399\u03b1\u03c0\u03c9\u03bd\u03af\u03b1,\u05d9\u05e4\u05df,Japonia,Japonsko,\u0e0d\u0e35\u0e48\u0e1b\u0e38\u0e48\u0e19,Jepang,Japan,Jap\u00f3,Jap\u00e1n,Nh\u1eadt B\u1ea3n".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.KP, "kp,\u5317\u97d3,North Korea,Cor\u00e9e du Nord,Nordkorea,\u671d\u9bae\u6c11\u4e3b\u4e3b\u7fa9\u4eba\u6c11\u5171\u548c\u56fd,Noord-Korea,Corea del Nord,Corea del Norte,Coreia do Norte,Coreia do Norte,Nordkorea,Pohjois-Korea,Nord-Korea,Nordkorea,\uc870\uc120 \ubbfc\uc8fc\uc8fc\uc758 \uc778\ubbfc \uacf5\ud654\uad6d,\u5317\u671d\u9c9c,\u0421\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u041a\u043e\u0440\u0435\u044f,Korea P\u00f3\u0142nocna,Kuzey Kore,\u041f\u0456\u0432\u043d\u0456\u0447\u043d\u0430 \u041a\u043e\u0440\u0435\u044f,\u0643\u0648\u0631\u064a\u0627 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629,Sjeverna Koreja,Severn\u00ed Korea,\u0392\u03cc\u03c1\u03b5\u03b9\u03b1 \u039a\u03bf\u03c1\u03ad\u03b1,\u05e6\u05e4\u05d5\u05df \u05e7\u05d5\u05e8\u05d9\u05d0\u05d4,Coreea de Nord,K\u00f3rejsk\u00e1 \u013eudovodemokratick\u00e1 republika,\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35\u0e40\u0e2b\u0e19\u0e37\u0e2d,Korea Utara,North Korea,Corea del Nord,\u00c9szak-Korea,B\u1eafc Tri\u1ec1u Ti\u00ean".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.KR, "kr,\u5357\u97d3,South Korea,Cor\u00e9e du Sud,S\u00fcdkorea,\u5927\u97d3\u6c11\u56fd,Zuid-Korea,Corea del Sud,Corea del Sur,Coreia do Sul,Coreia do Sul,Sydkorea,Etel\u00e4-Korea,S\u00f8r-Korea,Sydkorea,\ub300\ud55c\ubbfc\uad6d,\u97e9\u56fd,\u0420\u0435\u0441\u043f\u0443\u0431\u042c\u0438\u043a\u0430 \u041a\u043e\u0440\u0435\u044f,Korea Po\u0142udniowa,G\u00fcney Kore,\u041f\u0456\u0432\u0434\u0435\u043d\u043d\u0430 \u041a\u043e\u0440\u0435\u044f,\u0643\u0648\u0631\u064a\u0627 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629,Ju\u017ena Koreja,Ji\u017en\u00ed Korea,\u039d\u03cc\u03c4\u03b9\u03b1 \u039a\u03bf\u03c1\u03ad\u03b1,\u05d3\u05e8\u05d5\u05dd \u05e7\u05d5\u05e8\u05d9\u05d0\u05d4,Coreea de Sud,K\u00f3rejsk\u00e1 republika,\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35\u0e43\u0e15\u0e49,Korea Selatan,South Korea,Corea del Sud,D\u00e9l-Korea,H\u00e0n Qu\u1ed1c".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.MN, "mn,\u8499\u53e4,Mongolia,Mongolie,Mongolei,\u30e2\u30f3\u30b4\u30eb,Mongoli\u00eb,Mongolia,Mongolia,Mong\u00f3lia,Mong\u00f3lia,Mongoliet,Mongolia,Mongolia,Mongoliet,\ubabd\uace8,\u8499\u53e4,\u041c\u043e\u043d\u0433\u043e\u042c\u0438\u044f,Mongolia,Mo\u011folistan,\u041c\u043e\u043d\u0433\u043e\u042c\u0456\u044f,\u0645\u0646\u063a\u0648\u0644\u064a\u0627,Mongolija,Mongolsko,\u039c\u03bf\u03b3\u03b3\u03bf\u03bb\u03af\u03b1,\u05de\u05d5\u05e0\u05d2\u05d5\u05dc\u05d9\u05d4,Mongolia,Mongolsko,\u0e21\u0e2d\u0e07\u0e42\u0e01\u0e40\u0e25\u0e35\u0e22,Mongolia,Mongolia,Mong\u00f2lia,Mong\u00f3lia,M\u00f4ng C\u1ed5".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.MO, "mo,\u6fb3\u9580,Macao,Macao,Macao,\u4e2d\u56fd\u30de\u30ab\u30aa\u7279\u5225\u884c\u653f\u533a,Macau,Macao,Macao,Macau,Regi\u00e3o Administrativa Especial de Macau,SAR Macao,Macao \u2013 Kiinan e.h.a.,Macao S.A.R. Kina,Macao (S.A.R. Kina),\ub9c8\uce74\uc624, \uc911\uad6d \ud2b9\ubcc4\ud589\uc815\uad6c,\u6fb3\u95e8,\u041c\u0430\u043a\u0430\u043e (\u043e\u0441\u043e\u0431\u044b\u0439 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u044b\u0439 \u0440\u0430\u0439\u043e\u043d \u041a\u041d\u0420),Makau SAR,Makao SAR - \u00c7in,\u041c\u0430\u043a\u0430\u043e \u041e.\u0410.\u0420. \u041a\u0438\u0442\u0430\u044e,\u0645\u0627\u0643\u0627\u0648 \u0627\u0644\u0635\u064a\u0646\u064a\u0629,Makao S.A.R. Kine,Zvl\u00e1\u0161tn\u00ed administrativn\u00ed oblast \u010c\u00edny Macao,\u039c\u03b1\u03ba\u03ac\u03bf \u0395\u0394\u03a0 \u039a\u03af\u03bd\u03b1\u03c2,\u05de\u05e7\u05d0\u05d5 - \u05de\u05d7\u05d5\u05d6 \u05de\u05e0\u05d4\u05dc\u05d9 \u05de\u05d9\u05d5\u05d7\u05d3 \u05e9\u05dc \u05e1\u05d9\u05df,R.A.S. Macao a Chinei,Makao S.A.R. \u010c\u00edny,\u0e21\u0e32\u0e40\u0e01\u0e4a\u0e32 \u0e40\u0e02\u0e15\u0e1b\u0e01\u0e04\u0e23\u0e2d\u0e07\u0e1e\u0e34\u0e40\u0e28\u0e29\u0e1b\u0e23\u0e30\u0e40\u0e17\u0e28\u0e08\u0e35\u0e19,Makau SAR China,Macau SAR China,Regi\u00f3 administrativa especial xinesa de Macau,Maka\u00f3 SAR K\u00edna,\u0110\u1eb7c khu h\u00e0nh ch\u00ednh Macao thu\u1ed9c CHND Trung Hoa".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.TW, "tw,\u53f0\u7063,Taiwan,Ta\u00efwan,Taiwan,\u53f0\u6e7e,Taiwan,Taiwan,Taiw\u00e1n,Taiwan,Taiwan,Taiwan,Taiwan,Taiwan,Taiwan,\ub300\ub9cc,\u53f0\u6e7e,\u0422\u0430\u0439\u0432\u0430\u043d\u044c,Tajwan,Tayvan,\u0422\u0430\u0439\u0432\u0430\u043d\u044c,\u062a\u0627\u064a\u0648\u0627\u0646,Tajvan,Tchaj-wan,\u03a4\u03b1\u03ca\u03b2\u03ac\u03bd,\u05d8\u05d9\u05d9\u05d5\u05d5\u05d0\u05df,Taiwan,Tajwan,\u0e44\u0e15\u0e49\u0e2b\u0e27\u0e31\u0e19,Taiwan,Taiwan,Taiwan,Tajvan,\u0110\u00e0i Loan".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.BN, "bn,\u6c76\u840a,Brunei,Brun\u00e9i Darussalam,Brunei Darussalam,\u30d6\u30eb\u30cd\u30a4,Brunei,Brunei,Brun\u00e9i,Brunei,Brunei,Brunei Darussalam,Brunei,Brunei Darussalam,Brunei,\ube0c\ub8e8\ub098\uc774,\u6587\u83b1,\u0411\u0440\u0443\u043d\u0435\u0439 \u0414\u0430\u0440\u0443\u0441\u0441\u0430\u042c\u0430\u043c,Brunei Darussalam,Brunei,\u0411\u0440\u0443\u043d\u0435\u0439,\u0628\u0631\u0648\u0646\u0627\u064a,Brunej,Brunej Darussalam,\u039c\u03c0\u03c1\u03bf\u03c5\u03bd\u03ad\u03b9,\u05d1\u05e8\u05d5\u05e0\u05d9\u05d9,Brunei,Brunej,\u0e1a\u0e23\u0e39\u0e44\u0e19,Brunei,Brunei,Brunei,Brunei,Bru-n\u00e2y".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.ID, "id,\u5370\u5c3c,Indonesia,Indon\u00e9sie,Indonesien,\u30a4\u30f3\u30c9\u30cd\u30b7\u30a2,Indonesi\u00eb,Indonesia,Indonesia,Indon\u00e9sia,Indon\u00e9sia,Indonesien,Indonesia,Indonesia,Indonesien,\uc778\ub3c4\ub124\uc2dc\uc544,\u5370\u5ea6\u5c3c\u897f\u4e9a,\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f,Indonezja,Endonezya,\u0406\u043d\u0434\u043e\u043d\u0435\u0437\u0456\u044f,\u0627\u0646\u062f\u0648\u0646\u064a\u0633\u064a\u0627,Indonezija,Indon\u00e9sie,\u0399\u03bd\u03b4\u03bf\u03bd\u03b7\u03c3\u03af\u03b1,\u05d0\u05d9\u05e0\u05d3\u05d5\u05e0\u05d6\u05d9\u05d4,Indonezia,Indon\u00e9zia,\u0e2d\u0e34\u0e19\u0e42\u0e14\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22,Indonesia,Indonesia,Indon\u00e8sia,Indon\u00e9zia,Nam D\u01b0\u01a1ng".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.KH, "kh,\u67ec\u57d4\u5be8,Cambodia,Cambodge,Kambodscha,\u30ab\u30f3\u30dc\u30b8\u30a2,Cambodja,Cambogia,Camboya,Camboja,Camboja,Cambodja,Kambod\u017ea,Kambodsja,Kambodja,\uce84\ubcf4\ub514\uc544,\u67ec\u57d4\u5be8,\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0430,Kambod\u017ca,Kambo\u00e7ya,\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0430,\u0643\u0645\u0628\u0648\u062f\u064a\u0627,Kambod\u017ea,Kambod\u017ea,\u039a\u03b1\u03bc\u03c0\u03cc\u03c4\u03b6\u03b7,\u05e7\u05de\u05d1\u05d5\u05d3\u05d9\u05d4,Cambodgia,Kambod\u017ea,\u0e01\u0e31\u0e21\u0e1e\u0e39\u0e0a\u0e32,Kamboja,Cambodia,Cambodja,Kambodzsa,Campuchia".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.LA, "la,\u5bee\u570b,Laos,Laos,Laos,\u30e9\u30aa\u30b9,Laos,Laos,Laos,Rep\u00fablica Democr\u00e1tica Popular de Lao,Laos, Rep\u00fablica Popular Democr\u00e1tica do,Laos,Laos,Laos,Laos,\ub77c\uc624\uc2a4,\u8001\u631d\u4eba\u6c11\u6c11\u4e2c\u5171\u548c\u56fd,\u041b\u0430\u043e\u0441,Laos,Laos,\u041b\u0430\u043e\u0441,\u0644\u0627\u0648\u0633,Laos,Lidov\u011b demokratick\u00e1 republika Laos,\u039b\u03ac\u03bf\u03c2,\u05dc\u05d0\u05d5\u05e1,Laos,Laosk\u00e1 \u013eudovodemokratick\u00e1 republika,\u0e25\u0e32\u0e27,Laos,Laos,Laos,Laosz,L\u00e0o".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.MM, "mm,\u7dec\u7538,Myanmar,Myanmar,Myanmar,\u30df\u30e3\u30f3\u30de\u30fc,Myanmar,Myanmar,Myanmar,Mianmar,Mianmar,Myanmar,Myanmar,Myanmar,Myanmar,\ubbf8\uc580\ub9c8,\u7f05\u7538,\u041c\u044c\u044f\u043d\u043c\u0430,Birma,Myanmar,\u041c\u02bc\u044f\u043d\u043c\u0430 [\u0411\u0456\u0440\u043c\u0430],\u0645\u064a\u0627\u0646\u0645\u0627\u0631 -\u0628\u0648\u0631\u0645\u0627,Mijanma,Myanmar,\u039c\u03b9\u03b1\u03bd\u03bc\u03ac\u03c1,\u05de\u05d9\u05d9\u05d0\u05e0\u05de\u05d0\u05e8,Myanmar,Mjanmarsko,\u0e40\u0e21\u0e35\u0e22\u0e19\u0e21\u0e48\u0e32\u0e23\u0e4c [\u0e1e\u0e21\u0e48\u0e32],Myanmar,Myanmar [Burma],Myanmar [Birm\u00e0nia],Mianmar [Burma],Mi-an-ma".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.MY, "my,\u99ac\u4f86\u897f\u4e9e,Malaysia,Malaisie,Malaysia,\u30de\u30ec\u30fc\u30b7\u30a2,Maleisi\u00eb,Malesia,Malasia,Mal\u00e1sia,Mal\u00e1sia,Malaysia,Malesia,Malaysia,Malaysia,\ub9d0\ub808\uc774\uc2dc\uc544,\u9a6c\u6765\u897f\u4e9a,\u041c\u0430\u042c\u0430\u0439\u0437\u0438\u044f,Malezja,Malezya,\u041c\u0430\u042c\u0430\u0439\u0437\u0456\u044f,\u0645\u0627\u0644\u064a\u0632\u064a\u0627,Malezija,Malajsie,\u039c\u03b1\u03bb\u03b1\u03b9\u03c3\u03af\u03b1,\u05de\u05dc\u05d6\u05d9\u05d4,Malaezia,Malajzia,\u0e21\u0e32\u0e40\u0e25\u0e40\u0e0b\u0e35\u0e22,Malaysia,Malaysia,Mal\u00e0isia,Malajzia,Ma-lay-xi-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.PH, "ph,\u83f2\u5f8b\u8cd3,Philippines,Philippines,Philippinen,\u30d5\u30a3\u30ea\u30d4\u30f3,Filipijnen,Filippine,Filipinas,Filipinas,Filipinas,Filippinerne,Filippiinit,Filippinene,Filippinerna,\ud544\ub9ac\ud540,\u83f2\u5f8b\u5bbe,\u0424\u0438\u042c\u0438\u043f\u043f\u0438\u043d\u044b,Filipiny,Filipinler,\u0424\u0456\u042c\u0456\u043f\u043f\u0456\u043d\u0438,\u0627\u0644\u0641\u064a\u0644\u0628\u064a\u0646,Filipini,Filip\u00edny,\u03a6\u03b9\u03bb\u03b9\u03c0\u03c0\u03af\u03bd\u03b5\u03c2,\u05e4\u05d9\u05dc\u05d9\u05e4\u05d9\u05e0\u05d9\u05dd,Filipine,Filip\u00edny,\u0e1f\u0e34\u0e25\u0e34\u0e1b\u0e1b\u0e34\u0e19\u0e2a\u0e4c,Filipina,Philippines,Filipines,F\u00fcl\u00f6p-szigetek,Phi-lip-pin".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.SG, "sg,\u65b0\u52a0\u5761,Singapore,Singapour,Singapur,\u30b7\u30f3\u30ac\u30dd\u30fc\u30eb,Singapore,Singapore,Singapur,Cingapura,Singapura,Singapore,Singapore,Singapore,Singapore,\uc2f1\uac00\ud3ec\ub974,\u65b0\u52a0\u5761,\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440,Singapur,Singapur,\u0421\u0456\u043d\u0433\u0430\u043f\u0443\u0440,\u0633\u0646\u063a\u0627\u0641\u0648\u0631\u0629,Singapur,Singapur,\u03a3\u03b9\u03b3\u03ba\u03b1\u03c0\u03bf\u03cd\u03c1\u03b7,\u05e1\u05d9\u05e0\u05d2\u05e4\u05d5\u05e8,Singapore,Singapur,\u0e2a\u0e34\u0e07\u0e04\u0e42\u0e1b\u0e23\u0e4c,Singapura,Singapore,Singapur,Szingap\u00far,Xin-ga-po".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.TH, "th,\u6cf0\u570b,Thailand,Tha\u00eflande,Thailand,\u30bf\u30a4,Thailand,Tailandia,Tailandia,Tail\u00e2ndia,Tail\u00e2ndia,Thailand,Thaimaa,Thailand,Thailand,\ud0dc\uad6d,\u6cf0\u56fd,\u0422\u0430\u0438\u042c\u0430\u043d\u0434,Tajlandia,Tayland,\u0422\u0430\u0457\u042c\u0430\u043d\u0434,\u062a\u0627\u064a\u0644\u0646\u062f,Tajland,Thajsko,\u03a4\u03b1\u03ca\u03bb\u03ac\u03bd\u03b4\u03b7,\u05ea\u05d0\u05d9\u05dc\u05e0\u05d3,Thailanda,Thajsko,\u0e44\u0e17\u0e22,Thailand,Thailand,Tail\u00e0ndia,Thaif\u00f6ld,Th\u00e1i Lan".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.TL, "tl,\u6771\u5e1d\u6c76,East Timor,Timor oriental,Osttimor,\u6771\u30c6\u30a3\u30e2\u30fc\u30eb,Oost-Timor,Timor Est,Timor Oriental,Timor-Leste,Timor-Leste,Timor-Leste,It\u00e4-Timor,\u00d8st-Timor,\u00d6sttimor,\ub3d9\ud2f0\ubaa8\ub974,\u4e1c\u5e1d\u6c76,\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u044b\u0439 \u0422\u0438\u043c\u043e\u0440,Timor Wschodni,Timor-Leste,\u0422\u0456\u043c\u043e\u0440-\u041b\u0435\u0448\u0442\u0456,\u062a\u064a\u0645\u0648\u0631 \u0627\u0644\u0634\u0631\u0642\u064a\u0629,Isto\u010dni Timor,V\u00fdchodn\u00ed Timor,\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03cc \u03a4\u03b9\u03bc\u03cc\u03c1,\u05de\u05d6\u05e8\u05d7 \u05d8\u05d9\u05de\u05d5\u05e8,Timorul de Est,V\u00fdchodn\u00fd Timor,\u0e15\u0e34\u0e21\u0e2d\u0e23\u0e4c\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01,Timor Leste,Timor-Leste,Timor Oriental,Kelet-Timor,\u0110\u00f4ng Ti-mo".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.VN, "vn,\u8d8a\u5357,Vietnam,Vi\u00eat Nam,Vietnam,\u30d9\u30c8\u30ca\u30e0,Vietnam,Vietnam,Vietnam,Vietn\u00e3,Vietname,Vietnam,Vietnam,Vietnam,Vietnam,\ubca0\ud2b8\ub0a8,\u8d8a\u5357,\u0412\u044c\u0435\u0442\u043d\u0430\u043c,Wietnam,Vietnam,\u0412\u02bc\u0454\u0442\u043d\u0430\u043c,\u0641\u064a\u062a\u0646\u0627\u0645,Vijetnam,Vietnam,\u0392\u03b9\u03b5\u03c4\u03bd\u03ac\u03bc,\u05d5\u05d9\u05d9\u05d8\u05e0\u05d0\u05dd,Vietnam,Vietnam,\u0e40\u0e27\u0e35\u0e22\u0e14\u0e19\u0e32\u0e21,Vietnam,Vietnam,Vietnam,Vietnam,Vi\u1ec7t Nam".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.AF, "af,\u963f\u5bcc\u6c57,Afghanistan,Afghanistan,Afghanistan,\u30a2\u30d5\u30ac\u30cb\u30b9\u30bf\u30f3,Afghanistan,Afghanistan,Afganist\u00e1n,Afeganist\u00e3o,Afeganist\u00e3o,Afghanistan,Afganistan,Afghanistan,Afghanistan,\uc544\ud504\uac00\ub2c8\uc2a4\ud0c4,\u963f\u5bcc\u6c57,\u0410\u0444\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d,Afganistan,Afganistan,\u0410\u0444\u0433\u0430\u043d\u0456\u0441\u0442\u0430\u043d,\u0623\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646,Afganistan,Afgh\u00e1nist\u00e1n,\u0391\u03c6\u03b3\u03b1\u03bd\u03b9\u03c3\u03c4\u03ac\u03bd,\u05d0\u05e4\u05d2\u05e0\u05d9\u05e1\u05d8\u05df,Afganistan,Afganistan,\u0e2d\u0e31\u0e1f\u0e01\u0e32\u0e19\u0e34\u0e2a\u0e16\u0e32\u0e19,Afghanistan,Afghanistan,Afganistan,Afganiszt\u00e1n,\u00c1p-ga-ni-xtan".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.BD, "bd,\u5b5f\u52a0\u62c9,Bangladesh,Bangladesh,Bangladesch,\u30d0\u30f3\u30b0\u30e9\u30c7\u30b7\u30e5,Bangladesh,Bangladesh,Bangladesh,Bangladesh,Bangladeche,Bangladesh,Bangladesh,Bangladesh,Bangladesh,\ubc29\uae00\ub77c\ub370\uc2dc,\u5b5f\u52a0\u62c9\u56fd,\u0411\u0430\u043d\u0433\u042c\u0430\u0434\u0435\u0448,Bangladesz,Banglade\u015f,\u0411\u0430\u043d\u0433\u042c\u0430\u0434\u0435\u0448,\u0628\u0646\u062c\u0644\u0627\u062f\u064a\u0634,Banglade\u0161,Banglad\u00e9\u0161,\u039c\u03c0\u03b1\u03bd\u03b3\u03ba\u03bb\u03b1\u03bd\u03c4\u03ad\u03c2,\u05d1\u05e0\u05d2\u05dc\u05d3\u05e9,Bangladesh,Banglad\u00e9\u0161,\u0e1a\u0e31\u0e07\u0e01\u0e25\u0e32\u0e40\u0e17\u0e28,Bangladesh,Bangladesh,Bangla Desh,Banglades,B\u0103ng-la-\u0111\u00e9t".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.BT, "bt,\u4e0d\u4e39,Bhutan,Bhoutan,Bhutan,\u30d6\u30fc\u30bf\u30f3,Bhutan,Bhutan,But\u00e1n,But\u00e3o,But\u00e3o,Bhutan,Bhutan,Bhutan,Bhutan,\ubd80\ud0c4,\u4e0d\u4e39,\u0411\u0443\u0442\u0430\u043d,Bhutan,Butan,\u0411\u0443\u0442\u0430\u043d,\u0628\u0648\u062a\u0627\u0646,Butan,Bh\u00fat\u00e1n,\u039c\u03c0\u03bf\u03c5\u03c4\u03ac\u03bd,\u05d1\u05d4\u05d5\u05d8\u05df,Bhutan,But\u00e1n,\u0e20\u0e39\u0e0f\u0e32\u0e19,Bhutan,Bhutan,Bhutan,Bhut\u00e1n,Bu-tan (Bhutan)".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.IN, "in,\u5370\u5ea6,India,Inde,Indien,\u30a4\u30f3\u30c9,India,India,India,\u00cdndia,\u00cdndia,Indien,Intia,India,Indien,\uc778\ub3c4,\u5370\u5ea6,\u0418\u043d\u0434\u0438\u044f,Indie,Hindistan,\u0406\u043d\u0434\u0456\u044f,\u0627\u0644\u0647\u0646\u062f,Indija,Indie,\u0399\u03bd\u03b4\u03af\u03b1,\u05d4\u05d5\u05d3\u05d5,India,India,\u0e2d\u0e34\u0e19\u0e40\u0e14\u0e35\u0e22,India,India,\u00cdndia,India,\u1ea4n \u0110\u1ed9".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.IR, "ir,\u4f0a\u6717,Iran,Iran,Iran,\u30a4\u30e9\u30f3,Iran,Iran,Ir\u00e1n,Ir\u00e3,Ir\u00e3o,Iran,Iran,Iran,Iran,\uc774\ub780,\u4f0a\u6717,\u0418\u0440\u0430\u043d,Iran,\u0130ran,\u0406\u0440\u0430\u043d,\u0627\u064a\u0631\u0627\u0646,Iran,\u00cdr\u00e1n,\u0399\u03c1\u03ac\u03bd,\u05d0\u05d9\u05e8\u05d0\u05df,Iran,Ir\u00e1n,\u0e2d\u0e34\u0e2b\u0e23\u0e48\u0e32\u0e19,Iran,Iran,Iran,Ir\u00e1n,I-ran".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.LK, "lk,\u65af\u91cc\u862d\u5361,Sri Lanka,Sri Lanka,Sri Lanka,\u30b9\u30ea\u30e9\u30f3\u30ab,Sri Lanka,Sri Lanka,Sri Lanka,Sri Lanka,Sri Lanka,Sri Lanka,Sri Lanka,Sri Lanka,Sri Lanka,\uc2a4\ub9ac\ub791\uce74,\u65af\u91cc\u5170\u5361,\u0428\u0440\u0438-\u041b\u0430\u043d\u043a\u0430,Sri Lanka,Sri Lanka,\u0428\u0440\u0456-\u041b\u0430\u043d\u043a\u0430,\u0633\u0631\u064a\u0644\u0627\u0646\u0643\u0627,\u0160ri Lanka,Sr\u00ed Lanka,\u03a3\u03c1\u03b9 \u039b\u03ac\u03bd\u03ba\u03b1,\u05e1\u05e8\u05d9 \u05dc\u05e0\u05e7\u05d4,Sri Lanka,Sr\u00ed Lanka,\u0e28\u0e23\u0e35\u0e25\u0e31\u0e07\u0e01\u0e32,Sri Lanka,Sri Lanka,Sri Lanka,Sr\u00ed Lanka,Xri Lan-ca".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.MV, "mv,\u99ac\u723e\u5730\u592b,Maldives,Maldives,Malediven,\u30e2\u30eb\u30b8\u30d6,Maldiven,Maldive,Maldivas,Maldivas,Maldivas,Maldiverne,Malediivit,Maldivene,Maldiverna,\ubab0\ub514\ube0c,\u9a6c\u5c14\u4ee3\u592b,\u041c\u0430\u042c\u044c\u0434\u0438\u0432\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430,Malediwy,Maldivler,\u041c\u0430\u042c\u044c\u0434\u0456\u0432\u0438,\u062c\u0632\u0631 \u0627\u0644\u0645\u0644\u062f\u064a\u0641,Maldivi,Maladivy,\u039c\u03b1\u03bb\u03b4\u03af\u03b2\u03b5\u03c2,\u05de\u05dc\u05d3\u05d9\u05d1\u05d9\u05dd,Maldive,Maldivy,\u0e21\u0e31\u0e25\u0e14\u0e35\u0e1f\u0e2a\u0e4c,Maladewa,Maldives,Maldives,Mald\u00edv-szigetek,Man-\u0111i-v\u01a1".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.NP, "np,\u5c3c\u6cca\u723e,Nepal,N\u00e9pal,Nepal,\u30cd\u30d1\u30fc\u30eb,Nepal,Nepal,Nepal,Nepal,Nepal,Nepal,Nepal,Nepal,Nepal,\ub124\ud314,\u5c3c\u6cca\u5c14,\u041d\u0435\u043f\u0430\u042c,Nepal,Nepal,\u041d\u0435\u043f\u0430\u042c,\u0646\u064a\u0628\u0627\u0644,Nepal,Nep\u00e1l,\u039d\u03b5\u03c0\u03ac\u03bb,\u05e0\u05e4\u05d0\u05dc,Nepal,Nep\u00e1l,\u0e40\u0e19\u0e1b\u0e32\u0e25,Nepal,Nepal,Nepal,Nep\u00e1l,N\u00ea-pan".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.PK, "pk,\u5df4\u57fa\u65af\u5766,Pakistan,Pakistan,Pakistan,\u30d1\u30ad\u30b9\u30bf\u30f3,Pakistan,Pakistan,Pakist\u00e1n,Paquist\u00e3o,Paquist\u00e3o,Pakistan,Pakistan,Pakistan,Pakistan,\ud30c\ud0a4\uc2a4\ud0c4,\u5df4\u57fa\u65af\u5766,\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d,Pakistan,Pakistan,\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d,\u0628\u0627\u0643\u0633\u062a\u0627\u0646,Pakistan,P\u00e1kist\u00e1n,\u03a0\u03b1\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd,\u05e4\u05e7\u05d9\u05e1\u05d8\u05df,Pakistan,Pakistan,\u0e1b\u0e32\u0e01\u0e35\u0e2a\u0e16\u0e32\u0e19,Pakistan,Pakistan,Pakistan,Pakiszt\u00e1n,Pa-ki-xtan".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.AE, "ae,\u963f\u62c9\u4f2f\u806f\u5408\u5927\u516c\u570b,United Arab Emirates,\u00c9mirats arabes unis,Vereinigte Arabische Emirate,\u30a2\u30e9\u30d6\u9996\u9577\u56fd\u9023\u90a6,Verenigde Arabische Emiraten,Emirati Arabi Uniti,Emiratos \u00c1rabes Unidos,Emirados \u00c1rabes Unidos,Emiratos \u00c1rabes Unidos,Forenede Arabiske Emirater,Arabiemiirikunnat,De forente arabiske emirater,F\u00f6renade Arabemiraten,\uc544\ub78d\uc5d0\ubbf8\ub9ac\ud2b8 \uc5f0\ud569,\u963f\u62c9\u4f2f\u8054\u5408\u914b\u957f\u56fd,\u041e\u0431\u044a\u0435\u0434\u0438\u043d\u0435\u043d\u043d\u044b\u0435 \u0410\u0440\u0430\u0431\u0441\u043a\u0438\u0435 \u042d\u043c\u0438\u0440\u0430\u0442\u044b,Zjednoczone Emiraty Arabskie,Birle\u015fik Arap Emirlikleri,\u041e\u0431\u02bc\u0454\u0434\u043d\u0430\u043d\u0456 \u0410\u0440\u0430\u0431\u0441\u044c\u043a\u0456 \u0415\u043c\u0456\u0440\u0430\u0442\u0438,\u0627\u0644\u0627\u0645\u0627\u0631\u0627\u062a \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0645\u062a\u062d\u062f\u0629,Ujedinjeni Arapski Emirati,Spojen\u00e9 arabsk\u00e9 emir\u00e1ty,\u0397\u03bd\u03c9\u03bc\u03ad\u03bd\u03b1 \u0391\u03c1\u03b1\u03b2\u03b9\u03ba\u03ac \u0395\u03bc\u03b9\u03c1\u03ac\u03c4\u03b1,\u05d0\u05d9\u05d7\u05d5\u05d3 \u05d4\u05d0\u05de\u05d9\u05e8\u05d5\u05d9\u05d5\u05ea \u05d4\u05e2\u05e8\u05d1\u05d9\u05d5\u05ea,Emiratele Arabe Unite,Spojen\u00e9 arabsk\u00e9 emir\u00e1ty,\u0e2a\u0e2b\u0e23\u0e31\u0e10\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e40\u0e2d\u0e21\u0e34\u0e40\u0e23\u0e15\u0e2a\u0e4c,Uni Emirat Arab,United Arab Emirates,Uni\u00f3 dels Emirats \u00c0rabs,Egyes\u00fclt Arab Emir\u00e1tus,C\u00e1c Ti\u1ec3u V\u01b0\u01a1ng qu\u1ed1c A-r\u1eadp Th\u1ed1ng nh\u1ea5t".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.AM, "am,\u4e9e\u7f8e\u5c3c\u4e9e,Armenia,Arm\u00e9nie,Armenien,\u30a2\u30eb\u30e1\u30cb\u30a2,Armeni\u00eb,Armenia,Armenia,Arm\u00eania,Arm\u00e9nia,Armenien,Armenia,Armenia,Armenien,\uc544\ub974\uba54\ub2c8\uc544,\u4e9a\u7f8e\u5c3c\u4e9a,\u0410\u0440\u043c\u0435\u043d\u0438\u044f,Armenia,Ermenistan,\u0412\u0456\u0440\u043c\u0435\u043d\u0456\u044f,\u0623\u0631\u0645\u064a\u0646\u064a\u0627,Armenija,Arm\u00e9nie,\u0391\u03c1\u03bc\u03b5\u03bd\u03af\u03b1,\u05d0\u05e8\u05de\u05e0\u05d9\u05d4,Armenia,Arm\u00e9nsko,\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e21\u0e40\u0e19\u0e35\u0e22,Armenia,Armenia,Arm\u00e8nia,\u00d6rm\u00e9nyorsz\u00e1g,\u00c1c-m\u00ea-ni-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.AZ, "az,\u4e9e\u585e\u62dc\u7136,Azerbaijan,Azerba\u00efdjan,Aserbaidschan,\u30a2\u30bc\u30eb\u30d0\u30a4\u30b8\u30e3\u30f3,Azerbeidzjan,Azerbaigian,Azerbaiy\u00e1n,Azerbaij\u00e3o,Azerbeij\u00e3o,Aserbajdsjan,Azerbaid\u017ean,Aserbajdsjan,Azerbajdzjan,\uc544\uc81c\ub974\ubc14\uc774\uc794,\u963f\u585e\u62dc\u7586,\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d,Azerbejd\u017can,Azerbaycan,\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d,\u0623\u0630\u0631\u0628\u064a\u062c\u0627\u0646,Azerbajd\u017ean,\u00c1zerb\u00e1jd\u017e\u00e1n,\u0391\u03b6\u03b5\u03c1\u03bc\u03c0\u03b1\u03ca\u03c4\u03b6\u03ac\u03bd,\u05d0\u05d6\u05e8\u05d1\u05d9\u05d2\u05f3\u05df,Azerbaidjan,Azerbajd\u017ean,\u0e2d\u0e32\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e44\u0e1a\u0e08\u0e32\u0e19,Azerbaijan,Azerbaijan,Azerbaidjan,Azerbajdzs\u00e1n,Ai-d\u00e9c-bai-gian".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.BH, "bh,\u5df4\u6797,Bahrain,Bahre\u00efn,Bahrain,\u30d0\u30fc\u30ec\u30fc\u30f3,Bahrein,Bahrein,Bahr\u00e9in,Bahrain,Bahrein,Bahrain,Bahrain,Bahrain,Bahrain,\ubc14\ub808\uc778,\u5df4\u6797,\u0411\u0430\u0445\u0440\u0435\u0439\u043d,Bahrajn,Bahreyn,\u0411\u0430\u0445\u0440\u0435\u0439\u043d,\u0627\u0644\u0628\u062d\u0631\u064a\u0646,Bahrein,Bahrajn,\u039c\u03c0\u03b1\u03c7\u03c1\u03ad\u03b9\u03bd,\u05d1\u05d7\u05e8\u05d9\u05d9\u05df,Bahrain,Bahrajn,\u0e1a\u0e32\u0e2b\u0e4c\u0e40\u0e23\u0e19,Bahrain,Bahrain,Bahrain,Bahrein,Ba-ren".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.GE, "ge,\u55ac\u6cbb\u4e9e\u5171\u548c\u570b,Georgia,G\u00e9orgie,Georgien,\u30b0\u30eb\u30b8\u30a2,Georgi\u00eb,Georgia,Georgia,Ge\u00f3rgia,Ge\u00f3rgia,Georgien,Georgia,Georgia,Georgien,\uadf8\ub8e8\uc9c0\uc57c,\u683c\u9c81\u5409\u4e9a,\u0413\u0440\u0443\u0437\u0438\u044f,Gruzja,G\u00fcrcistan,\u0413\u0440\u0443\u0437\u0456\u044f,\u062c\u0648\u0631\u062c\u064a\u0627,Gruzija,Gruzie,\u0393\u03b5\u03c9\u03c1\u03b3\u03af\u03b1,\u05d2\u05d0\u05d5\u05e8\u05d2\u05d9\u05d4,Georgia,Gruz\u00ednsko,\u0e08\u0e2d\u0e23\u0e4c\u0e40\u0e08\u0e35\u0e22,Georgia,Georgia,Ge\u00f2rgia,Gr\u00fazia,Gru-di-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.IL, "il,\u4ee5\u8272\u5217,Israel,Isra\u00ebl,Israel,\u30a4\u30b9\u30e9\u30a8\u30eb,Isra\u00ebl,Israele,Israel,Israel,Israel,Israel,Israel,Israel,Israel,\uc774\uc2a4\ub77c\uc5d8,\u4ee5\u8272\u5217,\u0418\u0437\u0440\u0430\u0438\u042c\u044c,Izrael,\u0130srail,\u0406\u0437\u0440\u0430\u0457\u042c\u044c,\u0625\u0633\u0631\u0627\u0626\u064a\u0644,Izrael,Izrael,\u0399\u03c3\u03c1\u03b1\u03ae\u03bb,\u05d9\u05e9\u05e8\u05d0\u05dc,Israel,Izrael,\u0e2d\u0e34\u0e2a\u0e23\u0e32\u0e40\u0e2d\u0e25,Israel,Israel,Israel,Izrael,I-xra-en".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.IQ, "iq,\u4f0a\u62c9\u514b,Iraq,Irak,Irak,\u30a4\u30e9\u30af,Irak,Iraq,Iraq,Iraque,Iraque,Irak,Irak,Irak,Irak,\uc774\ub77c\ud06c,\u4f0a\u62c9\u514b,\u0418\u0440\u0430\u043a,Irak,Irak,\u0406\u0440\u0430\u043a,\u0627\u0644\u0639\u0631\u0627\u0642,Irak,Ir\u00e1k,\u0399\u03c1\u03ac\u03ba,\u05e2\u05d9\u05e8\u05d0\u05e7,Irak,Irak,\u0e2d\u0e34\u0e23\u0e31\u0e01,Iraq,Iraq,Iraq,Irak,I-r\u1eafc".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.JO, "jo,\u7d04\u65e6,Jordan,Jordanie,Jordanien,\u30e8\u30eb\u30c0\u30f3,Jordani\u00eb,Giordania,Jordania,Jord\u00e2nia,Jord\u00e2nia,Jordan,Jordania,Jordan,Jordanien,\uc694\ub974\ub2e8,\u7ea6\u65e6,\u0418\u043e\u0440\u0434\u0430\u043d\u0438\u044f,Jordania,\u00dcrd\u00fcn,\u0419\u043e\u0440\u0434\u0430\u043d\u0456\u044f,\u0627\u0644\u0623\u0631\u062f\u0646,Jordan,Jord\u00e1nsko,\u0399\u03bf\u03c1\u03b4\u03b1\u03bd\u03af\u03b1,\u05d9\u05e8\u05d3\u05df,Iordania,Jord\u00e1nsko,\u0e08\u0e2d\u0e23\u0e4c\u0e41\u0e14\u0e19,Yordania,Jordan,Jord\u00e0nia,Jord\u00e1nia,Gi\u00f3c-\u0111a-ni".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.KW, "kw,\u79d1\u5a01\u7279,Kuwait,Kowe\u00eft,Kuwait,\u30af\u30a6\u30a7\u30fc\u30c8,Koeweit,Kuwait,Kuwait,Kuwait,Kuwait,Kuwait,Kuwait,Kuwait,Kuwait,\ucfe0\uc6e8\uc774\ud2b8,\u79d1\u5a01\u7279,\u041a\u0443\u0432\u0435\u0439\u0442,Kuwejt,Kuveyt,\u041a\u0443\u0432\u0435\u0439\u0442,\u0627\u0644\u0643\u0648\u064a\u062a,Kuvajt,Kuvajt,\u039a\u03bf\u03c5\u03b2\u03ad\u03b9\u03c4,\u05db\u05d5\u05d5\u05d9\u05ea,Kuweit,Kuvajt,\u0e04\u0e39\u0e40\u0e27\u0e15,Kuwait,Kuwait,Kuwait,Kuvait,C\u00f4-o\u00e9t".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.LB, "lb,\u9ece\u5df4\u5ae9,Lebanon,Liban,Libanon,\u30ec\u30d0\u30ce\u30f3,Libanon,Libano,L\u00edbano,L\u00edbano,L\u00edbano,Libanon,Libanon,Libanon,Libanon,\ub808\ubc14\ub17c,\u9ece\u5df4\u5ae9,\u041b\u0438\u0432\u0430\u043d,Liban,L\u00fcbnan,\u041b\u0456\u0432\u0430\u043d,\u0644\u0628\u0646\u0627\u0646,Libanon,Libanon,\u039b\u03af\u03b2\u03b1\u03bd\u03bf\u03c2,\u05dc\u05d1\u05e0\u05d5\u05df,Liban,Libanon,\u0e40\u0e25\u0e1a\u0e32\u0e19\u0e2d\u0e19,Lebanon,Lebanon,L\u00edban,Libanon,Li-b\u0103ng".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.OM, "om,\u963f\u66fc\u738b\u570b,Oman,Oman,Oman,\u30aa\u30de\u30fc\u30f3,Oman,Oman,Om\u00e1n,Om\u00e3,Om\u00e3,Oman,Oman,Oman,Oman,\uc624\ub9cc,\u963f\u66fc,\u041e\u043c\u0430\u043d,Oman,Umman,\u041e\u043c\u0430\u043d,\u0639\u064f\u0645\u0627\u0646,Oman,Om\u00e1n,\u0390\u03bc\u03ac\u03bd,\u05e2\u05d5\u05de\u05d0\u05df,Oman,Om\u00e1n,\u0e42\u0e2d\u0e21\u0e32\u0e19,Oman,Oman,Oman,Om\u00e1n,\u00d4-man".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.QA, "qa,\u5361\u9054,Qatar,Qatar,Katar,\u30ab\u30bf\u30fc\u30eb,Qatar,Qatar,Qatar,Catar,Catar,Qatar,Qatar,Qatar,Qatar,\uce74\ud0c0\ub974,\u5361\u5854\u5c14,\u041a\u0430\u0442\u0430\u0440,Katar,Katar,\u041a\u0430\u0442\u0430\u0440,\u0642\u0637\u0631,Katar,Katar,\u039a\u03b1\u03c4\u03ac\u03c1,\u05e7\u05d8\u05d0\u05e8,Qatar,Katar,\u0e01\u0e32\u0e15\u0e32\u0e23\u0e4c,Qatar,Qatar,Qatar,Katar,Ca-ta".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.SA, "sa,\u6c99\u70cf\u5730\u963f\u62c9\u4f2f,Saudi Arabia,Arabie saoudite,Saudi-Arabien,\u30b5\u30a6\u30b8\u30a2\u30e9\u30d3\u30a2,Saoedi-Arabi\u00eb,Arabia Saudita,Arabia Saud\u00ed,Ar\u00e1bia Saudita,Ar\u00e1bia Saudita,Saudi-Arabien,Saudi-Arabia,Saudi-Arabia,Saudiarabien,\uc0ac\uc6b0\ub514\uc544\ub77c\ube44\uc544,\u6c99\u7279\u963f\u62c9\u4f2f,\u0421\u0430\u0443\u0434\u043e\u0432\u0441\u043a\u0430\u044f \u0410\u0440\u0430\u0432\u0438\u044f,Arabia Saudyjska,Suudi Arabistan,\u0421\u0430\u0443\u0434\u0456\u0432\u0441\u044c\u043a\u0430 \u0410\u0440\u0430\u0432\u0456\u044f,\u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629,Saudijska Arabija,Sa\u00fadsk\u00e1 Ar\u00e1bie,\u03a3\u03b1\u03bf\u03c5\u03b4\u03b9\u03ba\u03ae \u0391\u03c1\u03b1\u03b2\u03af\u03b1,\u05e2\u05e8\u05d1 \u05d4\u05e1\u05e2\u05d5\u05d3\u05d9\u05ea,Arabia Saudit\u0103,Saudsk\u00e1 Ar\u00e1bia,\u0e0b\u0e32\u0e2d\u0e38\u0e14\u0e35\u0e2d\u0e32\u0e23\u0e30\u0e40\u0e1a\u0e35\u0e22,Arab Saudi,Saudi Arabia,Ar\u00e0bia Saudita,Sza\u00fad-Ar\u00e1bia,A-r\u1eadp X\u00ea-\u00fat".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.SY, "sy,\u6558\u5229\u4e9e,Syria,Syrie,Syrien,\u30b7\u30ea\u30a2,Syri\u00eb,Siria,Siria,S\u00edria,S\u00edria,Syrien,Syyria,Syria,Syrien,\uc2dc\ub9ac\uc544,\u53d9\u5229\u4e9a,\u0421\u0438\u0440\u0438\u044f,Syria,Suriye,\u0421\u0438\u0440\u0456\u044f,\u0633\u0648\u0631\u064a\u0627,Sirija,S\u00fdrie,\u03a3\u03c5\u03c1\u03af\u03b1,\u05e1\u05d5\u05e8\u05d9\u05d4,Siria,S\u00fdrska arabsk\u00e1 republika,\u0e0b\u0e35\u0e40\u0e23\u0e35\u0e22,Syria,Syria,S\u00edria,Sz\u00edria,Xi-ri".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.TR, "tr,\u571f\u8033\u5176,Turkey,Turquie,T\u00fcrkei,\u30c8\u30eb\u30b3,Turkije,Turchia,Turqu\u00eda,Turquia,Turquia,Tyrkiet,Turkki,Tyrkia,Turkiet,\ud130\ud0a4,\u571f\u8033\u5176,\u0422\u0443\u0440\u0446\u0438\u044f,Turcja,T\u00fcrkiye,\u0422\u0443\u0440\u0435\u0447\u0447\u0438\u043d\u0430,\u062a\u0631\u0643\u064a\u0627,Turska,Turecko,\u03a4\u03bf\u03c5\u03c1\u03ba\u03af\u03b1,\u05d8\u05d5\u05e8\u05e7\u05d9\u05d4,Turcia,Turecko,\u0e15\u0e38\u0e23\u0e01\u0e35,Turkey,Turkey,Turquia,T\u00f6r\u00f6korsz\u00e1g,Th\u1ed5 Nh\u0129 K\u1ef3".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.YE, "ye,\u8449\u9580,Yemen,Y\u00e9men,Jemen,\u30a4\u30a8\u30e1\u30f3,Jemen,Yemen,Yemen,I\u00eamen,I\u00e9men,Yemen,Jemen,Jemen,Jemen,\uc608\uba58,\u4e5f\u95e8,\u0419\u0435\u043c\u0435\u043d,Jemen,Yemen,\u0404\u043c\u0435\u043d,\u0627\u0644\u064a\u0645\u0646,Jemen,Jemen,\u03a5\u03b5\u03bc\u03ad\u03bd\u03b7,\u05ea\u05d9\u05de\u05df,Yemen,Jemen,\u0e40\u0e22\u0e40\u0e21\u0e19,Yaman,Yemen,Iemen,Jemen,Y-\u00ea-men".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.AG, "ag,\u5b89\u5730\u5361\u53ca\u5df4\u5e03\u9054,Antigua and Barbuda,Antigua-et-Barbuda,Antigua und Barbuda,\u30a2\u30f3\u30c6\u30a3\u30b0\u30a2\u30fb\u30d0\u30fc\u30d6\u30fc\u30c0,Antigua en Barbuda,Antigua e Barbuda,Antigua y Barbuda,Ant\u00edgua e Barbuda,Ant\u00edgua e Barbuda,Antigua og Barbuda,Antigua ja Barbuda,Antigua og Barbuda,Antigua och Barbuda,\uc564\ud2f0\uac00 \ubc14\ubd80\ub2e4,\u5b89\u63d0\u74dc\u548c\u5df4\u5e03\u8fbe,\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0438 \u0411\u0430\u0440\u0431\u0443\u0434\u0430,Antigua i Barbuda,Antigua ve Barbuda,\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0456 \u0411\u0430\u0440\u0431\u0443\u0434\u0430,\u0623\u0646\u062a\u064a\u063a\u0648\u0627 \u0648\u0628\u0631\u0628\u0648\u062f\u0627,Antigua i Barbuda,Antigua a Barbuda,\u0391\u03bd\u03c4\u03af\u03b3\u03ba\u03bf\u03c5\u03b1 \u03ba\u03b1\u03b9 \u039c\u03c0\u03b1\u03c1\u03bc\u03c0\u03bf\u03cd\u03bd\u03c4\u03b1,\u05d0\u05e0\u05d8\u05d9\u05d2\u05d5\u05d0\u05d4 \u05d5\u05d1\u05e8\u05d1\u05d5\u05d3\u05d4,Antigua \u0219i Barbuda,Antigua a Barbados,\u0e41\u0e2d\u0e19\u0e15\u0e34\u0e01\u0e32\u0e41\u0e25\u0e30\u0e1a\u0e32\u0e23\u0e4c\u0e1a\u0e39\u0e14\u0e32,Antigua dan Barbuda,Antigua and Barbuda,Antigua i Barbuda,Antigua \u00e9s Barbuda,An-ti-gu-a v\u00e0 Ba-bu-\u0111a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.BB, "bb,\u5df4\u8c9d\u591a,Barbados,Barbade,Barbados,\u30d0\u30eb\u30d0\u30c9\u30b9,Barbados,Barbados,Barbados,Barbados,Barbados,Barbados,Barbados,Barbados,Barbados,\ubc14\ubca0\uc774\ub3c4\uc2a4,\u5df4\u5df4\u591a\u65af,\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441,Barbados,Barbados,\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441,\u0628\u0631\u0628\u0627\u062f\u0648\u0633,Barbados,Barbados,\u039c\u03c0\u03b1\u03c1\u03bc\u03c0\u03ac\u03bd\u03c4\u03bf\u03c2,\u05d1\u05e8\u05d1\u05d3\u05d5\u05e1,Barbados,Barbados,\u0e1a\u0e32\u0e23\u0e4c\u0e40\u0e1a\u0e42\u0e14\u0e2a,Barbados,Barbados,Barbados,Barbados,B\u00e1c-ba-\u0111\u1ed1t".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.BS, "bs,\u5df4\u54c8\u99ac,Bahamas,Bahamas,Bahamas,\u30d0\u30cf\u30de,Bahama\u2019s,Bahamas,Bahamas,Bahamas,Baamas,Bahamas,Bahama,Bahamas,Bahamas,\ubc14\ud558\ub9c8,\u5df4\u54c8\u9a6c,\u0411\u0430\u0433\u0430\u043c\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430,Bahamy,Bahamalar,\u0411\u0430\u0433\u0430\u043c\u0438,\u0627\u0644\u0628\u0627\u0647\u0627\u0645\u0627,Bahami,Bahamy,\u039c\u03c0\u03b1\u03c7\u03ac\u03bc\u03b5\u03c2,\u05d0\u05d9\u05d9 \u05d1\u05d4\u05d0\u05de\u05d4,Bahamas,Bahamy,\u0e1a\u0e32\u0e2e\u0e32\u0e21\u0e32\u0e2a,Bahama,Bahamas,Bahames,Bahama-szigetek,Ba-ha-ma".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.CU, "cu,\u53e4\u5df4,Cuba,Cuba,Kuba,\u30ad\u30e5\u30fc\u30d0,Cuba,Cuba,Cuba,Cuba,Cuba,Cuba,Kuuba,Cuba,Kuba,\ucfe0\ubc14,\u53e4\u5df4,\u041a\u0443\u0431\u0430,Kuba,K\u00fcba,\u041a\u0443\u0431\u0430,\u0643\u0648\u0628\u0627,Kuba,Kuba,\u039a\u03bf\u03cd\u03b2\u03b1,\u05e7\u05d5\u05d1\u05d4,Cuba,Kuba,\u0e04\u0e34\u0e27\u0e1a\u0e32,Kuba,Cuba,Cuba,Kuba,Cu Ba".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.DM, "dm,\u591a\u660e\u5c3c\u52a0,Dominica,Dominique,Dominica,\u30c9\u30df\u30cb\u30ab\u56fd,Dominica,Dominica,Dominica,Dominica,Dominica,Dominica,Dominica,Dominica,Dominica,\ub3c4\ubbf8\ub2c8\uce74,\u591a\u7c73\u5c3c\u52a0,\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430,Dominika,Dominika,\u0414\u043e\u043c\u0456\u043d\u0456\u043a,\u062f\u0648\u0645\u064a\u0646\u064a\u0643\u0627,Dominika,Dominika,\u039d\u03c4\u03bf\u03bc\u03af\u03bd\u03b9\u03ba\u03b1,\u05d3\u05d5\u05de\u05d9\u05e0\u05d9\u05e7\u05d4,Dominica,Dominika,\u0e42\u0e14\u0e21\u0e34\u0e19\u0e34\u0e01\u0e32,Dominika,Dominica,Dominica,Dominika,\u591a\u660e\u5c3c\u52a0".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.DO, "do,\u591a\u660e\u5c3c\u52a0\u5171\u548c\u570b,Dominican Republic,R\u00e9publique dominicaine,Dominikanische Republik,\u30c9\u30df\u30cb\u30ab\u5171\u548c\u56fd,Dominicaanse Republiek,Repubblica Dominicana,Rep\u00fablica Dominicana,Rep\u00fablica Dominicana,Rep\u00fablica Dominicana,Den Dominikanske Republik,Dominikaaninen tasavalta,Den dominikanske republikk,Dominikanska republiken,\ub3c4\ubbf8\ub2c8\uce74 \uacf5\ud654\uad6d,\u591a\u7c73\u5c3c\u52a0\u5171\u548c\u56fd,\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u042c\u0438\u043a\u0430,Republika Dominika\u0144ska,Dominik Cumhuriyeti,\u0414\u043e\u043c\u0456\u043d\u0456\u043a\u0430\u043d\u0441\u044c\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u042c\u0456\u043a\u0430,\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u062f\u0648\u0645\u064a\u0646\u064a\u0643,Dominikanska Republika,Dominik\u00e1nsk\u00e1 republika,\u0394\u03bf\u03bc\u03b9\u03bd\u03b9\u03ba\u03b1\u03bd\u03ae \u0394\u03b7\u03bc\u03bf\u03ba\u03c1\u03b1\u03c4\u03af\u03b1,\u05d4\u05e8\u05e4\u05d5\u05d1\u05dc\u05d9\u05e7\u05d4 \u05d4\u05d3\u05d5\u05de\u05d9\u05e0\u05d9\u05e7\u05e0\u05d9\u05ea,Republica Dominican\u0103,Dominik\u00e1nska republika,\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e42\u0e14\u0e21\u0e34\u0e19\u0e34\u0e01\u0e31\u0e19,Republik Dominika,Dominican Republic,Rep\u00fablica Dominicana,Dominikai K\u00f6zt\u00e1rsas\u00e1g,C\u1ed9ng ho\u00e0 \u0110\u00f4-mi-ni-ca".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.GD, "gd,\u683c\u745e\u7d0d\u9054,Grenada,Grenade,Grenada,\u30b0\u30ec\u30ca\u30c0,Grenada,Grenada,Granada,Granada,Granada,Grenada,Grenada,Grenada,Grenada,\uadf8\ub808\ub098\ub2e4,\u683c\u6797\u7eb3\u8fbe,\u0413\u0440\u0435\u043d\u0430\u0434\u0430,Grenada,Grenada,\u0413\u0440\u0435\u043d\u0430\u0434\u0430,\u062c\u0631\u064a\u0646\u0627\u062f\u0627,Grenada,Grenada,\u0393\u03c1\u03b5\u03bd\u03ac\u03b4\u03b1,\u05d2\u05e8\u05e0\u05d3\u05d4,Grenada,Grenada,\u0e40\u0e01\u0e23\u0e40\u0e19\u0e14\u0e32,Grenada,Grenada,Grenada,Grenada,Gr\u00ea-na-\u0111a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.HT, "ht,\u6d77\u5730,Haiti,Ha\u00efti,Haiti,\u30cf\u30a4\u30c1,Ha\u00efti,Haiti,Hait\u00ed,Haiti,Haiti,Haiti,Haiti,Haiti,Haiti,\uc544\uc774\ud2f0,\u6d77\u5730,\u0413\u0430\u0438\u0442\u0438,Haiti,Haiti,\u0413\u0430\u0457\u0442\u0456,\u0647\u0627\u064a\u062a\u064a,Haiti,Haiti,\u0391\u03ca\u03c4\u03ae,\u05d4\u05d0\u05d9\u05d8\u05d9,Haiti,Haiti,\u0e40\u0e2e\u0e15\u0e34,Haiti,Haiti,Hait\u00ed,Haiti,Ha-i-ti".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.JM, "jm,\u7259\u8cb7\u52a0,Jamaica,Jama\u00efque,Jamaika,\u30b8\u30e3\u30de\u30a4\u30ab,Jamaica,Giamaica,Jamaica,Jamaica,Jamaica,Jamaica,Jamaika,Jamaica,Jamaica,\uc790\uba54\uc774\uce74,\u7259\u4e70\u52a0,\u042f\u043c\u0430\u0439\u043a\u0430,Jamajka,Jamaika,\u042f\u043c\u0430\u0439\u043a\u0430,\u062c\u0627\u0645\u0627\u064a\u0643\u0627,Jamajka,Jamajka,\u03a4\u03b6\u03b1\u03bc\u03ac\u03b9\u03ba\u03b1,\u05d2\u05f3\u05de\u05d9\u05d9\u05e7\u05d4,Jamaica,Jamajka,\u0e08\u0e32\u0e40\u0e21\u0e01\u0e32,Jamaika,Jamaica,Jamaica,Jamaica,Ha-mai-ca".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.KY, "ky,\u958b\u66fc\u7fa4\u5cf6,Cayman Islands,\u00celes Ca\u00efmans,Kaimaninseln,\u30b1\u30a4\u30de\u30f3\u8af8\u5cf6,Caymaneilanden,Isole Cayman,Islas Caim\u00e1n,Ilhas Caiman,Ilhas Caim\u00e3o,Cayman\u00f8erne,Caymansaaret,Cayman\u00f8yene,Cayman\u00f6arna,\ucf00\uc774\ub9e8\uc81c\ub3c4,\u5f00\u66fc\u7fa4\u5c9b,\u041a\u0430\u0439\u043c\u0430\u043d\u043e\u0432\u044b \u043e\u0441\u0442\u0440\u043e\u0432\u0430,Kajmany,Cayman Adalar\u0131,\u041a\u0430\u0439\u043c\u0430\u043d\u043e\u0432\u0456 \u043e\u0441\u0442\u0440\u043e\u0432\u0438,\u062c\u0632\u0631 \u0627\u0644\u0643\u0627\u064a\u0645\u0646,Kajmanski Otoci,Kajmansk\u00e9 ostrovy,\u039d\u03ae\u03c3\u03bf\u03b9 \u039a\u03ad\u03b9\u03bc\u03b1\u03bd,\u05d0\u05d9\u05d9 \u05e7\u05d9\u05d9\u05de\u05df,Insulele Cayman,Kajmansk\u00e9 ostrovy,\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e40\u0e04\u0e22\u0e4c\u0e41\u0e21\u0e19,Kepulauan Kayman,Cayman Islands,Illes Caiman,Kajm\u00e1n-szigetek,Qu\u1ea7n \u0110\u1ea3o Cayman".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.LC, "lc,\u8056\u9732\u897f\u4e9e,Saint Lucia,Sainte-Lucie,St. Lucia,\u30bb\u30f3\u30c8\u30eb\u30b7\u30a2,Saint Lucia,Saint Lucia,Santa Luc\u00eda,Santa L\u00facia,Santa L\u00facia,Saint Lucia,Saint Lucia,St. Lucia,S:t Lucia,\uc138\uc778\ud2b8\ub8e8\uc2dc\uc544,\u5723\u5362\u897f\u4e9a,\u0421\u0435\u043d\u0442-\u041b\u044e\u0441\u0438\u044f,Saint Lucia,Saint Lucia,\u0421\u0435\u043d\u0442-\u041b\u044e\u0441\u0456\u044f,\u0633\u0627\u0646\u062a \u0644\u0648\u0633\u064a\u0627,Sveta Lucija,Svat\u00e1 Lucie,\u0391\u03b3\u03af\u03b1 \u039b\u03bf\u03c5\u03ba\u03af\u03b1,\u05e1\u05e0\u05d8 \u05dc\u05d5\u05e1\u05d9\u05d4,Sf\u00e2nta Lucia,Sv\u00e4t\u00e1 Lucia,\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e25\u0e39\u0e40\u0e0b\u0e35\u0e22,Saint Lucia,Saint Lucia,Saint Lucia,Santa Lucia,Xan Lu-xi".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.TT, "tt,\u5343\u91cc\u9054\u53ca\u6258\u5df4\u54e5,Trinidad and Tobago,Trinit\u00e9-et-Tobago,Trinidad und Tobago,\u30c8\u30ea\u30cb\u30c0\u30fc\u30c9\u30fb\u30c8\u30d0\u30b4,Trinidad en Tobago,Trinidad e Tobago,Trinidad y Tobago,Trinidad e Tobago,Trindade e Tobago,Trinidad og Tobago,Trinidad ja Tobago,Trinidad og Tobago,Trinidad och Tobago,\ud2b8\ub9ac\ub2c8\ub2e4\ub4dc \ud1a0\ubc14\uace0,\u7279\u7acb\u5c3c\u8fbe\u548c\u591a\u5df4\u54e5,\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0438 \u0422\u043e\u0431\u0430\u0433\u043e,Trynidad i Tobago,Trinidad ve Tobago,\u0422\u0440\u0438\u043d\u0456\u0434\u0430\u0434 \u0456 \u0422\u043e\u0431\u0430\u0433\u043e,\u062a\u0631\u064a\u0646\u064a\u062f\u0627\u062f \u0648\u062a\u0648\u0628\u0627\u063a\u0648,Trinidad i Tobago,Trinidad a Tobago,\u03a4\u03c1\u03b9\u03bd\u03b9\u03bd\u03c4\u03ac\u03bd\u03c4 \u03ba\u03b1\u03b9 \u03a4\u03bf\u03bc\u03c0\u03ac\u03b3\u03ba\u03bf,\u05d8\u05e8\u05d9\u05e0\u05d9\u05d3\u05d3 \u05d5\u05d8\u05d5\u05d1\u05d2\u05d5,Trinidad-Tobago,Trinidad a Tobago,\u0e15\u0e23\u0e34\u0e19\u0e34\u0e41\u0e14\u0e14\u0e41\u0e25\u0e30\u0e42\u0e15\u0e40\u0e1a\u0e42\u0e01,Trinidad dan Tobago,Trinidad and Tobago,Trinitat i Tobago,Trinidad \u00e9s Tobago,Tri-ni-\u0111\u00e1t v\u00e0 T\u00f4-ba-g\u00f4".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.VC, "vc,\u8056\u6587\u68ee\u53ca\u683c\u745e\u90a3\u4e01,Saint Vincent and the Grenadines,Saint-Vincent-et-les Grenadines,St. Vincent und die Grenadinen,\u30bb\u30f3\u30c8\u30d3\u30f3\u30bb\u30f3\u30c8\u30fb\u30b0\u30ec\u30ca\u30c7\u30a3\u30fc\u30f3\u8af8\u5cf6,Saint Vincent en de Grenadines,Saint Vincent e Grenadines,San Vicente y las Granadinas,S\u00e3o Vicente e Granadinas,S\u00e3o Vicente e Granadinas,St. Vincent og Grenadinerne,Saint Vincent ja Grenadiinit,St. Vincent og Grenadinene,S:t Vincent och Grenadinerna,\uc138\uc778\ud2b8\ube48\uc13c\ud2b8\uadf8\ub808\ub098\ub518,\u5723\u6587\u68ee\u7279\u548c\u683c\u6797\u7eb3\u4e01\u65af,\u0421\u0435\u043d\u0442-\u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u0438 \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d\u044b,Saint Vincent i Grenadyny,Saint Vincent ve Grenadinler,\u0421\u0435\u043d\u0442-\u0412\u0456\u043d\u0441\u0435\u043d\u0442 \u0456 \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d\u0438,\u0633\u0627\u0646\u062a \u0641\u0646\u0633\u0646\u062a \u0648\u063a\u0631\u0646\u0627\u062f\u064a\u0646,Sveti Vincent i Grenadini,Svat\u00fd Vincent a Grenadiny,\u0386\u03b3\u03b9\u03bf\u03c2 \u0392\u03b9\u03ba\u03ad\u03bd\u03c4\u03b9\u03bf\u03c2 \u03ba\u03b1\u03b9 \u0393\u03c1\u03b5\u03bd\u03b1\u03b4\u03af\u03bd\u03b5\u03c2,\u05e1\u05e0\u05d8 \u05d5\u05d9\u05e0\u05e1\u05e0\u05d8 \u05d5\u05d4\u05d2\u05e8\u05e0\u05d3\u05d9\u05e0\u05d9\u05dd,Sf\u00e2ntul Vincent \u0219i Grenadine,Sv\u00e4t\u00fd Vincent a Grenad\u00edny,\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e27\u0e34\u0e19\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e41\u0e25\u0e30\u0e40\u0e01\u0e23\u0e19\u0e32\u0e14\u0e35\u0e19\u0e2a\u0e4c,Saint Vincent dan Grenadines,Saint Vincent and the Grenadines,Saint Vincent i les Grenadines,Saint Vincent \u00e9s a Grenadine-szigetek,Xan Vin-xen v\u00e0 Gr\u00ea-na-din".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.AD, "ad,\u5b89\u9053\u723e,Andorra,Andorre,Andorra,\u30a2\u30f3\u30c9\u30e9,Andorra,Andorra,Andorra,Andorra,Andorra,Andorra,Andorra,Andorra,Andorra,\uc548\ub3c4\ub77c,\u5b89\u9053\u5c14,\u0410\u043d\u0434\u043e\u0440\u0440\u0430,Andora,Andorra,\u0410\u043d\u0434\u043e\u0440\u0440\u0430,\u0623\u0646\u062f\u0648\u0631\u0627,Andora,Andorra,\u0391\u03bd\u03b4\u03cc\u03c1\u03b1,\u05d0\u05e0\u05d3\u05d5\u05e8\u05d4,Andorra,Andorra,\u0e2d\u0e31\u0e19\u0e14\u0e2d\u0e23\u0e4c\u0e23\u0e32,Andora,Andorra,Andorra,Andorra,Andorra".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.AL, "al,\u963f\u723e\u5df4\u5c3c\u4e9e,Albania,Albanie,Albanien,\u30a2\u30eb\u30d0\u30cb\u30a2,Albani\u00eb,Albania,Albania,Alb\u00e2nia,Alb\u00e2nia,Albanien,Albania,Albania,Albanien,\uc54c\ubc14\ub2c8\uc544,\u963f\u5c14\u5df4\u5c3c\u4e9a,\u0410\u042c\u0431\u0430\u043d\u0438\u044f,Albania,Arnavutluk,\u0410\u042c\u0431\u0430\u043d\u0456\u044f,\u0623\u0644\u0628\u0627\u0646\u064a\u0627,Albanija,Alb\u00e1nie,\u0391\u03bb\u03b2\u03b1\u03bd\u03af\u03b1,\u05d0\u05dc\u05d1\u05e0\u05d9\u05d4,Albania,Alb\u00e1nsko,\u0e41\u0e2d\u0e25\u0e40\u0e1a\u0e40\u0e19\u0e35\u0e22,Albania,Albania,Alb\u00e0nia,Alb\u00e1nia,An-ba-ni".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.AT, "at,\u5967\u5730\u5229,Austria,Autriche,\u00d6sterreich,\u30aa\u30fc\u30b9\u30c8\u30ea\u30a2,Oostenrijk,Austria,Austria,\u00c1ustria,\u00c1ustria,\u00d8strig,It\u00e4valta,\u00d8sterrike,\u00d6sterrike,\uc624\uc2a4\ud2b8\ub9ac\uc544,\u5965\u5730\u5229,\u0410\u0432\u0441\u0442\u0440\u0438\u044f,Austria,Avusturya,\u0410\u0432\u0441\u0442\u0440\u0456\u044f,\u0627\u0644\u0646\u0645\u0633\u0627,Austrija,Rakousko,\u0391\u03c5\u03c3\u03c4\u03c1\u03af\u03b1,\u05d0\u05d5\u05e1\u05d8\u05e8\u05d9\u05d4,Austria,Rak\u00fasko,\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e35\u0e22,Austria,Austria,\u00c0ustria,Ausztria,\u00c1o".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.BA, "ba,\u6ce2\u58eb\u5c3c\u4e9e\u8207\u8d6b\u585e\u683c\u7dad\u7d0d,Bosnia and Herzegovina,Bosnie-Herz\u00e9govine,Bosnien und Herzegowina,\u30dc\u30b9\u30cb\u30a2\u30fb\u30d8\u30eb\u30c4\u30a7\u30b4\u30d3\u30ca,Bosni\u00eb en Herzegovina,Bosnia Erzegovina,Bosnia-Herzegovina,B\u00f3snia-Herzegovina,B\u00f3snia-Herzegovina,Bosnien-Hercegovina,Bosnia ja Hertsegovina,Bosnia-Hercegovina,Bosnien och Hercegovina,\ubcf4\uc2a4\ub2c8\uc544 \ud5e4\ub974\uccb4\uace0\ube44\ub098,\u6ce2\u65af\u5c3c\u4e9a\u548c\u9ed1\u585e\u54e5\u7ef4\u90a3,\u0411\u043e\u0441\u043d\u0438\u044f \u0438 \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430,Bo\u015bnia i Hercegowina,Bosna Hersek,\u0411\u043e\u0441\u043d\u0456\u044f \u0456 \u0413\u0435\u0440\u0446\u043e\u0433\u043e\u0432\u0438\u043d\u0430,\u0627\u0644\u0628\u0648\u0633\u0646\u0629 \u0648\u0627\u0644\u0647\u0631\u0633\u0643,Bosna i Hercegovina,Bosna a Hercegovina,\u0392\u03bf\u03c3\u03bd\u03af\u03b1 - \u0395\u03c1\u03b6\u03b5\u03b3\u03bf\u03b2\u03af\u03bd\u03b7,\u05d1\u05d5\u05e1\u05e0\u05d9\u05d4 \u05d5\u05d4\u05e8\u05e6\u05d2\u05d5\u05d1\u05d9\u05e0\u05d4,Bosnia \u0219i Her\u021begovina,Bosna a Hercegovina,\u0e1a\u0e2d\u0e2a\u0e40\u0e19\u0e35\u0e22\u0e41\u0e25\u0e30\u0e40\u0e2e\u0e2d\u0e23\u0e4c\u0e40\u0e0b\u0e42\u0e01\u0e27\u0e35\u0e19\u0e32,Bosnia dan Herzegovina,Bosnia and Herzegovina,B\u00f2snia i Hercegovina,Bosznia-Hercegovina,B\u00f4-xni-a H\u00e9c-x\u00ea-g\u00f4-vi-na".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.BE, "be,\u6bd4\u5229\u6642,Belgium,Belgique,Belgien,\u30d9\u30eb\u30ae\u30fc,Belgi\u00eb,Belgio,B\u00e9lgica,B\u00e9lgica,B\u00e9lgica,Belgien,Belgia,Belgia,Belgien,\ubca8\uae30\uc5d0,\u6bd4\u5229\u65f6,\u0411\u0435\u042c\u044c\u0433\u0438\u044f,Belgia,Bel\u00e7ika,\u0411\u0435\u042c\u044c\u0433\u0456\u044f,\u0628\u0644\u062c\u064a\u0643\u0627,Belgija,Belgie,\u0392\u03ad\u03bb\u03b3\u03b9\u03bf,\u05d1\u05dc\u05d2\u05d9\u05d4,Belgia,Belgicko,\u0e40\u0e1a\u0e25\u0e40\u0e22\u0e35\u0e22\u0e21,Belgia,Belgium,B\u00e8lgica,Belgium,B\u1ec9".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.BG, "bg,\u4fdd\u52a0\u5229\u4e9e,Bulgaria,Bulgarie,Bulgarien,\u30d6\u30eb\u30ac\u30ea\u30a2,Bulgarije,Bulgaria,Bulgaria,Bulg\u00e1ria,Bulg\u00e1ria,Bulgarien,Bulgaria,Bulgaria,Bulgarien,\ubd88\uac00\ub9ac\uc544,\u4fdd\u52a0\u5229\u4e9a,\u0411\u043e\u042c\u0433\u0430\u0440\u0438\u044f,Bu\u0142garia,Bulgaristan,\u0411\u043e\u042c\u0433\u0430\u0440\u0456\u044f,\u0628\u0644\u063a\u0627\u0631\u064a\u0627,Bugarska,Bulharsko,\u0392\u03bf\u03c5\u03bb\u03b3\u03b1\u03c1\u03af\u03b1,\u05d1\u05d5\u05dc\u05d2\u05e8\u05d9\u05d4,Bulgaria,Bulharsko,\u0e1a\u0e31\u0e25\u0e41\u0e01\u0e40\u0e23\u0e35\u0e22,Bulgaria,Bulgaria,Bulg\u00e0ria,Bulg\u00e1ria,Bun-ga-ri".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.BY, "by,\u767d\u4fc4\u7f85\u65af,Belarus,Bi\u00e9lorussie,Wei\u00dfrussland,\u30d9\u30e9\u30eb\u30fc\u30b7,Wit-Rusland,Bielorussia,Bielorrusia,Belarus,Bielorr\u00fassia,Hviderusland,Valko-Ven\u00e4j\u00e4,Hviterussland,Vitryssland,\ubca8\ub77c\ub8e8\uc2a4,\u767d\u4fc4\u7f57\u65af,\u0411\u0435\u042c\u0430\u0440\u0443\u0441\u044c,Bia\u0142oru\u015b,Beyaz Rusya,\u0411\u0456\u042c\u043e\u0440\u0443\u0441\u044c,\u0631\u0648\u0633\u064a\u0627 \u0627\u0644\u0628\u064a\u0636\u0627\u0621,Bjelorusija,B\u011blorusko,\u039b\u03b5\u03c5\u03ba\u03bf\u03c1\u03c9\u03c3\u03af\u03b1,\u05d1\u05dc\u05d0\u05e8\u05d5\u05e1,Bielorusia,Bielorusko,\u0e40\u0e1a\u0e25\u0e32\u0e23\u0e38\u0e2a,Belarusia,Belarus,Bielor\u00fassia,Feh\u00e9roroszorsz\u00e1g,B\u00ea-la-r\u00fat".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.CH, "ch,\u745e\u58eb,Switzerland,Suisse,Schweiz,\u30b9\u30a4\u30b9,Zwitserland,Svizzera,Suiza,Su\u00ed\u00e7a,Su\u00ed\u00e7a,Schweiz,Sveitsi,Sveits,Schweiz,\uc2a4\uc704\uc2a4,\u745e\u58eb,\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u044f,Szwajcaria,\u0130svi\u00e7re,\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0456\u044f,\u0633\u0648\u064a\u0633\u0631\u0627,\u0160vicarska,\u0160v\u00fdcarsko,\u0395\u03bb\u03b2\u03b5\u03c4\u03af\u03b1,\u05e9\u05d5\u05d5\u05d9\u05d9\u05e5,Eleve\u021bia,\u0160vaj\u010diarsko,\u0e2a\u0e27\u0e34\u0e15\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c,Swiss,Switzerland,Su\u00efssa,Sv\u00e1jc,Th\u1ee5y S\u0129".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.CY, "cy,\u8cfd\u666e\u52d2\u65af,Cyprus,Chypre,Zypern,\u30ad\u30d7\u30ed\u30b9,Cyprus,Cipro,Chipre,Chipre,Chipre,Cypern,Kypros,Kypros,Cypern,\uc0ac\uc774\ud504\ub7ec\uc2a4,\u585e\u6d66\u8def\u65af,\u041a\u0438\u043f\u0440,Cypr,G\u00fcney K\u0131br\u0131s Rum Kesimi,\u041a\u0456\u043f\u0440,\u0642\u0628\u0631\u0635,Cipar,Kypr,\u039a\u03cd\u03c0\u03c1\u03bf\u03c2,\u05e7\u05e4\u05e8\u05d9\u05e1\u05d9\u05df,Cipru,Cyprus,\u0e44\u0e0b\u0e1b\u0e23\u0e31\u0e2a,Siprus,Cyprus,Xipre,Ciprus,S\u00edp".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.CZ, "cz,\u6377\u514b\u5171\u548c\u570b,Czech Republic,R\u00e9publique tch\u00e8que,Tschechische Republik,\u30c1\u30a7\u30b3\u5171\u548c\u56fd,Tsjechi\u00eb,Repubblica Ceca,Rep\u00fablica Checa,Rep\u00fablica Tcheca,Rep\u00fablica Checa,Tjekkiet,T\u0161ekki,Tsjekkia,Tjeckien,\uccb4\ucf54,\u6377\u514b\u5171\u548c\u56fd,\u0427\u0435\u0445\u0438\u044f,Czechy,\u00c7ek Cumhuriyeti,\u0427\u0435\u0441\u044c\u043a\u0430 \u0440\u0435\u0441\u043f\u0443\u0431\u042c\u0456\u043a\u0430,\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u062a\u0634\u064a\u0643,\u010ce\u0161ka Republika,\u010cesk\u00e1 republika,\u03a4\u03c3\u03b5\u03c7\u03af\u03b1,\u05e6\u05f3\u05db\u05d9\u05d4,Republica Ceh\u0103,\u010cesk\u00e1 republika,\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e40\u0e0a\u0e47\u0e01,Republik Ceko,Czech Republic,Rep\u00fablica Txeca,Csehorsz\u00e1g,C\u1ed9ng h\u00f2a S\u00e9c".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.DE, "de,\u5fb7\u570b,Germany,Allemagne,Deutschland,\u30c9\u30a4\u30c4,Duitsland,Germania,Alemania,Alemanha,Alemanha,Tyskland,Saksa,Tyskland,Tyskland,\ub3c5\uc77c,\u5fb7\u56fd,\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f,Niemcy,Almanya,\u041d\u0456\u043c\u0435\u0447\u0447\u0438\u043d\u0430,\u0623\u0644\u0645\u0627\u0646\u064a\u0627,Njema\u010dka,N\u011bmecko,\u0393\u03b5\u03c1\u03bc\u03b1\u03bd\u03af\u03b1,\u05d2\u05e8\u05de\u05e0\u05d9\u05d4,Germania,Nemecko,\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e19\u0e35,Jerman,Germany,Alemanya,N\u00e9metorsz\u00e1g,\u0110\u1ee9c".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.DK, "dk,\u4e39\u9ea5,Denmark,Danemark,D\u00e4nemark,\u30c7\u30f3\u30de\u30fc\u30af,Denemarken,Danimarca,Dinamarca,Dinamarca,Dinamarca,Danmark,Tanska,Danmark,Danmark,\ub374\ub9c8\ud06c,\u4e39\u9ea6,\u0414\u0430\u043d\u0438\u044f,Dania,Danimarka,\u0414\u0430\u043d\u0456\u044f,\u0627\u0644\u062f\u0627\u0646\u0645\u0631\u0643,Danska,D\u00e1nsko,\u0394\u03b1\u03bd\u03af\u03b1,\u05d3\u05e0\u05de\u05e8\u05e7,Danemarca,D\u00e1nsko,\u0e40\u0e14\u0e19\u0e21\u0e32\u0e23\u0e4c\u0e01,Denmark,Denmark,Dinamarca,D\u00e1nia,\u0110an M\u1ea1ch".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.EE, "ee,\u611b\u6c99\u5c3c\u4e9e,Estonia,Estonie,Estland,\u30a8\u30b9\u30c8\u30cb\u30a2,Estland,Estonia,Estonia,Est\u00f4nia,Est\u00f3nia,Estland,Viro,Estland,Estland,\uc5d0\uc2a4\ud1a0\ub2c8\uc544,\u7231\u6c99\u5c3c\u4e9a,\u042d\u0441\u0442\u043e\u043d\u0438\u044f,Estonia,Estonya,\u0415\u0441\u0442\u043e\u043d\u0456\u044f,\u0627\u0633\u062a\u0648\u0646\u064a\u0627,Estonija,Estonsko,\u0395\u03c3\u03b8\u03bf\u03bd\u03af\u03b1,\u05d0\u05e1\u05d8\u05d5\u05e0\u05d9\u05d4,Estonia,Est\u00f3nsko,\u0e40\u0e2d\u0e2a\u0e42\u0e15\u0e40\u0e19\u0e35\u0e22,Estonia,Estonia,Est\u00f2nia,\u00c9sztorsz\u00e1g,E-xt\u00f4-ni-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.ES, "es,\u897f\u73ed\u7259,Spain,Espagne,Spanien,\u30b9\u30da\u30a4\u30f3,Spanje,Spagna,Espa\u00f1a,Espanha,Espanha,Spanien,Espanja,Spania,Spanien,\uc2a4\ud398\uc778,\u897f\u73ed\u7259,\u0418\u0441\u043f\u0430\u043d\u0438\u044f,Hiszpania,\u0130spanya,\u0406\u0441\u043f\u0430\u043d\u0456\u044f,\u0623\u0633\u0628\u0627\u0646\u064a\u0627,\u0160panjolska,\u0160pan\u011blsko,\u0399\u03c3\u03c0\u03b1\u03bd\u03af\u03b1,\u05e1\u05e4\u05e8\u05d3,Spania,\u0160panielsko,\u0e2a\u0e40\u0e1b\u0e19,Spanyol,Spain,Espanya,Spanyolorsz\u00e1g,T\u00e2y Ban Nha".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.FI, "fi,\u82ac\u862d,Finland,Finlande,Finnland,\u30d5\u30a3\u30f3\u30e9\u30f3\u30c9,Finland,Finlandia,Finlandia,Finl\u00e2ndia,Finl\u00e2ndia,Finland,Suomi,Finland,Finland,\ud540\ub780\ub4dc,\u82ac\u5170,\u0424\u0438\u043d\u042c\u044f\u043d\u0434\u0438\u044f,Finlandia,Finlandiya,\u0424\u0456\u043d\u042c\u044f\u043d\u0434\u0456\u044f,\u0641\u0646\u0644\u0646\u062f\u0627,Finska,Finsko,\u03a6\u03b9\u03bd\u03bb\u03b1\u03bd\u03b4\u03af\u03b1,\u05e4\u05d9\u05e0\u05dc\u05e0\u05d3,Finlanda,F\u00ednsko,\u0e1f\u0e34\u0e19\u0e41\u0e25\u0e19\u0e14\u0e4c,Finlandia,Finland,Finl\u00e0ndia,Finnorsz\u00e1g,Ph\u1ea7n Lan".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.FO, "fo,\u6cd5\u7f85\u7fa4\u5cf6,Faroe Islands,\u00celes F\u00e9ro\u00e9,F\u00e4r\u00f6er,\u30d5\u30a7\u30ed\u30fc\u8af8\u5cf6,Faer\u00f6er,Isole Faroe,Islas Feroe,Ilhas Faroe,Ilhas Faroe,F\u00e6r\u00f8erne,F\u00e4rsaaret,F\u00e6r\u00f8yene,F\u00e4r\u00f6arna,\ud398\ub85c\uc81c\ub3c4,\u6cd5\u7f57\u7fa4\u5c9b,\u0424\u0430\u0440\u0435\u0440\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430,Wyspy Owcze,Faroe Adalar\u0131,\u0424\u0430\u0440\u0435\u0440\u0441\u044c\u043a\u0456 \u043e\u0441\u0442\u0440\u043e\u0432\u0438,\u062c\u0632\u0631 \u0641\u0627\u0631\u0648,Farski Otoci,Faersk\u00e9 ostrovy,\u039d\u03ae\u03c3\u03bf\u03b9 \u03a6\u03b5\u03c1\u03cc\u03b5,\u05d0\u05d9\u05d9 \u05e4\u05d0\u05e8\u05d5,Insulele Feroe,Faersk\u00e9 ostrovy,\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e41\u0e1f\u0e42\u0e23,Kepulauan Faroe,Faroe Islands,Illes F\u00e8roe,Fer\u00f6er-szigetek,Qu\u1ea7n \u0110\u1ea3o Faroe".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.FR, "fr,\u6cd5\u570b,France,France,Frankreich,\u30d5\u30e9\u30f3\u30b9,Frankrijk,Francia,Francia,Fran\u00e7a,Fran\u00e7a,Frankrig,Ranska,Frankrike,Frankrike,\ud504\ub791\uc2a4,\u6cd5\u56fd,\u0424\u0440\u0430\u043d\u0446\u0438\u044f,Francja,Fransa,\u0424\u0440\u0430\u043d\u0446\u0456\u044f,\u0641\u0631\u0646\u0633\u0627,Francuska,Francie,\u0393\u03b1\u03bb\u03bb\u03af\u03b1,\u05e6\u05e8\u05e4\u05ea,Fran\u021ba,Franc\u00fazsko,\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a,Perancis,France,Fran\u00e7a,Franciaorsz\u00e1g,Ph\u00e1p".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.UK, "uk,\u82f1\u570b,United Kingdom,Grande-Bretagne,Vereinigtes K\u00f6nigreich,\u30a4\u30ae\u30ea\u30b9,Verenigd Koninkrijk,Regno Unito,Reino Unido,Reino Unido,Reino Unido,Storbritannien,Britannia,Storbritannia,Storbritannien,\uc601\uad6d,\u82f1\u56fd,\u0412\u0435\u042c\u0438\u043a\u043e\u0431\u0440\u0438\u0442\u0430\u043d\u0438\u044f,Wielka Brytania,Birle\u015fik Krall\u0131k,\u0412\u0435\u042c\u0438\u043a\u043e\u0431\u0440\u0438\u0442\u0430\u043d\u0456\u044f,\u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627\u0644\u0645\u062a\u062d\u062f\u0629,Velika Britanija,Velk\u00e1 Brit\u00e1nie,\u0397\u03bd\u03c9\u03bc\u03ad\u03bd\u03bf \u0392\u03b1\u03c3\u03af\u03bb\u03b5\u03b9\u03bf,\u05d1\u05e8\u05d9\u05d8\u05e0\u05d9\u05d4,Marea Britanie,Spojen\u00e9 kr\u00e1\u013eovstvo,\u0e2a\u0e2b\u0e23\u0e32\u0e0a\u0e2d\u0e32\u0e13\u0e32\u0e08\u0e31\u0e01\u0e23,Inggris Raya,United Kingdom,Regne Unit,Egyes\u00fclt Kir\u00e1lys\u00e1g,V\u01b0\u01a1ng qu\u1ed1c Anh".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.GR, "gr,\u5e0c\u81d8,Greece,Gr\u00e8ce,Griechenland,\u30ae\u30ea\u30b7\u30e3,Griekenland,Grecia,Grecia,Gr\u00e9cia,Gr\u00e9cia,Gr\u00e6kenland,Kreikka,Hellas,Grekland,\uadf8\ub9ac\uc2a4,\u5e0c\u814a,\u0413\u0440\u0435\u0446\u0438\u044f,Grecja,Yunanistan,\u0413\u0440\u0435\u0446\u0456\u044f,\u0627\u0644\u064a\u0648\u0646\u0627\u0646,Gr\u010dka,\u0158ecko,\u0395\u03bb\u03bb\u03ac\u03b4\u03b1,\u05d9\u05d5\u05d5\u05df,Grecia,Gr\u00e9cko,\u0e01\u0e23\u0e35\u0e0b,Yunani,Greece,Gr\u00e8cia,G\u00f6r\u00f6gorsz\u00e1g,Hy L\u1ea1p".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.HR, "hr,\u514b\u7f85\u57c3\u897f\u4e9e,Croatia,Croatie,Kroatien,\u30af\u30ed\u30a2\u30c1\u30a2,Kroati\u00eb,Croazia,Croacia,Cro\u00e1cia,Cro\u00e1cia,Kroatien,Kroatia,Kroatia,Kroatien,\ud06c\ub85c\uc544\ud2f0\uc544,\u514b\u7f57\u5730\u4e9a,\u0425\u043e\u0440\u0432\u0430\u0442\u0438\u044f,Chorwacja,H\u0131rvatistan,\u0425\u043e\u0440\u0432\u0430\u0442\u0456\u044f,\u0643\u0631\u0648\u0627\u062a\u064a\u0627,Hrvatska,Chorvatsko,\u039a\u03c1\u03bf\u03b1\u03c4\u03af\u03b1,\u05e7\u05e8\u05d5\u05d0\u05d8\u05d9\u05d4,Croa\u021bia,Chorv\u00e1tsko,\u0e42\u0e04\u0e23\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22,Kroasia,Croatia,Cro\u00e0cia,Horv\u00e1torsz\u00e1g,Cr\u00f4-a-ti-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.HU, "hu,\u5308\u7259\u5229,Hungary,Hongrie,Ungarn,\u30cf\u30f3\u30ac\u30ea\u30fc,Hongarije,Ungheria,Hungr\u00eda,Hungria,Hungria,Ungarn,Unkari,Ungarn,Ungern,\ud5dd\uac00\ub9ac,\u5308\u7259\u5229,\u0412\u0435\u043d\u0433\u0440\u0438\u044f,W\u0119gry,Macaristan,\u0423\u0433\u043e\u0440\u0449\u0438\u043d\u0430,\u0647\u0646\u063a\u0627\u0631\u064a\u0627,Ma\u0111arska,Ma\u010farsko,\u0390\u03c5\u03b3\u03b3\u03b1\u03c1\u03af\u03b1,\u05d4\u05d5\u05e0\u05d2\u05e8\u05d9\u05d4,Ungaria,Ma\u010farsko,\u0e2e\u0e31\u0e07\u0e01\u0e32\u0e23\u0e35,Hungaria,Hungary,Hongria,Magyarorsz\u00e1g,Hung-ga-ri".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.IE, "ie,\u611b\u723e\u862d,Ireland,Irlande,Irland,\u30a2\u30a4\u30eb\u30e9\u30f3\u30c9,Ierland,Irlanda,Irlanda,Irlanda,Irlanda,Irland,Irlanti,Irland,Irland,\uc544\uc77c\ub79c\ub4dc,\u7231\u5c14\u5170,\u0418\u0440\u042c\u0430\u043d\u0434\u0438\u044f,Irlandia,\u0130rlanda,\u0406\u0440\u042c\u0430\u043d\u0434\u0456\u044f,\u0623\u064a\u0631\u0644\u0646\u062f\u0627,Irska,Irsko,\u0399\u03c1\u03bb\u03b1\u03bd\u03b4\u03af\u03b1,\u05d0\u05d9\u05e8\u05dc\u05e0\u05d3,Irlanda,\u00cdrsko,\u0e44\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c,Irlandia,Ireland,Irlanda,\u00cdrorsz\u00e1g,Ai-len".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.IM, "im,\u66fc\u5cf6,Isle of Man,\u00cele de Man,Isle of Man,\u30de\u30f3\u5cf6,Isle of Man,Isola di Man,Isla de Man,Ilha de Man,Ilha de Man,Isle of Man,Mansaari,Man,Isle of Man,\ub9e8 \uc12c,\u66fc\u5c9b,\u041e\u0441\u0442\u0440\u043e\u0432 \u041c\u044d\u043d,Wyspa Man,Man Adas\u0131,\u041e\u0441\u0442\u0440\u0456\u0432 \u041c\u0435\u043d,\u062c\u0632\u064a\u0631\u0629 \u0645\u0627\u0646,Otok Man,Ostrov Man,\u039d\u03ae\u03c3\u03bf\u03c2 \u039c\u03b1\u03bd,\u05d4\u05d0\u05d9 \u05de\u05d0\u05df,Insula Man,Ostrov Man,\u0e40\u0e01\u0e32\u0e30\u0e41\u0e21\u0e19,\u66fc\u5cf6,Isle of Man,Illa de Man,Man-sziget,\u0110\u1ea3o Man".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.IS, "is,\u51b0\u5cf6,Iceland,Islande,Island,\u30a2\u30a4\u30b9\u30e9\u30f3\u30c9,IJsland,Islanda,Islandia,Isl\u00e2ndia,Isl\u00e2ndia,Island,Islanti,Island,Island,\uc544\uc774\uc2ac\ub780\ub4dc,\u51b0\u5c9b,\u0418\u0441\u042c\u0430\u043d\u0434\u0438\u044f,Islandia,\u0130zlanda,\u0406\u0441\u042c\u0430\u043d\u0434\u0456\u044f,\u0623\u064a\u0633\u0644\u0646\u062f\u0627,Island,Island,\u0399\u03c3\u03bb\u03b1\u03bd\u03b4\u03af\u03b1,\u05d0\u05d9\u05e1\u05dc\u05e0\u05d3,Islanda,Island,\u0e44\u0e2d\u0e0b\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c,Islandia,Iceland,Isl\u00e0ndia,Izland,Ai-x\u01a1-len".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.IT, "it,\u7fa9\u5927\u5229,Italy,Italie,Italien,\u30a4\u30bf\u30ea\u30a2,Itali\u00eb,Italia,Italia,It\u00e1lia,It\u00e1lia,Italien,Italia,Italia,Italien,\uc774\ud0c8\ub9ac\uc544,\u610f\u5927\u5229,\u0418\u0442\u0430\u042c\u0438\u044f,W\u0142ochy,\u0130talya,\u0406\u0442\u0430\u042c\u0456\u044f,\u0627\u064a\u0637\u0627\u0644\u064a\u0627,Italija,It\u00e1lie,\u0399\u03c4\u03b1\u03bb\u03af\u03b1,\u05d0\u05d9\u05d8\u05dc\u05d9\u05d4,Italia,Taliansko,\u0e2d\u0e34\u0e15\u0e32\u0e25\u0e35,Itali,Italy,It\u00e0lia,Olaszorsz\u00e1g,\u00dd".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.LI, "li,\u5217\u652f\u6566\u65af\u767b,Liechtenstein,Liechtenstein,Liechtenstein,\u30ea\u30d2\u30c6\u30f3\u30b7\u30e5\u30bf\u30a4\u30f3,Liechtenstein,Liechtenstein,Liechtenstein,Liechtenstein,Liechtenstein,Liechtenstein,Liechtenstein,Liechtenstein,Liechtenstein,\ub9ac\ud788\ud150\uc288\ud0c0\uc778,\u5217\u652f\u6566\u58eb\u767b,\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d,Liechtenstein,Liechtenstein,\u041b\u0456\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d,\u0644\u064a\u062e\u062a\u0646\u0634\u062a\u0627\u064a\u0646,Lihten\u0161tajn,Lichten\u0161tejnsko,\u039b\u03b9\u03c7\u03c4\u03b5\u03bd\u03c3\u03c4\u03ac\u03b9\u03bd,\u05dc\u05d9\u05db\u05d8\u05e0\u05e9\u05d8\u05d9\u05d9\u05df,Liechtenstein,Lichten\u0161tajnsko,\u0e25\u0e34\u0e01\u0e40\u0e15\u0e19\u0e2a\u0e44\u0e15\u0e19\u0e4c,Liechtenstein,Liechtenstein,Liechtenstein,Liechtenstein,Lich-ten-xt\u00ean".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.LT, "lt,\u7acb\u9676\u5b9b,Lithuania,Lituanie,Litauen,\u30ea\u30c8\u30a2\u30cb\u30a2,Litouwen,Lituania,Lituania,Litu\u00e2nia,Litu\u00e2nia,Litauen,Liettua,Litauen,Litauen,\ub9ac\ud22c\uc544\ub2c8\uc544,\u7acb\u9676\u5b9b,\u041b\u0438\u0442\u0432\u0430,Litwa,Litvanya,\u041b\u0438\u0442\u0432\u0430,\u0644\u064a\u062a\u0648\u0627\u0646\u064a\u0627,Litva,Litva,\u039b\u03b9\u03b8\u03bf\u03c5\u03b1\u03bd\u03af\u03b1,\u05dc\u05d9\u05d8\u05d0,Lituania,Litva,\u0e25\u0e34\u0e17\u0e31\u0e27\u0e40\u0e19\u0e35\u0e22,Lituania,Lithuania,Litu\u00e0nia,Litv\u00e1nia,Li-tu-a-ni-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.LU, "lu,\u76e7\u68ee\u5821,Luxembourg,Luxembourg,Luxemburg,\u30eb\u30af\u30bb\u30f3\u30d6\u30eb\u30b0,Luxemburg,Lussemburgo,Luxemburgo,Luxemburgo,Luxemburgo,Luxembourg,Luxemburg,Luxembourg,Luxemburg,\ub8e9\uc148\ubd80\ub974\ud06c,\u5362\u68ee\u5821,\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433,Luksemburg,L\u00fcksemburg,\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433,\u0644\u0648\u0643\u0633\u0645\u0628\u0648\u0631\u062c,Luksemburg,Lucembursko,\u039b\u03bf\u03c5\u03be\u03b5\u03bc\u03b2\u03bf\u03cd\u03c1\u03b3\u03bf,\u05dc\u05d5\u05e7\u05e1\u05de\u05d1\u05d5\u05e8\u05d2,Luxemburg,Luxembursko,\u0e25\u0e31\u0e01\u0e40\u0e0b\u0e21\u0e40\u0e1a\u0e34\u0e23\u0e4c\u0e01,Luxembourg,Luxembourg,Luxemburg,Luxemburg,L\u00fac-x\u0103m-bua".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.LV, "lv,\u62c9\u812b\u7dad\u4e9e,Latvia,Lettonie,Lettland,\u30e9\u30c8\u30d3\u30a2,Letland,Lettonia,Letonia,Let\u00f4nia,Let\u00f3nia,Letland,Latvia,Latvia,Lettland,\ub77c\ud2b8\ube44\uc544,\u62c9\u8131\u7ef4\u4e9a,\u041b\u0430\u0442\u0432\u0438\u044f,\u0141otwa,Letonya,\u041b\u0430\u0442\u0432\u0456\u044f,\u0644\u0627\u062a\u0641\u064a\u0627,Latvija,Loty\u0161sko,\u039b\u03b5\u03c4\u03bf\u03bd\u03af\u03b1,\u05dc\u05d8\u05d1\u05d9\u05d4,Letonia,Loty\u0161sko,\u0e25\u0e31\u0e15\u0e40\u0e27\u0e35\u0e22,Latvia,Latvia,Let\u00f2nia,Lettorsz\u00e1g,L\u00e1t-vi-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.MC, "mc,\u6469\u7d0d\u54e5,Monaco,Monaco,Monaco,\u30e2\u30ca\u30b3,Monaco,Monaco,M\u00f3naco,M\u00f4naco,M\u00f3naco,Monaco,Monaco,Monaco,Monaco,\ubaa8\ub098\ucf54,\u6469\u7eb3\u54e5,\u041c\u043e\u043d\u0430\u043a\u043e,Monako,Monako,\u041c\u043e\u043d\u0430\u043a\u043e,\u0645\u0648\u0646\u0627\u0643\u0648,Monako,Monako,\u039c\u03bf\u03bd\u03b1\u03ba\u03cc,\u05de\u05d5\u05e0\u05e7\u05d5,Monaco,Monako,\u0e42\u0e21\u0e19\u0e32\u0e42\u0e01,Monaco,Monaco,M\u00f2naco,Monaco,M\u00f4-na-c\u00f4".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.MD, "md,\u6469\u723e\u591a\u74e6,Moldova,Moldavie,Republik Moldau,\u30e2\u30eb\u30c9\u30d0,Moldavi\u00eb,Moldavia,Moldavia,Mold\u00e1via,Mold\u00e1via, Rep\u00fablica da,Republikken Moldova,Moldova,Moldova,Moldavien,\ubab0\ub3c4\ubc14,\u6469\u5c14\u591a\u74e6,\u041c\u043e\u042c\u0434\u043e\u0432\u0430,Mo\u0142dawia,Moldova,\u041c\u043e\u042c\u0434\u043e\u0432\u0430,\u0645\u0648\u0644\u062f\u0627\u0641\u064a\u0627,Moldavija,Moldavsko, republika,\u039c\u03bf\u03bb\u03b4\u03b1\u03b2\u03af\u03b1,\u05de\u05d5\u05dc\u05d3\u05d5\u05d1\u05d4,Republica Moldova,Moldavsko,\u0e21\u0e2d\u0e25\u0e42\u0e14\u0e27\u0e32,Moldova,Moldova,Mold\u00e0via,Moldova,M\u00f4n-\u0111\u00f4-va".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.ME, "me,\u8499\u7279\u5167\u54e5\u7f85,Montenegro,Mont\u00e9n\u00e9gro,Montenegro,\u30e2\u30f3\u30c6\u30cd\u30b0\u30ed,Montenegro,Montenegro,Montenegro,Montenegro,Montenegro,Montenegro,Montenegro,Montenegro,Montenegro,\ubaac\ud14c\ub124\uadf8\ub85c,\u9ed1\u5c71\u5171\u548c\u56fd,\u0427\u0435\u0440\u043d\u043e\u0433\u043e\u0440\u0438\u044f,Czarnog\u00f3ra,Karada\u011f,\u0427\u043e\u0440\u043d\u043e\u0433\u043e\u0440\u0456\u044f,\u0627\u0644\u062c\u0628\u0644 \u0627\u0644\u0623\u0633\u0648\u062f,Crna Gora,\u010cern\u00e1 Hora,\u039c\u03b1\u03c5\u03c1\u03bf\u03b2\u03bf\u03cd\u03bd\u03b9\u03bf,\u05de\u05d5\u05e0\u05d8\u05e0\u05d2\u05e8\u05d5,Muntenegru,\u010cierna Hora,\u0e21\u0e2d\u0e19\u0e40\u0e15\u0e40\u0e19\u0e42\u0e01\u0e23,\u8499\u7279\u5167\u54e5\u7f85,Montenegro,Montenegro,Montenegr\u00f3,Montenegro".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.MK, "mk,\u99ac\u5176\u9813,Macedonia,Mac\u00e9doine,Mazedonien,\u30de\u30b1\u30c9\u30cb\u30a2,Macedoni\u00eb,Repubblica di Macedonia,Macedonia,Maced\u00f4nia,Maced\u00f3nia,Makedonien,Makedonia,Makedonia,Makedonien,\ub9c8\ucf00\ub3c4\ub2c8\uc544,\u9a6c\u5176\u987f,\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u044f,Macedonia,Makedonya,\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0456\u044f,\u0645\u0642\u062f\u0648\u0646\u064a\u0627,Makedonija,Macedonia,\u03a0\u0393\u0394\u039c,\u05de\u05e7\u05d3\u05d5\u05e0\u05d9\u05d4,Macedonia,Maced\u00f3nsko,\u0e21\u0e32\u0e0b\u0e34\u0e42\u0e14\u0e40\u0e19\u0e35\u0e22,Makedonia,Macedonia,Maced\u00f2nia,Maced\u00f3nia,Ma-x\u00ea-\u0111\u00f4-ni-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.MT, "mt,\u99ac\u723e\u4ed6,Malta,Malte,Malta,\u30de\u30eb\u30bf,Malta,Malta,Malta,Malta,Malta,Malta,Malta,Malta,Malta,\ubab0\ud0c0,\u9a6c\u8033\u4ed6,\u041c\u0430\u042c\u044c\u0442\u0430,Malta,Malta,\u041c\u0430\u042c\u044c\u0442\u0430,\u0645\u0627\u0644\u0637\u0627,Malta,Malta,\u039c\u03ac\u03bb\u03c4\u03b1,\u05de\u05dc\u05d8\u05d4,Malta,Malta,\u0e21\u0e2d\u0e25\u0e15\u0e32,Malta,Malta,Malta,M\u00e1lta,Man-ta".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.NL, "nl,\u8377\u862d,Netherlands,Pays-Bas,Niederlande,\u30aa\u30e9\u30f3\u30c0,Nederland,Paesi Bassi,Holanda,Pa\u00edses Baixos,Pa\u00edses Baixos,Holland,Alankomaat,Nederland,Nederl\u00e4nderna,\ub124\ub35c\ub780\ub4dc,\u8377\u5170,\u041d\u0438\u0434\u0435\u0440\u042c\u0430\u043d\u0434\u044b,Holandia,Hollanda,\u041d\u0456\u0434\u0435\u0440\u042c\u0430\u043d\u0434\u0438,\u0647\u0648\u0644\u0646\u062f\u0627,Nizozemska,Nizozemsko,\u0390\u03bb\u03bb\u03b1\u03bd\u03b4\u03af\u03b1,\u05d4\u05d5\u05dc\u05e0\u05d3,Olanda,Holandsko,\u0e40\u0e19\u0e40\u0e18\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c,Netherlands,Netherlands,Pa\u00efsos Baixos,Hollandia,H\u00e0 Lan".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.NO, "no,\u632a\u5a01,Norway,Norv\u00e8ge,Norwegen,\u30ce\u30eb\u30a6\u30a7\u30fc,Noorwegen,Norvegia,Noruega,Noruega,Noruega,Norge,Norja,Norge,Norge,\ub178\ub974\uc6e8\uc774,\u632a\u5a01,\u041d\u043e\u0440\u0432\u0435\u0433\u0438\u044f,Norwegia,Norve\u00e7,\u041d\u043e\u0440\u0432\u0435\u0433\u0456\u044f,\u0627\u0644\u0646\u0631\u0648\u064a\u062c,Norve\u0161ka,Norsko,\u039d\u03bf\u03c1\u03b2\u03b7\u03b3\u03af\u03b1,\u05e0\u05d5\u05e8\u05d5\u05d5\u05d2\u05d9\u05d4,Norvegia,N\u00f3rsko,\u0e19\u0e2d\u0e23\u0e4c\u0e40\u0e27\u0e22\u0e4c,Norwegia,Norway,Noruega,Norv\u00e9gia,Na Uy".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.PL, "pl,\u6ce2\u862d,Poland,Pologne,Polen,\u30dd\u30fc\u30e9\u30f3\u30c9,Polen,Polonia,Polonia,Pol\u00f4nia,Pol\u00f3nia,Polen,Puola,Polen,Polen,\ud3f4\ub780\ub4dc,\u6ce2\u5170,\u041f\u043e\u042c\u044c\u0448\u0430,Polska,Polonya,\u041f\u043e\u042c\u044c\u0449\u0430,\u0628\u0648\u0644\u0646\u062f\u0627,Poljska,Polsko,\u03a0\u03bf\u03bb\u03c9\u03bd\u03af\u03b1,\u05e4\u05d5\u05dc\u05d9\u05df,Polonia,Po\u013esko,\u0e42\u0e1b\u0e41\u0e25\u0e19\u0e14\u0e4c,Polandia,Poland,Pol\u00f2nia,Lengyelorsz\u00e1g,Ba Lan".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.PT, "pt,\u8461\u8404\u7259,Portugal,Portugal,Portugal,\u30dd\u30eb\u30c8\u30ac\u30eb,Portugal,Portogallo,Portugal,Portugal,Portugal,Portugal,Portugali,Portugal,Portugal,\ud3ec\ub974\ud22c\uac08,\u8461\u8404\u7259,\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u042c\u0438\u044f,Portugalia,Portekiz,\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u042c\u0456\u044f,\u0627\u0644\u0628\u0631\u062a\u063a\u0627\u0644,Portugal,Portugalsko,\u03a0\u03bf\u03c1\u03c4\u03bf\u03b3\u03b1\u03bb\u03af\u03b1,\u05e4\u05d5\u05e8\u05d8\u05d5\u05d2\u05dc,Portugalia,Portugalsko,\u0e42\u0e1b\u0e23\u0e15\u0e38\u0e40\u0e01\u0e2a,Portugis,Portugal,Portugal,Portug\u00e1lia,B\u1ed3 \u0110\u00e0o Nha".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.RO, "ro,\u7f85\u99ac\u5c3c\u4e9e,Romania,Roumanie,Rum\u00e4nien,\u30eb\u30fc\u30de\u30cb\u30a2,Roemeni\u00eb,Romania,Ruman\u00eda,Rom\u00eania,Rom\u00e9nia,Rum\u00e6nien,Romania,Romania,Rum\u00e4nien,\ub8e8\ub9c8\ub2c8\uc544,\u7f57\u9a6c\u5c3c\u4e9a,\u0420\u0443\u043c\u044b\u043d\u0438\u044f,Rumunia,Romanya,\u0420\u0443\u043c\u0443\u043d\u0456\u044f,\u0631\u0648\u0645\u0627\u0646\u064a\u0627,Rumunjska,Rumunsko,\u03a1\u03bf\u03c5\u03bc\u03b1\u03bd\u03af\u03b1,\u05e8\u05d5\u05de\u05e0\u05d9\u05d4,Rom\u00e2nia,Rumunsko,\u0e42\u0e23\u0e21\u0e32\u0e40\u0e19\u0e35\u0e22,Rumania,Romania,Romania,Rom\u00e1nia,Ru-ma-ni".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.RS, "rs,\u585e\u723e\u7dad\u4e9e,Serbia,Serbie,Serbien,\u30bb\u30eb\u30d3\u30a2,Servi\u00eb,Serbia,Serbia,S\u00e9rvia,S\u00e9rvia,Serbien,Serbia,Serbia,Serbien,\uc138\ub974\ube44\uc544,\u585e\u5c14\u7ef4\u4e9a,\u0421\u0435\u0440\u0431\u0438\u044f,Serbia,S\u0131rbistan,\u0421\u0435\u0440\u0431\u0456\u044f,\u0635\u0631\u0628\u064a\u0627,Srbija,Srbsko,\u03a3\u03b5\u03c1\u03b2\u03af\u03b1,\u05e1\u05e8\u05d1\u05d9\u05d4,Serbia,Srbsko,\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e40\u0e1a\u0e35\u0e22,\u585e\u723e\u7dad\u4e9e,Serbia,S\u00e8rbia,Szerbia,X\u00e9c-bi".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.RU, "ru,\u4fc4\u7f85\u65af,Russia Federation,F\u00e9d\u00e9ration de Russie,Russische F\u00f6deration,\u30ed\u30b7\u30a2,Rusland,Federazione Russa,Federaci\u00f3n Rusa,Federa\u00e7\u00e3o Russa,R\u00fassia,Rusland,Ven\u00e4j\u00e4,Russland,Ryssland,\ub7ec\uc2dc\uc544,\u4fc4\u7f57\u65af,\u0420\u043e\u0441\u0441\u0438\u044f,Rosja,Rusya Federasyonu,\u0420\u043e\u0441\u0456\u044f,\u0631\u0648\u0633\u064a\u0627,Rusija,Rusko,\u03a1\u03c9\u03c3\u03af\u03b1,\u05e8\u05d5\u05e1\u05d9\u05d4,Rusia,Rusk\u00e1 feder\u00e1cia,\u0e23\u0e31\u0e2a\u0e40\u0e0b\u0e35\u0e22,Rusia,Russia,R\u00fassia,Oroszorsz\u00e1gi F\u00f6der\u00e1ci\u00f3,Nga".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.SE, "se,\u745e\u5178,Sweden,Su\u00e8de,Schweden,\u30b9\u30a6\u30a7\u30fc\u30c7\u30f3,Zweden,Svezia,Suecia,Su\u00e9cia,Su\u00e9cia,Sverige,Ruotsi,Sverige,Sverige,\uc2a4\uc6e8\ub374,\u745e\u5178,\u0428\u0432\u0435\u0446\u0438\u044f,Szwecja,\u0130sve\u00e7,\u0428\u0432\u0435\u0446\u0456\u044f,\u0627\u0644\u0633\u0648\u064a\u062f,\u0160vedska,\u0160v\u00e9dsko,\u03a3\u03bf\u03c5\u03b7\u03b4\u03af\u03b1,\u05e9\u05d5\u05d5\u05d3\u05d9\u05d4,Suedia,\u0160v\u00e9dsko,\u0e2a\u0e27\u0e35\u0e40\u0e14\u0e19,Swedia,Sweden,Su\u00e8cia,Sv\u00e9dorsz\u00e1g,Th\u1ee5y \u0110i\u1ec3n".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.SI, "si,\u65af\u6d1b\u7dad\u5c3c\u4e9e,Slovenia,Slov\u00e9nie,Slowenien,\u30b9\u30ed\u30d9\u30cb\u30a2,Sloveni\u00eb,Slovenia,Eslovenia,Eslov\u00eania,Eslov\u00e9nia,Slovenien,Slovenia,Slovenia,Slovenien,\uc2ac\ub85c\ubca0\ub2c8\uc544,\u65af\u6d1b\u6587\u5c3c\u4e9a,\u0421\u042c\u043e\u0432\u0435\u043d\u0438\u044f,S\u0142owenia,Slovenya,\u0421\u042c\u043e\u0432\u0435\u043d\u0456\u044f,\u0633\u0644\u0648\u0641\u064a\u0646\u064a\u0627,Slovenija,Slovinsko,\u03a3\u03bb\u03bf\u03b2\u03b5\u03bd\u03af\u03b1,\u05e1\u05dc\u05d5\u05d1\u05e0\u05d9\u05d4,Slovenia,Slovinsko,\u0e2a\u0e42\u0e25\u0e27\u0e35\u0e40\u0e19\u0e35\u0e22,Slovenia,Slovenia,Eslov\u00e8nia,Szlov\u00e9nia,Xl\u00f4-ven-ni-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.SK, "sk,\u65af\u6d1b\u4f10\u514b,Slovakia,Slovaquie,Slowakei,\u30b9\u30ed\u30d0\u30ad\u30a2,Slowakije,Slovacchia,Eslovaquia,Eslov\u00e1quia,Eslov\u00e1quia,Slovakiet,Slovakia,Slovakia,Slovakien,\uc2ac\ub85c\ubc14\ud0a4\uc544,\u65af\u6d1b\u4f10\u514b,\u0421\u042c\u043e\u0432\u0430\u043a\u0438\u044f,S\u0142owacja,Slovakya,\u0421\u042c\u043e\u0432\u0430\u043a\u0456\u044f,\u0633\u0644\u0648\u0641\u0627\u0643\u064a\u0627,Slova\u010dka,Slovensko,\u03a3\u03bb\u03bf\u03b2\u03b1\u03ba\u03af\u03b1,\u05e1\u05dc\u05d5\u05d1\u05e7\u05d9\u05d4,Slovacia,Slovensk\u00e1 republika,\u0e2a\u0e42\u0e25\u0e27\u0e30\u0e40\u0e01\u0e35\u0e22,Slovakia,Slovakia,Eslov\u00e0quia,Szlov\u00e1kia,Xl\u00f4-va-ki-a".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.UA, "ua,\u70cf\u514b\u862d,Ukraine,Ukraine,Ukraine,\u30a6\u30af\u30e9\u30a4\u30ca,Oekra\u00efne,Ucraina,Ucrania,Ucr\u00e2nia,Ucr\u00e2nia,Ukraine,Ukraina,Ukraina,Ukraina,\uc6b0\ud06c\ub77c\uc774\ub098,\u4e4c\u514b\u5170,\u0423\u043a\u0440\u0430\u0438\u043d\u0430,Ukraina,Ukrayna,\u0423\u043a\u0440\u0430\u0457\u043d\u0430,\u0623\u0648\u0643\u0631\u0627\u0646\u064a\u0627,Ukrajina,Ukrajina,\u0390\u03c5\u03ba\u03c1\u03b1\u03bd\u03af\u03b1,\u05d0\u05d5\u05e7\u05e8\u05d0\u05d9\u05e0\u05d4,Ucraina,Ukrajina,\u0e22\u0e39\u0e40\u0e04\u0e23\u0e19,Ukraina,Ukraine,Ucra\u00efna,Ukrajna,U-crai-na".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.VA, "va,\u68b5\u8482\u5ca1,Vatican,\u00c9tat de la Cit\u00e9 du Vatican,Vatikanstadt,\u30d0\u30c1\u30ab\u30f3\u5e02\u56fd,Vaticaanstad,Vaticano,Ciudad del Vaticano,Vaticano,Vaticano,Vatikanstaten,Vatikaani,Vatikanstaten,Vatikanstaten,\ubc14\ud2f0\uce78,\u68b5\u8482\u5188,\u0412\u0430\u0442\u0438\u043a\u0430\u043d,Watykan,Vatikan,\u0412\u0430\u0442\u0438\u043a\u0430\u043d,\u0627\u0644\u0641\u0627\u062a\u064a\u0643\u0627\u0646,Grad Vatikan,Svat\u00fd stolec,\u0392\u03b1\u03c4\u03b9\u03ba\u03b1\u03bd\u03cc,\u05d4\u05d5\u05d5\u05ea\u05d9\u05e7\u05df,Vatican,Vatik\u00e1n,\u0e27\u0e32\u0e15\u0e34\u0e01\u0e31\u0e19,Vatikan,Vatican City,Vatic\u00e0,Vatik\u00e1n,Va-ti-c\u0103ng".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.AU, "au,\u6fb3\u6d32,Australia,Australie,Australien,\u30aa\u30fc\u30b9\u30c8\u30e9\u30ea\u30a2,Australi\u00eb,Australia,Australia,Austr\u00e1lia,Austr\u00e1lia,Australien,Australia,Australia,Australien,\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544,\u6fb3\u5927\u5229\u4e9a,\u0410\u0432\u0441\u0442\u0440\u0430\u042c\u0438\u044f,Australia,Avustralya,\u0410\u0432\u0441\u0442\u0440\u0430\u042c\u0456\u044f,\u0623\u0633\u062a\u0631\u0627\u0644\u064a\u0627,Australija,Austr\u00e1lie,\u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1,\u05d0\u05d5\u05e1\u05d8\u05e8\u05dc\u05d9\u05d4,Australia,Austr\u00e1lia,\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22,Australia,Australia,Austr\u00e0lia,Ausztr\u00e1lia,\u00dac".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.FJ, "fj,\u6590\u6fdf,Fiji,Fidji,Fidschi,\u30d5\u30a3\u30b8\u30fc,Fiji,Figi,Fiyi,Fiji,Fiji,Fiji-\u00f8erne,Fid\u017ei,Fiji,Fiji,\ud53c\uc9c0,\u6590\u6d4e,\u0424\u0438\u0434\u0436\u0438,Fid\u017ci,Fiji,\u0424\u0456\u0434\u0436\u0456,\u0641\u064a\u062c\u064a,Fid\u017ei,Fid\u017ei,\u03a6\u03af\u03c4\u03b6\u03b9,\u05e4\u05d9\u05d2\u05f3\u05d9,Fiji,Fid\u017ei,\u0e1f\u0e34\u0e08\u0e34,Fiji,Fiji,Fiji,Fidzsi,Phi-gi".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.GS, "gs,\u5357\u55ac\u6cbb\u4e9e\u8207\u5357\u4e09\u660e\u6cbb\u7fa4\u5cf6,South Georgia and the South Sandwich Islands,G\u00e9orgie du Sud et les \u00eeles Sandwich du Sud,S\u00fcdgeorgien und die S\u00fcdlichen Sandwichinseln,\u5357\u30b8\u30e7\u30fc\u30b8\u30a2\u5cf6\u30fb\u5357\u30b5\u30f3\u30c9\u30a4\u30c3\u30c1\u8af8\u5cf6,Zuid-Georgi\u00eb en Zuidelijke Sandwicheilanden,Georgia del Sud e Isole Sandwich del Sud,Islas Georgia del Sur y Sandwich del Sur,Ge\u00f3rgia do Sul e Ilhas Sandwich do Sul,Ge\u00f3rgia do Sul e Ilhas Sandwich do Sul,South Georgia og De Sydlige Sandwich\u00f8er,Etel\u00e4-Georgia ja Etel\u00e4iset Sandwichsaaret,S\u00f8r-Georgia og de s\u00f8rlige Sandwich-\u00f8yene,Sydgeorgien och S\u00f6dra Sandwich\u00f6arna,\uc0ac\uc6b0\uc2a4\uc870\uc9c0\uc544 \uc0ac\uc6b0\uc2a4\uc0cc\ub4dc\uc704\uce58 \uc81c\ub3c4,\u5357\u4f50\u6cbb\u4e9a\u548c\u5357\u4e09\u660e\u6cbb\u7fa4\u5c9b,\u042e\u0436\u043d\u0430\u044f \u0414\u0436\u043e\u0440\u0434\u0436\u0438\u044f \u0438 \u042e\u0436\u043d\u044b\u0435 \u0421\u0430\u043d\u0434\u0432\u0438\u0447\u0435\u0432\u044b \u041e\u0441\u0442\u0440\u043e\u0432\u0430,Georgia Po\u0142udniowa i Sandwich Po\u0142udniowy,G\u00fcney Georgia ve G\u00fcney Sandwich Adalar\u0131,\u041f\u0456\u0432\u0434\u0435\u043d\u043d\u0430 \u0414\u0436\u043e\u0440\u0434\u0436\u0456\u044f \u0442\u0430 \u041f\u0456\u0432\u0434\u0435\u043d\u043d\u0456 \u0421\u0430\u043d\u0434\u0432\u0456\u0447\u0435\u0432\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438,\u062c\u0648\u0631\u062c\u064a\u0627 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629 \u0648\u062c\u0632\u0631 \u0633\u0627\u0646\u062f\u0648\u064a\u062a\u0634 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629,Ju\u017ena Gruzija i Ju\u017eni Sendvi\u010d Otoci,Ji\u017en\u00ed Georgie a Ji\u017en\u00ed Sandwichovy ostrovy,\u039d\u03cc\u03c4\u03b9\u03b1 \u0393\u03b5\u03c9\u03c1\u03b3\u03af\u03b1 \u03ba\u03b1\u03b9 \u039d\u03cc\u03c4\u03b9\u03b5\u03c2 \u039d\u03ae\u03c3\u03bf\u03b9 \u03a3\u03ac\u03bd\u03c4\u03bf\u03c5\u03b9\u03c4\u03c2,\u05d2\u05f3\u05d5\u05e8\u05d2\u05f3\u05d9\u05d4 \u05d4\u05d3\u05e8\u05d5\u05de\u05d9\u05ea \u05d5\u05d0\u05d9\u05d9 \u05e1\u05e0\u05d3\u05d5\u05d5\u05d9\u05e5\u05f3 \u05d4\u05d3\u05e8\u05d5\u05de\u05d9\u05d9\u05dd,Georgia de Sud \u015fi Insulele Sandwich de Sud,Ju\u017en\u00e1 Georgia a Ju\u017en\u00e9 Sandwichove ostrovy,\u0e40\u0e01\u0e32\u0e30\u0e40\u0e0b\u0e32\u0e17\u0e4c\u0e08\u0e2d\u0e23\u0e4c\u0e40\u0e08\u0e35\u0e22\u0e41\u0e25\u0e30\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e40\u0e0b\u0e32\u0e17\u0e4c\u0e41\u0e0b\u0e19\u0e14\u0e4c\u0e27\u0e34\u0e0a,Kepulauan South Sandwich dan South Georgia,South Georgia and the South Sandwich Islands,Illes Ge\u00f2rgia del Sud i Sandwich del Sud,D\u00e9l Gr\u00fazia \u00e9s a D\u00e9li Szendvics-szigetek,Qu\u1ea7n \u0111\u1ea3o Nam Georgia v\u00e0 Nam Sandwich".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.KI, "ki,\u5409\u91cc\u5df4\u65af,Kiribati,Kiribati,Kiribati,\u30ad\u30ea\u30d0\u30b9,Kiribati,Kiribati,Kiribati,Quiribati,Quiribati,Kiribati,Kiribati,Kiribati,Kiribati,\ud0a4\ub9ac\ubc14\uc2dc,\u57fa\u91cc\u5df4\u65af,\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438,Kiribati,Kiribati,\u041a\u0456\u0440\u0438\u0431\u0430\u0442\u0456,\u0643\u064a\u0631\u064a\u0628\u0627\u062a\u064a,Kiribati,Kiribati,\u039a\u03b9\u03c1\u03b9\u03bc\u03c0\u03ac\u03c4\u03b9,\u05e7\u05d9\u05e8\u05d9\u05d1\u05d0\u05d8\u05d9,Kiribati,Kiribati,\u0e04\u0e34\u0e23\u0e34\u0e1a\u0e32\u0e2a,Kiribati,Kiribati,Kiribati,Kiribati,Ki-ri-ba-ti".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.NC, "nc,\u65b0\u5580\u91cc\u591a\u5c3c\u4e9e\u7fa4\u5cf6,New Caledonia,Nouvelle-Cal\u00e9donie,Neukaledonien,\u30cb\u30e5\u30fc\u30ab\u30ec\u30c9\u30cb\u30a2,Nieuw-Caledoni\u00eb,Nuova Caledonia,Nueva Caledonia,Nova Caled\u00f4nia,Nova Caled\u00f3nia,Ny Caledonien,Uusi-Kaledonia,Ny-Caledonia,Nya Kaledonien,\ub274 \uce7c\ub808\ub3c4\ub2c8\uc544,\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a,\u041d\u043e\u0432\u0430\u044f \u041a\u0430\u042c\u0435\u0434\u043e\u043d\u0438\u044f,Nowa Kaledonia,Yeni Kaledonya,\u041d\u043e\u0432\u0430 \u041a\u0430\u042c\u0435\u0434\u043e\u043d\u0456\u044f,\u0643\u0627\u0644\u064a\u062f\u0648\u0646\u064a\u0627 \u0627\u0644\u062c\u062f\u064a\u062f\u0629,Nova Kaledonija,Nov\u00e1 Kaledonie,\u039d\u03ad\u03b1 \u039a\u03b1\u03bb\u03b7\u03b4\u03bf\u03bd\u03af\u03b1,\u05e7\u05dc\u05d3\u05d5\u05e0\u05d9\u05d4 \u05d4\u05d7\u05d3\u05e9\u05d4,Noua Caledonie,Nov\u00e1 Kaled\u00f3nia,\u0e19\u0e34\u0e27\u0e41\u0e04\u0e25\u0e34\u0e42\u0e14\u0e40\u0e19\u0e35\u0e22,Kaledonia Baru,New Caledonia,Nova Caled\u00f2nia,\u00daj-Kaled\u00f3nia,New Caledonia".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.NR, "nr,\u8afe\u9b6f,Nauru,Nauru,Nauru,\u30ca\u30a6\u30eb,Nauru,Nauru,Nauru,Nauru,Nauru,Nauru,Nauru,Nauru,Nauru,\ub098\uc6b0\ub8e8,\u7459\u9c81,\u041d\u0430\u0443\u0440\u0443,Nauru,Nauru,\u041d\u0430\u0443\u0440\u0443,\u0646\u0627\u0648\u0631\u0648,Nauru,Nauru,\u039d\u03b1\u03bf\u03cd\u03c1\u03bf\u03c5,\u05e0\u05d0\u05d5\u05e8\u05d5,Nauru,Nauru,\u0e19\u0e32\u0e2d\u0e39\u0e23\u0e39,Nauru,Nauru,Nauru,Nauru,\u8afe\u9b6f".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.NZ, "nz,\u7d10\u897f\u862d,New Zealand,Nouvelle-Z\u00e9lande,Neuseeland,\u30cb\u30e5\u30fc\u30b8\u30fc\u30e9\u30f3\u30c9,Nieuw-Zeeland,Nuova Zelanda,Nueva Zelanda,Nova Zel\u00e2ndia,Nova Zel\u00e2ndia,New Zealand,Uusi-Seelanti,New Zealand,Nya Zeeland,\ub274\uc9c8\ub79c\ub4dc,\u65b0\u897f\u5170,\u041d\u043e\u0432\u0430\u044f \u0417\u0435\u042c\u0430\u043d\u0434\u0438\u044f,Nowa Zelandia,Yeni Zelanda,\u041d\u043e\u0432\u0430 \u0417\u0435\u042c\u0430\u043d\u0434\u0456\u044f,\u0646\u064a\u0648\u0632\u064a\u0644\u0627\u0646\u062f\u0627,Novi Zeland,Nov\u00fd Z\u00e9land,\u039d\u03ad\u03b1 \u0396\u03b7\u03bb\u03b1\u03bd\u03b4\u03af\u03b1,\u05e0\u05d9\u05d5 \u05d6\u05d9\u05dc\u05e0\u05d3,Noua Zeeland\u0103,Nov\u00fd Z\u00e9land,\u0e19\u0e34\u0e27\u0e0b\u0e35\u0e41\u0e25\u0e19\u0e14\u0e4c,Selandia Baru,New Zealand,Nova Zelanda,\u00daj-Z\u00e9land,Niu Di-l\u00e2n".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.PF, "pf,\u6cd5\u5c6c\u73bb\u91cc\u5c3c\u897f\u4e9e,French Polynesia,Polyn\u00e9sie fran\u00e7aise,Franz\u00f6sisch-Polynesien,\u4ecf\u9818\u30dd\u30ea\u30cd\u30b7\u30a2,Frans-Polynesi\u00eb,Polinesia Francese,Polinesia Francesa,Polin\u00e9sia Francesa,Polin\u00e9sia Francesa,Fransk Polynesien,Ranskan Polynesia,Fransk Polynesia,Franska Polynesien,\ud504\ub791\uc2a4\ub839 \ud3f4\ub9ac\ub124\uc2dc\uc544,\u6cd5\u5c5e\u6ce2\u5229\u5c3c\u897f\u4e9a,\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f \u041f\u043e\u042c\u0438\u043d\u0435\u0437\u0438\u044f,Polinezja Francuska,Frans\u0131z Polinezyas\u0131,\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0430 \u041f\u043e\u042c\u0456\u043d\u0435\u0437\u0456\u044f,\u0628\u0648\u0644\u064a\u0646\u064a\u0632\u064a\u0627 \u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629,Francuska Polinezija,Francouzsk\u00e1 Polyn\u00e9sie,\u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ae \u03a0\u03bf\u03bb\u03c5\u03bd\u03b7\u03c3\u03af\u03b1,\u05e4\u05d5\u05dc\u05d9\u05e0\u05d6\u05d9\u05d4 \u05d4\u05e6\u05e8\u05e4\u05ea\u05d9\u05ea,Polinezia Francez\u0103,Franc\u00fazska Polyn\u00e9zia,\u0e40\u0e1f\u0e23\u0e19\u0e0a\u0e4c\u0e42\u0e1b\u0e25\u0e34\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22,Polynesia Perancis,French Polynesia,Polin\u00e8sia Francesa,Francia Polin\u00e9zia,Polynesia thu\u1ed9c Ph\u00e1p".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.PG, "pg,\u5df4\u5e03\u4e9e\u7d10\u5e7e\u5167\u4e9e,Papua New Guinea,Papouasie-Nouvelle-Guin\u00e9e,Papua-Neuguinea,\u30d1\u30d7\u30a2\u30cb\u30e5\u30fc\u30ae\u30cb\u30a2,Papoea-Nieuw-Guinea,Papua Nuova Guinea,Pap\u00faa Nueva Guinea,Papua-Nova Guin\u00e9,Papu\u00e1sia-Nova Guin\u00e9,Papua Ny Guinea,Papua-Uusi-Guinea,Papua Ny-Guinea,Papua Nya Guinea,\ud30c\ud478\uc544\ub274\uae30\ub2c8,\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a,\u041f\u0430\u043f\u0443\u0430 \u2013 \u041d\u043e\u0432\u0430\u044f \u0413\u0432\u0438\u043d\u0435\u044f,Papua Nowa Gwinea,Papua Yeni Gine,\u041f\u0430\u043f\u0443\u0430 \u041d\u043e\u0432\u0430 \u0413\u0432\u0456\u043d\u0435\u044f,\u0628\u0627\u0628\u0648\u0627 \u063a\u064a\u0646\u064a\u0627 \u0627\u0644\u062c\u062f\u064a\u062f\u0629,Papua Nova Gvineja,Papua-Nov\u00e1 Guinea,\u03a0\u03b1\u03c0\u03bf\u03cd\u03b1 \u039d\u03ad\u03b1 \u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1,\u05e4\u05e4\u05d5\u05d0\u05d4 \u05d2\u05d9\u05e0\u05d9\u05d0\u05d4 \u05d4\u05d7\u05d3\u05e9\u05d4,Papua Noua Guinee,Papua Nov\u00e1 Guinea,\u0e1b\u0e32\u0e1b\u0e31\u0e27\u0e19\u0e34\u0e27\u0e01\u0e34\u0e19\u0e35,Nugini Papua Nugini,Papua New Guinea,Papua Nova Guinea,P\u00e1pua \u00daj-Guinea,Pa-pu-a Niu Ghi-n\u00ea".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.SB, "sb,\u7d22\u7f85\u9580\u7fa4\u5cf6,Solomon Islands,\u00celes Salomon,Salomonen,\u30bd\u30ed\u30e2\u30f3\u8af8\u5cf6,Salomonseilanden,Isole Solomon,Islas Salom\u00f3n,Ilhas Salom\u00e3o,Ilhas Salom\u00e3o,Salomon\u00f8erne,Salomonsaaret,Salomon\u00f8yene,Salomon\u00f6arna,\uc194\ub85c\ubaac \uc81c\ub3c4,\u6240\u7f57\u95e8\u7fa4\u5c9b,\u0421\u043e\u042c\u043e\u043c\u043e\u043d\u043e\u0432\u044b \u043e-\u0432\u0430,Wyspy Salomona,Solomon Adalar\u0131,\u0421\u043e\u042c\u043e\u043c\u043e\u043d\u043e\u0432\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438,\u062c\u0632\u0631 \u0633\u0644\u064a\u0645\u0627\u0646,Solomonski Otoci,\u0160alamounovy ostrovy,\u039d\u03ae\u03c3\u03bf\u03b9 \u03a3\u03bf\u03bb\u03bf\u03bc\u03ce\u03bd\u03c4\u03bf\u03c2,\u05d0\u05d9\u05d9 \u05e9\u05dc\u05de\u05d4,Insulele Solomon,\u0160alam\u00fanove ostrovy,\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e42\u0e0b\u0e42\u0e25\u0e21\u0e2d\u0e19,Kepulauan Solomon,Solomon Islands,Illes Salom\u00f3,Salamon-szigetek,Qu\u1ea7n \u0111\u1ea3o X\u00f4-l\u00f4-m\u00f4ng".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.TO, "to,\u6771\u52a0,Tonga,Tonga,Tonga,\u30c8\u30f3\u30ac,Tonga,Tonga,Tonga,Tonga,Tonga,Tonga,Tonga,Tonga,Tonga,\ud1b5\uac00,\u6c64\u52a0,\u0422\u043e\u043d\u0433\u0430,Tonga,Tonga,\u0422\u043e\u043d\u0433\u0430,\u062a\u0648\u0646\u063a\u0627,Tonga,Tonga,\u03a4\u03cc\u03bd\u03b3\u03ba\u03b1,\u05d8\u05d5\u05e0\u05d2\u05d4,Tonga,Tonga,\u0e15\u0e2d\u0e07\u0e01\u0e32,Tonga,Tonga,Tonga,Tonga,T\u00f4ng-ga".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.TV, "tv,\u5410\u74e6\u9b6f,Tuvalu,Tuvalu,Tuvalu,\u30c4\u30d0\u30eb,Tuvalu,Tuvalu,Tuvalu,Tuvalu,Tuvalu,Tuvalu,Tuvalu,Tuvalu,Tuvalu,\ud22c\ubc1c\ub8e8,\u56fe\u74e6\u5362,\u0422\u0443\u0432\u0430\u042c\u0443,Tuvalu,Tuvalu,\u0422\u0443\u0432\u0430\u042c\u0443,\u062a\u0648\u0641\u0627\u0644\u0648,Tuvalu,Tuvalu,\u03a4\u03bf\u03c5\u03b2\u03b1\u03bb\u03bf\u03cd,\u05d8\u05d5\u05d1\u05dc\u05d5,Tuvalu,Tuvalu,\u0e15\u0e39\u0e27\u0e32\u0e25\u0e39,Tuvalu,Tuvalu,Tuvalu,Tuvalu,Tu-va-lu".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.VU, "vu,\u842c\u90a3\u675c,Vanuatu,Vanuatu,Vanuatu,\u30d0\u30cc\u30a2\u30c4,Vanuatu,Vanuatu,Vanuatu,Vanuatu,Vanuatu,Vanuatu,Vanuatu,Vanuatu,Vanuatu,\ubc14\ub204\uc544\ud22c,\u74e6\u52aa\u963f\u56fe,\u0412\u0430\u043d\u0443\u0430\u0442\u0443,Vanuatu,Vanuatu,\u0412\u0430\u043d\u0443\u0430\u0442\u0443,\u0641\u0627\u0646\u0648\u0627\u062a\u0648,Vanuatu,Vanuatu,\u0392\u03b1\u03bd\u03bf\u03c5\u03ac\u03c4\u03bf\u03c5,\u05d5\u05e0\u05d5\u05d0\u05d8\u05d5,Vanuatu,Vanuatu,\u0e27\u0e32\u0e19\u0e39\u0e2d\u0e32\u0e15\u0e39,Vanuatu,Vanuatu,Vanuatu,Vanuatu,Va-nu-a-tu".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.WS, "ws,\u85a9\u6469\u4e9e\u7fa4\u5cf6,Samoa,Samoa,Samoa,\u30b5\u30e2\u30a2,Samoa,Samoa,Samoa,Samoa,Samoa,Samoa,Samoa,Samoa,Samoa,\uc0ac\ubaa8\uc544,\u8428\u6469\u4e9a,\u0421\u0430\u043c\u043e\u0430,Samoa,Samoa,\u0421\u0430\u043c\u043e\u0430,\u0633\u0627\u0645\u0648\u0627,Samoa,Samoa,\u03a3\u03b1\u03bc\u03cc\u03b1,\u05e1\u05de\u05d5\u05d0\u05d4,Samoa,Samoa,\u0e0b\u0e32\u0e21\u0e31\u0e27,Samoa,Samoa,Samoa,Szamoa,Xa-moa".split(","));
        COUNTRY_CODE_TO_NAME.put(CountryCode.GH, "gh,\u8fe6\u7d0d,Ghana,Ghana,Ghana,\u30ac\u30fc\u30ca,Ghana,Ghana,Ghana,Gana,Ghana,Ghana,Ghana,Ghana,Ghana,\uac00\ub098,\u52a0\u7eb3,Ghana,Ghana,Ghana,Ghana,Ghana,Ghana,Ghana,Ghana,Ghana,Ghana,Ghana,Ghana,Ghana,Ghana,Ghana,Ghana,Ghana".split(","));
        for (CountryCode countryCode : CountryCode.values()) {
            for (int i = 0; i < 34; ++i) {
                String[] countryNames = (String[])COUNTRY_CODE_TO_NAME.get(countryCode);
                COUNTRY_NAME_TO_CODE.put(countryNames[i], countryCode);
            }
        }
    }
}

