/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.Utils;

import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.net.util.SubnetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class NetworkUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkUtil.class);

    public static final boolean isIpInGivenRange(String ipBegin, String ipToCheck, String ipEnd) {
        long ipBeginLong = NetworkUtil.ipAddressToLong((String)ipBegin);
        long ipToCheckLong = NetworkUtil.ipAddressToLong((String)ipToCheck);
        long ipEndLong = NetworkUtil.ipAddressToLong((String)ipEnd);
        return ipToCheckLong >= ipBeginLong && ipToCheckLong <= ipEndLong;
    }

    public static final String getClientIp(HttpServletRequest request) {
        String remoteAddr = "";
        if (request != null && ((remoteAddr = request.getHeader("X-FORWARDED-FOR")) == null || "".equals(remoteAddr))) {
            remoteAddr = request.getRemoteAddr();
        }
        return remoteAddr;
    }

    public static final long ipAddressToLong(String ipAddress) {
        byte[] octets = InetAddresses.forString((String)ipAddress).getAddress();
        long ipAddressDecimal = 0L;
        for (byte octet : octets) {
            ipAddressDecimal <<= 8;
            ipAddressDecimal |= (long)(octet & 0xFF);
        }
        return ipAddressDecimal;
    }

    public static final boolean isIpBeginGreaterThanIpEnd(String ipBegin, String ipEnd) {
        long ipEndLong;
        long ipBeginLong = NetworkUtil.ipAddressToLong((String)ipBegin);
        return ipBeginLong > (ipEndLong = NetworkUtil.ipAddressToLong((String)ipEnd));
    }

    public static final boolean isRemoteIpAddressSameWithServer(String remoteIp) throws SocketException {
        boolean ipAddressSameWithServer = false;
        Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
        while (networks.hasMoreElements()) {
            NetworkInterface network = networks.nextElement();
            for (InterfaceAddress addr : network.getInterfaceAddresses()) {
                if (!(addr.getAddress() instanceof Inet4Address) || addr.getAddress().isLoopbackAddress()) continue;
                if (addr.getAddress().getHostAddress().equals(remoteIp)) {
                    LOG.debug("Remote ip is server ip");
                    return true;
                }
                try {
                    short networkPrefixLength = addr.getNetworkPrefixLength();
                    String cidrNotation = addr.getAddress().getHostAddress() + "/" + networkPrefixLength;
                    LOG.debug("cidr:{}", (Object)cidrNotation);
                    SubnetUtils utils = new SubnetUtils(cidrNotation);
                    ipAddressSameWithServer = utils.getInfo().isInRange(remoteIp);
                    LOG.debug("LAN info:{}", (Object)utils.getInfo());
                }
                catch (Exception e) {
                    LOG.debug("Error", (Throwable)e);
                }
                if (!ipAddressSameWithServer) continue;
                return true;
            }
        }
        return ipAddressSameWithServer;
    }

    public static final boolean isRemoteIpAddressSameWithServerForGoogleCloud(String remoteIp) throws SocketException {
        boolean ipAddressSameWithServer = false;
        Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
        while (networks.hasMoreElements()) {
            NetworkInterface network = networks.nextElement();
            for (InterfaceAddress addr : network.getInterfaceAddresses()) {
                if (!(addr.getAddress() instanceof Inet4Address) || addr.getAddress().isLoopbackAddress()) continue;
                if (addr.getAddress().getHostAddress().equals(remoteIp)) {
                    LOG.debug("Remote ip is server ip");
                    return true;
                }
                try {
                    int networkPrefixLength = 20;
                    String cidrNotation = addr.getAddress().getHostAddress() + "/" + networkPrefixLength;
                    LOG.info("isRemoteIpAddressSameWithServerForGoogleCloud cidr:{}", (Object)cidrNotation);
                    SubnetUtils utils = new SubnetUtils(cidrNotation);
                    ipAddressSameWithServer = utils.getInfo().isInRange(remoteIp);
                    LOG.debug("LAN info:{}", (Object)utils.getInfo());
                }
                catch (Exception e) {
                    LOG.debug("Error", (Throwable)e);
                }
                if (!ipAddressSameWithServer) continue;
                return true;
            }
        }
        return ipAddressSameWithServer;
    }
}

