/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.Utils;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class LocalDateTimeAdapter
implements JsonSerializer<LocalDateTime>,
JsonDeserializer<LocalDateTime> {
    public static final String DEFAULT_DATETIME_FORMATTER = "yyyy-MM-dd'T'HH:mm:ss";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;

    public JsonElement serialize(LocalDateTime src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(src.format(DateTimeFormatter.ofPattern(DEFAULT_DATETIME_FORMATTER)));
    }

    public LocalDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String localDateTime = json.getAsJsonPrimitive().getAsString();
        return LocalDateTime.parse(localDateTime, DateTimeFormatter.ofPattern(DEFAULT_DATETIME_FORMATTER));
    }
}

