/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.Utils;

import com.penpower.worldcard.team.Utils.HardwareIdUtil;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.enums.ServerType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Scanner;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.platform.linux.LinuxHardwareAbstractionLayer;

/*
 * Exception performing whole class analysis ignored.
 */
public class HardwareIdUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HardwareIdUtil.class);
    private static String networkAddress = "";

    public static final long getystemInstalledMemoryBytes() {
        SystemInfo systemInfo = new SystemInfo();
        HardwareAbstractionLayer hal = systemInfo.getHardware();
        GlobalMemory globalMemory = hal.getMemory();
        long totalSystemMemoryBytes = globalMemory.getTotal();
        return totalSystemMemoryBytes;
    }

    public static final boolean linuxSystem() {
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hardWare = si.getHardware();
        boolean linuxHardWareLayer = hardWare instanceof LinuxHardwareAbstractionLayer;
        return linuxHardWareLayer;
    }

    public static final void beep(long miniSecond) {
    }

    public static final boolean systeminstalledMemoryLargerThan4G() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return true;
        }
        try {
            long installedMemoryBytes = HardwareIdUtil.getystemInstalledMemoryBytes();
            long installedMemoryGBCeil = (long)Math.ceil((double)installedMemoryBytes / 1.073741824E9);
            return installedMemoryGBCeil >= 4L;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static final String getFirstEthernetInterfaceIpaddress() {
        String ip = null;
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                if (iface.isLoopback() || !iface.isUp()) continue;
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    ip = addr.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return ip;
    }

    private static String ParserMacAddressbyID(String strLine, String ethID) {
        String[] tokens = strLine.split(" ");
        boolean bHWaddr = false;
        boolean bEth = false;
        for (String token : tokens) {
            if (token.length() <= 0) continue;
            if (bHWaddr && bEth) {
                return token;
            }
            if (token.compareToIgnoreCase("HWaddr") == 0) {
                bHWaddr = true;
            }
            if (token.compareToIgnoreCase(ethID) != 0) continue;
            bEth = true;
        }
        return "";
    }

    private static String ParserMacAddress(String strLine) {
        String[] tokens = strLine.split(" ");
        boolean bHWaddr = false;
        boolean bEth = false;
        for (String token : tokens) {
            if (token.length() <= 0) continue;
            if (bHWaddr && bEth) {
                return token.replace(":", "");
            }
            if (token.compareToIgnoreCase("HWaddr") == 0) {
                bHWaddr = true;
            }
            if (token.compareToIgnoreCase("eth0") != 0 && token.compareToIgnoreCase("eth1") != 0) continue;
            bEth = true;
        }
        return "";
    }

    private static String ParserSerialNumber(String strLine) {
        String[] tokens = strLine.split(" ");
        boolean bNext = false;
        for (String token : tokens) {
            if (token.length() <= 0) continue;
            if (bNext) {
                LOG.trace("ParserSerialNumber return" + token);
                return token;
            }
            if (token.toUpperCase().indexOf("SERIAL:") < 0) continue;
            bNext = true;
            LOG.trace("get serial number" + token);
        }
        return "";
    }

    public static String GetAddressbyID(String addressType, int nSeq, boolean withSepare) {
        ArrayList<String> addresslist = new ArrayList<String>();
        InetAddress lanIp = null;
        try {
            String ipAddress = null;
            Enumeration<NetworkInterface> net = null;
            net = NetworkInterface.getNetworkInterfaces();
            while (net.hasMoreElements()) {
                NetworkInterface element = net.nextElement();
                Enumeration<InetAddress> addresses = element.getInetAddresses();
                while (addresses.hasMoreElements() && !HardwareIdUtil.isVMMac((byte[])element.getHardwareAddress())) {
                    InetAddress ip = addresses.nextElement();
                    if (!(ip instanceof Inet4Address) || (lanIp = InetAddress.getByName(ipAddress = ip.getHostAddress())) == null) continue;
                    if (addressType.equals("ip")) {
                        String add = lanIp.toString().replaceAll("^/+", "");
                        if (StringUtil.IsStringNullorEmpty((String)add)) continue;
                        addresslist.add(add);
                        continue;
                    }
                    if (addressType.equals("mac")) {
                        String address = HardwareIdUtil.getMacAddress((InetAddress)lanIp, (boolean)withSepare);
                        if (StringUtil.IsStringNullorEmpty((String)address)) continue;
                        addresslist.add(address);
                        continue;
                    }
                    throw new Exception("Specify \"ip\" or \"mac\"");
                }
            }
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        addresslist.sort((p1, p2) -> p1.compareTo((String)p2));
        if (nSeq < addresslist.size()) {
            return (String)addresslist.get(nSeq);
        }
        return "";
    }

    public static String GetAddress() {
        LOG.debug("GetAddress 0");
        ArrayList<String> addresslist = new ArrayList<String>();
        InetAddress lanIp = null;
        String VMIP = "";
        try {
            String ipAddress = null;
            Enumeration<NetworkInterface> net = null;
            net = NetworkInterface.getNetworkInterfaces();
            while (net.hasMoreElements()) {
                NetworkInterface element = net.nextElement();
                Enumeration<InetAddress> addresses = element.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    String macaddr;
                    LOG.debug("GetAddress:");
                    LOG.debug(element.getDisplayName());
                    InetAddress ip = addresses.nextElement();
                    LOG.debug("HostName :");
                    LOG.debug(ip.getHostName());
                    if (!HardwareIdUtil.isVMMac((byte[])element.getHardwareAddress())) {
                        if (!(ip instanceof Inet4Address) || (ipAddress = ip.getHostAddress()) == null) continue;
                        lanIp = InetAddress.getByName(ipAddress);
                        LOG.debug("ipv4: []", (Object)lanIp.toString());
                        macaddr = HardwareIdUtil.getMacAddress((InetAddress)lanIp, (boolean)false);
                        LOG.debug("macaddr");
                        LOG.debug(macaddr);
                        if (macaddr == null || macaddr.length() <= 0) continue;
                        addresslist.add(macaddr);
                        continue;
                    }
                    if (!(ip instanceof Inet4Address) || (ipAddress = ip.getHostAddress()) == null) continue;
                    lanIp = InetAddress.getByName(ipAddress);
                    LOG.debug("vmipv4: []", (Object)lanIp.toString());
                    macaddr = HardwareIdUtil.getMacAddress((InetAddress)lanIp, (boolean)false);
                    LOG.debug("macaddr");
                    LOG.debug(macaddr);
                    if (macaddr == null || macaddr.length() <= 0) continue;
                    addresslist.add(macaddr);
                }
            }
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        LOG.trace("GetAddress aa");
        if (addresslist.size() == 0) {
            LOG.debug("GetAddress ab");
            LOG.debug(VMIP);
            networkAddress = VMIP;
            return VMIP;
        }
        LOG.debug("GetAddress ac");
        String allAddr = "";
        addresslist.sort((p1, p2) -> p1.compareTo((String)p2));
        for (String addr : addresslist) {
            allAddr = allAddr + addr;
            LOG.debug(addr);
        }
        networkAddress = allAddr;
        return allAddr;
    }

    private static String getMacAddress(InetAddress ip, boolean withSepare) {
        String address = null;
        try {
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            byte[] mac = network.getHardwareAddress();
            if (mac != null) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    if (withSepare) {
                        sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                        continue;
                    }
                    sb.append(String.format("%02X", mac[i]));
                }
                address = sb.toString();
            }
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        return address;
    }

    private static boolean isVMMac(byte[] mac) {
        byte[][] invalidMacs;
        if (null == mac) {
            return false;
        }
        for (byte[] invalid : invalidMacs = new byte[][]{{0, 5, 105}, {0, 28, 20}, {0, 12, 41}, {0, 80, 86}, {8, 0, 39}, {10, 0, 39}, {0, 3, -1}, {0, 21, 93}}) {
            if (invalid[0] != mac[0] || invalid[1] != mac[1] || invalid[2] != mac[2]) continue;
            return true;
        }
        return false;
    }

    public static final String getEthernetInterfaceMac(ServerType svrType) {
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ServerType[svrType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return HardwareIdUtil.getEthernetInterfaceMacbyASUSTOR();
            }
        }
        return HardwareIdUtil.GetAddress();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String GetCurrentNetIP() {
        try (DatagramSocket socket = new DatagramSocket();){
            String ip;
            socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            String string = ip = socket.getLocalAddress().getHostAddress();
            return string;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static final String getEthernetInterfaceMacbyLinux(int nSeq) {
        if (nSeq != 0) {
            return "";
        }
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            byte[] mac = network.getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                sb.append(String.format("%02X%s", mac[i]));
            }
            LOG.trace(sb.toString());
            return sb.toString();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static final String getEthernetInterfaceMacbyASUSTOR() {
        LOG.trace("GetEthernetMacAddress START ");
        ProcessBuilder builder = new ProcessBuilder("/sbin/ifconfig");
        builder.redirectErrorStream(true);
        String serilineal = null;
        ArrayList<String> addresslist = new ArrayList<String>();
        try {
            Process process = builder.start();
            process.getOutputStream().close();
            InputStream is = process.getInputStream();
            Object object = null;
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = null;
                while ((line = br.readLine()) != null) {
                    serilineal = line;
                    String address = HardwareIdUtil.ParserMacAddress((String)serilineal);
                    if (StringUtil.IsStringNullorEmpty((String)address)) continue;
                    addresslist.add(address);
                }
            }
            catch (Throwable br) {
                object = br;
                throw br;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable br) {
                            ((Throwable)object).addSuppressed(br);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.trace("teste ={}", (Object)e.getMessage());
            serilineal = "";
        }
        addresslist.sort((p1, p2) -> p1.compareTo((String)p2));
        String returnString = "";
        for (String addr : addresslist) {
            returnString = returnString + addr;
        }
        LOG.trace("GetEthernetMacAddress end = {}", (Object)returnString);
        return returnString;
    }

    public static final String getEthernetInterfacebyid(ServerType svrType, int nSeq) {
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ServerType[svrType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return HardwareIdUtil.getEthernetInterfacebyidbyASUSTOR((int)nSeq);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return HardwareIdUtil.getLinuxHardwareId();
            }
        }
        return HardwareIdUtil.GetAddressbyID((String)"mac", (int)nSeq, (boolean)false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String getEthernetInterfacebyidbyASUSTOR(int nSeq) {
        ProcessBuilder builder = new ProcessBuilder("/sbin/ifconfig");
        builder.redirectErrorStream(true);
        String serilineal = null;
        try {
            Process process = builder.start();
            process.getOutputStream().close();
            try (InputStream is = process.getInputStream();){
                String ethid;
                String address;
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = null;
                do {
                    if ((line = br.readLine()) == null) return null;
                    serilineal = line;
                    LOG.trace("GetEthernetMacAddress line = {}", (Object)serilineal);
                } while (StringUtil.IsStringNullorEmpty((String)(address = HardwareIdUtil.ParserMacAddressbyID((String)serilineal, (String)(ethid = "eth" + String.valueOf(nSeq))))));
                String string = address;
                return string;
            }
        }
        catch (IOException e) {
            LOG.trace("teste ={}", (Object)e.getMessage());
            return null;
        }
    }

    private static final String StringToHex(String sourceString) {
        byte[] bytes = DatatypeConverter.parseHexBinary((String)sourceString);
        try {
            return new String(bytes, "UTF-16");
        }
        catch (Exception e) {
            return "";
        }
    }

    private static final String StringUTF16LEToHex(String sourceString) {
        if (!StringUtil.IsStringNullorEmpty((String)sourceString)) {
            byte[] bytes = DatatypeConverter.parseHexBinary((String)sourceString);
            try {
                return new String(bytes, "UTF-16LE");
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    private static final String HexToStringUTF16LE(String sourceString) {
        try {
            if (StringUtil.IsStringNullorEmpty((String)sourceString)) {
                return "\"\"";
            }
            String outputString = String.format("%04X", new BigInteger(1, sourceString.getBytes("UTF-16LE")));
            return outputString;
        }
        catch (Exception e) {
            return "\"\"";
        }
    }

    private static final String HexToString(String sourceString) {
        try {
            if (StringUtil.IsStringNullorEmpty((String)sourceString)) {
                return "\"\"";
            }
            String outputString = String.format("%04X", new BigInteger(1, sourceString.getBytes("UTF-16")));
            return outputString.substring(4, outputString.length());
        }
        catch (Exception e) {
            return "\"\"";
        }
    }

    public static String getOsName() {
        String OS = System.getProperty("os.name");
        LOG.trace("OS={}", (Object)OS);
        return OS;
    }

    public static boolean isWindows() {
        return HardwareIdUtil.getOsName().startsWith("Windows");
    }

    public static final String GetGoogleAddress(String street, String city, String state, String zip, String country) {
        if (HardwareIdUtil.isWindows()) {
            LOG.trace("windows addr={},{},{},{},{}", new Object[]{street, city, state, zip, country});
            String cmdString = HardwareIdUtil.HexToStringUTF16LE((String)street) + " " + HardwareIdUtil.HexToStringUTF16LE((String)city) + " " + HardwareIdUtil.HexToStringUTF16LE((String)state) + " " + HardwareIdUtil.HexToStringUTF16LE((String)zip) + " " + HardwareIdUtil.HexToStringUTF16LE((String)country);
            LOG.trace(cmdString);
            String tomcatRoot = System.getProperty("catalina.base");
            Path tomcatPath = Paths.get(tomcatRoot, new String[0]);
            Path defaultGoogleAddrLibPath = Paths.get(tomcatPath.getParent().toString(), "bin/wcaddrw.exe");
            LOG.trace(defaultGoogleAddrLibPath.toString());
            ProcessBuilder builder = new ProcessBuilder(defaultGoogleAddrLibPath.toString(), HardwareIdUtil.HexToStringUTF16LE((String)street), HardwareIdUtil.HexToStringUTF16LE((String)city), HardwareIdUtil.HexToStringUTF16LE((String)state), HardwareIdUtil.HexToStringUTF16LE((String)zip), HardwareIdUtil.HexToStringUTF16LE((String)country));
            builder.redirectErrorStream(true);
            String serial = null;
            try {
                Process process = builder.start();
                process.getOutputStream().close();
                try (InputStream is = process.getInputStream();){
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        LOG.trace("line={}", (Object)line);
                        serial = line;
                    }
                }
            }
            catch (IOException e) {
                LOG.trace("teste ={}", (Object)e.getMessage());
                serial = "";
            }
            LOG.trace(serial);
            String straddr = HardwareIdUtil.StringUTF16LEToHex((String)serial);
            LOG.trace(straddr);
            return straddr;
        }
        LOG.trace("linux addr={},{},{},{},{}", new Object[]{street, city, state, zip, country});
        String cmdString = HardwareIdUtil.HexToString((String)street) + " " + HardwareIdUtil.HexToString((String)city) + " " + HardwareIdUtil.HexToString((String)state) + " " + HardwareIdUtil.HexToString((String)zip) + " " + HardwareIdUtil.HexToString((String)country);
        LOG.trace(cmdString);
        String tomcatRoot = System.getProperty("catalina.base");
        Path tomcatPath = Paths.get(tomcatRoot, new String[0]);
        Path defaultGoogleAddrLibPath = Paths.get(tomcatPath.getParent().toString(), "bin/wcaddr");
        ProcessBuilder builder = new ProcessBuilder(defaultGoogleAddrLibPath.toString(), HardwareIdUtil.HexToString((String)street), HardwareIdUtil.HexToString((String)city), HardwareIdUtil.HexToString((String)state), HardwareIdUtil.HexToString((String)zip), HardwareIdUtil.HexToString((String)country));
        builder.redirectErrorStream(true);
        String serial = null;
        try {
            Process process = builder.start();
            process.getOutputStream().close();
            try (InputStream is = process.getInputStream();){
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = null;
                while ((line = br.readLine()) != null) {
                    LOG.trace("line={}", (Object)line);
                    serial = line;
                }
            }
        }
        catch (IOException e) {
            LOG.trace("teste ={}", (Object)e.getMessage());
            serial = "";
        }
        LOG.trace(serial);
        String straddr = HardwareIdUtil.StringToHex((String)serial);
        LOG.trace(straddr);
        return straddr;
    }

    public static final String GetMachineID(ServerType svrType) {
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ServerType[svrType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return HardwareIdUtil.GetASUSSerial();
            }
            case 8: {
                return HardwareIdUtil.readRegistry((String)"HKLM\\SOFTWARE\\Microsoft\\Cryptography", (String)"MachineGuid");
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return HardwareIdUtil.getLinuxHardwareId();
            }
        }
        return "";
    }

    public static final String readRegistry(String location, String key) {
        try {
            String[] parsed;
            Process process = Runtime.getRuntime().exec("reg query \"" + location + '\"' + "  /v " + key);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String output = reader.getResult();
            LOG.debug("readRegistry output = {}", (Object)output);
            if (!output.contains("\r")) {
                return null;
            }
            for (String ss : parsed = output.split("\r")) {
                LOG.debug("readRegistry parsed = {}", (Object)ss);
                String[] parsspace = ss.split(" ");
                int nseq = 0;
                int bFindKeyIdx = 0;
                for (String space : parsspace) {
                    if (space.compareToIgnoreCase("") == 0) continue;
                    ++nseq;
                    if (space.compareToIgnoreCase(key) == 0) {
                        ++bFindKeyIdx;
                        continue;
                    }
                    if (bFindKeyIdx == 2) {
                        return space;
                    }
                    if (bFindKeyIdx <= 0) continue;
                    ++bFindKeyIdx;
                }
            }
        }
        catch (Exception e) {
            LOG.debug("readRegistry exception  = {}", (Object)e.getMessage());
            return null;
        }
        LOG.debug("readRegistry return null");
        return null;
    }

    public static final String GetASUSSerial() {
        LOG.trace("GetASUSSerial ");
        String tomcatRoot = System.getProperty("catalina.base");
        Path tomcatPath = Paths.get(tomcatRoot, new String[0]);
        Path defaultASUSSNPath = Paths.get(tomcatPath.getParent().toString(), "bin/vents");
        File f = new File(defaultASUSSNPath.toString());
        if (!f.exists() || f.isDirectory()) {
            return "";
        }
        if (f.length() != 14203L) {
            return "";
        }
        ProcessBuilder builder = new ProcessBuilder(defaultASUSSNPath.toString(), "-getserial");
        builder.redirectErrorStream(true);
        String serial = null;
        try {
            Process process = builder.start();
            process.getOutputStream().close();
            try (InputStream is = process.getInputStream();){
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = null;
                while ((line = br.readLine()) != null) {
                    String serialNumber = HardwareIdUtil.ParserSerialNumber((String)line);
                    if (StringUtil.IsStringNullorEmpty((String)serialNumber)) continue;
                    serial = serialNumber;
                    break;
                }
            }
        }
        catch (IOException e) {
            LOG.trace("teste ={}", (Object)e.getMessage());
            serial = "";
        }
        LOG.trace("GetASUSSerial END");
        return serial;
    }

    public static final String GetQSMSystemID() {
        File f = new File("/proc/ems/sys_sn");
        if (!f.exists() || f.isDirectory()) {
            return "NOQSM";
        }
        ProcessBuilder builder = new ProcessBuilder("/bin/cat", "/proc/ems/sys_sn");
        builder.redirectErrorStream(true);
        String serial = null;
        try {
            Process process = builder.start();
            process.getOutputStream().close();
            try (InputStream is = process.getInputStream();
                 Scanner sc = new Scanner(is);){
                serial = sc.next();
            }
        }
        catch (IOException e) {
            serial = "";
        }
        return serial;
    }

    public static final String getWindowsHardwareId() {
        String serial = null;
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"wmic", "csproduct", "get", "UUID"});
            process.getOutputStream().close();
            try (InputStream is = process.getInputStream();
                 Scanner sc = new Scanner(is);){
                String property = sc.next();
                serial = sc.next();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return serial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getLinuxHardwareId() {
        LOG.trace("getLinuxHardwareId 1");
        String command = "dmidecode -s system-uuid";
        LOG.trace("command 1");
        String uuid = null;
        try {
            LOG.trace("getLinuxHardwareId 2");
            Process SerNumProcess = Runtime.getRuntime().exec(command);
            BufferedReader sNumReader = new BufferedReader(new InputStreamReader(SerNumProcess.getInputStream()));
            String line = null;
            LOG.trace("getLinuxHardwareId 3");
            SerNumProcess.waitFor();
            while ((line = sNumReader.readLine()) != null) {
                LOG.trace("line={}", (Object)line);
                uuid = line;
                SerNumProcess.waitFor();
            }
            sNumReader.close();
            LOG.trace("getLinuxHardwareId 4");
        }
        catch (Exception ex) {
            LOG.trace("getLinuxHardwareId Exp ={}", (Object)ex.getMessage());
            uuid = null;
            return uuid;
        }
        finally {
            return uuid;
        }
    }
}

