/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.Utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.penpower.worldcard.team.Utils.ApplicationContextProvider;
import com.penpower.worldcard.team.Utils.CollectionUtil;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.crm.salesforce.SalesforceErrorResponse;
import com.penpower.worldcard.team.dto.MailSettingInfo;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.entity.Globalinfocompany;
import com.penpower.worldcard.team.enums.ContactField;
import com.penpower.worldcard.team.enums.CrmExportFailedReason;
import com.penpower.worldcard.team.enums.CrmTargetType;
import com.penpower.worldcard.team.enums.NameDisplayOrderSettingType;
import com.penpower.worldcard.team.enums.Platform;
import com.penpower.worldcard.team.enums.PlatformCategory;
import com.penpower.worldcard.team.enums.PlatformForDevice;
import com.penpower.worldcard.team.enums.PlatformForSecurity;
import com.penpower.worldcard.team.enums.SalesforceErrorCode;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.MailConnectionException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.service.CRMOperationService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.web.api.vo.IntervalFilter;
import com.penpower.worldcard.team.web.api.vo.ItemBasicVo;
import com.penpower.worldcard.team.web.api.vo.PageInfo;
import com.sun.mail.smtp.SMTPSendFailedException;
import io.jsonwebtoken.impl.TextCodec;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import net.markenwerk.utils.mail.dkim.Canonicalization;
import net.markenwerk.utils.mail.dkim.DkimException;
import net.markenwerk.utils.mail.dkim.DkimMessage;
import net.markenwerk.utils.mail.dkim.DkimSigner;
import net.markenwerk.utils.mail.dkim.SigningAlgorithm;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tika.Tika;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Sort;

/*
 * Exception performing whole class analysis ignored.
 */
public class GlobalUtils {
    public static final String CHECK_STRING_CONTAINS_KEYWORD_PATTERN = "[\\u3000-\\u303F]+|[\\u9FA6-\\u9FBB]+|[\\u3400-\\u4DB5]+|[\\u4E00-\\u9FA5]+|[\\uF900-\\uFA2D]+|[\\uFA30-\\uFA6A]+|[\\uFA70-\\uFAD9]+|[\\uFF00-\\uFFEF]+|[\\u2E80-\\u2EFF]+|[\\u31C0-\\u31EF]+";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static ServerType serverType = ServerType.Google_Linux_Server_Cloud;
    private static final Logger LOG = LoggerFactory.getLogger(GlobalUtils.class);
    private static String FIELD_NAME_NAME_EAST_FL_WEST_FL = "fullnameeastfirstwestfirst";
    private static String FIELD_NAME_NAME_EAST_FL_WEST_LF = "fullnameeastfirstwestlast";
    private static String FIELD_NAME_NAME_EAST_LF_WEST_FL = "fullnameeastlastwestfirst";
    private static String FIELD_NAME_NAME_EAST_LF_WEST_LF = "fullnameeastlastwestlast";
    private static String FIELD_NAME_COMPANY = "company";
    private static String FIELD_NAME_DEPARTMENT = "department";
    private static String FIELD_NAME_JOBTITLE = "jobtitle";
    private static String FIELD_NAME_CREATED_TIME = "createtime";
    private static String FIELD_NAME_GUID = "guid";

    public static final PlatformCategory getPlatformCategory(Platform platform) {
        if (Platform.ANDROID.equals((Object)platform) || Platform.IOS.equals((Object)platform)) {
            return PlatformCategory.MOBILE_PHONES;
        }
        if (Platform.ANDROID_TABLET.equals((Object)platform) || Platform.IPAD.equals((Object)platform)) {
            return PlatformCategory.TABLET_IPADS;
        }
        if (Platform.PC.equals((Object)platform) || Platform.MAC.equals((Object)platform)) {
            return PlatformCategory.PC;
        }
        if (Platform.WEB.equals((Object)platform)) {
            return PlatformCategory.WEB;
        }
        return PlatformCategory.SCANNER;
    }

    public static boolean IsCloudServerType(ServerType svrType) {
        return svrType == ServerType.Google_Linux_Server_Cloud || svrType == ServerType.ASUSTOR_NAS_Cloud || svrType == ServerType.ASUSTOR_NAS_AUTOMATION || svrType == ServerType.Linux_Server_Cloud;
    }

    public static int compareVersions(String version1, String version2) {
        int comparisonResult = 0;
        String[] version1Splits = version1.split("\\.");
        String[] version2Splits = version2.split("\\.");
        int maxLengthOfVersionSplits = Math.max(version1Splits.length, version2Splits.length);
        for (int i = 0; i < maxLengthOfVersionSplits; ++i) {
            Integer v2;
            Integer v1 = i < version1Splits.length ? Integer.parseInt(version1Splits[i]) : 0;
            int compare = v1.compareTo(v2 = Integer.valueOf(i < version2Splits.length ? Integer.parseInt(version2Splits[i]) : 0));
            if (compare == 0) continue;
            comparisonResult = compare;
            break;
        }
        return comparisonResult;
    }

    public static final PlatformForSecurity getPlatformForSecurity(Platform platform) {
        switch (10.$SwitchMap$com$penpower$worldcard$team$enums$Platform[platform.ordinal()]) {
            case 1: 
            case 2: {
                return PlatformForSecurity.IOS;
            }
            case 3: 
            case 4: {
                return PlatformForSecurity.ANDROID;
            }
            case 5: {
                return PlatformForSecurity.WINDOWS;
            }
            case 6: {
                return PlatformForSecurity.MAC;
            }
            case 7: {
                return PlatformForSecurity.WEB;
            }
            case 8: {
                return PlatformForSecurity.SCANNER;
            }
        }
        return null;
    }

    public static ServerType getServerType() {
        return serverType;
    }

    public static void setServerType(ServerType svrtype) {
        serverType = svrtype;
    }

    public static final PlatformForDevice getPlatformForDevice(Platform platform) {
        if (platform != Platform.WEB) {
            PlatformForSecurity platformForSecurtiy = GlobalUtils.getPlatformForSecurity((Platform)platform);
            return PlatformForDevice.valueOf((String)platformForSecurtiy.toString());
        }
        return null;
    }

    public static final List<Platform> getPlatformByPlatformForSecurity(PlatformForDevice platformForDevice) {
        ArrayList<Platform> platforms = new ArrayList<Platform>();
        switch (10.$SwitchMap$com$penpower$worldcard$team$enums$PlatformForDevice[platformForDevice.ordinal()]) {
            case 1: {
                platforms.add(Platform.IOS);
                platforms.add(Platform.IPAD);
                break;
            }
            case 2: {
                platforms.add(Platform.ANDROID);
                platforms.add(Platform.ANDROID_TABLET);
                break;
            }
            case 3: {
                platforms.add(Platform.PC);
                break;
            }
            case 4: {
                platforms.add(Platform.MAC);
                break;
            }
            case 5: {
                platforms.add(Platform.SCANNER);
            }
        }
        return platforms;
    }

    public static final void setProperty(CompanyGlobalInfoService globalInfoService, String ConfigureKey, String value, String companyGuid) {
        Globalinfocompany gObject = globalInfoService.getPropertiesByKey(ConfigureKey, companyGuid);
        if (gObject == null) {
            globalInfoService.createNewProperties(ConfigureKey, value, companyGuid);
        } else {
            globalInfoService.updatePropertyValue(gObject.getGuid(), value);
        }
    }

    public static final String getProperty(CompanyGlobalInfoService globalInfoService, String ConfigureKey, String companyGuid) {
        Globalinfocompany gObject = globalInfoService.getPropertiesByKey(ConfigureKey, companyGuid);
        if (gObject != null) {
            return gObject.getConfigValue();
        }
        return "";
    }

    public static final void setProperty(GlobalInfoService globalInfoService, String ConfigureKey, String value) {
        Globalinfo gObject = globalInfoService.getPropertiesByKey(ConfigureKey);
        if (gObject == null) {
            globalInfoService.createNewProperties(ConfigureKey, value);
        } else {
            globalInfoService.updatePropertyValue(gObject.getGuid(), value);
        }
    }

    public static final String getProperty(GlobalInfoService globalInfoService, String ConfigureKey) {
        Globalinfo gObject = globalInfoService.getPropertiesByKey(ConfigureKey);
        if (gObject != null) {
            return gObject.getConfigValue();
        }
        return "";
    }

    public static final boolean stringContainsChineseWord(String keyWord) {
        try {
            Pattern pattern = Pattern.compile("[\\u3000-\\u303F]+|[\\u9FA6-\\u9FBB]+|[\\u3400-\\u4DB5]+|[\\u4E00-\\u9FA5]+|[\\uF900-\\uFA2D]+|[\\uFA30-\\uFA6A]+|[\\uFA70-\\uFAD9]+|[\\uFF00-\\uFFEF]+|[\\u2E80-\\u2EFF]+|[\\u31C0-\\u31EF]+");
            Matcher matcher = pattern.matcher(keyWord);
            return matcher.find();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final boolean collectionEmpty(Collection<?> collection) {
        return CollectionUtil.collectionEmpty(collection);
    }

    public static final String getFileContent(Path file) {
        Tika tika = new Tika();
        try {
            String fileContent = tika.detect(file);
            return fileContent;
        }
        catch (IOException e) {
            return "application/octet-stream";
        }
    }

    public static final String getFileContent(byte[] content) {
        Tika tika = new Tika();
        String fileContent = tika.detect(content);
        return fileContent;
    }

    private static String getFieldName(PageInfo<ContactField> pageInfo, NameDisplayOrderSettingType nameDisplayOrderSettingType) {
        String fieldName;
        ContactField field = (ContactField)pageInfo.getFieldOrderBy();
        switch (10.$SwitchMap$com$penpower$worldcard$team$enums$ContactField[field.ordinal()]) {
            case 1: {
                if (NameDisplayOrderSettingType.EAST_FL_WEST_FL.equals((Object)nameDisplayOrderSettingType)) {
                    fieldName = FIELD_NAME_NAME_EAST_FL_WEST_FL;
                    break;
                }
                if (NameDisplayOrderSettingType.EAST_FL_WEST_LF.equals((Object)nameDisplayOrderSettingType)) {
                    fieldName = FIELD_NAME_NAME_EAST_FL_WEST_LF;
                    break;
                }
                if (NameDisplayOrderSettingType.EAST_LF_WEST_FL.equals((Object)nameDisplayOrderSettingType)) {
                    fieldName = FIELD_NAME_NAME_EAST_LF_WEST_FL;
                    break;
                }
                fieldName = FIELD_NAME_NAME_EAST_LF_WEST_LF;
                break;
            }
            case 2: {
                fieldName = FIELD_NAME_COMPANY;
                break;
            }
            case 3: {
                fieldName = FIELD_NAME_DEPARTMENT;
                break;
            }
            case 4: {
                fieldName = FIELD_NAME_JOBTITLE;
                break;
            }
            case 5: {
                fieldName = FIELD_NAME_CREATED_TIME;
                break;
            }
            default: {
                fieldName = FIELD_NAME_CREATED_TIME;
            }
        }
        return fieldName;
    }

    public static final String getSortString(PageInfo<ContactField> pageInfo, NameDisplayOrderSettingType nameDisplayOrderSettingType) {
        String fieldName = GlobalUtils.getFieldName(pageInfo, (NameDisplayOrderSettingType)nameDisplayOrderSettingType);
        if (pageInfo.isAscendingOrder()) {
            return fieldName + " " + Sort.Direction.ASC.toString();
        }
        return fieldName + " " + Sort.Direction.DESC.toString();
    }

    public static final Sort getSortProperty(PageInfo<ContactField> pageInfo, NameDisplayOrderSettingType nameDisplayOrderSettingType) {
        String fieldName = GlobalUtils.getFieldName(pageInfo, (NameDisplayOrderSettingType)nameDisplayOrderSettingType);
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        if (pageInfo.isAscendingOrder()) {
            orders.add(new Sort.Order(Sort.Direction.ASC, fieldName));
        } else {
            orders.add(new Sort.Order(Sort.Direction.DESC, fieldName));
        }
        if (!((ContactField)pageInfo.getFieldOrderBy()).equals((Object)ContactField.CREATED_TIME)) {
            orders.add(new Sort.Order(Sort.Direction.DESC, FIELD_NAME_CREATED_TIME));
        }
        orders.add(new Sort.Order(Sort.Direction.ASC, FIELD_NAME_GUID));
        Sort sort = new Sort(orders);
        return sort;
    }

    public static final String getJsonString(Object obj) {
        Gson gson = new Gson();
        String jsonString = gson.toJson(obj);
        return jsonString;
    }

    public static final String getJsonStringWithDateTimeSerializer(Object obj) {
        Gson gson = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new /* Unavailable Anonymous Inner Class!! */).create();
        return gson.toJson(obj);
    }

    public static final <T> T getObjectFromJsonWithDateTimeSerializer(String json, Class<T> classOfT) {
        try {
            if (StringUtils.isEmpty((String)json)) {
                return null;
            }
            Gson gson = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new /* Unavailable Anonymous Inner Class!! */).create();
            Object resultContent = gson.fromJson(json, classOfT);
            return (T)resultContent;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static final <T> T getObjectFromJson(String json, Class<T> classOfT) {
        try {
            if (StringUtil.IsStringNullorEmpty((String)json)) {
                return null;
            }
            Gson gson = new Gson();
            Object resultContent = gson.fromJson(json, classOfT);
            return (T)resultContent;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static List<String> getGuidsFromBasicItems(List<ItemBasicVo> basicItems) {
        ArrayList<String> guids = CollectionUtils.isEmpty(basicItems) ? new ArrayList<String>() : basicItems.stream().map(c -> c.getGuid()).collect(Collectors.toList());
        return guids;
    }

    public static String[] getGuidArrayFromBasicItems(List<ItemBasicVo> basicItems) {
        List guids = GlobalUtils.getGuidsFromBasicItems(basicItems);
        String[] guidArray = new String[guids.size()];
        guids.toArray(guidArray);
        return guidArray;
    }

    public static CRMOperationService getCrmOperationService(CrmTargetType crmTargetType) {
        CRMOperationService crmOperationService = null;
        ApplicationContext context = ApplicationContextProvider.getApplicationContext();
        switch (10.$SwitchMap$com$penpower$worldcard$team$enums$CrmTargetType[crmTargetType.ordinal()]) {
            case 1: {
                crmOperationService = (CRMOperationService)context.getBean("SalesforceLeadOperation");
                break;
            }
            case 2: {
                crmOperationService = (CRMOperationService)context.getBean("SalesforceContactOperation");
                break;
            }
            case 3: {
                crmOperationService = (CRMOperationService)context.getBean("SugarCRMOperation");
                break;
            }
            default: {
                throw new ItemNotFoundException("There is no specified CRM target type.");
            }
        }
        return crmOperationService;
    }

    public static IntervalFilter checkIntervalFilter(IntervalFilter filter) {
        IntervalFilter intervalFilter = filter;
        DateTime earliestTime = new DateTime(1900, 1, 1, 0, 0);
        DateTime currentTime = new DateTime();
        if (intervalFilter == null) {
            intervalFilter = new IntervalFilter(earliestTime, currentTime);
        } else {
            if (intervalFilter.getTimeStart() == null) {
                intervalFilter.setTimeStart(earliestTime);
            }
            if (intervalFilter.getTimeEnd() == null) {
                intervalFilter.setTimeEnd(currentTime);
            }
            if (intervalFilter.getTimeEnd().isBefore((ReadableInstant)intervalFilter.getTimeStart())) {
                throw new RequestArgumentNotValidException("End time of interval filter is before start time");
            }
        }
        return intervalFilter;
    }

    public static DateTime getEarliestTime() {
        return new DateTime(1900, 1, 1, 0, 0, 0, DateTimeZone.UTC);
    }

    public static Optional<?> getFirstListItem(List<?> listItem) {
        List objects = Optional.ofNullable(listItem).orElse(Collections.emptyList());
        Optional firstObject = objects.stream().findFirst();
        return firstObject;
    }

    public static String getFieldString(String inputString, int maxLength) {
        if (inputString == null) {
            return "";
        }
        String retStr = inputString.substring(0, Math.min(inputString.length(), maxLength));
        return retStr;
    }

    public static boolean isExceptionCategoryHasContactDuplicate(Exception e) {
        String rootCauseString = ExceptionUtils.getRootCause((Throwable)e).getMessage();
        return rootCauseString.contains("idx_17010_primary");
    }

    public static String getFieldString(String inputString) {
        return inputString == null ? "" : inputString;
    }

    public static Map<NameDisplayOrderSettingType, String> getNameOrderString(String firstName, String lastName) {
        HashMap<NameDisplayOrderSettingType, String> nameOrder = new HashMap<NameDisplayOrderSettingType, String>();
        String first = GlobalUtils.getFieldString((String)firstName);
        String last = GlobalUtils.getFieldString((String)lastName);
        String fullnameFL = String.format("%s%s", first, last);
        String fullnameLF = String.format("%s%s", last, first);
        if (!GlobalUtils.stringContainsChineseWord((String)fullnameFL)) {
            fullnameFL = String.format("%s %s", first, last);
            fullnameLF = String.format("%s %s", last, first);
            fullnameFL = fullnameFL.trim().replaceAll(" +", " ");
            fullnameLF = fullnameLF.trim().replaceAll(" +", " ");
            nameOrder.put(NameDisplayOrderSettingType.EAST_LF_WEST_FL, fullnameFL);
            nameOrder.put(NameDisplayOrderSettingType.EAST_FL_WEST_LF, fullnameLF);
        } else {
            nameOrder.put(NameDisplayOrderSettingType.EAST_LF_WEST_FL, fullnameLF);
            nameOrder.put(NameDisplayOrderSettingType.EAST_FL_WEST_LF, fullnameFL);
        }
        nameOrder.put(NameDisplayOrderSettingType.EAST_FL_WEST_FL, fullnameFL);
        nameOrder.put(NameDisplayOrderSettingType.EAST_LF_WEST_LF, fullnameLF);
        return nameOrder;
    }

    public static Path getdkimPath() {
        ClassLoader classLoader = GlobalUtils.class.getClassLoader();
        File file = new File(classLoader.getResource("dkim.der").getFile());
        String fileDecode = null;
        try {
            fileDecode = URLDecoder.decode(file.getAbsolutePath(), "UTF-8");
            LOG.info("getdkimPath={}", (Object)file.toPath());
            LOG.info("getdkimDecodePath={}", (Object)Paths.get(fileDecode, new String[0]));
            return Paths.get(fileDecode, new String[0]);
        }
        catch (UnsupportedEncodingException ex) {
            LOG.info("getdkimPath={}", (Object)file.toPath());
            LOG.info("getdkimDecodePath={}", (Object)fileDecode);
            return file.toPath();
        }
    }

    public static String getHostUrlByTSMC(String aHostURL, String aParameter) {
        StringBuilder response = new StringBuilder();
        try {
            DataOutputStream wr;
            LOG.debug("getHostUrlByTSCM aHostURL=" + aHostURL + "\n");
            LOG.debug("getHostUrlByTSCM aParameter=" + aParameter);
            URL url = new URL(aHostURL);
            HttpsURLConnection connection = GlobalUtils.getHttpsURLConnection0602((URL)url);
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            if (!StringUtil.IsStringNullorEmpty((String)aParameter)) {
                wr = new DataOutputStream(connection.getOutputStream());
                byte[] data = aParameter.getBytes("utf-8");
                wr.write(data);
                wr.flush();
                wr.close();
                LOG.debug("getHostUrlByTSCM data=" + data.toString());
            } else {
                wr = new DataOutputStream(connection.getOutputStream());
                wr.close();
            }
            int status = connection.getResponseCode();
            LOG.debug("getHostUrlByTSCM status=" + status + "\n");
            if (status == 200) {
                String line;
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                    response.append('\r');
                }
                reader.close();
                inputStream.close();
                LOG.debug("getHostUrlByTSCM response=" + response.toString() + "\n");
            }
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
            LOG.debug("getHostUrlByTSCM SocketTimeoutException=" + e.getMessage() + "\n");
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.debug("getHostUrlByTSCM IOException=" + e.getMessage() + "\n");
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            LOG.debug("NoSuchAlgorithmException: " + e.getMessage() + "\n");
            e.printStackTrace();
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (KeyManagementException e) {
            LOG.debug("KeyManagementException: " + e.getMessage() + "\n");
            e.printStackTrace();
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ItemNotFoundException(e.getMessage());
        }
        LOG.debug("getHostUrlByTSCM response=" + response.toString() + "\n");
        return response.toString();
    }

    public static HttpsURLConnection getHttpsURLConnection0602(URL url) throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setSSLSocketFactory(sc.getSocketFactory());
        4 hostnameVerifier = new /* Unavailable Anonymous Inner Class!! */;
        connection.setHostnameVerifier((HostnameVerifier)hostnameVerifier);
        return connection;
    }

    public static void testMail(String MailSettingJson) throws MailConnectionException, IOException {
        MailSettingInfo MailSetting = null;
        String mailFrom = "";
        LOG.debug("sendMail in mailTo={},subject={},Body={},Content={},MailSettingJson={}", (Object)MailSettingJson);
        try {
            if (!StringUtil.IsStringNullorEmpty((String)MailSettingJson)) {
                Gson gson = new Gson();
                MailSetting = (MailSettingInfo)gson.fromJson(MailSettingJson, MailSettingInfo.class);
            }
        }
        catch (Exception ee) {
            LOG.error("sendMail load setting =" + ee.getMessage());
            throw new MailConnectionException("sendMail Mail Setting load exception", (Throwable)ee);
        }
        try {
            Properties props;
            if (MailSetting == null) {
                LOG.debug("sendMail mailsetting is null");
                props = new Properties();
                props.put("mail.smtp.auth", "true");
                props.put("mail.smtp.starttls.enable", "true");
                props.put("mail.smtp.starttls.enable", "true");
                props.put("mail.smtp.ssl.trust", "mail.worldcardteam.com");
                props.put("mail.smtp.host", "mail.worldcardteam.com");
                props.put("mail.smtp.port", (Object)25);
                Session session = Session.getInstance((Properties)props, (Authenticator)new /* Unavailable Anonymous Inner Class!! */);
                Transport transport = session.getTransport("smtp");
                transport.connect();
            } else {
                LOG.debug("sendMail mailsetting = {}", MailSetting);
                props = new Properties();
                if (MailSetting.isSmtpAuth()) {
                    props.put("mail.smtp.auth", "true");
                } else {
                    props.put("mail.smtp.auth", "false");
                }
                if (MailSetting.isSmtpstarttls()) {
                    props.put("mail.smtp.starttls.enable", "true");
                } else {
                    props.put("mail.smtp.starttls.enable", "false");
                }
                props.put("mail.smtp.ssl.trust", MailSetting.getHost());
                props.put("mail.smtp.host", MailSetting.getHost());
                props.put("mail.smtp.port", (Object)MailSetting.getPort());
                String username = MailSetting.getUserName();
                String password = MailSetting.getPassWord();
                Session session = Session.getInstance((Properties)props, (Authenticator)new /* Unavailable Anonymous Inner Class!! */);
                Transport transport = session.getTransport("smtp");
                transport.connect();
                transport.close();
            }
        }
        catch (Exception e) {
            LOG.error("sendMail exception  = {}", (Object)e.getMessage());
            throw new MailConnectionException("sendMail exception", (Throwable)e);
        }
    }

    public static void sendMail(String mailTo, String subject, String Body, String Content, String MailSettingJson) throws MailConnectionException, IOException {
        MailSettingInfo MailSetting = null;
        String mailFrom = "";
        LOG.debug("sendMail in mailTo={},subject={},Body={},Content={},MailSettingJson={},", new Object[]{mailTo, subject, Body, Content, MailSettingJson});
        try {
            if (!StringUtil.IsStringNullorEmpty((String)MailSettingJson)) {
                Gson gson = new Gson();
                MailSetting = (MailSettingInfo)gson.fromJson(MailSettingJson, MailSettingInfo.class);
            }
        }
        catch (Exception ee) {
            LOG.error("sendMail load setting =" + ee.getMessage());
            throw new MailConnectionException("sendMail Mail Setting load exception", (Throwable)ee);
        }
        try {
            Properties props;
            MimeMessage msg = null;
            Session session = null;
            if (MailSetting == null) {
                LOG.debug("sendMail mailsetting is null");
                props = new Properties();
                props.put("mail.smtp.auth", "true");
                props.put("mail.smtp.starttls.enable", "true");
                props.put("mail.smtp.starttls.enable", "true");
                props.put("mail.smtp.ssl.trust", "mail.worldcardteam.com");
                props.put("mail.smtp.host", "mail.worldcardteam.com");
                props.put("mail.smtp.port", (Object)25);
                session = Session.getInstance((Properties)props, (Authenticator)new /* Unavailable Anonymous Inner Class!! */);
                msg = new MimeMessage(session);
                mailFrom = "WorldCard Team Service<wctservice@mail.worldcardteam.com>";
            } else {
                LOG.debug("sendMail mailsetting = {}", (Object)MailSetting);
                props = new Properties();
                if (MailSetting.isSmtpAuth()) {
                    props.put("mail.smtp.auth", "true");
                } else {
                    props.put("mail.smtp.auth", "false");
                }
                if (MailSetting.isSmtpstarttls()) {
                    props.put("mail.smtp.starttls.enable", "true");
                } else {
                    props.put("mail.smtp.starttls.enable", "false");
                }
                props.put("mail.smtp.ssl.trust", MailSetting.getHost());
                props.put("mail.smtp.host", MailSetting.getHost());
                props.put("mail.smtp.port", (Object)MailSetting.getPort());
                String username = MailSetting.getUserName();
                String password = MailSetting.getPassWord();
                session = Session.getInstance((Properties)props, (Authenticator)new /* Unavailable Anonymous Inner Class!! */);
                msg = new MimeMessage(session);
                mailFrom = MailSetting.getUserName() + "@" + MailSetting.getHost();
            }
            LOG.debug("Send nail mailFrom={}", (Object)mailFrom);
            msg.setFrom((Address)new InternetAddress(mailFrom, false));
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)mailTo));
            msg.setSubject(subject);
            msg.setSentDate(new Date());
            msg.setContent((Object)Body, Content);
            Transport transport = session.getTransport("smtp");
            transport.connect();
            LOG.debug("Send nail before send");
            if (MailSetting == null) {
                MimeMessage dkimSignedMessage = GlobalUtils.getDkimSignMessage((MimeMessage)msg);
                Transport.send((Message)dkimSignedMessage);
            } else {
                Transport.send((Message)msg);
            }
            transport.close();
        }
        catch (SMTPSendFailedException e) {
            LOG.error("SMTPSendFailedException exception  = {}", (Object)e.getMessage());
            LOG.error("SMTPSendFailedException return  = {}", (Object)e.getReturnCode());
            throw new MailConnectionException("SMTPSendFailedException exception", (Throwable)e);
        }
        catch (MessagingException ex) {
            LOG.error("MessagingException exception  = {}", (Object)ex.getMessage());
            throw new MailConnectionException("MessagingException exception", (Throwable)ex);
        }
        catch (NoSuchAlgorithmException eex) {
            LOG.error("NoSuchAlgorithmException exception  = {}", (Object)eex.getMessage());
            throw new MailConnectionException("NoSuchAlgorithmException exception", (Throwable)eex);
        }
        catch (InvalidKeySpecException eeex) {
            LOG.error("NoSuchAlgorithmException exception  = {}", (Object)eeex.getMessage());
            throw new MailConnectionException("NoSuchAlgorithmException exception", (Throwable)eeex);
        }
    }

    public static MimeMessage getDkimSignMessage(MimeMessage message) throws MessagingException, NoSuchAlgorithmException, InvalidKeySpecException, DkimException, IOException {
        String from = "WorldCard Team Service<wctservice@mail.worldcardteam.com>";
        String signingDomain = "mail.worldcardteam.com";
        String selector = "mail";
        String senderMail = from.substring(from.indexOf("<") + 1, from.indexOf(">"));
        DkimSigner dkimSigner = new DkimSigner(signingDomain, selector, GlobalUtils.getdkimPath().toFile());
        dkimSigner.setIdentity(senderMail);
        dkimSigner.setHeaderCanonicalization(Canonicalization.RELAXED);
        dkimSigner.setBodyCanonicalization(Canonicalization.RELAXED);
        dkimSigner.setSigningAlgorithm(SigningAlgorithm.SHA256_WITH_RSA);
        dkimSigner.setLengthParam(false);
        dkimSigner.setZParam(false);
        return new DkimMessage(message, dkimSigner);
    }

    public static final boolean isAdAccountPattern(String account) {
        int firstIndex = account.indexOf("\\");
        int lastIndex = account.lastIndexOf("\\");
        if (firstIndex == -1) {
            return false;
        }
        return firstIndex == lastIndex && firstIndex != 0 && account.length() - 1 != firstIndex;
    }

    public static CrmExportFailedReason getCRMExportFailedReason(String errorMessage) {
        try {
            Gson gson = new Gson();
            List list = (List)gson.fromJson(errorMessage, new /* Unavailable Anonymous Inner Class!! */.getType());
            if (CollectionUtils.isEmpty((Collection)list)) {
                return CrmExportFailedReason.OTHER;
            }
            SalesforceErrorResponse response = (SalesforceErrorResponse)list.get(0);
            if (response.getErrorCode().equals((Object)SalesforceErrorCode.UNKNOWN_ACCOUNT)) {
                return CrmExportFailedReason.UNKNOWN_ACCOUNT;
            }
            return CrmExportFailedReason.OTHER;
        }
        catch (Exception ex) {
            return CrmExportFailedReason.OTHER;
        }
    }

    public static String removeKeyElementFromJsonString(String source, String ... keys) {
        JSONObject jsonObject = new JSONObject(source);
        for (String k : keys) {
            if (!jsonObject.has(k)) continue;
            jsonObject.remove(k);
        }
        return jsonObject.toString();
    }

    public static final String base64UrlEncode(Object o) {
        byte[] bytes;
        try {
            bytes = GlobalUtils.toJson((Object)o);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return TextCodec.BASE64URL.encode(bytes);
    }

    public static final <T> T base64UrlDecode(String base64EncodeUrl, Class<T> classOfT) {
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String decodedString = new String(decoder.decode(base64EncodeUrl));
        return (T)new Gson().fromJson(decodedString, classOfT);
    }

    private static byte[] toJson(Object object) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsBytes(object);
    }
}

