--
-- TOC entry 1 (class 3079 OID 12355)
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- TOC entry 2700 (class 0 OID 0)
-- Dependencies: 1
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


--
-- TOC entry 2 (class 3079 OID 203183)
-- Name: pg_trgm; Type: EXTENSION; Schema: -; Owner: 
--
CREATE EXTENSION IF NOT EXISTS pg_trgm WITH SCHEMA public;


--
-- TOC entry 2701 (class 0 OID 0)
-- Dependencies: 2
-- Name: EXTENSION pg_trgm; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION pg_trgm IS 'text similarity measurement and index searching based on trigrams';


--
-- TOC entry 183 (class 1259 OID 202310)
-- Name: account; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE account (
    guid character varying(36) NOT NULL,
    email text NOT NULL,
    password text NOT NULL,
    displayname text NOT NULL,
    logofilepath text,
    createtime timestamp with time zone NOT NULL,
    status text NOT NULL,
    role text NOT NULL,
    exportability integer DEFAULT 0 NOT NULL,
    boss character varying(36),
    company_guid character varying(36) NOT NULL,
    categoryorderupdatetime timestamp with time zone,
    resigndate timestamp with time zone,
    inheritdate timestamp with time zone,
    inheritedaccount character varying(36),
    secretary integer DEFAULT 0 NOT NULL,
    printability integer DEFAULT 0 NOT NULL,
    inheritancestatus text,
    contactcountinprivate integer DEFAULT 0 NOT NULL
);


ALTER TABLE account OWNER TO postgres;

--
-- TOC entry 184 (class 1259 OID 202317)
-- Name: account_can_view_activity; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE account_can_view_activity (
    account_guid character varying(36) NOT NULL,
    activity_guid character varying(36) NOT NULL
);


ALTER TABLE account_can_view_activity OWNER TO postgres;

--
-- TOC entry 185 (class 1259 OID 202320)
-- Name: account_can_view_contact; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE account_can_view_contact (
    account_guid character varying(36) NOT NULL,
    contact_guid character varying(36) NOT NULL
);


ALTER TABLE account_can_view_contact OWNER TO postgres;

--
-- TOC entry 186 (class 1259 OID 202323)
-- Name: account_can_view_task; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE account_can_view_task (
    account_guid character varying(36) NOT NULL,
    task_guid character varying(36) NOT NULL
);


ALTER TABLE account_can_view_task OWNER TO postgres;

--
-- TOC entry 187 (class 1259 OID 202326)
-- Name: account_private_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE account_private_settings (
    guid character varying(36) NOT NULL,
    contactsperpage bigint,
    viewmodeinpublicarea text,
    mapengine text DEFAULT 'auto'::text NOT NULL,
    westernsurnameorder text DEFAULT 'firstname_lastname'::text NOT NULL,
    asiansurnameorder text DEFAULT 'lastname_firstname'::text NOT NULL,
    showownerinfo integer DEFAULT 0 NOT NULL,
    autoshare integer DEFAULT 0 NOT NULL,
    sharecontact integer DEFAULT 0 NOT NULL,
    sharetask integer DEFAULT 0 NOT NULL,
    shareactivity integer DEFAULT 0 NOT NULL,
    shareaccounts text,
    lastnoticecountview timestamp with time zone,
    sortingorder text DEFAULT 'name'::text NOT NULL,
    identificationresult text DEFAULT 'contact_content'::text NOT NULL,
    account_guid character varying(36) NOT NULL,
    userstoredcrmtype character varying(30),
    crmexportmode character varying(30),
    usercrmaccount character varying(45),
    usercrmpassword character varying(45),
    usercrmsecrettoken character varying(250),
    consumerkey character varying(250),
    consumersecret character varying(250),
    crmlogintoken text,
    usercrmtokentype character varying(45),
    modifytime timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    lastexportcount bigint DEFAULT 0,
    lastexporttime timestamp with time zone DEFAULT timezone('utc'::text, now()),
    lastexportresult text,
    crmsynclastcompletedtimeforwct timestamp with time zone,
    crmsynclastcompletedtimeforcrm timestamp with time zone,
    lastdeeplydeletedcontacttime timestamp with time zone
);


ALTER TABLE account_private_settings OWNER TO postgres;

--
-- TOC entry 232 (class 1259 OID 203035)
-- Name: account_share_to_account_items; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE account_share_to_account_items (
    guid character varying(36) NOT NULL,
    share_account_guid character varying(36) NOT NULL,
    beshared_account_guid character varying(36) NOT NULL,
    item_guid character varying(36) NOT NULL,
    item_type character varying(32) NOT NULL
);


ALTER TABLE account_share_to_account_items OWNER TO postgres;

--
-- TOC entry 188 (class 1259 OID 202342)
-- Name: accountsharetargetsetting; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE accountsharetargetsetting (
    guid character varying(36) NOT NULL,
    shareitem text NOT NULL,
    sharedaccountguid character varying(36) NOT NULL,
    account_guid character varying(36) NOT NULL
);


ALTER TABLE accountsharetargetsetting OWNER TO postgres;

--
-- TOC entry 189 (class 1259 OID 202348)
-- Name: activity; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE activity (
    guid character varying(36) NOT NULL,
    property text,
    discription text,
    createtime timestamp with time zone NOT NULL,
    ownerguid character varying(36) NOT NULL,
    taskguid character varying(36)
);


ALTER TABLE activity OWNER TO postgres;

--
-- TOC entry 190 (class 1259 OID 202354)
-- Name: activity_has_contact; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE activity_has_contact (
    activity_guid character varying(36) NOT NULL,
    contact_guid character varying(36) NOT NULL
);


ALTER TABLE activity_has_contact OWNER TO postgres;

--
-- TOC entry 191 (class 1259 OID 202357)
-- Name: activityattachments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE activityattachments (
    guid character varying(36) NOT NULL,
    filepath text,
    createtime timestamp with time zone,
    activity_guid character varying(36) NOT NULL
);


ALTER TABLE activityattachments OWNER TO postgres;

--
-- TOC entry 192 (class 1259 OID 202363)
-- Name: category; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE category (
    guid character varying(36) NOT NULL,
    name text,
    categorytype text NOT NULL,
    displayorder bigint,
    contactcount bigint NOT NULL,
    ownerguid character varying(36) NOT NULL,
    updatetime timestamp with time zone,
    isdeleted integer DEFAULT 0 NOT NULL,
    secretary_account_guid character varying(36),
    inheritecategoryguid character varying(36)
);


ALTER TABLE category OWNER TO postgres;

--
-- TOC entry 193 (class 1259 OID 202370)
-- Name: category_has_contact; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE category_has_contact (
    category_guid character varying(36) NOT NULL,
    contact_guid character varying(36) NOT NULL
);


ALTER TABLE category_has_contact OWNER TO postgres;

--
-- TOC entry 194 (class 1259 OID 202373)
-- Name: company; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE company (
    guid character varying(36) NOT NULL,
    name text
);


ALTER TABLE company OWNER TO postgres;

--
-- TOC entry 195 (class 1259 OID 202379)
-- Name: contact; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contact (
    guid character varying(36) NOT NULL,
    note text,
    birthday timestamp with time zone,
    uniformnumber text,
    nickname text,
    recoglanguagefront bigint,
    recoglanguageback bigint,
    createtime timestamp with time zone NOT NULL,
    modifytime timestamp with time zone NOT NULL,
    iscorrected integer DEFAULT 0 NOT NULL,
    isdeleted integer DEFAULT 0 NOT NULL,
    textsha1 character varying(40),
    ownerguid character varying(36) NOT NULL,
    creatorguid character varying(36) NOT NULL,
    modifytimefordisplay timestamp with time zone NOT NULL,
    accountscanviewsha1 character varying(40),
    editorguid character varying(36),
    modifytimeforcrmsync timestamp with time zone
);


ALTER TABLE contact OWNER TO postgres;

--
-- TOC entry 196 (class 1259 OID 202387)
-- Name: contactaddress; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactaddress (
    guid character varying(36) NOT NULL,
    street text,
    city text,
    state text,
    zip text,
    countryname text,
    countrycode text,
    addressformat bigint DEFAULT '1'::bigint NOT NULL,
    addresstype text NOT NULL,
    recognizesource text NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


ALTER TABLE contactaddress OWNER TO postgres;

--
-- TOC entry 234 (class 1259 OID 203068)
-- Name: contactcustomdata; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactcustomdata (
    guid character varying(36) NOT NULL,
    contact_guid character varying(36) NOT NULL,
    intvalue bigint DEFAULT 0,
    textvalue text,
    fieldtype text NOT NULL,
    fieldsettingguid character varying(36) NOT NULL,
    floatvalue numeric(15,3) DEFAULT (0.0)::double precision,
    datetimevalue timestamp with time zone
);


ALTER TABLE contactcustomdata OWNER TO postgres;

--
-- TOC entry 197 (class 1259 OID 202394)
-- Name: contactcustomfieldcontent; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactcustomfieldcontent (
    guid character varying(36) NOT NULL,
    contentname text,
    contactcustomfieldname_id character varying(36) NOT NULL
);


ALTER TABLE contactcustomfieldcontent OWNER TO postgres;

--
-- TOC entry 198 (class 1259 OID 202400)
-- Name: contactcustomfieldname; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactcustomfieldname (
    guid character varying(36) NOT NULL,
    fieldname text
);


ALTER TABLE contactcustomfieldname OWNER TO postgres;

--
-- TOC entry 199 (class 1259 OID 202406)
-- Name: contactdate; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactdate (
    guid character varying(36) NOT NULL,
    datevalue timestamp with time zone,
    datetype text NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


ALTER TABLE contactdate OWNER TO postgres;

--
-- TOC entry 200 (class 1259 OID 202412)
-- Name: contactemail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactemail (
    guid character varying(36) NOT NULL,
    emailvalue text,
    emailtype text NOT NULL,
    recognizesource text NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


ALTER TABLE contactemail OWNER TO postgres;

--
-- TOC entry 201 (class 1259 OID 202418)
-- Name: contactfulltext; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactfulltext (
    guid character varying(36) NOT NULL,
    textcontent text,
    contact_guid character varying(36) NOT NULL
);


ALTER TABLE contactfulltext OWNER TO postgres;

--
-- TOC entry 202 (class 1259 OID 202424)
-- Name: contactim; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactim (
    guid character varying(36) NOT NULL,
    imvalue text,
    imtype text NOT NULL,
    recognizesource text NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


ALTER TABLE contactim OWNER TO postgres;

--
-- TOC entry 203 (class 1259 OID 202430)
-- Name: contactimage; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactimage (
    guid character varying(36) NOT NULL,
    filepath text,
    imagetype text NOT NULL,
    createtime timestamp with time zone,
    updatetime timestamp with time zone,
    sha1 character varying(40),
    contact_guid character varying(36) NOT NULL
);


ALTER TABLE contactimage OWNER TO postgres;

--
-- TOC entry 204 (class 1259 OID 202436)
-- Name: contactjobinfo; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactjobinfo (
    guid character varying(36) NOT NULL,
    companyname text,
    conpanypronunce text,
    jobtitle text,
    department text,
    recognizesource text NOT NULL,
    fieldorder bigint,
    contact_guid character varying(36) NOT NULL
);


ALTER TABLE contactjobinfo OWNER TO postgres;

--
-- TOC entry 205 (class 1259 OID 202442)
-- Name: contactname; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactname (
    guid character varying(36) NOT NULL,
    firstname text,
    lastname text,
    middlename text,
    prefix text,
    suffix text,
    firstnamepronunce text,
    lastnamepronunce text,
    recognizesource text NOT NULL,
    fieldorder bigint,
    contact_guid character varying(36) NOT NULL
);


ALTER TABLE contactname OWNER TO postgres;

--
-- TOC entry 206 (class 1259 OID 202448)
-- Name: contactphone; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactphone (
    guid character varying(36) NOT NULL,
    phonevalue text,
    phonetype text NOT NULL,
    recognizesource text NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


ALTER TABLE contactphone OWNER TO postgres;

--
-- TOC entry 207 (class 1259 OID 202454)
-- Name: contactsimpleinfo; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactsimpleinfo (
    guid character varying(36) NOT NULL,
    fullnameeastlastwestlast text,
    company text,
    department text,
    jobtitle text,
    createtime timestamp with time zone NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fullnameeastfirstwestfirst text,
    fullnameeastfirstwestlast text,
    fullnameeastlastwestfirst text
);


ALTER TABLE contactsimpleinfo OWNER TO postgres;

--
-- TOC entry 208 (class 1259 OID 202460)
-- Name: contactsocial; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactsocial (
    guid character varying(36) NOT NULL,
    socialvalue text,
    socialtype text NOT NULL,
    recognizesource text NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


ALTER TABLE contactsocial OWNER TO postgres;

--
-- TOC entry 209 (class 1259 OID 202466)
-- Name: contactstatusforaccount; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactstatusforaccount (
    guid character varying(36) NOT NULL,
    categorysha1 character varying(40),
    categoryguids text,
    isdeletedfromaccount integer DEFAULT 0 NOT NULL,
    statusupdatetime timestamp with time zone NOT NULL,
    contact_guid character varying(36) NOT NULL,
    account_guid character varying(36) NOT NULL,
    exporttosalesforceid character varying(45) DEFAULT NULL::character varying,
    exporttosugarcrmid character varying(45) DEFAULT NULL::character varying,
    salesforceaccount character varying(45) DEFAULT NULL::character varying,
    sugarcrmaccount character varying(45) DEFAULT NULL::character varying,
    exporttosalesforceleadid character varying(45) DEFAULT NULL::character varying,
    modifytimeforcrmsync timestamp with time zone,
    previousmodifiedtimeforsalesforcecontact timestamp with time zone,
    previousmodifiedtimeforsalesforcelead timestamp with time zone
);


ALTER TABLE contactstatusforaccount OWNER TO postgres;

--
-- TOC entry 210 (class 1259 OID 202473)
-- Name: contacturl; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contacturl (
    guid character varying(36) NOT NULL,
    urlvalue text,
    urltype text NOT NULL,
    recognizesource text NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


ALTER TABLE contacturl OWNER TO postgres;

--
-- TOC entry 219 (class 1259 OID 202859)
-- Name: customfield; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE customfield (
    guid character varying(36) NOT NULL,
    customfieldcategory text,
    customfieldname text,
    customfieldcontactattribute text,
    sortorder integer DEFAULT 0 NOT NULL
);


ALTER TABLE customfield OWNER TO postgres;

--
-- TOC entry 233 (class 1259 OID 203051)
-- Name: forget_password_session; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE forget_password_session (
    guid character varying(36) NOT NULL,
    email text,
    token text,
    customfieldcontactattribute text,
    createdate timestamp with time zone
);


ALTER TABLE forget_password_session OWNER TO postgres;

--
-- TOC entry 211 (class 1259 OID 202479)
-- Name: globalinfo; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE globalinfo (
    guid character varying(36) NOT NULL,
    configkey text,
    configvalue text
);


ALTER TABLE globalinfo OWNER TO postgres;

--
-- TOC entry 212 (class 1259 OID 202485)
-- Name: log_performance; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE log_performance (
    guid character varying(36) NOT NULL,
    userguid character varying(36) NOT NULL,
    commandname text,
    begintime timestamp with time zone,
    endtime timestamp with time zone,
    consumetime numeric
);


ALTER TABLE log_performance OWNER TO postgres;

--
-- TOC entry 218 (class 1259 OID 202850)
-- Name: loginfailedlinfo; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE loginfailedlinfo (
    guid character varying(36) NOT NULL,
    ipaddress text NOT NULL,
    lastfailuretime timestamp with time zone NOT NULL,
    useraccount text NOT NULL,
    failurecount bigint DEFAULT '0'::bigint NOT NULL,
    failuretype text NOT NULL
);


ALTER TABLE loginfailedlinfo OWNER TO postgres;

--
-- TOC entry 213 (class 1259 OID 202491)
-- Name: notice; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE notice (
    guid character varying(36) NOT NULL,
    notifytype text,
    notifytime timestamp with time zone NOT NULL,
    isviewed integer DEFAULT 0 NOT NULL,
    receiverguid character varying(36) NOT NULL,
    notifycontent text,
    notifycategory text NOT NULL,
    senderguid character varying(36)
);


ALTER TABLE notice OWNER TO postgres;

--
-- TOC entry 235 (class 1259 OID 203130)
-- Name: picklist_content; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE picklist_content (
    guid character varying(36) NOT NULL,
    content text,
    customfield_guid character varying(36),
    sortorder integer DEFAULT 0 NOT NULL
);


ALTER TABLE picklist_content OWNER TO postgres;
--
-- TOC entry 231 (class 1259 OID 203025)
-- Name: registry; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE registry (
    guid character varying(36) NOT NULL,
    email character varying(255),
    companyname character varying(255),
    updatetime timestamp with time zone,
    attributekey character varying(255),
    attributevalue text,
    attributevalueex text
);


ALTER TABLE registry OWNER TO postgres;
--
-- TOC entry 214 (class 1259 OID 202498)
-- Name: session; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE session (
    guid character varying(36) NOT NULL,
    logintoken character varying(36) NOT NULL,
    itemkey text NOT NULL,
    itemvalue text NOT NULL
);


ALTER TABLE session OWNER TO postgres;

--
-- TOC entry 215 (class 1259 OID 202504)
-- Name: tagsfortaskandactivity; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE tagsfortaskandactivity (
    guid character varying(36) NOT NULL,
    tagtype text,
    tagname text
);


ALTER TABLE tagsfortaskandactivity OWNER TO postgres;

--
-- TOC entry 216 (class 1259 OID 202510)
-- Name: task; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE task (
    guid character varying(36) NOT NULL,
    title text,
    description text,
    createtime timestamp with time zone NOT NULL,
    ownerguid character varying(36) NOT NULL,
    creatorguid character varying(36) NOT NULL
);


ALTER TABLE task OWNER TO postgres;

--
-- TOC entry 217 (class 1259 OID 202516)
-- Name: task_has_contact; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE task_has_contact (
    task_guid character varying(36) NOT NULL,
    contact_guid character varying(36) NOT NULL
);


ALTER TABLE task_has_contact OWNER TO postgres;

--
-- TOC entry 2420 (class 2606 OID 203170)
-- Name: customfield customfieldname_unique_constraint; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY customfield
    ADD CONSTRAINT customfieldname_unique_constraint UNIQUE (customfieldname);


--
-- TOC entry 2302 (class 2606 OID 203117)
-- Name: account displayname_unique_constraint; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY account
    ADD CONSTRAINT displayname_unique_constraint UNIQUE (displayname);


--
-- TOC entry 2472 (class 2606 OID 203058)
-- Name: forget_password_session forget_password_session_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY forget_password_session
    ADD CONSTRAINT forget_password_session_primary PRIMARY KEY (guid);


--
-- TOC entry 2306 (class 2606 OID 202520)
-- Name: account idx_16950_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY account
    ADD CONSTRAINT idx_16950_primary PRIMARY KEY (guid);


--
-- TOC entry 2325 (class 2606 OID 202522)
-- Name: accountsharetargetsetting idx_16957_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY accountsharetargetsetting
    ADD CONSTRAINT idx_16957_primary PRIMARY KEY (guid);


--
-- TOC entry 2311 (class 2606 OID 202524)
-- Name: account_can_view_activity idx_16963_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY account_can_view_activity
    ADD CONSTRAINT idx_16963_primary PRIMARY KEY (account_guid, activity_guid);


--
-- TOC entry 2315 (class 2606 OID 202526)
-- Name: account_can_view_contact idx_16966_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY account_can_view_contact
    ADD CONSTRAINT idx_16966_primary PRIMARY KEY (account_guid, contact_guid);


--
-- TOC entry 2319 (class 2606 OID 202528)
-- Name: account_can_view_task idx_16969_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY account_can_view_task
    ADD CONSTRAINT idx_16969_primary PRIMARY KEY (account_guid, task_guid);


--
-- TOC entry 2322 (class 2606 OID 202530)
-- Name: account_private_settings idx_16972_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY account_private_settings
    ADD CONSTRAINT idx_16972_primary PRIMARY KEY (guid);


--
-- TOC entry 2329 (class 2606 OID 202532)
-- Name: activity idx_16988_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY activity
    ADD CONSTRAINT idx_16988_primary PRIMARY KEY (guid);


--
-- TOC entry 2336 (class 2606 OID 202534)
-- Name: activityattachments idx_16994_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY activityattachments
    ADD CONSTRAINT idx_16994_primary PRIMARY KEY (guid);


--
-- TOC entry 2333 (class 2606 OID 202536)
-- Name: activity_has_contact idx_17000_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY activity_has_contact
    ADD CONSTRAINT idx_17000_primary PRIMARY KEY (activity_guid, contact_guid);


--
-- TOC entry 2339 (class 2606 OID 202538)
-- Name: category idx_17003_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY category
    ADD CONSTRAINT idx_17003_primary PRIMARY KEY (guid);


--
-- TOC entry 2343 (class 2606 OID 202540)
-- Name: category_has_contact idx_17010_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY category_has_contact
    ADD CONSTRAINT idx_17010_primary PRIMARY KEY (category_guid, contact_guid);


--
-- TOC entry 2345 (class 2606 OID 202542)
-- Name: company idx_17013_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY company
    ADD CONSTRAINT idx_17013_primary PRIMARY KEY (guid);


--
-- TOC entry 2348 (class 2606 OID 202544)
-- Name: contact idx_17019_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contact
    ADD CONSTRAINT idx_17019_primary PRIMARY KEY (guid);


--
-- TOC entry 2351 (class 2606 OID 202546)
-- Name: contactaddress idx_17027_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactaddress
    ADD CONSTRAINT idx_17027_primary PRIMARY KEY (guid);


--
-- TOC entry 2354 (class 2606 OID 202548)
-- Name: contactcustomfieldcontent idx_17034_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactcustomfieldcontent
    ADD CONSTRAINT idx_17034_primary PRIMARY KEY (guid);


--
-- TOC entry 2356 (class 2606 OID 202550)
-- Name: contactcustomfieldname idx_17040_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactcustomfieldname
    ADD CONSTRAINT idx_17040_primary PRIMARY KEY (guid);


--
-- TOC entry 2359 (class 2606 OID 202552)
-- Name: contactdate idx_17046_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactdate
    ADD CONSTRAINT idx_17046_primary PRIMARY KEY (guid);


--
-- TOC entry 2362 (class 2606 OID 202554)
-- Name: contactemail idx_17052_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactemail
    ADD CONSTRAINT idx_17052_primary PRIMARY KEY (guid);


--
-- TOC entry 2366 (class 2606 OID 202556)
-- Name: contactfulltext idx_17058_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactfulltext
    ADD CONSTRAINT idx_17058_primary PRIMARY KEY (guid);


--
-- TOC entry 2370 (class 2606 OID 202558)
-- Name: contactim idx_17064_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactim
    ADD CONSTRAINT idx_17064_primary PRIMARY KEY (guid);


--
-- TOC entry 2373 (class 2606 OID 202560)
-- Name: contactimage idx_17070_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactimage
    ADD CONSTRAINT idx_17070_primary PRIMARY KEY (guid);


--
-- TOC entry 2376 (class 2606 OID 202562)
-- Name: contactjobinfo idx_17076_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactjobinfo
    ADD CONSTRAINT idx_17076_primary PRIMARY KEY (guid);


--
-- TOC entry 2379 (class 2606 OID 202564)
-- Name: contactname idx_17082_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactname
    ADD CONSTRAINT idx_17082_primary PRIMARY KEY (guid);


--
-- TOC entry 2382 (class 2606 OID 202566)
-- Name: contactphone idx_17088_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactphone
    ADD CONSTRAINT idx_17088_primary PRIMARY KEY (guid);


--
-- TOC entry 2386 (class 2606 OID 202568)
-- Name: contactsimpleinfo idx_17094_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactsimpleinfo
    ADD CONSTRAINT idx_17094_primary PRIMARY KEY (guid);


--
-- TOC entry 2389 (class 2606 OID 202570)
-- Name: contactsocial idx_17100_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactsocial
    ADD CONSTRAINT idx_17100_primary PRIMARY KEY (guid);


--
-- TOC entry 2393 (class 2606 OID 202572)
-- Name: contactstatusforaccount idx_17106_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactstatusforaccount
    ADD CONSTRAINT idx_17106_primary PRIMARY KEY (guid);


--
-- TOC entry 2397 (class 2606 OID 202574)
-- Name: contacturl idx_17113_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contacturl
    ADD CONSTRAINT idx_17113_primary PRIMARY KEY (guid);


--
-- TOC entry 2399 (class 2606 OID 202576)
-- Name: globalinfo idx_17119_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY globalinfo
    ADD CONSTRAINT idx_17119_primary PRIMARY KEY (guid);


--
-- TOC entry 2401 (class 2606 OID 202578)
-- Name: log_performance idx_17125_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY log_performance
    ADD CONSTRAINT idx_17125_primary PRIMARY KEY (guid);


--
-- TOC entry 2404 (class 2606 OID 202580)
-- Name: notice idx_17131_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY notice
    ADD CONSTRAINT idx_17131_primary PRIMARY KEY (guid);


--
-- TOC entry 2406 (class 2606 OID 202582)
-- Name: session idx_17145_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY session
    ADD CONSTRAINT idx_17145_primary PRIMARY KEY (guid);


--
-- TOC entry 2408 (class 2606 OID 202584)
-- Name: tagsfortaskandactivity idx_17151_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tagsfortaskandactivity
    ADD CONSTRAINT idx_17151_primary PRIMARY KEY (guid);


--
-- TOC entry 2412 (class 2606 OID 202586)
-- Name: task idx_17157_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY task
    ADD CONSTRAINT idx_17157_primary PRIMARY KEY (guid);


--
-- TOC entry 2416 (class 2606 OID 202588)
-- Name: task_has_contact idx_17163_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY task_has_contact
    ADD CONSTRAINT idx_17163_primary PRIMARY KEY (task_guid, contact_guid);


--
-- TOC entry 2422 (class 2606 OID 202866)
-- Name: customfield idx_26238_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY customfield
    ADD CONSTRAINT idx_26238_primary PRIMARY KEY (guid);


--
-- TOC entry 2418 (class 2606 OID 202858)
-- Name: loginfailedlinfo idx_26250_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY loginfailedlinfo
    ADD CONSTRAINT idx_26250_primary PRIMARY KEY (guid);


--
-- TOC entry 2470 (class 2606 OID 203039)
-- Name: account_share_to_account_items idx_account_share_to_account_items_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY account_share_to_account_items
    ADD CONSTRAINT idx_account_share_to_account_items_primary PRIMARY KEY (guid);


--
-- TOC entry 2474 (class 2606 OID 203076)
-- Name: contactcustomdata idx_contactcustomdata_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactcustomdata
    ADD CONSTRAINT idx_contactcustomdata_primary PRIMARY KEY (guid);


--
-- TOC entry 2476 (class 2606 OID 203137)
-- Name: picklist_content picklist_content_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY picklist_content
    ADD CONSTRAINT picklist_content_pk PRIMARY KEY (guid);


--
-- TOC entry 2478 (class 2606 OID 203236)
-- Name: picklist_content picklist_content_unique_constraint; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY picklist_content
    ADD CONSTRAINT picklist_content_unique_constraint UNIQUE (content, customfield_guid);


--
-- TOC entry 2466 (class 2606 OID 203034)
-- Name: registry registry_attributevalue_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY registry
    ADD CONSTRAINT registry_attributevalue_key UNIQUE (attributevalue);


--
-- TOC entry 2468 (class 2606 OID 203032)
-- Name: registry registry_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY registry
    ADD CONSTRAINT registry_pkey PRIMARY KEY (guid);


--
-- TOC entry 2303 (class 1259 OID 202589)
-- Name: idx_16950_fk_account_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16950_fk_account_account1_idx ON account USING btree (boss);


--
-- TOC entry 2304 (class 1259 OID 202590)
-- Name: idx_16950_fk_account_company_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16950_fk_account_company_idx ON account USING btree (company_guid);


--
-- TOC entry 2307 (class 1259 OID 202591)
-- Name: idx_16950_unique_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16950_unique_index ON account USING btree (email, company_guid);


--
-- TOC entry 2323 (class 1259 OID 202592)
-- Name: idx_16957_fk_accountsharetargetsetting_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16957_fk_accountsharetargetsetting_account1_idx ON accountsharetargetsetting USING btree (account_guid);


--
-- TOC entry 2308 (class 1259 OID 202593)
-- Name: idx_16963_fk_account_has_activity_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16963_fk_account_has_activity_account1_idx ON account_can_view_activity USING btree (account_guid);


--
-- TOC entry 2309 (class 1259 OID 202594)
-- Name: idx_16963_fk_account_has_activity_activity1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16963_fk_account_has_activity_activity1_idx ON account_can_view_activity USING btree (activity_guid);


--
-- TOC entry 2312 (class 1259 OID 202595)
-- Name: idx_16966_fk_account_has_contact_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16966_fk_account_has_contact_account1_idx ON account_can_view_contact USING btree (account_guid);


--
-- TOC entry 2313 (class 1259 OID 202596)
-- Name: idx_16966_fk_account_has_contact_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16966_fk_account_has_contact_contact1_idx ON account_can_view_contact USING btree (contact_guid);


--
-- TOC entry 2316 (class 1259 OID 202597)
-- Name: idx_16969_fk_account_has_task_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16969_fk_account_has_task_account1_idx ON account_can_view_task USING btree (account_guid);


--
-- TOC entry 2317 (class 1259 OID 202598)
-- Name: idx_16969_fk_account_has_task_task1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16969_fk_account_has_task_task1_idx ON account_can_view_task USING btree (task_guid);


--
-- TOC entry 2320 (class 1259 OID 202599)
-- Name: idx_16972_fk_account_private_settings_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16972_fk_account_private_settings_account1_idx ON account_private_settings USING btree (account_guid);


--
-- TOC entry 2326 (class 1259 OID 202600)
-- Name: idx_16988_fk_activity_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16988_fk_activity_account1_idx ON activity USING btree (ownerguid);


--
-- TOC entry 2327 (class 1259 OID 202601)
-- Name: idx_16988_fk_activity_task1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16988_fk_activity_task1_idx ON activity USING btree (taskguid);


--
-- TOC entry 2334 (class 1259 OID 202602)
-- Name: idx_16994_fk_activityattachments_activity1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16994_fk_activityattachments_activity1_idx ON activityattachments USING btree (activity_guid);


--
-- TOC entry 2330 (class 1259 OID 202603)
-- Name: idx_17000_fk_activity_has_contact_activity1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17000_fk_activity_has_contact_activity1_idx ON activity_has_contact USING btree (activity_guid);


--
-- TOC entry 2331 (class 1259 OID 202604)
-- Name: idx_17000_fk_activity_has_contact_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17000_fk_activity_has_contact_contact1_idx ON activity_has_contact USING btree (contact_guid);


--
-- TOC entry 2337 (class 1259 OID 202605)
-- Name: idx_17003_fk_category_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17003_fk_category_account1_idx ON category USING btree (ownerguid);


--
-- TOC entry 2340 (class 1259 OID 202607)
-- Name: idx_17010_fk_category_has_contact_category1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17010_fk_category_has_contact_category1_idx ON category_has_contact USING btree (category_guid);


--
-- TOC entry 2341 (class 1259 OID 202608)
-- Name: idx_17010_fk_category_has_contact_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17010_fk_category_has_contact_contact1_idx ON category_has_contact USING btree (contact_guid);


--
-- TOC entry 2346 (class 1259 OID 202609)
-- Name: idx_17019_fk_contact_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17019_fk_contact_account1_idx ON contact USING btree (ownerguid);


--
-- TOC entry 2349 (class 1259 OID 202610)
-- Name: idx_17027_fk_contactaddress_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17027_fk_contactaddress_contact1_idx ON contactaddress USING btree (contact_guid);


--
-- TOC entry 2352 (class 1259 OID 202611)
-- Name: idx_17034_fk_contactcustomfieldcontent_contactcustomfieldname1_; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17034_fk_contactcustomfieldcontent_contactcustomfieldname1_ ON contactcustomfieldcontent USING btree (contactcustomfieldname_id);


--
-- TOC entry 2357 (class 1259 OID 202612)
-- Name: idx_17046_fk_contactdate_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17046_fk_contactdate_contact1_idx ON contactdate USING btree (contact_guid);


--
-- TOC entry 2360 (class 1259 OID 202613)
-- Name: idx_17052_fk_contactemail_contact_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17052_fk_contactemail_contact_idx ON contactemail USING btree (contact_guid);


--
-- TOC entry 2363 (class 1259 OID 202614)
-- Name: idx_17058_contact_guid_unique; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17058_contact_guid_unique ON contactfulltext USING btree (contact_guid);


--
-- TOC entry 2364 (class 1259 OID 202615)
-- Name: idx_17058_fk_contactfullcontext_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17058_fk_contactfullcontext_contact1_idx ON contactfulltext USING btree (contact_guid);


--
-- TOC entry 2368 (class 1259 OID 202616)
-- Name: idx_17064_fk_contactim_contact_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17064_fk_contactim_contact_idx ON contactim USING btree (contact_guid);


--
-- TOC entry 2371 (class 1259 OID 202617)
-- Name: idx_17070_fk_contactimage_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17070_fk_contactimage_contact1_idx ON contactimage USING btree (contact_guid);


--
-- TOC entry 2374 (class 1259 OID 202618)
-- Name: idx_17076_fk_contactjobinfo_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17076_fk_contactjobinfo_contact1_idx ON contactjobinfo USING btree (contact_guid);


--
-- TOC entry 2377 (class 1259 OID 202619)
-- Name: idx_17082_fk_contactname_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17082_fk_contactname_contact1_idx ON contactname USING btree (contact_guid);


--
-- TOC entry 2380 (class 1259 OID 202620)
-- Name: idx_17088_fk_contactphone_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17088_fk_contactphone_contact1_idx ON contactphone USING btree (contact_guid);


--
-- TOC entry 2383 (class 1259 OID 202621)
-- Name: idx_17094_contact_guid_unique; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17094_contact_guid_unique ON contactsimpleinfo USING btree (contact_guid);


--
-- TOC entry 2384 (class 1259 OID 202622)
-- Name: idx_17094_fk_contactsimpleinfo_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17094_fk_contactsimpleinfo_contact1_idx ON contactsimpleinfo USING btree (contact_guid);


--
-- TOC entry 2387 (class 1259 OID 202623)
-- Name: idx_17100_fk_contactsocial_contact_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17100_fk_contactsocial_contact_idx ON contactsocial USING btree (contact_guid);


--
-- TOC entry 2390 (class 1259 OID 202624)
-- Name: idx_17106_fk_contactstatusforaccount_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17106_fk_contactstatusforaccount_account1_idx ON contactstatusforaccount USING btree (account_guid);


--
-- TOC entry 2391 (class 1259 OID 202625)
-- Name: idx_17106_fk_contactstatusforaccount_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17106_fk_contactstatusforaccount_contact1_idx ON contactstatusforaccount USING btree (contact_guid);


--
-- TOC entry 2394 (class 1259 OID 202626)
-- Name: idx_17106_unique_contact_account_pair; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17106_unique_contact_account_pair ON contactstatusforaccount USING btree (contact_guid, account_guid);


--
-- TOC entry 2395 (class 1259 OID 202627)
-- Name: idx_17113_fk_contacturl_contact_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17113_fk_contacturl_contact_idx ON contacturl USING btree (contact_guid);


--
-- TOC entry 2402 (class 1259 OID 202628)
-- Name: idx_17131_fk_notice_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17131_fk_notice_account1_idx ON notice USING btree (receiverguid);


--
-- TOC entry 2409 (class 1259 OID 202629)
-- Name: idx_17157_fk_task_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17157_fk_task_account1_idx ON task USING btree (ownerguid);


--
-- TOC entry 2410 (class 1259 OID 202630)
-- Name: idx_17157_fk_task_account2_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17157_fk_task_account2_idx ON task USING btree (creatorguid);


--
-- TOC entry 2413 (class 1259 OID 202631)
-- Name: idx_17163_fk_task_has_contact_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17163_fk_task_has_contact_contact1_idx ON task_has_contact USING btree (contact_guid);


--
-- TOC entry 2414 (class 1259 OID 202632)
-- Name: idx_17163_fk_task_has_contact_task1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17163_fk_task_has_contact_task1_idx ON task_has_contact USING btree (task_guid);


--
-- TOC entry 2367 (class 1259 OID 203234)
-- Name: index_contactfulltext_on_textcontent_trigram; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX index_contactfulltext_on_textcontent_trigram ON contactfulltext USING gin (textcontent gin_trgm_ops);

--
-- TOC entry 2479 (class 2606 OID 202633)
-- Name: account fk_account_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY account
    ADD CONSTRAINT fk_account_account1 FOREIGN KEY (boss) REFERENCES account(guid);


--
-- TOC entry 2480 (class 2606 OID 202638)
-- Name: account fk_account_company; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY account
    ADD CONSTRAINT fk_account_company FOREIGN KEY (company_guid) REFERENCES company(guid);


--
-- TOC entry 2481 (class 2606 OID 202643)
-- Name: account_can_view_activity fk_account_has_activity_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY account_can_view_activity
    ADD CONSTRAINT fk_account_has_activity_account1 FOREIGN KEY (account_guid) REFERENCES account(guid);


--
-- TOC entry 2482 (class 2606 OID 202648)
-- Name: account_can_view_activity fk_account_has_activity_activity1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY account_can_view_activity
    ADD CONSTRAINT fk_account_has_activity_activity1 FOREIGN KEY (activity_guid) REFERENCES activity(guid);


--
-- TOC entry 2483 (class 2606 OID 202653)
-- Name: account_can_view_contact fk_account_has_contact_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY account_can_view_contact
    ADD CONSTRAINT fk_account_has_contact_account1 FOREIGN KEY (account_guid) REFERENCES account(guid);


--
-- TOC entry 2484 (class 2606 OID 202658)
-- Name: account_can_view_contact fk_account_has_contact_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY account_can_view_contact
    ADD CONSTRAINT fk_account_has_contact_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2485 (class 2606 OID 202663)
-- Name: account_can_view_task fk_account_has_task_task1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY account_can_view_task
    ADD CONSTRAINT fk_account_has_task_task1 FOREIGN KEY (task_guid) REFERENCES task(guid);


--
-- TOC entry 2486 (class 2606 OID 202668)
-- Name: account_can_view_task fk_account_has_task_viewers; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY account_can_view_task
    ADD CONSTRAINT fk_account_has_task_viewers FOREIGN KEY (account_guid) REFERENCES account(guid);


--
-- TOC entry 2487 (class 2606 OID 202673)
-- Name: account_private_settings fk_account_private_settings_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY account_private_settings
    ADD CONSTRAINT fk_account_private_settings_account1 FOREIGN KEY (account_guid) REFERENCES account(guid);


--
-- TOC entry 2488 (class 2606 OID 202678)
-- Name: accountsharetargetsetting fk_accountsharetargetsetting_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY accountsharetargetsetting
    ADD CONSTRAINT fk_accountsharetargetsetting_account1 FOREIGN KEY (account_guid) REFERENCES account(guid);


--
-- TOC entry 2489 (class 2606 OID 202683)
-- Name: activity fk_activity_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY activity
    ADD CONSTRAINT fk_activity_account1 FOREIGN KEY (ownerguid) REFERENCES account(guid);


--
-- TOC entry 2491 (class 2606 OID 202688)
-- Name: activity_has_contact fk_activity_has_contact_activity1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY activity_has_contact
    ADD CONSTRAINT fk_activity_has_contact_activity1 FOREIGN KEY (activity_guid) REFERENCES activity(guid);


--
-- TOC entry 2492 (class 2606 OID 202693)
-- Name: activity_has_contact fk_activity_has_contact_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY activity_has_contact
    ADD CONSTRAINT fk_activity_has_contact_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2490 (class 2606 OID 202698)
-- Name: activity fk_activity_task1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY activity
    ADD CONSTRAINT fk_activity_task1 FOREIGN KEY (taskguid) REFERENCES task(guid);


--
-- TOC entry 2493 (class 2606 OID 202703)
-- Name: activityattachments fk_activityattachments_activity1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY activityattachments
    ADD CONSTRAINT fk_activityattachments_activity1 FOREIGN KEY (activity_guid) REFERENCES activity(guid);


--
-- TOC entry 2494 (class 2606 OID 202708)
-- Name: category fk_category_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY category
    ADD CONSTRAINT fk_category_account1 FOREIGN KEY (ownerguid) REFERENCES account(guid);


--
-- TOC entry 2495 (class 2606 OID 202713)
-- Name: category_has_contact fk_category_has_contact_category1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY category_has_contact
    ADD CONSTRAINT fk_category_has_contact_category1 FOREIGN KEY (category_guid) REFERENCES category(guid);


--
-- TOC entry 2496 (class 2606 OID 202718)
-- Name: category_has_contact fk_category_has_contact_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY category_has_contact
    ADD CONSTRAINT fk_category_has_contact_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2497 (class 2606 OID 202723)
-- Name: contact fk_contact_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contact
    ADD CONSTRAINT fk_contact_account1 FOREIGN KEY (ownerguid) REFERENCES account(guid);


--
-- TOC entry 2498 (class 2606 OID 202728)
-- Name: contactaddress fk_contactaddress_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactaddress
    ADD CONSTRAINT fk_contactaddress_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2523 (class 2606 OID 203077)
-- Name: contactcustomdata fk_contactcustomdata_contact; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactcustomdata
    ADD CONSTRAINT fk_contactcustomdata_contact FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2499 (class 2606 OID 202733)
-- Name: contactcustomfieldcontent fk_contactcustomfieldcontent_contactcustomfieldname1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactcustomfieldcontent
    ADD CONSTRAINT fk_contactcustomfieldcontent_contactcustomfieldname1 FOREIGN KEY (contactcustomfieldname_id) REFERENCES contactcustomfieldname(guid);


--
-- TOC entry 2500 (class 2606 OID 202738)
-- Name: contactdate fk_contactdate_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactdate
    ADD CONSTRAINT fk_contactdate_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2501 (class 2606 OID 202743)
-- Name: contactemail fk_contactemail_contact; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactemail
    ADD CONSTRAINT fk_contactemail_contact FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2502 (class 2606 OID 202748)
-- Name: contactfulltext fk_contactfullcontext_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactfulltext
    ADD CONSTRAINT fk_contactfullcontext_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2503 (class 2606 OID 202753)
-- Name: contactim fk_contactim_contact; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactim
    ADD CONSTRAINT fk_contactim_contact FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2504 (class 2606 OID 202758)
-- Name: contactimage fk_contactimage_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactimage
    ADD CONSTRAINT fk_contactimage_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2505 (class 2606 OID 202763)
-- Name: contactjobinfo fk_contactjobinfo_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactjobinfo
    ADD CONSTRAINT fk_contactjobinfo_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2506 (class 2606 OID 202768)
-- Name: contactname fk_contactname_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactname
    ADD CONSTRAINT fk_contactname_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2507 (class 2606 OID 202773)
-- Name: contactphone fk_contactphone_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactphone
    ADD CONSTRAINT fk_contactphone_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2508 (class 2606 OID 202778)
-- Name: contactsimpleinfo fk_contactsimpleinfo_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactsimpleinfo
    ADD CONSTRAINT fk_contactsimpleinfo_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2509 (class 2606 OID 202783)
-- Name: contactsocial fk_contactsocial_contact; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactsocial
    ADD CONSTRAINT fk_contactsocial_contact FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2510 (class 2606 OID 202788)
-- Name: contactstatusforaccount fk_contactstatusforaccount_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactstatusforaccount
    ADD CONSTRAINT fk_contactstatusforaccount_account1 FOREIGN KEY (account_guid) REFERENCES account(guid);


--
-- TOC entry 2511 (class 2606 OID 202793)
-- Name: contactstatusforaccount fk_contactstatusforaccount_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contactstatusforaccount
    ADD CONSTRAINT fk_contactstatusforaccount_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2512 (class 2606 OID 202798)
-- Name: contacturl fk_contacturl_contact; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contacturl
    ADD CONSTRAINT fk_contacturl_contact FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2513 (class 2606 OID 202803)
-- Name: notice fk_notice_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY notice
    ADD CONSTRAINT fk_notice_account1 FOREIGN KEY (receiverguid) REFERENCES account(guid);


--
-- TOC entry 2514 (class 2606 OID 202808)
-- Name: task fk_task_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY task
    ADD CONSTRAINT fk_task_account1 FOREIGN KEY (ownerguid) REFERENCES account(guid);


--
-- TOC entry 2515 (class 2606 OID 202813)
-- Name: task fk_task_account2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY task
    ADD CONSTRAINT fk_task_account2 FOREIGN KEY (creatorguid) REFERENCES account(guid);


--
-- TOC entry 2516 (class 2606 OID 202818)
-- Name: task_has_contact fk_task_has_contact_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY task_has_contact
    ADD CONSTRAINT fk_task_has_contact_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2517 (class 2606 OID 202823)
-- Name: task_has_contact fk_task_has_contact_task1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY task_has_contact
    ADD CONSTRAINT fk_task_has_contact_task1 FOREIGN KEY (task_guid) REFERENCES task(guid);


--
-- TOC entry 2524 (class 2606 OID 203138)
-- Name: picklist_content picklist_content_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY picklist_content
    ADD CONSTRAINT picklist_content_fk FOREIGN KEY (customfield_guid) REFERENCES customfield(guid);
    
    

