/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.websokcet;

import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.config.websocket.WebSocketSessionManager;
import com.penpower.worldcard.team.websokcet.WebSocketMessageSender;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class SimpleTextMessageSender
implements WebSocketMessageSender<String> {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleTextMessageSender.class);
    private WebSocketSessionManager webSocketSessionManager;

    public SimpleTextMessageSender(WebSocketSessionManager webSocketSessionManager) {
        this.webSocketSessionManager = webSocketSessionManager;
    }

    public void broadcastMessage(String message) {
        List sessions = this.webSocketSessionManager.getSessionsWithOutFilters(null, null);
        LOG.debug("boradacastMessage , session length : {} ", (Object)sessions.size());
        this.broadcastMessageInternal(message, sessions);
    }

    private void broadcastMessageInternal(String message, List<WebSocketSession> sessions) {
        String userName = SecurityUtils.getCurrentLoginUser().getName();
        message = Optional.ofNullable(message).orElse("<<Empty Message>>");
        TextMessage broadcastMessage = new TextMessage((CharSequence)String.format("Message broadcast from user[%s} : %s", userName, message));
        sessions.stream().filter(Objects::nonNull).filter(session -> session.isOpen()).forEach(session -> {
            try {
                session.sendMessage((WebSocketMessage)broadcastMessage);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void broadcastMessageExceptForLoginUser(String message) {
        String loginUserMail = SecurityUtils.getCurrentLoginUser().getEmail();
        List sessions = this.webSocketSessionManager.getSessionsWithOutFilters(Arrays.asList(loginUserMail), null);
        this.broadcastMessageInternal(message, sessions);
    }

    public void broadcastMessageExceptForLoginToken(String message) {
        String loginUserToken = SecurityUtils.getCurrentLoginUserToken().getToken();
        List sessions = this.webSocketSessionManager.getSessionsWithOutFilters(null, Arrays.asList(loginUserToken));
        LOG.debug("loginUserToken : {} ", (Object)loginUserToken);
        this.broadcastMessageInternal(message, sessions);
    }

    public void sendMessageToUser(String email, String message) {
        List sessions = this.webSocketSessionManager.getSessionsWithFilters(Arrays.asList(email), null);
        LOG.debug("sessions size : {} ", (Object)sessions.size());
        this.sendMessage(message, sessions);
    }

    private void sendMessage(String message, List<WebSocketSession> sessions) {
        TextMessage sendMessage = new TextMessage((CharSequence)message);
        sessions.stream().filter(Objects::nonNull).filter(session -> session.isOpen()).forEach(session -> {
            try {
                session.sendMessage((WebSocketMessage)sendMessage);
            }
            catch (Exception e) {
                LOG.warn("Fail to send websocket to user session , session : {}", session);
            }
        });
    }

    public void sendMessageToUserToken(String token, String message) {
        List sessions = this.webSocketSessionManager.getSessionsWithFilters(null, Arrays.asList(token));
        this.sendMessage(message, sessions);
    }
}

