/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.websokcet;

import com.google.gson.Gson;
import com.penpower.worldcard.team.websokcet.SocketMessageObject;
import com.penpower.worldcard.team.websokcet.WebSocketMessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoticeMessageSender
implements WebSocketMessageSender<SocketMessageObject> {
    private static final Logger LOG = LoggerFactory.getLogger(NoticeMessageSender.class);
    private WebSocketMessageSender<String> simpleTextMessageSender;
    private Gson gson;

    public NoticeMessageSender(WebSocketMessageSender simpleTextMessageSender) {
        this.simpleTextMessageSender = simpleTextMessageSender;
        this.gson = new Gson();
    }

    public void broadcastMessage(SocketMessageObject message) {
        String msg = this.gson.toJson((Object)message);
        this.simpleTextMessageSender.broadcastMessage((Object)msg);
    }

    public void broadcastMessageExceptForLoginUser(SocketMessageObject message) {
        String msg = this.gson.toJson((Object)message);
        this.simpleTextMessageSender.broadcastMessageExceptForLoginUser((Object)msg);
    }

    public void broadcastMessageExceptForLoginToken(SocketMessageObject message) {
        String msg = this.gson.toJson((Object)message);
        this.simpleTextMessageSender.broadcastMessageExceptForLoginToken((Object)msg);
    }

    public void sendMessageToUser(String email, SocketMessageObject message) {
        String msg = this.gson.toJson((Object)message);
        LOG.debug("send message to user {}  , json msg : {} ", (Object)email, (Object)msg);
        this.simpleTextMessageSender.sendMessageToUser(email, (Object)msg);
    }

    public void sendMessageToUserToken(String token, SocketMessageObject message) {
        String msg = this.gson.toJson((Object)message);
        this.simpleTextMessageSender.sendMessageToUser(token, (Object)msg);
    }
}

