/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api.vo;

import com.penpower.worldcard.team.dto.AccountInfoLess;
import com.penpower.worldcard.team.dto.CategoryInfo;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.web.api.vo.ContactInfoVo;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.format.annotation.DateTimeFormat;

public class ContactInfoVoForWCT
extends ContactInfoVo {
    private List<AccountInfoLess> beSharedAccounts;
    private List<CategoryInfo> belongCategories;
    private Boolean beFavorite;
    private String ownerName;
    private String editorName;
    private String creatorName;
    @ApiModelProperty(dataType="java.lang.String", required=true, example="1970-01-01 11:22:33.999")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    private DateTime modifyTimeForDisplay;

    public ContactInfoVoForWCT() {
        this.setBeSharedAccounts(new ArrayList());
        this.setBelongCategories(new ArrayList());
        this.setBeFavorite(Boolean.valueOf(false));
    }

    public ContactInfoVoForWCT(Contact contact) {
        super(contact);
        this.setBeSharedAccounts(new ArrayList());
        this.setBelongCategories(new ArrayList());
        this.setBeFavorite(Boolean.valueOf(false));
        Account owner = contact.getOwnerAccount();
        if (owner != null) {
            this.setOwnerName(owner.getDisplayName());
        }
        this.setModifyTimeForDisplay(contact.getModifytimefordisplay());
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getEditorName() {
        return this.editorName;
    }

    public void setEditorName(String editorName) {
        this.editorName = editorName;
    }

    public Boolean isBeFavorite() {
        return this.beFavorite;
    }

    public void setBeFavorite(Boolean beFavorite) {
        this.beFavorite = beFavorite;
    }

    public DateTime getModifyTimeForDisplay() {
        return this.modifyTimeForDisplay;
    }

    public void setModifyTimeForDisplay(DateTime modifyTimeForDisplay) {
        this.modifyTimeForDisplay = modifyTimeForDisplay;
    }

    public List<AccountInfoLess> getBeSharedAccounts() {
        return this.beSharedAccounts;
    }

    public List<CategoryInfo> getBelongCategories() {
        return this.belongCategories;
    }

    public void setBeSharedAccounts(List<AccountInfoLess> beSharedAccounts) {
        this.beSharedAccounts = beSharedAccounts;
    }

    public void setBelongCategories(List<CategoryInfo> belongCategories) {
        this.belongCategories = belongCategories;
    }
}

