/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api.vo;

import com.penpower.worldcard.team.dto.ContactInfoForResponse;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Contact;
import io.swagger.annotations.ApiModelProperty;
import org.joda.time.DateTime;
import org.springframework.format.annotation.DateTimeFormat;

public class ContactInfoVo
extends ContactInfoForResponse {
    private String creatorGuid;
    private String ownerGuid;
    private String editorGuid;
    @ApiModelProperty(dataType="java.lang.String", required=true, example="1970-01-01 11:22:33.999")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    private DateTime createTime;
    @ApiModelProperty(dataType="java.lang.String", required=true, example="1970-01-01 11:22:33.999")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    private DateTime modifyTime;

    public ContactInfoVo(Contact contact) {
        super(contact);
        Account owner = contact.getOwnerAccount();
        if (owner != null) {
            this.setOwnerGuid(owner.getGuid());
        }
        this.setCreatorGuid(contact.getCreatorGuid());
        this.setEditorGuid(contact.getEditorguid());
        this.setCreateTime(contact.getCreateTime());
        this.setModifyTime(contact.getModifyTime());
    }

    public ContactInfoVo() {
    }

    public String getCreatorGuid() {
        return this.creatorGuid;
    }

    public void setCreatorGuid(String creatorGuid) {
        this.creatorGuid = creatorGuid;
    }

    public String getEditorGuid() {
        return this.editorGuid;
    }

    public void setEditorGuid(String editorGuid) {
        this.editorGuid = editorGuid;
    }

    public DateTime getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(DateTime createTime) {
        this.createTime = createTime;
    }

    public DateTime getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(DateTime modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getOwnerGuid() {
        return this.ownerGuid;
    }

    public void setOwnerGuid(String ownerGuid) {
        this.ownerGuid = ownerGuid;
    }
}

