/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api.login;

import com.penpower.worldcard.team.Utils.HardwareIdUtil;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.exception.LowSystemMemoryInstalledException;
import com.penpower.worldcard.team.web.api.login.LoginRuleHandler;
import com.penpower.worldcard.team.web.api.login.LoginRuntimeInfo;

public class LowSystemMemoryRuleHandler
extends LoginRuleHandler {
    public LowSystemMemoryRuleHandler(LoginRuleHandler loginRuleHandler) {
        super(loginRuleHandler);
    }

    public void doCheck(LoginRuntimeInfo loginRuntimeInfo) {
        if (loginRuntimeInfo.getServerType() != ServerType.SYNOLOGY_NAS) {
            boolean lowSystemMemoryInstalled = HardwareIdUtil.systeminstalledMemoryLargerThan4G();
            if (!lowSystemMemoryInstalled) {
                throw new LowSystemMemoryInstalledException("Not enough physical memory.(lower than 4G)");
            }
            this.process(loginRuntimeInfo);
        } else {
            this.process(loginRuntimeInfo);
        }
    }
}

