/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api.login;

import com.penpower.worldcard.team.Utils.ApplicationContextProvider;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.enums.Platform;
import com.penpower.worldcard.team.enums.PlatformCategory;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.TokenService;
import com.penpower.worldcard.team.web.api.login.LoginRuleHandler;
import com.penpower.worldcard.team.web.api.login.LoginRuntimeInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class LoginTokenPlatformRuleHandler
extends LoginRuleHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LoginTokenPlatformRuleHandler.class);
    private TokenService tokenService;
    private AccountService accountService;

    public LoginTokenPlatformRuleHandler(LoginRuleHandler loginRuleHandler) {
        super(loginRuleHandler);
        ApplicationContext springApplicationContext = ApplicationContextProvider.getApplicationContext();
        this.accountService = (AccountService)springApplicationContext.getBean("accountService");
        this.tokenService = (TokenService)springApplicationContext.getBean("tokenService");
    }

    public void doCheck(LoginRuntimeInfo loginRuntimeInfo) throws RuntimeException {
        if (LOG.isDebugEnabled()) {
            this.tokenService.printAllTokenLog();
        }
        String loginUserMail = loginRuntimeInfo.getLoginEmail();
        Platform loginUserPlatform = loginRuntimeInfo.getPlatform();
        boolean webPlatform = Platform.WEB.equals((Object)loginUserPlatform);
        boolean isScanner = Platform.SCANNER.equals((Object)loginUserPlatform);
        if (!webPlatform && !isScanner) {
            AccountInfo accountInfo = this.accountService.getAccountInfo(null, loginUserMail);
            PlatformCategory platformCategory = GlobalUtils.getPlatformCategory((Platform)loginUserPlatform);
            List userAllTokens = this.tokenService.getUserTokensByPlatformCategory(accountInfo.getGuid(), platformCategory);
            LOG.debug("userAllTokens by category  : platformCategory ->{}  ,tokens ->{} ", (Object)platformCategory, (Object)userAllTokens);
            if (userAllTokens.size() > 0) {
                LOG.debug("found the same platform login token.....");
                LOG.debug("set all tokens to invalid which has the same platform value.... , user : {}", (Object)loginRuntimeInfo.getLoginEmail());
                for (String token : userAllTokens) {
                    this.tokenService.setToInvalid(token);
                }
            }
        } else {
            this.process(loginRuntimeInfo);
        }
    }
}

