/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api.login;

import com.penpower.worldcard.team.exception.DifferentTimeException;
import com.penpower.worldcard.team.web.api.login.LoginRuleHandler;
import com.penpower.worldcard.team.web.api.login.LoginRuntimeInfo;
import com.penpower.worldcard.team.web.api.vo.DifferentTimeDetail;
import com.penpower.worldcard.team.web.api.vo.DifferentTimeVo;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTimeRuleHandler
extends LoginRuleHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LocalTimeRuleHandler.class);

    public LocalTimeRuleHandler(LoginRuleHandler loginRuleHandler) {
        super(loginRuleHandler);
    }

    public void doCheck(LoginRuntimeInfo loginRuntimeInfo) {
        DateTime clientLocalTime = loginRuntimeInfo.getClientLocalTime();
        DateTime clientLocalTimeWithOutMs = new DateTime(clientLocalTime.getYear(), clientLocalTime.getMonthOfYear(), clientLocalTime.getDayOfMonth(), clientLocalTime.getHourOfDay(), clientLocalTime.getMinuteOfHour(), clientLocalTime.getSecondOfMinute(), 0);
        DateTime now = new DateTime();
        DateTime nowWithOutMs = new DateTime(now.getYear(), now.getMonthOfYear(), now.getDayOfMonth(), now.getHourOfDay(), now.getMinuteOfHour(), now.getSecondOfMinute(), 0);
        Period p = new Period((ReadableInstant)now, (ReadableInstant)clientLocalTime);
        long differentMillis = Math.abs(nowWithOutMs.getMillis() - clientLocalTimeWithOutMs.getMillis());
        long differentHour = Math.abs(TimeUnit.MILLISECONDS.toHours(differentMillis));
        long differentMinute = Math.abs(p.getMinutes());
        long differentSecond = Math.abs(p.getSeconds());
        boolean clientLocalTimeDifferentServerLimit = differentHour > 0L || differentMinute >= 5L;
        LOG.debug("now  : {} ", (Object)now);
        LOG.debug("nowWithOutMs  : {} ", (Object)nowWithOutMs);
        LOG.debug("clientLocalTime  : {} ", (Object)clientLocalTime);
        LOG.debug("clientLocalTimeWithOutMs  : {} ", (Object)clientLocalTimeWithOutMs);
        LOG.debug("differentMillis : {}", (Object)differentMillis);
        LOG.debug("differentHour : {}", (Object)differentHour);
        LOG.debug("differentMinute : {}", (Object)differentMinute);
        LOG.debug("differentSecond : {}", (Object)differentSecond);
        LOG.debug("clientLocalTimeDifferentServerLimit : {}", (Object)clientLocalTimeDifferentServerLimit);
        LOG.debug("Period DAYS: " + p.getDays());
        LOG.debug("Period HOURS: " + p.getHours());
        LOG.debug("Period MINUTES: " + p.getMinutes());
        LOG.debug("Period SECONDS: " + p.getSeconds());
        if (clientLocalTimeDifferentServerLimit) {
            DifferentTimeDetail detail = new DifferentTimeDetail(differentHour, differentMinute, differentSecond);
            LOG.debug("detail :{} ", (Object)detail);
            DifferentTimeVo differentTime = new DifferentTimeVo(clientLocalTimeWithOutMs, nowWithOutMs, detail);
            LOG.debug("differentTime : {} ", (Object)differentTime);
            throw new DifferentTimeException(differentTime, String.format("Login failed , client and server time different value was larger than %d seconds.", 300));
        }
        this.process(loginRuntimeInfo);
    }
}

