/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api.login;

import com.penpower.worldcard.team.Utils.ApplicationContextProvider;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.enums.AccountType;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.exception.AuthenticationFailedException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.ldap.ActiveDirectoryUtils;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.web.api.login.LoginRuleHandler;
import com.penpower.worldcard.team.web.api.login.LoginRuntimeInfo;
import com.penpower.worldcard.team.web.api.vo.ActiveDirectoryInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class AccountVerifyRuleHandler
extends LoginRuleHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AccountVerifyRuleHandler.class);
    private AccountService accountService;

    public AccountVerifyRuleHandler(LoginRuleHandler loginRuleHandler) {
        super(loginRuleHandler);
        ApplicationContext springApplicationContext = ApplicationContextProvider.getApplicationContext();
        this.accountService = (AccountService)springApplicationContext.getBean("accountService");
    }

    public void doCheck(LoginRuntimeInfo loginRuntimeInfo) {
        LOG.debug("===================AccountVerifyRuleHandler started===================");
        String email = loginRuntimeInfo.getLoginEmail();
        String password = loginRuntimeInfo.getLoginPassword();
        try {
            this.accountService.verifyAccount(null, email);
        }
        catch (ItemNotFoundException ex) {
            throw new AuthenticationFailedException(String.format("Login failed, Account[%s] not found", email));
        }
        AccountInfo account = this.accountService.getAccountInfo(null, email);
        AccountType accountType = account.getAccountType();
        if (AccountType.LOCAL.equals((Object)accountType)) {
            LOG.debug("AccountType is LOCAL , check the user password at local database....");
            boolean passwordCorrect = this.accountService.verifyPassword(null, email, password);
            if (!passwordCorrect) {
                throw new AuthenticationFailedException(String.format("Failed to login User[%s] password not correct..", email));
            }
        } else if (AccountType.AD.equals((Object)accountType)) {
            LOG.debug("AccountType is AD , check the user password at remote AD server ....");
            String activeAccount = loginRuntimeInfo.getLoginEmail();
            String activePassword = loginRuntimeInfo.getLoginPassword();
            String activeDirectoryServer = account.getActiveDirectoryServer();
            String baseDn = account.getActiveDirectoryBaseDn();
            ActiveDirectoryInfo activeDirectoryInfo = new ActiveDirectoryInfo(activeDirectoryServer, baseDn, activeAccount, activePassword);
            LOG.debug("activeDirectoryInfo : {} ", (Object)activeDirectoryInfo);
            ActiveDirectoryUtils activeDirectoryUtils = new ActiveDirectoryUtils(activeDirectoryInfo);
            activeDirectoryUtils.authenticate(activeAccount, activePassword);
        } else {
            throw new AuthenticationFailedException("AccountType " + accountType + " is invalid.");
        }
        LOG.debug("account & password verify succeeded.... search accountInfo : {} ", (Object)account);
        UserStatus status = account.getStatus();
        boolean validUser = SecurityUtils.validUser((UserStatus)status);
        if (!validUser) {
            throw new AuthenticationFailedException(String.format("Failed to login , user status was not ACTIVE or INACTIVE. , status : %s ", status.toString()));
        }
        this.process(loginRuntimeInfo);
        LOG.debug("===================AccountVerifyRuleHandler end===================");
    }
}

