/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api.error;

import com.penpower.worldcard.team.web.api.vo.response.ErrorResponseInfoResult;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@Order(value=0x7FFFFFFF)
public class RootRequestExceptionControllerAdvice {
    private static final Logger LOG = LoggerFactory.getLogger(RootRequestExceptionControllerAdvice.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> otherException(Exception e) {
        LOG.error("Other exception occurs : ", (Throwable)e);
        String message = "Other exceptions occurs.<BR>";
        int errorCode = HttpStatus.INTERNAL_SERVER_ERROR.value();
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }
}

