/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api.error;

import com.penpower.worldcard.team.exception.AccessWithUnbindingDeviceOrNotAllowedIpException;
import com.penpower.worldcard.team.exception.AccountAlreadyExistsException;
import com.penpower.worldcard.team.exception.AccountCreateException;
import com.penpower.worldcard.team.exception.AccountPausedException;
import com.penpower.worldcard.team.exception.AccountResignedAndExistsException;
import com.penpower.worldcard.team.exception.AccountUpdateException;
import com.penpower.worldcard.team.exception.AssignInheritorFailedException;
import com.penpower.worldcard.team.exception.AuthenticationFailedException;
import com.penpower.worldcard.team.exception.BackupFileVersionNewerThanServerException;
import com.penpower.worldcard.team.exception.CRMLoginException;
import com.penpower.worldcard.team.exception.CRMLogoutException;
import com.penpower.worldcard.team.exception.CRMOperationException;
import com.penpower.worldcard.team.exception.CategoryAlreadyExistsException;
import com.penpower.worldcard.team.exception.CategoryIsNotEmptyException;
import com.penpower.worldcard.team.exception.CustomFieldMaxCountException;
import com.penpower.worldcard.team.exception.DeleteAccountException;
import com.penpower.worldcard.team.exception.DifferentTimeException;
import com.penpower.worldcard.team.exception.DuplicateCustomFieldValueException;
import com.penpower.worldcard.team.exception.DuplicateItemValueException;
import com.penpower.worldcard.team.exception.ExclusiveException;
import com.penpower.worldcard.team.exception.ForgetPasswordTokenNotValidException;
import com.penpower.worldcard.team.exception.HttpConnectionException;
import com.penpower.worldcard.team.exception.IllegalException;
import com.penpower.worldcard.team.exception.IncorrectAccountSettings;
import com.penpower.worldcard.team.exception.IncorrectRegistrationInformationException;
import com.penpower.worldcard.team.exception.ItemAlreadyExistsException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.LicenseCountMaxExceededException;
import com.penpower.worldcard.team.exception.LicenseNeedToReactiveException;
import com.penpower.worldcard.team.exception.LoginFailureLockedException;
import com.penpower.worldcard.team.exception.LoginWithNotAllowedDeviceOrPlatformException;
import com.penpower.worldcard.team.exception.LoginWithUnbindingDeviceException;
import com.penpower.worldcard.team.exception.LowSystemMemoryInstalledException;
import com.penpower.worldcard.team.exception.MailConnectionException;
import com.penpower.worldcard.team.exception.MaxCountExceededCategoryLayerException;
import com.penpower.worldcard.team.exception.MaxCountExceededContactOwningException;
import com.penpower.worldcard.team.exception.MaxCountExceededContactPrivateException;
import com.penpower.worldcard.team.exception.MaxCountExceededContactTotalException;
import com.penpower.worldcard.team.exception.MaxFailureCountExceededException;
import com.penpower.worldcard.team.exception.MethodNotAllowedException;
import com.penpower.worldcard.team.exception.NotEnoughSpaceForRestoreException;
import com.penpower.worldcard.team.exception.PasswordChangeException;
import com.penpower.worldcard.team.exception.PasswordIncorrectException;
import com.penpower.worldcard.team.exception.PasswordLengthIncorrectException;
import com.penpower.worldcard.team.exception.PermissionDeniedException;
import com.penpower.worldcard.team.exception.RecordEqualException;
import com.penpower.worldcard.team.exception.RecordUpdateException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.exception.ResourceLockedException;
import com.penpower.worldcard.team.exception.RetryException;
import com.penpower.worldcard.team.exception.ScheduleStartException;
import com.penpower.worldcard.team.exception.SearchEngineIndexMissingException;
import com.penpower.worldcard.team.exception.SearchEngineInitializationNotFinshedException;
import com.penpower.worldcard.team.exception.SearchEngineNotRunningException;
import com.penpower.worldcard.team.exception.SearchEngineRuntimeException;
import com.penpower.worldcard.team.exception.SearchEngineSpaceInsufficientException;
import com.penpower.worldcard.team.exception.ServiceBusyException;
import com.penpower.worldcard.team.exception.SpecifiedGuidConflictException;
import com.penpower.worldcard.team.exception.SubscriptionLockedException;
import com.penpower.worldcard.team.exception.SubscriptionNotSupportException;
import com.penpower.worldcard.team.exception.SubscriptionOutOfTSubscripException;
import com.penpower.worldcard.team.exception.TokenInvalidException;
import com.penpower.worldcard.team.exception.UnActiveExpiredLockedException;
import com.penpower.worldcard.team.exception.UpdateToResignedException;
import com.penpower.worldcard.team.exception.UploadFileException;
import com.penpower.worldcard.team.exception.UserNameConflictException;
import com.penpower.worldcard.team.exception.ValueOutofRangeException;
import com.penpower.worldcard.team.web.api.vo.DifferentTimeVo;
import com.penpower.worldcard.team.web.api.vo.IpRangeVo;
import com.penpower.worldcard.team.web.api.vo.LoginFailureCountExceeded;
import com.penpower.worldcard.team.web.api.vo.response.ErrorResponseInfoResult;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.mail.MailSendException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@Order(value=-2147483648)
public class RequestExceptionControllerAdvice {
    private static final Logger LOG = LoggerFactory.getLogger(RequestExceptionControllerAdvice.class);
    @Autowired
    Environment env;

    @ExceptionHandler(value={HttpConnectionException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> httpConnectionException(Exception e, HttpServletResponse response) {
        String message = "The request could not be executed due to cancellation, a connectivity problem or timeout.";
        int errorCode = 450;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={LicenseNeedToReactiveException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> LicenseNeedToReactiveException(Exception e, HttpServletResponse response) {
        String message = "Server license is fail";
        int errorCode = 429;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={IllegalException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> IllegalException(Exception e, HttpServletResponse response) {
        String message = "This Machine is illegal for registeration";
        int errorCode = 445;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={RetryException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> RetryException(Exception e, HttpServletResponse response) {
        String message = "Request limit exceeded , server busy.";
        int errorCode = 443;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={ServiceBusyException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> ServiceBusyException(Exception e, HttpServletResponse response) {
        String message = "Request limit exceeded , server busy.";
        int errorCode = 425;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={ExclusiveException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> ExclusiveException(Exception e, HttpServletResponse response) {
        String message = "Background is busy for purge.";
        int errorCode = 432;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={LowSystemMemoryInstalledException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> LowerSystemInstalledMemoryException(Exception e, HttpServletResponse response) {
        String message = "Not enough physical memory.(lower than 4G)";
        int errorCode = 427;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={AssignInheritorFailedException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> AssignInheritorFailedException(Exception e, HttpServletResponse response) {
        String message = "Assign account inheritor failed.";
        int errorCode = 442;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={AccountResignedAndExistsException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> accountResignedAndExistsException(Exception e, HttpServletResponse response) {
        String message = "Account already exists and status is RESIGNED.";
        int errorCode = 441;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={AccountPausedException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> accountPausedException(Exception e, HttpServletResponse response) {
        String message = "Account is paused.<BR>";
        int errorCode = 463;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={ScheduleStartException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> ScheduleStartException(Exception e, HttpServletResponse response) {
        String message = "Fail to start schedule.";
        int errorCode = 200;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        LOG.info("errorMessage : {} ", (Object)errorMessage);
        if (errorMessage.indexOf("one already exists") > 0) {
            message = "Schedule already exists with this identification.";
            errorCode = 438;
        } else {
            errorCode = 439;
        }
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={MailConnectionException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> mailConnectionException(Exception e, HttpServletResponse response) {
        String message = "Fail to send mail.";
        int errorCode = 435;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={MailSendException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> mailSendException(Exception e, HttpServletResponse response) {
        String message = "Fail to connection to SMPT server.";
        int errorCode = 436;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={DuplicateItemValueException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> duplicateItemValueException(Exception e, HttpServletResponse response) {
        String message = "Item cannot have the same value.";
        int errorCode = 430;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={DuplicateCustomFieldValueException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> duplicateCustomFieldValueException(Exception e, HttpServletResponse response) {
        String message = "Item cannot have the same value.";
        int errorCode = 433;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={BackupFileVersionNewerThanServerException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> BackupControlFileNewerThanServerException(Exception e, HttpServletResponse response) {
        String message = "Backup file api version is newer than server, or it's not correct version format";
        int errorCode = 483;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={NotEnoughSpaceForRestoreException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> NotEnoughForRestoreException(Exception e, HttpServletResponse response) {
        String message = "Not enough space for restore";
        int errorCode = 484;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={PasswordChangeException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> passwordChangeException(Exception e, HttpServletResponse response) {
        String message = "new password cannot be same as the old password.";
        int errorCode = 416;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={UserNameConflictException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> userNameConflictException(Exception e, HttpServletResponse response) {
        String message = "user name already in use.";
        int errorCode = 415;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={AccountUpdateException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> accountUpdateException(Exception e, HttpServletResponse response) {
        String message = "Fail to update account.";
        int errorCode = 426;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={AccountCreateException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> accountCreateException(Exception e, HttpServletResponse response) {
        String message = "Fail to create account.";
        int errorCode = 428;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={LicenseCountMaxExceededException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> licenseCountMaxExceededException(Exception e, HttpServletResponse response) {
        String message = "License count is 0 or max count of account exceeded.";
        int errorCode = 426;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={ForgetPasswordTokenNotValidException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> forgetPasswordTokenNotValidException(Exception e, HttpServletResponse response) {
        String message = "Invalid forget password token.";
        int errorCode = 423;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={CustomFieldMaxCountException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> CustomFieldMaxCountException(Exception e, HttpServletResponse response) {
        String message = "Total custom field count cannot be larger than16";
        int errorCode = 402;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={CRMLoginException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> CRMLoginException(Exception e, HttpServletResponse response) {
        String message = "CRM system login failed.";
        int errorCode = 400;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={CRMOperationException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> CRMOperationException(Exception e, HttpServletResponse response) {
        String message = "The crm operation has failed.";
        int errorCode = 409;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={CRMLogoutException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> CRMLogoutException(Exception e, HttpServletResponse response) {
        String message = "CRM system login failed.";
        int errorCode = 400;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={RecordUpdateException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> RecordUpdateException(Exception e, HttpServletResponse response) {
        String message = "the Record in server is newer than client,and update fail";
        int errorCode = 462;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={RecordEqualException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> RecordEqualException(Exception e, HttpServletResponse response) {
        String message = "the Record in server equal to client not nessary to update";
        int errorCode = 409;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={MaxFailureCountExceededException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> maxFailureCountExceededException(Exception e, HttpServletResponse response) {
        String message = "Max count limit is reached.";
        int errorCode = 424;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        LoginFailureCountExceeded errorData = ((MaxFailureCountExceededException)e).getErrorData();
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, (Object)errorData);
        return result;
    }

    @ExceptionHandler(value={MaxCountExceededCategoryLayerException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> maxCountExceededCategoryLayerException(Exception e, HttpServletResponse response) {
        String message = "Max count limit of category layer is reached.";
        int errorCode = 428;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={MaxCountExceededContactPrivateException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> maxCountExceededContactPrivateException(Exception e, HttpServletResponse response) {
        String message = "Max count limit of contact in private is reached.";
        int errorCode = 425;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={MaxCountExceededContactOwningException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> maxCountExceededContactOwningException(Exception e, HttpServletResponse response) {
        String message = "Max count limit of contact owning is reached.";
        int errorCode = 426;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={MaxCountExceededContactTotalException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> maxCountExceededContactTotalException(Exception e, HttpServletResponse response) {
        String message = "Max count limit of contact in DB is reached.";
        int errorCode = 427;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ResponseBody
    @ExceptionHandler(value={ItemAlreadyExistsException.class})
    public ErrorResponseInfoResult<?, ?> itemAlreadyExistsException(Exception e, HttpServletResponse response) {
        String message = "Item already exists.<BR>";
        int errorCode = 460;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        IpRangeVo errorData = ((ItemAlreadyExistsException)e).getErrorData();
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, (Object)errorData);
        return result;
    }

    @ExceptionHandler(value={UpdateToResignedException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> updateToResignedException(Exception e, HttpServletResponse response) {
        String message = "Account status is RESIGNED or INACTIVE cannot change to RESIGNED.<BR>";
        int errorCode = 406;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={DifferentTimeException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> differentTimeException(Exception e, HttpServletResponse response) {
        String message = "client and server time different value was larger than server value.";
        DifferentTimeException exception = (DifferentTimeException)e;
        DifferentTimeVo vo = exception.getDifferentTimeVo();
        int errorCode = 461;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, (Object)vo);
        return result;
    }

    @ExceptionHandler(value={IncorrectAccountSettings.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> incorrectAccountSettingsException(Exception e, HttpServletResponse response) {
        String message = "Account settings incorrect.<BR>";
        int errorCode = 460;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={PasswordIncorrectException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> passwordIncorrectException(Exception e, HttpServletResponse response) {
        String message = "Password incorrect.<BR>";
        int errorCode = 460;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={ValueOutofRangeException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> ValueOutofRangeException(Exception e, HttpServletResponse response) {
        String message = "Update value is out of range";
        int errorCode = 462;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={PasswordLengthIncorrectException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> passwordLengthIncorrectException(Exception e, HttpServletResponse response) {
        String message = "password length has to be minimum of 6 characters and maximum of 16 characters.";
        int errorCode = 462;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> dccessDeniedException(Exception e, HttpServletResponse response) {
        String message = "You don't have permission to access this request.<BR>";
        int errorCode = 403;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={DeleteAccountException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> deleteAccountException(Exception e, HttpServletResponse response) {
        String message = "The resource item can't be removed.<BR>";
        int errorCode = 460;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> methodArgumentNotValidException(Exception e, HttpServletResponse response) {
        String message = "Request parameters value is invalid. <BR>";
        int errorCode = 422;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={AccountAlreadyExistsException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> AccountAlreadyExistsException(Exception e, HttpServletResponse response) {
        String message = "Account already exists.<BR>";
        int errorCode = 460;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={ItemNotFoundException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> itemNotFoundException(Exception e, HttpServletResponse response) {
        String message = "Resource item not found in system. <BR>";
        int errorCode = HttpStatus.NOT_FOUND.value();
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={RequestArgumentNotValidException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> requestArgumentNotValidException(Exception e, HttpServletResponse response) {
        String message = "Request required parameters not valid. <BR>";
        int errorCode = 422;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={UploadFileException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> uploadFileException(Exception e, HttpServletResponse response) {
        String message = "Upload file failed.<BR>";
        int errorCode = HttpStatus.FORBIDDEN.value();
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={CategoryAlreadyExistsException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> categoryAlreadyExistsException(Exception e, HttpServletResponse response) {
        String message = "Category already exists.<BR>";
        int errorCode = 460;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={SpecifiedGuidConflictException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> specifiedGuidConflictException(Exception e, HttpServletResponse response) {
        String message = "Specified guid has been used.<BR>";
        int errorCode = 490;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={AuthenticationFailedException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> authenticationException(Exception e) {
        String message = "Authentication failed.<BR>";
        int errorCode = HttpStatus.UNAUTHORIZED.value();
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={AccessWithUnbindingDeviceOrNotAllowedIpException.class, LoginWithUnbindingDeviceException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> deviceOrIpNotAllowedException(Exception e) {
        String message = "Access with unbinding device or not-allowed IP address";
        int errorCode = 469;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={LoginWithNotAllowedDeviceOrPlatformException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> deviceOrPlatformNotAllowedWhenLogin(Exception e) {
        String message = "Login with unbinding device or platform";
        int errorCode = 482;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={TokenInvalidException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> tokenInvalidException(Exception e) {
        String message = "Invalid token<BR>";
        int errorCode = 461;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={PermissionDeniedException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> permissionDeniedException(Exception e) {
        LOG.error("permissionDeniedException occurs : ", (Throwable)e);
        String message = "You don't have permission to access this request.<BR>";
        int errorCode = HttpStatus.FORBIDDEN.value();
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        String AccountData = ((PermissionDeniedException)e).getAccountData();
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, (Object)AccountData);
        return result;
    }

    @ExceptionHandler(value={IncorrectRegistrationInformationException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> incorrectRegistrationInformationException(Exception e) {
        LOG.error("IncorrectRegistrationInformationException occurs : ", (Throwable)e);
        String message = "Request parameters value is invalid. <BR>";
        int errorCode = HttpStatus.METHOD_NOT_ALLOWED.value();
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={MethodNotAllowedException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> MethodNotAllowedException(Exception e) {
        LOG.error("MethodNotAllowedException occurs : ", (Throwable)e);
        String message = "Request parameters value is invalid. <BR>";
        int errorCode = HttpStatus.METHOD_NOT_ALLOWED.value();
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={ResourceLockedException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> ResourceLockedException(Exception e) {
        LOG.error("ResourceLockedException occurs : ", (Throwable)e);
        String message = "The registry library is  locked.<BR>";
        int errorCode = HttpStatus.LOCKED.value();
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={CategoryIsNotEmptyException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> categoryIsNotEmptyException(Exception e) {
        LOG.error("CategoryIsNotEmptyException occurs : ", (Throwable)e);
        String message = "There are child categories or contacts in the category.";
        int errorCode = 480;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={SearchEngineInitializationNotFinshedException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> SearchEngineInitializationNotFinshedException(Exception e) {
        LOG.error("SearchEngineInitializationNotFinshedException occurs : ", (Throwable)e);
        String message = "Search engine initialization is not finished.";
        int errorCode = 491;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        Double errorData = ((SearchEngineInitializationNotFinshedException)e).getErrorData();
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, (Object)errorData);
        return result;
    }

    @ExceptionHandler(value={SearchEngineNotRunningException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> SearchEngineNotRunningException(Exception e) {
        LOG.error("SearchEngineNotRunningException occurs : ", (Throwable)e);
        String message = "Search engine is not running";
        int errorCode = 492;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={SearchEngineIndexMissingException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> SearchEngineIndexMissingException(Exception e) {
        LOG.error("SearchEngineIndexMissingException occurs : ", (Throwable)e);
        String message = "Search engine indexing data is missing";
        int errorCode = 493;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={SearchEngineSpaceInsufficientException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> SearchEngineSpaceInsufficientException(Exception e) {
        LOG.error("SearchEngineRuntimeException occurs : ", (Throwable)e);
        String message = "Search result are not up-to-date because of insufficient disk space";
        int errorCode = 495;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={SearchEngineRuntimeException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> SearchEngineRuntimeException(Exception e) {
        LOG.error("SearchEngineRuntimeException occurs : ", (Throwable)e);
        String message = "Unspecified exception for searchEngine";
        int errorCode = 494;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={SubscriptionNotSupportException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> SubscriptionNotSupportException(Exception e) {
        LOG.error("SubscriptionNotSupportException occurs : ", (Throwable)e);
        String message = "This localte not support Subscription";
        int errorCode = 487;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={UnActiveExpiredLockedException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> UnActiveExpiredLockedException(Exception e) {
        LOG.error("UnActiveExpiredLockedException occurs : ", (Throwable)e);
        String message = "Unactive account Exipred lock case by failure";
        int errorCode = 489;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={LoginFailureLockedException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> LoginFailureLockedException(Exception e) {
        LOG.error("LoginFailureLockedException occurs : ", (Throwable)e);
        String message = "Login lock case by failure";
        int errorCode = 488;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={SubscriptionLockedException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> SubscriptionLockedException(Exception e) {
        LOG.error("SubscriptionLockedException occurs : ", (Throwable)e);
        String message = "Subscription mode service locked.";
        int errorCode = 485;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={SubscriptionOutOfTSubscripException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> SubscriptionOutOfTSubscripException(Exception e) {
        LOG.error("SubscriptionOutOfTSubscripException occurs : ", (Throwable)e);
        String message = "Subscription mode out of subscription";
        int errorCode = 486;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }
}

