/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api.error;

import com.penpower.worldcard.team.exception.BackupJobAlreadyRunningException;
import com.penpower.worldcard.team.exception.BackupRuntimException;
import com.penpower.worldcard.team.exception.BackupScheduleJobAlreadySetException;
import com.penpower.worldcard.team.exception.BackupStorageSpaceNotEnoughException;
import com.penpower.worldcard.team.exception.ImageDataMigrationJobRunningException;
import com.penpower.worldcard.team.exception.InvalidBackupPathException;
import com.penpower.worldcard.team.exception.UnsupportFileSystemTypeException;
import com.penpower.worldcard.team.web.api.vo.response.ErrorResponseInfoResult;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@Order(value=-2147483648)
public class BackupExceptionControllerAdvice {
    @ExceptionHandler(value={BackupJobAlreadyRunningException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> backupJobAlreadyRunningException(Exception e, HttpServletResponse response) {
        String message = "Backup job is already running";
        int errorCode = 466;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={ImageDataMigrationJobRunningException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> imageDataMigrationJobRunningException(Exception e, HttpServletResponse response) {
        String message = "The image data migration job already running";
        int errorCode = 459;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={BackupRuntimException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> backupRuntimException(Exception e, HttpServletResponse response) {
        String message = "Unspecified exception for backup job.";
        int errorCode = 465;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={BackupScheduleJobAlreadySetException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> backupScheduleJobAlreadySetException(Exception e, HttpServletResponse response) {
        String message = "The backup job schedule is already set up.";
        int errorCode = 467;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={InvalidBackupPathException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> invalidBackupPathException(Exception e, HttpServletResponse response) {
        String message = "The backup storage path is invalid or not exists.";
        int errorCode = 468;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={UnsupportFileSystemTypeException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> unsupportFileSystemTypeException(Exception e, HttpServletResponse response) {
        String message = "Backup path only support ext4 or ntfs file system.";
        int errorCode = 481;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={BackupStorageSpaceNotEnoughException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> backupStorageSpaceNotEnoughException(Exception e, HttpServletResponse response) {
        String message = "There is not enough space available on the backup path.";
        int errorCode = 464;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }
}

