/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.AccountInfoLess;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.exception.MailConnectionException;
import com.penpower.worldcard.team.exception.PasswordChangeException;
import com.penpower.worldcard.team.exception.PasswordIncorrectException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.exception.SystemIoException;
import com.penpower.worldcard.team.exception.UserNameConflictException;
import com.penpower.worldcard.team.files.PathManager;
import com.penpower.worldcard.team.mail.MailInfo;
import com.penpower.worldcard.team.mail.PasswordChangedMailInfoBuilder;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.MultiLayerCategoryService;
import com.penpower.worldcard.team.web.api.vo.response.AccountInfoLessResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.AccountInfoResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.ListResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import javax.mail.internet.MimeMessage;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.validator.internal.constraintvalidators.hv.EmailValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.MailSendException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/user/account"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"user account"}, description="user account operation")
@PreAuthorize(value="principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE")
public class UserAccountController {
    private static final Logger LOG = LoggerFactory.getLogger(UserAccountController.class);
    @Autowired
    private AccountService accountService;
    @Autowired
    private PathManager accountPathManager;
    @Autowired
    private JavaMailSender javaMailSender;
    @Autowired
    private MultiLayerCategoryService multiLayerCategoryService;

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_boss"}, method={RequestMethod.POST})
    public AccountInfoLessResponseResult getBoss() {
        String guid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountService.verifyAccount(guid, null);
        AccountInfo accountInfo = this.accountService.getBoss(guid);
        AccountInfoLess accountInfoLess = new AccountInfoLess(accountInfo.getGuid(), accountInfo.getEmail(), accountInfo.getName(), accountInfo.getStatus(), accountInfo.getAccountType(), accountInfo.getAccountSubscriptionStatus(), accountInfo.getLockedIssue());
        AccountInfoLessResponseResult response = new AccountInfoLessResponseResult(String.format("Get boss account information by guid[%s] succeeded.", guid), accountInfoLess);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_subordinates"}, method={RequestMethod.POST})
    public ListResponseResult<AccountInfoLess> getSubordinates() {
        String guid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountService.verifyAccount(guid, null);
        List subordinates = this.accountService.getSubordinates(guid);
        List subordinatesLess = subordinates.stream().map(accountInfo -> new AccountInfoLess(accountInfo.getGuid(), accountInfo.getEmail(), accountInfo.getName(), accountInfo.getStatus(), accountInfo.getAccountType(), accountInfo.getAccountSubscriptionStatus(), accountInfo.getLockedIssue())).collect(Collectors.toList());
        ListResponseResult response = new ListResponseResult("Get account all subordinates succeeded.", subordinatesLess);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_logo"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> getAccountLogo() {
        ResponseEntity responseEnty;
        String guid = SecurityUtils.getCurrentLoginUser().getGuid();
        String accountLogoRelativePath = this.accountService.getAccountLogoRelativePath(guid);
        Path accountLogo = this.accountPathManager.getFullyPath(accountLogoRelativePath);
        try (InputStream is = Files.newInputStream(accountLogo, new OpenOption[0]);){
            long fileSize = Files.size(accountLogo);
            String contentType = GlobalUtils.getFileContent((Path)accountLogo);
            MediaType mediaType = MediaType.parseMediaType((String)contentType);
            byte[] imageBytes = IOUtils.toByteArray((InputStream)is);
            responseEnty = ResponseEntity.ok().contentLength(fileSize).contentType(mediaType).body((Object)imageBytes);
        }
        catch (IOException e) {
            throw new SystemIoException("Fail to load image file....", (Throwable)e);
        }
        return responseEnty;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_logo_base64"}, method={RequestMethod.GET})
    public MessageResponseResult getAccountLogoBase64() {
        String accountGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountService.verifyAccount(accountGuid, null);
        String accountLogoRelativePath = this.accountService.getAccountLogoRelativePath(accountGuid);
        Path accountLogo = this.accountPathManager.getFullyPath(accountLogoRelativePath);
        String imageBase64String = "";
        try (InputStream is = Files.newInputStream(accountLogo, new OpenOption[0]);){
            byte[] imageBytes = IOUtils.toByteArray((InputStream)is);
            imageBase64String = Base64.encodeBase64String((byte[])imageBytes);
        }
        catch (IOException e) {
            throw new SystemIoException("Fail to load image file....", (Throwable)e);
        }
        MessageResponseResult response = new MessageResponseResult("Get base64 string of account logo image succeeded.", imageBase64String);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_account_details"}, method={RequestMethod.POST})
    public AccountInfoResponseResult getAccountDetails() {
        String guid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountService.verifyAccount(guid, null);
        AccountInfo accountInfo = this.accountService.getAccountInfo(guid, null);
        AccountInfoResponseResult response = new AccountInfoResponseResult(String.format("Search account by guid[%s] succeeded.", guid), accountInfo);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=401, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_other_account_list"}, method={RequestMethod.POST})
    public ListResponseResult<AccountInfoLess> getOtherAccountList() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        List accountInfos = this.accountService.getAccountInfos(currentLoginUser.getCompanyGuid());
        String currentUserGuid = currentLoginUser.getGuid();
        List accountsInfoLess = accountInfos.stream().filter(accountInfo -> !accountInfo.getGuid().equals(currentUserGuid)).map(accountInfo -> new AccountInfoLess(accountInfo.getGuid(), accountInfo.getEmail(), accountInfo.getName(), accountInfo.getStatus(), accountInfo.getAccountType(), accountInfo.getAccountSubscriptionStatus(), accountInfo.getLockedIssue())).collect(Collectors.toList());
        ListResponseResult response = new ListResponseResult("Get all account less information succeeded.", accountsInfoLess);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/reset_password"}, method={RequestMethod.POST})
    @PreAuthorize(value="(principal.accountType==T(com.penpower.worldcard.team.enums.AccountType).LOCAL)")
    public MessageResponseResult resetPassword() {
        String currentLoginUserGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        LOG.debug("reset_password account=" + currentLoginUserGuid);
        this.accountService.verifyAccount(currentLoginUserGuid, null);
        this.accountService.resetPassword(currentLoginUserGuid);
        MessageResponseResult response = new MessageResponseResult("Password has been reset.", "");
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=460, message="Password incorrect.<BR>"), @ApiResponse(code=416, message="new password cannot be same as the old password."), @ApiResponse(code=462, message="password length has to be minimum of 6 characters and maximum of 16 characters."), @ApiResponse(code=403, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/change_password_byMail"}, method={RequestMethod.GET})
    @PreAuthorize(value="(principal.accountType==T(com.penpower.worldcard.team.enums.AccountType).LOCAL)")
    public MessageResponseResult ChangePasswordByMail() {
        String currentLoginUserGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountService.verifyAccount(currentLoginUserGuid, null);
        this.accountService.resetPassword(currentLoginUserGuid);
        MessageResponseResult response = new MessageResponseResult("Password has been reset.", "");
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=460, message="Password incorrect.<BR>"), @ApiResponse(code=416, message="new password cannot be same as the old password."), @ApiResponse(code=462, message="password length has to be minimum of 6 characters and maximum of 16 characters."), @ApiResponse(code=403, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/change_password"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    @PreAuthorize(value="(principal.accountType==T(com.penpower.worldcard.team.enums.AccountType).LOCAL)")
    public MessageResponseResult changePassword(@RequestParam String oldPassword, @RequestParam String newPassword) {
        boolean passwordCorrect;
        String currentLoginUserGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountService.verifyAccount(currentLoginUserGuid, null);
        this.accountService.checkPasswordValidate(newPassword);
        if (this.accountService.getAccountStatus(currentLoginUserGuid) != UserStatus.INACTIVE && !(passwordCorrect = this.accountService.verifyPassword(currentLoginUserGuid, null, oldPassword))) {
            throw new PasswordIncorrectException("Old password incorrect.");
        }
        boolean IsPasswordInHistory = this.accountService.IsPasswordInHistory(currentLoginUserGuid, null, newPassword);
        if (IsPasswordInHistory) {
            throw new PasswordChangeException("new password supplied is the same as the previous password.");
        }
        this.accountService.changePassword(currentLoginUserGuid, oldPassword, newPassword);
        AccountInfo accountInfo = this.accountService.getAccountInfo(currentLoginUserGuid, null);
        LOG.debug("reset_password account info mail=" + accountInfo.getEmail());
        JavaMailSenderImpl javaMailSenderImpl = (JavaMailSenderImpl)this.javaMailSender;
        try {
            javaMailSenderImpl.testConnection();
        }
        catch (Exception ex) {
            LOG.error("fail to test mail connection.....", (Throwable)ex);
            throw new MailConnectionException(ex.getMessage(), (Throwable)ex);
        }
        LOG.debug("reset_password after mail test");
        try {
            PasswordChangedMailInfoBuilder mailInfoBuilder = new PasswordChangedMailInfoBuilder(accountInfo.getName());
            LOG.debug("reset_password after mail 1");
            MailInfo PasswordChangedMailInfo = mailInfoBuilder.createMailInfo();
            LOG.debug("\"reset_password after mail \n {}", (Object)PasswordChangedMailInfo);
            MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, false, "UTF-8");
            LOG.debug("reset_password after mail 2");
            helper.setTo(accountInfo.getEmail());
            helper.setFrom("WorldCard Team Service<wctservice@mail.worldcardteam.com>");
            LOG.debug("reset_password after mail 3");
            helper.setSubject(PasswordChangedMailInfo.getMailSubject());
            mimeMessage.setContent((Object)PasswordChangedMailInfo.getStringMailBody(), "text/html;charset=utf-8");
            LOG.debug("reset_password after mail 4");
            this.javaMailSender.send(mimeMessage);
            MimeMessage dkimSignedMessage = GlobalUtils.getDkimSignMessage((MimeMessage)mimeMessage);
            this.javaMailSender.send(dkimSignedMessage);
            LOG.debug("reset_password after mail 5");
        }
        catch (Exception ex) {
            LOG.error("Fail to send PasswordChanged mail ", (Throwable)ex);
            throw new MailSendException("Fail to send PasswordChanged mail....", (Throwable)ex);
        }
        MessageResponseResult response = new MessageResponseResult("Password has been changed.", "");
        return response;
    }

    @ApiOperation(value="", notes="\u4fee\u6539\u4f7f\u7528\u8005\u81ea\u5df1\u7684\u986f\u793a\u540d\u7a31")
    @ApiResponses(value={@ApiResponse(code=415, message="user name already in use."), @ApiResponse(code=403, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/change_display_name"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult changeDisplayName(@RequestParam String newDisplayName) {
        String guid = SecurityUtils.getCurrentLoginUser().getGuid();
        try {
            this.accountService.changeDisplayName(guid, newDisplayName);
        }
        catch (ConstraintViolationException | DataIntegrityViolationException ex) {
            LOG.error("fail to change user diaplay name ...", ex);
            throw new UserNameConflictException("Fail to change user displayname , user name already in use.");
        }
        this.multiLayerCategoryService.renameAllSecretaryCategoriesCreatedByAccount(guid);
        MessageResponseResult response = new MessageResponseResult("Display name has been changed.", "");
        return response;
    }

    @ApiOperation(value="", notes="\u4f7f\u7528\u8005\u4fee\u6539\u81ea\u5df1\u8a18\u9304\u5728WCT\u88e1\u9762\u7684mail\u8cc7\u8a0a(AD\u5e33\u865f\u5c08\u7528)")
    @ApiResponses(value={@ApiResponse(code=403, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE) and (principal.accountType==T(com.penpower.worldcard.team.enums.AccountType).AD) ")
    @RequestMapping(value={"/change_ad_account_mail"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult changeActiveDirectoryAccountMail(@RequestParam String newAdAdcountMail) {
        String guid = SecurityUtils.getCurrentLoginUser().getGuid();
        EmailValidator validator = new EmailValidator();
        boolean emailValid = validator.isValid((CharSequence)newAdAdcountMail, null);
        if (!emailValid) {
            throw new RequestArgumentNotValidException("not a well-formed email address");
        }
        this.accountService.changeActiveDirectoryAccountMail(guid, newAdAdcountMail);
        MessageResponseResult response = new MessageResponseResult("Display name has been changed.", "");
        return response;
    }
}

