/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.HardwareIdUtil;
import com.penpower.worldcard.team.Utils.NetworkUtil;
import com.penpower.worldcard.team.Utils.SSLUtil;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.auth.TokenInfo;
import com.penpower.worldcard.team.config.ApplicationConfig;
import com.penpower.worldcard.team.config.property.ApplicationProperties;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.AccountInfoForDS;
import com.penpower.worldcard.team.dto.AutoInitialInfo;
import com.penpower.worldcard.team.dto.UIDisplayOption;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.enums.ContactImageTransferStatus;
import com.penpower.worldcard.team.enums.CreateAccountRole;
import com.penpower.worldcard.team.enums.LanguageCode;
import com.penpower.worldcard.team.enums.LicenseMode;
import com.penpower.worldcard.team.enums.LogLevel;
import com.penpower.worldcard.team.enums.ServerRegisterStatus;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.enums.SubscriberCreateType;
import com.penpower.worldcard.team.enums.SubscriptionStatus;
import com.penpower.worldcard.team.enums.UserRole;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.exception.AuthenticationFailedException;
import com.penpower.worldcard.team.exception.DatabaseUtilsRuntimeException;
import com.penpower.worldcard.team.exception.IncorrectRegistrationInformationException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.PermissionDeniedException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.exception.ResourceLockedException;
import com.penpower.worldcard.team.exception.SystemIoException;
import com.penpower.worldcard.team.files.PathManager;
import com.penpower.worldcard.team.mail.MailInfo;
import com.penpower.worldcard.team.mail.SystemInitialMainInfoBuilder;
import com.penpower.worldcard.team.restore.DatabaseConnectionInfo;
import com.penpower.worldcard.team.restore.PostgreSqlJdbcUtils;
import com.penpower.worldcard.team.scheduler.JobIdentify;
import com.penpower.worldcard.team.scheduler.ScheduleManager;
import com.penpower.worldcard.team.scheduler.job.RebuildElasticsearchIndexJob;
import com.penpower.worldcard.team.scheduler.job.SendMailJob;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.ElasticSearchService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.SubscriptionService;
import com.penpower.worldcard.team.service.TokenService;
import com.penpower.worldcard.team.service.impl.DatabaseSystemSettingService;
import com.penpower.worldcard.team.web.api.vo.AccountCreationVo;
import com.penpower.worldcard.team.web.api.vo.LicenseVo;
import com.penpower.worldcard.team.web.api.vo.ProductInfo;
import com.penpower.worldcard.team.web.api.vo.SSLDetailInfo;
import com.penpower.worldcard.team.web.api.vo.ServicePort;
import com.penpower.worldcard.team.web.api.vo.ServiceStatus;
import com.penpower.worldcard.team.web.api.vo.SubscriptionInfoVo;
import com.penpower.worldcard.team.web.api.vo.SystemInitiaDemolVo;
import com.penpower.worldcard.team.web.api.vo.SystemInitiaTwoPersionVo;
import com.penpower.worldcard.team.web.api.vo.SystemInitialVo;
import com.penpower.worldcard.team.web.api.vo.SystemReInitialVo;
import com.penpower.worldcard.team.web.api.vo.VersionInfo;
import com.penpower.worldcard.team.web.api.vo.response.AutoInitialInfoResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.BooleanResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.DateTimeResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.LicenseResponeResult;
import com.penpower.worldcard.team.web.api.vo.response.ListResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.LongResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.ServerRegisterStatusResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.ServiceStatusResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.SubscriptionStatusResponeResult;
import com.penpower.worldcard.team.web.api.vo.response.TokenInfoResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.UIDisplayOptionResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.VersionInfoResponseResult;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.flywaydb.core.Flyway;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.json.JSONObject;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@CrossOrigin
@RequestMapping(value={"/system"})
public class SystemController {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(SystemController.class);
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private RegistryService registryService;
    private AuthenticationManager authenticationManager;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private DatabaseSystemSettingService databaseSystemSettingService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private ScheduleManager scheduleManager;
    @Autowired
    private PathManager cardPathManager;
    @Autowired
    private Environment env;
    @Autowired
    private JavaMailSender javaMailSender;
    @Autowired
    @Qualifier(value="databaseName")
    private String databaseName;
    @Autowired
    private ElasticSearchService elasticSearchService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private Flyway flyway;
    @Autowired
    private ApplicationConfig applicationConfig;
    @Value(value="${Servertype}")
    private String serverType;
    @Value(value="${httpPort}")
    private String httpPort;
    @Value(value="${httpsPort}")
    private String httpsPort;
    @Value(value="${AdminCanViewAll}")
    private String AdminCanViewAll;

    @ApiOperation(value="get All Display Option", notes="get All Display Option")
    @ApiResponses(value={@ApiResponse(code=404, message="Can't connect to register server. <BR>")})
    @RequestMapping(value={"/getUIDisplayOption"}, method={RequestMethod.GET})
    public UIDisplayOptionResponseResult getUIDisplayOption() {
        UIDisplayOption updisplayUption = new UIDisplayOption();
        updisplayUption.setIsCloud(false);
        updisplayUption.setIsIsMultiCompany(false);
        updisplayUption.setIsSupportBackupRestore(true);
        updisplayUption.setIsSupportRetistry(true);
        updisplayUption.setIsSupportSubscription(false);
        updisplayUption.setIsSupportSecuritySetting(true);
        updisplayUption.setIsSimplyUI(false);
        updisplayUption.setIsSupportApplyAccount(false);
        updisplayUption.setCustom("cathaylife");
        return new UIDisplayOptionResponseResult("getUIDisplayOption success", updisplayUption);
    }

    @ApiOperation(value="multi company frame", notes="Is current db support multicompany")
    @ApiResponses(value={@ApiResponse(code=404, message="Can't connect to register server. <BR>")})
    @RequestMapping(value={"/getIsMultiCompanyFrame"}, method={RequestMethod.GET})
    public BooleanResponseResult IsMultiCompanyFrame() {
        ServerType svrType = this.registryService.GetServerType();
        if (GlobalUtils.IsCloudServerType((ServerType)svrType)) {
            return new BooleanResponseResult("Multi companyFrame", Boolean.valueOf(true));
        }
        return new BooleanResponseResult("NOT Multi companyFrame ", Boolean.valueOf(false));
    }

    @ApiOperation(value="Simplify_UI", notes="Simplify_UI will save cpu resource")
    @RequestMapping(value={"/getIsSimplifyUI"}, method={RequestMethod.GET})
    public BooleanResponseResult IsSimplifyUI() {
        ServerType svrType = this.registryService.GetServerType();
        if (GlobalUtils.IsCloudServerType((ServerType)svrType)) {
            return new BooleanResponseResult("simplify UI", Boolean.valueOf(true));
        }
        return new BooleanResponseResult("NOT simplify UI ", Boolean.valueOf(false));
    }

    @ApiOperation(value="is Current location support subscription", notes="is Current location support subscription")
    @ApiResponses(value={@ApiResponse(code=404, message="Can't connect to register server. <BR>")})
    @RequestMapping(value={"/IsSupportSubscription"}, method={RequestMethod.POST})
    public BooleanResponseResult IsSupportSubscription() {
        LOG.debug("IsSupportSubscription");
        BooleanResponseResult response = null;
        if (this.registryService.IsAnyRegisterSupportSubscription()) {
            response = new BooleanResponseResult("supported subscription by register ", Boolean.valueOf(true));
            LOG.debug("IsSupportSubscription true");
        } else if (this.subscriptionService.IsCurrentLocateSupportSubscription()) {
            response = new BooleanResponseResult("supported subscription by PRS", Boolean.valueOf(true));
            LOG.debug("IsSupportSubscription true");
        } else {
            response = new BooleanResponseResult("not supported subscription", Boolean.valueOf(false));
            LOG.debug("IsSupportSubscription false");
        }
        return response;
    }

    @ApiOperation(value="Initial system", notes="Initial system include register product,create admin account and login")
    @ApiResponses(value={@ApiResponse(code=404, message="Can't connect to register server. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR> Maybe admin account need or only access when first time create registry"), @ApiResponse(code=445, message="This Machine is illegal for registeration"), @ApiResponse(code=462, message="password length has to be minimum of 6 characters and maximum of 16 characters."), @ApiResponse(code=422, message="Request parameters value is invalid. <BR>"), @ApiResponse(code=435, message="Fail to send mail."), @ApiResponse(code=436, message="Fail to connection to SMPT server."), @ApiResponse(code=405, message="license code is invalid <BR>")})
    @RequestMapping(value={"/InitialCloudbyWeb"}, method={RequestMethod.POST})
    public AutoInitialInfoResponseResult InitialbyCloudWeb(@RequestBody SystemInitialVo systemInitialVo, HttpServletRequest request) {
        ServerType svrType = this.registryService.GetServerType();
        if (svrType != ServerType.Google_Linux_Server_Cloud && svrType != ServerType.Linux_Server_Cloud) {
            throw new PermissionDeniedException("not supported servertype");
        }
        AutoInitialInfoResponseResult response = null;
        String serviceID = this.InitialSystemCloudVersionbyWeb(systemInitialVo, request);
        response = new AutoInitialInfoResponseResult("initial success", new AutoInitialInfo(serviceID, this.databaseName));
        return response;
    }

    @ApiOperation(value="Initial system", notes="Initial system include register product,create admin account and login")
    @ApiResponses(value={@ApiResponse(code=404, message="Can't connect to register server. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR> Maybe admin account need or only access when first time create registry"), @ApiResponse(code=445, message="This Machine is illegal for registeration"), @ApiResponse(code=462, message="password length has to be minimum of 6 characters and maximum of 16 characters."), @ApiResponse(code=422, message="Request parameters value is invalid. <BR>"), @ApiResponse(code=435, message="Fail to send mail."), @ApiResponse(code=436, message="Fail to connection to SMPT server."), @ApiResponse(code=405, message="license code is invalid <BR>")})
    @RequestMapping(value={"/InitialbyCloudSingleAccount"}, method={RequestMethod.POST})
    public AutoInitialInfoResponseResult InitialbyCloudSingleAccount(@RequestBody SystemInitialVo systemInitialVo, HttpServletRequest request) {
        ServerType svrType = this.registryService.GetServerType();
        if (svrType != ServerType.Google_Linux_Server_Cloud && svrType != ServerType.Linux_Server_Cloud) {
            throw new PermissionDeniedException("not supported servertype");
        }
        AutoInitialInfoResponseResult response = null;
        String serviceID = this.InitialSystemByCloudVersionSingleAccount(systemInitialVo, request);
        response = new AutoInitialInfoResponseResult("initial success", new AutoInitialInfo(serviceID, this.databaseName));
        return response;
    }

    @ApiOperation(value="Initial system", notes="Initial system include register product,create admin account and login")
    @ApiResponses(value={@ApiResponse(code=404, message="Can't connect to register server. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR> Maybe admin account need or only access when first time create registry"), @ApiResponse(code=445, message="This Machine is illegal for registeration"), @ApiResponse(code=462, message="password length has to be minimum of 6 characters and maximum of 16 characters."), @ApiResponse(code=422, message="Request parameters value is invalid. <BR>"), @ApiResponse(code=435, message="Fail to send mail."), @ApiResponse(code=436, message="Fail to connection to SMPT server."), @ApiResponse(code=405, message="license code is invalid <BR>")})
    @RequestMapping(value={"/InitialbyCloud"}, method={RequestMethod.POST})
    public AutoInitialInfoResponseResult InitialbyCloud(@RequestBody SystemInitiaTwoPersionVo systemInitiaTwoPersionVo, HttpServletRequest request) {
        ServerType svrType = this.registryService.GetServerType();
        if (svrType != ServerType.Google_Linux_Server_Cloud && svrType != ServerType.Linux_Server_Cloud) {
            throw new PermissionDeniedException("not supported servertype");
        }
        AutoInitialInfoResponseResult response = null;
        String serviceID = this.InitialSystemByCloudVersion(systemInitiaTwoPersionVo, request);
        response = new AutoInitialInfoResponseResult("initial success", new AutoInitialInfo(serviceID, this.databaseName));
        return response;
    }

    @ApiOperation(value="Initial system", notes="Initial system include register product,create admin account and login")
    @ApiResponses(value={@ApiResponse(code=404, message="Can't connect to register server. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR> Maybe admin account need or only access when first time create registry"), @ApiResponse(code=445, message="This Machine is illegal for registeration"), @ApiResponse(code=462, message="password length has to be minimum of 6 characters and maximum of 16 characters."), @ApiResponse(code=422, message="Request parameters value is invalid. <BR>"), @ApiResponse(code=435, message="Fail to send mail."), @ApiResponse(code=436, message="Fail to connection to SMPT server."), @ApiResponse(code=405, message="license code is invalid <BR>")})
    @RequestMapping(value={"/InitialbyDemo"}, method={RequestMethod.POST})
    public AutoInitialInfoResponseResult InitialbyDemo(@RequestBody SystemInitiaDemolVo systemInitiaDemolVo, HttpServletRequest request) {
        ServerType svrType = this.registryService.GetServerType();
        if (svrType != ServerType.ASUSTOR_NAS_Cloud) {
            throw new PermissionDeniedException("not supported servertype");
        }
        AutoInitialInfoResponseResult response = null;
        String serviceID = this.InitialSystemByDemoVersion(systemInitiaDemolVo, request);
        response = new AutoInitialInfoResponseResult("initial success", new AutoInitialInfo(serviceID, this.databaseName));
        return response;
    }

    private String InitialSystemCloudVersionbyWeb(SystemInitialVo systemInitialVo, HttpServletRequest request) {
        Globalinfo maxCompanyCount = this.globalInfoService.getPropertiesByKey("MAX_COMPANY_COUNT");
        Globalinfo maxAccountCount = this.globalInfoService.getPropertiesByKey("MAX_ACCOUNT_COUNT");
        long maxCompanyCountLimit = 1L;
        long maxAccountCountLimit = 0L;
        if (maxCompanyCount != null) {
            maxCompanyCountLimit = Long.parseLong(maxCompanyCount.getConfigValue());
            maxAccountCountLimit = maxAccountCount != null ? Long.parseLong(maxAccountCount.getConfigValue()) : maxCompanyCountLimit * 2L;
        } else {
            maxCompanyCountLimit = 1L;
        }
        if (maxCompanyCountLimit > 1L) {
            if ((long)this.companyService.FindAllCompany().size() >= maxCompanyCountLimit) {
                throw new PermissionDeniedException("exceed max Company Count");
            }
            if (this.subscriptionService.getAllCompanyAccountCount() >= maxAccountCountLimit) {
                throw new PermissionDeniedException("exceed max Account Count");
            }
        } else if (this.subscriptionService.getLicenseMode("") != LicenseMode.NONE) {
            throw new PermissionDeniedException("SystemIsInitialed");
        }
        this.accountService.checkPasswordValidate(systemInitialVo.getAdminPassword());
        String newCompanyGuid = UUIDGenerator.getRandomUUID();
        this.subscriptionService.Initial(systemInitialVo.getEmail(), systemInitialVo.getCompanyName(), systemInitialVo.getCompanyTel(), systemInitialVo.getCountry(), systemInitialVo.getAdminAcountName(), 0, null, SubscriberCreateType.SUBSCRIPTION_CLOUD_BY_WEB, systemInitialVo.getLicenseCode(), newCompanyGuid);
        Company company = this.companyService.createCompany(newCompanyGuid, systemInitialVo.getCompanyName(), systemInitialVo.getCompanyTel());
        this.subscriptionService.DownloadSubscriptionInfo(company.getGuid());
        SubscriptionInfoVo subscriptionInfoVo = this.subscriptionService.getSubscriptionInfo(company.getGuid());
        if (subscriptionInfoVo != null) {
            LOG.debug("subscriptionInfoVo = {}", (Object)subscriptionInfoVo);
            if (subscriptionInfoVo.checkLastTrialAccountCountLimit() > 1) {
                TokenInfoResponseResult response = null;
                try {
                    String adminAccountID = "";
                    String remoteIp = NetworkUtil.getClientIp((HttpServletRequest)request);
                    LOG.debug("create two account 1= {}", (Object)systemInitialVo);
                    LOG.debug("create two account 2= {}", (Object)systemInitialVo);
                    String accountID = this.CreateAccount(systemInitialVo.getEmail(), false, true, true, systemInitialVo.getAdminAcountName(), systemInitialVo.getAdminPassword(), UserRole.ADMIN, "", UserStatus.INACTIVE, company);
                    LOG.debug("create two account 2 end");
                    TokenInfo token = this.tokenService.createNewToken(accountID, remoteIp);
                    response = new TokenInfoResponseResult(String.format("subscription success and account[%s]  has been created.", systemInitialVo.getEmail()), token);
                }
                catch (Exception ex) {
                    response = new TokenInfoResponseResult("subscription  fail by exception =" + ex.getMessage(), null);
                }
                this.subscriptionService.setLicenseMode(company.getGuid(), LicenseMode.SUBSCRIPTION);
                String serviceID = this.subscriptionService.getSubscriptionInfo(company.getGuid()).getServiceId();
                return serviceID;
            }
            throw new IncorrectRegistrationInformationException("no subscirption info or invalidate");
        }
        throw new IncorrectRegistrationInformationException("no subscirption info ");
    }

    private String InitialSystemByCloudVersionSingleAccount(SystemInitialVo systemInitialVo, HttpServletRequest request) {
        Globalinfo maxCompanyCount = this.globalInfoService.getPropertiesByKey("MAX_COMPANY_COUNT");
        Globalinfo maxAccountCount = this.globalInfoService.getPropertiesByKey("MAX_ACCOUNT_COUNT");
        long maxCompanyCountLimit = 1L;
        long maxAccountCountLimit = 0L;
        if (maxCompanyCount != null) {
            maxCompanyCountLimit = Long.parseLong(maxCompanyCount.getConfigValue());
            maxAccountCountLimit = maxAccountCount != null ? Long.parseLong(maxAccountCount.getConfigValue()) : maxCompanyCountLimit * 2L;
        } else {
            maxCompanyCountLimit = 1L;
        }
        if (maxCompanyCountLimit > 1L) {
            if ((long)this.companyService.FindAllCompany().size() >= maxCompanyCountLimit) {
                throw new PermissionDeniedException("exceed max Company Count");
            }
            if (this.subscriptionService.getAllCompanyAccountCount() >= maxAccountCountLimit) {
                throw new PermissionDeniedException("exceed max Account Count");
            }
        } else if (this.subscriptionService.getLicenseMode("") != LicenseMode.NONE) {
            throw new PermissionDeniedException("SystemIsInitialed");
        }
        this.accountService.checkPasswordValidate(systemInitialVo.getAdminPassword());
        String newCompanyGuid = UUIDGenerator.getRandomUUID();
        this.subscriptionService.Initial(systemInitialVo.getEmail(), systemInitialVo.getCompanyName(), systemInitialVo.getCompanyTel(), systemInitialVo.getCountry(), systemInitialVo.getAdminAcountName(), 0, null, SubscriberCreateType.SUBSCRIPTION_CLOUD_BY_SERIAL, systemInitialVo.getLicenseCode(), newCompanyGuid);
        Company company = this.companyService.createCompany(newCompanyGuid, systemInitialVo.getCompanyName(), systemInitialVo.getCompanyTel());
        this.subscriptionService.DownloadSubscriptionInfo(company.getGuid());
        SubscriptionInfoVo subscriptionInfoVo = this.subscriptionService.getSubscriptionInfo(company.getGuid());
        if (subscriptionInfoVo != null) {
            LOG.debug("subscriptionInfoVo = {}", (Object)subscriptionInfoVo);
            if (subscriptionInfoVo.checkLastTrialAccountCountLimit() > 1) {
                TokenInfoResponseResult response = null;
                try {
                    String adminAccountID = "";
                    String remoteIp = NetworkUtil.getClientIp((HttpServletRequest)request);
                    TokenInfo token = null;
                    adminAccountID = this.CreateAccount(systemInitialVo.getEmail(), true, true, true, systemInitialVo.getAdminAcountName(), systemInitialVo.getAdminPassword(), UserRole.ADMIN, "", UserStatus.INACTIVE, company);
                    LOG.debug("create two account 1 end");
                    token = this.tokenService.createNewToken(adminAccountID, remoteIp);
                    response = new TokenInfoResponseResult(String.format("subscription success and account[%s]  has been created.", systemInitialVo.getEmail()), token);
                }
                catch (Exception ex) {
                    response = new TokenInfoResponseResult("subscription  fail by exception =" + ex.getMessage(), null);
                }
                this.subscriptionService.setLicenseMode(company.getGuid(), LicenseMode.SUBSCRIPTION);
                String serviceID = this.subscriptionService.getSubscriptionInfo(company.getGuid()).getServiceId();
                return serviceID;
            }
            throw new IncorrectRegistrationInformationException("no subscirption info or invalidate");
        }
        throw new IncorrectRegistrationInformationException("no subscirption info ");
    }

    private String InitialSystemByCloudVersion(SystemInitiaTwoPersionVo systemInitiaTwoPersionVo, HttpServletRequest request) {
        Globalinfo maxCompanyCount = this.globalInfoService.getPropertiesByKey("MAX_COMPANY_COUNT");
        Globalinfo maxAccountCount = this.globalInfoService.getPropertiesByKey("MAX_ACCOUNT_COUNT");
        long maxCompanyCountLimit = 1L;
        long maxAccountCountLimit = 0L;
        if (maxCompanyCount != null) {
            maxCompanyCountLimit = Long.parseLong(maxCompanyCount.getConfigValue());
            maxAccountCountLimit = maxAccountCount != null ? Long.parseLong(maxAccountCount.getConfigValue()) : maxCompanyCountLimit * 2L;
        } else {
            maxCompanyCountLimit = 1L;
        }
        if (maxCompanyCountLimit > 1L) {
            if ((long)this.companyService.FindAllCompany().size() >= maxCompanyCountLimit) {
                throw new PermissionDeniedException("exceed max Company Count");
            }
            if (this.subscriptionService.getAllCompanyAccountCount() >= maxAccountCountLimit) {
                throw new PermissionDeniedException("exceed max Account Count");
            }
        } else if (this.subscriptionService.getLicenseMode("") != LicenseMode.NONE) {
            throw new PermissionDeniedException("SystemIsInitialed");
        }
        this.accountService.checkPasswordValidate(systemInitiaTwoPersionVo.getAdminPassword());
        this.accountService.checkPasswordValidate(systemInitiaTwoPersionVo.getSecondAccountPassword());
        String newCompanyGuid = UUIDGenerator.getRandomUUID();
        this.subscriptionService.Initial(systemInitiaTwoPersionVo.getEmail(), systemInitiaTwoPersionVo.getCompanyName(), systemInitiaTwoPersionVo.getCompanyTel(), systemInitiaTwoPersionVo.getCountry(), systemInitiaTwoPersionVo.getAdminAcountName(), 0, null, SubscriberCreateType.SUBSCRIPTION_CLOUD_BY_SERIAL, systemInitiaTwoPersionVo.getLicenseCode(), newCompanyGuid);
        Company company = this.companyService.createCompany(newCompanyGuid, systemInitiaTwoPersionVo.getCompanyName(), systemInitiaTwoPersionVo.getCompanyTel());
        this.subscriptionService.DownloadSubscriptionInfo(company.getGuid());
        SubscriptionInfoVo subscriptionInfoVo = this.subscriptionService.getSubscriptionInfo(company.getGuid());
        if (subscriptionInfoVo != null) {
            LOG.debug("subscriptionInfoVo = {}", (Object)subscriptionInfoVo);
            if (subscriptionInfoVo.checkLastTrialAccountCountLimit() > 1) {
                TokenInfoResponseResult response = null;
                try {
                    String adminAccountID = "";
                    String remoteIp = NetworkUtil.getClientIp((HttpServletRequest)request);
                    TokenInfo token = null;
                    if (systemInitiaTwoPersionVo.getSecondCreateAccountRole() == CreateAccountRole.BOSS) {
                        LOG.debug("create two account 1= {}", (Object)systemInitiaTwoPersionVo);
                        String bossAccountID = this.CreateAccount(systemInitiaTwoPersionVo.getSecondAccountEmail(), true, true, true, systemInitiaTwoPersionVo.getSecondAccountName(), systemInitiaTwoPersionVo.getSecondAccountPassword(), UserRole.NORMAL_USER, "", UserStatus.INACTIVE, company);
                        adminAccountID = this.CreateAccount(systemInitiaTwoPersionVo.getEmail(), true, true, true, systemInitiaTwoPersionVo.getAdminAcountName(), systemInitiaTwoPersionVo.getAdminPassword(), UserRole.ADMIN, bossAccountID, UserStatus.INACTIVE, company);
                        LOG.debug("create two account 1 end");
                        token = this.tokenService.createNewToken(adminAccountID, remoteIp);
                    } else {
                        String bossAccountID;
                        LOG.debug("create two account 2= {}", (Object)systemInitiaTwoPersionVo);
                        adminAccountID = bossAccountID = this.CreateAccount(systemInitiaTwoPersionVo.getEmail(), true, true, true, systemInitiaTwoPersionVo.getAdminAcountName(), systemInitiaTwoPersionVo.getAdminPassword(), UserRole.ADMIN, "", UserStatus.INACTIVE, company);
                        this.CreateAccount(systemInitiaTwoPersionVo.getSecondAccountEmail(), true, true, true, systemInitiaTwoPersionVo.getSecondAccountName(), systemInitiaTwoPersionVo.getSecondAccountPassword(), UserRole.NORMAL_USER, bossAccountID, UserStatus.INACTIVE, company);
                        LOG.debug("create two account 2 end");
                        token = this.tokenService.createNewToken(bossAccountID, remoteIp);
                    }
                    response = new TokenInfoResponseResult(String.format("subscription success and account[%s] and [%S] has been created.", systemInitiaTwoPersionVo.getEmail(), systemInitiaTwoPersionVo.getSecondAccountEmail()), token);
                }
                catch (Exception ex) {
                    response = new TokenInfoResponseResult("subscription  fail by exception =" + ex.getMessage(), null);
                }
                this.subscriptionService.setLicenseMode(company.getGuid(), LicenseMode.SUBSCRIPTION);
                String serviceID = this.subscriptionService.getSubscriptionInfo(company.getGuid()).getServiceId();
                return serviceID;
            }
            throw new IncorrectRegistrationInformationException("no subscirption info or invalidate");
        }
        throw new IncorrectRegistrationInformationException("no subscirption info ");
    }

    private String CreateAccount(String eMail, boolean SecretaryAblity, boolean ExportAbility, boolean PrintAbility, String Name, String Password, UserRole userRole, String Boss, UserStatus userStatus, Company company) {
        LOG.debug("CreateAccount eMail = {}  Name = {}  Password = {}  userRole = {}  Boss = {}  userStatus = {} ", new Object[]{eMail, Name, Password, userRole, Boss, userStatus});
        AccountCreationVo accountCreationVo = new AccountCreationVo();
        accountCreationVo.setEmail(eMail);
        accountCreationVo.setExportAbility(ExportAbility);
        accountCreationVo.setName(Name);
        accountCreationVo.setRole(userRole);
        accountCreationVo.setBoss(Boss);
        accountCreationVo.setStatus(userStatus);
        accountCreationVo.setSecretary(SecretaryAblity);
        accountCreationVo.setPrintAbility(true);
        String guid = this.accountService.createAccount(accountCreationVo, company.getGuid(), false);
        LOG.debug("CreateAccount guid={}", (Object)guid);
        this.accountService.updatePassword(guid, Password);
        this.contactPrivateService.CreateDefaultContact(guid, company.getGuid());
        return guid;
    }

    private LocalDate JodaTimeToJavaTime(DateTime localDateTime) {
        LocalDate date = LocalDate.of(localDateTime.getYear(), localDateTime.getMonthOfYear(), localDateTime.getDayOfMonth());
        return date;
    }

    private String InitialSystemByDemoVersion(SystemInitiaDemolVo systemInitiaDemolVo, HttpServletRequest request) {
        if (this.subscriptionService.getLicenseMode("") != LicenseMode.NONE) {
            throw new PermissionDeniedException("SystemIsInitialed");
        }
        this.accountService.checkPasswordValidate(systemInitiaDemolVo.getAdminPassword());
        String newCompanyGuid = UUIDGenerator.getRandomUUID();
        LocalDate javaValidateDate = this.JodaTimeToJavaTime(systemInitiaDemolVo.getValidateDate());
        this.subscriptionService.Initial(systemInitiaDemolVo.getEmail(), systemInitiaDemolVo.getCompanyName(), systemInitiaDemolVo.getCompanyTel(), systemInitiaDemolVo.getCountry(), systemInitiaDemolVo.getAdminAcountName(), systemInitiaDemolVo.getAccountNum(), javaValidateDate, SubscriberCreateType.SUBSCRIPTION_DEMO, "", newCompanyGuid);
        Company company = this.companyService.createCompany(newCompanyGuid, systemInitiaDemolVo.getCompanyName(), systemInitiaDemolVo.getCompanyTel());
        this.subscriptionService.DownloadSubscriptionInfo(company.getGuid());
        SubscriptionInfoVo subscriptionInfoVo = this.subscriptionService.getSubscriptionInfo(company.getGuid());
        if (subscriptionInfoVo != null) {
            LOG.debug("subscriptionInfoVo = {}", (Object)subscriptionInfoVo);
            if (subscriptionInfoVo.checkLastTrialAccountCountLimit() > 0) {
                TokenInfoResponseResult response = null;
                try {
                    AccountCreationVo accountCreationVo = new AccountCreationVo();
                    accountCreationVo.setEmail(systemInitiaDemolVo.getEmail());
                    accountCreationVo.setExportAbility(true);
                    accountCreationVo.setName(systemInitiaDemolVo.getAdminAcountName());
                    accountCreationVo.setRole(UserRole.ADMIN);
                    accountCreationVo.setBoss("");
                    accountCreationVo.setStatus(UserStatus.INACTIVE);
                    String guid = this.accountService.createAccount(accountCreationVo, company.getGuid(), false);
                    this.accountService.updatePassword(guid, systemInitiaDemolVo.getAdminPassword());
                    String remoteIp = NetworkUtil.getClientIp((HttpServletRequest)request);
                    TokenInfo token = this.tokenService.createNewToken(guid, remoteIp);
                    this.contactPrivateService.CreateDefaultContact(guid, company.getGuid());
                    response = new TokenInfoResponseResult(String.format("subscription success and account[%s] has been created.", accountCreationVo.getEmail()), token);
                }
                catch (Exception ex) {
                    response = new TokenInfoResponseResult("subscription  fail by exception =" + ex.getMessage(), null);
                }
                this.subscriptionService.setLicenseMode(company.getGuid(), LicenseMode.SUBSCRIPTION);
                String serviceID = this.subscriptionService.getSubscriptionInfo(company.getGuid()).getServiceId();
                return serviceID;
            }
            throw new IncorrectRegistrationInformationException("no subscirption info or invalidate");
        }
        throw new IncorrectRegistrationInformationException("no subscirption info ");
    }

    @ApiOperation(value="Initial system", notes="Initial system include register product,create admin account and login")
    @ApiResponses(value={@ApiResponse(code=404, message="Can't connect to register server. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR> Maybe admin account need or only access when first time create registry"), @ApiResponse(code=445, message="This Machine is illegal for registeration"), @ApiResponse(code=462, message="password length has to be minimum of 6 characters and maximum of 16 characters."), @ApiResponse(code=422, message="Request parameters value is invalid. <BR>"), @ApiResponse(code=435, message="Fail to send mail."), @ApiResponse(code=436, message="Fail to connection to SMPT server."), @ApiResponse(code=405, message="license code is invalid <BR>")})
    @RequestMapping(value={"/InitialbyAuto"}, method={RequestMethod.POST})
    public AutoInitialInfoResponseResult InitialbyAuto(@RequestBody SystemInitialVo systemInitialVo, HttpServletRequest request) {
        ServerType svrType = this.registryService.GetServerType();
        if (svrType != ServerType.ASUSTOR_NAS_AUTOMATION) {
            throw new PermissionDeniedException("not supported servertype");
        }
        Globalinfo maxCompanyCount = this.globalInfoService.getPropertiesByKey("MAX_COMPANY_COUNT");
        long maxCompanyCountLimit = 1L;
        maxCompanyCountLimit = maxCompanyCount != null ? Long.parseLong(maxCompanyCount.getConfigValue()) : 1L;
        if (maxCompanyCountLimit > 1L) {
            if ((long)this.companyService.FindAllCompany().size() >= maxCompanyCountLimit) {
                throw new PermissionDeniedException("exceed max Company Count");
            }
        } else if (this.subscriptionService.getLicenseMode("") != LicenseMode.NONE) {
            throw new PermissionDeniedException("SystemIsInitialed");
        }
        AutoInitialInfoResponseResult response = null;
        String serviceID = this.InitialSystemByAutomationSubscription(systemInitialVo, request);
        response = new AutoInitialInfoResponseResult("initial success", new AutoInitialInfo(serviceID, this.databaseName));
        return response;
    }

    private String InitialSystemByAutomationSubscription(SystemInitialVo systemInitialVo, HttpServletRequest request) {
        if (this.subscriptionService.getLicenseMode("") != LicenseMode.NONE) {
            throw new PermissionDeniedException("SystemIsInitialed");
        }
        this.accountService.checkPasswordValidate(systemInitialVo.getAdminPassword());
        String newCompanyGuid = UUIDGenerator.getRandomUUID();
        this.subscriptionService.Initial(systemInitialVo.getEmail(), systemInitialVo.getCompanyName(), systemInitialVo.getCompanyTel(), systemInitialVo.getCountry(), systemInitialVo.getAdminAcountName(), 0, null, SubscriberCreateType.SUBSCRIPTION_AUTO_TRIAL_NEW, "", newCompanyGuid);
        Company company = this.companyService.createCompany(newCompanyGuid, systemInitialVo.getCompanyName(), systemInitialVo.getCompanyTel());
        this.subscriptionService.DownloadSubscriptionInfo(company.getGuid());
        SubscriptionInfoVo subscriptionInfoVo = this.subscriptionService.getSubscriptionInfo(company.getGuid());
        if (subscriptionInfoVo != null) {
            LOG.debug("subscriptionInfoVo = {}", (Object)subscriptionInfoVo);
            if (subscriptionInfoVo.checkLastTrialAccountCountLimit() > 0) {
                TokenInfoResponseResult response = null;
                try {
                    AccountCreationVo accountCreationVo = new AccountCreationVo();
                    accountCreationVo.setEmail(systemInitialVo.getEmail());
                    accountCreationVo.setExportAbility(true);
                    accountCreationVo.setName(systemInitialVo.getAdminAcountName());
                    accountCreationVo.setRole(UserRole.ADMIN);
                    accountCreationVo.setBoss("");
                    accountCreationVo.setStatus(UserStatus.INACTIVE);
                    String guid = this.accountService.createAccount(accountCreationVo, company.getGuid(), false);
                    this.accountService.updatePassword(guid, systemInitialVo.getAdminPassword());
                    String remoteIp = NetworkUtil.getClientIp((HttpServletRequest)request);
                    TokenInfo token = this.tokenService.createNewToken(guid, remoteIp);
                    this.contactPrivateService.CreateDefaultContact(guid, company.getGuid());
                    response = new TokenInfoResponseResult(String.format("subscription success and account[%s] has been created.", accountCreationVo.getEmail()), token);
                }
                catch (Exception ex) {
                    response = new TokenInfoResponseResult("subscription  fail by exception =" + ex.getMessage(), null);
                }
                this.subscriptionService.setLicenseMode(company.getGuid(), LicenseMode.SUBSCRIPTION);
                String serviceID = this.subscriptionService.getSubscriptionInfo(company.getGuid()).getServiceId();
                return serviceID;
            }
            throw new IncorrectRegistrationInformationException("no subscirption info or invalidate");
        }
        throw new IncorrectRegistrationInformationException("no subscirption info ");
    }

    @ApiOperation(value="Initial system", notes="Initial system include register product,create admin account and login")
    @ApiResponses(value={@ApiResponse(code=404, message="Can't connect to register server. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR> Maybe admin account need or only access when first time create registry"), @ApiResponse(code=445, message="This Machine is illegal for registeration"), @ApiResponse(code=462, message="password length has to be minimum of 6 characters and maximum of 16 characters."), @ApiResponse(code=422, message="Request parameters value is invalid. <BR>"), @ApiResponse(code=435, message="Fail to send mail."), @ApiResponse(code=436, message="Fail to connection to SMPT server."), @ApiResponse(code=405, message="license code is invalid <BR>")})
    @RequestMapping(value={"/Initial"}, method={RequestMethod.POST})
    public TokenInfoResponseResult Initial(@RequestBody SystemInitialVo systemInitialVo, @RequestParam(value="languageCode") LanguageCode languageCode, HttpServletRequest request) {
        boolean belongSubscription;
        ServerType svrType = this.registryService.GetServerType();
        if (svrType != ServerType.ASUSTOR_NAS && svrType != ServerType.Window_Server && svrType != ServerType.Linux_Server && svrType != ServerType.SYNOLOGY_NAS) {
            throw new PermissionDeniedException("not supported servertype");
        }
        if (this.subscriptionService.getLicenseMode("") != LicenseMode.NONE) {
            throw new PermissionDeniedException("SystemIsInitialed");
        }
        TokenInfoResponseResult response = null;
        response = !systemInitialVo.getIsTrial() ? ((belongSubscription = this.subscriptionService.CheckSerialBelongSubscription(systemInitialVo.getLicenseCode())) ? (svrType == ServerType.ASUSTOR_NAS ? this.InitialSystemBySubscriptionCode(systemInitialVo, languageCode, request) : this.InitialSystemByBuyOut(systemInitialVo, languageCode, request)) : this.InitialSystemByBuyOut(systemInitialVo, languageCode, request)) : (this.subscriptionService.IsCurrentLocateSupportSubscription() ? this.InitialSystemBySubscription(systemInitialVo, languageCode, request) : this.InitialSystemByBuyOut(systemInitialVo, languageCode, request));
        return response;
    }

    private TokenInfoResponseResult InitialSystemBySubscriptionCode(SystemInitialVo systemInitialVo, LanguageCode languageCode, HttpServletRequest request) {
        if (!systemInitialVo.IsValidata()) {
            throw new RequestArgumentNotValidException("one of  licenseCode, email, adminAcountName is empty");
        }
        this.accountService.checkPasswordValidate(systemInitialVo.getAdminPassword());
        String newCompanyGuid = UUIDGenerator.getRandomUUID();
        this.subscriptionService.Initial(systemInitialVo.getEmail(), systemInitialVo.getCompanyName(), systemInitialVo.getCompanyTel(), systemInitialVo.getCountry(), systemInitialVo.getAdminAcountName(), 0, null, SubscriberCreateType.SUBSCRIPTION_BY_SERIAL, systemInitialVo.getLicenseCode(), newCompanyGuid);
        Company company = this.companyService.createCompany(newCompanyGuid, systemInitialVo.getCompanyName(), systemInitialVo.getCompanyTel());
        this.subscriptionService.DownloadSubscriptionInfo(company.getGuid());
        SubscriptionInfoVo subscriptionInfoVo = this.subscriptionService.getSubscriptionInfo(company.getGuid());
        if (subscriptionInfoVo != null) {
            LOG.debug("subscriptionInfoVo = {}", (Object)subscriptionInfoVo);
            if (subscriptionInfoVo.checkLastTrialAccountCountLimit() > 0) {
                TokenInfoResponseResult response = null;
                try {
                    AccountCreationVo accountCreationVo = new AccountCreationVo();
                    accountCreationVo.setEmail(systemInitialVo.getEmail());
                    accountCreationVo.setExportAbility(true);
                    accountCreationVo.setName(systemInitialVo.getAdminAcountName());
                    accountCreationVo.setRole(UserRole.ADMIN);
                    accountCreationVo.setBoss("");
                    accountCreationVo.setStatus(UserStatus.ACTIVE);
                    String guid = this.accountService.createAccount(accountCreationVo, company.getGuid(), false);
                    this.accountService.changePassword(guid, "penpower", systemInitialVo.getAdminPassword());
                    String remoteIp = NetworkUtil.getClientIp((HttpServletRequest)request);
                    TokenInfo token = this.tokenService.createNewToken(guid, remoteIp);
                    this.contactPrivateService.CreateDefaultContact(guid, company.getGuid());
                    response = new TokenInfoResponseResult(String.format("subscription success and account[%s] has been created.", accountCreationVo.getEmail()), token);
                }
                catch (Exception ex) {
                    response = new TokenInfoResponseResult("subscription  fail by exception =" + ex.getMessage(), null);
                }
                this.subscriptionService.setLicenseMode(company.getGuid(), LicenseMode.SUBSCRIPTION);
                this.CreateSendMailJob(systemInitialVo.getEmail(), systemInitialVo.getAdminAcountName(), languageCode);
                return response;
            }
            throw new IncorrectRegistrationInformationException("no subscirption info or invalidate");
        }
        throw new IncorrectRegistrationInformationException("no subscirption info ");
    }

    private TokenInfoResponseResult InitialSystemBySubscription(SystemInitialVo systemInitialVo, LanguageCode languageCode, HttpServletRequest request) {
        if (!systemInitialVo.IsValidata()) {
            throw new RequestArgumentNotValidException("one of  licenseCode, email, adminAcountName is empty");
        }
        this.accountService.checkPasswordValidate(systemInitialVo.getAdminPassword());
        String newCompanyGuid = UUIDGenerator.getRandomUUID();
        this.subscriptionService.Initial(systemInitialVo.getEmail(), systemInitialVo.getCompanyName(), systemInitialVo.getCompanyTel(), systemInitialVo.getCountry(), systemInitialVo.getAdminAcountName(), 0, null, SubscriberCreateType.SUBSCRIPTION_TRIAL_NEW, "", newCompanyGuid);
        Company company = this.companyService.createCompany(newCompanyGuid, systemInitialVo.getCompanyName(), systemInitialVo.getCompanyTel());
        this.subscriptionService.DownloadSubscriptionInfo(company.getGuid());
        SubscriptionInfoVo subscriptionInfoVo = this.subscriptionService.getSubscriptionInfo(company.getGuid());
        if (subscriptionInfoVo != null) {
            LOG.debug("subscriptionInfoVo = {}", (Object)subscriptionInfoVo);
            if (subscriptionInfoVo.checkLastTrialAccountCountLimit() > 0) {
                TokenInfoResponseResult response = null;
                try {
                    AccountCreationVo accountCreationVo = new AccountCreationVo();
                    accountCreationVo.setEmail(systemInitialVo.getEmail());
                    accountCreationVo.setExportAbility(true);
                    accountCreationVo.setName(systemInitialVo.getAdminAcountName());
                    accountCreationVo.setRole(UserRole.ADMIN);
                    accountCreationVo.setBoss("");
                    accountCreationVo.setStatus(UserStatus.ACTIVE);
                    String guid = this.accountService.createAccount(accountCreationVo, company.getGuid(), false);
                    LOG.debug("InitialSystemBySubscription guid = {}", (Object)guid);
                    this.accountService.changePassword(guid, "penpower", systemInitialVo.getAdminPassword());
                    String remoteIp = NetworkUtil.getClientIp((HttpServletRequest)request);
                    TokenInfo token = this.tokenService.createNewToken(guid, remoteIp);
                    this.contactPrivateService.CreateDefaultContact(guid, company.getGuid());
                    response = new TokenInfoResponseResult(String.format("subscription success and account[%s] has been created.", accountCreationVo.getEmail()), token);
                }
                catch (Exception ex) {
                    response = new TokenInfoResponseResult("subscription  fail by exception =" + ex.getMessage(), null);
                    LOG.debug("InitialSystemBySubscription ex = {}", (Object)ex.getMessage());
                }
                this.subscriptionService.setLicenseMode(company.getGuid(), LicenseMode.SUBSCRIPTION);
                this.CreateSendMailJob(systemInitialVo.getEmail(), systemInitialVo.getAdminAcountName(), languageCode);
                return response;
            }
            throw new IncorrectRegistrationInformationException("no subscirption info or invalidate");
        }
        throw new IncorrectRegistrationInformationException("no subscirption info ");
    }

    private TokenInfoResponseResult InitialSystemByBuyOut(SystemInitialVo systemInitialVo, LanguageCode languageCode, HttpServletRequest request) {
        if (systemInitialVo.getIsTrial()) {
            systemInitialVo.setLicenseCode("ICGOPLEJNWITJVXD");
        } else if (systemInitialVo.getLicenseCode().compareToIgnoreCase("ICGOPLEJNWITJVXD") == 0) {
            throw new IncorrectRegistrationInformationException("License code is not validate");
        }
        if (!systemInitialVo.IsValidata()) {
            throw new RequestArgumentNotValidException("one of  licenseCode, email, adminAcountName is empty");
        }
        this.accountService.checkPasswordValidate(systemInitialVo.getAdminPassword());
        int nCount = this.registryService.getLicenseCount(false);
        if (nCount > 0) {
            throw new PermissionDeniedException("Can't register server wiithout auth after server initialed");
        }
        this.registryService.register(systemInitialVo.getEmail(), systemInitialVo.getLicenseCode(), systemInitialVo.getCompanyName(), systemInitialVo.getCompanyTel(), false, systemInitialVo.getCountry().toString());
        TokenInfoResponseResult response = null;
        String newCompanyGuid = UUIDGenerator.getRandomUUID();
        Company company = this.companyService.createCompany(newCompanyGuid, systemInitialVo.getCompanyName(), systemInitialVo.getCompanyTel());
        try {
            AccountCreationVo accountCreationVo = new AccountCreationVo();
            accountCreationVo.setEmail(systemInitialVo.getEmail());
            accountCreationVo.setExportAbility(true);
            accountCreationVo.setName(systemInitialVo.getAdminAcountName());
            accountCreationVo.setRole(UserRole.ADMIN);
            accountCreationVo.setBoss("");
            accountCreationVo.setStatus(UserStatus.ACTIVE);
            LOG.debug("clear account 3");
            String guid = this.accountService.createAccount(accountCreationVo, company.getGuid(), true);
            LOG.debug("clear account 4");
            this.accountService.changePassword(guid, "penpower", systemInitialVo.getAdminPassword());
            LOG.debug("clear account 4a");
            String remoteIp = NetworkUtil.getClientIp((HttpServletRequest)request);
            TokenInfo token = this.tokenService.createNewToken(guid, remoteIp);
            LOG.debug("clear account 4b");
            this.contactPrivateService.CreateDefaultContact(guid, company.getGuid());
            LOG.debug("clear account 5");
            response = new TokenInfoResponseResult(String.format("Register success and account[%s] has been created.", accountCreationVo.getEmail()), token);
            LOG.debug("clear account 6");
        }
        catch (Exception ex) {
            LOG.debug("Exception ={}", (Object)ex.getMessage());
            this.registryService.clearRegistry();
            response = new TokenInfoResponseResult("Register  fail by exception =" + ex.getMessage(), null);
        }
        this.subscriptionService.setLicenseMode(company.getGuid(), LicenseMode.BUYOUT);
        this.CreateSendMailJob(systemInitialVo.getEmail(), systemInitialVo.getAdminAcountName(), languageCode);
        return response;
    }

    @ApiOperation(value="ReInitial system", notes="ReInitial system while machine is replace new one")
    @ApiResponses(value={@ApiResponse(code=404, message="Can't connect to register server. <BR>"), @ApiResponse(code=401, message="Authentication failed.<BR>"), @ApiResponse(code=445, message="This Machine is illegal for registeration"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR> Maybe admin account need or only access when first time create registry"), @ApiResponse(code=405, message="license code is invalid <BR>")})
    @RequestMapping(value={"/ReInitial"}, method={RequestMethod.POST})
    public TokenInfoResponseResult ReInitial(@RequestBody SystemReInitialVo systemReInitialVo, HttpServletRequest request) {
        try {
            this.accountService.verifyAccount(null, systemReInitialVo.getEmail());
        }
        catch (ItemNotFoundException ex) {
            throw new AuthenticationFailedException(String.format("Login failed, Account[%s] not found", systemReInitialVo.getEmail()));
        }
        boolean passwordCorrect = this.accountService.verifyPassword(null, systemReInitialVo.getEmail(), systemReInitialVo.getAdminPassword());
        if (!passwordCorrect) {
            throw new AuthenticationFailedException(String.format("Failed to login User[%s] password not correct..", systemReInitialVo.getEmail()));
        }
        AccountInfo accountInfo = null;
        try {
            accountInfo = this.accountService.getAccountInfo(null, systemReInitialVo.getEmail());
        }
        catch (Exception ex) {
            throw new AuthenticationFailedException(String.format("Failed to login User[%s] password not correct..", systemReInitialVo.getEmail()));
        }
        if (accountInfo != null) {
            if (accountInfo.getRole() != UserRole.ADMIN) {
                throw new PermissionDeniedException(String.format("login User[%s] is not admin", systemReInitialVo.getEmail()));
            }
        } else {
            throw new AuthenticationFailedException(String.format("Failed to login User[%s] password not correct..", systemReInitialVo.getEmail()));
        }
        String remoteIp = NetworkUtil.getClientIp((HttpServletRequest)request);
        TokenInfo token = this.tokenService.createNewToken(accountInfo.getGuid(), remoteIp);
        this.registryService.ReRegister(systemReInitialVo.getEmail(), systemReInitialVo.getLicenseCode());
        LOG.debug("clear account 5");
        TokenInfoResponseResult response = new TokenInfoResponseResult(String.format("account[%s] login success  ", accountInfo.getEmail()), token);
        LOG.debug("clear account 6");
        return response;
    }

    public static String EnCode(String key, String dataString) throws Exception {
        try {
            byte[] data = dataString.getBytes("UTF-8");
            if (data.length % 8 != 0) {
                int newDateLength = (data.length / 8 + 1) * 8;
                System.out.println(newDateLength);
                byte[] newData = Arrays.copyOf(data, newDateLength);
                for (int i = data.length; i < newData.length; ++i) {
                    newData[i] = 0;
                }
                data = newData;
            }
            DESKeySpec dks = new DESKeySpec(key.getBytes());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(dks);
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, secretKey);
            byte[] bytes = cipher.doFinal(data);
            return new String(Base64.getEncoder().encodeToString(bytes));
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @RequestMapping(value={"/GetProductInfo"}, method={RequestMethod.GET})
    public MessageResponseResult GetProductInfo(@RequestParam String currentAcntID) {
        MessageResponseResult productInfoResponseResult = null;
        LOG.debug("GetProductInfo ");
        ProductInfo productInfo = new ProductInfo();
        ServerType svrType = this.registryService.GetServerType();
        productInfo.setSerialNumber(HardwareIdUtil.GetMachineID((ServerType)svrType));
        productInfo.setMacAddr0(HardwareIdUtil.getEthernetInterfacebyid((ServerType)svrType, (int)0));
        productInfo.setMacAddr1(HardwareIdUtil.getEthernetInterfacebyid((ServerType)svrType, (int)1));
        if (!StringUtil.IsStringNullorEmpty((String)currentAcntID)) {
            try {
                AccountInfo acntinfo = this.accountService.getAccountInfo(currentAcntID, null);
                if (acntinfo != null) {
                    productInfo.setEmail(acntinfo.getEmail());
                    productInfo.setName(acntinfo.getName());
                }
            }
            catch (Exception acntinfo) {
                // empty catch block
            }
        }
        JSONObject jproduct = new JSONObject((Object)productInfo);
        LOG.debug("GetProductInfo string={}", (Object)jproduct.toString());
        try {
            String productinfoUrl = jproduct.toString();
            try {
                productinfoUrl = URLEncoder.encode(productinfoUrl, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            String encodeProduct = SystemController.EnCode((String)"ppwcteam", (String)productinfoUrl);
            LOG.debug("GetProductInfo encodeProduct={}", (Object)encodeProduct);
            encodeProduct = this.GetUTF8(encodeProduct);
            LOG.debug("GetProductInfo encodeProduct={}", (Object)encodeProduct);
            productInfoResponseResult = new MessageResponseResult("get product info success", encodeProduct);
            return productInfoResponseResult;
        }
        catch (Exception e) {
            productInfoResponseResult = new MessageResponseResult("get product info fail", "");
            return productInfoResponseResult;
        }
    }

    private String GetUTF8(String strSource) {
        String strba = "";
        if (strSource != null) {
            try {
                byte[] byteArray;
                for (byte ba : byteArray = strSource.getBytes("UTF-8")) {
                    String strp = "%" + String.format("%02x", ba);
                    strba = strba + strp;
                }
            }
            catch (Exception e) {
                return null;
            }
        } else {
            return null;
        }
        return strba;
    }

    @RequestMapping(value={"/GetVersionInfo"}, method={RequestMethod.GET})
    @ApiOperation(value="VersionInfo", notes="Get versioninfo in format Major.Minor.Release.Number")
    public VersionInfoResponseResult GetVersionInfo() {
        VersionInfoResponseResult versionInfoResponseResult = null;
        ServerType svrType = this.registryService.GetServerType();
        VersionInfo versionInfo = new VersionInfo("6.0.0.41", "WorldCardTeamAPI", svrType, "product version");
        versionInfoResponseResult = new VersionInfoResponseResult("System api version V Major.Minor.Release.Number", versionInfo);
        return versionInfoResponseResult;
    }

    @RequestMapping(value={"/GetProductVersionInfo"}, method={RequestMethod.GET})
    @ApiOperation(value="VersionInfo", notes="Get versioninfo in format Major.Minor.Release.Number")
    public MessageResponseResult GetProductVersionInfo() {
        MessageResponseResult respone = new MessageResponseResult("", "V1.6.16");
        return respone;
    }

    boolean SetQSMNoticeMailSender(String accountMail) {
        OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
        LOG.debug("SetQSMNoticeMailSender");
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("mail_type", "custom").addFormDataPart("mail_from", "noticesender@mail.worldcardteam.com").addFormDataPart("smtp_server", "mail.worldcardteam.com").addFormDataPart("auth_method", "1").addFormDataPart("account", "noticesender").addFormDataPart("password", "&cit3a@syt43SycaU").addFormDataPart("mail_to_1", accountMail).addFormDataPart("filter_1", "[[0,1,0],[0,1,0],[0]]").addFormDataPart("filter_2", "[[0,0,0],[0,0,0],[0]]").addFormDataPart("filter_3", "[[0,0,0],[0,0,0],[0]]").addFormDataPart("op", "set_mail").build();
        String fullurl = "http://127.0.0.1:13080/app/WorldCardTeam/backend/Penpower.php";
        LOG.debug("SetQSMNoticeMailSender url={}", (Object)fullurl);
        Request request = new Request.Builder().url(fullurl).method("POST", okhttp3.RequestBody.create(null, (byte[])new byte[0])).post((okhttp3.RequestBody)requestBody).build();
        LOG.debug("SetQSMNoticeMailSender b");
        try (Response response = httpClient.newCall(request).execute();){
            LOG.debug("SetQSMNoticeMailSender c");
            ResponseBody responseBody = response.body();
            String responseString = responseBody.toString();
            LOG.debug("SetQSMNoticeMailSender rsp={}", (Object)responseString);
        }
        catch (IOException e) {
            LOG.error("SetQSMNoticeMailSender Fail to execute http post SetQSMNoticeMailSender method.....e={}", (Throwable)e);
            return false;
        }
        return true;
    }

    void CreateSendMailJob(String email, String userName, LanguageCode languageCode) {
        try {
            JobIdentify jobIdentify = new JobIdentify("SEND_MAIL_TO_REGISTER" + UUIDGenerator.getRandomUUID(), SendMailJob.class);
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("SEND_EMAIL", email);
            dataMap.put("SEND_USERNAME", userName);
            dataMap.put("SEND_LANGUAGECODE", languageCode.toString());
            this.scheduleManager.startScheduleOnce(jobIdentify, null, dataMap);
        }
        catch (Exception ex) {
            LOG.error("Fail to CreateSendMailJob ", (Throwable)ex);
        }
    }

    void SendMailtoRegister(String email, String userName, LanguageCode languageCode) {
        try {
            JavaMailSenderImpl javaMailSenderImpl = (JavaMailSenderImpl)this.javaMailSender;
            try {
                javaMailSenderImpl.testConnection();
            }
            catch (Exception ex) {
                LOG.error("fail to test mail connection.....", (Throwable)ex);
            }
            SystemInitialMainInfoBuilder mailInfoBuilder = new SystemInitialMainInfoBuilder(userName, email, languageCode);
            MailInfo systemInitialMailInfo = mailInfoBuilder.createMailInfo();
            LOG.debug("Check mail info : \n {}", (Object)systemInitialMailInfo);
            MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, false, "UTF-8");
            helper.setTo(email);
            helper.setFrom("WorldCard Team Service<wctservice@mail.worldcardteam.com>");
            helper.setSubject(systemInitialMailInfo.getMailSubject());
            mimeMessage.setContent((Object)systemInitialMailInfo.getStringMailBody(), "text/html;charset=utf-8");
            MimeMessage dkimSignedMessage = GlobalUtils.getDkimSignMessage((MimeMessage)mimeMessage);
            this.javaMailSender.send(dkimSignedMessage);
        }
        catch (Exception ex) {
            LOG.error("Fail to send mail ", (Throwable)ex);
        }
    }

    @RequestMapping(value={"/GetLicense"}, method={RequestMethod.GET})
    @ApiOperation(value="Get Server license info", notes="Get server license info")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    public LicenseResponeResult GetLicense() {
        ServerType svrType = this.registryService.GetServerType();
        if (GlobalUtils.IsCloudServerType((ServerType)svrType)) {
            LOG.error("not supported servertype");
            throw new PermissionDeniedException("not supported servertype");
        }
        List companys = this.companyService.FindAllCompany();
        LicenseVo lv = null;
        if (companys.size() > 0) {
            lv = this.databaseSystemSettingService.GetLicense(((Company)companys.get(0)).getGuid());
        } else {
            lv = new LicenseVo();
            lv.setServerRegisterStatus(ServerRegisterStatus.NONE);
            lv.setSubscriptionStatus(SubscriptionStatus.NONE);
            lv.setLicenseMode(LicenseMode.NONE);
        }
        LicenseResponeResult response = new LicenseResponeResult("GetLicense success.", lv);
        return response;
    }

    private void CheckClientPermission(HttpServletRequest request) {
        String dispatchURL = "";
        ServerType svrType = this.registryService.GetServerType();
        if (svrType != ServerType.Google_Linux_Server_Cloud && svrType != ServerType.ASUSTOR_NAS_AUTOMATION) {
            LOG.error("not supported servertype");
            throw new PermissionDeniedException("not supported servertype");
        }
    }

    @RequestMapping(value={"/DeleteCompany"}, method={RequestMethod.POST})
    @ApiResponses(value={@ApiResponse(code=405, message="Server type not validate <BR>"), @ApiResponse(code=404, message="Resource item not found in system. <BR>")})
    public MessageResponseResult DeleteCompany(@RequestParam String serviceID, HttpServletRequest request) {
        ServerType svrType = this.registryService.GetServerType();
        if (svrType != ServerType.Google_Linux_Server_Cloud && svrType != ServerType.ASUSTOR_NAS_AUTOMATION) {
            LOG.error("not supported servertype");
            throw new PermissionDeniedException("not supported servertype");
        }
        String companyGuid = this.subscriptionService.getCompanyIDByServiceID(serviceID);
        this.accountService.deleteAccountbyCompany(companyGuid);
        this.companyService.DeleteCompany(companyGuid);
        MessageResponseResult response = new MessageResponseResult("Delete company success", companyGuid);
        return response;
    }

    @RequestMapping(value={"/GetAccounts"}, method={RequestMethod.GET})
    @ApiOperation(value="Get Subscription status", notes="Get Subscription status")
    public ListResponseResult<AccountInfoForDS> GetAccountList(HttpServletRequest request) {
        this.CheckClientPermission(request);
        List accounts = this.accountService.getAccountList();
        ListResponseResult response = new ListResponseResult("GetAccountList success.", accounts);
        return response;
    }

    @RequestMapping(value={"/GetTokens"}, method={RequestMethod.GET})
    @ApiOperation(value="Get Subscription status", notes="Get Subscription status")
    public ListResponseResult<String> GetTokenList(HttpServletRequest request) {
        this.CheckClientPermission(request);
        List tokens = this.tokenService.GetAllTokenGuids();
        ListResponseResult response = new ListResponseResult("GetTokenList success.", tokens);
        return response;
    }

    @RequestMapping(value={"/getAvailableCompanyCount"}, method={RequestMethod.GET})
    @ApiOperation(value="Get Subscription status", notes="Get Subscription status")
    public LongResponseResult getAvailableCompanyCount(HttpServletRequest request) {
        this.CheckClientPermission(request);
        Globalinfo maxCompanyCount = this.globalInfoService.getPropertiesByKey("MAX_COMPANY_COUNT");
        long maxCompanyCountLimit = 1L;
        maxCompanyCountLimit = maxCompanyCount != null ? Long.parseLong(maxCompanyCount.getConfigValue()) : 1L;
        long leftCount = maxCompanyCountLimit - (long)this.companyService.FindAllCompany().size();
        LongResponseResult response = new LongResponseResult("GetTokenList success.", Long.valueOf(leftCount));
        return response;
    }

    @RequestMapping(value={"/GetSubscriptionStatus"}, method={RequestMethod.GET})
    @ApiOperation(value="Get Subscription status", notes="Get Subscription status")
    public SubscriptionStatusResponeResult GetSubscriptionStatus() {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        SubscriptionStatus SS = this.subscriptionService.getSubScriptionStatus(currentLoginAccount.getCompanyGuid());
        LOG.debug("SubscriptionStatus ={}", (Object)SS);
        SubscriptionStatusResponeResult response = new SubscriptionStatusResponeResult("GetSubscriptionStatus success.", SS);
        return response;
    }

    @RequestMapping(value={"/GetRegisterStatus"}, method={RequestMethod.GET})
    @ApiOperation(value="GetRegisterstatus", notes="Get Register status")
    public ServerRegisterStatusResponseResult GetRegisterStatus() {
        List companys = this.companyService.FindAllCompany();
        ServerRegisterStatusResponseResult response = null;
        if (companys.size() > 0) {
            ServerRegisterStatus SRS = this.registryService.GetRegisterStatus(((Company)companys.get(0)).getGuid());
            LOG.debug("ServerRegisterStatusResponseResult ={}", (Object)SRS);
            response = new ServerRegisterStatusResponseResult("GetRegisterStatus success.", SRS);
        } else {
            response = new ServerRegisterStatusResponseResult("GetRegisterStatus success.", ServerRegisterStatus.NOT_ACTIVED);
        }
        return response;
    }

    @RequestMapping(value={"/IsServerNeedReActived"}, method={RequestMethod.GET})
    @ApiOperation(value="IsActived", notes="Check ther Worldcardteam service is IsActived")
    public BooleanResponseResult IsServerNeedReActived() {
        ServerRegisterStatus SRS;
        LOG.debug("IsServerNeedReActived 1");
        List companys = this.companyService.FindAllCompany();
        BooleanResponseResult response = null;
        response = companys.size() > 0 ? ((SRS = this.registryService.GetRegisterStatus(((Company)companys.get(0)).getGuid())) == ServerRegisterStatus.NEED_REINITIAL ? new BooleanResponseResult("the server is actived.", Boolean.valueOf(true)) : new BooleanResponseResult("the server is not actived", Boolean.valueOf(false))) : new BooleanResponseResult("the server is not actived", Boolean.valueOf(false));
        return response;
    }

    @RequestMapping(value={"/IsServerActived"}, method={RequestMethod.GET})
    @ApiOperation(value="IsActived", notes="Check ther Worldcardteam service is IsActived")
    public BooleanResponseResult IsServerActived() {
        ServerRegisterStatus SRS;
        List companys = this.companyService.FindAllCompany();
        BooleanResponseResult response = null;
        response = companys.size() > 0 ? ((SRS = this.registryService.GetRegisterStatus(((Company)companys.get(0)).getGuid())) == ServerRegisterStatus.ACTIVED || SRS == ServerRegisterStatus.TRIAL_USE ? new BooleanResponseResult("the server is actived.", Boolean.valueOf(true)) : new BooleanResponseResult("the server is not actived", Boolean.valueOf(false))) : new BooleanResponseResult("the server is not actived", Boolean.valueOf(false));
        return response;
    }

    @RequestMapping(value={"/GetDBBuildTime"}, method={RequestMethod.GET})
    @ApiOperation(value="GetDBBuildTime", notes="Get db build time ,when db is restore db build time is regenerate")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>")})
    public DateTimeResponseResult GetDBBuildTime() {
        Globalinfo DBBuildTimeInfo = this.globalInfoService.getPropertiesByKey("DB_BUILD_TIME");
        if (DBBuildTimeInfo != null) {
            DateTimeFormatter f = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS");
            DateTime dbBuildTimeFromDB = f.parseDateTime(DBBuildTimeInfo.getConfigValue());
            DateTimeResponseResult respone = new DateTimeResponseResult("get db build time for sync", dbBuildTimeFromDB);
            return respone;
        }
        throw new ItemNotFoundException("db build time not found in server, mayby bug");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/GetASUSDDNSName"}, method={RequestMethod.GET})
    @ApiOperation(value="Get DNS NAME", notes="Get DNS Setting in ASUSTOR NAS")
    public MessageResponseResult GetASUSDDNSName() {
        String domainName = "";
        File f = new File("/usr/builtin/etc/inadyn/inadyn.conf");
        if (!f.exists() || f.isDirectory()) {
            domainName = "";
            return new MessageResponseResult("succee to get ddndname", domainName);
        }
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream("/usr/builtin/etc/inadyn/inadyn.conf");
            prop.load(input);
            String DDNS = prop.getProperty("dyndns_server_name");
            String alias = prop.getProperty("alias");
            switch (DDNS) {
                case "api.asustor.com": {
                    domainName = alias + ".myasustor.com";
                    return new MessageResponseResult("succee to get ddndname", domainName);
                }
                default: {
                    domainName = alias;
                    return new MessageResponseResult("succee to get ddndname", domainName);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return new MessageResponseResult("succee to get ddndname", domainName);
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @RequestMapping(value={"/CheckServiceStatus"}, method={RequestMethod.GET})
    @ApiOperation(value="IsActived", notes="Check ther Worldcardteam service is IsActived")
    public ServiceStatusResponseResult CheckServiceStatus() {
        ServicePort servicePort;
        ServerSocket s;
        ServerType svrType = this.registryService.GetServerType();
        if (svrType.equals((Object)ServerType.ASUSTOR_NAS_AUTOMATION) || svrType.equals((Object)ServerType.Linux_Server_Cloud) || svrType.equals((Object)ServerType.ASUSTOR_NAS_Cloud) || svrType.equals((Object)ServerType.Google_Linux_Server_Cloud)) {
            ServiceStatus serviceStatus = new ServiceStatus();
            serviceStatus.setopenPortList(new ArrayList());
            ServicePort servicePort2 = new ServicePort();
            servicePort2.setopenPortNum(Integer.valueOf(80));
            servicePort2.setopenPortName("http");
            serviceStatus.getopenPortList().add(servicePort2);
            ServicePort servicePorthttps = new ServicePort();
            servicePorthttps.setopenPortNum(Integer.valueOf(443));
            servicePorthttps.setopenPortName("https");
            serviceStatus.getopenPortList().add(servicePorthttps);
            ContactImageTransferStatus status = ContactImageTransferStatus.TRANSFER_SUCCESS;
            serviceStatus.setContactImageTransferStatus(status);
            ServiceStatusResponseResult response = new ServiceStatusResponseResult("get status success.", serviceStatus);
            return response;
        }
        ServiceStatus serviceStatus = new ServiceStatus();
        serviceStatus.setopenPortList(new ArrayList());
        int httpPortNum = 0;
        int httpsPortNum = 0;
        try {
            httpPortNum = Integer.parseInt(this.httpPort);
        }
        catch (NumberFormatException e) {
            httpPortNum = 9080;
        }
        try {
            httpsPortNum = Integer.parseInt(this.httpsPort);
        }
        catch (NumberFormatException e) {
            httpsPortNum = 9443;
        }
        LOG.debug("http port ={} https port={}", (Object)httpPortNum, (Object)httpsPortNum);
        try {
            LOG.debug("http init");
            s = new ServerSocket(httpPortNum);
            LOG.debug("http new");
            s.close();
        }
        catch (Exception e) {
            servicePort = new ServicePort();
            servicePort.setopenPortNum(Integer.valueOf(httpPortNum));
            servicePort.setopenPortName("http");
            serviceStatus.getopenPortList().add(servicePort);
            LOG.debug("http port add");
        }
        try {
            LOG.debug("https init");
            s = new ServerSocket(9443);
            s.close();
        }
        catch (Exception e) {
            servicePort = new ServicePort();
            servicePort.setopenPortNum(Integer.valueOf(httpsPortNum));
            servicePort.setopenPortName("https");
            serviceStatus.getopenPortList().add(servicePort);
            LOG.debug("https port add");
        }
        SSLDetailInfo rSSLDetailInfo = SSLUtil.GetCurrentSSLFileDetail();
        serviceStatus.setSSLDetailInfo(rSSLDetailInfo);
        Globalinfo globalInfo = this.globalInfoService.getPropertiesByKey("CONTACT_IMAGE_TRANSFER_STATUS");
        ContactImageTransferStatus status = ContactImageTransferStatus.IN_PROGRESS;
        try {
            status = ContactImageTransferStatus.valueOf((String)globalInfo.getConfigValue());
            LOG.info("ContactImageTransferStauts: {}", (Object)status);
        }
        catch (Exception e) {
            status = ContactImageTransferStatus.IN_PROGRESS;
        }
        serviceStatus.setContactImageTransferStatus(status);
        ServiceStatusResponseResult response = new ServiceStatusResponseResult("get status success.", serviceStatus);
        return response;
    }

    @RequestMapping(value={"/IsAlive"}, method={RequestMethod.POST})
    @ApiOperation(value="IsAlive", notes="Check ther Worldcardteam service is alive")
    public BooleanResponseResult IsAlive() {
        BooleanResponseResult response = new BooleanResponseResult("the server is alive.", Boolean.valueOf(true));
        return response;
    }

    @RequestMapping(value={"/IsFine"}, method={RequestMethod.POST})
    @ApiOperation(value="IsFine", notes="Check ther Worldcardteam service is fine")
    @ApiResponses(value={@ApiResponse(code=423, message="The NAS memory is lessthan 4g")})
    public BooleanResponseResult IsFine() {
        if (this.registryService.GetServerType() != ServerType.SYNOLOGY_NAS && !HardwareIdUtil.systeminstalledMemoryLargerThan4G()) {
            throw new ResourceLockedException("MEMORY is less than 4g");
        }
        BooleanResponseResult response = new BooleanResponseResult("the server is fine.", Boolean.valueOf(true));
        return response;
    }

    @RequestMapping(value={"/IsReadOnfy"}, method={RequestMethod.POST})
    public BooleanResponseResult IsReadOnfy() {
        BooleanResponseResult response = new BooleanResponseResult("the server not readonly.", Boolean.valueOf(false));
        return response;
    }

    @ApiOperation(value="getBoss", notes="Get account boss.")
    @ApiResponses(value={@ApiResponse(code=401, message="Authentication failed.<BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/change_system_log_level"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult change_system_log_level(@RequestParam(required=true) LogLevel logLevel, @RequestParam(required=true) String securityKey) {
        if (securityKey.equals("worldcardteam")) {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            List loggers = lc.getLoggerList();
            Level newLevel = Level.toLevel((String)logLevel.toString());
            LOG.debug("Change log level to new level : [{}]", (Object)newLevel.levelStr);
            for (org.slf4j.Logger logger : loggers) {
                String logogerName = logger.getName();
                if (logogerName.indexOf("com.penpower") < 0) continue;
                ((Logger)logger).setLevel(newLevel);
            }
        } else {
            throw new AuthenticationFailedException("Log security key doesn't match.....");
        }
        MessageResponseResult response = new MessageResponseResult("Change the log level of system succeeded.", null);
        return response;
    }

    @RequestMapping(value={"/IsAdminCanViewAll"}, method={RequestMethod.GET})
    public BooleanResponseResult GetAdminCanViewAll() {
        boolean CanViewAll = true;
        LOG.debug("AdminCanViewAll={}", (Object)this.AdminCanViewAll);
        if (StringUtil.IsStringNullorEmpty((String)this.AdminCanViewAll)) {
            LOG.debug("AdminCanViewAll = TRUE");
            CanViewAll = true;
        } else if (StringUtil.Compare((String)this.AdminCanViewAll, (String)"FALSE") == 0) {
            LOG.debug("AdminCanViewAll = FALSE");
            CanViewAll = false;
        }
        return new BooleanResponseResult("get IsAdminCanViewAll success", Boolean.valueOf(CanViewAll));
    }

    @RequestMapping(value={"/RemoveServer"}, method={RequestMethod.POST})
    public MessageResponseResult removeServer(HttpServletRequest request) {
        if (this.isForPublicCloud(request)) {
            DatabaseConnectionInfo databaseConnectionInfo = this.createDatabaseConnectionInfo();
            PostgreSqlJdbcUtils restoreJdbcUtils = new PostgreSqlJdbcUtils(databaseConnectionInfo);
            Scheduler scheduler = this.scheduleManager.getScheduler();
            this.tokenService.cleanTokens();
            this.stopAndPauseAllRunningSchedule(scheduler);
            this.cleanElasticSearchIndex();
            LOG.debug("create a empty database from source migration sql......");
            restoreJdbcUtils.cleanDatabaseSessions(this.databaseName);
            restoreJdbcUtils.deleteDatabase(this.databaseName);
            restoreJdbcUtils.createDatabase(this.databaseName);
            restoreJdbcUtils.cleanDatabaseSessions(this.databaseName);
            this.flyway.migrate();
            LOG.debug("Reconfigure global info......");
            this.applicationConfig.reConfigureGlobalInfo();
            try {
                scheduler.resumeAll();
                boolean rebuildElasticsearchIndexJobRunning = this.scheduleManager.jobRunning(RebuildElasticsearchIndexJob.class);
                if (!rebuildElasticsearchIndexJobRunning) {
                    LOG.debug("re-schedule the RebuildElasticsearchIndexJob.");
                    JobIdentify jobIdentify = new JobIdentify("REBUILD_ELASTICSEARCH_INDEX" + UUIDGenerator.getRandomUUID(), RebuildElasticsearchIndexJob.class);
                    this.scheduleManager.startScheduleOnce(jobIdentify, null, new JobDataMap());
                }
            }
            catch (Exception ex) {
                LOG.info("resume failed:{}", (Object)ex.getMessage());
            }
            MessageResponseResult response = new MessageResponseResult("Remove server success.", null);
            return response;
        }
        throw new PermissionDeniedException("ServerType not allowed");
    }

    private boolean isForPublicCloud(HttpServletRequest request) {
        String remoteIp = NetworkUtil.getClientIp((HttpServletRequest)request);
        LOG.info("remoteIP:{}", (Object)remoteIp);
        boolean remoteIpSameWithServer = false;
        try {
            remoteIpSameWithServer = NetworkUtil.isRemoteIpAddressSameWithServerForGoogleCloud((String)remoteIp);
        }
        catch (Exception ex) {
            throw new SystemIoException(ex.getMessage());
        }
        if (!remoteIpSameWithServer) {
            throw new PermissionDeniedException("Permission denied");
        }
        ServerType serverType = this.registryService.GetServerType();
        return ServerType.ASUSTOR_NAS_AUTOMATION.equals((Object)serverType) || ServerType.ASUSTOR_NAS_Cloud.equals((Object)serverType) || ServerType.Linux_Server_Cloud.equals((Object)serverType) || ServerType.Google_Linux_Server_Cloud.equals((Object)serverType);
    }

    @RequestMapping(value={"/pause_all_scheduler"}, method={RequestMethod.POST})
    public MessageResponseResult pauseAllScheduler(HttpServletRequest request) {
        if (this.isForPublicCloud(request)) {
            Scheduler scheduler = this.scheduleManager.getScheduler();
            this.tokenService.cleanTokens();
            this.stopAndPauseAllRunningSchedule(scheduler);
            this.cleanElasticSearchIndex();
            MessageResponseResult response = new MessageResponseResult("pause_all_scheduler success.", null);
            return response;
        }
        throw new PermissionDeniedException("ServerType not allowed");
    }

    @RequestMapping(value={"/resume_all_scheduler"}, method={RequestMethod.POST})
    public MessageResponseResult resumeAllScheduler(HttpServletRequest request) throws Exception {
        if (this.isForPublicCloud(request)) {
            Scheduler scheduler = this.scheduleManager.getScheduler();
            scheduler.resumeAll();
            boolean rebuildElasticsearchIndexJobRunning = this.scheduleManager.jobRunning(RebuildElasticsearchIndexJob.class);
            if (!rebuildElasticsearchIndexJobRunning) {
                LOG.debug("re-schedule the RebuildElasticsearchIndexJob.");
                JobIdentify jobIdentify = new JobIdentify("REBUILD_ELASTICSEARCH_INDEX" + UUIDGenerator.getRandomUUID(), RebuildElasticsearchIndexJob.class);
                this.scheduleManager.startScheduleOnce(jobIdentify, null, new JobDataMap());
            }
            MessageResponseResult response = new MessageResponseResult("resume_all_scheduler success.", null);
            return response;
        }
        throw new PermissionDeniedException("ServerType not allowed");
    }

    private DatabaseConnectionInfo createDatabaseConnectionInfo() {
        String rootUrlFormat = "%s%s:%s/";
        String serverIpAddress = this.env.getProperty("dataSource.nas.ip");
        String serverPort = this.env.getProperty("dataSource.nas.port");
        String dbUserName = this.env.getProperty("dataSource.nas.username");
        String dbPassword = this.env.getProperty("dataSource.nas.password");
        ServerType serverType = this.registryService.GetServerType();
        if (serverType.equals((Object)ServerType.Linux_Server_Cloud)) {
            serverIpAddress = "10.10.15.99";
        }
        DatabaseConnectionInfo databaseConnectionInfo = new DatabaseConnectionInfo(rootUrlFormat, serverIpAddress, serverPort, dbUserName, dbPassword);
        return databaseConnectionInfo;
    }

    private void stopAndPauseAllRunningSchedule(Scheduler scheduler) {
        LOG.debug("Stop all running schedule and shutdown schedule......");
        try {
            List executingJobs = scheduler.getCurrentlyExecutingJobs();
            for (JobExecutionContext jobExecutionContext : executingJobs) {
                JobDetail executingJobDetai = jobExecutionContext.getJobDetail();
                JobKey key = executingJobDetai.getKey();
                scheduler.interrupt(key);
            }
            LOG.debug("Pause all schedule .....");
            scheduler.pauseAll();
        }
        catch (SchedulerException e) {
            throw new DatabaseUtilsRuntimeException("Fail to interrupt current running jobs.....", (Throwable)e);
        }
    }

    private void cleanElasticSearchIndex() {
        try {
            LOG.debug("Try to delete elasticsearch index");
            this.elasticSearchService.removeAllIndex();
        }
        catch (Exception ex) {
            LOG.debug("ElasticsearchError", (Throwable)ex);
            LOG.debug("Do not handle exception for elasticsearch removeindex job !!!");
        }
    }
}

