/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.ContactProfile;
import com.penpower.worldcard.team.dto.ContactStatusForAccountDto;
import com.penpower.worldcard.team.enums.ListSetBehavior;
import com.penpower.worldcard.team.enums.ShareItem;
import com.penpower.worldcard.team.enums.TempStoredDataType;
import com.penpower.worldcard.team.enums.UpdateAction;
import com.penpower.worldcard.team.enums.UpdateComponent;
import com.penpower.worldcard.team.exception.ExclusiveException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.ResourceLockedException;
import com.penpower.worldcard.team.exception.RetryException;
import com.penpower.worldcard.team.scheduler.JobIdentify;
import com.penpower.worldcard.team.scheduler.ScheduleManager;
import com.penpower.worldcard.team.scheduler.job.SendBeSharedNoticeToAccountJob;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.AccountShareTargetService;
import com.penpower.worldcard.team.service.CategoryService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.ContactPublicService;
import com.penpower.worldcard.team.service.ContactService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.SyncService;
import com.penpower.worldcard.team.web.api.vo.ContactCheckResultVo;
import com.penpower.worldcard.team.web.api.vo.ContactCheckVo;
import com.penpower.worldcard.team.web.api.vo.ContactCreationVo;
import com.penpower.worldcard.team.web.api.vo.ContactCreationWithImageVo;
import com.penpower.worldcard.team.web.api.vo.ContactInfoExVo;
import com.penpower.worldcard.team.web.api.vo.ContactUpdateCheckVo;
import com.penpower.worldcard.team.web.api.vo.ContactUpdateVo;
import com.penpower.worldcard.team.web.api.vo.SyncInfo;
import com.penpower.worldcard.team.web.api.vo.SyncUpdateInfoVo;
import com.penpower.worldcard.team.web.api.vo.response.BasicResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.BooleanResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.ContactProfileResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.DateTimeResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.StartSyncResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.UpdateActionResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.UpdateCheckContactResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.quartz.JobDataMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/Sync"}, produces={"application/json;charset=UTF-8"}, method={RequestMethod.POST})
@Api(tags={"Sync"})
@PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE)")
public class SyncController {
    private static final Logger LOG = LoggerFactory.getLogger(SyncController.class);
    @Autowired
    private AccountService accountService;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private SyncService syncService;
    @Autowired
    private AccountShareTargetService accountShareTargetService;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private ScheduleManager scheduleManager;
    @Autowired
    ContactPrivateService contactPrivateService;
    @Autowired
    GlobalInfoService globalInfoService;
    @Autowired
    private ContactService contactService;
    @Autowired
    private ContactPublicService contactPublicService;

    @ApiOperation(value="Sync", notes="\u540c\u6b65\u7684\u7b2c\u4e00\u500b\u6b65\u9a5f,\u85c9\u7531\u6b64api\u4f86\u6bd4\u5c0d\u9808\u9032\u884c\u7570\u52d5\u7684\u7d50\u679c")
    @ApiResponses(value={@ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=432, message="Background is busy for purge."), @ApiResponse(code=423, message="Account is inheriting,sync must be cancel")})
    @RequestMapping(value={"/StartSync"}, method={RequestMethod.POST})
    public StartSyncResponseResult StartSync(@RequestBody SyncInfo syncInfo) {
        LOG.debug("before start sync home" + System.getProperty("user.home"));
        if (this.contactService.getDeeplyDeleteContactJobStatus()) {
            throw new ExclusiveException("Background is busy for purge");
        }
        AccountInfo acntinfo = this.accountService.getAccountInfo(syncInfo.getAccountGuid(), null);
        if (this.accountService.verifyAccountIsInheritor(syncInfo.getAccountGuid())) {
            LOG.debug("account in INHERITING");
            throw new ResourceLockedException("Can't sync data when account is INHERITING");
        }
        SyncUpdateInfoVo syncUpdateInfovo = this.syncService.StartSync(syncInfo);
        LOG.debug("after startsync service");
        return new StartSyncResponseResult("StartSync success", syncUpdateInfovo);
    }

    @RequestMapping(value={"/IsNeedFullSync"}, method={RequestMethod.POST})
    public BooleanResponseResult IsNeedFullSync(@RequestParam @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS") DateTime ContactLastRecTime) {
        LOG.debug("IsNeedFullSync datetime={}", (Object)ContactLastRecTime);
        AccountInfo accountInfo = SecurityUtils.getCurrentLoginUser();
        DateTime lastDeletedContactTime = this.accountPrivateSettingService.getLastDeeplyDeletedContactTime(accountInfo.getGuid());
        LOG.debug("IsNeedFullSync lastDeletedContactTime={}", (Object)lastDeletedContactTime);
        BooleanResponseResult respone = null;
        if (ContactLastRecTime == null || ContactLastRecTime.getYear() <= 1970) {
            respone = new BooleanResponseResult("never sync ,need fullsync", Boolean.valueOf(true));
            LOG.debug("never sync ,need fullsync");
        } else if (lastDeletedContactTime == null || lastDeletedContactTime.getYear() <= 1970) {
            respone = new BooleanResponseResult("never delete ,not need fullsync", Boolean.valueOf(false));
            LOG.debug("never delete ,not need fullsync");
        } else if (ContactLastRecTime.isAfter((ReadableInstant)lastDeletedContactTime)) {
            respone = new BooleanResponseResult("contactlastrectime is newest ,not need fullsync", Boolean.valueOf(false));
            LOG.debug("contactlastrectime is newest ,not need fullsync");
        } else {
            respone = new BooleanResponseResult("contactlastrectime is over last delete time ,need fullsync", Boolean.valueOf(true));
            LOG.debug("contactlastrectime is over last delete time ,need fullsync");
        }
        return respone;
    }

    @RequestMapping(value={"/SyncDone"}, method={RequestMethod.POST})
    public MessageResponseResult SyncDone() {
        LOG.debug("sYNCDONE");
        String strMessage = "[test]";
        LOG.debug("sYNCDONE2");
        return new MessageResponseResult("SyncDone success", "Finish");
    }

    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=432, message="Background is busy for purge.")})
    @RequestMapping(value={"/Contact/Get"}, method={RequestMethod.POST})
    public BasicResponseResult<ContactInfoExVo, Object> getContactByGuid(@RequestParam(required=true) String contactGuid) {
        LOG.debug("getContact contactid={}", (Object)contactGuid);
        if (this.contactService.getDeeplyDeleteContactJobStatus()) {
            throw new ExclusiveException("Background is busy for purge");
        }
        this.contactPrivateService.verifyContactGuids(Arrays.asList(contactGuid));
        LOG.debug("getContact  1");
        AccountInfo loginAccountInfo = SecurityUtils.getCurrentLoginUser();
        ContactInfoExVo contactInfoVo = this.contactPrivateService.getContactInfoExByGuid(contactGuid, loginAccountInfo.getGuid());
        if (contactInfoVo == null) {
            throw new ItemNotFoundException("Contact not found");
        }
        LOG.debug("getContact  2");
        return new BasicResponseResult("Get contact by guid success.", (Object)contactInfoVo);
    }

    @ApiOperation(value="", notes="Add contact. Used for manually creating contact.")
    @ApiResponses(value={@ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=423, message="Account is inheriting,sync must be cancel"), @ApiResponse(code=425, message="Max count limit of contact in private is reached."), @ApiResponse(code=426, message="Max count limit of contact owning is reached."), @ApiResponse(code=427, message="Max count limit of contact in DB is reached."), @ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=432, message="Background is busy for purge."), @ApiResponse(code=443, message="Thread is busy please try again"), @ApiResponse(code=490, message="Specified guid has been used.<BR>")})
    @RequestMapping(value={"/Contact/Create"}, method={RequestMethod.POST})
    public ContactProfileResponseResult createContact(@RequestBody @Valid ContactCreationWithImageVo vo) {
        if (this.contactService.getDeeplyDeleteContactJobStatus()) {
            throw new ExclusiveException("Background is busy for purge");
        }
        ContactCreationWithImageVo contactCreationVo = vo;
        LOG.debug("[createContact] contactCreationVo: {}", (Object)contactCreationVo);
        String creatorAccountGuid = vo.getCreatorAccountGuid();
        this.accountService.verifyAccount(creatorAccountGuid, null);
        if (this.accountService.verifyAccountIsInheritor(creatorAccountGuid)) {
            LOG.debug("account in INHERITING");
            throw new ResourceLockedException("Can't sync data when account is INHERITING");
        }
        DateTime passedCreatedTime = new DateTime();
        String strContactID = "";
        try {
            try {
                AccountInfo accountInfo = SecurityUtils.getCurrentLoginUser();
                strContactID = this.contactPrivateService.createContact((ContactCreationVo)contactCreationVo, vo.getFrontImageFileGuid(), vo.getRearImageFileGuid(), vo.getLogoImageFileGuid(), accountInfo.getCompanyGuid());
                passedCreatedTime = this.contactPrivateService.getContactModifyTimeByGuid(strContactID);
            }
            catch (OptimisticLockException ee) {
                LOG.error("service lock please try again");
                throw new RetryException("service lock please try again");
            }
            this.autoShareAndNotifyToAccountsWhileCreation(creatorAccountGuid, strContactID, passedCreatedTime);
            LOG.debug("[createContact] 3");
            ContactProfile contactProfile = this.contactPrivateService.getContactProfile(strContactID, vo.getCreatorAccountGuid());
            LOG.debug("[createContact] 4 contactProfile={}", (Object)contactProfile);
            return new ContactProfileResponseResult("Create contact success.", contactProfile);
        }
        catch (PersistenceException e) {
            LOG.error("[updateContact fail]:{}", (Throwable)e);
            if (GlobalUtils.isExceptionCategoryHasContactDuplicate((Exception)((Object)e))) {
                LOG.error("throw new RetryException()");
                throw new RetryException("service lock please try again");
            }
            boolean bExist = this.syncService.CheckContactExist(contactCreationVo.getClientCreatedContactGuid(), contactCreationVo.getCreatorAccountGuid());
            LOG.info("createContact] exception e={}", (Throwable)e);
            if (bExist) {
                this.autoShareAndNotifyToAccountsWhileCreation(creatorAccountGuid, strContactID, passedCreatedTime);
                LOG.debug("[createContact] 3 a");
                ContactProfile contactProfile = this.contactPrivateService.getContactProfile(strContactID, vo.getCreatorAccountGuid());
                LOG.debug("[createContact] 4 a contactProfile={}", (Object)contactProfile);
                return new ContactProfileResponseResult("Create contact success.", contactProfile);
            }
            throw new ExclusiveException("contact is creating..");
        }
    }

    private void autoShareAndNotifyToAccountsWhileCreation(String shareAccountGuid, String contactGuid, DateTime passedTime) {
        List otherBesharedAccountGuids = this.contactPublicService.getAccountGuidsSharedByContact(contactGuid);
        this.setupContactShareNoticeJobToAccounts(shareAccountGuid, otherBesharedAccountGuids, contactGuid);
    }

    private List<String> autoShareContactBySettings(String shareAccountGuid, String contactGuid, DateTime passedTime) {
        boolean autoShare = this.accountPrivateSettingService.getAutoShareSetting(shareAccountGuid);
        if (autoShare) {
            List shareTargets = this.accountShareTargetService.getShareTargetsByShareItem(shareAccountGuid, ShareItem.CONTACT);
            List<String> besharedAccountGuids = shareTargets.stream().map(a -> a.getAccountGuid()).collect(Collectors.toList());
            this.contactPublicService.shareContactToAccounts(contactGuid, besharedAccountGuids, ListSetBehavior.ADD, passedTime);
            return besharedAccountGuids;
        }
        return new ArrayList<String>();
    }

    private void setupContactShareNoticeJobToAccounts(String shareAccountGuid, List<String> besharedAccountGuids, String contactGuid) {
        for (String accountGuid : besharedAccountGuids) {
            try {
                this.accountShareTargetService.addItemIntoShareNotice(shareAccountGuid, accountGuid, contactGuid, TempStoredDataType.CONTACT);
                JobIdentify jobIdentify = new JobIdentify("SEND_SHARE_NOTICE" + shareAccountGuid + accountGuid, SendBeSharedNoticeToAccountJob.class);
                this.scheduleManager.deleteSchedule(jobIdentify);
                DateTime launchTime = new DateTime().plusMinutes(1);
                JobDataMap dataMap = new JobDataMap();
                dataMap.put("SHARE_ACCOUNT_GUID", shareAccountGuid);
                dataMap.put("BESHARED_ACCOUNT_GUID", accountGuid);
                this.scheduleManager.startScheduleOnce(jobIdentify, launchTime.toDate(), dataMap);
            }
            catch (Exception e) {
                LOG.error("setupContactShareNoticeJobToAccounts fail.(share account:{},beshared account:{})", (Object)shareAccountGuid, (Object)accountGuid);
                LOG.error("{}", (Throwable)e);
            }
        }
    }

    @ApiOperation(value="Check contact Is exist", notes="\u5728\u65b0\u589e\u81f3server\u524d\u5148\u6aa2\u67e5\u9023\u7d61\u4eba\u662f\u5426\u5b58\u5728")
    @ApiResponses(value={@ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=432, message="Background is busy for purge.")})
    @RequestMapping(value={"/Contact/IsExist"})
    public BooleanResponseResult CheckContactExist(@RequestParam(required=true) String contactGuid, @RequestParam(required=true) String AccountID) {
        boolean bExist = this.syncService.CheckContactExist(contactGuid, AccountID);
        if (this.contactService.getDeeplyDeleteContactJobStatus()) {
            throw new ExclusiveException("Background is busy for purge");
        }
        LOG.debug("IsExist contact guid={} return ={}", (Object)contactGuid, (Object)bExist);
        return new BooleanResponseResult("CheckContactExist success.", Boolean.valueOf(bExist));
    }

    @ApiOperation(value="Check Contact Status", notes="\u5728Statsync \u5f8c\u56de\u50b3UnCheck\u6642\u518d\u547c\u53eb\u8a72func\u5f97\u5230\u771f\u6b63\u7684update action")
    @ApiResponses(value={@ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=432, message="Background is busy for purge.")})
    @RequestMapping(value={"/Contact/CheckStatus"})
    public UpdateActionResponseResult CheckContactStatus(@RequestBody ContactCheckVo contactCheckVo) {
        LOG.debug("CheckContactStatus contact guid={}", (Object)contactCheckVo.getContactID());
        if (this.contactService.getDeeplyDeleteContactJobStatus()) {
            throw new ExclusiveException("Background is busy for purge");
        }
        UpdateAction updateAction = this.syncService.CheckContactStatus(contactCheckVo.getContactID(), contactCheckVo.getAccountID(), contactCheckVo.getModifyTime(), contactCheckVo.getActionType());
        LOG.debug("CheckContactStatus return ={}", (Object)updateAction);
        return new UpdateActionResponseResult("CheckContactStatus success.", updateAction);
    }

    @ApiOperation(value="update contact ", notes="\u5728Statsync \u5f8c\u56de\u50b3UnCheck\u6642\u518d\u547c\u53eb\u8a72func\u5f97\u5230\u771f\u6b63\u7684update action")
    @ApiResponses(value={@ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=432, message="Background is busy for purge.")})
    @RequestMapping(value={"/Contact/UpdateCheck"})
    public UpdateCheckContactResponseResult UpdateCheckContact(@RequestBody ContactUpdateCheckVo contactUpdateCheckVo) {
        if (this.contactService.getDeeplyDeleteContactJobStatus()) {
            throw new ExclusiveException("Background is busy for purge");
        }
        LOG.debug("UpdateCheck contact contactUpdateCheckVo={}", (Object)contactUpdateCheckVo);
        ContactCheckResultVo contactCheckResultVo = this.syncService.CheckContactUpdateStats(contactUpdateCheckVo);
        LOG.debug("UpdateCheck contact  return ={}", (Object)contactCheckResultVo);
        return new UpdateCheckContactResponseResult("get ContactUpdateCheckResult success.", contactCheckResultVo);
    }

    @ApiOperation(value="Update Contact in sync", notes="Add contact. Used for manually creating contact.")
    @ApiResponses(value={@ApiResponse(code=425, message="Max count limit of contact in private is reached."), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=462, message="the Record in server is newer than client,and update fail"), @ApiResponse(code=423, message="Account is inheriting,sync must be cancel"), @ApiResponse(code=432, message="Background is busy for purge."), @ApiResponse(code=443, message="Thread is busy please try again"), @ApiResponse(code=404, message="Resource item not found in system. <BR>")})
    @RequestMapping(value={"/Contact/Update"})
    public ContactProfileResponseResult updateContact(@RequestBody @Valid ContactUpdateVo vo) {
        LOG.debug("/Contact/Update ContactUpdateVo={}", (Object)vo);
        if (this.contactService.getDeeplyDeleteContactJobStatus()) {
            throw new ExclusiveException("Background is busy for purge");
        }
        AccountInfo accountInfo = SecurityUtils.getCurrentLoginUser();
        if (this.accountService.verifyAccountIsInheritor(accountInfo.getGuid())) {
            LOG.debug("account in INHERITING");
            throw new ResourceLockedException("Can't sync data when account is INHERITING");
        }
        this.contactPrivateService.verifyModifyTime(vo.getContactGuid(), vo.getsyncModifyTime(), vo.getCategoryOwnerAccountGuid());
        this.contactPrivateService.verifyContactGuids(Arrays.asList(vo.getContactGuid()));
        LOG.debug("uPDATECONTACT 2");
        List<UpdateComponent> updateCompoments = Arrays.asList(vo.getUpdateComponents());
        boolean isAddShare = updateCompoments.contains(UpdateComponent.UC_SHARE_ACCOUNT);
        List originSharedAccountGuids = new ArrayList();
        if (isAddShare) {
            originSharedAccountGuids = this.contactPublicService.getAccountGuidsSharedByContact(vo.getContactGuid());
        }
        LOG.debug("uPDATECONTACT 5");
        AccountInfo myAccount = SecurityUtils.getCurrentLoginUser();
        String contactEditorGuid = myAccount.getGuid();
        try {
            this.contactPrivateService.updateContact(vo, contactEditorGuid);
        }
        catch (OptimisticLockException | ObjectOptimisticLockingFailureException ee) {
            LOG.error("({}) service lock please try again", (Object)vo.getContactGuid());
            throw new RetryException("service lock please try again");
        }
        catch (PersistenceException e) {
            LOG.error("({}) PersistenceException", (Object)vo.getContactGuid());
            LOG.error("[updateContact fail]:{}", (Throwable)e);
            if (GlobalUtils.isExceptionCategoryHasContactDuplicate((Exception)((Object)e))) {
                LOG.error("throw new RetryException()");
                throw new RetryException("service lock please try again");
            }
            throw e;
        }
        LOG.debug("uPDATECONTACT 6");
        if (isAddShare) {
            List besharedAccountGuids = this.contactPublicService.getAccountGuidsSharedByContact(vo.getContactGuid());
            besharedAccountGuids.removeAll(originSharedAccountGuids);
            if (!CollectionUtils.isEmpty((Collection)besharedAccountGuids)) {
                this.setupContactShareNoticeJobToAccounts(contactEditorGuid, besharedAccountGuids, vo.getContactGuid());
            }
        }
        LOG.debug("uPDATECONTACT 7");
        ContactProfile contactProfile = this.contactPrivateService.getContactProfile(vo.getContactGuid(), vo.getCategoryOwnerAccountGuid());
        LOG.debug("[CategorySha1Issue] ({}) contactProfile.getCategorySha1():{}", (Object)vo.getContactGuid(), (Object)contactProfile.getCategorySha1());
        LOG.debug("uPDATECONTACT 8");
        return new ContactProfileResponseResult("Update contact success.", contactProfile);
    }

    @RequestMapping(value={"Contact/Delete"}, method={RequestMethod.POST})
    @ApiResponses(value={@ApiResponse(code=423, message="Account is inheriting,sync must be cancel"), @ApiResponse(code=443, message="Thread is busy please try again"), @ApiResponse(code=432, message="Background is busy for purge.")})
    public DateTimeResponseResult deleteContact(@RequestParam String contactGuid, @RequestParam String accountGuid) {
        if (this.contactService.getDeeplyDeleteContactJobStatus()) {
            throw new ExclusiveException("Background is busy for purge");
        }
        LOG.debug("/Contact/Delete contactGuid={} accountGuid ={}", (Object)contactGuid, (Object)accountGuid);
        AccountInfo accountInfo = SecurityUtils.getCurrentLoginUser();
        if (this.accountService.verifyAccountIsInheritor(accountInfo.getGuid())) {
            LOG.debug("account in INHERITING");
            throw new ResourceLockedException("Can't sync data when account is INHERITING");
        }
        this.accountService.verifyAccount(accountGuid, null);
        try {
            this.contactPrivateService.updateCategoriesOfContact(contactGuid, null, accountGuid, ListSetBehavior.REMOVE_ALL, null);
        }
        catch (OptimisticLockException ee) {
            LOG.error("service lock please try again");
            throw new RetryException("service lock please try again");
        }
        ContactStatusForAccountDto contactStatusDto = this.contactPrivateService.getContactStatusForAccount(contactGuid, accountGuid);
        return new DateTimeResponseResult("Delete contact success", contactStatusDto.getStatusUpdateTime());
    }
}

