/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.config.property.ApplicationProperties;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.enums.LicenseMode;
import com.penpower.worldcard.team.exception.MethodNotAllowedException;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.SubscriptionService;
import com.penpower.worldcard.team.web.api.vo.LicenseVo;
import com.penpower.worldcard.team.web.api.vo.SubscriptionInfoVo;
import com.penpower.worldcard.team.web.api.vo.response.BooleanResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.LicenseResponeResult;
import com.penpower.worldcard.team.web.api.vo.response.LongResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.SubscriptionInfoVoResponseResult;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/Subscribe"})
public class SubscriptionController {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionController.class);
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private RegistryService registryService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private ApplicationProperties applicationProperties;

    @ApiOperation(value="Subscribe", notes="Get subscription info")
    @ApiResponses(value={@ApiResponse(code=405, message="license code is invalid <BR>")})
    @RequestMapping(value={"/GetSubscriptionInfo"}, method={RequestMethod.POST})
    public SubscriptionInfoVoResponseResult GetSubscriptionInfo() {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        LicenseMode lm = this.subscriptionService.getLicenseMode(currentLoginAccount.getCompanyGuid());
        if (lm != LicenseMode.SUBSCRIPTION) {
            throw new MethodNotAllowedException("getAllRegistry can't call at BUYOUT mode");
        }
        SubscriptionInfoVo vo = this.subscriptionService.getSubscriptionInfo(currentLoginAccount.getCompanyGuid());
        SubscriptionInfoVoResponseResult response = new SubscriptionInfoVoResponseResult("GetSubscriptionInfo success", vo);
        return response;
    }

    @RequestMapping(value={"/GetLicense"}, method={RequestMethod.GET})
    @ApiOperation(value="Get Server license info", notes="Get server license info")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    public LicenseResponeResult GetLicense() {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        LicenseVo lv = this.subscriptionService.GetLicense(currentLoginAccount.getCompanyGuid());
        LicenseResponeResult response = new LicenseResponeResult("GetLicense success.", lv);
        return response;
    }

    @ApiOperation(value="subscription by redeemkey", notes="subscription by redeemkey")
    @ApiResponses(value={@ApiResponse(code=405, message="license code is invalid <BR>"), @ApiResponse(code=404, message="Can't connect to register server. <BR>")})
    @RequestMapping(value={"/SubscribByRedeem"}, method={RequestMethod.POST})
    public MessageResponseResult SubscribByRedeem(@RequestParam(required=true) String ReedeemCode) {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        LicenseMode lm = this.subscriptionService.getLicenseMode(currentLoginAccount.getCompanyGuid());
        if (lm != LicenseMode.SUBSCRIPTION) {
            throw new MethodNotAllowedException("SubscribByRedeem can't call at buyout mode");
        }
        this.subscriptionService.SubscribByRedeem(ReedeemCode, currentLoginAccount.getCompanyGuid());
        this.subscriptionService.DownloadSubscriptionInfo(currentLoginAccount.getCompanyGuid());
        MessageResponseResult response = new MessageResponseResult("SubscribByRedeem", "ss");
        return response;
    }

    @ApiOperation(value="refresh Subscribe", notes="triager wct server to get subscriptionn info from PRS")
    @RequestMapping(value={"/RefreshSubscriptionInfoToServer"}, method={RequestMethod.POST})
    @ApiResponses(value={@ApiResponse(code=404, message="Can't connect to register server. <BR>"), @ApiResponse(code=405, message="license code is invalid <BR>")})
    public BooleanResponseResult RefreshSubscriptionInfoToServer(@RequestParam(required=true) boolean IsNeedToInvalidateToken) {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        LicenseMode lm = this.subscriptionService.getLicenseMode(currentLoginAccount.getCompanyGuid());
        if (lm != LicenseMode.SUBSCRIPTION) {
            throw new MethodNotAllowedException("getAllRegistry can't call at BUYOUT mode");
        }
        this.subscriptionService.DownloadSubscriptionInfo(currentLoginAccount.getCompanyGuid());
        this.subscriptionService.CheckLicenseValidate(currentLoginAccount.getCompanyGuid(), IsNeedToInvalidateToken, null, true);
        BooleanResponseResult response = new BooleanResponseResult("RefreshSubscriptionInfoToServer", Boolean.valueOf(true));
        return response;
    }

    @ApiOperation(value="Get Subscription url", notes="get Subscription url and open it to subscribe")
    @RequestMapping(value={"/getSubscriptionURL"}, method={RequestMethod.POST})
    @ApiResponses(value={@ApiResponse(code=404, message="Can't connect to register server. <BR>"), @ApiResponse(code=405, message="license code is invalid <BR>"), @ApiResponse(code=443, message="Thread is busy please try again")})
    public MessageResponseResult getSubscriptionURL() {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        LicenseMode lm = this.subscriptionService.getLicenseMode(currentLoginAccount.getCompanyGuid());
        if (lm != LicenseMode.SUBSCRIPTION) {
            throw new MethodNotAllowedException("getAllRegistry can't call at BUYOUT mode");
        }
        String subURL = this.subscriptionService.getSubscriptionURL(currentLoginAccount.getGuid(), currentLoginAccount.getCompanyGuid());
        if (!StringUtil.IsStringNullorEmpty((String)subURL)) {
            MessageResponseResult respone = new MessageResponseResult("getSubscriptionURL success", subURL);
            return respone;
        }
        MessageResponseResult respone = new MessageResponseResult("getSubscriptionURL fail", "");
        return respone;
    }

    @RequestMapping(value={"/getAccountLimit"}, method={RequestMethod.GET})
    @ApiOperation(value="Get Registries limit", notes="Get the maxium registry count")
    @ApiResponses(value={@ApiResponse(code=405, message="license code is invalid <BR>")})
    public LongResponseResult getAccountLimit() {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        LicenseMode lm = this.subscriptionService.getLicenseMode(currentLoginAccount.getCompanyGuid());
        if (lm != LicenseMode.SUBSCRIPTION) {
            throw new MethodNotAllowedException("getAllRegistry can't call at BUYOUT mode");
        }
        long accountLimit = this.subscriptionService.getAccountLimit(currentLoginAccount.getCompanyGuid());
        LongResponseResult response = new LongResponseResult("Get all accounts information succeeded.", Long.valueOf(accountLimit));
        LOG.debug("getAccountLimit 4 ");
        return response;
    }
}

