/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.AuthorizedInfoDto;
import com.penpower.worldcard.team.dto.StorageInfoDto;
import com.penpower.worldcard.team.service.StatisticsService;
import com.penpower.worldcard.team.web.api.vo.response.AuthorizedInfoResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.LongResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.StorageInfoResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Controller
@RestController
@CrossOrigin
@RequestMapping(value={"/api/statistics"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"statistics_info"}, description="")
@PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE) and (hasAuthority('ADMIN'))")
public class StatisticsInformationController {
    @Autowired
    private StatisticsService statisticsService;

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_authorized_Info"}, method={RequestMethod.POST})
    public AuthorizedInfoResponseResult get_authorized_Info() {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        AuthorizedInfoDto authorizedInfoDto = this.statisticsService.getAuthroizedInfo(currentLoginAccount.getCompanyGuid());
        AuthorizedInfoResponseResult response = new AuthorizedInfoResponseResult(String.format("Get authorized information succeeded.", new Object[0]), authorizedInfoDto);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_contact_total_count"}, method={RequestMethod.POST})
    public LongResponseResult get_contact_total_count() {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        long totalCount = this.statisticsService.getContactTotalCount(currentLoginAccount.getCompanyGuid());
        LongResponseResult response = new LongResponseResult(String.format("Get contact total count succeeded.", new Object[0]), Long.valueOf(totalCount));
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_task_total_count"}, method={RequestMethod.POST})
    public LongResponseResult get_task_total_count() {
        long totalCount = this.statisticsService.getTaskTotalCount();
        LongResponseResult response = new LongResponseResult(String.format("Get contact total count succeeded.", new Object[0]), Long.valueOf(totalCount));
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_activity_total_count"}, method={RequestMethod.POST})
    public LongResponseResult get_activity_total_count() {
        long totalCount = this.statisticsService.getActivityTotalCount();
        LongResponseResult response = new LongResponseResult(String.format("Get activity total count succeeded.", new Object[0]), Long.valueOf(totalCount));
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_storage_info"}, method={RequestMethod.POST})
    public StorageInfoResponseResult get_storage_info() {
        StorageInfoDto storageInfo = this.statisticsService.getStorageInfo();
        StorageInfoResponseResult response = new StorageInfoResponseResult(String.format("Get storage info succeeded.", new Object[0]), storageInfo);
        return response;
    }
}

