/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.FileSystemUtil;
import com.penpower.worldcard.team.Utils.HardwareIdUtil;
import com.penpower.worldcard.team.backup.BackupControlFile;
import com.penpower.worldcard.team.backup.BackupFileManager;
import com.penpower.worldcard.team.config.property.ApplicationProperties;
import com.penpower.worldcard.team.dto.RestoreStoragInfos;
import com.penpower.worldcard.team.dto.RestoreStorageInfosLess;
import com.penpower.worldcard.team.enums.BackupRunningStaus;
import com.penpower.worldcard.team.enums.BackupStatus;
import com.penpower.worldcard.team.enums.RestoreJobRunningStaus;
import com.penpower.worldcard.team.exception.BackupFileVersionNewerThanServerException;
import com.penpower.worldcard.team.exception.BackupJobAlreadyRunningException;
import com.penpower.worldcard.team.exception.DatabaseUtilsRuntimeException;
import com.penpower.worldcard.team.exception.InvalidBackupPathException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.NotEnoughSpaceForRestoreException;
import com.penpower.worldcard.team.exception.PermissionDeniedException;
import com.penpower.worldcard.team.exception.RestoreJobAlreadyRunningException;
import com.penpower.worldcard.team.exception.ScheduleStartException;
import com.penpower.worldcard.team.restore.DatabaseConnectionInfo;
import com.penpower.worldcard.team.restore.PostgreSqlJdbcUtils;
import com.penpower.worldcard.team.scheduler.JobIdentify;
import com.penpower.worldcard.team.scheduler.ScheduleManager;
import com.penpower.worldcard.team.scheduler.job.BackupJob;
import com.penpower.worldcard.team.scheduler.job.RestoreJob;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.RestoreInfoService;
import com.penpower.worldcard.team.web.api.RestoreController;
import com.penpower.worldcard.team.web.api.vo.response.ListResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.validation.Valid;
import org.joda.time.DateTime;
import org.quartz.JobDataMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/restore"}, produces={"application/json;charset=UTF-8"})
@Api(tags={""}, description="\u5099\u4efd\u76f8\u95dc\u7684API\u64cd\u4f5c")
public class RestoreController {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreController.class);
    @Autowired
    private RestoreInfoService restoreInfoService;
    @Autowired
    @Qualifier(value="databaseScheduleManager")
    private ScheduleManager databaseScheduleManager;
    @Autowired
    @Qualifier(value="scheduleManager")
    private ScheduleManager inMemoryScheduleManager;
    @Autowired
    private AccountService accountService;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private Environment env;

    @ApiOperation(value="", notes="\u53d6\u5f97\u5099\u4efd\u7684\u8cc7\u6599\u593e\u6e05\u55ae(USB)")
    @ApiResponses(value={@ApiResponse(code=466, message="Backup job is already running"), @ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_restore_storage_infos"}, method={RequestMethod.GET})
    public ListResponseResult<RestoreStoragInfos> getRestoreStorageInfos() {
        if (!HardwareIdUtil.linuxSystem()) {
            throw new PermissionDeniedException("Linux system support only.");
        }
        boolean inMemoryBackupJobRunning = this.inMemoryScheduleManager.jobRunning(BackupJob.class);
        BackupRunningStaus backupJoRunningStatus = (BackupRunningStaus)BackupJob.BACKUP_RUNNING_STATUS.get();
        boolean backupJobRunning = BackupRunningStaus.FIRED.equals((Object)backupJoRunningStatus) || BackupRunningStaus.RUNNING.equals((Object)backupJoRunningStatus);
        LOG.debug("inMemoryBackupJobRunning : {} ", (Object)inMemoryBackupJobRunning);
        LOG.debug("backupJobRunning : {} ", (Object)backupJobRunning);
        if (inMemoryBackupJobRunning || backupJobRunning) {
            throw new BackupJobAlreadyRunningException("Backup job is already running....");
        }
        List restoreStoragInfos = this.restoreInfoService.getRestoreStorageInfos();
        if (restoreStoragInfos == null || restoreStoragInfos.size() <= 0) {
            throw new ItemNotFoundException("No external storage information found.");
        }
        ListResponseResult response = new ListResponseResult("Get all restore storage informations succeeded.", restoreStoragInfos);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_restore_job_status"}, method={RequestMethod.GET})
    public MessageResponseResult getRestoreJobStatus() {
        if (!HardwareIdUtil.linuxSystem()) {
            throw new PermissionDeniedException("Linux system support only.");
        }
        RestoreJobRunningStaus runningStatus = null;
        boolean inMemoryRestoreJobRunning = this.inMemoryScheduleManager.jobRunning(RestoreJob.class);
        if (!inMemoryRestoreJobRunning && !RestoreJobRunningStaus.FIRED.equals(RestoreJob.RESTORE_RUNNING_STATUS.get())) {
            throw new ItemNotFoundException("There is no restore job running.....");
        }
        runningStatus = (RestoreJobRunningStaus)RestoreJob.RESTORE_RUNNING_STATUS.get();
        if (RestoreJobRunningStaus.RESTORING_DB.equals((Object)runningStatus)) {
            runningStatus = RestoreJobRunningStaus.RUNNING;
        }
        return new MessageResponseResult("Get current restore job running status succeeded.", runningStatus.toString());
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_restore_job_progress"}, method={RequestMethod.GET})
    public MessageResponseResult getRestoreJobProgress() {
        LOG.debug("RestoreJob.RESTORE_RUNNING_STATUS.get() >>>>>>>>> {} ", RestoreJob.RESTORE_RUNNING_STATUS.get());
        if (!HardwareIdUtil.linuxSystem()) {
            throw new PermissionDeniedException("Linux system support only.");
        }
        boolean inMemoryRestoreJobRunning = this.inMemoryScheduleManager.jobRunning(RestoreJob.class);
        if (!inMemoryRestoreJobRunning && !RestoreJobRunningStaus.FIRED.equals(RestoreJob.RESTORE_RUNNING_STATUS.get())) {
            throw new ItemNotFoundException("There is no restore job running.....");
        }
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$RestoreJobRunningStaus[((RestoreJobRunningStaus)RestoreJob.RESTORE_RUNNING_STATUS.get()).ordinal()]) {
            case 1: {
                LOG.debug("Restore fired.... return the fixed value.");
                return new MessageResponseResult("Get current restore job running progress value succeeded.", String.valueOf(0));
            }
            case 2: {
                LOG.debug("Restore job running... return the fixed value.");
                return new MessageResponseResult("Get current restore job running progress value succeeded.", String.valueOf(1));
            }
        }
        String rootUrlFormat = "%s%s:%s/";
        String serverIpAddress = this.env.getProperty("dataSource.nas.ip");
        String serverPort = this.env.getProperty("dataSource.nas.port");
        String username = this.env.getProperty("dataSource.nas.username");
        String password = this.env.getProperty("dataSource.nas.password");
        String databaseName = this.env.getProperty("dataSource.nas.databaseName");
        DatabaseConnectionInfo databaseConnectionInfo = new DatabaseConnectionInfo(rootUrlFormat, serverIpAddress, serverPort, username, password);
        PostgreSqlJdbcUtils jdbcDatabaseUtils = new PostgreSqlJdbcUtils(databaseConnectionInfo);
        RestoreStorageInfosLess restoreStorageInfosLessTmp = (RestoreStorageInfosLess)RestoreJob.RESTORE_STORAGE_INFO_LESS_TMP.get();
        String storagePath = restoreStorageInfosLessTmp.getStoragePath();
        BackupFileManager manager = new BackupFileManager(storagePath);
        BackupControlFile controlFile = manager.readRestoreControlFileJsonObject();
        long restoreDatabaseSizeBytes = jdbcDatabaseUtils.queryDatabaseSize(databaseName);
        long databaseSizeBytes = controlFile.getBackupDatabaseSize();
        LOG.debug("restoreDatabaseSizeBytes : {} ", (Object)restoreDatabaseSizeBytes);
        LOG.debug("databaseSizeBytes : {} ", (Object)databaseSizeBytes);
        double restoreDatabasePercentageValue = FileSystemUtil.getPercentageValue((long)restoreDatabaseSizeBytes, (long)databaseSizeBytes) + 1.0;
        LOG.debug("restoreDatabasePercentageValue : {} ", (Object)restoreDatabasePercentageValue);
        if (restoreDatabasePercentageValue >= 100.0) {
            restoreDatabasePercentageValue = 100.0;
        }
        return new MessageResponseResult("Get current restore job running progress value succeeded.", String.valueOf(restoreDatabasePercentageValue));
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=490, message="Unspecified exception for restore job."), @ApiResponse(code=468, message="The backup storage path is invalid or not exists."), @ApiResponse(code=484, message="Not enough space for restore"), @ApiResponse(code=483, message="Backup file api version is newer than server, or it's not correct version format"), @ApiResponse(code=497, message="Restore job is already running"), @ApiResponse(code=466, message="Backup job is already running"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/start_restore_auth"}, method={RequestMethod.POST})
    @PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE) and (hasAuthority('ADMIN'))")
    public MessageResponseResult startRestoreAuth(@RequestBody @Valid RestoreStorageInfosLess restoreStorageInfosLess) {
        if (!HardwareIdUtil.linuxSystem()) {
            throw new PermissionDeniedException("Linux system support only.");
        }
        this.verifyBackupFileAndStorageInfo(restoreStorageInfosLess);
        this.internalExecuteRestoreJob(restoreStorageInfosLess);
        MessageResponseResult response = new MessageResponseResult("Restore job start scceeded.(in background)", null);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=490, message="Unspecified exception for restore job."), @ApiResponse(code=468, message="The backup storage path is invalid or not exists."), @ApiResponse(code=484, message="Not enough space for restore"), @ApiResponse(code=483, message="Backup file api version is newer than server, or it's not correct version format"), @ApiResponse(code=497, message="Restore job is already running"), @ApiResponse(code=466, message="Backup job is already running"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/start_restore_no_auth"}, method={RequestMethod.POST})
    public MessageResponseResult startRestoreNoAuth(@RequestBody @Valid RestoreStorageInfosLess restoreStorageInfosLess) {
        if (!HardwareIdUtil.linuxSystem()) {
            throw new PermissionDeniedException("Linux system support only.");
        }
        long accountCount = this.accountService.getAccountCountforAllCompany();
        if (accountCount > 0L) {
            throw new AccessDeniedException("start_restore_no_auth api is for system UI call.");
        }
        this.verifyBackupFileAndStorageInfo(restoreStorageInfosLess);
        this.internalExecuteRestoreJob(restoreStorageInfosLess);
        MessageResponseResult response = new MessageResponseResult("Restore job start scceeded.(in background)", null);
        return response;
    }

    private void verifyBackupFileAndStorageInfo(RestoreStorageInfosLess restoreStorageInfosLess) {
        String storagePath = restoreStorageInfosLess.getStoragePath();
        BackupFileManager manager = new BackupFileManager(storagePath);
        BackupControlFile controlFile = manager.readRestoreControlFileJsonObject();
        LOG.debug("Precheck control file....");
        LOG.debug("controlFile: {}", (Object)controlFile);
        if (controlFile == null) {
            throw new DatabaseUtilsRuntimeException("Backup control file not found.");
        }
        String controlFileApiVersion = controlFile.getApiVersion();
        boolean backupFileCanBeRestored = this.restoreInfoService.backupFileVersionCanBeRestored(controlFileApiVersion);
        if (!backupFileCanBeRestored) {
            throw new BackupFileVersionNewerThanServerException("Backup file api version is newer than server, or it's not correct version format");
        }
        long backupSizeBytes = controlFile.getBackupSizeBytes();
        String fileSystemRootPath = this.applicationProperties.getProperty("FILE_SYSTEM_ROOT_PATH");
        Path fileSystemRoot = Paths.get(fileSystemRootPath, new String[0]);
        long usableSpaceBytes = FileSystemUtil.getDiskInfos((Path)fileSystemRoot).getUsableSpaceBytes();
        LOG.debug("backupSizeBytes:{}, usableSpaceBytes:{}", (Object)backupSizeBytes, (Object)usableSpaceBytes);
        if (backupSizeBytes > usableSpaceBytes) {
            throw new NotEnoughSpaceForRestoreException("Not enough space for restore");
        }
    }

    private void internalExecuteRestoreJob(RestoreStorageInfosLess restoreStorageInfosLess) {
        boolean backupControlFileExists;
        boolean inMemoryBackupJobRunning = this.inMemoryScheduleManager.jobRunning(BackupJob.class);
        BackupRunningStaus backupJoRunningStatus = (BackupRunningStaus)BackupJob.BACKUP_RUNNING_STATUS.get();
        boolean backupJobRunning = BackupRunningStaus.FIRED.equals((Object)backupJoRunningStatus) || BackupRunningStaus.RUNNING.equals((Object)backupJoRunningStatus);
        LOG.debug("inMemoryBackupJobRunning : {} ", (Object)inMemoryBackupJobRunning);
        LOG.debug("backupJobRunning : {} ", (Object)backupJobRunning);
        if (inMemoryBackupJobRunning || backupJobRunning) {
            throw new BackupJobAlreadyRunningException("Backup job is already running....");
        }
        boolean inMemoryRestoreJobRunning = this.inMemoryScheduleManager.jobRunning(RestoreJob.class);
        RestoreJobRunningStaus restoreJobRunningStatus = (RestoreJobRunningStaus)RestoreJob.RESTORE_RUNNING_STATUS.get();
        boolean restoreJobRunning = RestoreJobRunningStaus.FIRED.equals((Object)restoreJobRunningStatus) || RestoreJobRunningStaus.RUNNING.equals((Object)restoreJobRunningStatus) || RestoreJobRunningStaus.RESTORING_DB.equals((Object)restoreJobRunningStatus);
        LOG.debug("inMemoryRestoreJobRunning : {} ", (Object)inMemoryRestoreJobRunning);
        LOG.debug("restoreJobRunning : {} ", (Object)restoreJobRunning);
        if (inMemoryRestoreJobRunning || restoreJobRunning) {
            throw new RestoreJobAlreadyRunningException("Restore job is already running...");
        }
        String storagePath = restoreStorageInfosLess.getStoragePath();
        Path restoreFileRoot = Paths.get(storagePath, new String[0]);
        boolean restorePathExists = Files.exists(restoreFileRoot, new LinkOption[0]);
        if (!restorePathExists) {
            throw new InvalidBackupPathException("Invalid backup folder....");
        }
        BackupFileManager backupFileManager = new BackupFileManager(storagePath);
        BackupControlFile backupControlFile = backupFileManager.readRestoreControlFileJsonObject();
        boolean bl = backupControlFileExists = backupControlFile != null;
        if (!backupControlFileExists) {
            throw new DatabaseUtilsRuntimeException("Backup control file not found.");
        }
        BackupStatus backupStatus = backupControlFile.getBackupStatus();
        boolean validBackupStatus = BackupStatus.FINISHED.equals((Object)backupStatus);
        if (!validBackupStatus) {
            throw new DatabaseUtilsRuntimeException("BackupStatus in control file is incorrect.");
        }
        JobIdentify jobIdentify = new JobIdentify("RESTORE_JOB_GROUP", RestoreJob.class);
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("restoreStoragInfosLess", (Object)restoreStorageInfosLess);
        DateTime launchTime = new DateTime().plusSeconds(5);
        try {
            this.inMemoryScheduleManager.startScheduleOnce(jobIdentify, launchTime.toDate(), dataMap);
        }
        catch (ScheduleStartException ex) {
            RestoreJob.resetAllTemporaryValues();
            throw ex;
        }
        finally {
            RestoreJob.RESTORE_RUNNING_STATUS.set(RestoreJobRunningStaus.FIRED);
        }
    }
}

