/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.NoticeDto;
import com.penpower.worldcard.team.enums.NoticeReadStatus;
import com.penpower.worldcard.team.enums.NoticeSortField;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.web.api.vo.ListRequestVo;
import com.penpower.worldcard.team.web.api.vo.NoticeSendVo;
import com.penpower.worldcard.team.web.api.vo.PageInfoVo;
import com.penpower.worldcard.team.web.api.vo.response.ListResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.LongResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.PageResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/notice"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"notice"}, description="")
@PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE)")
public class NoticeController {
    private static final Logger LOG = LoggerFactory.getLogger(NoticeController.class);
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_notice_list"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public ListResponseResult<NoticeDto> get_notice_list(@RequestParam(required=true) NotifyCategory notifyCategory, @RequestParam(required=true) NoticeReadStatus noticeReadStatus) {
        PageResponseResult noticesPage = this.get_notice_list_pageable(notifyCategory, noticeReadStatus, 0, Integer.MAX_VALUE, NoticeSortField.notifytime, Sort.Direction.DESC);
        this.setAccountNoticeLastViewedTime();
        LOG.debug("totalCount  : {} , totalPage :{} , dataSize : {}", new Object[]{noticesPage.getTotalCount(), noticesPage.getTotalPages(), ((List)noticesPage.getData()).size()});
        ListResponseResult response = new ListResponseResult(String.format("Get all notice list by NotifyCategory[%s] succeeded.", notifyCategory), (List)noticesPage.getData());
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u548c\u8a72ACCOUNT\u76f8\u95dc\u7684\u6240\u6709NOTICE\uff0c\u5305\u542b\u5206\u9801\u53c3\u6578 <BR><BR>page\u5f9e0\u958b\u59cb, \u5982\u679c\u8f38\u5165\u70ba-1\u6642 \u8996\u70ba\u67e5\u8a62\u5168\u90e8\u8cc7\u6599<BR>\u6b64\u6642pageSize \u5c07\u6703\u662f\u7cfb\u7d71\u9810\u8a2d\u6700\u5927\u503c(\u53ef\u8f38\u51650)<BR>")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_notice_list_pageable"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public PageResponseResult<NoticeDto> get_notice_list_pageable(@RequestParam(required=true) NotifyCategory notifyCategory, @RequestParam(required=true) NoticeReadStatus noticeReadStatus, @RequestParam(required=true) int page, @RequestParam(required=true) int pageSize, @RequestParam(required=true) NoticeSortField noticeSortField, @RequestParam(required=true) Sort.Direction sortDirection) {
        if (page < 0) {
            LOG.debug("Page value was less than 0 , query all notice items.");
            page = 0;
            pageSize = 500;
            notifyCategory = NotifyCategory.ALL;
            noticeSortField = NoticeSortField.notifytime;
            sortDirection = Sort.Direction.DESC;
        }
        Sort sort = new Sort(sortDirection, new String[]{noticeSortField.getTableName().toLowerCase()});
        PageRequest pageRequest = new PageRequest(page, pageSize, sort);
        PageInfoVo noticePageResult = this.noticeService.getAllNoticeWithPageable(notifyCategory, noticeReadStatus, pageRequest);
        LOG.debug("get all notice items finished.....");
        this.setAccountNoticeLastViewedTime();
        LOG.debug("set notice last viewed time finished.....");
        LOG.debug("totalCount  : {} , totalPage :{} , dataSize : {}", new Object[]{noticePageResult.getTotalCount(), noticePageResult.getTotalPage(), ((List)noticePageResult.getPageContent()).size()});
        PageResponseResult response = new PageResponseResult(String.format("Get all notice list by NotifyCategory[%s] succeeded.", notifyCategory.toString()), (List)noticePageResult.getPageContent(), noticePageResult.getTotalCount(), noticePageResult.getTotalPage());
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u7279\u5b9aNOTICE\u7684\u8a73\u7d30\u5167\u5bb9(CONTENT \u5167\u5bb9\u70baJSON\u683c\u5f0f\uff0c\u5305\u542b\u5c0d\u61c9\u4e8b\u4ef6\u7684GUID\u6216\u5c6c\u6027)")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>"), @ApiResponse(code=404, message="Resource item not found in system. <BR>")})
    @RequestMapping(value={"/get_notice_content"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult get_notice_content(@RequestParam(required=true) String noticeGuid) {
        String noticeContent = this.noticeService.getNoticeContent(noticeGuid);
        this.noticeService.setNoticeViewed(noticeGuid);
        MessageResponseResult response = new MessageResponseResult(String.format("Get notice content by guid[%s] succeeded.", noticeGuid), noticeContent);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_unviewed_notice_count"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public LongResponseResult get_unviewed_notice_count(@RequestParam(required=true) NotifyCategory notifyCategory) {
        AccountInfo accountInfo = SecurityUtils.getCurrentLoginUser();
        String accountGuid = accountInfo.getGuid();
        DateTime getLastNoticeCountView = this.accountPrivateSettingService.getLastNoticeCountView(accountGuid);
        long count = this.noticeService.getAccountUnviewedNoticeCount(notifyCategory, accountGuid, getLastNoticeCountView);
        LongResponseResult response = new LongResponseResult(String.format("Get unviewd notice count by NotifyCategory[%s] succeeded.", notifyCategory), Long.valueOf(count));
        return response;
    }

    @ApiOperation(value="", notes="\u8a2d\u5b9a\u4f7f\u7528\u8005\u6700\u5f8c\u8b80\u53d6\u901a\u77e5\u6578\u91cf\u7684\u6642\u9593.")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/set_last_notice_viewed"}, method={RequestMethod.POST})
    public MessageResponseResult set_last_notice_viewed() {
        this.setAccountNoticeLastViewedTime();
        MessageResponseResult response = new MessageResponseResult("Set last notice viewd time succeeded.", null);
        return response;
    }

    @ApiOperation(value="", notes="\u9001\u51fa\u5206\u4eab\u540d\u7247\u7684\u901a\u77e5\u7d66\u88ab\u5206\u4eab\u8005.")
    @ApiResponses(value={@ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/send_contacts_shared_notice"}, method={RequestMethod.POST})
    public MessageResponseResult send_contacts_shared_notice(@RequestBody NoticeSendVo vo) {
        AccountInfo myAccountInfo = SecurityUtils.getCurrentLoginUser();
        List receiverAccountGuids = vo.getReceiverAccountGuids();
        if (CollectionUtils.isEmpty((Collection)receiverAccountGuids)) {
            throw new RequestArgumentNotValidException("No receiver accounts.");
        }
        List sharedContactGuids = vo.getSharedContactGuids();
        if (CollectionUtils.isEmpty((Collection)sharedContactGuids)) {
            throw new RequestArgumentNotValidException("No shared contacts.");
        }
        while (!CollectionUtils.isEmpty((Collection)sharedContactGuids)) {
            List headList = sharedContactGuids.subList(0, Math.min(sharedContactGuids.size(), 300));
            ListRequestVo noticeContentModel = new ListRequestVo();
            noticeContentModel.setList(headList);
            this.noticeService.addNewNoticeToUsers(NotifyCategory.CONTACT, NotifyType.CONTACT_BESHARED, GlobalUtils.getJsonString((Object)noticeContentModel), receiverAccountGuids, myAccountInfo.getGuid(), myAccountInfo.getCompanyGuid());
            sharedContactGuids.removeAll(headList);
        }
        MessageResponseResult response = new MessageResponseResult("Send notice to receivers succeeded.", null);
        return response;
    }

    private void setAccountNoticeLastViewedTime() {
        AccountInfo accountInfo = SecurityUtils.getCurrentLoginUser();
        String accountGuid = accountInfo.getGuid();
        this.accountPrivateSettingService.setLastNoticeCountView(accountGuid, new DateTime());
    }
}

