/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.google.gson.Gson;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.config.property.SystemConstantProperties;
import com.penpower.worldcard.team.crm.BasicToken;
import com.penpower.worldcard.team.crm.CRMAuthenticationManager;
import com.penpower.worldcard.team.crm.NullCRMToken;
import com.penpower.worldcard.team.crm.salesforce.SalesForceOAuthTokenType;
import com.penpower.worldcard.team.crm.salesforce.SalesforceOAuthToken;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.AccountPrivateSettingDto;
import com.penpower.worldcard.team.dto.AccountShareTargetDto;
import com.penpower.worldcard.team.dto.CRMSettingsDto;
import com.penpower.worldcard.team.dto.CustomFieldDto;
import com.penpower.worldcard.team.dto.PicklistContentDto;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.enums.CRMExportMode;
import com.penpower.worldcard.team.enums.CustomFieldCategory;
import com.penpower.worldcard.team.enums.IdentificationResult;
import com.penpower.worldcard.team.enums.LoginFailureOption;
import com.penpower.worldcard.team.enums.MapEngine;
import com.penpower.worldcard.team.enums.NameOrder;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.enums.ShareItem;
import com.penpower.worldcard.team.enums.ShareRule;
import com.penpower.worldcard.team.enums.SortingOrder;
import com.penpower.worldcard.team.enums.SupportCRM;
import com.penpower.worldcard.team.enums.SystemProperty;
import com.penpower.worldcard.team.exception.CRMOperationException;
import com.penpower.worldcard.team.exception.ItemAlreadyExistsException;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.AccountShareTargetService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.CustomFieldService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.SystemSettingService;
import com.penpower.worldcard.team.web.api.vo.AccountShareTargetUpdateListVo;
import com.penpower.worldcard.team.web.api.vo.AccountShareTargetVo;
import com.penpower.worldcard.team.web.api.vo.ListRequestVo;
import com.penpower.worldcard.team.web.api.vo.UpdateCRMTokenVo;
import com.penpower.worldcard.team.web.api.vo.UserExportInfoVo;
import com.penpower.worldcard.team.web.api.vo.response.AllUserSettingResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.BooleanResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.CRMSettingsResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.ListResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.LoginFailureOptionResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.LongResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.ShareRuleResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.SupportCRMResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.UserExportInfoResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/account/normal/setting"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"normal_user_settings"}, description="Normal user settings")
@PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE)")
public class NormalUserSettingController {
    private static final Logger LOG = LoggerFactory.getLogger(NormalUserSettingController.class);
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private AccountShareTargetService accountShareTargetService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private SystemSettingService systemSettingService;
    @Autowired
    private CRMAuthenticationManager salesForceAuthenticationManager;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private RegistryService registryService;

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_support_map_engines"}, method={RequestMethod.POST})
    public ListResponseResult<MapEngine> get_support_map_engines() {
        List<MapEngine> supportMapEngines = Arrays.asList(MapEngine.values());
        ListResponseResult response = new ListResponseResult(String.format("Get support map engines succeeded.", new Object[0]), supportMapEngines);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_map_engine_setting"}, method={RequestMethod.POST})
    public MessageResponseResult get_map_engine_setting() {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountService.verifyAccount(userGuid, null);
        MapEngine mapEngine = this.accountPrivateSettingService.getUserMapEngineSetting(userGuid);
        MessageResponseResult response = new MessageResponseResult(String.format("Get user map engine setting succeeded.", new Object[0]), mapEngine.toString());
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/set_map_engine_setting"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult set_map_engine_setting(@RequestParam(required=true) MapEngine mapEngine) {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountService.verifyAccount(userGuid, null);
        this.accountPrivateSettingService.setUserMapEngineSetting(userGuid, mapEngine);
        MessageResponseResult response = new MessageResponseResult(String.format("Set user map engine succeeded.", new Object[0]), null);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_western_surname_order_setting"}, method={RequestMethod.POST})
    public MessageResponseResult get_western_surname_order() {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountService.verifyAccount(userGuid, null);
        NameOrder nameOrder = this.accountPrivateSettingService.getUserWesternSurnameOrder(userGuid);
        MessageResponseResult response = new MessageResponseResult(String.format("Get user western surname order setting succeeded.", new Object[0]), nameOrder.toString());
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/set_western_surname_order_setting"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult set_western_surname_order_setting(@RequestParam(required=true) NameOrder nameOrder) {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountService.verifyAccount(userGuid, null);
        this.accountPrivateSettingService.setUserWesternSurnameOrder(userGuid, nameOrder);
        MessageResponseResult response = new MessageResponseResult(String.format("Set user western surname order setting succeeded.", new Object[0]), null);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_asian_surname_order_setting"}, method={RequestMethod.POST})
    public MessageResponseResult get_asian_surname_order_setting() {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountService.verifyAccount(userGuid, null);
        NameOrder nameOrder = this.accountPrivateSettingService.getUserAsianSurnameOrder(userGuid);
        MessageResponseResult response = new MessageResponseResult(String.format("Get user asian surname order setting succeeded.", new Object[0]), nameOrder.toString());
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/set_asian_surname_order_setting"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult set_asian_surname_order_setting(@RequestParam(required=true) NameOrder nameOrder) {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountService.verifyAccount(userGuid, null);
        this.accountPrivateSettingService.setUserAsianSurnameOrder(userGuid, nameOrder);
        MessageResponseResult response = new MessageResponseResult(String.format("Set user asian surname order setting succeeded.", new Object[0]), null);
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u81ea\u52d5\u5206\u4eab\u958b\u555f\u548c\u95dc\u9589\u7684\u8a2d\u5b9a")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_auto_share_setting"}, method={RequestMethod.POST})
    public BooleanResponseResult get_auto_share() {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountService.verifyAccount(userGuid, null);
        boolean autoShare = this.accountPrivateSettingService.getAutoShareSetting(userGuid);
        BooleanResponseResult response = new BooleanResponseResult(String.format("Get user auto share to all user setting succeeded.", new Object[0]), Boolean.valueOf(autoShare));
        return response;
    }

    @ApiOperation(value="", notes="\u8a2d\u5b9a\u81ea\u52d5\u5206\u4eab\u529f\u80fd\u958b\u555f\u548c\u95dc\u9589")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/set_auto_share_setting"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult set_auto_share_setting(@RequestParam(required=true) boolean enable) {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountService.verifyAccount(userGuid, null);
        this.accountPrivateSettingService.setAutoShareSetting(userGuid, enable);
        MessageResponseResult response = new MessageResponseResult(String.format("Set user auto share to all user setting succeeded", new Object[0]), null);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_account_share_targets"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public ListResponseResult<AccountShareTargetDto> get_account_share_targets(@RequestParam(value="shareItem") ShareItem shareItem) {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountService.verifyAccount(userGuid, null);
        List shareTargets = this.accountShareTargetService.getShareTargetsByShareItem(userGuid, shareItem);
        ListResponseResult response = new ListResponseResult(String.format("Get all shared target by shareItem succeeded.", new Object[0]), shareTargets);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=460, message="Item already exists.<BR>"), @ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/add_account_share_target"}, method={RequestMethod.POST})
    public MessageResponseResult add_account_share_target(@RequestBody @Valid AccountShareTargetVo accountShareTargetCreateVo) {
        boolean newItemExists = this.accountShareTargetService.newShareTargetExists(accountShareTargetCreateVo.getAccountGuid(), accountShareTargetCreateVo.getShareItem());
        if (newItemExists) {
            throw new ItemAlreadyExistsException("Filed to add new share target , item already exists.");
        }
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountShareTargetService.addNewShareTarget(userGuid, accountShareTargetCreateVo.getAccountGuid(), accountShareTargetCreateVo.getShareItem());
        MessageResponseResult response = new MessageResponseResult(String.format("add new user for share succeeded", new Object[0]), null);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/add_account_share_targets"}, method={RequestMethod.POST})
    public MessageResponseResult add_account_share_targets(@RequestBody @Valid ListRequestVo<AccountShareTargetVo> accountShareTargetsCreateVo) {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountShareTargetService.addNewShareTargets(userGuid, accountShareTargetsCreateVo.getList());
        MessageResponseResult response = new MessageResponseResult(String.format("Share account targets has been added.", new Object[0]), null);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/update_account_share_target_list"}, method={RequestMethod.POST})
    public MessageResponseResult updateAccountShareTargetList(@RequestBody @Valid AccountShareTargetUpdateListVo accountShareTargetUpdateListVo) {
        LOG.debug("accountShareTargetUpdateListVo :{} ", (Object)accountShareTargetUpdateListVo);
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountShareTargetService.updateAccountShareTargetList(userGuid, accountShareTargetUpdateListVo);
        MessageResponseResult response = new MessageResponseResult(String.format("update share target list succeeded", new Object[0]), null);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/remove_account_share_target"}, method={RequestMethod.POST})
    public MessageResponseResult removeAccountShareTarget(@RequestBody @Valid AccountShareTargetVo accountShareTargetVo) {
        String currentLoginUserGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountShareTargetService.deleteShareTarget(currentLoginUserGuid, accountShareTargetVo.getAccountGuid(), accountShareTargetVo.getShareItem());
        MessageResponseResult response = new MessageResponseResult(String.format("remove account share target succeeded.", new Object[0]), null);
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u8981\u4f9d\u90a3\u500b\u6b04\u4f4d\u6392\u5e8f\u7684\u8a2d\u5b9a\u503c")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_sorting_order_setting"}, method={RequestMethod.POST})
    public MessageResponseResult getSortingOrderSetting() {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        SortingOrder sortingOrder = this.accountPrivateSettingService.getSortingOrder(userGuid);
        MessageResponseResult response = new MessageResponseResult(String.format("Get user sorting order succeeded.", new Object[0]), sortingOrder.toString());
        return response;
    }

    @ApiOperation(value="", notes="\u8a2d\u5b9a\u8981\u4f9d\u90a3\u500b\u6b04\u4f4d\u6392\u5e8f\u7684\u8a2d\u5b9a\u503c")
    @ApiResponses(value={@ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/set_sorting_order_setting"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult setSortingOrderSetting(@RequestParam(required=true) SortingOrder sortingOrder) {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountPrivateSettingService.setSortingOrder(userGuid, sortingOrder);
        MessageResponseResult response = new MessageResponseResult(String.format("Set user sotring order succeeded.", new Object[0]), null);
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u4e2d\u6587\u8fa6\u8b58\u7d50\u679c\u8981\u986f\u793a\u7684\u65b9\u5f0f<BR> CONTACT_CONTENT - \u540c\u540d\u7247\u5167\u5bb9<BR>GB - \u7c21\u9ad4\u4e2d\u6587<BR>BIG5 - \u7e41\u9ad4\u4e2d\u6587")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_identification_result_setting"}, method={RequestMethod.POST})
    public MessageResponseResult getIdentificationResultSetting() {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        IdentificationResult identificationResult = this.accountPrivateSettingService.getIdentificationResult(userGuid);
        MessageResponseResult response = new MessageResponseResult(String.format("Get user sorting order succeeded.", new Object[0]), identificationResult.toString());
        return response;
    }

    @ApiOperation(value="", notes="\u8a2d\u5b9a\u4e2d\u6587\u8fa6\u8b58\u7d50\u679c\u8981\u986f\u793a\u7684\u65b9\u5f0f<BR> CONTACT_CONTENT - \u540c\u540d\u7247\u5167\u5bb9<BR>GB - \u7c21\u9ad4\u4e2d\u6587<BR>BIG5 - \u7e41\u9ad4\u4e2d\u6587")
    @ApiResponses(value={@ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/set_identification_result_setting"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult setIdentificationResultSetting(@RequestParam(required=true) IdentificationResult identificationResult) {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountPrivateSettingService.setIdentificationResult(userGuid, identificationResult);
        MessageResponseResult response = new MessageResponseResult(String.format("Set user sotring order succeeded.", new Object[0]), null);
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u7ba1\u7406\u8005\u7684\u5171\u4eab\u898f\u5247\u8a2d\u5b9a<BR> ALL - \u5168\u90e8\u5171\u4eab <BR> BY_SETTING - \u4f9d\u64da\u6b0a\u9650\u8207\u5206\u4eab\u8a2d\u5b9a")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_global_share_rule"}, method={RequestMethod.POST})
    public ShareRuleResponseResult get_global_share_rule() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        ShareRule shareRule = this.systemSettingService.getShareRule(currentLoginUser);
        ShareRuleResponseResult response = new ShareRuleResponseResult("Get global share rule setting succeeded.", shareRule);
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u4f7f\u7528\u8005\u6240\u6709\u7684\u4e00\u822c\u7cfb\u7d71\u8a2d\u5b9a")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_all_user_settings"}, method={RequestMethod.POST})
    public AllUserSettingResponseResult getAllUserSettings() {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        AccountPrivateSettingDto dto = this.accountPrivateSettingService.getAllUserSettings(userGuid);
        AllUserSettingResponseResult response = new AllUserSettingResponseResult("Get user all settings succeeded.", dto);
        return response;
    }

    @ApiOperation(value="", notes="\u8a2d\u5b9a\u4f7f\u7528\u8005CRM\u76f8\u95dc\u7684\u8a2d\u5b9a(\u6b64\u70baUsername-Password oauth\u4f7f\u7528\uff0cuser-agent\u8acb\u4f7f\u7528update_CRM_access_token)<BR> \u6b64\u8a2d\u5b9a\u6703\u547c\u53ebCRM\u7684login function<BR> \u5982\u679c\u5931\u6557\u6703\u56de\u50b3\u932f\u8aa4\u4ee3\u78bc<BR>")
    @ApiResponses(value={@ApiResponse(code=450, message="The request could not be executed due to cancellation, a connectivity problem or timeout."), @ApiResponse(code=409, message="The crm operation has failed."), @ApiResponse(code=400, message="CRM system login failed."), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/set_CRM_settings"}, method={RequestMethod.POST})
    public MessageResponseResult setCRMSettings(@RequestBody @Valid CRMSettingsDto CRMSettingsDto2) {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        GlobalUtils.setProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"HAVE_SET_SALSEFORCE", (String)"true", (String)currentLoginAccount.getCompanyGuid());
        try {
            this.accountPrivateSettingService.setUserCRMSettings(userGuid, CRMSettingsDto2);
            CRMSettingsDto CRMSettings = this.accountPrivateSettingService.getUserCRMSettings(userGuid);
            BasicToken basicToken = this.salesForceAuthenticationManager.loginCRM(CRMSettings);
            boolean userAgentTokenJsonValid = this.salesForceAuthenticationManager.testAccessToken(basicToken, SalesForceOAuthTokenType.USERNAME_PASSWORD);
            if (!userAgentTokenJsonValid) {
                throw new CRMOperationException("Fail to update access token , token invalid.");
            }
            SalesforceOAuthToken authResult = (SalesforceOAuthToken)basicToken;
            Gson gson = new Gson();
            String authString = gson.toJson((Object)authResult);
            this.accountPrivateSettingService.setUserCRMloginToken(userGuid, authString, SalesForceOAuthTokenType.USERNAME_PASSWORD);
            GlobalUtils.setProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"HAVE_SET_SALSEFORCE", (String)"true", (String)currentLoginAccount.getCompanyGuid());
        }
        catch (Exception ex) {
            this.accountPrivateSettingService.cleanUserCRMSettings(userGuid);
            throw ex;
        }
        MessageResponseResult response = new MessageResponseResult("Set all CRM settings succeeded.", "CRM login successeeded , access_token has been stored.");
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u4f7f\u7528\u8005\u6240\u6709CRM\u76f8\u95dc\u7684\u8a2d\u5b9a, ")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_CRM_settings"}, method={RequestMethod.POST})
    public CRMSettingsResponseResult getCRMSettings() {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        CRMSettingsDto CRMSettingsDto2 = this.accountPrivateSettingService.getUserCRMSettings(userGuid);
        CRMSettingsResponseResult response = new CRMSettingsResponseResult("Get all CRM settings succeeded.", CRMSettingsDto2);
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u7684\u6240\u6709\u7684\u81ea\u8a02\u6b04\u4f4d\u5167\u5bb9(\u9700\u6307\u5b9acategory CONTACT,TASK,ACTIVITY)")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_all_custom_fields_by_category"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public ListResponseResult<CustomFieldDto> getAllCustomFieldsByCategory(@RequestParam(required=true) CustomFieldCategory customFieldCategory) {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        List customFieldContentDtos = this.customFieldService.getAllCustomFields(customFieldCategory, currentLoginAccount.getCompanyGuid());
        ListResponseResult response = new ListResponseResult("Get all custom fields succeeded.", customFieldContentDtos);
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u7279\u5b9aCustomField\u7684picklist content")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_custom_field_picklist_content"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public ListResponseResult<PicklistContentDto> getCustomFieldPicklistContent(@RequestParam(required=true) String customFieldGuid) {
        List customFieldPicklistContentDtos = this.customFieldService.getCustomFieldPicklistContent(customFieldGuid);
        ListResponseResult response = new ListResponseResult("Get picklist contents by custom field guid succeeded.", customFieldPicklistContentDtos);
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u76ee\u524d\u7cfb\u7d71\u4f7f\u7528\u7684CRM\u8a2d\u5b9a")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_CRM_system"}, method={RequestMethod.POST})
    public SupportCRMResponseResult getCRMSystem() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        SupportCRM supportCRM = this.systemSettingService.getSystemCRM(currentLoginUser);
        SupportCRMResponseResult response = new SupportCRMResponseResult("Get system CRM setting succeeded.", supportCRM);
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u4f7f\u7528\u8005\u6700\u5f8c\u532f\u51fa\u7684\u6642\u9593")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_user_CRM_last_export_info"}, method={RequestMethod.POST})
    public UserExportInfoResult getUserCRMLastExportInfo() {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        AccountPrivateSettingDto allUserSettings = this.accountPrivateSettingService.getAllUserSettings(userGuid);
        UserExportInfoVo userExportInfoVo = new UserExportInfoVo(allUserSettings.getLastexportcount(), allUserSettings.getLastexporttime(), allUserSettings.getLastexportresult());
        UserExportInfoResult response = new UserExportInfoResult("Get user CRM export info setting succeeded.", userExportInfoVo);
        return response;
    }

    @ApiOperation(value="", notes="\u8a2d\u5b9a\u4f7f\u7528\u8005\u7d81\u5b9aCRM\u4e4b\u5f8c\u6240\u4f7f\u7528\u7684\u532f\u51fa\u6a21\u5f0f<BR>AUTO_EXPORT_OPPORTUNITY : \u81ea\u52d5\u532f\u51fa\u5230\u5546\u6a5f<BR>AUTO_EXPORT_CONTACT : \u81ea\u52d5\u532f\u51fa\u5230\u806f\u7d61\u4eba<BR>MANUAL_EXPORT : \u624b\u52d5\u532f\u51fa")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/set_CRM_export_mode"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult setCRMExportMode(@RequestParam(required=true) SupportCRM supportCRM, @RequestParam(required=true) CRMExportMode CRMExportMode2) {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        this.accountPrivateSettingService.setUserCRMExportMode(userGuid, CRMExportMode2);
        MessageResponseResult response = new MessageResponseResult("Set user CRM export mode setting succeeded.", null);
        return response;
    }

    @ApiOperation(value="", notes="\u66f4\u65b0\u76ee\u524d\u4f7f\u7528\u8005\u5df2\u5132\u5b58\u7684CRM access_token.")
    @ApiResponses(value={@ApiResponse(code=409, message="The crm operation has failed."), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/update_CRM_access_token"}, method={RequestMethod.POST})
    public MessageResponseResult updateCRMAccessToken(@RequestBody UpdateCRMTokenVo updateCRMTokenVo) {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        Gson gson = new Gson();
        String userAgentTokenJson = gson.toJson((Object)updateCRMTokenVo.getSalesforceUserAgentAuthToken());
        LOG.debug("new user CRM json : {} ", (Object)userAgentTokenJson);
        boolean userAgentTokenJsonValid = this.salesForceAuthenticationManager.testAccessTokenByJsonString(userAgentTokenJson, SalesForceOAuthTokenType.USER_AGENT);
        if (!userAgentTokenJsonValid) {
            throw new CRMOperationException("Fail to update access token , token invalid.");
        }
        CRMSettingsDto crmSettings = new CRMSettingsDto();
        crmSettings.setUserCRMAccount(updateCRMTokenVo.getUserCRMAccount());
        crmSettings.setUserCRMExportMode(updateCRMTokenVo.getCRMExportMode());
        this.accountPrivateSettingService.setUserCRMSettings(userGuid, crmSettings);
        this.accountPrivateSettingService.setUserCRMloginToken(userGuid, userAgentTokenJson, SalesForceOAuthTokenType.USER_AGENT);
        MessageResponseResult response = new MessageResponseResult("Update user CRM access_token succeeded.", null);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="", notes="\u767b\u51fa\u76ee\u524d\u4f7f\u7528\u8005\u7d81\u5b9a\u7684CRM,\u6e05\u9664\u7cfb\u7d71\u5132\u5b58\u7684\u8a2d\u5b9a")
    @ApiResponses(value={@ApiResponse(code=400, message="CRM system logout failed."), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/logout_CRM"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult logoutCRM(@RequestParam(required=true) SupportCRM supportCRM) {
        String userGuid = SecurityUtils.getCurrentLoginUser().getGuid();
        String CRMLoginJsonToken = this.accountPrivateSettingService.getUserCRMLoginToken(userGuid);
        SalesForceOAuthTokenType tokenType = this.accountPrivateSettingService.getUserCRMTokenType(userGuid);
        BasicToken currentAccessToken = this.salesForceAuthenticationManager.getAccessToken(CRMLoginJsonToken, tokenType);
        LOG.debug("chrrentAccessToken : {} ", (Object)currentAccessToken);
        if (currentAccessToken == null || currentAccessToken instanceof NullCRMToken) {
            this.accountPrivateSettingService.resetUserCRMsettings(userGuid);
        } else {
            try {
                this.salesForceAuthenticationManager.logoutCRM(currentAccessToken.getAccess_token());
            }
            catch (Exception exception) {
            }
            finally {
                this.accountPrivateSettingService.cleanUserCRMSettings(userGuid);
            }
        }
        MessageResponseResult response = new MessageResponseResult("Logout CRM system succeeded.", null);
        return response;
    }

    @RequestMapping(value={"/GetProperty"}, method={RequestMethod.GET})
    @ApiOperation(value="Get Property", notes="Get system property")
    public MessageResponseResult GetProperty(@RequestParam SystemProperty systemProperty) {
        Globalinfo maxContactCount;
        String responString = "";
        if (systemProperty.equals((Object)SystemProperty.MAX_CATEGORY_LAYER_COUNT)) {
            responString = Long.toString(3L);
        }
        if (systemProperty == SystemProperty.MAX_CONTACT_COUNT_IN_PRIVATE) {
            maxContactCount = this.globalInfoService.getPropertiesByKey("MAX_CONTACT_COUNT_IN_PRIVATE");
            responString = maxContactCount == null ? Long.toString(25000L) : maxContactCount.getConfigValue();
        }
        if (systemProperty == SystemProperty.MAX_CONTACT_COUNT_IN_PUBLIC) {
            maxContactCount = this.globalInfoService.getPropertiesByKey("MAX_CONTACT_COUNT_IN_PRIVATE");
            if (maxContactCount == null) {
                long maxCount = 30000L;
                responString = Long.toString(maxCount);
            } else {
                long maxCount = (long)((float)Long.parseLong(maxContactCount.getConfigValue()) * 1.2f);
                responString = Long.toString(maxCount);
            }
        }
        if (systemProperty == SystemProperty.MAX_CONTACT_COUNT_IN_SERVER) {
            responString = this.registryService.GetServerType() == ServerType.ASUSTOR_NAS_AUTOMATION ? "500" : ((maxContactCount = this.globalInfoService.getPropertiesByKey("MAX_CONTACT_COUNT_IN_DB")) == null ? Long.toString(360000L) : maxContactCount.getConfigValue());
        }
        MessageResponseResult response = new MessageResponseResult("Get property success", responString);
        return response;
    }

    @RequestMapping(value={"/get_login_failure_option"}, method={RequestMethod.GET})
    public LoginFailureOptionResponseResult getLoginFailureOption() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        String loginFailureOptionString = this.companyGlobalInfoService.getStringByKeyWithDefault("LOGIN_FAILURE_OPTION", SystemConstantProperties.DEFAULT_DELAY_LOGIN, currentLoginUser.getCompanyGuid());
        LoginFailureOption loginFailureOption = LoginFailureOption.valueOf((String)loginFailureOptionString);
        return new LoginFailureOptionResponseResult("get sucess", loginFailureOption);
    }

    @RequestMapping(value={"/get_login_failure_count_limit"}, method={RequestMethod.GET})
    public LongResponseResult getLoginFailureCountLimit() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        long rtnValue = this.companyGlobalInfoService.getValueByKeyWithDefault("LOGIN_FAILURE_COUNT_LIMIT", 5, currentLoginUser.getCompanyGuid());
        return new LongResponseResult("get sucess", Long.valueOf(rtnValue));
    }

    @RequestMapping(value={"/get_login_failure_block_Period"}, method={RequestMethod.GET})
    public LongResponseResult getLoginFailureBlockPeriod() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        long rtnValue = this.companyGlobalInfoService.getValueByKeyWithDefault("LOGIN_FAILURE_BLOCK_PERIOD", 5, currentLoginUser.getCompanyGuid());
        return new LongResponseResult("get sucess", Long.valueOf(rtnValue));
    }

    @RequestMapping(value={"/get_recent_password_repetitions"}, method={RequestMethod.GET})
    public LongResponseResult getRecentPasswordRepetitions() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        long rtnValue = this.companyGlobalInfoService.getValueByKeyWithDefault("RECENT_PASSWORD_REPETITION", 4, currentLoginUser.getCompanyGuid());
        return new LongResponseResult("get sucess", Long.valueOf(rtnValue));
    }

    @RequestMapping(value={"/get_is_force_change_password"}, method={RequestMethod.GET})
    public BooleanResponseResult getIsForceChangePassword() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        if (this.companyGlobalInfoService.getStringByKeyWithDefault("FORCE_CHANGE_PASSWORD", SystemConstantProperties.DEFAULT_FORCE_CHANGE_PASSWORD, currentLoginUser.getCompanyGuid()).compareToIgnoreCase(Boolean.TRUE.toString()) == 0) {
            return new BooleanResponseResult("get sucess", Boolean.valueOf(true));
        }
        return new BooleanResponseResult("get sucess", Boolean.valueOf(false));
    }

    @RequestMapping(value={"/get_autoLock_unactive_days"}, method={RequestMethod.GET})
    public LongResponseResult getAutoLockUnactiveDays() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        long rtnValue = this.companyGlobalInfoService.getValueByKeyWithDefault("AUTO_LOCK_UNACTIVE_DAYS", 14, currentLoginUser.getCompanyGuid());
        return new LongResponseResult("get sucess", Long.valueOf(rtnValue));
    }

    @RequestMapping(value={"/get_change_password_period"}, method={RequestMethod.GET})
    public LongResponseResult getChangePasswordPeriod() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        long rtnValue = this.companyGlobalInfoService.getValueByKeyWithDefault("CHANGE_PASSWORD_PERIOD", 90, currentLoginUser.getCompanyGuid());
        return new LongResponseResult("get sucess", Long.valueOf(rtnValue));
    }

    @RequestMapping(value={"/get_is_reject_locked_account_login"}, method={RequestMethod.GET})
    public BooleanResponseResult getIsRejectLockedAccountLogin() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        if (this.companyGlobalInfoService.getStringByKeyWithDefault("REJECT_LOCKED_ACCOUNT_LOGIN", SystemConstantProperties.DEFAULT_REJECT_LOCKED_ACCOUNT_LOGIN, currentLoginUser.getCompanyGuid()).compareToIgnoreCase(Boolean.TRUE.toString()) == 0) {
            return new BooleanResponseResult("get sucess", Boolean.valueOf(true));
        }
        return new BooleanResponseResult("get sucess", Boolean.valueOf(false));
    }

    @RequestMapping(value={"/get_is_auto_lock_unactive"}, method={RequestMethod.GET})
    public BooleanResponseResult getIsAutoLockUnactive() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        if (this.companyGlobalInfoService.getStringByKeyWithDefault("AUTO_LOCK_UNACTIVE", SystemConstantProperties.DEFAULT_AUTO_LOCK_UNACTIVE, currentLoginUser.getCompanyGuid()).compareToIgnoreCase(Boolean.TRUE.toString()) == 0) {
            return new BooleanResponseResult("get sucess", Boolean.valueOf(true));
        }
        return new BooleanResponseResult("get sucess", Boolean.valueOf(false));
    }
}

