/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.DatabaseCreationTime;
import com.penpower.worldcard.team.Utils.DatabaseCreationTimeUtil;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.NetworkUtil;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.auth.TokenInfo;
import com.penpower.worldcard.team.config.property.ApplicationProperties;
import com.penpower.worldcard.team.config.property.SystemConstantProperties;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.LoginCode;
import com.penpower.worldcard.team.dto.LoginInfo;
import com.penpower.worldcard.team.entity.ForgetPasswordSession;
import com.penpower.worldcard.team.entity.Globalinfocompany;
import com.penpower.worldcard.team.entity.Loginfailedlinfo;
import com.penpower.worldcard.team.enums.AccountLockCase;
import com.penpower.worldcard.team.enums.AccountLockedIssue;
import com.penpower.worldcard.team.enums.AccountType;
import com.penpower.worldcard.team.enums.FailureType;
import com.penpower.worldcard.team.enums.LanguageCode;
import com.penpower.worldcard.team.enums.LicenseMode;
import com.penpower.worldcard.team.enums.LoginFailureOption;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.Platform;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.enums.TokenStatus;
import com.penpower.worldcard.team.enums.UserRole;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.enums.VerifySource;
import com.penpower.worldcard.team.exception.AccessWithUnbindingDeviceOrNotAllowedIpException;
import com.penpower.worldcard.team.exception.ActiveDirectoryInvalidCredentialsException;
import com.penpower.worldcard.team.exception.AuthenticationFailedException;
import com.penpower.worldcard.team.exception.DifferentTimeException;
import com.penpower.worldcard.team.exception.ForgetPasswordTokenNotValidException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.LdapRuntimeException;
import com.penpower.worldcard.team.exception.LicenseNeedToReactiveException;
import com.penpower.worldcard.team.exception.LoginFailureLockedException;
import com.penpower.worldcard.team.exception.LoginWithNotAllowedDeviceOrPlatformException;
import com.penpower.worldcard.team.exception.LoginWithUnbindingDeviceException;
import com.penpower.worldcard.team.exception.LowSystemMemoryInstalledException;
import com.penpower.worldcard.team.exception.MailConnectionException;
import com.penpower.worldcard.team.exception.MaxFailureCountExceededException;
import com.penpower.worldcard.team.exception.PasswordChangeException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.exception.SpecifiedGuidConflictException;
import com.penpower.worldcard.team.exception.SubscriptionLockedException;
import com.penpower.worldcard.team.exception.TokenInvalidException;
import com.penpower.worldcard.team.exception.TokenNotFoundException;
import com.penpower.worldcard.team.exception.UnActiveExpiredLockedException;
import com.penpower.worldcard.team.mail.ForgetPasswordMailInfoBuilder;
import com.penpower.worldcard.team.mail.MailInfo;
import com.penpower.worldcard.team.mail.PasswordChangedMailInfoBuilder;
import com.penpower.worldcard.team.mail.PurchaseLicensedMailInfoBuilder;
import com.penpower.worldcard.team.notice.content.AccountLockedCasebyLoginFailureContent;
import com.penpower.worldcard.team.service.AccountSecurityService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.ForgetPasswordSessionService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.LoginfailedlinfoService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.SubscriptionService;
import com.penpower.worldcard.team.service.SystemSettingService;
import com.penpower.worldcard.team.service.TokenService;
import com.penpower.worldcard.team.web.api.LoginController;
import com.penpower.worldcard.team.web.api.login.AccountSecurityRuleHandler;
import com.penpower.worldcard.team.web.api.login.AccountVerifyRuleHandler;
import com.penpower.worldcard.team.web.api.login.LocalTimeRuleHandler;
import com.penpower.worldcard.team.web.api.login.LoginRuleHandler;
import com.penpower.worldcard.team.web.api.login.LoginRuntimeInfo;
import com.penpower.worldcard.team.web.api.login.LoginTokenPlatformRuleHandler;
import com.penpower.worldcard.team.web.api.login.LowSystemMemoryRuleHandler;
import com.penpower.worldcard.team.web.api.login.ReactiveLicenseRuleHandler;
import com.penpower.worldcard.team.web.api.vo.CaptchaInfo;
import com.penpower.worldcard.team.web.api.vo.LicenseVo;
import com.penpower.worldcard.team.web.api.vo.LoginFailureCountExceeded;
import com.penpower.worldcard.team.web.api.vo.LoginVo;
import com.penpower.worldcard.team.web.api.vo.PurchaseLiceneseInfo;
import com.penpower.worldcard.team.web.api.vo.response.CaptchaInfoResponseReault;
import com.penpower.worldcard.team.web.api.vo.response.LoginResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.TokenInfoResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.mail.internet.MimeMessage;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Hours;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailSendException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/auth"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"authentication"}, description="authentication operation")
public class LoginController {
    private static final Logger LOG = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private TokenService tokenService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private RegistryService registryService;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private LoginfailedlinfoService loginfailedlinfoService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private SystemSettingService databaseSystemSettingService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private DatabaseCreationTimeUtil databaseCreationTimeUtil;
    @Autowired
    private JavaMailSender javaMailSender;
    @Autowired
    private ForgetPasswordSessionService forgetPasswordSessionService;
    @Autowired
    private AccountSecurityService accountSecurityService;

    @ApiOperation(value="Login", notes="\u4ee5\u5e33\u865f/\u5bc6\u78bc\u767b\u5165,\u53d6\u56de\u547c\u53ebAPI\u6240\u9700\u7684token\u7b49\u8cc7\u8a0a.<BR><BR> clientLocalTime : \u50b3\u5165\u547c\u53eb\u7aef\u7684\u76ee\u524d\u6642\u9593(\u5b57\u4e32\u683c\u5f0f\u70ba yyyy-MM-dd HH:mm:ss.SSS)<BR> deviceId/deviceName : \u7528\u4f86\u767b\u5165\u7684\u88dd\u7f6eId/Name(\u82e5\u5e73\u53f0\u70baWEB\uff0c\u5247\u5169\u8005\u90fd\u4e0d\u9700\u8981)<BR> email/password : \u7528\u4f86\u767b\u5165\u7684email/password<BR> platform : \u547c\u53ebAPI\u7684\u5e73\u53f0")
    @ApiResponses(value={@ApiResponse(code=470, message="Other ldap runtime exception occurs."), @ApiResponse(code=477, message="Indicates that during a bind operation one of the following occurred:<BR>The client passed either an incorrect DN or password,<BR>or the password is incorrect because it has expired,<BR>intruder detection has locked the account, or another similar reason."), @ApiResponse(code=478, message="Indicates that the LDAP server is too busy to process the client request at this time<BR>but if the client waits and resubmits the request,<BR>the server may be able to process it then."), @ApiResponse(code=479, message="Indicates that the LDAP server cannot process the client's bind request,<BR>usually because it is shutting down."), @ApiResponse(code=472, message="Indicates an Active Directory (AD) AcceptSecurityContext error, <BR>which is returned when the username is valid<BR>but the combination of password and user credential is invalid. "), @ApiResponse(code=473, message="Indicates an Active Directory (AD) AcceptSecurityContext data error<BR> that is returned when the username is invalid."), @ApiResponse(code=474, message="Indicates an Active Directory (AD) AcceptSecurityContext data error that is a logon failure.<BR>The specified account password has expired.<BR>Returns only when presented with valid username and password credential."), @ApiResponse(code=475, message="Indicates an Active Directory (AD) AcceptSecurityContext data error that is a logon failure.<BR>The user's account has expired.<BR>Returns only when presented with valid username and password credential."), @ApiResponse(code=476, message="Indicates an Active Directory (AD) AcceptSecurityContext data error.<BR>The user's password must be changed before logging on the first time.<BR>Returns only when presented with valid user-name and password credential."), @ApiResponse(code=471, message="Fail to connect to AD server."), @ApiResponse(code=401, message="Authentication failed.<BR>"), @ApiResponse(code=429, message="Server license is fail"), @ApiResponse(code=427, message="Not enough physical memory.(lower than 4G)"), @ApiResponse(code=461, message="client and server time different value was larger than server value."), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=482, message="Login with unbinding device or platform"), @ApiResponse(code=424, message="Max count limit is reached."), @ApiResponse(code=485, message="Subscription mode service locked."), @ApiResponse(code=488, message="Login lock case by failure"), @ApiResponse(code=489, message="Unactive account Exipred lock case by failure")})
    @RequestMapping(value={"/login_with_ad"}, method={RequestMethod.POST})
    public LoginResponseResult login(@RequestBody @Valid LoginVo loginVO, HttpServletRequest request, HttpServletResponse response) {
        String email = loginVO.getEmail();
        String password = loginVO.getPassword();
        DateTime clientLocalTime = loginVO.getClientLocalTime();
        Platform platform = loginVO.getPlatform();
        String deviceId = loginVO.getDeviceId();
        String deviceName = loginVO.getDeviceName();
        DateTime serverTime = DateTime.now();
        ServerType serverType = this.registryService.GetServerType();
        String remoteIpaddress = NetworkUtil.getClientIp((HttpServletRequest)request);
        LOG.debug("try to login , email : {} ,  remoteIpaddress :{} ", (Object)email, (Object)remoteIpaddress);
        AccountInfo account = null;
        try {
            account = this.accountService.getAccountInfo(null, email);
            if (account.getRole() != UserRole.ADMIN) {
                switch (1.$SwitchMap$com$penpower$worldcard$team$enums$AccountLockedIssue[account.getLockedIssue().ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        throw new UnActiveExpiredLockedException("Account is locked");
                    }
                    case 3: {
                        throw new LoginFailureLockedException("Account is locked");
                    }
                    case 4: {
                        throw new SubscriptionLockedException("Account is locked");
                    }
                }
            }
        }
        catch (ItemNotFoundException ex) {
            throw new AuthenticationFailedException(ex.getMessage());
        }
        this.checkFailureCountExceededforPreCheck(email, remoteIpaddress, FailureType.LOGIN, account.getCompanyGuid());
        LicenseVo lv = this.databaseSystemSettingService.GetLicense(account.getCompanyGuid());
        LOG.debug("login license mode={}  ", (Object)lv);
        LoginRuntimeInfo loginRuntimeInfo = new LoginRuntimeInfo(email, password, lv, clientLocalTime, platform, deviceId, deviceName, remoteIpaddress, serverTime, serverType);
        LOG.debug("login license loginRuntimeInfo={}  ", (Object)loginRuntimeInfo);
        LowSystemMemoryRuleHandler loginConditionHandler = new LowSystemMemoryRuleHandler((LoginRuleHandler)new LocalTimeRuleHandler((LoginRuleHandler)new AccountVerifyRuleHandler((LoginRuleHandler)new AccountSecurityRuleHandler((LoginRuleHandler)new LoginTokenPlatformRuleHandler(null)))));
        try {
            loginConditionHandler.doCheck(loginRuntimeInfo);
        }
        catch (AuthenticationFailedException | DifferentTimeException | LdapRuntimeException | LicenseNeedToReactiveException ex) {
            LOG.debug("login check excpetion={}", (Object)ex.getClass().toString());
            this.loginfailedlinfoService.increaseFailureCount(remoteIpaddress, email, FailureType.LOGIN);
            this.checkFailureCountExceededaftercheck(email, remoteIpaddress, FailureType.LOGIN, account.getCompanyGuid());
            if (ex.getClass() == AuthenticationFailedException.class || ex.getClass() == ActiveDirectoryInvalidCredentialsException.class) {
                if (account.getLockedIssue() != AccountLockedIssue.NO_ISSUE && account.getRole() == UserRole.ADMIN) {
                    switch (1.$SwitchMap$com$penpower$worldcard$team$enums$AccountLockedIssue[account.getLockedIssue().ordinal()]) {
                        default: {
                            throw new LoginFailureLockedException("Account is locked");
                        }
                        case 4: {
                            throw new SubscriptionLockedException("Account is locked");
                        }
                        case 2: 
                    }
                    throw new UnActiveExpiredLockedException("Account is locked");
                }
                throw ex;
            }
            throw ex;
        }
        catch (LoginWithUnbindingDeviceException e) {
            throw new LoginWithNotAllowedDeviceOrPlatformException(e.getMessage());
        }
        catch (LowSystemMemoryInstalledException e) {
            LOG.debug("LowSystemMemoryInstalledException msg={} serverType={}", (Object)e.getMessage(), (Object)this.registryService.GetServerType());
            throw e;
        }
        catch (AccessWithUnbindingDeviceOrNotAllowedIpException e) {
            LOG.debug(e.getMessage());
            if (e.getMessage().contains("platform")) {
                throw new LoginWithNotAllowedDeviceOrPlatformException(e.getMessage());
            }
            throw e;
        }
        if (account.getRole() != UserRole.ADMIN) {
            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$AccountLockedIssue[account.getLockedIssue().ordinal()]) {
                default: {
                    break;
                }
                case 3: {
                    throw new LoginFailureLockedException("Account is locked");
                }
                case 4: {
                    throw new SubscriptionLockedException("Account is locked");
                }
                case 2: {
                    throw new UnActiveExpiredLockedException("Account is locked");
                }
            }
        }
        LOG.debug("login check success ");
        DateTime databaseCreateTime = this.ReadDBCreateTimeFromSettingFile();
        Optional<String> Referer = Optional.ofNullable(request.getHeader("Referer"));
        String hostName = "";
        if (Referer.isPresent()) {
            try {
                URL aURL = new URL(Referer.get());
                hostName = aURL.getHost();
            }
            catch (MalformedURLException aURL) {
                // empty catch block
            }
        }
        TokenInfo token = this.tokenService.createNewTokenWithPlatformAndIpAndDeviceId(account.getGuid(), platform, remoteIpaddress, deviceId, hostName);
        Globalinfocompany globalinfocompany = this.companyGlobalInfoService.getPropertiesByKey("SERVER_ID", account.getCompanyGuid());
        String serverId = globalinfocompany.getConfigValue();
        LoginInfo loginInfo = new LoginInfo(serverId, token, account, serverTime, databaseCreateTime);
        LOG.debug("loginInfo : {} ", (Object)loginInfo);
        this.loginfailedlinfoService.resetIpAddressLimit(remoteIpaddress, email, FailureType.LOGIN);
        loginInfo.setServerStatus(this.subscriptionService.getServerStatus(account.getGuid()));
        loginInfo.setIsNeedChangePassword(false);
        if (account.getStatus() == UserStatus.INACTIVE) {
            if (account.getAccountType() == AccountType.AD) {
                loginInfo.setIsNeedChangePassword(false);
                this.accountService.setAccountUserStatus(account.getGuid(), UserStatus.ACTIVE);
                loginInfo.getAccountInfo().setStatus(UserStatus.ACTIVE);
            } else {
                loginInfo.setIsNeedChangePassword(true);
            }
        } else if (account.getAccountType() == AccountType.LOCAL) {
            if (this.companyGlobalInfoService.getStringByKeyWithDefault("FORCE_CHANGE_PASSWORD", SystemConstantProperties.DEFAULT_FORCE_CHANGE_PASSWORD, account.getCompanyGuid()).compareToIgnoreCase(Boolean.TRUE.toString()) == 0) {
                int changePasswordPeriod = this.companyGlobalInfoService.getValueByKeyWithDefault("CHANGE_PASSWORD_PERIOD", 90, account.getCompanyGuid());
                if (account.getLastPasswordChangeTime() != null && account.getLastPasswordChangeTime().plusDays(changePasswordPeriod).isBeforeNow()) {
                    loginInfo.setIsNeedChangePassword(true);
                }
            }
        } else {
            loginInfo.setIsNeedChangePassword(false);
        }
        if (loginInfo.getServerStatus().getSubscriptionStatus() != null && account.getRole() == UserRole.ADMIN) {
            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$SubscriptionStatus[loginInfo.getServerStatus().getSubscriptionStatus().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    try {
                        LOG.debug("download subscriptioninfo");
                        this.subscriptionService.DownloadSubscriptionInfo(account.getCompanyGuid());
                        loginInfo.setServerStatus(this.subscriptionService.getServerStatus(account.getGuid()));
                        break;
                    }
                    catch (Exception e) {
                        LOG.debug("Login download subscription info exception", (Throwable)e);
                    }
                }
            }
        }
        LoginResponseResult result = new LoginResponseResult("Login succeeded.", loginInfo);
        if (lv.getLicenseMode() == LicenseMode.BUYOUT) {
            LoginCode loginCode = this.registryService.getLoginCode();
            result.setLoginCode(loginCode);
        } else {
            result.setLoginCode(this.registryService.getfakeLoginCode());
        }
        return result;
    }

    @RequestMapping(value={"/purchase_license"}, method={RequestMethod.POST})
    @ApiOperation(value="", notes="\u5bc4\u9001\u52a0\u8cfc\u6388\u6b0a\u7684\u4fe1\u4ef6")
    @ApiResponses(value={@ApiResponse(code=435, message="Fail to send mail."), @ApiResponse(code=436, message="Fail to connection to SMPT server."), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    public MessageResponseResult purchaseLicense(@RequestBody @Valid PurchaseLiceneseInfo purchaseLiceneseInfo) {
        JavaMailSenderImpl javaMailSenderImpl = (JavaMailSenderImpl)this.javaMailSender;
        try {
            javaMailSenderImpl.testConnection();
        }
        catch (Exception ex) {
            LOG.error("fail to test mail connection.....", (Throwable)ex);
            throw new MailConnectionException(ex.getMessage(), (Throwable)ex);
        }
        try {
            PurchaseLicensedMailInfoBuilder mailInfoBuilder = new PurchaseLicensedMailInfoBuilder(purchaseLiceneseInfo.getSenderName(), purchaseLiceneseInfo.getSenderMail(), purchaseLiceneseInfo.getSenderPhone(), purchaseLiceneseInfo.getSenderRequirement(), purchaseLiceneseInfo.getLanguageCode());
            MailInfo purchaseLicenseMailInfo = mailInfoBuilder.createMailInfo();
            MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, false, "UTF-8");
            helper.setTo(purchaseLiceneseInfo.getReceiverMail());
            helper.setFrom(purchaseLiceneseInfo.getSenderMail());
            helper.setSubject(purchaseLicenseMailInfo.getMailSubject());
            mimeMessage.setContent((Object)purchaseLicenseMailInfo.getStringMailBody(), "text/html;charset=utf-8");
            this.javaMailSender.send(mimeMessage);
        }
        catch (Exception ex) {
            LOG.error("Fail to send mail ", (Throwable)ex);
            throw new MailSendException("Fail to send purchase license mail....", (Throwable)ex);
        }
        MessageResponseResult result = new MessageResponseResult(String.format("The purchase licnese requirement mail has been send to %s.", purchaseLiceneseInfo.getReceiverMail()), "");
        return result;
    }

    private void checkFailureCountExceededforPreCheck(String email, String remoteIpaddress, FailureType failureType, String companyGuid) {
        String loginFailureOptionString = this.companyGlobalInfoService.getStringByKeyWithDefault("LOGIN_FAILURE_OPTION", SystemConstantProperties.DEFAULT_DELAY_LOGIN, companyGuid);
        LoginFailureOption loginFailureOption = LoginFailureOption.valueOf((String)loginFailureOptionString);
        if (loginFailureOption == LoginFailureOption.DELAY_LOGIN) {
            int maxFailureCountExceeded = this.loginfailedlinfoService.maxFailureCountexceeded(remoteIpaddress, email, failureType, companyGuid);
            if (maxFailureCountExceeded >= 0) {
                Loginfailedlinfo loginfailedlinfo = this.loginfailedlinfoService.getLoginfailedlinfo(remoteIpaddress, email, failureType);
                DateTime lastFailureTime = loginfailedlinfo.getLastfailuretime();
                DateTime now = new DateTime();
                Duration duration = new Duration((ReadableInstant)lastFailureTime, (ReadableInstant)now);
                long differentMinutes = duration.getStandardMinutes();
                int loginFailureCountlimit = this.companyGlobalInfoService.getValueByKeyWithDefault("LOGIN_FAILURE_COUNT_LIMIT", 5, companyGuid);
                int loginFailureBlockPeriod = this.companyGlobalInfoService.getValueByKeyWithDefault("LOGIN_FAILURE_BLOCK_PERIOD", 5, companyGuid);
                LOG.debug("checkFailureCountExceededforDelayLogin  lastFailureTime{}, nOW= {},differentMinutes = {} loginFailureBlockPeriod ={}", new Object[]{lastFailureTime, DateTime.now(), differentMinutes, loginFailureBlockPeriod});
                if (differentMinutes <= (long)loginFailureBlockPeriod) {
                    LoginFailureCountExceeded loginFailureCountExceeded = new LoginFailureCountExceeded();
                    loginFailureCountExceeded.setEmail(email);
                    loginFailureCountExceeded.setLoginFailureBlockPeriod(loginFailureBlockPeriod);
                    loginFailureCountExceeded.setLoginFailureCountlimit(loginFailureCountlimit);
                    loginFailureCountExceeded.setRemoteIpaddress(remoteIpaddress);
                    String loginFailureCountExceededString = GlobalUtils.getJsonString((Object)loginFailureCountExceeded);
                    throw new MaxFailureCountExceededException(loginFailureCountExceededString, loginFailureCountExceeded);
                }
            }
        } else {
            AccountInfo accountInfo = this.accountService.getAccountInfo(null, email);
            if (accountInfo.getLockedIssue() == AccountLockedIssue.LOGIN_FAIL && accountInfo.getRole() != UserRole.ADMIN) {
                throw new LoginFailureLockedException("Account is locked");
            }
        }
    }

    private void checkFailureCountExceededaftercheck(String email, String remoteIpaddress, FailureType failureType, String companyGuid) {
        String loginFailureOptionString = this.companyGlobalInfoService.getStringByKeyWithDefault("LOGIN_FAILURE_OPTION", SystemConstantProperties.DEFAULT_DELAY_LOGIN, companyGuid);
        LoginFailureOption loginFailureOption = LoginFailureOption.valueOf((String)loginFailureOptionString);
        if (loginFailureOption == LoginFailureOption.AUTO_LOCK_ACCOUNT) {
            AccountInfo accountInfo = this.accountService.getAccountInfo(null, email);
            int maxFailureCountExceeded = this.loginfailedlinfoService.maxFailureCountexceeded(remoteIpaddress, email, failureType, companyGuid);
            if (maxFailureCountExceeded >= 0) {
                Loginfailedlinfo loginfailedlinfo = this.loginfailedlinfoService.getLoginfailedlinfo(remoteIpaddress, email, failureType);
                if (accountInfo != null && (accountInfo.getLockedIssue() != AccountLockedIssue.LOGIN_FAIL || maxFailureCountExceeded == 0)) {
                    String AccountLockedCasebyLoginFailureContentString = GlobalUtils.getJsonString((Object)new AccountLockedCasebyLoginFailureContent(loginfailedlinfo.getGuid(), loginfailedlinfo.getUseraccount(), loginfailedlinfo.getFailurecount(), loginfailedlinfo.getLastfailuretime()));
                    LOG.debug("checkFailureCountExceededforAutoLock AccountLockedCasebyLoginFailureContent ={}", (Object)AccountLockedCasebyLoginFailureContentString);
                    this.noticeService.addSystemNoticeToAdmin(NotifyCategory.SYSTEM, NotifyType.ACCOUNT_LOCKBY_LOGIN_FAILURE, AccountLockedCasebyLoginFailureContentString, accountInfo.getCompanyGuid());
                    LOG.debug("LOGIN FAIL LOCK ACCOUNT= : {} ", (Object)email);
                    this.tokenService.setUserTokensInvalid(accountInfo.getGuid(), "");
                }
                this.accountService.setAccountLockissue(email, AccountLockedIssue.LOGIN_FAIL, AccountLockCase.PASSWORD_FAILURE);
            }
        }
    }

    private void checkFailureCountExceeded(String email, String remoteIpaddress, FailureType failureType, String companyGuid) {
        int maxFailureCountExceeded = this.loginfailedlinfoService.maxFailureCountexceeded(remoteIpaddress, email, failureType, companyGuid);
        LOG.debug("maxFailureCountExceeded : {} ", (Object)maxFailureCountExceeded);
        if (maxFailureCountExceeded >= 0) {
            String loginFailureOptionString = this.companyGlobalInfoService.getStringByKeyWithDefault("LOGIN_FAILURE_OPTION", SystemConstantProperties.DEFAULT_DELAY_LOGIN, companyGuid);
            LoginFailureOption loginFailureOption = LoginFailureOption.valueOf((String)loginFailureOptionString);
            Loginfailedlinfo loginfailedlinfo = this.loginfailedlinfoService.getLoginfailedlinfo(remoteIpaddress, email, failureType);
            if (loginFailureOption == LoginFailureOption.DELAY_LOGIN) {
                DateTime lastFailureTime = loginfailedlinfo.getLastfailuretime();
                DateTime now = new DateTime();
                Duration duration = new Duration((ReadableInstant)lastFailureTime, (ReadableInstant)now);
                long differentMinutes = duration.getStandardMinutes();
                int loginFailureCountlimit = this.companyGlobalInfoService.getValueByKeyWithDefault("LOGIN_FAILURE_COUNT_LIMIT", 5, companyGuid);
                int loginFailureBlockPeriod = this.companyGlobalInfoService.getValueByKeyWithDefault("LOGIN_FAILURE_BLOCK_PERIOD", 5, companyGuid);
                LOG.debug("checkFailureCountExceeded  lastFailureTime{}, nOW= {},differentMinutes = {} loginFailureBlockPeriod ={}", new Object[]{lastFailureTime, DateTime.now(), differentMinutes, loginFailureBlockPeriod});
                if (differentMinutes <= (long)loginFailureBlockPeriod) {
                    LoginFailureCountExceeded loginFailureCountExceeded = new LoginFailureCountExceeded();
                    loginFailureCountExceeded.setEmail(email);
                    loginFailureCountExceeded.setLoginFailureBlockPeriod(loginFailureBlockPeriod);
                    loginFailureCountExceeded.setLoginFailureCountlimit(loginFailureCountlimit);
                    loginFailureCountExceeded.setRemoteIpaddress(remoteIpaddress);
                    String loginFailureCountExceededString = GlobalUtils.getJsonString((Object)loginFailureCountExceeded);
                    throw new MaxFailureCountExceededException(loginFailureCountExceededString, loginFailureCountExceeded);
                }
                this.loginfailedlinfoService.resetIpAddressLimit(remoteIpaddress, email, failureType);
                LOG.debug("LOGIN FAIL DELAY ACCOUNT= : {} ", (Object)email);
            } else {
                AccountInfo accountInfo = this.accountService.getAccountInfo(null, email);
                if (accountInfo != null && (accountInfo.getLockedIssue() != AccountLockedIssue.LOGIN_FAIL || maxFailureCountExceeded == 0)) {
                    String AccountLockedCasebyLoginFailureContentString = GlobalUtils.getJsonString((Object)new AccountLockedCasebyLoginFailureContent(loginfailedlinfo.getGuid(), loginfailedlinfo.getUseraccount(), loginfailedlinfo.getFailurecount(), loginfailedlinfo.getLastfailuretime()));
                    LOG.debug("checkFailureCountExceeded AccountLockedCasebyLoginFailureContent ={}", (Object)AccountLockedCasebyLoginFailureContentString);
                    this.noticeService.addNewNoticeToAllUsers(NotifyCategory.SYSTEM, NotifyType.ACCOUNT_LOCKBY_LOGIN_FAILURE, AccountLockedCasebyLoginFailureContentString, loginfailedlinfo.getGuid(), accountInfo.getCompanyGuid());
                    LOG.debug("LOGIN FAIL LOCK ACCOUNT= : {} ", (Object)email);
                }
                this.accountService.setAccountLockissue(email, AccountLockedIssue.LOGIN_FAIL, AccountLockCase.PASSWORD_FAILURE);
            }
        }
    }

    private DateTime ReadDBCreateTimeFromSettingFile() {
        if (!this.databaseCreationTimeUtil.IsSettingFileExist()) {
            DatabaseCreationTime newDatabaseCreationTime = new DatabaseCreationTime();
            newDatabaseCreationTime.setCreationTime(new DateTime());
            this.databaseCreationTimeUtil.writeCreationTime(newDatabaseCreationTime);
        }
        DatabaseCreationTime databaseCreationTime = this.databaseCreationTimeUtil.readDatabaseCreationTime();
        return databaseCreationTime.getCreationTime();
    }

    @ApiOperation(value="Login", notes="\u4ee5\u5e33\u865f/\u5bc6\u78bc\u767b\u5165,\u53d6\u56de\u547c\u53ebAPI\u6240\u9700\u7684token\u7b49\u8cc7\u8a0a.<BR><BR> clientLocalTime : \u50b3\u5165\u547c\u53eb\u7aef\u7684\u76ee\u524d\u6642\u9593(\u5b57\u4e32\u683c\u5f0f\u70ba yyyy-MM-dd HH:mm:ss.SSS)<BR> deviceId/deviceName : \u7528\u4f86\u767b\u5165\u7684\u88dd\u7f6eId/Name(\u82e5\u5e73\u53f0\u70baWEB\uff0c\u5247\u5169\u8005\u90fd\u4e0d\u9700\u8981)<BR> email/password : \u7528\u4f86\u767b\u5165\u7684email/password<BR> platform : \u547c\u53ebAPI\u7684\u5e73\u53f0")
    @ApiResponses(value={@ApiResponse(code=401, message="Authentication failed.<BR>"), @ApiResponse(code=461, message="client and server time different value was larger than server value."), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=424, message="Max count limit is reached.")})
    @RequestMapping(value={"/login2"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public LoginResponseResult login2(@RequestParam String email, @RequestParam String password, HttpServletRequest request, HttpServletResponse response) {
        String remoteIpaddress = NetworkUtil.getClientIp((HttpServletRequest)request);
        LOG.debug("try to login , email : {} ,  remoteIpaddress :{} ", (Object)email, (Object)remoteIpaddress);
        AccountInfo account = this.accountService.getAccountInfo(null, email);
        LOG.debug("account & password verify succeeded.... search accountInfo : {} ", (Object)account);
        try {
            this.accountService.verifyAccount(null, email);
        }
        catch (ItemNotFoundException ex) {
            this.loginfailedlinfoService.increaseFailureCount(remoteIpaddress, email, FailureType.LOGIN);
            this.checkFailureCountExceeded(email, remoteIpaddress, FailureType.LOGIN, account.getCompanyGuid());
            throw new AuthenticationFailedException(String.format("Login failed, Account[%s] not found", email));
        }
        boolean passwordCorrect = this.accountService.verifyPassword(null, email, password);
        if (!passwordCorrect) {
            this.loginfailedlinfoService.increaseFailureCount(remoteIpaddress, email, FailureType.LOGIN);
            this.checkFailureCountExceeded(email, remoteIpaddress, FailureType.LOGIN, account.getCompanyGuid());
            throw new AuthenticationFailedException(String.format("Failed to login User[%s] password not correct..", email));
        }
        UserStatus status = account.getStatus();
        boolean validUser = SecurityUtils.validUser((UserStatus)status);
        if (!validUser) {
            this.loginfailedlinfoService.increaseFailureCount(remoteIpaddress, email, FailureType.LOGIN);
            this.checkFailureCountExceeded(email, remoteIpaddress, FailureType.LOGIN, account.getCompanyGuid());
            throw new AuthenticationFailedException(String.format("Failed to login , user status was not ACTIVE or INACTIVE. , status : %s ", status.toString()));
        }
        if (account.getRole() != UserRole.ADMIN) {
            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$AccountLockedIssue[account.getLockedIssue().ordinal()]) {
                case 1: {
                    break;
                }
                case 3: {
                    throw new LoginFailureLockedException("Account is locked");
                }
                case 4: {
                    throw new SubscriptionLockedException("Account is locked");
                }
                case 2: {
                    throw new UnActiveExpiredLockedException("Account is locked");
                }
            }
        }
        String deviceId = "";
        String deviceName = "";
        this.accountSecurityService.verifyPlatformAndDevice(deviceId, deviceName, Platform.WEB);
        DateTime databaseCreateTime = new DateTime(2018, 6, 14, 12, 0, 0, 0);
        DateTime serverTime = DateTime.now();
        this.accountSecurityService.createNewLoginRecord(account.getGuid(), deviceId, deviceName, Platform.WEB, serverTime);
        this.accountSecurityService.verifyAccountSecurity(VerifySource.LOGIN, account.getGuid(), remoteIpaddress, deviceId, deviceName, Platform.WEB, DateTime.now());
        this.accountSecurityService.updateLoginTimeForBackupRestoreRecord(account.getGuid(), deviceId, serverTime);
        Optional<String> Referer = Optional.ofNullable(request.getHeader("Referer"));
        String hostName = "";
        if (Referer.isPresent()) {
            try {
                URL aURL = new URL(Referer.get());
                hostName = aURL.getHost();
            }
            catch (MalformedURLException aURL) {
                // empty catch block
            }
        }
        TokenInfo token = this.tokenService.createNewTokenWithPlatformAndIpAndDeviceId(account.getGuid(), Platform.WEB, remoteIpaddress, deviceId, hostName);
        Globalinfocompany globalinfocompany = this.companyGlobalInfoService.getPropertiesByKey("SERVER_ID", account.getCompanyGuid());
        String serverId = globalinfocompany.getConfigValue();
        LicenseVo lv = this.databaseSystemSettingService.GetLicense(account.getCompanyGuid());
        LoginInfo loginInfo = new LoginInfo(serverId, token, account, serverTime, databaseCreateTime);
        LOG.debug("loginInfo : {} ", (Object)loginInfo);
        this.loginfailedlinfoService.resetIpAddressLimit(remoteIpaddress, email, FailureType.LOGIN);
        loginInfo.setServerStatus(this.subscriptionService.getServerStatus(account.getGuid()));
        LoginCode loginCode = this.registryService.getLoginCode();
        LoginResponseResult result = new LoginResponseResult("Login succeeded.", loginInfo);
        if (lv.getLicenseMode() == LicenseMode.BUYOUT) {
            result.setLoginCode(loginCode);
        } else {
            result.setLoginCode(this.registryService.getfakeLoginCode());
        }
        return result;
    }

    @ApiOperation(value="", notes="\u91cd\u7f6etoken\u7684expired & invalid time ")
    @ApiResponses(value={@ApiResponse(code=401, message="Authentication failed.<BR>"), @ApiResponse(code=429, message="Server license is fail"), @ApiResponse(code=461, message="Invalid token<BR>"), @ApiResponse(code=485, message="Subscription mode service locked.")})
    @RequestMapping(value={"/refreshToken"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public TokenInfoResponseResult refreshToken(@RequestParam(value="token") String token, HttpServletRequest request, HttpServletResponse response) {
        TokenInfo tokenInfo = null;
        try {
            TokenStatus tokenStatus = this.tokenService.getTokenStatus(token);
            LOG.debug("check tokenStatus(before) , token:{} ,  status:{} ", (Object)token, (Object)tokenStatus);
            if (TokenStatus.INVALID.equals((Object)tokenStatus)) {
                throw new TokenInvalidException("Failed to refresh token , token[{}] status was invalid.");
            }
            String userGuid = this.tokenService.getUserGuid(token);
            AccountInfo accountInfo = this.accountService.getAccountInfo(userGuid, null);
            LOG.debug("check tokenStatus(after) , token:{} ,  status:{} ", (Object)token, (Object)tokenStatus);
            LicenseVo lv = this.databaseSystemSettingService.GetLicense(accountInfo.getCompanyGuid());
            ServerType serverType = this.registryService.GetServerType();
            LoginRuntimeInfo loginRuntimeInfo = new LoginRuntimeInfo(accountInfo.getEmail(), null, lv, null, null, null, null, null, null, serverType);
            ReactiveLicenseRuleHandler loginConditionHandler = new ReactiveLicenseRuleHandler(null);
            loginConditionHandler.doCheck(loginRuntimeInfo);
            TokenInfo tokeninfo = this.tokenService.getTokenInfo(token);
            tokenInfo = this.tokenService.refreshTokenWithIpAndDeviceId(token, userGuid, tokeninfo.getHostname());
        }
        catch (TokenNotFoundException ex) {
            throw new AuthenticationFailedException(String.format("Can't refresh token , token[%s] was not found.", token));
        }
        TokenInfoResponseResult result = new TokenInfoResponseResult("Token refresh succeeded.", tokenInfo);
        return result;
    }

    @ApiOperation(value="Logout", notes="Form post\u767b\u51faapi, \u4f7f\u7528conten-type\u70ba application/x-www-form-urlencoded")
    @ApiResponses(value={@ApiResponse(code=401, message="Authentication failed.<BR>")})
    @RequestMapping(value={"/logout"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult logout(@RequestParam(value="token") String token) {
        try {
            this.tokenService.removeToken(token);
        }
        catch (TokenNotFoundException ex) {
            throw new AuthenticationFailedException(String.format("Can't remove token , token[%s] was not found.", token));
        }
        MessageResponseResult result = new MessageResponseResult(String.format("Logout succeeded. token[%s] has been removed.", token), "");
        return result;
    }

    @RequestMapping(value={"/getCaptcha"}, method={RequestMethod.GET})
    public CaptchaInfoResponseReault getCaptcha(HttpServletRequest req) throws ServletException, IOException {
        int i;
        int iTotalChars = 6;
        int iHeight = 38;
        int iWidth = 160;
        Font fntStyle1 = new Font("Arial", 1, 30);
        Random randChars = new Random();
        String sImageCode = Long.toString(Math.abs(randChars.nextLong()), 36).substring(0, iTotalChars);
        String guid = UUIDGenerator.getRandomUUID();
        LOG.debug("getCaptcha Imagecode={} GUID={}", (Object)sImageCode, (Object)guid);
        BufferedImage biImage = new BufferedImage(iWidth, iHeight, 1);
        Graphics2D g2dImage = (Graphics2D)biImage.getGraphics();
        g2dImage.setPaint(new Color(220, 220, 220));
        g2dImage.fillRect(0, 0, biImage.getWidth(), biImage.getHeight());
        int iCircle = 15;
        for (i = 0; i < iCircle; ++i) {
            g2dImage.setColor(new Color(randChars.nextInt(255), randChars.nextInt(255), randChars.nextInt(255)));
        }
        g2dImage.setFont(fntStyle1);
        for (i = 0; i < iTotalChars; ++i) {
            g2dImage.setColor(new Color(randChars.nextInt(255), randChars.nextInt(255), randChars.nextInt(255)));
            if (i % 2 == 0) {
                g2dImage.drawString(sImageCode.substring(i, i + 1), 25 * i, 24);
                continue;
            }
            g2dImage.drawString(sImageCode.substring(i, i + 1), 25 * i, 35);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)biImage, "jpeg", baos);
        baos.flush();
        byte[] imageInByte = baos.toByteArray();
        baos.close();
        g2dImage.dispose();
        this.forgetPasswordSessionService.addCaptcha(sImageCode, guid);
        String imageBase64 = Base64.encodeBase64String((byte[])imageInByte);
        LOG.debug("getCaptcha imageBase64={}", (Object)imageBase64);
        CaptchaInfo captchaInfo = new CaptchaInfo(guid, imageBase64);
        CaptchaInfoResponseReault captchaInfoResponseReault = new CaptchaInfoResponseReault("get captcha", captchaInfo);
        return captchaInfoResponseReault;
    }

    @ApiOperation(value="", notes="\u5bc4\u9001\u5fd8\u8a18\u5bc6\u78bc\u7684\u4fe1\u4ef6\u7d66\u6307\u5b9a\u7684\u4f7f\u7528\u8005")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>"), @ApiResponse(code=435, message="Fail to send mail."), @ApiResponse(code=436, message="Fail to connection to SMPT server."), @ApiResponse(code=404, message="Account not found."), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=424, message="Max count limit is reached."), @ApiResponse(code=490, message="Captcha check fail.<BR>"), @ApiResponse(code=401, message="Authentication failed.<BR>")})
    @RequestMapping(value={"/forgetPassword"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult forgetPassword(@RequestParam(value="email") String email, @RequestParam(value="languageCode") LanguageCode languageCode, @RequestParam(value="securityKey") String securityKey, @RequestParam(value="CaptchaCode") String CaptchaCode, HttpServletRequest request, HttpServletResponse response) {
        LOG.debug("getCaptcha CaptchaCode={} securityKey={}", (Object)CaptchaCode, (Object)securityKey);
        String ImageCode = this.forgetPasswordSessionService.getCaptcha(securityKey);
        if (StringUtil.IsStringNullorEmpty((String)ImageCode)) {
            throw new RequestArgumentNotValidException("token is invalidate");
        }
        LOG.debug("getCaptcha ImageCode={} ", (Object)ImageCode);
        if (ImageCode.compareToIgnoreCase(CaptchaCode) != 0) {
            throw new SpecifiedGuidConflictException("Captcha check  fail");
        }
        String remoteIpaddress = NetworkUtil.getClientIp((HttpServletRequest)request);
        AccountInfo accountInfo = null;
        try {
            accountInfo = this.accountService.getAccountInfo(null, email);
            this.checkFailureCountExceeded(email, remoteIpaddress, FailureType.FORGET_PASSWORD, accountInfo.getCompanyGuid());
        }
        catch (ItemNotFoundException | RequestArgumentNotValidException e) {
            this.loginfailedlinfoService.increaseFailureCount(remoteIpaddress, email, FailureType.FORGET_PASSWORD);
            throw e;
        }
        AccountType accountType = accountInfo.getAccountType();
        if (AccountType.AD.equals((Object)accountType)) {
            throw new AccessDeniedException("Can't use forget password feature with AD account type.");
        }
        try {
            boolean validStatus;
            UserStatus accountStatus = accountInfo.getStatus();
            boolean bl = validStatus = UserStatus.ACTIVE.equals((Object)accountStatus) || UserStatus.INACTIVE.equals((Object)accountStatus);
            if (!validStatus) {
                throw new RuntimeException("Account status is " + accountStatus.toString());
            }
            ForgetPasswordSession session = this.forgetPasswordSessionService.createNewSession(email);
            String requestUrl = request.getRequestURL().toString();
            String requestUri = request.getRequestURI().toString();
            String rootUrl = requestUrl.replaceAll(requestUri, "");
            JavaMailSenderImpl javaMailSenderImpl = (JavaMailSenderImpl)this.javaMailSender;
            try {
                javaMailSenderImpl.testConnection();
            }
            catch (Exception ex) {
                LOG.error("fail to test mail connection.....", (Throwable)ex);
                throw new MailConnectionException(ex.getMessage(), (Throwable)ex);
            }
            LOG.debug("rootUrl  : {} ", (Object)rootUrl);
            String resetPasswordUrl = String.format("%s/reset-password-redirect/index.html?account_email=%s&token=%s", rootUrl, email, session.getToken());
            ForgetPasswordMailInfoBuilder mailInfoBuilder = new ForgetPasswordMailInfoBuilder(accountInfo.getName(), resetPasswordUrl, languageCode);
            MailInfo forgetPasswordMailInfo = mailInfoBuilder.createMailInfo();
            LOG.debug("Check mail info : \n {}", (Object)forgetPasswordMailInfo);
            MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, false, "UTF-8");
            helper.setTo(email);
            helper.setFrom("WorldCard Team Service<wctservice@mail.worldcardteam.com>");
            helper.setSubject(forgetPasswordMailInfo.getMailSubject());
            mimeMessage.setContent((Object)forgetPasswordMailInfo.getStringMailBody(), "text/html;charset=utf-8");
            this.javaMailSender.send(mimeMessage);
            MimeMessage dkimSignedMessage = GlobalUtils.getDkimSignMessage((MimeMessage)mimeMessage);
            this.javaMailSender.send(dkimSignedMessage);
        }
        catch (Exception ex) {
            LOG.error("Fail to send mail ", (Throwable)ex);
            throw new MailSendException("Fail to send forgetpassword mail....", (Throwable)ex);
        }
        this.forgetPasswordSessionService.delCaptcha(securityKey);
        this.loginfailedlinfoService.resetIpAddressLimit(remoteIpaddress, email, FailureType.FORGET_PASSWORD);
        MessageResponseResult result = new MessageResponseResult(String.format("The reset password URL has been send to %s.", email), "");
        return result;
    }

    @ApiOperation(value="", notes="\u5fd8\u8a18\u5bc6\u78bc\u5c0e\u5f15\u7684URL\u6703\u547c\u53eb\u6b64API\u4f86\u91cd\u8a2d\u5bc6\u78bc")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>"), @ApiResponse(code=423, message="Invalid forget password token."), @ApiResponse(code=416, message="new password cannot be same as the old password."), @ApiResponse(code=404, message="Account not found."), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=424, message="Max count limit is reached."), @ApiResponse(code=401, message="Authentication failed.<BR>")})
    @RequestMapping(value={"/resetPassword"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult resetPassword(@RequestParam(value="email") String email, @RequestParam(value="token") String token, @RequestParam(value="newPassword") String newPassword, HttpServletRequest request, HttpServletResponse response) {
        String remoteIpaddress = NetworkUtil.getClientIp((HttpServletRequest)request);
        LOG.debug("resetPassword email : {} ,  newPassword :{} ", (Object)email, (Object)newPassword);
        AccountInfo accountInfo = null;
        try {
            accountInfo = this.accountService.getAccountInfo(null, email);
            this.checkFailureCountExceeded(email, remoteIpaddress, FailureType.FORGET_PASSWORD, accountInfo.getCompanyGuid());
        }
        catch (ItemNotFoundException | RequestArgumentNotValidException e) {
            this.loginfailedlinfoService.increaseFailureCount(remoteIpaddress, email, FailureType.FORGET_PASSWORD);
            throw e;
        }
        AccountType accountType = accountInfo.getAccountType();
        if (AccountType.AD.equals((Object)accountType)) {
            throw new AccessDeniedException("Can't reset password with AD account type.");
        }
        ForgetPasswordSession session = this.forgetPasswordSessionService.getLatestSession(email);
        if (session == null) {
            this.loginfailedlinfoService.increaseFailureCount(remoteIpaddress, email, FailureType.FORGET_PASSWORD);
            throw new ItemNotFoundException("No forget password item found , token not exists.");
        }
        if (!session.getToken().equals(token)) {
            this.loginfailedlinfoService.increaseFailureCount(remoteIpaddress, email, FailureType.FORGET_PASSWORD);
            throw new ForgetPasswordTokenNotValidException("Invalid forget password token.");
        }
        DateTime sessionCreationTime = session.getCreateDate();
        Hours hours = Hours.hoursBetween((ReadableInstant)sessionCreationTime, (ReadableInstant)DateTime.now());
        if (hours.getHours() >= 24) {
            throw new ForgetPasswordTokenNotValidException("Invalid forget password token. token was timeout.");
        }
        String accountGuid = accountInfo.getGuid();
        LOG.debug("resetPassword accountGuid email : {} ,  newPassword :{} ", (Object)email, (Object)newPassword);
        this.accountService.checkPasswordValidate(newPassword);
        boolean IsPasswordInHistory = this.accountService.IsPasswordInHistory(accountGuid, null, newPassword);
        LOG.debug("resetPassword IsPasswordInHistory : {}  ", (Object)IsPasswordInHistory);
        if (IsPasswordInHistory) {
            throw new PasswordChangeException("new password supplied is the same as the previous password.");
        }
        this.accountService.changePassword(accountGuid, null, newPassword);
        this.removeAllForgetPasswordSessionQuiet(email);
        this.loginfailedlinfoService.resetIpAddressLimit(remoteIpaddress, email, FailureType.FORGET_PASSWORD);
        LOG.debug("reset_password account info mail=" + accountInfo.getEmail());
        JavaMailSenderImpl javaMailSenderImpl = (JavaMailSenderImpl)this.javaMailSender;
        try {
            javaMailSenderImpl.testConnection();
        }
        catch (Exception ex) {
            LOG.error("fail to test mail connection.....", (Throwable)ex);
            throw new MailConnectionException(ex.getMessage(), (Throwable)ex);
        }
        LOG.debug("reset_password after mail test");
        try {
            PasswordChangedMailInfoBuilder mailInfoBuilder = new PasswordChangedMailInfoBuilder(accountInfo.getName());
            LOG.debug("reset_password after mail 1");
            MailInfo PasswordChangedMailInfo = mailInfoBuilder.createMailInfo();
            LOG.debug("\"reset_password after mail \n {}", (Object)PasswordChangedMailInfo);
            MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, false, "UTF-8");
            LOG.debug("reset_password after mail 2");
            helper.setTo(accountInfo.getEmail());
            helper.setFrom("WorldCard Team Service<wctservice@mail.worldcardteam.com>");
            LOG.debug("reset_password after mail 3");
            helper.setSubject(PasswordChangedMailInfo.getMailSubject());
            mimeMessage.setContent((Object)PasswordChangedMailInfo.getStringMailBody(), "text/html;charset=utf-8");
            LOG.debug("reset_password after mail 4");
            this.javaMailSender.send(mimeMessage);
            MimeMessage dkimSignedMessage = GlobalUtils.getDkimSignMessage((MimeMessage)mimeMessage);
            this.javaMailSender.send(dkimSignedMessage);
            LOG.debug("reset_password after mail 5");
        }
        catch (Exception ex) {
            LOG.error("Fail to send PasswordChanged mail ", (Throwable)ex);
            throw new MailSendException("Fail to send PasswordChanged mail....", (Throwable)ex);
        }
        LOG.debug("reset_password after mail 6");
        MessageResponseResult result = new MessageResponseResult(String.format("account[%s] password has been reset and changed to new password.", email), "");
        return result;
    }

    @ApiOperation(value="", notes="\u5fd8\u8a18\u5bc6\u78bc\u5c0e\u5f15\u7684URL\u6703\u547c\u53eb\u6b64API\u4f86\u91cd\u8a2d\u5bc6\u78bc")
    @ApiResponses(value={@ApiResponse(code=423, message="Invalid forget password token."), @ApiResponse(code=404, message="Account not found."), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=424, message="Max count limit is reached."), @ApiResponse(code=401, message="Authentication failed.<BR>")})
    @RequestMapping(value={"/verify_forget_password_token"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult verifyForgetPasswordToken(@RequestParam(value="email") String email, @RequestParam(value="token") String token, HttpServletRequest request, HttpServletResponse response) {
        String remoteIpaddress = NetworkUtil.getClientIp((HttpServletRequest)request);
        AccountInfo accountInfo = this.accountService.getAccountInfo(null, email);
        this.checkFailureCountExceeded(email, remoteIpaddress, FailureType.FORGET_PASSWORD, accountInfo.getCompanyGuid());
        try {
            this.accountService.verifyAccount(null, email);
        }
        catch (ItemNotFoundException | RequestArgumentNotValidException e) {
            this.loginfailedlinfoService.increaseFailureCount(remoteIpaddress, email, FailureType.FORGET_PASSWORD);
            throw e;
        }
        ForgetPasswordSession session = this.forgetPasswordSessionService.getLatestSession(email);
        if (session == null) {
            this.loginfailedlinfoService.increaseFailureCount(remoteIpaddress, email, FailureType.FORGET_PASSWORD);
            throw new ItemNotFoundException("No forget password item found , token not exists.");
        }
        if (!session.getToken().equals(token)) {
            this.loginfailedlinfoService.increaseFailureCount(remoteIpaddress, email, FailureType.FORGET_PASSWORD);
            throw new ForgetPasswordTokenNotValidException("Invalid forget password token.");
        }
        DateTime sessionCreationTime = session.getCreateDate();
        Hours hours = Hours.hoursBetween((ReadableInstant)sessionCreationTime, (ReadableInstant)DateTime.now());
        if (hours.getHours() >= 24) {
            throw new ForgetPasswordTokenNotValidException("Invalid forget password token. token was timeout.");
        }
        this.loginfailedlinfoService.resetIpAddressLimit(remoteIpaddress, email, FailureType.FORGET_PASSWORD);
        MessageResponseResult result = new MessageResponseResult(String.format("valid forget password token.", email), "");
        return result;
    }

    private void removeAllForgetPasswordSessionQuiet(String email) {
        try {
            this.forgetPasswordSessionService.removeAllSession(email);
        }
        catch (Exception ex) {
            LOG.warn("remove all forgetpassword session by email failed.", (Throwable)ex);
        }
    }
}

