/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.config.property.ApplicationProperties;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/log"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"log"}, description="modify log properties")
@PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE) and (hasAuthority('ADMIN'))")
public class LogController {
    @Autowired
    private ApplicationProperties applicationProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="", notes="\u958b\u555f/\u95dc\u9589log\u6bcf\u500bcontroller\u7684\u57f7\u884c\u6642\u9593\u7684flag")
    @ApiResponses(value={@ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/change_log_performance_flag"}, method={RequestMethod.POST})
    public MessageResponseResult setIdentificationResultSetting(@RequestParam(required=true) boolean enable) {
        LogController logController = this;
        synchronized (logController) {
            this.applicationProperties.updateProperty("LOG_ENABLE", String.valueOf(enable));
        }
        MessageResponseResult response = new MessageResponseResult(String.format("Update log performance flag succeeded.", new Object[0]), "new status is : " + enable);
        return response;
    }
}

