/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.ldap.ActiveDirectoryAccountInfo;
import com.penpower.worldcard.team.ldap.ActiveDirectoryUtils;
import com.penpower.worldcard.team.web.api.vo.ActiveDirectoryInfo;
import com.penpower.worldcard.team.web.api.vo.response.ListResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/ldap"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"Ldap_Operations"}, description="LDAP & AD \u76f8\u95dc\u7684\u8cc7\u6599\u64cd\u4f5capi")
@PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE) and (hasAuthority('ADMIN'))")
public class LdapController {
    private static final Logger LOG = LoggerFactory.getLogger(LdapController.class);

    @ApiOperation(value="getAllAdAccounts", notes="\u53d6\u5f97\u6240\u6709AD\u7684Account\u6e05\u55ae. <BR><BR>USER ROLE\u5fc5\u9700\u70baADMIN")
    @ApiResponses(value={@ApiResponse(code=470, message="Other ldap runtime exception occurs."), @ApiResponse(code=477, message="Indicates that during a bind operation one of the following occurred:<BR>The client passed either an incorrect DN or password,<BR>or the password is incorrect because it has expired,<BR>intruder detection has locked the account, or another similar reason."), @ApiResponse(code=478, message="Indicates that the LDAP server is too busy to process the client request at this time<BR>but if the client waits and resubmits the request,<BR>the server may be able to process it then."), @ApiResponse(code=479, message="Indicates that the LDAP server cannot process the client's bind request,<BR>usually because it is shutting down."), @ApiResponse(code=472, message="Indicates an Active Directory (AD) AcceptSecurityContext error, <BR>which is returned when the username is valid<BR>but the combination of password and user credential is invalid. "), @ApiResponse(code=473, message="Indicates an Active Directory (AD) AcceptSecurityContext data error<BR> that is returned when the username is invalid."), @ApiResponse(code=474, message="Indicates an Active Directory (AD) AcceptSecurityContext data error that is a logon failure.<BR>The specified account password has expired.<BR>Returns only when presented with valid username and password credential."), @ApiResponse(code=475, message="Indicates an Active Directory (AD) AcceptSecurityContext data error that is a logon failure.<BR>The user's account has expired.<BR>Returns only when presented with valid username and password credential."), @ApiResponse(code=476, message="Indicates an Active Directory (AD) AcceptSecurityContext data error.<BR>The user's password must be changed before logging on the first time.<BR>Returns only when presented with valid user-name and password credential."), @ApiResponse(code=471, message="Fail to connect to AD server."), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_ad_accounts"}, method={RequestMethod.POST})
    public ListResponseResult<ActiveDirectoryAccountInfo> getActiveDirectoryAccounts(@RequestBody @Valid ActiveDirectoryInfo activeDirectoryInfo) {
        LOG.debug("activeDirectoryInfo : {}", (Object)activeDirectoryInfo);
        ActiveDirectoryUtils activeDirectoryUtils = null;
        try {
            activeDirectoryUtils = new ActiveDirectoryUtils(activeDirectoryInfo);
        }
        catch (Exception ex) {
            LOG.error("Invalid ad import params.", (Throwable)ex);
            throw new RequestArgumentNotValidException("Invalid ad import params.", (Throwable)ex);
        }
        String accountNameLocalPart = this.getLocalPartName(activeDirectoryInfo.getLoginAccount());
        LOG.debug("accountNameLocalPart : {} ", (Object)accountNameLocalPart);
        activeDirectoryUtils.authenticate(accountNameLocalPart, activeDirectoryInfo.getLoginPassword());
        List allActiveDirectoryAccounts = activeDirectoryUtils.getAllUserAccountNames();
        LOG.debug("allActiveDirectoryAccounts : {}", (Object)allActiveDirectoryAccounts);
        ListResponseResult result = new ListResponseResult("Retrive all acive directory account names succeeded.", allActiveDirectoryAccounts);
        return result;
    }

    private String getLocalPartName(String loginAccount) {
        String[] localPartSplit = loginAccount.split("@");
        return localPartSplit[0];
    }
}

