/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.ContactSimpleInfoDto;
import com.penpower.worldcard.team.entity.Globalinfocompany;
import com.penpower.worldcard.team.enums.ContactField;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.enums.ShareRule;
import com.penpower.worldcard.team.enums.UserRole;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.MaxCountExceededContactOwningException;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CategoryService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.ContactPublicService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.web.api.vo.AccountBeSharedByOneContact;
import com.penpower.worldcard.team.web.api.vo.AccountShareContactToMe;
import com.penpower.worldcard.team.web.api.vo.ContactGetByAccountVo;
import com.penpower.worldcard.team.web.api.vo.ContactGetByCategoryAndOwnerVo;
import com.penpower.worldcard.team.web.api.vo.ContactNumberOfCategoriesRequest;
import com.penpower.worldcard.team.web.api.vo.ContactShareAccountVo;
import com.penpower.worldcard.team.web.api.vo.ContactsSetOwnerVo;
import com.penpower.worldcard.team.web.api.vo.GuidWithData;
import com.penpower.worldcard.team.web.api.vo.IntervalFilter;
import com.penpower.worldcard.team.web.api.vo.PageInfo;
import com.penpower.worldcard.team.web.api.vo.response.BasicResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.ListResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.PageResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contact/public"}, produces={"application/json;charset=UTF-8"}, method={RequestMethod.POST})
@Api(tags={"contact/public"})
@PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE)")
public class ContactPublicController {
    private final Logger LOG = LoggerFactory.getLogger(ContactPublicController.class);
    @Autowired
    private ContactPublicService contactPublicService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private RegistryService registryService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private CategoryService categoryService;
    @Value(value="${AdminCanViewAll}")
    private String AdminCanViewAll;

    @RequestMapping(value={"/set_owner_of_contacts"})
    @PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE) and (hasAuthority('ADMIN'))")
    @ApiOperation(value="", notes="\u8a2d\u5b9a\u540d\u7247\u7684OWNER.<BR>Response Model\u88e1,\u5305\u542b\u56de\u50b3\u7684\u8a0a\u606f,\u4ee5\u53ca\u4e00\u500b\u8a2d\u5b9a\u5931\u6557\u7684\u540d\u7247\u5217\u8868. \u5217\u8868\u88e1\u6bcf\u4e00\u500b\u9805\u76ee,\u662f\u8a72\u5931\u6557\u540d\u7247\u7684guid,\u53ca\u5176\u932f\u8aa4\u63cf\u8ff0. <BR>\u63cf\u8ff0\u5206\u5169\u7a2e,\u6d41\u7a0b\u4e0a\u53ef\u77e5\u539f\u56e0\u7684\u70ba\u932f\u8aa4\u78bc,\u610f\u5916\u539f\u56e0\u7684\u5247\u70ba\u932f\u8aa4\u5b57\u4e32. \u53ef\u77e5\u539f\u56e0\u7684\u932f\u8aa4\u78bc\u6709\u4ee5\u4e0b\u5e7e\u500b:<BR>404 : Item not found<BR>426 : Max count limit of contact owning is reached.")
    public ListResponseResult<GuidWithData<String>> setOwnerOfContacts(@RequestBody @Valid ContactsSetOwnerVo vo) {
        String accountGuid = vo.getNewOwnerAccountGuid();
        List contactGuids = vo.getContactGuids();
        this.contactPrivateService.verifyContactGuids(contactGuids);
        this.accountService.verifyAccount(accountGuid, null);
        ArrayList<GuidWithData> failedList = new ArrayList<GuidWithData>();
        String returnMessage = "set owner of contacts success.";
        for (String contactGuid : contactGuids) {
            try {
                this.contactPrivateService.setContactToNewOwnerAndShareToOriginOwner(contactGuid, accountGuid);
            }
            catch (Exception e) {
                GuidWithData fail = new GuidWithData(contactGuid, (Object)e.getMessage());
                if (e instanceof ItemNotFoundException) {
                    fail.setData((Object)String.valueOf(HttpStatus.NOT_FOUND.value()));
                } else if (e instanceof MaxCountExceededContactOwningException) {
                    fail.setData((Object)String.valueOf(426));
                }
                failedList.add(fail);
                returnMessage = "Some contacts fail to change owner.";
            }
        }
        return new ListResponseResult(returnMessage, failedList);
    }

    @RequestMapping(value={"/get_download_status_of_shared_contacts"})
    public ListResponseResult<GuidWithData<Boolean>> getDownloadStatusOfSharedContacts(@RequestBody List<String> contactGuids) {
        this.contactPrivateService.verifyContactGuids(contactGuids);
        AccountInfo loginAccount = SecurityUtils.getCurrentLoginUser();
        List downloadStatuses = this.contactPublicService.getDownloadStatusOfContactsByAccount(loginAccount.getGuid(), contactGuids);
        ListResponseResult result = new ListResponseResult("Get download status of shared contacts success.", downloadStatuses);
        return result;
    }

    @RequestMapping(value={"/get_shared_status_of_all_accounts_for_private_contact"})
    public ListResponseResult<AccountBeSharedByOneContact> getShareStatusOfAllAccountsByOneContact(@RequestParam String contactGuid) {
        this.contactPrivateService.verifyContactGuids(Arrays.asList(contactGuid));
        AccountInfo myAccount = SecurityUtils.getCurrentLoginUser();
        List accountStatuses = this.accountService.getAccountsByStatus(myAccount.getCompanyGuid(), new UserStatus[]{UserStatus.ACTIVE, UserStatus.INACTIVE, UserStatus.RESIGNED}).stream().map(a -> new AccountBeSharedByOneContact(a)).collect(Collectors.toList());
        List accountGuidsShared = this.contactPublicService.getAccountGuidsSharedByContact(contactGuid);
        accountStatuses.stream().filter(s -> accountGuidsShared.contains(s.getAccountGuid())).forEach(s -> s.setBeShared(true));
        String ownerAccountGuid = this.contactPrivateService.getOwnerGuidByContact(contactGuid);
        accountStatuses.stream().filter(s -> s.getAccountGuid().equals(ownerAccountGuid)).forEach(s -> s.setBeOwner(true));
        List bossGuids = this.accountService.getAllBossGuids(ownerAccountGuid);
        accountStatuses.stream().filter(s -> bossGuids.contains(s.getAccountGuid())).forEach(s -> s.setBeBoss(true));
        List subordinateGuids = this.accountService.getAllSubordinateGuids(ownerAccountGuid);
        accountStatuses.stream().filter(s -> subordinateGuids.contains(s.getAccountGuid())).forEach(s -> s.setBeSubordinate(true));
        ListResponseResult result = new ListResponseResult("Get shared status of all accounts for one private contact success.", accountStatuses);
        return result;
    }

    private AccountShareContactToMe createContactSharedAccountsInfo(AccountInfo accountInfo, Long sharedContactCount) {
        AccountShareContactToMe sharedAccountsInfo = new AccountShareContactToMe(accountInfo);
        sharedAccountsInfo.setSharedContactCount(sharedContactCount.intValue());
        return sharedAccountsInfo;
    }

    public boolean GetAdminCanViewAll() {
        this.LOG.debug("AdminCanViewAll={}", (Object)this.AdminCanViewAll);
        if (StringUtil.IsStringNullorEmpty((String)this.AdminCanViewAll)) {
            this.LOG.debug("AdminCanViewAll = TRUE");
            return true;
        }
        if (StringUtil.Compare((String)this.AdminCanViewAll, (String)"FALSE") == 0) {
            this.LOG.debug("AdminCanViewAll = FALSE");
            return false;
        }
        this.LOG.debug("AdminCanViewAll = TRUE");
        return true;
    }

    public boolean isAdmin(AccountInfo user) {
        Globalinfocompany globalinfocompany = this.companyGlobalInfoService.getPropertiesByKey("SHARE_RULE", user.getCompanyGuid());
        if (ShareRule.ALL.equals((Object)ShareRule.valueOf((String)globalinfocompany.getConfigValue())) || UserRole.ADMIN.equals((Object)user.getRole()) && this.GetAdminCanViewAll()) {
            this.LOG.debug("isAdmin = TRUE");
            return true;
        }
        this.LOG.debug("isAdmin = FALSE");
        return false;
    }

    @RequestMapping(value={"/get_accounts_share_to_me"})
    public ListResponseResult<AccountShareContactToMe> getAccountsShareToMe() {
        ServerType svrType = this.registryService.GetServerType();
        this.LOG.debug("get_accounts_share_to_me 1");
        AccountInfo myAccount = SecurityUtils.getCurrentLoginUser();
        this.LOG.debug("get_accounts_share_to_me 1a");
        String myAccountGuid = myAccount.getGuid();
        this.LOG.debug("get_accounts_share_to_me 1b");
        List subordinateGuids = this.accountService.getAllSubordinateGuids(myAccountGuid);
        this.LOG.debug("get_accounts_share_to_me 1c");
        if (!CollectionUtils.isEmpty((Collection)subordinateGuids)) {
            subordinateGuids = subordinateGuids.stream().distinct().collect(Collectors.toList());
            this.LOG.debug("get_accounts_share_to_me 1d");
        }
        this.LOG.debug("get_accounts_share_to_me 2");
        ArrayList<Object> shareAccountInfos = new ArrayList<Object>();
        IntervalFilter intervalFilter = GlobalUtils.checkIntervalFilter(null);
        this.LOG.debug("get_accounts_share_to_me 3");
        Long contactNum = 0L;
        contactNum = !GlobalUtils.IsCloudServerType((ServerType)svrType) ? this.contactPrivateService.getContactNumOwnedByAccount(myAccountGuid, intervalFilter) : Long.valueOf(-1L);
        AccountShareContactToMe sAcct = this.createContactSharedAccountsInfo(myAccount, contactNum);
        shareAccountInfos.add(0, sAcct);
        this.LOG.debug("get_accounts_share_to_me 4");
        for (String subGuid : subordinateGuids) {
            Object accountInfo;
            if (!GlobalUtils.IsCloudServerType((ServerType)svrType)) {
                contactNum = this.contactPrivateService.getContactNumOwnedByAccount(subGuid, intervalFilter);
                if (contactNum <= 0L) continue;
                accountInfo = this.accountService.getAccountInfo(subGuid, null);
                sAcct = this.createContactSharedAccountsInfo((AccountInfo)accountInfo, contactNum);
                sAcct.setBeSubordinate(true);
                shareAccountInfos.add(sAcct);
                continue;
            }
            accountInfo = this.accountService.getAccountInfo(subGuid, null);
            sAcct = this.createContactSharedAccountsInfo((AccountInfo)accountInfo, Long.valueOf(-1L));
            sAcct.setBeSubordinate(true);
            shareAccountInfos.add(sAcct);
        }
        this.LOG.debug("get_accounts_share_to_me 5");
        ArrayList canViewAccountGuids = new ArrayList(subordinateGuids);
        canViewAccountGuids.add(myAccountGuid);
        this.LOG.debug("get_accounts_share_to_me 6");
        if (this.isAdmin(myAccount)) {
            List allAccounts = this.accountService.getAccountsByStatus(myAccount.getCompanyGuid(), new UserStatus[]{UserStatus.ACTIVE, UserStatus.RESIGNED, UserStatus.INACTIVE});
            this.LOG.debug("get_accounts_share_to_me allAccountsa ={}", (Object)allAccounts);
            for (AccountInfo accountInfo : allAccounts) {
                if (canViewAccountGuids.contains(accountInfo.getGuid())) continue;
                if (!GlobalUtils.IsCloudServerType((ServerType)svrType)) {
                    contactNum = this.contactPrivateService.getContactNumOwnedByAccount(accountInfo.getGuid(), intervalFilter);
                    if (contactNum <= 0L) continue;
                    sAcct = this.createContactSharedAccountsInfo(accountInfo, contactNum);
                    shareAccountInfos.add(sAcct);
                    continue;
                }
                sAcct = this.createContactSharedAccountsInfo(accountInfo, Long.valueOf(-1L));
                shareAccountInfos.add(sAcct);
            }
        } else {
            Map accountSet = this.contactPublicService.getAccountsShareToAccounts(canViewAccountGuids, intervalFilter);
            List<Object> filteredAccountInfos = new ArrayList();
            filteredAccountInfos = !GlobalUtils.IsCloudServerType((ServerType)svrType) ? accountSet.entrySet().stream().filter(s -> !canViewAccountGuids.contains(((AccountInfo)s.getKey()).getGuid())).map(s -> this.createContactSharedAccountsInfo((AccountInfo)s.getKey(), (Long)s.getValue())).collect(Collectors.toList()) : accountSet.entrySet().stream().filter(s -> !canViewAccountGuids.contains(((AccountInfo)s.getKey()).getGuid())).map(s -> this.createContactSharedAccountsInfo((AccountInfo)s.getKey(), Long.valueOf(-1L))).collect(Collectors.toList());
            shareAccountInfos.addAll(filteredAccountInfos);
        }
        List bossGuids = this.accountService.getAllBossGuids(myAccountGuid);
        this.LOG.debug("get_accounts_share_to_me bossGuids ={}", (Object)bossGuids);
        this.LOG.debug("get_accounts_share_to_me shareAccountInfos a ={}", shareAccountInfos);
        shareAccountInfos.stream().filter(a -> bossGuids.contains(a.getAccountGuid())).forEach(a -> a.setBeBoss(true));
        this.LOG.debug("get_accounts_share_to_me shareAccountInfos b={}", shareAccountInfos);
        ListResponseResult result = new ListResponseResult("Get account list share to me success", shareAccountInfos);
        this.LOG.debug("get_accounts_share_to_me 9");
        return result;
    }

    @RequestMapping(value={"/get_contact_number_shared_by_all"})
    public BasicResponseResult<Long, Object> getContactNumberSharedByAll() {
        AccountInfo myAccount = SecurityUtils.getCurrentLoginUser();
        String myAccountGuid = myAccount.getGuid();
        Long contactNum = 0L;
        contactNum = this.isAdmin(myAccount) ? this.contactPrivateService.getContactNumByAll(myAccount.getCompanyGuid()) : this.contactPublicService.countContactsAllIcanView(myAccountGuid);
        return new BasicResponseResult("Get shared contact number by all success.", (Object)contactNum);
    }

    @ApiOperation(notes="\u53d6\u5f97\u516c\u6709\u5340\u88e1,\u67d0\u5e33\u865f\u6240\u64c1\u6709\u4e26\u4e14\u6709\u5206\u4eab\u7d66\u6211,\u4f46\u537b\u4e0d\u5728\u4ed6\u7684\u79c1\u6709\u5340\u88e1\u7684\u540d\u7247\u6578\u91cf.", value="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/get_contact_number_shared_by_account_uncategory"})
    public BasicResponseResult<Long, Object> getContactNumberSharedByAccountButNotInHisPrivate(@RequestParam String accountGuid) {
        AccountInfo myAccount = SecurityUtils.getCurrentLoginUser();
        Long contactNum = 0L;
        contactNum = this.canViewAllShares(accountGuid, myAccount) ? this.contactPrivateService.getContactNumUncategoryByContactOwner(accountGuid) : this.contactPrivateService.getContactNumUncategoryByContactOwnerAndAccountCanView(accountGuid, myAccount.getGuid());
        return new BasicResponseResult("Get shared contact number uncategory by account success.", (Object)contactNum);
    }

    @ApiOperation(notes="\u50b3\u5165\u516c\u6709\u5340\u88e1\u7684\u985e\u5225guid\u5217\u8868,\u53d6\u56de\u9019\u4e9b\u985e\u5225\u88e1\u7684\u540d\u7247\u6578\u91cf.", value="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/get_contact_number_shared_by_categories"})
    public ListResponseResult<GuidWithData<Long>> getContactNumberOfSharedCategories(@RequestBody ContactNumberOfCategoriesRequest vo) {
        String categoryOwnerGuid = vo.getCategoryOwnerGuid();
        List categoryGuids = vo.getCategoryGuids();
        List filteredCategoryGuids = this.categoryService.filterOutCategoryGuidsExist(categoryGuids);
        AccountInfo myAccount = SecurityUtils.getCurrentLoginUser();
        ArrayList<GuidWithData> result = new ArrayList<GuidWithData>();
        if (this.canViewAllShares(categoryOwnerGuid, myAccount)) {
            for (String categoryGuid : filteredCategoryGuids) {
                Long contactNum = this.contactPrivateService.getContactNumByCategoryAndContactOwner(categoryGuid, categoryOwnerGuid);
                result.add(new GuidWithData(categoryGuid, (Object)contactNum));
            }
        } else {
            for (String categoryGuid : filteredCategoryGuids) {
                Long contactNum = this.contactPrivateService.getContactNumByCategoryAndContactOwnerAndAccountCanView(categoryGuid, categoryOwnerGuid, myAccount.getGuid());
                result.add(new GuidWithData(categoryGuid, (Object)contactNum));
            }
        }
        return new ListResponseResult("Get contact number of categories success.", result);
    }

    private PageResult<ContactSimpleInfoDto> getSharedContactsOfAccount_ALL(String shareAccountGuid, PageInfo<ContactField> pageInfo, IntervalFilter intervalFilter, String companyGuid) {
        this.LOG.debug("getSharedContactsOfAccount_ALL shareAccountGuid={}", (Object)shareAccountGuid);
        if (shareAccountGuid == null) {
            return this.contactPrivateService.getSimpleContactsByAll(pageInfo, intervalFilter, companyGuid);
        }
        return this.contactPrivateService.getSimpleContactsOwnedByAccount(shareAccountGuid, pageInfo, intervalFilter);
    }

    private PageResult<ContactSimpleInfoDto> getSharedContactsOfAccount_BY_SETTING(String myAccountGuid, String shareAccountGuid, PageInfo<ContactField> pageInfo, IntervalFilter intervalFilter) {
        this.LOG.debug("getSharedContactsOfAccount_BY_SETTING myAccountGuid = {} shareAccountGuid ={}", (Object)myAccountGuid, (Object)shareAccountGuid);
        AccountInfo myAccount = SecurityUtils.getCurrentLoginUser();
        List subordinateGuids = this.accountService.getAllSubordinateGuids(myAccountGuid);
        this.LOG.debug("getSharedContactsOfAccount_BY_SETTING subordinateGuids = {} ", (Object)subordinateGuids);
        if (shareAccountGuid == null) {
            return this.contactPublicService.getContactsAllIcanView(myAccountGuid, pageInfo, intervalFilter);
        }
        if (subordinateGuids.stream().anyMatch(a -> a.equals(shareAccountGuid))) {
            return this.contactPrivateService.getSimpleContactsOwnedByAccount(shareAccountGuid, pageInfo, intervalFilter);
        }
        if (shareAccountGuid.equals(myAccountGuid)) {
            return this.contactPrivateService.getSimpleContactsOwnedByAccount(myAccountGuid, pageInfo, intervalFilter);
        }
        return this.contactPublicService.getContactsSharedByAccount(myAccountGuid, shareAccountGuid, pageInfo, intervalFilter);
    }

    @RequestMapping(value={"/get_shared_contacts_of_account"})
    public PageResponseResult<ContactSimpleInfoDto> getSharedContactsOfAccount(@RequestBody @Valid ContactGetByAccountVo vo) {
        this.LOG.debug("get_shared_contacts_of_account vo={}", (Object)vo);
        AccountInfo myAccount = SecurityUtils.getCurrentLoginUser();
        String myAccountGuid = myAccount.getGuid();
        String shareAccountGuid = vo.getAccountGuid();
        if (shareAccountGuid != null) {
            this.accountService.verifyAccountGuids(Arrays.asList(shareAccountGuid));
        }
        IntervalFilter intervalFilter = GlobalUtils.checkIntervalFilter((IntervalFilter)vo.getIntervalFilter());
        PageResult contactPage = new PageResult();
        contactPage = this.isAdmin(myAccount) ? this.getSharedContactsOfAccount_ALL(shareAccountGuid, vo.getPageInfo(), intervalFilter, myAccount.getCompanyGuid()) : this.getSharedContactsOfAccount_BY_SETTING(myAccountGuid, shareAccountGuid, vo.getPageInfo(), intervalFilter);
        this.LOG.debug("get_shared_contacts_of_account after getdata");
        this.contactPublicService.markDownloadStatusOfContactsByAccount(contactPage.getData(), myAccountGuid);
        this.LOG.debug("get_shared_contacts_of_account contactPage={}", (Object)contactPage);
        PageResponseResult result = new PageResponseResult("Get shared contacts of account success.", contactPage.getData(), contactPage.getTotalCount(), contactPage.getTotalPage());
        return result;
    }

    @ApiOperation(notes="\u53d6\u5f97\u516c\u6709\u5340\u88e1,\u67d0\u5e33\u865f\u6240\u64c1\u6709\u4e26\u4e14\u6709\u5206\u4eab\u7d66\u6211,\u4f46\u537b\u4e0d\u5728\u4ed6\u7684\u79c1\u6709\u5340\u88e1\u7684\u540d\u7247\u5217\u8868.", value="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/get_contacts_shared_by_account_uncategory"})
    public PageResponseResult<ContactSimpleInfoDto> getSharedContactsByAccountButNotInHisPrivate(@RequestBody @Valid ContactGetByAccountVo vo) {
        String accountGuid = vo.getAccountGuid();
        PageInfo pageInfo = vo.getPageInfo();
        IntervalFilter intervalFilter = GlobalUtils.checkIntervalFilter((IntervalFilter)vo.getIntervalFilter());
        AccountInfo myAccount = SecurityUtils.getCurrentLoginUser();
        PageResult contactPage = new PageResult();
        contactPage = this.canViewAllShares(accountGuid, myAccount) ? this.contactPrivateService.getSimpleContactsUncategoryAndContactOwner(accountGuid, pageInfo, intervalFilter) : this.contactPrivateService.getSimpleContactsUncategoryAndContactOwnerAndAccountCanView(accountGuid, myAccount.getGuid(), pageInfo, intervalFilter);
        this.contactPublicService.markDownloadStatusOfContactsByAccount(contactPage.getData(), myAccount.getGuid());
        PageResponseResult result = new PageResponseResult("Get shared contacts of category success.", contactPage.getData(), contactPage.getTotalCount(), contactPage.getTotalPage());
        return result;
    }

    @ApiOperation(notes="\u53d6\u5f97\u516c\u6709\u5340\u88e1,\u67d0\u4e00\u500b\u985e\u5225\u88e1\u7684\u540d\u7247\u5217\u8868.", value="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/get_contacts_shared_by_category"})
    public PageResponseResult<ContactSimpleInfoDto> getSharedContactsByCategory(@RequestBody @Valid ContactGetByCategoryAndOwnerVo vo) {
        String categoryGuid = vo.getCategoryGuid();
        String categoryOwnerGuid = vo.getCategoryOwnerAccountGuid();
        PageInfo pageInfo = vo.getPageInfo();
        IntervalFilter intervalFilter = GlobalUtils.checkIntervalFilter((IntervalFilter)vo.getIntervalFilter());
        this.categoryService.verifyCategoryGuidsOfAccount(Arrays.asList(categoryGuid), categoryOwnerGuid);
        AccountInfo myAccount = SecurityUtils.getCurrentLoginUser();
        PageResult contactPage = new PageResult();
        contactPage = this.canViewAllShares(categoryOwnerGuid, myAccount) ? this.contactPrivateService.getSimpleContactsByCategoryAndContactOwner(categoryGuid, categoryOwnerGuid, pageInfo, intervalFilter) : this.contactPrivateService.getSimpleContactsByCategoryAndContactOwnerAndAccountCanView(categoryGuid, categoryOwnerGuid, myAccount.getGuid(), pageInfo, intervalFilter);
        this.contactPublicService.markDownloadStatusOfContactsByAccount(contactPage.getData(), myAccount.getGuid());
        PageResponseResult result = new PageResponseResult("Get shared contacts of category success.", contactPage.getData(), contactPage.getTotalCount(), contactPage.getTotalPage());
        return result;
    }

    private boolean canViewAllShares(String accountGuid, AccountInfo myAccount) {
        String myAccountGuid = myAccount.getGuid();
        boolean isSubordinate = this.accountService.isSubordinateOf(accountGuid, myAccountGuid);
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        Globalinfocompany globalinfocompany = this.companyGlobalInfoService.getPropertiesByKey("SHARE_RULE", currentLoginUser.getCompanyGuid());
        String serverId = globalinfocompany.getConfigValue();
        return accountGuid.equals(myAccountGuid) || isSubordinate || this.isAdmin(myAccount);
    }

    @RequestMapping(value={"/share_contacts_to_accounts"}, method={RequestMethod.POST})
    public MessageResponseResult shareToAccounts(@RequestBody @Valid ContactShareAccountVo vo) {
        List<String> contactGuids = Arrays.asList(vo.getContactGuids());
        List<String> accountGuids = Arrays.asList(vo.getAccountGuids());
        this.contactPrivateService.verifyContactGuids(contactGuids);
        this.accountService.verifyAccountGuids(accountGuids);
        this.LOG.debug("[Ralph Debug modify time] shareToAccounts");
        for (String contactGuid : contactGuids) {
            try {
                this.contactPublicService.shareContactToAccounts(contactGuid, accountGuids, vo.getShareBehavior(), null);
            }
            catch (Exception exception) {}
        }
        return new MessageResponseResult("Share success.", "nothing return");
    }
}

