/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.CollectionUtil;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.CategoryInfo;
import com.penpower.worldcard.team.dto.ContactInfoForRequest;
import com.penpower.worldcard.team.dto.ContactInfoForResponse;
import com.penpower.worldcard.team.dto.ContactSimpleInfoDto;
import com.penpower.worldcard.team.dto.ContactSimpleInfoDuplicate;
import com.penpower.worldcard.team.dto.ContactemailInfo;
import com.penpower.worldcard.team.enums.AccountLockedIssue;
import com.penpower.worldcard.team.enums.ContactImageType;
import com.penpower.worldcard.team.enums.ListSetBehavior;
import com.penpower.worldcard.team.enums.ShareItem;
import com.penpower.worldcard.team.enums.TempStoredDataType;
import com.penpower.worldcard.team.enums.UpdateComponent;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.enums.WctSystemExceptionType;
import com.penpower.worldcard.team.exception.AccountResignedAndExistsException;
import com.penpower.worldcard.team.exception.IllegalException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.MaxCountExceededContactPrivateException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.exception.ResourceLockedException;
import com.penpower.worldcard.team.exception.SubscriptionOutOfTSubscripException;
import com.penpower.worldcard.team.exception.SystemIoException;
import com.penpower.worldcard.team.exception.UploadFileException;
import com.penpower.worldcard.team.files.PathManager;
import com.penpower.worldcard.team.scheduler.JobIdentify;
import com.penpower.worldcard.team.scheduler.ScheduleManager;
import com.penpower.worldcard.team.scheduler.job.SendBeSharedNoticeToAccountJob;
import com.penpower.worldcard.team.scheduler.job.SendCreateContactsForNoticeToAccountJob;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.AccountShareTargetService;
import com.penpower.worldcard.team.service.CategoryService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.ContactPublicService;
import com.penpower.worldcard.team.service.ContactService;
import com.penpower.worldcard.team.service.ElasticSearchService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.web.api.vo.ContactCreationVo;
import com.penpower.worldcard.team.web.api.vo.ContactCreationWithImageVo;
import com.penpower.worldcard.team.web.api.vo.ContactGetByAccountVo;
import com.penpower.worldcard.team.web.api.vo.ContactGetByCategoryVo;
import com.penpower.worldcard.team.web.api.vo.ContactInfoVoForWCT;
import com.penpower.worldcard.team.web.api.vo.ContactMyCardTemplateVo;
import com.penpower.worldcard.team.web.api.vo.ContactSetCategoriesVo;
import com.penpower.worldcard.team.web.api.vo.ContactUpdateMyCardVo;
import com.penpower.worldcard.team.web.api.vo.ContactUpdateVo;
import com.penpower.worldcard.team.web.api.vo.ContactsAndAccountVo;
import com.penpower.worldcard.team.web.api.vo.ContactsRemoveFromCategoryVo;
import com.penpower.worldcard.team.web.api.vo.ContactsSetFavoriteVo;
import com.penpower.worldcard.team.web.api.vo.GuidWithData;
import com.penpower.worldcard.team.web.api.vo.ItemBasicVo;
import com.penpower.worldcard.team.web.api.vo.ListRequestVo;
import com.penpower.worldcard.team.web.api.vo.PageInfo;
import com.penpower.worldcard.team.web.api.vo.response.BasicResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.ListResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.PageResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.PersistenceException;
import javax.validation.Valid;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.validator.internal.constraintvalidators.hv.EmailValidator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.quartz.JobDataMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/contact/private"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"contact/private"})
@PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE)")
public class ContactPrivateController {
    private static final Logger LOG = LoggerFactory.getLogger(ContactPrivateController.class);
    @Autowired
    private AccountService accountService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private AccountShareTargetService accountShareTargetService;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private ContactService contactService;
    @Autowired
    private PathManager cardPathManager;
    @Autowired
    private ContactPublicService contactPublicService;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private ScheduleManager scheduleManager;
    @Autowired
    private ElasticSearchService elasticSearchService;
    private static final int IMG_WIDTH = 256;
    private static final int IMG_HEIGHT = 256;

    @ApiOperation(notes="\u53d6\u5f97\u540d\u7247\u6a23\u7248.", value="my_card_template_get")
    @RequestMapping(value={"/my_card_template_get"}, method={RequestMethod.POST})
    public BasicResponseResult<ContactMyCardTemplateVo, Object> myCardTemplateGet(@RequestParam String templateGuid) {
        ContactMyCardTemplateVo result = new ContactMyCardTemplateVo();
        return new BasicResponseResult("under implement.", (Object)result);
    }

    @ApiOperation(notes="\u522a\u9664\u540d\u7247\u6a23\u7248.", value="my_card_template_delete")
    @RequestMapping(value={"/my_card_template_delete"}, method={RequestMethod.POST})
    public MessageResponseResult myCardTemplateDelete(@RequestParam String templateGuid) {
        return new MessageResponseResult("under implement.", "template guid");
    }

    @ApiOperation(notes="\u4fee\u6539\u540d\u7247\u6a23\u7248.", value="my_card_template_update")
    @RequestMapping(value={"/my_card_template_update"}, method={RequestMethod.POST})
    public MessageResponseResult myCardTemplateUpdate(@RequestBody ContactMyCardTemplateVo vo) {
        return new MessageResponseResult("under implement.", "template guid");
    }

    @ApiOperation(notes="\u65b0\u589e\u540d\u7247\u6a23\u7248.", value="my_card_template_create")
    @RequestMapping(value={"/my_card_template_create"}, method={RequestMethod.POST})
    public MessageResponseResult myCardTemplateCreate(@RequestBody ContactMyCardTemplateVo vo) {
        return new MessageResponseResult("under implement.", "created template guid");
    }

    @ApiOperation(notes="\u65b0\u589e/\u4fee\u6539\"\u6211\u7684\u540d\u7247\".", value="my_card_set")
    @RequestMapping(value={"/my_card_set"}, method={RequestMethod.POST})
    public MessageResponseResult myCardSet(@RequestBody @Valid ContactUpdateMyCardVo vo) {
        return new MessageResponseResult("under implement.", "nothing return");
    }

    @ApiOperation(notes="\u53d6\u5f97\"\u6211\u7684\u540d\u7247\".", value="my_card_get")
    @RequestMapping(value={"/my_card_get"}, method={RequestMethod.POST})
    public BasicResponseResult<ContactInfoForResponse, Object> myCardGet() {
        ContactInfoForResponse result = new ContactInfoForResponse();
        return new BasicResponseResult("under implement.", (Object)result);
    }

    @ApiOperation(notes="\u53d6\u5f97\u4e00\u5f35\u65b0\u7684,\u6709\u540c\u6a23\u516c\u53f8\u8cc7\u8a0a\u7684\u540d\u7247.", value="get_new_one_with_same_company")
    @RequestMapping(value={"/get_new_one_with_same_company"}, method={RequestMethod.GET})
    public BasicResponseResult<ContactInfoForRequest, Object> getContactBySameCompany(@RequestParam(required=true) String contactGuid) {
        this.contactPrivateService.verifyContactGuids(Arrays.asList(contactGuid));
        ContactInfoForRequest result = this.contactPrivateService.getContactInfoByGuid_SameCompany(contactGuid);
        return new BasicResponseResult("Get contact with same company success.", (Object)result);
    }

    @ApiOperation(notes="\u5408\u4f75\u91cd\u8907\u540d\u7247,\u4e00\u6b21\u5408\u4f75\u4e00\u7d44,\u628a\u5c6c\u65bc\u540c\u4e00\u500b\u4eba\u7684\u540d\u7247ID\u5217\u8868\u50b3\u9032\u4f86.<BR>\u6703\u56de\u50b3\u5408\u4f75\u5f8c\u7684\u90a3\u4e00\u7b46\u540d\u7247ID.", value="merge_contacts")
    @RequestMapping(value={"/merge_contacts"}, method={RequestMethod.POST})
    public MessageResponseResult mergeDuplicateContacts(@RequestBody @Valid ListRequestVo<String> contactGuidsVo) {
        List contactGuids = contactGuidsVo.getList();
        this.contactPrivateService.verifyContactGuids(contactGuids);
        List duplicates = this.contactPrivateService.getContactSimpleInfoDuplicates(contactGuids);
        String mergedContactGuid = this.determineReservedContactInDuplicates(duplicates);
        AccountInfo myAccount = SecurityUtils.getCurrentLoginUser();
        String contactEditorGuid = myAccount.getGuid();
        ContactUpdateVo mergedContact = this.contactPrivateService.mergeContacts(contactGuids, mergedContactGuid);
        this.contactPrivateService.updateContact(mergedContact, contactEditorGuid);
        return new MessageResponseResult("Merge contacts success.", mergedContactGuid);
    }

    @ApiOperation(notes="\u53d6\u5f97\u767b\u5165\u5e33\u865f\u7684\u91cd\u8907\u540d\u7247\u6e05\u55ae.(\u5408\u4f75\u7528)<BR>\u6703\u56de\u50b3\u591a\u7d44\u91cd\u8907\u540d\u7247,\u6bcf\u4e00\u7d44\u5c31\u662f\u4e00\u500blist,\u88e1\u9762\u5305\u542bN\u7b46\u540d\u7247.<BR>\u91dd\u5c0d\u91cd\u8907\u540d\u7247,\u9810\u8a2d\u662f\u5168\u90e8\u5408\u4f75,\u6240\u4ee5\u9810\u8a2d\u90fd\u662f\u986f\u793a\u70ba\u52fe\u9078\u72c0\u614b(beDefaultSelected is true).", value="get_duplicate_contacts_for_merge")
    @RequestMapping(value={"/get_duplicate_contacts_for_merge"}, method={RequestMethod.POST})
    public ListResponseResult<List<ContactSimpleInfoDuplicate>> getDuplicateContactsForMerge() {
        boolean isDetermineReserved = false;
        return this.getDuplicateContacts(isDetermineReserved);
    }

    @ApiOperation(notes="\u53d6\u5f97\u767b\u5165\u5e33\u865f\u7684\u91cd\u8907\u540d\u7247\u6e05\u55ae.(\u522a\u9664\u7528)<BR>\u6703\u56de\u50b3\u591a\u7d44\u91cd\u8907\u540d\u7247,\u6bcf\u4e00\u7d44\u5c31\u662f\u4e00\u500blist,\u88e1\u9762\u5305\u542bN\u7b46\u540d\u7247.<BR>\u4f9d\u898f\u683c\u8981\u6c42,\u512a\u5148\u52fe\u9078\u522a\u9664\u5225\u4eba\u7684\u540d\u7247,\u6216\u540d\u7247\u5716\u6578\u91cf\u8f03\u5c11\u7684\u540d\u7247,\u56e0\u6b64\u6bcf\u4e00\u7b46\u540d\u7247\u6703\u4ee5beDefaultSelected\u6a19\u793a\u8981\u4e0d\u8981\u9810\u8a2d\u986f\u793a\u70ba\u52fe\u9078\u72c0\u614b.<BR><BR>\u4f9d\u898f\u683c\u522a\u9664\u91cd\u8907\u540d\u7247\u7684\u505a\u6cd5\u662f\u79fb\u51fa\u79c1\u6709\u5340,\u6240\u4ee5\u8acb\u4f7f\u7528\u65e2\u6709API\u57f7\u884c\u6b64\u52d5\u4f5c.", value="get_duplicate_contacts_for_delete")
    @RequestMapping(value={"/get_duplicate_contacts_for_delete"}, method={RequestMethod.POST})
    public ListResponseResult<List<ContactSimpleInfoDuplicate>> getDuplicateContactsForDelete() {
        boolean isDetermineReserved = true;
        return this.getDuplicateContacts(isDetermineReserved);
    }

    private ListResponseResult<List<ContactSimpleInfoDuplicate>> getDuplicateContacts(boolean isDetermineReserved) {
        AccountInfo myAccountInfo = SecurityUtils.getCurrentLoginUser();
        List dupContacts = this.contactPrivateService.getDuplicateContacts(myAccountInfo.getGuid());
        for (List list : dupContacts) {
            list.forEach(c -> c.setBeDefaultSelected(Boolean.valueOf(true)));
            if (!isDetermineReserved) continue;
            String reservedContactGuid = this.determineReservedContactInDuplicates(list);
            list.stream().filter(c -> reservedContactGuid.equals(c.getContactGuid())).forEach(c -> c.setBeDefaultSelected(Boolean.valueOf(false)));
        }
        ListResponseResult result = new ListResponseResult("Get duplicate contacts success.", dupContacts);
        return result;
    }

    private String determineReservedContactInDuplicates(List<ContactSimpleInfoDuplicate> list) {
        AccountInfo myAccountInfo = SecurityUtils.getCurrentLoginUser();
        List<Object> filtered = list.stream().filter(c -> myAccountInfo.getGuid().equals(c.getOwnerAccountGuid())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filtered)) {
            filtered = list;
        }
        if (filtered.size() == 1) {
            return ((ContactSimpleInfoDuplicate)filtered.get(0)).getContactGuid();
        }
        Comparator imageNumComparator = (o1, o2) -> o1.getContactImageNum().compareTo(o2.getContactImageNum());
        filtered.sort(imageNumComparator.reversed());
        if (((ContactSimpleInfoDuplicate)filtered.get(0)).getContactImageNum() > ((ContactSimpleInfoDuplicate)filtered.get(1)).getContactImageNum()) {
            return ((ContactSimpleInfoDuplicate)filtered.get(0)).getContactGuid();
        }
        int maxImageNum = ((ContactSimpleInfoDuplicate)filtered.get(0)).getContactImageNum();
        filtered = filtered.stream().filter(c -> maxImageNum == c.getContactImageNum()).collect(Collectors.toList());
        Comparator timeComparator = (o1, o2) -> o1.getCreatedTime().compareTo((ReadableInstant)o2.getCreatedTime());
        filtered.sort(timeComparator.reversed());
        return ((ContactSimpleInfoDuplicate)filtered.get(0)).getContactGuid();
    }

    @RequestMapping(value={"/get_uncorrected_number"}, method={RequestMethod.POST})
    public BasicResponseResult<Long, Object> getUncorrectedContactsNumber(@RequestParam String accountGuid) {
        this.accountService.verifyAccount(accountGuid, null);
        Long contactNum = this.contactPrivateService.getcontactNumUncorrectedByAccount(accountGuid);
        return new BasicResponseResult("get uncorrected contact number success.", (Object)contactNum);
    }

    @RequestMapping(value={"/get_uncorrected_list"}, method={RequestMethod.POST})
    public PageResponseResult<ContactSimpleInfoDto> getUncorrectedContacts(@RequestBody @Valid ContactGetByAccountVo vo) {
        String accountGuid = vo.getAccountGuid();
        this.accountService.verifyAccount(accountGuid, null);
        PageResult contactPage = this.contactPrivateService.getSimpleContactsUncorrectedByAccount(accountGuid, vo.getPageInfo());
        PageResponseResult result = new PageResponseResult("get uncorrected contacts success", contactPage.getData(), contactPage.getTotalCount(), contactPage.getTotalPage());
        return result;
    }

    @RequestMapping(value={"/get"}, method={RequestMethod.GET})
    public BasicResponseResult<ContactInfoVoForWCT, Object> getContactByGuid(@RequestParam(required=true) String contactGuid) {
        this.contactPrivateService.verifyContactGuids(Arrays.asList(contactGuid));
        AccountInfo myAccountInfo = SecurityUtils.getCurrentLoginUser();
        ContactInfoVoForWCT contactInfoVo = this.contactPrivateService.getContactInfoVoForWCTByGuid(contactGuid, myAccountInfo.getGuid());
        LOG.debug("contactInfoVo.getNames(): ++++++++++++++++++++++++++++++++++++++++++++++++++");
        if (!CollectionUtils.isEmpty((Collection)contactInfoVo.getNames())) {
            contactInfoVo.getNames().forEach(name -> LOG.debug("+++++++++++++++++++ {}", (Object)(name.getFirstName() + name.getLastName())));
        }
        return new BasicResponseResult("Get contact by guid success.", (Object)contactInfoVo);
    }

    @RequestMapping(value={"/get_contact_number_of_categories"}, method={RequestMethod.POST})
    public ListResponseResult<GuidWithData<Long>> getContactNumberOfCategories(@RequestBody @Valid ListRequestVo<String> vo) {
        LOG.debug("get_contact_number_of_categories: vo={}", vo);
        List categoryGuids = vo.getList();
        ArrayList<GuidWithData> contactNumOfCategories = new ArrayList<GuidWithData>();
        for (String categoryGuid : categoryGuids) {
            LOG.debug("get_contact_number_of_categories: categoryGuid={}", (Object)categoryGuid);
            Long contactNum = this.contactPrivateService.getContactNumByCategory(categoryGuid);
            LOG.debug("get_contact_number_of_categories: contactNum={}", (Object)contactNum);
            contactNumOfCategories.add(new GuidWithData(categoryGuid, (Object)contactNum));
        }
        ListResponseResult result = new ListResponseResult("Get contact number of categories success.", contactNumOfCategories);
        LOG.debug("get_contact_number_of_categories: end");
        return result;
    }

    @RequestMapping(value={"/get_by_category"}, method={RequestMethod.POST})
    public PageResponseResult<ContactSimpleInfoDto> getContactsByCategory(@RequestBody @Valid ContactGetByCategoryVo vo) {
        String categoryGuid = vo.getCategoryGuid();
        this.categoryService.verifyCategoryGuids(Arrays.asList(categoryGuid));
        PageInfo pageInfo = vo.getPageInfo();
        PageResult contactPage = this.contactPrivateService.getSimpleContactsByCategory(categoryGuid, pageInfo);
        PageResponseResult result = new PageResponseResult("Get contacts in category success.", contactPage.getData(), contactPage.getTotalCount(), contactPage.getTotalPage());
        return result;
    }

    @RequestMapping(value={"/get_contact_image_base64"}, method={RequestMethod.GET})
    public MessageResponseResult getContactImageBase64(@RequestParam String contactGuid, @RequestParam ContactImageType imageType) {
        this.contactPrivateService.verifyContactGuids(Arrays.asList(contactGuid));
        byte[] arrayByte = new byte[]{};
        try {
            arrayByte = this.contactPrivateService.getImageContent(contactGuid, imageType);
        }
        catch (IOException e) {
            throw new SystemIoException("Fail to load image file: ", (Throwable)e);
        }
        String imageBase64 = Base64.encodeBase64String((byte[])arrayByte);
        return new MessageResponseResult("Get contact image success.", imageBase64);
    }

    @RequestMapping(value={"/get_contact_image"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> getContactImage(@RequestParam String contactGuid, @RequestParam ContactImageType imageType) {
        this.contactPrivateService.verifyContactGuids(Arrays.asList(contactGuid));
        byte[] imageBytes = new byte[]{};
        try {
            imageBytes = this.contactPrivateService.getImageContent(contactGuid, imageType);
        }
        catch (IOException e) {
            throw new SystemIoException("Fail to load image file: ", (Throwable)e);
        }
        String contentType = GlobalUtils.getFileContent((byte[])imageBytes);
        MediaType mediaType = MediaType.parseMediaType((String)contentType);
        ResponseEntity responseEntity = ResponseEntity.ok().contentLength((long)imageBytes.length).contentType(mediaType).body((Object)imageBytes);
        return responseEntity;
    }

    public ResponseEntity<byte[]> getImage() throws IOException {
        RandomAccessFile f = new RandomAccessFile("/home/vivex/apache-tomcat-7.0.59/tmpFiles/1.jpg", "r");
        byte[] b = new byte[(int)f.length()];
        f.readFully(b);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.IMAGE_PNG);
        return new ResponseEntity((Object)b, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @ResponseBody
    public byte[] testphoto(MultipartFile file) throws IOException {
        InputStream inputStream = file.getInputStream();
        return IOUtils.toByteArray((InputStream)inputStream);
    }

    private File multipartToFile(MultipartFile multipart) throws IllegalStateException, IOException {
        File convFile = new File(multipart.getOriginalFilename());
        multipart.transferTo(convFile);
        return convFile;
    }

    private static BufferedImage resizeImage(BufferedImage originalImage, int type) {
        BufferedImage resizedImage = new BufferedImage(256, 256, type);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(originalImage, 0, 0, 256, 256, null);
        g.dispose();
        return resizedImage;
    }

    @ApiOperation(value="", notes="Upload image, includes card image and logo image.")
    @RequestMapping(value={"/upload_image"}, method={RequestMethod.POST})
    public MessageResponseResult uploadImage(@RequestPart MultipartFile multipartFile) {
        String tempFileGuid = this.saveFileToTempFolder(multipartFile);
        return new MessageResponseResult("Upload file success and get guid of this temp file.", tempFileGuid);
    }

    private String saveFileToTempFolder(MultipartFile multipartFile) {
        if (multipartFile == null) {
            return null;
        }
        String tempGuid = null;
        try (InputStream inStream = multipartFile.getInputStream();){
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inStream, (OutputStream)stream);
            byte[] content = stream.toByteArray();
            tempGuid = this.contactPrivateService.createContactImage(content);
        }
        catch (IOException e) {
            throw new UploadFileException("Save to temp folder failed. Reason: " + e.toString());
        }
        return tempGuid;
    }

    private List<String> autoShareContactBySettings(String shareAccountGuid, String contactGuid, DateTime passedCreatedTime) {
        boolean autoShare = this.accountPrivateSettingService.getAutoShareSetting(shareAccountGuid);
        if (autoShare) {
            List shareTargets = this.accountShareTargetService.getShareTargetsByShareItem(shareAccountGuid, ShareItem.CONTACT);
            List<String> besharedAccountGuids = shareTargets.stream().map(a -> a.getAccountGuid()).collect(Collectors.toList());
            this.contactPublicService.shareContactToAccounts(contactGuid, besharedAccountGuids, ListSetBehavior.ADD, passedCreatedTime);
            return besharedAccountGuids;
        }
        return new ArrayList<String>();
    }

    private void setupContactShareNoticeJobToAccounts(String shareAccountGuid, List<String> besharedAccountGuids, String contactGuid) {
        for (String accountGuid : besharedAccountGuids) {
            this.accountShareTargetService.addItemIntoShareNotice(shareAccountGuid, accountGuid, contactGuid, TempStoredDataType.CONTACT);
            JobIdentify jobIdentify = new JobIdentify("SEND_SHARE_NOTICE" + shareAccountGuid + accountGuid, SendBeSharedNoticeToAccountJob.class);
            this.scheduleManager.deleteSchedule(jobIdentify);
            DateTime launchTime = new DateTime().plusMinutes(5);
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("SHARE_ACCOUNT_GUID", shareAccountGuid);
            dataMap.put("BESHARED_ACCOUNT_GUID", accountGuid);
            this.scheduleManager.startScheduleOnce(jobIdentify, launchTime.toDate(), dataMap);
        }
    }

    private void setupContactCreateForSomeoneNoticeJob(String contactCreatorGuid, String contactReceiverAccountGuid, String contactGuid) {
        this.accountShareTargetService.addItemIntoShareNotice(contactCreatorGuid, contactReceiverAccountGuid, contactGuid, TempStoredDataType.CONTACT_CREATE_FOR_SOMEONE);
        JobIdentify jobIdentify = new JobIdentify("CREATE_CONTACT_FOR_SOMEONE_NOTICE" + contactCreatorGuid + contactReceiverAccountGuid, SendCreateContactsForNoticeToAccountJob.class);
        this.scheduleManager.deleteSchedule(jobIdentify);
        DateTime launchTime = new DateTime().plusMinutes(5);
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("CREATOR_ACCOUNT_GUID", contactCreatorGuid);
        dataMap.put("RECEIVER_ACCOUNT_GUID", contactReceiverAccountGuid);
        this.scheduleManager.startScheduleOnce(jobIdentify, launchTime.toDate(), dataMap);
    }

    @ApiOperation(value="", notes="\u65b0\u589e\u540d\u7247(\u5354\u52a9\u6383\u63cf\u8005\u5c08\u7528API). <BR><BR>NOTE: \u8981\u50b3\u5165\u6307\u5b9a\u8981\u6383\u7d66\u54ea\u4e00\u500b\u5e33\u865f\u7684GUID")
    @ApiResponses(value={@ApiResponse(code=441, message="Account already exists and status is RESIGNED."), @ApiResponse(code=425, message="Max count limit of contact in private is reached."), @ApiResponse(code=426, message="Max count limit of contact owning is reached."), @ApiResponse(code=427, message="Max count limit of contact in DB is reached."), @ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=445, message="THIS EMAIL IS ILLEGAL FORMAT"), @ApiResponse(code=490, message="Specified guid has been used.<BR>"), @ApiResponse(code=486, message="Subscription mode out of subscription"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/create_with_pre_upload_image_for_account"}, method={RequestMethod.POST})
    public MessageResponseResult createContactForAccount(@RequestBody @Valid ContactCreationWithImageVo vo, @RequestParam String contactReceiverAccountGuid) {
        String contactCreatorGuid = vo.getCreatorAccountGuid();
        this.accountService.verifyAccount(contactCreatorGuid, null);
        AccountInfo receiver = this.accountService.getAccountInfo(contactReceiverAccountGuid, null);
        if (receiver != null && receiver.getStatus().equals((Object)UserStatus.RESIGNED)) {
            throw new AccountResignedAndExistsException("Contact receiver is set to RESIGNED.");
        }
        if (receiver != null && !receiver.getLockedIssue().equals((Object)AccountLockedIssue.NO_ISSUE)) {
            throw new SubscriptionOutOfTSubscripException("Contact receiver is TEMPLATE_INVALIDATE");
        }
        if (this.contactPrivateService.doesContactCountInPrivateReachLimit(contactReceiverAccountGuid)) {
            throw new MaxCountExceededContactPrivateException(WctSystemExceptionType.MAX_CONTACT_NUMBER_IN_PRIVATE_REACHED.toString());
        }
        List categoryGuids = GlobalUtils.getGuidsFromBasicItems((List)vo.getBelongingCategories());
        this.categoryService.verifyCategoryGuidsOfAccount(categoryGuids, contactReceiverAccountGuid);
        this.vertifyEmailvalidate(vo.getEmails());
        ContactCreationWithImageVo contactCreationVo = vo;
        contactCreationVo.setOwnerAccountGuid(contactReceiverAccountGuid);
        if (contactReceiverAccountGuid.compareToIgnoreCase(contactCreationVo.getCreatorAccountGuid()) != 0) {
            AccountInfo myAccount = SecurityUtils.getCurrentLoginUser();
            GlobalUtils.setProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"HAVE_SCAN_BY_SECRETARY", (String)"true", (String)myAccount.getCompanyGuid());
        }
        if (CollectionUtils.isEmpty((Collection)categoryGuids)) {
            CategoryInfo categoryInfo = this.categoryService.getCategoryGuidSomeoneCreateForMe(contactReceiverAccountGuid, contactCreatorGuid);
            if (categoryInfo != null) {
                this.categoryService.undeleteCategory(categoryInfo.getGuid());
            } else {
                AccountInfo accountInfo = this.accountService.getAccountInfo(contactCreatorGuid, null);
                categoryInfo = this.categoryService.createCategoryBySecretary("From " + accountInfo.getName(), contactReceiverAccountGuid, null, contactCreatorGuid, false);
            }
            contactCreationVo.setBelongingCategories(Arrays.asList(new ItemBasicVo(categoryInfo.getGuid(), categoryInfo.getName())));
        }
        contactCreationVo.setBelongingCategoriesOwnerAccountGuid(contactReceiverAccountGuid);
        String createdContactGuid = this.contactPrivateService.createContact((ContactCreationVo)contactCreationVo, vo.getFrontImageFileGuid(), vo.getRearImageFileGuid(), vo.getLogoImageFileGuid(), receiver.getCompanyGuid());
        this.setupContactCreateForSomeoneNoticeJob(contactCreatorGuid, contactReceiverAccountGuid, createdContactGuid);
        DateTime contactModifyTime = this.contactPrivateService.getContactModifyTimeByGuid(createdContactGuid);
        this.autoShareAndNotifyToAccountsWhileCreation(contactReceiverAccountGuid, createdContactGuid, contactModifyTime);
        return new MessageResponseResult("Create contact for account success.", createdContactGuid);
    }

    @ApiOperation(value="", notes="Add contact. Used for manually creating contact.")
    @ApiResponses(value={@ApiResponse(code=425, message="Max count limit of contact in private is reached."), @ApiResponse(code=426, message="Max count limit of contact owning is reached."), @ApiResponse(code=427, message="Max count limit of contact in DB is reached."), @ApiResponse(code=445, message="THIS EMAIL IS ILLEGAL FORMAT"), @ApiResponse(code=490, message="Specified guid has been used.<BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/create_with_pre_upload_image"}, method={RequestMethod.POST})
    public MessageResponseResult createContact(@RequestBody @Valid ContactCreationWithImageVo vo) {
        ContactCreationWithImageVo contactCreationVo = vo;
        String creatorAccountGuid = vo.getCreatorAccountGuid();
        this.accountService.verifyAccount(creatorAccountGuid, null);
        List categoryGuids = GlobalUtils.getGuidsFromBasicItems((List)vo.getBelongingCategories());
        this.categoryService.verifyCategoryGuidsOfAccountAreNormal(categoryGuids, creatorAccountGuid);
        this.vertifyEmailvalidate(vo.getEmails());
        AccountInfo myAccount = SecurityUtils.getCurrentLoginUser();
        String createdContactGuid = "";
        try {
            createdContactGuid = this.contactPrivateService.createContact((ContactCreationVo)contactCreationVo, vo.getFrontImageFileGuid(), vo.getRearImageFileGuid(), vo.getLogoImageFileGuid(), myAccount.getCompanyGuid());
        }
        catch (PersistenceException e) {
            String rootCauseString = ExceptionUtils.getRootCause((Throwable)e).getMessage();
            LOG.error(rootCauseString);
            throw new RequestArgumentNotValidException("write contact cotent into DB fail.");
        }
        DateTime contactModifyTime = this.contactPrivateService.getContactModifyTimeByGuid(createdContactGuid);
        this.autoShareAndNotifyToAccountsWhileCreation(creatorAccountGuid, createdContactGuid, contactModifyTime);
        return new MessageResponseResult("Create contact success.", createdContactGuid);
    }

    private void autoShareAndNotifyToAccountsWhileCreation(String shareAccountGuid, String contactGuid, DateTime passedCreatedTime) {
        LOG.debug("[Ralph Debug modify time] autoShareAndNotifyToAccountsWhileCreation,contactGuid: {}", (Object)contactGuid);
        List besharedAccountGuids = this.autoShareContactBySettings(shareAccountGuid, contactGuid, passedCreatedTime);
        if (!CollectionUtils.isEmpty((Collection)besharedAccountGuids)) {
            this.setupContactShareNoticeJobToAccounts(shareAccountGuid, besharedAccountGuids, contactGuid);
        }
        List otherBesharedAccountGuids = this.contactPublicService.getAccountGuidsSharedByContact(contactGuid);
        otherBesharedAccountGuids.removeAll(besharedAccountGuids);
        this.setupContactShareNoticeJobToAccounts(shareAccountGuid, otherBesharedAccountGuids, contactGuid);
    }

    @ApiOperation(value="", notes="\u66f4\u65b0contact.")
    @ApiResponses(value={@ApiResponse(code=425, message="Max count limit of contact in private is reached."), @ApiResponse(code=445, message="THIS EMAIL IS ILLEGAL FORMAT"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public MessageResponseResult updateContact(@RequestBody @Valid ContactUpdateVo vo) {
        boolean isUpdateContent;
        String contactGuid = vo.getContactGuid();
        LOG.debug("[updateContact]contactGuid: {}", (Object)contactGuid);
        this.contactPrivateService.verifyContactGuids(Arrays.asList(contactGuid));
        List<UpdateComponent> updateCompoments = Arrays.asList(vo.getUpdateComponents());
        if (updateCompoments.contains(UpdateComponent.UC_CATEGORY)) {
            List categoryGuids = GlobalUtils.getGuidsFromBasicItems((List)vo.getBelongingCategories());
            String categoryOwnerGuid = vo.getCategoryOwnerAccountGuid();
            if (CollectionUtils.isEmpty((Collection)categoryGuids)) {
                this.accountService.verifyAccount(categoryOwnerGuid, null);
            } else {
                this.categoryService.verifyCategoryGuidsOfAccount(categoryGuids, categoryOwnerGuid);
            }
        }
        boolean isAddShare = updateCompoments.contains(UpdateComponent.UC_SHARE_ACCOUNT);
        List originSharedAccountGuids = new ArrayList();
        if (isAddShare) {
            originSharedAccountGuids = this.contactPublicService.getAccountGuidsSharedByContact(contactGuid);
        }
        if (isUpdateContent = updateCompoments.contains(UpdateComponent.UC_CONTENT)) {
            this.vertifyEmailvalidate(vo.getEmails());
        }
        AccountInfo myAccount = SecurityUtils.getCurrentLoginUser();
        String contactEditorGuid = myAccount.getGuid();
        this.contactPrivateService.updateContact(vo, contactEditorGuid);
        if (isAddShare) {
            List besharedAccountGuids = this.contactPublicService.getAccountGuidsSharedByContact(contactGuid);
            besharedAccountGuids.removeAll(originSharedAccountGuids);
            if (!CollectionUtils.isEmpty((Collection)besharedAccountGuids)) {
                LOG.debug("[updateContact]besharedAccountGuids: {}", (Object)besharedAccountGuids);
                this.setupContactShareNoticeJobToAccounts(contactEditorGuid, besharedAccountGuids, contactGuid);
            }
        }
        return new MessageResponseResult("Update contact success.", "nothing return");
    }

    private void vertifyEmailvalidate(List<ContactemailInfo> emails) {
        EmailValidator validator = new EmailValidator();
        for (ContactemailInfo contactemailInfo : emails) {
            boolean emailValid = validator.isValid((CharSequence)contactemailInfo.getValue(), null);
            if (emailValid) continue;
            throw new IllegalException("mail is not a well-formed email address");
        }
    }

    @ApiOperation(value="", notes="Add contact. Used for batch creating contacts.")
    @ApiResponse(code=445, message="THIS EMAIL IS ILLEGAL FORMAT")
    public MessageResponseResult createContact(@RequestPart @Valid ContactCreationVo contactCreationVo, @RequestPart MultipartFile frontImage, @RequestPart MultipartFile rearImage, @RequestPart MultipartFile logoImage) {
        String creatorAccountGuid = contactCreationVo.getCreatorAccountGuid();
        this.accountService.verifyAccount(creatorAccountGuid, null);
        this.vertifyEmailvalidate(contactCreationVo.getEmails());
        AccountInfo myAccount = SecurityUtils.getCurrentLoginUser();
        String createdContactGuid = this.contactPrivateService.createContact(contactCreationVo, this.saveFileToTempFolder(frontImage), this.saveFileToTempFolder(rearImage), this.saveFileToTempFolder(logoImage), myAccount.getCompanyGuid());
        DateTime contactModifyTime = this.contactPrivateService.getContactModifyTimeByGuid(createdContactGuid);
        this.autoShareAndNotifyToAccountsWhileCreation(creatorAccountGuid, createdContactGuid, contactModifyTime);
        return new MessageResponseResult("Create contact success.", createdContactGuid);
    }

    @RequestMapping(value={"/toggle_favorite_contacts"}, method={RequestMethod.POST})
    public MessageResponseResult toggleFavoriteContacts(@RequestBody ContactsSetFavoriteVo contactsSetFavoriteVo) {
        String accountGuid = contactsSetFavoriteVo.getAccountGuid();
        this.accountService.verifyAccount(accountGuid, null);
        List contactGuids = CollectionUtil.asList((Object[])contactsSetFavoriteVo.getContactGuids());
        this.contactPrivateService.verifyContactGuids(contactGuids);
        this.contactPrivateService.toggleFavoriteContacts(contactGuids, accountGuid, contactsSetFavoriteVo.isMarkAsFavorite());
        return new MessageResponseResult("Mark/Unmark contacts as favorite success", "nothing return");
    }

    @ApiOperation(value="", notes="\u50b3\u5165\u4e00\u5806\u540d\u7247\u4ee5\u53ca\u5e33\u865f,\u770b\u6bcf\u4e00\u7b46\u540d\u7247\u662f\u5426\u5c6c\u65bc\u8a72\u5e33\u865f\u7684\u6700\u611b\u985e\u5225")
    @RequestMapping(value={"/are_contacts_in_account_favorite"}, method={RequestMethod.POST})
    public ListResponseResult<GuidWithData<Boolean>> areContactsInAccountFavorite(@RequestBody @Valid ContactsAndAccountVo vo) {
        List<String> contactGuids = Arrays.asList(vo.getContactGuids());
        List resultList = this.contactPrivateService.areContactsInAccountFavorite(vo.getAccountGuid(), contactGuids);
        return new ListResponseResult("Get favorite status succeed.", resultList);
    }

    @ApiOperation(notes="\u8a2d\u5b9a\u540d\u7247\u7684\u985e\u5225.<BR>Response Model\u88e1,\u5305\u542b\u56de\u50b3\u7684\u8a0a\u606f,\u4ee5\u53ca\u4e00\u500b\u8a2d\u5b9a\u5931\u6557\u7684\u540d\u7247\u5217\u8868. \u5217\u8868\u88e1\u6bcf\u4e00\u500b\u9805\u76ee,\u662f\u8a72\u5931\u6557\u540d\u7247\u7684guid,\u53ca\u5176\u932f\u8aa4\u63cf\u8ff0. <BR>\u63cf\u8ff0\u5206\u5169\u7a2e,\u6d41\u7a0b\u4e0a\u53ef\u77e5\u539f\u56e0\u7684\u70ba\u932f\u8aa4\u78bc,\u610f\u5916\u539f\u56e0\u7684\u5247\u70ba\u932f\u8aa4\u5b57\u4e32. \u53ef\u77e5\u539f\u56e0\u7684\u932f\u8aa4\u78bc\u6709\u4ee5\u4e0b\u5e7e\u500b:<BR>422 : Request required parameters not valid. <BR>425 : Max count limit of contact in private is reached.", value="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=425, message="Max count limit of contact in private is reached.")})
    @RequestMapping(value={"/add_or_set_categories"}, method={RequestMethod.POST})
    public ListResponseResult<GuidWithData<String>> setPrivateCategories(@RequestBody @Valid ContactSetCategoriesVo vo) {
        AccountInfo myAccount = SecurityUtils.getCurrentLoginUser();
        String myAccountGuid = myAccount.getGuid();
        List categoryGuids = CollectionUtil.asList((Object[])vo.getCategoryGuids());
        categoryGuids = this.categoryService.verifyAndGetNewCategoryGuidsOfAccount(categoryGuids, myAccountGuid);
        ArrayList<GuidWithData> failedReasonList = new ArrayList<GuidWithData>();
        String returnMessage = "Set categories for contacts finished.";
        List contactGuids = CollectionUtil.asList((Object[])vo.getContactGuids());
        ArrayList<String> contactInfoForEsGuids = new ArrayList<String>();
        LOG.debug("[Ralph Debug modify time] setPrivateCategories,myAccountGuid: {}", (Object)myAccountGuid);
        for (String contactGuid : contactGuids) {
            try {
                this.contactPrivateService.verifyContactGuid(contactGuid);
                ListSetBehavior behavior = vo.getSetBehavior();
                DateTime passedTime = new DateTime();
                LOG.debug("({})Input categories({}):{}", new Object[]{contactGuid, behavior, categoryGuids});
                this.contactPrivateService.updateCategoriesOfContact(contactGuid, categoryGuids, myAccountGuid, behavior, passedTime);
                List belongingCategories = this.contactPrivateService.getBelongCategoriesByAccount(contactGuid, myAccountGuid);
                LOG.debug("({})Output categories:{}", (Object)contactGuid, (Object)belongingCategories);
                if ((ListSetBehavior.ADD.equals((Object)behavior) || ListSetBehavior.OVERWRITE.equals((Object)behavior)) && !this.contactService.doesAccountOwnThis(contactGuid, myAccountGuid)) {
                    this.contactPublicService.shareContactToAccounts(contactGuid, Arrays.asList(myAccountGuid), ListSetBehavior.ADD, passedTime);
                }
                if (!ListSetBehavior.REMOVE_ALL.equals((Object)behavior)) continue;
                contactInfoForEsGuids.add(contactGuid);
            }
            catch (Exception e) {
                GuidWithData failReason = new GuidWithData(contactGuid, (Object)e.getMessage());
                if (e instanceof RequestArgumentNotValidException) {
                    failReason.setData((Object)String.valueOf(422));
                } else if (e instanceof MaxCountExceededContactPrivateException) {
                    failReason.setData((Object)String.valueOf(425));
                }
                failedReasonList.add(failReason);
                returnMessage = "Some contacts set category failed.";
            }
        }
        if (!CollectionUtil.collectionEmpty(contactInfoForEsGuids)) {
            List contactInfoForEs = this.contactPrivateService.getContactForEsByContactGuids(contactInfoForEsGuids);
            try {
                this.elasticSearchService.updateEsContact(contactInfoForEs);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.elasticSearchService.refreshIndexToBeSearchable();
        }
        return new ListResponseResult(returnMessage, failedReasonList);
    }

    @RequestMapping(value={"/remove_list_from_category"}, method={RequestMethod.POST})
    public MessageResponseResult removeContactsFromCategory(@RequestBody @Valid ContactsRemoveFromCategoryVo contactsRemoveFromCategoryVo) {
        String categoryGuid = contactsRemoveFromCategoryVo.getCategoryGuid();
        List categoryGuids = CollectionUtil.asList((Object[])new String[]{categoryGuid});
        AccountInfo loginAccountInfo = SecurityUtils.getCurrentLoginUser();
        this.categoryService.verifyCategoryGuidsOfAccountAreNormal(categoryGuids, loginAccountInfo.getGuid());
        List contactGuids = CollectionUtil.asList((Object[])contactsRemoveFromCategoryVo.getContactGuids());
        this.contactPrivateService.verifyContactGuidsOfCategory(contactGuids, categoryGuid);
        this.contactPrivateService.removeContactsFromCategory(contactGuids, categoryGuid, loginAccountInfo.getGuid());
        return new MessageResponseResult("Remove contacts from category success", "nothing return");
    }

    @ApiOperation(value="", notes="\u5c07\u540d\u7247\u8a2d\u5b9a\u70baisdeleted.<BR>Response Model\u88e1,\u5305\u542b\u56de\u50b3\u7684\u8a0a\u606f,\u4ee5\u53ca\u4e00\u500b\u8a2d\u5b9a\u5931\u6557\u7684\u540d\u7247\u5217\u8868. \u5217\u8868\u88e1\u6bcf\u4e00\u500b\u9805\u76ee,\u662f\u8a72\u5931\u6557\u540d\u7247\u7684guid,\u53ca\u5176\u932f\u8aa4\u63cf\u8ff0. <BR>\u63cf\u8ff0\u5206\u5169\u7a2e,\u6d41\u7a0b\u4e0a\u53ef\u77e5\u539f\u56e0\u7684\u70ba\u932f\u8aa4\u78bc,\u610f\u5916\u539f\u56e0\u7684\u5247\u70ba\u932f\u8aa4\u5b57\u4e32. \u53ef\u77e5\u539f\u56e0\u7684\u932f\u8aa4\u78bc\u6709\u4ee5\u4e0b\u5e7e\u500b:<BR>404 : Item not found<BR>423 : Some other accounts have this contact in Private")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ListResponseResult<GuidWithData<String>> deleteContacts(@RequestBody ListRequestVo<String> vo) {
        List contactGuids = vo.getList();
        ArrayList<GuidWithData> failedList = new ArrayList<GuidWithData>();
        String returnMessage = "Contacts are marked as deleted.";
        ArrayList<String> contactInfoForEsGuids = new ArrayList<String>();
        for (String contactGuid : contactGuids) {
            try {
                this.contactPrivateService.deleteContact(contactGuid);
                contactInfoForEsGuids.add(contactGuid);
            }
            catch (Exception e) {
                GuidWithData fail = new GuidWithData(contactGuid, (Object)e.getMessage());
                if (e instanceof ItemNotFoundException) {
                    fail.setData((Object)String.valueOf(HttpStatus.NOT_FOUND.value()));
                } else if (e instanceof ResourceLockedException) {
                    fail.setData((Object)String.valueOf(HttpStatus.LOCKED.value()));
                }
                failedList.add(fail);
                returnMessage = "Some contacts fail to be marked as deleted.";
            }
        }
        if (!CollectionUtil.collectionEmpty(contactInfoForEsGuids)) {
            List contactInfoForEs = this.contactPrivateService.getContactForEsByContactGuids(contactInfoForEsGuids);
            try {
                this.elasticSearchService.updateEsContact(contactInfoForEs);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.elasticSearchService.refreshIndexToBeSearchable();
        }
        return new ListResponseResult(returnMessage, failedList);
    }
}

