/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.CategoryInfo;
import com.penpower.worldcard.team.dto.CategoryOrderInfo;
import com.penpower.worldcard.team.dto.CategoryOrderInfoEx;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.scheduler.JobIdentify;
import com.penpower.worldcard.team.scheduler.ScheduleManager;
import com.penpower.worldcard.team.scheduler.job.DeleteCategoryJob;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CategoryService;
import com.penpower.worldcard.team.web.api.vo.CategoryCreationVo;
import com.penpower.worldcard.team.web.api.vo.response.CategoryOrderInfoResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.DateTimeResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.ListResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.List;
import javax.validation.Valid;
import org.joda.time.DateTime;
import org.quartz.JobDataMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contact/category"}, produces={"application/json;charset=UTF-8"}, method={RequestMethod.POST})
@Api(tags={"category"})
@PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE)")
public class CategoryController {
    private static final Logger LOG = LoggerFactory.getLogger(CategoryController.class);
    @Autowired
    private AccountService accountService;
    @Autowired
    private CategoryService categoryService;
    private static final String DELETE_CATEGORY_JOB = "DELETE_CATEGORY_JOB";
    @Autowired
    private ScheduleManager scheduleManager;

    @ApiOperation(value="Set Category Order", notes="\u8a2d\u5b9a\u500b\u4eba\u7684\u985e\u5225\u6b21\u5e8fin guid \u5982\u679c\u4f3a\u670d\u5668\u4e0a\u7684\u6b21\u5e8f\u8a18\u9304\u6bd4\u8f03\u65b0,\u6703\u4f9d\u53c3\u6578\u4e2d\u7684isForceUpdate\u4f86\u6c7a\u5b9a\u662f\u5426\u66f4\u65b0,\u5982\u679c\u66f4\u65b0\u5931\u6557\u6703\u56de\u50b3exception 462")
    @ApiResponses(value={@ApiResponse(code=462, message="the Record in server is newer than client,and update fail"), @ApiResponse(code=409, message="the Record in server equal to client not nessary to update")})
    public DateTimeResponseResult setCategoryOrder(@RequestBody CategoryOrderInfoEx info) {
        AccountInfo accountInfo = SecurityUtils.getCurrentLoginUser();
        String ownerAccountGuid = accountInfo.getGuid();
        LOG.debug("[CategoryOrderIssue](setCategoryOrder) getOrderedCategoryGuids(): {}", (Object)info.getOrderedCategoryGuids());
        DateTime updateTime = this.categoryService.setCategoryOrder(ownerAccountGuid, info);
        LOG.debug("[CategoryOrderIssue](setCategoryOrder) returned updateTime: {}", (Object)updateTime);
        return new DateTimeResponseResult("Set categories order success.", updateTime);
    }

    @ApiOperation(value="Get Category Order", notes="\u53d6\u5f97\u500b\u4eba\u7684\u985e\u5225\u6b21\u5e8fin guid \u53ca\u6700\u5f8c\u7684\u6b21\u5e8f\u66f4\u65b0\u6642\u9593 ")
    public CategoryOrderInfoResponseResult getCategoryOrder() {
        AccountInfo accountInfo = SecurityUtils.getCurrentLoginUser();
        String ownerAccountGuid = accountInfo.getGuid();
        CategoryOrderInfo categoryOrderInfo = this.categoryService.getCategoriesOrder(ownerAccountGuid);
        return new CategoryOrderInfoResponseResult("Get categories order success.", categoryOrderInfo);
    }

    @ApiResponses(value={@ApiResponse(code=490, message="Specified guid has been used.<BR>")})
    public MessageResponseResult createCategory(@RequestBody @Valid CategoryCreationVo categoryCreationVo) {
        AccountInfo accountInfo = SecurityUtils.getCurrentLoginUser();
        CategoryInfo categoryInfo = this.categoryService.createCategory(categoryCreationVo.getName(), accountInfo.getGuid(), categoryCreationVo.getClientCreatedCategoryGuid(), false);
        return new MessageResponseResult("Create category success", categoryInfo.getGuid());
    }

    public MessageResponseResult deleteCategory(@RequestParam String categoryGuid) {
        AccountInfo loginAccountInfo = SecurityUtils.getCurrentLoginUser();
        String categoryOwnerGuid = loginAccountInfo.getGuid();
        this.categoryService.verifyCategoryGuidsOfAccountAreNormal(Arrays.asList(categoryGuid), loginAccountInfo.getGuid());
        JobIdentify jobIdentify = new JobIdentify(DELETE_CATEGORY_JOB + categoryGuid, DeleteCategoryJob.class);
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("CATEGORY_OWNER_GUID", categoryOwnerGuid);
        dataMap.put("CATEGORY_GUID", categoryGuid);
        this.scheduleManager.startScheduleOnce(jobIdentify, null, dataMap);
        return new MessageResponseResult("Issue delete category job success", "nothing return");
    }

    public MessageResponseResult updateCategory(@RequestParam String categoryGuid, @RequestParam String categoryName) {
        if (categoryName.length() > 40) {
            throw new RequestArgumentNotValidException("Category name is too long.");
        }
        this.categoryService.verifyCategoryGuids(Arrays.asList(categoryGuid));
        return new MessageResponseResult("Update category success.", "nothing return");
    }

    public ListResponseResult<CategoryInfo> getPrivateCategories(@RequestParam String accountGuid) {
        this.accountService.verifyAccount(accountGuid, null);
        List categoryInfos = this.categoryService.getCategories(accountGuid);
        ListResponseResult result = new ListResponseResult("Get categories of account success.", categoryInfos);
        return result;
    }
}

