/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.mchange.v1.lang.BooleanUtils;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.ContactSimpleInfoDto;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.enums.ContactRangeType;
import com.penpower.worldcard.team.exception.SearchEngineInitializationNotFinshedException;
import com.penpower.worldcard.team.exception.SearchEngineNotRunningException;
import com.penpower.worldcard.team.exception.SearchEngineSpaceInsufficientException;
import com.penpower.worldcard.team.scheduler.job.RebuildElasticsearchIndexJob;
import com.penpower.worldcard.team.service.ContactPublicService;
import com.penpower.worldcard.team.service.ContactSearchService;
import com.penpower.worldcard.team.service.ContactService;
import com.penpower.worldcard.team.service.ElasticSearchService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.web.api.aop.RequestLimit;
import com.penpower.worldcard.team.web.api.vo.AdvancedSearchVo;
import com.penpower.worldcard.team.web.api.vo.PageInfoVo;
import com.penpower.worldcard.team.web.api.vo.response.PageResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/search/advanced"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"advanced search"}, description="\u9032\u968e\u641c\u5c0b\u76f8\u95dcapi")
@PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE)")
public class AdvancedSearchController {
    private static final Logger LOG = LoggerFactory.getLogger(AdvancedSearchController.class);
    @Autowired
    private ContactSearchService contactSearchService;
    @Autowired
    private ContactPublicService contactPublicService;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private ContactService contactService;
    @Autowired
    private ElasticSearchService elasticSearchService;

    @ApiOperation(value="", notes="\u6839\u64daContactRangeType\u641c\u5c0b\u516c\u6709\u5340\u53ca\u79c1\u6709\u5340\u540d\u7247<BR><BR>\u5728ContactInfoCondition\u548cCustomFieldCondition\u4e2d<BR>\u7b2c\u4e00\u7d44SearchInfo\u4e0d\u9700\u5305\u542blogicWithPreviousAllResults<BR>\u4e4b\u5f8c\u7684logicWithPreviousAllResults\u662f\u548c\u4e0a\u9762\u7684\u7d50\u679c\u505aAND\u6216OR<BR><BR>CustomFieldCondtion\u641c\u5c0b\u898f\u5247\uff1a\u7576CustomField\u7684CustomFieldContactAttribute\u70ba<BR>TEXT,EMAIL\uff1a\u4f7f\u7528keyword\u9032\u884c\u641c\u5c0b<BR>PICKLIST\uff1a\u4f7f\u7528picklistContentGuids\u9032\u884c\u641c\u5c0b<BR>NUMBER,FLOAT\uff1a\u4f7f\u7528numberInterval\u9032\u884c\u641c\u5c0b<BR>DATE,DATE_TIME\uff1a\u4f7f\u7528timeInterval\u9032\u884c\u641c\u5c0b<BR><BR>StatusCode:495<BR>\u5728\u78c1\u789f\u7a7a\u9593\u4e0d\u8db3\u6642\uff0c\u6703\u5c0e\u81f4\u4ee5\u4e0b\u5169\u7a2e\u72c0\u6cc1\uff1a<BR>1. \u641c\u5c0b\u5f15\u64ce\u5c1a\u672a\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u6703\u4e1ferrorCode:495 exception\uff0c\u8aaa\u660e\u56e0\u78c1\u789f\u7a7a\u9593\u4e0d\u8db3\u5c0e\u81f4searchEngine\u7121\u6cd5\u521d\u59cb\u5316<BR>2. \u641c\u5c0b\u5f15\u64ce\u521d\u59cb\u5316\u5df2\u5b8c\u6210\uff0c\u53ef\u4ee5\u641c\u5c0b\u5230\u8cc7\u6599\uff0c\u4f46[errorData]\u6703\u56de\u50b3495(type=int)\uff0c\u8aaa\u660e\u56e0\u78c1\u789f\u7a7a\u9593\u4e0d\u8db3\u5c0e\u81f4searchEngine\u7684index\u7121\u6cd5\u66f4\u65b0(\u641c\u5c0b\u5230\u820a\u8cc7\u6599)<BR><BR>StatusCode:491<BR>\u7b2c\u4e00\u6b21\u4f7f\u7528searchEngine\u6642\uff0c\u6703\u9032\u884c\u521d\u59cb\u5316\u7684\u52d5\u4f5c\uff0c\u82e5\u6b64\u6642\u9032\u884c\u641c\u5c0b\uff0c\u6703\u4e1ferrorCode:491 exception<BR>\u4e26\u5728[errorData]\u986f\u793a\u521d\u59cb\u5316\u5b8c\u6210\u9032\u5ea6\u7684\u767e\u5206\u6bd4(type=double)\u3002")
    @ApiResponses(value={@ApiResponse(code=494, message="Unspecified exception for searchEngine"), @ApiResponse(code=495, message="Search result are not up-to-date because of insufficient disk space"), @ApiResponse(code=491, message="Search engine initialization is not finished."), @ApiResponse(code=493, message="Search engine indexing data is missing"), @ApiResponse(code=492, message="Search engine is not running"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=425, message="Request limit exceeded , server busy."), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/search_contact"}, method={RequestMethod.POST})
    @RequestLimit(limitCount=4)
    public PageResponseResult<ContactSimpleInfoDto> searchPublicContact(@RequestBody(required=true) @Valid AdvancedSearchVo advancedSearchVo) {
        long startTime = System.currentTimeMillis();
        LOG.debug("advancedSearchVo:{}", (Object)advancedSearchVo);
        Globalinfo globalInfo = this.globalInfoService.getPropertiesByKey("ELASTIC_SEARCH_INDEXING_COMPLETE");
        boolean indexCompleteForWCT = BooleanUtils.parseBoolean((String)globalInfo.getConfigValue());
        if (!indexCompleteForWCT) {
            if (!this.elasticSearchService.searchEngineExist()) {
                throw new SearchEngineNotRunningException("Search engine is not running");
            }
            if (RebuildElasticsearchIndexJob.CURRENT_DISK_SPACE_INSUFFICIENT.get()) {
                throw new SearchEngineSpaceInsufficientException("Search engine initialization can't finished due to insufficient disk-space.");
            }
            double percent = this.contactService.getSearchEngineIndexInitializationPercentage();
            throw new SearchEngineInitializationNotFinshedException(Double.valueOf(percent));
        }
        if (RebuildElasticsearchIndexJob.CURRENT_DISK_SPACE_INSUFFICIENT.get()) {
            throw new SearchEngineSpaceInsufficientException("Search engine disk-space insufficient");
        }
        AccountInfo loginUser = SecurityUtils.getCurrentLoginUser();
        PageInfoVo contactSearchResult = this.contactSearchService.searchContactForAdvanced(advancedSearchVo, loginUser);
        if (ContactRangeType.PUBLIC.equals((Object)advancedSearchVo.getContactRangetype())) {
            this.contactPublicService.markDownloadStatusOfContactsByAccount((List)contactSearchResult.getPageContent(), loginUser.getGuid());
        }
        PageResponseResult response = new PageResponseResult("Search contact succeeded...", (List)contactSearchResult.getPageContent(), contactSearchResult.getTotalCount(), contactSearchResult.getTotalPage());
        long endTime = System.currentTimeMillis();
        LOG.debug("TotalSpendTime:{}", (Object)(endTime - startTime));
        return response;
    }
}

