/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.TimeUtil;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.CategoryDao;
import com.penpower.worldcard.team.dao.ContactDao;
import com.penpower.worldcard.team.dao.ContactStatusForAccountDao;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.CategoryInfo;
import com.penpower.worldcard.team.dto.ContactForSyncList;
import com.penpower.worldcard.team.dto.ContactProfile;
import com.penpower.worldcard.team.dto.mapper.DtoMapper;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Category;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.entity.Contactstatusforaccount;
import com.penpower.worldcard.team.enums.ActionType;
import com.penpower.worldcard.team.enums.ContactStatus;
import com.penpower.worldcard.team.enums.UpdateAction;
import com.penpower.worldcard.team.enums.UpdateComponent;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CategoryService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.SyncService;
import com.penpower.worldcard.team.service.impl.SyncServiceImpl;
import com.penpower.worldcard.team.web.api.vo.ContactCheckResultVo;
import com.penpower.worldcard.team.web.api.vo.ContactCompareAction;
import com.penpower.worldcard.team.web.api.vo.ContactForSync;
import com.penpower.worldcard.team.web.api.vo.ContactSyncInfo;
import com.penpower.worldcard.team.web.api.vo.ContactUpdateCheckVo;
import com.penpower.worldcard.team.web.api.vo.SyncInfo;
import com.penpower.worldcard.team.web.api.vo.SyncUpdateInfoVo;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SyncServiceImpl
implements SyncService {
    private static final Logger LOG = LoggerFactory.getLogger(SyncServiceImpl.class);
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private ContactDao contactDao;
    @Autowired
    private CategoryDao categoryDao;
    @Autowired
    ContactPrivateService contactService;
    @Autowired
    CategoryService categoryService;
    @Autowired
    ContactStatusForAccountDao contactStatusForAccountDao;
    @Autowired
    AccountService accountService;
    @Autowired
    @Qualifier(value="accountInfoDtoMapper")
    private DtoMapper<Account, AccountInfo> accountInfoDtoMapper;

    public UpdateAction CheckContactStatus(String contactGuid, String AccountGuid, DateTime modifyTime, ActionType actionType) {
        ContactProfile getContactProfile = this.contactService.getContactProfile(contactGuid, AccountGuid);
        LOG.debug("checksontact status id={} ,ac-{}", (Object)AccountGuid, (Object)actionType);
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ActionType[actionType.ordinal()]) {
            case 1: {
                if (getContactProfile != null) {
                    LOG.debug("getContactProfile = true");
                    if (!getContactProfile.isDeleted().booleanValue()) {
                        if (getContactProfile.getSyncModifyTime().isAfter((ReadableInstant)modifyTime)) {
                            return UpdateAction.UPDATE_CLIENT;
                        }
                        return UpdateAction.DEL_SERVER;
                    }
                    return UpdateAction.DEL_CLIENT;
                }
                LOG.debug("getContactProfile = false");
                return UpdateAction.DEL_CLIENT;
            }
            case 2: 
            case 3: {
                if (getContactProfile != null) {
                    if (getContactProfile.isDeleted().booleanValue()) {
                        if (getContactProfile.getSyncModifyTime().isAfter((ReadableInstant)modifyTime)) {
                            return UpdateAction.DEL_CLIENT;
                        }
                        if (getContactProfile.getDeletedFromShare().booleanValue()) {
                            return UpdateAction.DEL_CLIENT;
                        }
                        return UpdateAction.UPDATE_SERVER;
                    }
                    LOG.debug("CheckContactStatus getContactProfile.getSyncModifyTime()={},getContactProfile.getModifyTime()={},modifyTim={} ", new Object[]{getContactProfile.getSyncModifyTime(), getContactProfile.getModifyTime(), modifyTime});
                    if (getContactProfile.getSyncModifyTime().isAfter((ReadableInstant)modifyTime)) {
                        return UpdateAction.UPDATE_CLIENT;
                    }
                    if (!getContactProfile.getSyncModifyTime().isBefore((ReadableInstant)modifyTime)) break;
                    return UpdateAction.UPDATE_SERVER;
                }
                return UpdateAction.ADD_SERVER;
            }
        }
        return UpdateAction.DO_NOTHING;
    }

    public boolean CheckContactExist(String contactGuid, String AccountGuid) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            return false;
        }
        if (contact.getIsDeleted().booleanValue()) {
            return false;
        }
        Account curAccount = this.accountDao.findOne(AccountGuid);
        Contactstatusforaccount contactstatus = this.contactStatusForAccountDao.findFirstByAccountAndContact(curAccount, contact);
        if (contactstatus == null) {
            return false;
        }
        return contactstatus.getIsdeletedfromaccount() != true;
    }

    public ContactCheckResultVo CheckContactUpdateStats(ContactUpdateCheckVo contactUpdateCheckVo) {
        LOG.debug("CheckContactUpdateStats  VO= {}", (Object)contactUpdateCheckVo);
        ContactCheckResultVo contactCheckResultVo = new ContactCheckResultVo();
        ContactProfile contactProfile = this.contactService.getContactProfile(contactUpdateCheckVo.getContactGuid(), contactUpdateCheckVo.getAccountGuid());
        if (contactProfile == null) {
            contactCheckResultVo.setContactStatus(ContactStatus.CONTACT_NO_EXIST);
        } else {
            if (contactProfile.getSyncModifyTime().isAfter((ReadableInstant)contactUpdateCheckVo.getLastModifyTime())) {
                contactCheckResultVo.setContactStatus(ContactStatus.SERVER_IS_NEWER);
            } else if (contactProfile.getSyncModifyTime().isBefore((ReadableInstant)contactUpdateCheckVo.getLastModifyTime())) {
                contactCheckResultVo.setContactStatus(ContactStatus.CLIENT_IS_NEWER);
            } else {
                contactCheckResultVo.setContactStatus(ContactStatus.SAME_WITH_SERVER);
            }
            if (StringUtil.Compare((String)contactUpdateCheckVo.getContentSHA1(), (String)contactProfile.getTextSha1()) != 0) {
                contactCheckResultVo.getUpdateComponents().add(UpdateComponent.UC_CONTENT);
            }
            if (StringUtil.Compare((String)contactUpdateCheckVo.getAccountcanviewSHA1(), (String)contactProfile.getaccountcanviewSha1()) != 0) {
                contactCheckResultVo.getUpdateComponents().add(UpdateComponent.UC_SHARE_ACCOUNT);
            }
            if (StringUtil.Compare((String)contactUpdateCheckVo.getFrontImageSHA1(), (String)contactProfile.getFrontImageSha1()) != 0) {
                contactCheckResultVo.getUpdateComponents().add(UpdateComponent.UC_FRONT_IMAGE);
            }
            if (StringUtil.Compare((String)contactUpdateCheckVo.getBackImageSHA1(), (String)contactProfile.getRearImageSha1()) != 0) {
                contactCheckResultVo.getUpdateComponents().add(UpdateComponent.UC_BACK_IMAGE);
            }
            if (StringUtil.Compare((String)contactUpdateCheckVo.getLogoSHA1(), (String)contactProfile.getLogoImageSha1()) != 0) {
                contactCheckResultVo.getUpdateComponents().add(UpdateComponent.UC_LOGO);
            }
            if (StringUtil.Compare((String)contactUpdateCheckVo.getCategorySHA1(), (String)contactProfile.getCategorySha1()) != 0) {
                contactCheckResultVo.getUpdateComponents().add(UpdateComponent.UC_CATEGORY);
            }
        }
        LOG.debug("CheckContactUpdateStats  rtn= {}", (Object)contactCheckResultVo);
        return contactCheckResultVo;
    }

    public CategoryInfo getCategory(String categoryGuid) {
        Category category = (Category)this.categoryDao.findOne((Serializable)((Object)categoryGuid));
        if (category.isDeleted()) {
            return null;
        }
        CategoryInfo categoryInfo = new CategoryInfo(category);
        return categoryInfo;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public SyncUpdateInfoVo StartSync(SyncInfo syncInfo) {
        ContactCompareAction newContactCompareAction;
        boolean bFound;
        AccountInfo accountInfo = this.accountService.getAccountInfo(syncInfo.getAccountGuid(), null);
        Account curAccount = (Account)this.accountInfoDtoMapper.transformToEntity((Object)accountInfo);
        LOG.debug("StartSyncEE in  account ={} syncInfo={}", (Object)accountInfo.getName(), (Object)syncInfo);
        if (syncInfo.getIsContactContinueSeek() && !syncInfo.IsFirstSyncTimeValid() && syncInfo.getIsContactFirstSync()) {
            throw new RequestArgumentNotValidException("when IsContactContinueSeek == true FirstSyncTime must be validate");
        }
        ContactSyncInfo oldContactSyncInfo = null;
        for (ContactSyncInfo currContactSyncInfo : syncInfo.getContactSyncInfoList()) {
            if (oldContactSyncInfo != null && currContactSyncInfo.getContactGuid().compareToIgnoreCase(oldContactSyncInfo.getContactGuid()) <= 0) {
                throw new RequestArgumentNotValidException("ContactSyncInfoList must be sort by guid in ASC");
            }
            oldContactSyncInfo = currContactSyncInfo;
        }
        for (ContactSyncInfo currContactSyncInfo : syncInfo.getContactSyncInfoList()) {
        }
        SyncUpdateInfoVo syncUpdateInfo = new SyncUpdateInfoVo();
        if (syncInfo.getIsContactFirstSync() && !syncInfo.IsFirstSyncTimeValid() && !syncInfo.getIsContactContinueSeek()) {
            syncUpdateInfo.setFirstSyncTimeResult(new DateTime());
        } else {
            syncUpdateInfo.setFirstSyncTimeResult(syncInfo.getFirstSyncTime());
        }
        LOG.debug("StartSync  CheckValidate acount={}", (Object)accountInfo.getName());
        syncInfo.CheckValidate();
        LOG.debug("StartSync in syncimp syncInfo={}", (Object)syncInfo);
        DateTime ContactServerLastTime = TimeUtil.GetZeroTime();
        if (syncInfo.getContactLastRecTime().isAfter((ReadableInstant)ContactServerLastTime)) {
            ContactServerLastTime = syncInfo.getContactLastRecTime();
        }
        int nMaxCount = 300;
        LOG.debug("StartSync  getModifyContactsByAccount before acount={}", (Object)accountInfo.getName());
        boolean IsgetDeletedData = syncInfo.IsFirstSyncTimeValid() | syncInfo.getIsContactContinueSeek();
        ContactForSyncList contactForSyncList = this.contactService.getContactsModifiedByAccount(syncInfo.getContactLastRecTime(), syncInfo.getAccountGuid(), syncInfo.getIsContactFirstSync(), IsgetDeletedData, syncInfo.getFirstSyncTime(), nMaxCount, syncInfo.getContactContinueSeekTime(), syncInfo.getIsContactContinueSeek());
        syncUpdateInfo.setIsNeedContactContinueSeek(contactForSyncList.getisNeedContinue());
        syncUpdateInfo.setContactContinueSeekTimeResult(contactForSyncList.getlastRecordTime());
        if (contactForSyncList.getlastRecordTime().isAfter((ReadableInstant)ContactServerLastTime)) {
            ContactServerLastTime = contactForSyncList.getlastRecordTime();
        }
        LOG.debug("StartSync  getModifyContactsByAccount after acount={}", (Object)accountInfo.getName());
        boolean nIdxofSyncContact = false;
        for (ContactForSync currContact : contactForSyncList.getContactList()) {
            if (currContact.getModifyTime().isAfter((ReadableInstant)ContactServerLastTime)) {
                ContactServerLastTime = currContact.getModifyTime();
            }
            bFound = false;
            for (ContactSyncInfo currContactSyncInfo : syncInfo.getContactSyncInfoList()) {
                if (currContact.getGuid().compareToIgnoreCase(currContactSyncInfo.getContactGuid()) == 0) {
                    bFound = true;
                    LOG.debug("currContact = {}", (Object)currContact);
                    ContactCompareAction newContactCompareAction2 = new ContactCompareAction();
                    newContactCompareAction2.setContactGuid(currContact.getGuid());
                    newContactCompareAction2.setUpdateAction(UpdateAction.DO_NOTHING);
                    newContactCompareAction2.setLastModifyTime(currContact.getModifyTime());
                    switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ActionType[currContactSyncInfo.getAction().ordinal()]) {
                        case 2: 
                        case 3: {
                            if (currContact.getIsDeleted().booleanValue() || currContact.getDeletedFromShare().booleanValue()) {
                                if (currContact.getModifyTime().isBefore((ReadableInstant)currContactSyncInfo.getLastModifyTime())) {
                                    if (currContact.getDeletedFromShare().booleanValue()) {
                                        newContactCompareAction2.setUpdateAction(UpdateAction.DEL_CLIENT);
                                        break;
                                    }
                                    newContactCompareAction2.setUpdateAction(UpdateAction.UPDATE_SERVER);
                                    break;
                                }
                                newContactCompareAction2.setUpdateAction(UpdateAction.DEL_CLIENT);
                                break;
                            }
                            if (currContact.getModifyTime().isAfter((ReadableInstant)currContactSyncInfo.getLastModifyTime())) {
                                newContactCompareAction2.setUpdateAction(UpdateAction.UPDATE_CLIENT);
                                break;
                            }
                            if (!currContact.getModifyTime().isBefore((ReadableInstant)currContactSyncInfo.getLastModifyTime())) break;
                            newContactCompareAction2.setUpdateAction(UpdateAction.UPDATE_SERVER);
                            break;
                        }
                        case 1: {
                            if (currContact.getIsDeleted().booleanValue() || currContact.getDeletedFromShare().booleanValue()) break;
                            if (currContact.getModifyTime().isAfter((ReadableInstant)currContactSyncInfo.getLastModifyTime())) {
                                newContactCompareAction2.setUpdateAction(UpdateAction.ADD_OR_UPDATE_CLIENT);
                                break;
                            }
                            newContactCompareAction2.setUpdateAction(UpdateAction.DEL_SERVER);
                            break;
                        }
                    }
                    syncUpdateInfo.getContactCompareActionList().add(newContactCompareAction2);
                }
                if (!bFound) continue;
                break;
            }
            if (bFound) continue;
            if (currContact.getIsDeleted().booleanValue() || currContact.getDeletedFromShare().booleanValue()) {
                if (!syncInfo.getIsContactFirstSync()) {
                    newContactCompareAction = new ContactCompareAction();
                    newContactCompareAction.setContactGuid(currContact.getGuid());
                    newContactCompareAction.setUpdateAction(UpdateAction.DEL_CLIENT);
                    newContactCompareAction.setLastModifyTime(currContact.getModifyTime());
                    syncUpdateInfo.getContactCompareActionList().add(newContactCompareAction);
                    continue;
                }
                if (!syncInfo.IsFirstSyncTimeValid() || !currContact.getModifyTime().isAfter((ReadableInstant)syncInfo.getFirstSyncTime())) continue;
                newContactCompareAction = new ContactCompareAction();
                newContactCompareAction.setContactGuid(currContact.getGuid());
                newContactCompareAction.setUpdateAction(UpdateAction.DEL_CLIENT);
                newContactCompareAction.setLastModifyTime(currContact.getModifyTime());
                syncUpdateInfo.getContactCompareActionList().add(newContactCompareAction);
                continue;
            }
            newContactCompareAction = new ContactCompareAction();
            newContactCompareAction.setContactGuid(currContact.getGuid());
            newContactCompareAction.setUpdateAction(UpdateAction.ADD_OR_UPDATE_CLIENT);
            newContactCompareAction.setLastModifyTime(currContact.getModifyTime());
            syncUpdateInfo.getContactCompareActionList().add(newContactCompareAction);
        }
        for (ContactSyncInfo currContactSyncInfo : syncInfo.getContactSyncInfoList()) {
            if (syncInfo.getIsContactContinueSeek() && currContactSyncInfo.getLastModifyTime().isBefore((ReadableInstant)syncInfo.getContactContinueSeekTime()) || contactForSyncList.getisNeedContinue() && currContactSyncInfo.getLastModifyTime().isAfter((ReadableInstant)contactForSyncList.getlastRecordTime())) continue;
            bFound = false;
            for (ContactForSync currContact : contactForSyncList.getContactList()) {
                if (currContact.getGuid().compareToIgnoreCase(currContactSyncInfo.getContactGuid()) != 0) continue;
                bFound = true;
                break;
            }
            if (bFound) continue;
            newContactCompareAction = new ContactCompareAction();
            newContactCompareAction.setUpdateAction(UpdateAction.DO_NOTHING);
            newContactCompareAction.setContactGuid(currContactSyncInfo.getContactGuid());
            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ActionType[currContactSyncInfo.getAction().ordinal()]) {
                case 2: {
                    newContactCompareAction.setUpdateAction(UpdateAction.UNCHECK);
                    break;
                }
                case 3: {
                    newContactCompareAction.setUpdateAction(UpdateAction.UNCHECK);
                    break;
                }
                case 1: {
                    newContactCompareAction.setUpdateAction(UpdateAction.UNCHECK);
                }
            }
            syncUpdateInfo.getContactCompareActionList().add(newContactCompareAction);
        }
        LOG.debug("StartSync  comparecontact after acount={}", (Object)accountInfo.getName());
        for (ContactCompareAction CCAction : syncUpdateInfo.getContactCompareActionList()) {
            LOG.debug("acnt={},{}", (Object)accountInfo.getName(), (Object)CCAction.toString());
        }
        LOG.debug("StartSync  comparecontact after acount={} server_Time={}", (Object)accountInfo.getName(), (Object)ContactServerLastTime);
        syncUpdateInfo.setContactLastRecTimeResult(ContactServerLastTime);
        LOG.debug("StartSyncEE in end account ={} syncUpdateInfo={}", (Object)accountInfo.getName(), (Object)syncUpdateInfo);
        return syncUpdateInfo;
    }
}

