/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.DiskInfos;
import com.penpower.worldcard.team.Utils.FileSystemUtil;
import com.penpower.worldcard.team.Utils.HardwareIdUtil;
import com.penpower.worldcard.team.config.property.ApplicationProperties;
import com.penpower.worldcard.team.dao.ActivityDao;
import com.penpower.worldcard.team.dao.CompanyDao;
import com.penpower.worldcard.team.dao.TaskDao;
import com.penpower.worldcard.team.dto.AuthorizedInfoDto;
import com.penpower.worldcard.team.dto.StorageInfoDto;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.entity.Registry;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.StatisticsService;
import com.penpower.worldcard.team.service.SubscriptionService;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class StatisticsServiceImpl
implements StatisticsService {
    private static final Logger LOG = LoggerFactory.getLogger(StatisticsServiceImpl.class);
    @Autowired
    private TaskDao taskDao;
    @Autowired
    private ActivityDao activityDao;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private CompanyDao companyDao;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private RegistryService registryService;
    @Autowired
    private SubscriptionService subscriptionService;

    public AuthorizedInfoDto getAuthroizedInfo(String companyGuid) {
        AuthorizedInfoDto fake_authorizedInfoDto = new AuthorizedInfoDto();
        Registry registry = this.registryService.getSystemRegInfo(companyGuid);
        Company company = (Company)this.companyDao.findOne((Serializable)((Object)companyGuid));
        int count = this.registryService.getLicenseCount(true);
        fake_authorizedInfoDto.setMaxAccountSize(count);
        if (registry != null) {
            fake_authorizedInfoDto.setTime(registry.getUpdateTime());
            fake_authorizedInfoDto.setEmail(registry.getEmail());
            fake_authorizedInfoDto.setCompanyName(company == null ? "" : company.getName());
        }
        return fake_authorizedInfoDto;
    }

    public long getContactTotalCount(String companyGuid) {
        long count = this.contactPrivateService.getContactNumByAll(companyGuid);
        return count;
    }

    public long getTaskTotalCount() {
        long count = this.taskDao.count();
        return count;
    }

    public long getActivityTotalCount() {
        long count = this.activityDao.count();
        return count;
    }

    public StorageInfoDto getStorageInfo() {
        if (this.registryService.GetServerType() == ServerType.ASUSTOR_NAS || this.registryService.GetServerType() == ServerType.SYNOLOGY_NAS) {
            String fileSystemRootPath = this.applicationProperties.getProperty("FILE_SYSTEM_ROOT_PATH");
            Path fileSystemRoot = Paths.get(fileSystemRootPath, new String[0]);
            if (!HardwareIdUtil.linuxSystem()) {
                fileSystemRoot = fileSystemRoot.getRoot();
                LOG.debug("Windows platform found, change the path to root.... fileSystemRoot : {}", (Object)fileSystemRoot);
            }
            DiskInfos diskInfos = FileSystemUtil.getDiskInfos((Path)fileSystemRoot);
            LOG.debug("fileSystemRootPath : {} ", (Object)fileSystemRootPath);
            LOG.debug("fileSystemRoot : {} ", (Object)fileSystemRoot);
            LOG.debug("diskInfos : {} ", (Object)diskInfos);
            StorageInfoDto storageInfo = new StorageInfoDto();
            storageInfo.setCapacity(FileSystemUtil.convertToStringRepresentation((long)diskInfos.getTotalSpaceBytes()));
            storageInfo.setFreeSpace(FileSystemUtil.convertToStringRepresentation((long)diskInfos.getUsableSpaceBytes()));
            return storageInfo;
        }
        throw new AccessDeniedException("Can't access server");
    }
}

