/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.fatboyindustrial.gsonjodatime.Converters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.penpower.worldcard.team.Utils.OkHttpUtils;
import com.penpower.worldcard.team.crm.BasicToken;
import com.penpower.worldcard.team.crm.NullCRMToken;
import com.penpower.worldcard.team.crm.salesforce.SalesforceOAuthToken;
import com.penpower.worldcard.team.crm.salesforce.vo.contact.SalesforceContactInfoFully;
import com.penpower.worldcard.team.crm.salesforce.vo.contact.SalesforceContactQueryAllResult;
import com.penpower.worldcard.team.crm.salesforce.vo.contact.SalesforceContactSearchResult;
import com.penpower.worldcard.team.crm.salesforce.vo.lead.SalesforceLeadInfoFully;
import com.penpower.worldcard.team.crm.salesforce.vo.lead.SalesforceLeadQueryAllResult;
import com.penpower.worldcard.team.crm.salesforce.vo.lead.SalesforceLeadSearchResult;
import com.penpower.worldcard.team.crm.salesforce.vo.lead.SalesforceLeadtQueryAllResult;
import com.penpower.worldcard.team.exception.CRMOperationException;
import com.penpower.worldcard.team.service.SalesforceService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SalesforceServiceImpl
implements SalesforceService {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceServiceImpl.class);
    private static final String QUERY_ALL_BASE_URL = "/services/data/v39.0/queryAll";
    private static final String DELETE_CONTACT_BASE_URL = "/services/data/v39.0/sobjects/Contact/";
    private static final String DELETE_LEAD_BASE_URL = "/services/data/v39.0/sobjects/Lead/";
    private OkHttpClient client = new OkHttpClient.Builder().connectTimeout(3L, TimeUnit.MINUTES).writeTimeout(3L, TimeUnit.MINUTES).readTimeout(3L, TimeUnit.MINUTES).build();
    private Gson gson = Converters.registerDateTime((GsonBuilder)new GsonBuilder()).create();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contactDeleted(BasicToken basicToken, String CRMContactId) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        try {
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String queryAllUrl = salesforceAuthToken.getInstance_url() + QUERY_ALL_BASE_URL;
            String contactDeletedSoql = String.format("SELECT+id+FROM+Contact+WHERE+IsDeleted+=+true+AND+id+=+'%s'", CRMContactId);
            HttpUrl queryContactUrl = HttpUrl.parse((String)queryAllUrl).newBuilder().addEncodedQueryParameter("q", contactDeletedSoql).build();
            Request queryContactRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(queryContactUrl).build();
            try (Response queryDeletedContactResponse = this.client.newCall(queryContactRequest).execute();){
                if (!queryDeletedContactResponse.isSuccessful()) {
                    throw new IOException(OkHttpUtils.getResponseBodyString((Response)queryDeletedContactResponse));
                }
                String jsonString = OkHttpUtils.getResponseBodyString((Response)queryDeletedContactResponse);
                SalesforceContactSearchResult result = (SalesforceContactSearchResult)this.gson.fromJson(jsonString, SalesforceContactSearchResult.class);
                if (result == null || result.getTotalSize() <= 0) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            LOG.error("Fail to check contact was deleted...", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean leadDeleted(BasicToken basicToken, String CRMContactId) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        try {
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String queryAllUrl = salesforceAuthToken.getInstance_url() + QUERY_ALL_BASE_URL;
            String leadDeletedSoql = String.format("SELECT+id+FROM+Lead+WHERE+IsDeleted+=+true+AND+id+=+'%s'", CRMContactId);
            HttpUrl queryLeadUrl = HttpUrl.parse((String)queryAllUrl).newBuilder().addEncodedQueryParameter("q", leadDeletedSoql).build();
            Request queryLeadRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(queryLeadUrl).build();
            try (Response queryDeletedLeadResponse = this.client.newCall(queryLeadRequest).execute();){
                if (!queryDeletedLeadResponse.isSuccessful()) {
                    throw new IOException(OkHttpUtils.getResponseBodyString((Response)queryDeletedLeadResponse));
                }
                String jsonString = OkHttpUtils.getResponseBodyString((Response)queryDeletedLeadResponse);
                SalesforceLeadSearchResult result = (SalesforceLeadSearchResult)this.gson.fromJson(jsonString, SalesforceLeadSearchResult.class);
                if (result == null || result.getTotalSize() <= 0) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            LOG.error("fail to check leade was deledted....", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SalesforceContactInfoFully> getModifiedContactRecordsAfterSpecifiedTime(BasicToken basicToken, DateTime time) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        try {
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String queryAllUrl = salesforceAuthToken.getInstance_url() + QUERY_ALL_BASE_URL;
            String querySOQL = "SELECT Id,AccountId,LastName,FirstName,Salutation,OtherStreet,OtherCity,OtherState,OtherPostalCode,OtherCountry,MailingStreet,MailingCity,MailingState,MailingPostalCode, MailingCountry,Phone,Fax,MobilePhone,HomePhone,OtherPhone,Email,Title,Department, Birthdate,Description,CreatedDate,LastModifiedDate, LastViewedDate,LastReferencedDate,IsDeleted,Account.Name FROM Contact WHERE LastModifiedDate >= " + time.toString();
            HttpUrl queryContactUrl = HttpUrl.parse((String)queryAllUrl).newBuilder().addEncodedQueryParameter("q", querySOQL).build();
            Request queryContactRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(queryContactUrl).build();
            try (Response queryAllContactResponse = this.client.newCall(queryContactRequest).execute();){
                if (!queryAllContactResponse.isSuccessful()) {
                    throw new IOException(OkHttpUtils.getResponseBodyString((Response)queryAllContactResponse));
                }
                String jsonString = OkHttpUtils.getResponseBodyString((Response)queryAllContactResponse);
                SalesforceContactQueryAllResult result = (SalesforceContactQueryAllResult)this.gson.fromJson(jsonString, SalesforceContactQueryAllResult.class);
                if (result == null || result.getTotalSize() <= 0) {
                    ArrayList<SalesforceContactInfoFully> arrayList = new ArrayList<SalesforceContactInfoFully>();
                    return arrayList;
                }
                List list = result.getRecords();
                return list;
            }
        }
        catch (Exception ex) {
            LOG.error("Fail to query contact by specific time....", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SalesforceContactInfoFully getContactRecord(BasicToken basicToken, String contactID) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        try {
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String queryAllUrl = salesforceAuthToken.getInstance_url() + QUERY_ALL_BASE_URL;
            String querySOQL = "SELECT Id,AccountId,LastName,FirstName,Salutation,OtherStreet,OtherCity,OtherState,OtherPostalCode,OtherCountry,MailingStreet,MailingCity,MailingState,MailingPostalCode, MailingCountry,Phone,Fax,MobilePhone,HomePhone,OtherPhone,Email,Title,Department, Birthdate,Description,CreatedDate,LastModifiedDate, LastViewedDate,LastReferencedDate,IsDeleted,Account.Name FROM Contact WHERE Id  = '" + contactID + "'";
            HttpUrl queryContactUrl = HttpUrl.parse((String)queryAllUrl).newBuilder().addEncodedQueryParameter("q", querySOQL).build();
            Request queryContactRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(queryContactUrl).build();
            try (Response queryAllContactResponse = this.client.newCall(queryContactRequest).execute();){
                if (!queryAllContactResponse.isSuccessful()) {
                    throw new IOException(OkHttpUtils.getResponseBodyString((Response)queryAllContactResponse));
                }
                String jsonString = OkHttpUtils.getResponseBodyString((Response)queryAllContactResponse);
                SalesforceContactQueryAllResult result = (SalesforceContactQueryAllResult)this.gson.fromJson(jsonString, SalesforceContactQueryAllResult.class);
                if (result == null || result.getTotalSize() <= 0) {
                    SalesforceContactInfoFully salesforceContactInfoFully = null;
                    return salesforceContactInfoFully;
                }
                SalesforceContactInfoFully salesforceContactInfoFully = (SalesforceContactInfoFully)result.getRecords().get(0);
                return salesforceContactInfoFully;
            }
        }
        catch (Exception ex) {
            LOG.error("Fail to query contact by specific time....", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SalesforceLeadInfoFully> getModifiedLeadRecordsAfterSpecifiedTime(BasicToken basicToken, DateTime time) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        try {
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String queryAllUrl = salesforceAuthToken.getInstance_url() + QUERY_ALL_BASE_URL;
            String querySOQL = "SELECT Id,LastName,FirstName,Salutation,Phone,MobilePhone,Fax,Email, Website,Description,Title,Company,Street,City,State,PostalCode, Country,CreatedDate,LastModifiedDate,LastViewedDate,LastReferencedDate,IsDeleted FROM Lead WHERE LastModifiedDate > " + time.toString();
            HttpUrl queryLeadUrl = HttpUrl.parse((String)queryAllUrl).newBuilder().addEncodedQueryParameter("q", querySOQL).build();
            Request queryLeadRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(queryLeadUrl).build();
            try (Response queryAllLeadResponse = this.client.newCall(queryLeadRequest).execute();){
                if (!queryAllLeadResponse.isSuccessful()) {
                    throw new IOException(OkHttpUtils.getResponseBodyString((Response)queryAllLeadResponse));
                }
                String jsonString = OkHttpUtils.getResponseBodyString((Response)queryAllLeadResponse);
                SalesforceLeadQueryAllResult result = (SalesforceLeadQueryAllResult)this.gson.fromJson(jsonString, SalesforceLeadQueryAllResult.class);
                if (result == null || result.getTotalSize() <= 0) {
                    ArrayList<SalesforceLeadInfoFully> arrayList = new ArrayList<SalesforceLeadInfoFully>();
                    return arrayList;
                }
                List list = result.getRecords();
                return list;
            }
        }
        catch (Exception ex) {
            LOG.error("Fail to query contact by specific time....", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SalesforceLeadInfoFully getLeadRecord(BasicToken basicToken, String leadID) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        try {
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String queryAllUrl = salesforceAuthToken.getInstance_url() + QUERY_ALL_BASE_URL;
            String querySOQL = "SELECT Id,LastName,FirstName,Salutation,Phone,MobilePhone,Fax,Email, Website,Description,Title,Company,Street,City,State,PostalCode, Country,CreatedDate,LastModifiedDate,LastViewedDate,LastReferencedDate,IsDeleted FROM Lead WHERE Id  = '" + leadID + "'";
            HttpUrl queryLeadUrl = HttpUrl.parse((String)queryAllUrl).newBuilder().addEncodedQueryParameter("q", querySOQL).build();
            Request queryLeatRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(queryLeadUrl).build();
            try (Response queryAllLeadResponse = this.client.newCall(queryLeatRequest).execute();){
                if (!queryAllLeadResponse.isSuccessful()) {
                    throw new IOException(OkHttpUtils.getResponseBodyString((Response)queryAllLeadResponse));
                }
                String jsonString = OkHttpUtils.getResponseBodyString((Response)queryAllLeadResponse);
                SalesforceLeadtQueryAllResult result = (SalesforceLeadtQueryAllResult)this.gson.fromJson(jsonString, SalesforceLeadtQueryAllResult.class);
                if (result == null || result.getTotalSize() <= 0) {
                    SalesforceLeadInfoFully salesforceLeadInfoFully = null;
                    return salesforceLeadInfoFully;
                }
                SalesforceLeadInfoFully salesforceLeadInfoFully = (SalesforceLeadInfoFully)result.getRecords().get(0);
                return salesforceLeadInfoFully;
            }
        }
        catch (Exception ex) {
            LOG.error("Fail to query lead by specific time....", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteContact(BasicToken basicToken, String CRMContactId) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        try {
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String deleteContactUrl = salesforceAuthToken.getInstance_url() + DELETE_CONTACT_BASE_URL + CRMContactId;
            Request deleteContactRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(deleteContactUrl).delete().build();
            try (Response deleteContactResponse = this.client.newCall(deleteContactRequest).execute();){
                if (!deleteContactResponse.isSuccessful()) {
                    throw new IOException(OkHttpUtils.getResponseBodyString((Response)deleteContactResponse));
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            LOG.error("Fail to delete contact...", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteLead(BasicToken basicToken, String CRMLeadId) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        try {
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String deleteLeadUrl = salesforceAuthToken.getInstance_url() + DELETE_LEAD_BASE_URL + CRMLeadId;
            Request deleteLeadRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(deleteLeadUrl).delete().build();
            try (Response deleteLeadResponse = this.client.newCall(deleteLeadRequest).execute();){
                if (!deleteLeadResponse.isSuccessful()) {
                    throw new IOException(OkHttpUtils.getResponseBodyString((Response)deleteLeadResponse));
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            LOG.error("Fail to delete lead...", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
    }
}

