/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.crm.BasicToken;
import com.penpower.worldcard.team.crm.salesforce.vo.lead.SalesforceLeadInfoFully;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.ContactDao;
import com.penpower.worldcard.team.dao.ContactStatusForAccountDao;
import com.penpower.worldcard.team.dto.CRMSettingsDto;
import com.penpower.worldcard.team.dto.ContactInfoForRequest;
import com.penpower.worldcard.team.dto.ContactInfoForResponse;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.entity.Contactstatusforaccount;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.CRMOperationService;
import com.penpower.worldcard.team.service.SalesforceExportService;
import com.penpower.worldcard.team.service.SalesforceService;
import com.penpower.worldcard.team.web.api.vo.ContactCreationVo;
import com.penpower.worldcard.team.web.api.vo.ContactCrmSyncInfoForCRM;
import com.penpower.worldcard.team.web.api.vo.ContactCrmSyncInfoForWCT;
import com.penpower.worldcard.team.web.api.vo.ContactUpdateVo;
import java.io.Serializable;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="SalesforceLeadOperation")
@Transactional
public class SalesforceLeadOperation
implements CRMOperationService {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceLeadOperation.class);
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private ContactDao contactDao;
    @Autowired
    private ContactStatusForAccountDao contactStatusForAccountDao;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private SalesforceExportService salesforceExportService;
    @Autowired
    private SalesforceService salesforceBasicService;
    @Autowired
    private SalesforceService salesforceService;

    public String getExportedCrmID(String accountGuid, String contactGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            throw new ItemNotFoundException("[getExportedCrmID]: Can not find account.");
        }
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            throw new ItemNotFoundException("[getExportedCrmID]: Can not find contact.");
        }
        Contactstatusforaccount status = this.contactStatusForAccountDao.findFirstByAccountAndContact(account, contact);
        if (status == null) {
            throw new ItemNotFoundException("[getExportedCrmID]: Can not find status.");
        }
        CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
        String crmAccount = crmSettingsDto.getUserCRMAccount();
        String crmID = status.getExporttosalesforceleadid();
        if (crmAccount.equals(status.getSalesforceaccount())) {
            return crmID;
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void setExportCrmInfo(String accountGuid, String contactGuid, String exportedCrmRecordID, String exportedCrmAccount, DateTime crmRecordModifyTime) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            throw new ItemNotFoundException("[setExportCrmInfo]: Can not find account.");
        }
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            throw new ItemNotFoundException("[setExportCrmInfo]: Can not find contact.");
        }
        Contactstatusforaccount status = this.contactStatusForAccountDao.findFirstByAccountAndContact(account, contact);
        if (status == null) {
            throw new ItemNotFoundException("[setExportCrmInfo]: Can not find status.");
        }
        if (exportedCrmRecordID != null) {
            status.setExporttosalesforceleadid(exportedCrmRecordID);
        }
        if (exportedCrmAccount != null) {
            status.setSalesforceaccount(exportedCrmAccount);
        }
        if (crmRecordModifyTime != null) {
            status.setPreviousModifiedTimeForSalesforceLead(crmRecordModifyTime);
        }
        this.contactStatusForAccountDao.save((Object)status);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public String exportContactToCRM(String accountGuid, ContactInfoForResponse contactInfo, boolean isForSync, BasicToken basicToken) {
        CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
        String retCrmID = this.salesforceExportService.createNewLeadRecord(basicToken, (ContactInfoForRequest)contactInfo);
        DateTime crmModifyTime = null;
        if (isForSync) {
            ContactCrmSyncInfoForCRM record = this.getRecordSyncInfo(accountGuid, retCrmID, basicToken);
            if (record == null) {
                throw new ItemNotFoundException("Contact exported, but get corresponding CRM record failed.");
            }
            crmModifyTime = record.getModifiedTime();
        }
        this.setExportCrmInfo(accountGuid, contactInfo.getGuid(), retCrmID, crmSettingsDto.getUserCRMAccount(), crmModifyTime);
        return retCrmID;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void updateContactToCRM(String accountGuid, ContactInfoForResponse contactInfo, String crmID, boolean isForSync, BasicToken basicToken) {
        if (this.salesforceBasicService.leadDeleted(basicToken, crmID)) {
            this.exportContactToCRM(accountGuid, contactInfo, isForSync, basicToken);
        } else {
            this.salesforceExportService.updateLeadRecord(basicToken, crmID, (ContactInfoForRequest)contactInfo);
            if (isForSync) {
                ContactCrmSyncInfoForCRM record = this.getRecordSyncInfo(accountGuid, crmID, basicToken);
                if (record == null) {
                    throw new ItemNotFoundException("CRM record udpated, but get it back failed.");
                }
                this.setExportCrmInfo(accountGuid, contactInfo.getGuid(), null, null, record.getModifiedTime());
            }
        }
    }

    public List<ContactCrmSyncInfoForWCT> getWctSyncInfosByAccount(String accountGuid, DateTime lastSyncCompletedTime) {
        return null;
    }

    public ContactCrmSyncInfoForCRM getRecordSyncInfo(String accountGuid, String crmID, BasicToken basicToken) {
        if (StringUtil.IsStringNullorEmpty((String)crmID)) {
            return null;
        }
        CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
        SalesforceLeadInfoFully record = this.salesforceService.getLeadRecord(basicToken, crmID);
        if (record == null) {
            return null;
        }
        return new ContactCrmSyncInfoForCRM(crmID, Boolean.valueOf(record.isIsDeleted()), record.getLastModifiedDate(), crmSettingsDto.getUserCRMAccount());
    }

    public void deleteRecord(String accountGuid, String crmID, String contactGuid, boolean isForSync, BasicToken basicToken) {
    }

    public List<ContactCrmSyncInfoForCRM> getCrmSyncInfosByAccount(String accountGuid, DateTime lastSyncCompletedTime, BasicToken basicToken) {
        return null;
    }

    public ContactCrmSyncInfoForWCT getWctSyncInfoByCorrespondingCrmSyncInfo(String accountGuid, ContactCrmSyncInfoForCRM syncInfoCRM) {
        return null;
    }

    public ContactCreationVo getContactCreationVoByCrmID(String accountGuid, String crmID, BasicToken basicToken) {
        return null;
    }

    public void exportContactCheck(ContactInfoForResponse contact) {
    }

    public ContactUpdateVo getContactUpdateVoByCrmID(ContactCrmSyncInfoForWCT syncInfoWCT, BasicToken basicToken, ContactInfoForRequest originContact) {
        return null;
    }
}

