/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.fatboyindustrial.gsonjodatime.Converters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.OkHttpUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.crm.BasicToken;
import com.penpower.worldcard.team.crm.NullCRMToken;
import com.penpower.worldcard.team.crm.salesforce.SalesforceOAuthToken;
import com.penpower.worldcard.team.crm.salesforce.vo.CreateRecordResponse;
import com.penpower.worldcard.team.crm.salesforce.vo.SalesForceSearchRecord;
import com.penpower.worldcard.team.crm.salesforce.vo.SalesforceAccountInfo;
import com.penpower.worldcard.team.crm.salesforce.vo.SalesforceAccountSearchResult;
import com.penpower.worldcard.team.crm.salesforce.vo.SalesforceLeadInfo;
import com.penpower.worldcard.team.crm.salesforce.vo.contact.SalesforceContactInfo;
import com.penpower.worldcard.team.dto.ContactInfoForRequest;
import com.penpower.worldcard.team.dto.ContactaddressInfo;
import com.penpower.worldcard.team.dto.ContactemailInfo;
import com.penpower.worldcard.team.dto.ContactjobinfoInfo;
import com.penpower.worldcard.team.dto.ContactnameInfo;
import com.penpower.worldcard.team.dto.ContactphoneInfo;
import com.penpower.worldcard.team.dto.ContacturlInfo;
import com.penpower.worldcard.team.enums.ContactFieldType;
import com.penpower.worldcard.team.enums.ContactPhoneType;
import com.penpower.worldcard.team.enums.ContactUrlType;
import com.penpower.worldcard.team.exception.CRMOperationException;
import com.penpower.worldcard.team.service.SalesforceExportService;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SalesforceExportServiceImpl
implements SalesforceExportService {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceExportServiceImpl.class);
    private static final String ACCOUNT_RECORD_BASE_URL = "/services/data/v39.0/sobjects/Account/";
    private static final String PARAMETERIZED_SEARCH_BASE_URL = "/services/data/v39.0/parameterizedSearch/";
    private static final String QUERY_BASE_URL = "/services/data/v39.0/query";
    private static final String CONTACT_RECORD_BASE_URL = "/services/data/v39.0/sobjects/Contact/";
    private static final String LEAD_RECORD_BASE_URL = "/services/data/v39.0/sobjects/Lead/";
    private OkHttpClient client = new OkHttpClient.Builder().connectTimeout(3L, TimeUnit.MINUTES).writeTimeout(3L, TimeUnit.MINUTES).readTimeout(3L, TimeUnit.MINUTES).build();
    private Gson gson = Converters.registerDateTime((GsonBuilder)new GsonBuilder()).create();

    public String createNewContactRecord(BasicToken basicToken, ContactInfoForRequest contactInfo) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        String newContactId = null;
        try {
            SalesforceContactInfo newSalesforceContact = this.getSalesforceContactInfo(contactInfo);
            this.fillJobInfoRelatedValues(contactInfo, basicToken, newSalesforceContact);
            LOG.debug("newSalesforceContact : {} ", (Object)newSalesforceContact);
            newContactId = this.createNewContact(basicToken, newSalesforceContact);
        }
        catch (Exception ex) {
            LOG.error("Fail to create new contact", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
        return newContactId;
    }

    private void fillJobInfoRelatedValues(ContactInfoForRequest contactInfo, BasicToken basicToken, SalesforceContactInfo salesforceContact) throws Exception {
        Optional jobInfo = GlobalUtils.getFirstListItem((List)contactInfo.getJobinfos());
        LOG.debug("Check jobInfo : {} ", (Object)jobInfo);
        String companyName = "";
        if (jobInfo.isPresent()) {
            salesforceContact.setDepartment(((ContactjobinfoInfo)jobInfo.get()).getDepartment());
            salesforceContact.setTitle(((ContactjobinfoInfo)jobInfo.get()).getJobTitle());
            companyName = ((ContactjobinfoInfo)jobInfo.get()).getCompanyName();
        }
        if (!StringUtil.IsStringNullorEmpty((String)companyName)) {
            SalesforceAccountSearchResult searchResult = this.searchAccountNameByCompanyName(basicToken, companyName);
            LOG.debug("Check searc account by companyName result : {} ", (Object)searchResult);
            if (searchResult != null) {
                List searchRecords = searchResult.getRecords();
                LOG.debug("searchRecords : {} ", (Object)searchRecords);
                if (this.companyNameForAccountExists(searchRecords)) {
                    SalesForceSearchRecord searchAccount = (SalesForceSearchRecord)searchRecords.stream().findFirst().get();
                    salesforceContact.setAccountId(searchAccount.getId());
                } else {
                    SalesforceAccountInfo newAccount = new SalesforceAccountInfo();
                    this.fillNewAccountValues(salesforceContact, companyName, newAccount);
                    LOG.debug("account for company not exits , create new one : {} ", (Object)newAccount);
                    String newAccountJson = this.gson.toJson((Object)newAccount);
                    String newAccountId = this.createNewAccount(basicToken, newAccountJson);
                    salesforceContact.setAccountId(newAccountId);
                }
            }
        }
    }

    private String createNewContact(BasicToken basicToken, SalesforceContactInfo newSalesforceContact) throws IOException {
        LOG.debug("create new Contact , execute salsesforce create contact RESTful api .....");
        SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
        String createNewContactUrl = salesforceAuthToken.getInstance_url() + CONTACT_RECORD_BASE_URL;
        String newContactJson = this.gson.toJson((Object)newSalesforceContact);
        LOG.debug("Create new contact url : {} ", (Object)createNewContactUrl);
        MediaType JSON = MediaType.parse((String)"application/json;charset=UTF-8");
        RequestBody body = RequestBody.create((MediaType)JSON, (String)newContactJson);
        Request createNewContactRequest = new Request.Builder().url(createNewContactUrl).post(body).addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).build();
        try (Response createNewContactResponse = this.client.newCall(createNewContactRequest).execute();){
            if (!createNewContactResponse.isSuccessful()) {
                throw new CRMOperationException(OkHttpUtils.getResponseBodyString((Response)createNewContactResponse));
            }
            String createNewContactResponseJsonBody = OkHttpUtils.getResponseBodyString((Response)createNewContactResponse);
            CreateRecordResponse result = (CreateRecordResponse)this.gson.fromJson(createNewContactResponseJsonBody, CreateRecordResponse.class);
            String string = result.getId();
            return string;
        }
    }

    private void fillNewAccountValues(SalesforceContactInfo newSalesforceContact, String companyName, SalesforceAccountInfo newAccount) {
        newAccount.setName(companyName);
        newAccount.setFax(newSalesforceContact.getFax());
        newAccount.setPhone(newSalesforceContact.getPhone());
        newAccount.setBillingCity(newSalesforceContact.getMailingCity());
        newAccount.setBillingCountry(newSalesforceContact.getMailingCountry());
        newAccount.setBillingPostalCode(newSalesforceContact.getMailingPostalCode());
        newAccount.setBillingState(newSalesforceContact.getMailingState());
        newAccount.setBillingStreet(newSalesforceContact.getMailingStreet());
        newAccount.setShippingCity(newSalesforceContact.getOtherCity());
        newAccount.setShippingCountry(newSalesforceContact.getOtherCountry());
        newAccount.setShippingPostalCode(newSalesforceContact.getOtherPostalCode());
        newAccount.setShippingState(newSalesforceContact.getOtherState());
        newAccount.setShippingStreet(newSalesforceContact.getOtherStreet());
    }

    private String createNewAccount(BasicToken basicToken, String newAccountJson) throws Exception {
        LOG.debug("create new Account , execute salsesforce create account RESTful api .....");
        SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
        String createNewAccountUrl = salesforceAuthToken.getInstance_url() + ACCOUNT_RECORD_BASE_URL;
        MediaType JSON = MediaType.parse((String)"application/json;charset=UTF-8");
        RequestBody newAccountRequestBody = RequestBody.create((MediaType)JSON, (String)newAccountJson);
        LOG.debug("Create new account url : {} ", (Object)createNewAccountUrl);
        Request createNewAccountRequest = new Request.Builder().url(createNewAccountUrl).post(newAccountRequestBody).addHeader("Authorization", "Bearer " + salesforceAuthToken.getAccess_token()).build();
        try (Response createNewAccountResponse = this.client.newCall(createNewAccountRequest).execute();){
            if (!createNewAccountResponse.isSuccessful()) {
                throw new CRMOperationException(OkHttpUtils.getResponseBodyString((Response)createNewAccountResponse));
            }
            String createNewAccountResponseJsonBody = OkHttpUtils.getResponseBodyString((Response)createNewAccountResponse);
            CreateRecordResponse result = (CreateRecordResponse)this.gson.fromJson(createNewAccountResponseJsonBody, CreateRecordResponse.class);
            String string = result.getId();
            return string;
        }
    }

    private boolean companyNameForAccountExists(List<SalesForceSearchRecord> searchRecords) {
        return searchRecords != null && searchRecords.size() > 0;
    }

    private SalesforceAccountSearchResult searchAccountNameByCompanyName(BasicToken basicToken, String companyName) {
        LOG.debug("Search account by companyName , execute salsesforce search account RESTful api .....");
        SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
        String queryUrl = salesforceAuthToken.getInstance_url() + QUERY_BASE_URL;
        LOG.debug("Search account url  : {} ", (Object)queryUrl);
        String queryAccountSoql = String.format("SELECT+id,name+FROM+Account+WHERE+name+=+'%s'", companyName);
        HttpUrl searchAccountUrl = HttpUrl.parse((String)queryUrl).newBuilder().addEncodedQueryParameter("q", queryAccountSoql).build();
        Request searchAccountRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(searchAccountUrl).build();
        SalesforceAccountSearchResult searchRecords = null;
        try (Response searchAccountResponse = this.client.newCall(searchAccountRequest).execute();){
            if (!searchAccountResponse.isSuccessful()) {
                throw new CRMOperationException(OkHttpUtils.getResponseBodyString((Response)searchAccountResponse));
            }
            String jsonBody = OkHttpUtils.getResponseBodyString((Response)searchAccountResponse);
            searchRecords = (SalesforceAccountSearchResult)this.gson.fromJson(jsonBody, SalesforceAccountSearchResult.class);
        }
        catch (Exception ex) {
            LOG.error("Fail to execute search account RESTful api ....", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
        return searchRecords;
    }

    private SalesforceContactInfo getSalesforceContactInfo(ContactInfoForRequest contactInfo) {
        Optional<DateTime> birthday;
        Optional businessMail;
        Optional otherAddress;
        Optional businessAddress;
        Optional businessFax;
        Optional otherPhone;
        Optional mobilePhone;
        Optional businessPhone;
        Optional homePhone;
        SalesforceContactInfo newSalesforceContact = new SalesforceContactInfo();
        Optional name = GlobalUtils.getFirstListItem((List)contactInfo.getNames());
        if (name.isPresent()) {
            newSalesforceContact.setLastName(((ContactnameInfo)name.get()).getLastName());
            newSalesforceContact.setFirstName(((ContactnameInfo)name.get()).getFirstName());
            newSalesforceContact.setSalutation(((ContactnameInfo)name.get()).getSuffix());
        }
        if ((homePhone = this.getContactphoneInfoByPhoneType(contactInfo.getPhones(), ContactPhoneType.HOME_TEL)).isPresent()) {
            newSalesforceContact.setHomePhone(((ContactphoneInfo)homePhone.get()).getValue());
        }
        if ((businessPhone = this.getContactphoneInfoByPhoneType(contactInfo.getPhones(), ContactPhoneType.BUSINESS_TEL)).isPresent()) {
            newSalesforceContact.setPhone(((ContactphoneInfo)businessPhone.get()).getValue());
        }
        if ((mobilePhone = this.getContactphoneInfoByPhoneType(contactInfo.getPhones(), ContactPhoneType.CELL)).isPresent()) {
            newSalesforceContact.setMobilePhone(((ContactphoneInfo)mobilePhone.get()).getValue());
        }
        if ((otherPhone = this.getContactphoneInfoByPhoneType(contactInfo.getPhones(), ContactPhoneType.OTHER_TEL)).isPresent()) {
            newSalesforceContact.setOtherPhone(((ContactphoneInfo)otherPhone.get()).getValue());
        }
        if ((businessFax = this.getContactphoneInfoByPhoneType(contactInfo.getPhones(), ContactPhoneType.BUSINESS_FAX)).isPresent()) {
            newSalesforceContact.setFax(((ContactphoneInfo)businessFax.get()).getValue());
        }
        if ((businessAddress = this.getContactaddressInfoByType(contactInfo.getAddresses(), ContactFieldType.BUSINESS)).isPresent()) {
            newSalesforceContact.setMailingCountry(((ContactaddressInfo)businessAddress.get()).getCountryName());
            newSalesforceContact.setMailingCity(((ContactaddressInfo)businessAddress.get()).getCity());
            newSalesforceContact.setMailingState(((ContactaddressInfo)businessAddress.get()).getState());
            newSalesforceContact.setMailingPostalCode(((ContactaddressInfo)businessAddress.get()).getZip());
            newSalesforceContact.setMailingStreet(((ContactaddressInfo)businessAddress.get()).getStreet());
        }
        if ((otherAddress = this.getContactaddressInfoByType(contactInfo.getAddresses(), ContactFieldType.OTHER)).isPresent()) {
            newSalesforceContact.setOtherCountry(((ContactaddressInfo)otherAddress.get()).getCountryName());
            newSalesforceContact.setOtherCity(((ContactaddressInfo)otherAddress.get()).getCity());
            newSalesforceContact.setOtherState(((ContactaddressInfo)otherAddress.get()).getState());
            newSalesforceContact.setOtherPostalCode(((ContactaddressInfo)otherAddress.get()).getZip());
            newSalesforceContact.setOtherStreet(((ContactaddressInfo)otherAddress.get()).getStreet());
        }
        if ((businessMail = this.getContactemailInfoByType(contactInfo.getEmails(), ContactFieldType.BUSINESS)).isPresent()) {
            newSalesforceContact.setEmail(((ContactemailInfo)businessMail.get()).getValue());
        }
        if ((birthday = Optional.ofNullable(contactInfo.getBirthday())).isPresent()) {
            DateTimeFormatter dtfOut = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
            String birthDayString = dtfOut.print((ReadableInstant)birthday.get());
            newSalesforceContact.setBirthdate(birthDayString);
        }
        newSalesforceContact.setDescription(contactInfo.getNote());
        return newSalesforceContact;
    }

    private Optional<ContactemailInfo> getContactemailInfoByType(List<ContactemailInfo> emailsIn, ContactFieldType contactFieldType) {
        List emails = Optional.ofNullable(emailsIn).orElse(Collections.emptyList());
        Optional<ContactemailInfo> resultEmail = emails.stream().filter(email -> contactFieldType.equals((Object)email.getType())).findFirst();
        return resultEmail;
    }

    private Optional<ContactaddressInfo> getContactaddressInfoByType(List<ContactaddressInfo> addressesIn, ContactFieldType contactFieldType) {
        List addresses = Optional.ofNullable(addressesIn).orElse(Collections.emptyList());
        Optional<ContactaddressInfo> resultAddress = addresses.stream().filter(address -> contactFieldType.equals((Object)address.getType())).findFirst();
        return resultAddress;
    }

    private Optional<ContacturlInfo> getContacturlInfoByType(List<ContacturlInfo> urls, ContactUrlType business) {
        List urlInfos = Optional.ofNullable(urls).orElse(Collections.emptyList());
        Optional<ContacturlInfo> urlInfosResult = urlInfos.stream().filter(urlInfo -> business.equals((Object)urlInfo.getType())).findFirst();
        return urlInfosResult;
    }

    private Optional<ContactphoneInfo> getContactphoneInfoByPhoneType(List<ContactphoneInfo> phonesIn, ContactPhoneType contactPhoneType) {
        List phones = Optional.ofNullable(phonesIn).orElse(Collections.emptyList());
        Optional<ContactphoneInfo> resultPhone = phones.stream().filter(phone -> contactPhoneType.equals((Object)phone.getType())).findFirst();
        return resultPhone;
    }

    public void updateContactRecord(BasicToken basicToken, String CRMRecordId, ContactInfoForRequest contactInfo) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        try {
            SalesforceContactInfo salesforceContactUpdated = this.getSalesforceContactInfo(contactInfo);
            this.fillJobInfoRelatedValues(contactInfo, basicToken, salesforceContactUpdated);
            LOG.debug("Update contact : {}", (Object)salesforceContactUpdated);
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String updateContactUrl = salesforceAuthToken.getInstance_url() + CONTACT_RECORD_BASE_URL + CRMRecordId;
            String contactUpdatedJson = this.gson.toJson((Object)salesforceContactUpdated);
            LOG.debug("updateContactUrl : {} ", (Object)updateContactUrl);
            MediaType JSON = MediaType.parse((String)"application/json;charset=UTF-8");
            RequestBody body = RequestBody.create((MediaType)JSON, (String)contactUpdatedJson);
            Request contactUpdatedRequest = new Request.Builder().url(updateContactUrl).patch(body).addHeader("Authorization", "Bearer " + salesforceAuthToken.getAccess_token()).build();
            try (Response contactUpdatedResponse = this.client.newCall(contactUpdatedRequest).execute();){
                if (!contactUpdatedResponse.isSuccessful()) {
                    throw new CRMOperationException(OkHttpUtils.getResponseBodyString((Response)contactUpdatedResponse));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Fail to update contact ...", (Throwable)e);
            throw new CRMOperationException(e.getMessage());
        }
    }

    public String createNewLeadRecord(BasicToken basicToken, ContactInfoForRequest contactInfo) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        SalesforceLeadInfo salesforceLeadInfo = this.fillLeadValues(contactInfo);
        String newLeadId = null;
        try {
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String createNewLeadUrl = salesforceAuthToken.getInstance_url() + LEAD_RECORD_BASE_URL;
            String newLeadJson = this.gson.toJson((Object)salesforceLeadInfo);
            MediaType jsonMediaType = MediaType.parse((String)"application/json;charset=UTF-8");
            RequestBody newLeadRequestBody = RequestBody.create((MediaType)jsonMediaType, (String)newLeadJson);
            Request createNewLeadRequest = new Request.Builder().url(createNewLeadUrl).post(newLeadRequestBody).addHeader("Authorization", "Bearer " + salesforceAuthToken.getAccess_token()).build();
            try (Response createNewLeadResponse = this.client.newCall(createNewLeadRequest).execute();){
                if (!createNewLeadResponse.isSuccessful()) {
                    throw new IOException(OkHttpUtils.getResponseBodyString((Response)createNewLeadResponse));
                }
                String createNewLeadResponseJsonBody = OkHttpUtils.getResponseBodyString((Response)createNewLeadResponse);
                CreateRecordResponse createNewLeadResponseRst = (CreateRecordResponse)this.gson.fromJson(createNewLeadResponseJsonBody, CreateRecordResponse.class);
                newLeadId = createNewLeadResponseRst.getId();
            }
        }
        catch (Exception ex) {
            LOG.error("Fail to create new lead..", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
        return newLeadId;
    }

    private SalesforceLeadInfo fillLeadValues(ContactInfoForRequest contactInfo) {
        Optional urls;
        Optional businessMail;
        Optional businessAddress;
        Optional businessFax;
        Optional mobilePhone;
        Optional businessPhone;
        SalesforceLeadInfo salesforceLeadInfo = new SalesforceLeadInfo();
        Optional name = GlobalUtils.getFirstListItem((List)contactInfo.getNames());
        if (name.isPresent()) {
            salesforceLeadInfo.setLastName(((ContactnameInfo)name.get()).getLastName());
            salesforceLeadInfo.setFirstName(((ContactnameInfo)name.get()).getFirstName());
            salesforceLeadInfo.setSalutation(((ContactnameInfo)name.get()).getSuffix());
        }
        if ((businessPhone = this.getContactphoneInfoByPhoneType(contactInfo.getPhones(), ContactPhoneType.BUSINESS_TEL)).isPresent()) {
            salesforceLeadInfo.setPhone(((ContactphoneInfo)businessPhone.get()).getValue());
        }
        if ((mobilePhone = this.getContactphoneInfoByPhoneType(contactInfo.getPhones(), ContactPhoneType.CELL)).isPresent()) {
            salesforceLeadInfo.setMobilePhone(((ContactphoneInfo)mobilePhone.get()).getValue());
        }
        if ((businessFax = this.getContactphoneInfoByPhoneType(contactInfo.getPhones(), ContactPhoneType.BUSINESS_FAX)).isPresent()) {
            salesforceLeadInfo.setFax(((ContactphoneInfo)businessFax.get()).getValue());
        }
        if ((businessAddress = this.getContactaddressInfoByType(contactInfo.getAddresses(), ContactFieldType.BUSINESS)).isPresent()) {
            salesforceLeadInfo.setCountry(((ContactaddressInfo)businessAddress.get()).getCountryName());
            salesforceLeadInfo.setCity(((ContactaddressInfo)businessAddress.get()).getCity());
            salesforceLeadInfo.setState(((ContactaddressInfo)businessAddress.get()).getState());
            salesforceLeadInfo.setPostalCode(((ContactaddressInfo)businessAddress.get()).getZip());
            salesforceLeadInfo.setStreet(((ContactaddressInfo)businessAddress.get()).getStreet());
        }
        if ((businessMail = this.getContactemailInfoByType(contactInfo.getEmails(), ContactFieldType.BUSINESS)).isPresent()) {
            salesforceLeadInfo.setEmail(((ContactemailInfo)businessMail.get()).getValue());
        }
        if ((urls = this.getContacturlInfoByType(contactInfo.getUrls(), ContactUrlType.BUSINESS)).isPresent()) {
            salesforceLeadInfo.setWebsite(((ContacturlInfo)urls.get()).getValue());
        }
        salesforceLeadInfo.setDescription(contactInfo.getNote());
        Optional jobInfo = GlobalUtils.getFirstListItem((List)contactInfo.getJobinfos());
        if (jobInfo.isPresent()) {
            String companyName = ((ContactjobinfoInfo)jobInfo.get()).getCompanyName();
            salesforceLeadInfo.setCompany(companyName);
            String title = ((ContactjobinfoInfo)jobInfo.get()).getJobTitle();
            salesforceLeadInfo.setTitle(title);
        }
        return salesforceLeadInfo;
    }

    public void updateLeadRecord(BasicToken basicToken, String CRMRecordId, ContactInfoForRequest contactInfo) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        SalesforceLeadInfo salesforceLeadInfo = this.fillLeadValues(contactInfo);
        try {
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String updateLeadUrl = salesforceAuthToken.getInstance_url() + LEAD_RECORD_BASE_URL + CRMRecordId;
            String leadUpdatedJson = this.gson.toJson((Object)salesforceLeadInfo);
            MediaType JSON = MediaType.parse((String)"application/json;charset=UTF-8");
            RequestBody body = RequestBody.create((MediaType)JSON, (String)leadUpdatedJson);
            Request contactUpdatedRequest = new Request.Builder().url(updateLeadUrl).patch(body).addHeader("Authorization", "Bearer " + salesforceAuthToken.getAccess_token()).build();
            try (Response leadUpdatedResponse = this.client.newCall(contactUpdatedRequest).execute();){
                if (!leadUpdatedResponse.isSuccessful()) {
                    throw new IOException(OkHttpUtils.getResponseBodyString((Response)leadUpdatedResponse));
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Fail to update lead..", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
    }
}

