/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.google.gson.Gson;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.crm.BasicToken;
import com.penpower.worldcard.team.crm.salesforce.vo.SalesforceAccountInfo;
import com.penpower.worldcard.team.crm.salesforce.vo.contact.SalesforceContactInfoFully;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.ContactDao;
import com.penpower.worldcard.team.dao.ContactStatusForAccountDao;
import com.penpower.worldcard.team.dto.CRMSettingsDto;
import com.penpower.worldcard.team.dto.ContactInfoForRequest;
import com.penpower.worldcard.team.dto.ContactInfoForResponse;
import com.penpower.worldcard.team.dto.ContactaddressInfo;
import com.penpower.worldcard.team.dto.ContactemailInfo;
import com.penpower.worldcard.team.dto.ContactjobinfoInfo;
import com.penpower.worldcard.team.dto.ContactnameInfo;
import com.penpower.worldcard.team.dto.ContactphoneInfo;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.entity.Contactstatusforaccount;
import com.penpower.worldcard.team.enums.ContactFieldType;
import com.penpower.worldcard.team.enums.ContactPhoneType;
import com.penpower.worldcard.team.enums.RecognizeSourceType;
import com.penpower.worldcard.team.enums.UpdateComponent;
import com.penpower.worldcard.team.exception.CRMOperationException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.CRMOperationService;
import com.penpower.worldcard.team.service.SalesforceExportService;
import com.penpower.worldcard.team.service.SalesforceService;
import com.penpower.worldcard.team.service.impl.SalesforceContactOperation;
import com.penpower.worldcard.team.web.api.vo.ContactCreationVo;
import com.penpower.worldcard.team.web.api.vo.ContactCrmSyncInfoForCRM;
import com.penpower.worldcard.team.web.api.vo.ContactCrmSyncInfoForWCT;
import com.penpower.worldcard.team.web.api.vo.ContactUpdateVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="SalesforceContactOperation")
@Transactional
public class SalesforceContactOperation
implements CRMOperationService {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceContactOperation.class);
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private ContactDao contactDao;
    @Autowired
    private ContactStatusForAccountDao contactStatusForAccountDao;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private SalesforceExportService salesforceExportService;
    @Autowired
    private SalesforceService salesforceService;
    @Autowired
    private SalesforceService salesforceBasicService;

    public String getExportedCrmID(String accountGuid, String contactGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            throw new ItemNotFoundException("[getExportedCrmID]: Can not find account.");
        }
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            throw new ItemNotFoundException("[getExportedCrmID]: Can not find contact.");
        }
        Contactstatusforaccount status = this.contactStatusForAccountDao.findFirstByAccountAndContact(account, contact);
        if (status == null) {
            throw new ItemNotFoundException("[getExportedCrmID]: Can not find status.");
        }
        CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
        String crmAccount = crmSettingsDto.getUserCRMAccount();
        String crmID = status.getExporttosalesforceid();
        if (crmAccount.equals(status.getSalesforceaccount())) {
            return crmID;
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void setExportCrmInfo(String accountGuid, String contactGuid, String exportedCrmRecordID, String exportedCrmAccount, DateTime crmRecordModifyTime) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            throw new ItemNotFoundException("[setExportCrmInfo]: Can not find account.");
        }
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            throw new ItemNotFoundException("[setExportCrmInfo]: Can not find contact.");
        }
        Contactstatusforaccount status = this.contactStatusForAccountDao.findFirstByAccountAndContact(account, contact);
        if (status == null) {
            throw new ItemNotFoundException("[setExportCrmInfo]: Can not find status.");
        }
        if (exportedCrmRecordID != null) {
            status.setExporttosalesforceid(exportedCrmRecordID);
        }
        if (exportedCrmAccount != null) {
            status.setSalesforceaccount(exportedCrmAccount);
        }
        if (crmRecordModifyTime != null) {
            status.setPreviousModifiedTimeForSalesforceContact(crmRecordModifyTime);
        }
        this.contactStatusForAccountDao.save((Object)status);
    }

    public void exportContactCheck(ContactInfoForResponse contactInfo) {
        Optional name = GlobalUtils.getFirstListItem((List)contactInfo.getNames());
        if (!name.isPresent() || StringUtil.IsStringNullorEmpty((String)((ContactnameInfo)name.get()).getLastName())) {
            SalesforceErrorResponse response = new SalesforceErrorResponse(this, "There is no last name.", SalesforceErrorCode.REQUIRED_FIELD_MISSING, Arrays.asList("LastName"));
            List<SalesforceErrorResponse> responses = Arrays.asList(response);
            throw new CRMOperationException(GlobalUtils.getJsonString(responses));
        }
        List mails = contactInfo.getEmails();
        for (ContactemailInfo mail : mails) {
            if (StringUtil.IsStringNullorEmpty((String)mail.getValue()) || mail.getValue().matches("^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z]+$")) continue;
            SalesforceErrorResponse response = new SalesforceErrorResponse(this, "Email is invalid.", SalesforceErrorCode.INVALID_EMAIL_ADDRESS, Arrays.asList("Email"));
            List<SalesforceErrorResponse> responses = Arrays.asList(response);
            throw new CRMOperationException(GlobalUtils.getJsonString(responses));
        }
    }

    private void skipIfThisErrorCode(Exception e, SalesforceErrorCode errorCode) throws Exception {
        Gson gson = new Gson();
        List list = (List)gson.fromJson(e.getMessage(), new /* Unavailable Anonymous Inner Class!! */.getType());
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw e;
        }
        SalesforceErrorResponse response = (SalesforceErrorResponse)list.get(0);
        if (!errorCode.equals((Object)response.getErrorCode())) {
            throw e;
        }
    }

    public void deleteRecord(String accountGuid, String crmID, String contactGuid, boolean isForSync, BasicToken basicToken) {
        try {
            this.salesforceService.deleteContact(basicToken, crmID);
        }
        catch (Exception e) {
            LOG.error("salesforceService.deleteContact fail: {}", (Object)e.getMessage());
            try {
                this.skipIfThisErrorCode(e, SalesforceErrorCode.DELETE_FAILED);
            }
            catch (Exception e2) {
                LOG.error("parse salesforce error message fail: {}", (Object)e2.getMessage());
                throw e;
            }
        }
        if (isForSync) {
            ContactCrmSyncInfoForCRM record = this.getRecordSyncInfo(accountGuid, crmID, basicToken);
            if (record == null) {
                throw new ItemNotFoundException("CRM record deleted, but get it back failed.");
            }
            this.setExportCrmInfo(accountGuid, contactGuid, "", "", record.getModifiedTime());
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public String exportContactToCRM(String accountGuid, ContactInfoForResponse contactInfo, boolean isForSync, BasicToken basicToken) {
        CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
        String retCrmID = "";
        try {
            retCrmID = this.salesforceExportService.createNewContactRecord(basicToken, (ContactInfoForRequest)contactInfo);
        }
        catch (Exception e) {
            LOG.error("salesforceExportService.createNewContactRecord fail: {}", (Object)e.getMessage());
            try {
                this.skipIfThisErrorCode(e, SalesforceErrorCode.DUPLICATES_DETECTED);
            }
            catch (Exception e2) {
                LOG.error("parse salesforce error message fail: {}", (Object)e2.getMessage());
                throw e;
            }
        }
        DateTime crmModifyTime = null;
        if (isForSync) {
            ContactCrmSyncInfoForCRM record = this.getRecordSyncInfo(accountGuid, retCrmID, basicToken);
            if (record == null) {
                throw new ItemNotFoundException("Contact exported, but get corresponding CRM record failed.");
            }
            crmModifyTime = record.getModifiedTime();
        }
        this.setExportCrmInfo(accountGuid, contactInfo.getGuid(), retCrmID, crmSettingsDto.getUserCRMAccount(), crmModifyTime);
        return retCrmID;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void updateContactToCRM(String accountGuid, ContactInfoForResponse contactInfo, String crmID, boolean isForSync, BasicToken basicToken) {
        if (this.salesforceBasicService.contactDeleted(basicToken, crmID)) {
            this.exportContactToCRM(accountGuid, contactInfo, isForSync, basicToken);
        } else {
            try {
                this.salesforceExportService.updateContactRecord(basicToken, crmID, (ContactInfoForRequest)contactInfo);
            }
            catch (Exception e) {
                LOG.error("salesforceExportService.updateContactRecord fail: {}", (Object)e.getMessage());
                try {
                    this.skipIfThisErrorCode(e, SalesforceErrorCode.DUPLICATES_DETECTED);
                }
                catch (Exception e2) {
                    LOG.error("parse salesforce error message fail: {}", (Object)e2.getMessage());
                    throw e;
                }
            }
            if (isForSync) {
                ContactCrmSyncInfoForCRM record = this.getRecordSyncInfo(accountGuid, crmID, basicToken);
                if (record == null) {
                    throw new ItemNotFoundException("CRM record udpated, but get it back failed.");
                }
                this.setExportCrmInfo(accountGuid, contactInfo.getGuid(), null, null, record.getModifiedTime());
            }
        }
    }

    public List<ContactCrmSyncInfoForCRM> getCrmSyncInfosByAccount(String accountGuid, DateTime lastSyncCompletedTime, BasicToken basicToken) {
        DateTime lastTime = lastSyncCompletedTime == null ? GlobalUtils.getEarliestTime() : lastSyncCompletedTime;
        CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
        List records = this.salesforceService.getModifiedContactRecordsAfterSpecifiedTime(basicToken, lastTime);
        List<ContactCrmSyncInfoForCRM> syncInfos = records.stream().map(r -> new ContactCrmSyncInfoForCRM(r.getId(), Boolean.valueOf(r.isIsDeleted()), r.getLastModifiedDate(), crmSettingsDto.getUserCRMAccount())).collect(Collectors.toList());
        syncInfos.sort((p1, p2) -> p1.getModifiedTime().compareTo((ReadableInstant)p2.getModifiedTime()));
        return syncInfos;
    }

    public List<ContactCrmSyncInfoForWCT> getWctSyncInfosByAccount(String accountGuid, DateTime lastSyncCompletedTime) {
        DateTime lastTime = lastSyncCompletedTime == null ? GlobalUtils.getEarliestTime() : lastSyncCompletedTime;
        List statusList = this.contactStatusForAccountDao.findContactByAccountAndModifyTimeForSync(accountGuid, lastTime);
        ArrayList<ContactCrmSyncInfoForWCT> syncInfos = new ArrayList<ContactCrmSyncInfoForWCT>();
        for (Contactstatusforaccount status : statusList) {
            if (status.getIsdeletedfromaccount().booleanValue() && status.getModifyTimeForCrmSync().isBefore((ReadableInstant)lastTime)) continue;
            ContactCrmSyncInfoForWCT syncInfo = this.getSyncInfoForWctFromStatus(status);
            LOG.debug("[getWctSyncInfosByAccount] syncInfo:{}", (Object)syncInfo);
            syncInfos.add(syncInfo);
        }
        syncInfos.sort((p1, p2) -> p1.getModifiedTime().compareTo((ReadableInstant)p2.getModifiedTime()));
        return syncInfos;
    }

    public ContactCrmSyncInfoForCRM getRecordSyncInfo(String accountGuid, String crmID, BasicToken basicToken) {
        if (StringUtil.IsStringNullorEmpty((String)crmID)) {
            return null;
        }
        CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
        SalesforceContactInfoFully record = this.salesforceService.getContactRecord(basicToken, crmID);
        if (record == null) {
            return null;
        }
        return new ContactCrmSyncInfoForCRM(crmID, Boolean.valueOf(record.isIsDeleted()), record.getLastModifiedDate(), crmSettingsDto.getUserCRMAccount());
    }

    public ContactCrmSyncInfoForWCT getWctSyncInfoByCorrespondingCrmSyncInfo(String accountGuid, ContactCrmSyncInfoForCRM syncInfoCRM) {
        List statusList = this.contactStatusForAccountDao.findByAccountAndSalesforceAccountAndContactID(accountGuid, syncInfoCRM.getSyncCrmAccount(), syncInfoCRM.getCrmID());
        if (CollectionUtils.isEmpty((Collection)statusList)) {
            return null;
        }
        Contactstatusforaccount status = null;
        if (statusList.size() >= 2) {
            String exceptionString = String.format("There should not have 2 more contacts correspond to the same CRM record.(account guid:%s,salesforce account:%s,salesforce contact ID:%s)", accountGuid, syncInfoCRM.getSyncCrmAccount(), syncInfoCRM.getCrmID());
            LOG.error(exceptionString);
            status = this.pickupStatusByTime(statusList);
            LOG.error("Picked contact status:{}", (Object)status.getGuid());
        } else {
            status = (Contactstatusforaccount)statusList.get(0);
        }
        ContactCrmSyncInfoForWCT syncInfoWCT = this.getSyncInfoForWctFromStatus(status);
        return syncInfoWCT;
    }

    private Contactstatusforaccount pickupStatusByTime(List<Contactstatusforaccount> statusList) {
        return statusList.get(0);
    }

    private ContactCrmSyncInfoForWCT getSyncInfoForWctFromStatus(Contactstatusforaccount status) {
        Contact contact = status.getContact();
        boolean isDeleted = status.getIsdeletedfromaccount();
        DateTime modifyTime = status.getModifyTimeForCrmSync();
        DateTime contactModifyTime = contact.getModifyTimeForCrmSync();
        if (!status.getIsdeletedfromaccount().booleanValue() && contactModifyTime != null && contactModifyTime.isAfter((ReadableInstant)modifyTime)) {
            modifyTime = contactModifyTime;
        }
        ContactCrmSyncInfoForWCT syncInfo = new ContactCrmSyncInfoForWCT(contact.getGuid(), status.getPreviousModifiedTimeForSalesforceContact(), status.getExporttosalesforceid(), Boolean.valueOf(isDeleted), modifyTime, status.getSalesforceaccount());
        return syncInfo;
    }

    public ContactUpdateVo getContactUpdateVoByCrmID(ContactCrmSyncInfoForWCT syncInfoWCT, BasicToken basicToken, ContactInfoForRequest originalContactInfo) {
        String crmID = syncInfoWCT.getCrmID();
        if (StringUtil.IsStringNullorEmpty((String)crmID)) {
            return null;
        }
        SalesforceContactInfoFully record = this.salesforceService.getContactRecord(basicToken, crmID);
        if (record == null) {
            return null;
        }
        ContactInfoForRequest contactInfo = this.getContactCreationVoFromSalesforceContactInfoFully(record);
        contactInfo.setRecogLanguageFront(originalContactInfo.getRecogLanguageFront());
        contactInfo.setRecogLanguageBack(originalContactInfo.getRecogLanguageBack());
        ContactUpdateVo resultVo = new ContactUpdateVo();
        BeanUtils.copyProperties((Object)contactInfo, (Object)resultVo);
        resultVo.setContactGuid(syncInfoWCT.getContactGuid());
        resultVo.setUpdateComponents(new UpdateComponent[]{UpdateComponent.UC_CONTENT});
        resultVo.setdisplayModifyTime(record.getLastModifiedDate());
        return resultVo;
    }

    public ContactCreationVo getContactCreationVoByCrmID(String accountGuid, String crmID, BasicToken basicToken) {
        if (StringUtil.IsStringNullorEmpty((String)crmID)) {
            return null;
        }
        SalesforceContactInfoFully record = this.salesforceService.getContactRecord(basicToken, crmID);
        if (record == null) {
            return null;
        }
        ContactInfoForRequest contactInfo = this.getContactCreationVoFromSalesforceContactInfoFully(record);
        ContactCreationVo resultVo = new ContactCreationVo();
        BeanUtils.copyProperties((Object)contactInfo, (Object)resultVo);
        resultVo.setCreatorAccountGuid(accountGuid);
        resultVo.setClientCreatedTime(record.getCreatedDate());
        return resultVo;
    }

    private ContactInfoForRequest getContactCreationVoFromSalesforceContactInfoFully(SalesforceContactInfoFully record) {
        ContactaddressInfo address;
        ContactphoneInfo phone;
        ContactInfoForRequest resultVo = new ContactInfoForRequest();
        ContactnameInfo name = new ContactnameInfo();
        name.setLastName(record.getLastName());
        name.setFirstName(record.getFirstName());
        name.setSuffix(record.getSalutation());
        name.setRecognizeSource(RecognizeSourceType.MANUAL);
        resultVo.getNames().add(name);
        SalesforceAccountInfo sfAccount = record.getAccount();
        if (sfAccount != null && !StringUtil.IsStringNullorEmpty((String)sfAccount.getName()) || !StringUtil.IsStringNullorEmpty((String)record.getDepartment()) || !StringUtil.IsStringNullorEmpty((String)record.getTitle())) {
            String companyName = "";
            if (sfAccount != null) {
                companyName = sfAccount.getName();
            }
            ContactjobinfoInfo jobInfo = new ContactjobinfoInfo(companyName, record.getDepartment(), record.getTitle(), RecognizeSourceType.MANUAL);
            resultVo.getJobinfos().add(jobInfo);
        }
        if (!StringUtil.IsStringNullorEmpty((String)record.getHomePhone())) {
            phone = new ContactphoneInfo(record.getHomePhone(), ContactPhoneType.HOME_TEL, RecognizeSourceType.MANUAL);
            resultVo.getPhones().add(phone);
        }
        if (!StringUtil.IsStringNullorEmpty((String)record.getPhone())) {
            phone = new ContactphoneInfo(record.getPhone(), ContactPhoneType.BUSINESS_TEL, RecognizeSourceType.MANUAL);
            resultVo.getPhones().add(phone);
        }
        if (!StringUtil.IsStringNullorEmpty((String)record.getMobilePhone())) {
            phone = new ContactphoneInfo(record.getMobilePhone(), ContactPhoneType.CELL, RecognizeSourceType.MANUAL);
            resultVo.getPhones().add(phone);
        }
        if (!StringUtil.IsStringNullorEmpty((String)record.getOtherPhone())) {
            phone = new ContactphoneInfo(record.getOtherPhone(), ContactPhoneType.OTHER_TEL, RecognizeSourceType.MANUAL);
            resultVo.getPhones().add(phone);
        }
        if (!StringUtil.IsStringNullorEmpty((String)record.getFax())) {
            phone = new ContactphoneInfo(record.getFax(), ContactPhoneType.BUSINESS_FAX, RecognizeSourceType.MANUAL);
            resultVo.getPhones().add(phone);
        }
        if (!(StringUtil.IsStringNullorEmpty((String)record.getMailingCountry()) && StringUtil.IsStringNullorEmpty((String)record.getMailingCity()) && StringUtil.IsStringNullorEmpty((String)record.getMailingState()) && StringUtil.IsStringNullorEmpty((String)record.getMailingStreet()) && StringUtil.IsStringNullorEmpty((String)record.getMailingPostalCode()))) {
            int addressFormat = 0;
            address = new ContactaddressInfo(record.getMailingCountry(), record.getMailingCity(), record.getMailingState(), record.getMailingStreet(), record.getMailingPostalCode(), Integer.valueOf(addressFormat), ContactFieldType.BUSINESS, RecognizeSourceType.MANUAL);
            resultVo.getAddresses().add(address);
        }
        if (!(StringUtil.IsStringNullorEmpty((String)record.getOtherCountry()) && StringUtil.IsStringNullorEmpty((String)record.getOtherCity()) && StringUtil.IsStringNullorEmpty((String)record.getOtherState()) && StringUtil.IsStringNullorEmpty((String)record.getOtherStreet()) && StringUtil.IsStringNullorEmpty((String)record.getOtherPostalCode()))) {
            int addressFormat = 0;
            address = new ContactaddressInfo(record.getOtherCountry(), record.getOtherCity(), record.getOtherState(), record.getOtherStreet(), record.getOtherPostalCode(), Integer.valueOf(addressFormat), ContactFieldType.OTHER, RecognizeSourceType.MANUAL);
            resultVo.getAddresses().add(address);
        }
        if (!StringUtil.IsStringNullorEmpty((String)record.getEmail())) {
            ContactemailInfo mail = new ContactemailInfo(record.getEmail(), ContactFieldType.BUSINESS, RecognizeSourceType.MANUAL);
            resultVo.getEmails().add(mail);
        }
        if (!StringUtil.IsStringNullorEmpty((String)record.getBirthdate())) {
            DateTimeFormatter dtfOut = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
            DateTime birthday = dtfOut.parseDateTime(record.getBirthdate());
            resultVo.setBirthday(birthday);
        }
        resultVo.setNote(record.getDescription());
        return resultVo;
    }
}

