/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.HardwareIdUtil;
import com.penpower.worldcard.team.Utils.RegistryInformationUtil;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.RegistryDao;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.LoginCode;
import com.penpower.worldcard.team.dto.RegistryDto;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.entity.Registry;
import com.penpower.worldcard.team.enums.AccountLockCase;
import com.penpower.worldcard.team.enums.AccountLockedIssue;
import com.penpower.worldcard.team.enums.AccountSubscriptionStatus;
import com.penpower.worldcard.team.enums.ServerRegisterStatus;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.enums.UserRole;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.exception.PermissionDeniedException;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.TokenService;
import com.penpower.worldcard.team.service.impl.RegistryServiceImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RegistryServiceImpl
implements RegistryService {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryServiceImpl.class);
    private static final String REGISTRATION_URL = "http://sw-license.penpower.net/Register/PPRManage.dll?v=100&dt=7360f3485a6e903c7f47f4726d48d598c7fca1f5fef58ac59e99d9ef";
    @Autowired
    private RegistryDao registryDao;
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private AccountService accountService;
    private static DateTime trialExpiredTime;
    @Value(value="${Servertype}")
    private String serverType;
    private static ServerRegisterStatus globalServerRegisterStatus;
    private static int globalCheckServerRegisterStatus;

    public LoginCode getfakeLoginCode() {
        LoginCode loginCode = new LoginCode();
        loginCode.setCode("1196aeb316e1ef3198c1b68af874fb01d428c48d88f2f74edd5474d72a4f7399c1bc1346f4bb819600019897ae9c7af776f212f2eba33b5670d8712824995d24caafc0435ecaf0b421a8b9b8ab7102e9b07ca505114915221757ae3ec74dfb1e95876927145e88f03b62963558e1960924253fcb0cbf76c3038bf61ed073c46d572a2c9031090d0921d0f1c6140fd3f90668da4942dd9d1fa4e44a63883c0272eaf6050bf2f87d14ad5aa145");
        loginCode.setHWID1("001378D6A002");
        loginCode.setHWID2("9CA87DAC-1B69-11E7-87A2-001378D6A002");
        return loginCode;
    }

    public boolean IsAnyRegisterSupportSubscription() {
        List registrys = this.getRegistryInfoincludeExpried(false);
        for (RegistryDto registrydto : registrys) {
            if (!registrydto.getCanSubscrib()) continue;
            return true;
        }
        return false;
    }

    public LoginCode getLoginCode() {
        LoginCode loginCode = new LoginCode();
        List registrys = this.getRegistryInfo(false);
        if (registrys != null && registrys.size() > 0) {
            String macAddress = HardwareIdUtil.getEthernetInterfaceMac((ServerType)this.GetServerType()).toUpperCase();
            String hardwareId = HardwareIdUtil.GetMachineID((ServerType)this.GetServerType()).toUpperCase();
            for (RegistryDto reg : registrys) {
                LOG.debug("getLoginCode reg={}", (Object)reg);
                if (reg.getHwid().compareToIgnoreCase(macAddress) != 0 || reg.getHwid2().compareToIgnoreCase(hardwareId) != 0) continue;
                loginCode.setCode(reg.GetLoginCode());
                loginCode.setHWID1(macAddress);
                loginCode.setHWID2(hardwareId);
                LOG.debug("getLoginCode setCode reg={}", (Object)reg);
                if (!StringUtil.IsStringNullorEmpty((String)loginCode.getCode())) continue;
                LOG.debug("getLoginCode setCode= none", (Object)reg);
                loginCode.setCode("none");
            }
        }
        return loginCode;
    }

    public ServerType GetServerType() {
        LOG.debug("ServerType={}", (Object)this.serverType);
        ServerType svrType = ServerType.valueOf((String)this.serverType);
        LOG.debug("ServerTypeA={}", (Object)svrType);
        GlobalUtils.setServerType((ServerType)svrType);
        return svrType;
    }

    public int getLicenseCount(boolean IsNeedToCheckAdmin) {
        if (IsNeedToCheckAdmin) {
            this.CheckIsAdmin();
        }
        LOG.debug("getLicenseCount 1");
        List registrys = this.getRegistryInfo(IsNeedToCheckAdmin);
        LOG.debug("getLicenseCount 1 registrys={}", (Object)registrys);
        if (registrys != null && registrys.size() != 0) {
            int count = (int)registrys.stream().mapToInt(registry -> registry.getLicenseCount()).summaryStatistics().getSum();
            return count;
        }
        return 0;
    }

    public Registry getSystemRegInfo(String companyGuid) {
        List Registrys = this.registryDao.findAll();
        Registry regfirst = null;
        Iterator iterator = Registrys.iterator();
        if (iterator.hasNext()) {
            Registry reg = (Registry)iterator.next();
            LOG.debug("reg ={}", (Object)reg);
            RegistryDto dto = this.getRegistryDto(reg);
            LOG.debug("regdto ={}", (Object)dto);
            regfirst = reg;
        }
        if (regfirst != null) {
            if (!StringUtil.IsStringNullorEmpty((String)companyGuid)) {
                Company company = this.companyService.findOne(companyGuid);
                regfirst.setCompanyName(company.getName());
            } else {
                List companys = this.companyService.FindAllCompany();
                if (companys.size() > 0) {
                    regfirst.setCompanyName(((Company)companys.get(0)).getName());
                }
            }
        }
        return regfirst;
    }

    public List<RegistryDto> getRegistryInfo(boolean IsNeedToCheckAdmin) {
        LOG.debug("RealRegistrys IsNeedToCheckAdmin={}", (Object)IsNeedToCheckAdmin);
        List FilterRegistrys = this.getRegistryInfoincludeExpried(IsNeedToCheckAdmin);
        ArrayList<RegistryDto> RealRegistrys = new ArrayList<RegistryDto>();
        LOG.debug("FilterRegistrys regs={}", (Object)FilterRegistrys);
        for (RegistryDto registrydto : FilterRegistrys) {
            if (registrydto.getIsTrial()) continue;
            RealRegistrys.add(registrydto);
        }
        if (RealRegistrys.size() == 0) {
            RegistryDto lastTrialregistry = null;
            for (RegistryDto registrydto : FilterRegistrys) {
                if (!registrydto.getIsTrial()) continue;
                if (lastTrialregistry == null) {
                    lastTrialregistry = registrydto;
                    continue;
                }
                DateTime dtTrialDate = registrydto.ParserValidateDate();
                if (!dtTrialDate.isAfter((ReadableInstant)lastTrialregistry.ParserValidateDate())) continue;
                lastTrialregistry = registrydto;
            }
            if (lastTrialregistry != null) {
                LOG.debug("lastTrialregistry regs={}", lastTrialregistry);
                if (!lastTrialregistry.getIsExpired()) {
                    RealRegistrys.add(lastTrialregistry);
                }
            }
        }
        LOG.debug("RealRegistrys regs={}", RealRegistrys);
        return RealRegistrys;
    }

    public void CheckLicenseValidate(String companyGuid) {
        long validateAcntCount = this.getLicenseCount(false);
        LOG.debug("CheckLicenseValidate validateAcntCount ={}", (Object)validateAcntCount);
        List accountInfos = this.accountService.getAccountInfos(companyGuid);
        LOG.debug("CheckLicenseValidate accountInfossize ={}", (Object)accountInfos.size());
        List accountsGuidsInSubscription = accountInfos.stream().filter(account -> AccountLockedIssue.NO_ISSUE.equals((Object)account.getLockedIssue())).filter(account -> UserStatus.ACTIVE.equals((Object)account.getStatus()) || UserStatus.INACTIVE.equals((Object)account.getStatus())).map(account -> account.getGuid()).collect(Collectors.toList());
        LOG.debug("CheckLicenseValidate accountsGuidsInSubscriptionsize ={}", (Object)accountsGuidsInSubscription.size());
        if ((long)accountsGuidsInSubscription.size() > validateAcntCount) {
            if (validateAcntCount == 0L) {
                this.accountService.updateSubscriptionStatus(accountsGuidsInSubscription, AccountSubscriptionStatus.TEMPLATE_INVALIDATE, companyGuid, AccountLockCase.SUBSCRIPTION_EXPIRED);
            } else {
                this.accountService.updateSubscriptionStatus(accountsGuidsInSubscription, AccountSubscriptionStatus.TEMPLATE_INVALIDATE, companyGuid, AccountLockCase.SUBSCRIPTION_REDUCE);
            }
            this.accountService.SetAllUserTokenInvalidate();
        }
    }

    private int parserRegistryInfoinNormalCount(List<RegistryDto> allRegistrys) {
        ArrayList<RegistryDto> RealRegistrys = new ArrayList<RegistryDto>();
        LOG.debug("getRegistryInfoinNormal regs={}", allRegistrys);
        for (RegistryDto registrydto : allRegistrys) {
            if (registrydto.getIsTrial()) continue;
            RealRegistrys.add(registrydto);
        }
        if (RealRegistrys != null && RealRegistrys.size() != 0) {
            int count = (int)RealRegistrys.stream().mapToInt(registry -> registry.getLicenseCount()).summaryStatistics().getSum();
            return count;
        }
        return 0;
    }

    public int getRegistryInfoinNormalCount() {
        List FilterRegistrys = this.getRegistryInfoincludeExpried(false);
        return this.parserRegistryInfoinNormalCount(FilterRegistrys);
    }

    private RegistryDto parserRegistryTrial(List<RegistryDto> allRegistrys) {
        RegistryDto lastTrialregistry = null;
        LOG.debug("getRegistryTrial size={}", (Object)allRegistrys.size());
        for (RegistryDto registrydto : allRegistrys) {
            LOG.debug("getRegistryTrial registrydto={}", (Object)registrydto);
            if (!registrydto.getIsTrial()) continue;
            if (lastTrialregistry == null) {
                lastTrialregistry = registrydto;
                continue;
            }
            DateTime dtTrialDate = registrydto.ParserValidateDate();
            if (!dtTrialDate.isAfter((ReadableInstant)lastTrialregistry.ParserValidateDate())) continue;
            lastTrialregistry = registrydto;
        }
        if (lastTrialregistry != null) {
            return lastTrialregistry;
        }
        return null;
    }

    public RegistryDto getRegistryTrial() {
        List FilterRegistrys = this.getRegistryInfoincludeExpried(false);
        return this.parserRegistryTrial(FilterRegistrys);
    }

    public ServerRegisterStatus GetRegisterStatus(String companyGuid) {
        LOG.debug("GetRegisterStatus globalCheckServerRegisterStatus ={} , globalServerRegisterStatus ={}", (Object)globalCheckServerRegisterStatus, (Object)globalServerRegisterStatus);
        if (globalServerRegisterStatus != ServerRegisterStatus.ACTIVED || globalCheckServerRegisterStatus > 10) {
            LOG.debug("GetRegisterStatus start");
            globalCheckServerRegisterStatus = 0;
            List FilterRegistrys = this.getRegistryInfoincludeExpried(false);
            long accountCount = this.accountService.getAccountCountIncludeNotValid(companyGuid);
            long accountNormalCountLimit = this.parserRegistryInfoinNormalCount(FilterRegistrys);
            RegistryDto trialRegister = this.parserRegistryTrial(FilterRegistrys);
            ServerRegisterStatus SRS = ServerRegisterStatus.NOT_ACTIVED;
            LOG.debug("GetRegisterStatus accountCount={}", (Object)accountCount);
            LOG.debug("GetRegisterStatus accountNormalCountLimit={}", (Object)accountNormalCountLimit);
            LOG.debug("GetRegisterStatus trialRegister={}", (Object)trialRegister);
            SRS = accountCount > 0L ? (accountNormalCountLimit > 0L ? ServerRegisterStatus.ACTIVED : (trialRegister == null ? ServerRegisterStatus.NEED_REINITIAL : (!trialRegister.getIsExpired() ? ServerRegisterStatus.TRIAL_USE : ServerRegisterStatus.TRIAL_EXPIRED))) : ServerRegisterStatus.NOT_ACTIVED;
            globalServerRegisterStatus = SRS;
            return SRS;
        }
        ++globalCheckServerRegisterStatus;
        return globalServerRegisterStatus;
    }

    public List<RegistryDto> getRegistryInfoincludeExpried(boolean IsNeedToCheckAdmin) {
        List registrys;
        ArrayList<RegistryDto> FilterRegistrys = new ArrayList<RegistryDto>();
        if (IsNeedToCheckAdmin) {
            this.CheckIsAdmin();
        }
        if ((registrys = this.registryDao.findAll()) == null || registrys.size() <= 0) {
            return FilterRegistrys;
        }
        LOG.debug("getRegistryInfo 3 registrys count ={}", (Object)registrys.size());
        for (Registry rs : registrys) {
            LOG.debug("getRegistryInfo 4 Registry t ={}", (Object)rs);
        }
        List registryDtos = registrys.stream().filter(dto -> dto != null).map(registry -> this.getRegistryDto(registry)).filter(dto -> dto != null).collect(Collectors.toList());
        LOG.debug("getRegistryInfo 3 registryDtos ={}", registryDtos);
        String macAddress = HardwareIdUtil.getEthernetInterfaceMac((ServerType)this.GetServerType());
        String hardwareId = HardwareIdUtil.GetMachineID((ServerType)this.GetServerType());
        if (macAddress == null || macAddress.length() == 0 || hardwareId == null || hardwareId.length() == 0) {
            return FilterRegistrys;
        }
        registryDtos.sort((p1, p2) -> p1.getSnid().compareTo(p2.getSnid()));
        String strPreKey = "";
        LOG.debug("getRegistryInfo regs={}", registryDtos);
        for (RegistryDto registrydto : registryDtos) {
            LOG.debug("getRegistryInfo registrydto ={}", (Object)registrydto);
            LOG.debug("getRegistryInfo strPreKey ={} macAddress  ={}   hardwareId ={}", new Object[]{strPreKey, macAddress, hardwareId});
            if (registrydto.getSnid().compareTo(strPreKey) != 0 && registrydto.getHwid().compareToIgnoreCase(macAddress) == 0 && registrydto.getHwid2().compareToIgnoreCase(hardwareId) == 0) {
                FilterRegistrys.add(registrydto);
            }
            strPreKey = registrydto.getSnid();
        }
        return FilterRegistrys;
    }

    private RegistryDto getRegistryDto(Registry registry) {
        LOG.debug("getRegistryDto registry={}", (Object)registry);
        String registrationByte = registry.getAttributeValue();
        LOG.debug("GetRegistryDto={}", (Object)registrationByte);
        String macAddress = HardwareIdUtil.getEthernetInterfaceMac((ServerType)this.GetServerType());
        LOG.debug("getRegistryDto macAddress={}", (Object)macAddress);
        String hardwareId = HardwareIdUtil.GetMachineID((ServerType)this.GetServerType());
        LOG.debug("getRegistryDto hardwareId={}", (Object)hardwareId);
        RegistryDto registryDto = null;
        registryDto = RegistryInformationUtil.getRegistryInfomation((String)registrationByte, (String)macAddress, (ServerType)this.GetServerType());
        LOG.debug("getRegistryDto registryDto={}", (Object)registryDto);
        if (registryDto != null) {
            LOG.debug("registryDto.getSnid={}", (Object)registryDto.getSnid());
            registryDto.setUpdateTime(registry.getUpdateTime());
        } else {
            registryDto = new RegistryDto("query", registry.getAttributeKey(), macAddress, hardwareId, "", registry.getEmail(), 0, "", "19700101-010000", 0);
        }
        return registryDto;
    }

    private void CheckIsAdmin() {
        LOG.debug("CheckIsAdmin ");
        AccountInfo currentAccountInfo = SecurityUtils.getCurrentLoginUser();
        Account currentAcnt = this.accountDao.findOne(currentAccountInfo.getGuid());
        if (currentAcnt != null) {
            if (currentAcnt.getRole() != UserRole.ADMIN) {
                LOG.debug("CheckIsAdmin not admin ");
                throw new PermissionDeniedException("Need admin account");
            }
        } else {
            LOG.debug("currant  not admin ");
            throw new PermissionDeniedException("Need admin account");
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void ReRegister(String email, String licenseCode) {
        LOG.debug("ReRegister = {}   {}", (Object)email, (Object)licenseCode);
        if (this.getLicenseCount(false) > 0) {
            throw new PermissionDeniedException("Can't register server wiithout auth after server initialed");
        }
        licenseCode = licenseCode.toUpperCase();
        LOG.debug("register 1");
        String CompanyName = "";
        Registry curregistry = this.getSystemRegInfo("");
        if (curregistry != null) {
            CompanyName = curregistry.getCompanyName();
        }
        RegisterPostOperation registerPostOperation = new RegisterPostOperation(this, RegisterOperation.REGISTER, licenseCode, email, CompanyName, "", null);
        LOG.debug("register 2");
        registerPostOperation.execute();
        LOG.debug("registerPostOperation : {} ", (Object)registerPostOperation.toString());
        Registry registry = null;
        Registry currentRegistry = this.registryDao.findFirstByattributekey(licenseCode);
        if (currentRegistry == null) {
            LOG.debug("register new ");
            registry = new Registry();
            registry.setGuid(UUIDGenerator.getRandomUUID());
            registry.setEmail(email);
            registry.setCompanyName(CompanyName);
            registry.setUpdateTime(new DateTime());
            registry.setAttributeKey(licenseCode);
            String macAddress = HardwareIdUtil.getEthernetInterfaceMac((ServerType)this.GetServerType());
            registry.setAttributeValue(registerPostOperation.getResponseRawData());
            if (registerPostOperation.getRegistryDto() != null) {
                registry.setAttributeValueEx(registerPostOperation.getRegistryDto().GetLoginCode());
            }
            this.registryDao.save((Object)registry);
        } else {
            LOG.debug("register find exist");
            currentRegistry.setEmail(email);
            currentRegistry.setUpdateTime(new DateTime());
            currentRegistry.setCompanyName(CompanyName);
            currentRegistry.setAttributeKey(licenseCode);
            String macAddress = HardwareIdUtil.getEthernetInterfaceMac((ServerType)this.GetServerType());
            currentRegistry.setAttributeValue(registerPostOperation.getResponseRawData());
            if (registerPostOperation.getRegistryDto() != null) {
                currentRegistry.setAttributeValueEx(registerPostOperation.getRegistryDto().GetLoginCode());
            }
            this.registryDao.save((Object)currentRegistry);
        }
        LOG.debug("register 4");
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void DownloadRegistryInfo(String companyGuid, boolean interrupt) {
        long nLicenseCount;
        LOG.debug("DownloadRegistryInfo START");
        List registrys = this.getRegistryInfoincludeExpried(false);
        for (RegistryDto reg : registrys) {
            if (interrupt) break;
            this.Query(reg.getSnid(), reg.getEmail(), "", "", false);
            LOG.debug("DownloadRegistryInfo check {}", (Object)reg.getSnid());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if ((nLicenseCount = (long)this.getLicenseCount(false)) == 0L) {
            this.tokenService.cleanTokens();
            LOG.debug("DownloadRegistryInfo no valid license logout all account");
        }
        this.CheckLicenseValidate(companyGuid);
        LOG.debug("DownloadRegistryInfo end");
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void Query(String licenseCode, String email, String name, String tel, boolean IsNeedToCheckAdmin) {
        LOG.debug("IsNeedToCheckAdmin= {}", (Object)IsNeedToCheckAdmin);
        licenseCode = licenseCode.toUpperCase();
        LOG.debug("query 1");
        RegisterPostOperation registerPostOperation = new RegisterPostOperation(this, RegisterOperation.QUERY, licenseCode, email, name, tel, null);
        LOG.debug("query 2");
        registerPostOperation.execute();
        LOG.debug("registerPostOperation query respone  ={}", (Object)registerPostOperation.getResponseRawData());
        Object registry = null;
        Registry currentRegistry = this.registryDao.findFirstByattributekey(licenseCode);
        if (currentRegistry != null) {
            LOG.debug("query find exist ");
            String regResult = registerPostOperation.getResponseRawData();
            int Index = regResult.indexOf("ng:");
            if (Index >= 0) {
                String result = regResult.substring(Index + 3, regResult.length());
                LOG.debug("result= {}", (Object)result);
                int resultInt = 0;
                try {
                    resultInt = Integer.parseInt(result);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (resultInt == -21 || resultInt == -23 || resultInt == -25) {
                    currentRegistry.setAttributeValue("");
                    LOG.debug("Query set attrib rtn ={}", (Object)resultInt);
                }
            } else if (!StringUtil.IsStringNullorEmpty((String)regResult) && StringUtil.IsfullAplhaNum((String)regResult) && regResult.length() > 200) {
                currentRegistry.setAttributeValue(regResult);
                RegistryDto registryDto = this.getRegistryDto(currentRegistry);
                if (registryDto == null) {
                    LOG.debug("Query respone data is not validate");
                    return;
                }
                if (registryDto.getSnid().compareToIgnoreCase(licenseCode) != 0) {
                    LOG.debug("Query respone data decode error");
                    return;
                }
            } else {
                LOG.debug("Query respone data has sign");
                return;
            }
            if (registerPostOperation.getRegistryDto() != null) {
                currentRegistry.setAttributeValueEx(registerPostOperation.getRegistryDto().GetLoginCode());
            }
            this.registryDao.save((Object)currentRegistry);
        }
        LOG.debug("query 4");
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void RegisterwithoutTrial(String email, String licenseCode, String companyName, String companyTel, boolean IsNeedToCheckAdmin, String country) {
        LOG.debug("IsNeedToCheckAdmin= {}", (Object)IsNeedToCheckAdmin);
        if (IsNeedToCheckAdmin) {
            LOG.debug("IsNeedToCheckAdmin = true");
            this.CheckIsAdmin();
        } else if (this.getLicenseCount(IsNeedToCheckAdmin) > 0) {
            throw new PermissionDeniedException("Can't register server wiithout auth after server initialed");
        }
        licenseCode = licenseCode.toUpperCase();
        LOG.debug("register 1");
        RegisterPostOperation registerPostOperation = new RegisterPostOperation(this, RegisterOperation.REGWOTRIAL, licenseCode, email, companyName, companyTel, country);
        LOG.debug("register 2");
        registerPostOperation.execute();
        LOG.debug("registerPostOperation : {} ", (Object)registerPostOperation.toString());
        Registry registry = null;
        Registry currentRegistry = this.registryDao.findFirstByattributekey(licenseCode);
        if (currentRegistry == null) {
            LOG.debug("register new ");
            registry = new Registry();
            registry.setGuid(UUIDGenerator.getRandomUUID());
            registry.setEmail(email);
            registry.setCompanyName(companyName);
            registry.setUpdateTime(new DateTime());
            registry.setAttributeKey(licenseCode);
            String macAddress = HardwareIdUtil.getEthernetInterfaceMac((ServerType)this.GetServerType());
            registry.setAttributeValue(registerPostOperation.getResponseRawData());
            if (registerPostOperation.getRegistryDto() != null) {
                registry.setAttributeValueEx(registerPostOperation.getRegistryDto().GetLoginCode());
            }
            this.registryDao.save((Object)registry);
        } else {
            LOG.debug("register find exist");
            currentRegistry.setEmail(email);
            currentRegistry.setUpdateTime(new DateTime());
            currentRegistry.setCompanyName(companyName);
            currentRegistry.setAttributeKey(licenseCode);
            String macAddress = HardwareIdUtil.getEthernetInterfaceMac((ServerType)this.GetServerType());
            currentRegistry.setAttributeValue(registerPostOperation.getResponseRawData());
            if (registerPostOperation.getRegistryDto() != null) {
                currentRegistry.setAttributeValueEx(registerPostOperation.getRegistryDto().GetLoginCode());
            }
            this.registryDao.save((Object)currentRegistry);
        }
        LOG.debug("register 4");
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void register(String email, String licenseCode, String companyName, String companyTel, boolean IsNeedToCheckAdmin, String country) {
        LOG.debug("IsNeedToCheckAdmin= {}", (Object)IsNeedToCheckAdmin);
        if (IsNeedToCheckAdmin) {
            LOG.debug("IsNeedToCheckAdmin = true");
            this.CheckIsAdmin();
        } else if (this.getLicenseCount(IsNeedToCheckAdmin) > 0) {
            throw new PermissionDeniedException("Can't register server wiithout auth after server initialed");
        }
        licenseCode = licenseCode.toUpperCase();
        LOG.debug("register 1");
        RegisterPostOperation registerPostOperation = new RegisterPostOperation(this, RegisterOperation.REGISTER, licenseCode, email, companyName, companyTel, country);
        LOG.debug("register 2");
        registerPostOperation.execute();
        LOG.debug("registerPostOperation : {} ", (Object)registerPostOperation.toString());
        Registry registry = null;
        Registry currentRegistry = this.registryDao.findFirstByattributekey(licenseCode);
        if (currentRegistry == null) {
            LOG.debug("register new ");
            registry = new Registry();
            registry.setGuid(UUIDGenerator.getRandomUUID());
            registry.setEmail(email);
            registry.setCompanyName(companyName);
            registry.setUpdateTime(new DateTime());
            registry.setAttributeKey(licenseCode);
            String macAddress = HardwareIdUtil.getEthernetInterfaceMac((ServerType)this.GetServerType());
            registry.setAttributeValue(registerPostOperation.getResponseRawData());
            if (registerPostOperation.getRegistryDto() != null) {
                registry.setAttributeValueEx(registerPostOperation.getRegistryDto().GetLoginCode());
            }
            this.registryDao.save((Object)registry);
        } else {
            LOG.debug("register find exist");
            currentRegistry.setEmail(email);
            currentRegistry.setUpdateTime(new DateTime());
            currentRegistry.setCompanyName(companyName);
            currentRegistry.setAttributeKey(licenseCode);
            String macAddress = HardwareIdUtil.getEthernetInterfaceMac((ServerType)this.GetServerType());
            currentRegistry.setAttributeValue(registerPostOperation.getResponseRawData());
            if (registerPostOperation.getRegistryDto() != null) {
                currentRegistry.setAttributeValueEx(registerPostOperation.getRegistryDto().GetLoginCode());
            }
            this.registryDao.save((Object)currentRegistry);
        }
        LOG.debug("register 4");
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void clearRegistry() {
        this.registryDao.deleteAll();
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    static {
        globalServerRegisterStatus = ServerRegisterStatus.NONE;
        globalCheckServerRegisterStatus = 0;
    }
}

