/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.CategoryDao;
import com.penpower.worldcard.team.dao.ContactDao;
import com.penpower.worldcard.team.dto.CategoryInfo;
import com.penpower.worldcard.team.dto.CategoryInfoMultiLayer;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Category;
import com.penpower.worldcard.team.enums.CategoryType;
import com.penpower.worldcard.team.exception.CategoryAlreadyExistsException;
import com.penpower.worldcard.team.exception.CategoryIsNotEmptyException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.PermissionDeniedException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.service.MultiLayerCategoryService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional
public class MultiLayerCategoryServiceImpl
implements MultiLayerCategoryService {
    private static final Logger LOG = LoggerFactory.getLogger(MultiLayerCategoryServiceImpl.class);
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private CategoryDao categoryDao;
    @Autowired
    private ContactDao contactDao;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public CategoryInfoMultiLayer createCategory(String categoryName, String ownerAccountGuid, String parentCategoryGuid) {
        Account owner = this.findAccount(ownerAccountGuid);
        String innerParentCategoryGuid = parentCategoryGuid;
        if (!StringUtil.IsStringNullorEmpty((String)parentCategoryGuid)) {
            Category parentCategory = this.findCategory(parentCategoryGuid, "Specified parent category is not found.");
            if (!this.isPureNormalCategory(parentCategory)) {
                throw new RequestArgumentNotValidException("Specified parent category is not NORMAL type or created by secretary.");
            }
        } else {
            innerParentCategoryGuid = null;
        }
        this.checkDuplicatedName(categoryName, owner, innerParentCategoryGuid);
        Category category = new Category();
        category.setGuid(UUIDGenerator.getRandomUUID());
        category.setName(categoryName);
        category.setOwneraccount(owner);
        category.setCategoryType(CategoryType.NORMAL);
        DateTime curTime = new DateTime();
        category.setUpdateTime(curTime);
        category.setParentCategoryGuid(innerParentCategoryGuid);
        this.categoryDao.save((Object)category);
        this.accountDao.save((Object)owner);
        return new CategoryInfoMultiLayer(category);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public CategoryInfo updateCategory(String categoryGuid, String categoryName) {
        Category category = this.findCategory(categoryGuid);
        if (category.getSecretaryaccountguid() != null) {
            throw new PermissionDeniedException("From secretary category can't be updated");
        }
        this.checkDuplicatedName(categoryName, category.getOwneraccount(), category.getParentCategoryGuid());
        category.setName(categoryName);
        category.setUpdateTime(new DateTime());
        this.categoryDao.save((Object)category);
        CategoryInfo newCategoryInfo = new CategoryInfo(category);
        return newCategoryInfo;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteCategory(String categoryGuid) {
        Category category = this.findCategory(categoryGuid);
        if (!CategoryType.NORMAL.equals((Object)category.getCategoryType())) {
            throw new RequestArgumentNotValidException("Category type is not normal.");
        }
        Long contactCount = this.contactDao.countByCategoryWithDeleted(categoryGuid);
        if (contactCount > 0L) {
            throw new CategoryIsNotEmptyException("There are contatcs in the category.");
        }
        Long categoryCount = this.categoryDao.countByParentCategoryGuid(categoryGuid);
        if (categoryCount > 0L) {
            throw new CategoryIsNotEmptyException("There are sub-categories in the category.");
        }
        this.categoryDao.delete((Serializable)((Object)categoryGuid));
    }

    public List<CategoryInfoMultiLayer> getCategoriesByParent(String accountGuid, String parentCategoryGuid) {
        Account owneraccount = this.accountDao.findOne(accountGuid);
        if (owneraccount == null) {
            throw new ItemNotFoundException("Account is not found.");
        }
        if (StringUtil.IsStringNullorEmpty((String)parentCategoryGuid)) {
            parentCategoryGuid = null;
        }
        List categories = this.categoryDao.findByOwneraccountAndParentCategoryGuid(owneraccount, parentCategoryGuid);
        List<CategoryInfoMultiLayer> categoryInfos = categories.stream().map(c -> new CategoryInfoMultiLayer(c)).collect(Collectors.toList());
        return categoryInfos;
    }

    public List<CategoryInfoMultiLayer> getCategoriesByAccount(String accountGuid) {
        Account owneraccount = this.accountDao.findOne(accountGuid);
        if (owneraccount == null) {
            throw new ItemNotFoundException("Account is not found.");
        }
        List categories = this.categoryDao.findByOwneraccount(owneraccount);
        List<CategoryInfoMultiLayer> categoryInfos = categories.stream().map(c -> new CategoryInfoMultiLayer(c)).collect(Collectors.toList());
        return categoryInfos;
    }

    public Long countChildCategoris(String categoryGuid) {
        Long count = this.categoryDao.countByParentCategoryGuid(categoryGuid);
        return count;
    }

    public CategoryInfoMultiLayer getCategory(String categoryGuid) {
        Category category = this.findCategory(categoryGuid);
        return new CategoryInfoMultiLayer(category);
    }

    public List<CategoryInfoMultiLayer> getCategoriesToggled(String accountGuid) {
        Account owneraccount = this.accountDao.findOne(accountGuid);
        if (owneraccount == null) {
            throw new ItemNotFoundException("Account is not found.");
        }
        List categories = this.categoryDao.findByOwneraccountAndIsUsualOrderByDisplayorderAsc(owneraccount, true);
        List<CategoryInfoMultiLayer> categoryInfos = categories.stream().map(c -> new CategoryInfoMultiLayer(c)).collect(Collectors.toList());
        return categoryInfos;
    }

    private boolean isPureNormalCategory(Category category) {
        return CategoryType.NORMAL.equals((Object)category.getCategoryType()) && StringUtil.IsStringNullorEmpty((String)category.getSecretaryaccountguid());
    }

    private Category findCategory(String categoryGuid) {
        return this.findCategory(categoryGuid, "category is not found.");
    }

    private Category findCategory(String categoryGuid, String message) {
        Category category = (Category)this.categoryDao.findOne((Serializable)((Object)categoryGuid));
        if (category == null) {
            throw new ItemNotFoundException(message);
        }
        return category;
    }

    private Account findAccount(String accountGuid) {
        return this.findAccount(accountGuid, "account is not found.");
    }

    private Account findAccount(String accountGuid, String message) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            throw new ItemNotFoundException(message);
        }
        return account;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void moveCategory(String movedCategoryGuid, String targetParentCategoryGuid) {
        Category movedCategory = this.findCategory(movedCategoryGuid, "Moved category is not found");
        Category targetCategory = this.findCategory(targetParentCategoryGuid, "Target category for moving is not found.");
        if (!this.isPureNormalCategory(movedCategory)) {
            throw new RequestArgumentNotValidException("Specified moved category is not valid.");
        }
        if (!this.isPureNormalCategory(targetCategory)) {
            throw new RequestArgumentNotValidException("Specified target category is not valid.");
        }
        if (!movedCategory.getOwneraccount().equals((Object)targetCategory.getOwneraccount())) {
            throw new RequestArgumentNotValidException("Category can not move to another account.");
        }
        if (movedCategory.isAncestorOf(targetCategory, this.categoryDao)) {
            throw new RequestArgumentNotValidException("Category can not move to its descendants.");
        }
        this.checkDuplicatedName(movedCategory.getName(), targetCategory.getOwneraccount(), targetParentCategoryGuid);
        movedCategory.setParentCategoryGuid(targetParentCategoryGuid);
        this.categoryDao.save((Object)movedCategory);
    }

    private void checkDuplicatedName(String categoryName, Account categoryOwner, String targetParentCategoryGuid) {
        List targetChildCategories = this.categoryDao.findByOwneraccountAndParentCategoryGuid(categoryOwner, targetParentCategoryGuid);
        if (targetChildCategories.stream().anyMatch(c -> categoryName.equals(c.getName()))) {
            throw new CategoryAlreadyExistsException("There is duplicated category name in the same layer.");
        }
    }

    public CategoryInfoMultiLayer findCategoryWithName(String categoryName, String categoryOwnerGuid, String parentCategoryGuid) {
        Account categoryOwner;
        List targetChildCategories;
        Optional<Category> category;
        String innerParentCategoryGuid = parentCategoryGuid;
        if (StringUtil.IsStringNullorEmpty((String)parentCategoryGuid)) {
            innerParentCategoryGuid = null;
        }
        if ((category = (targetChildCategories = this.categoryDao.findByOwneraccountAndParentCategoryGuid(categoryOwner = this.findAccount(categoryOwnerGuid), innerParentCategoryGuid)).stream().filter(c -> categoryName.equals(c.getName())).findFirst()).isPresent()) {
            return new CategoryInfoMultiLayer(category.get());
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void moveCategoryToRoot(String movedCategoryGuid) {
        Category movedCategory = this.findCategory(movedCategoryGuid, "Moved category is not found");
        if (!this.isPureNormalCategory(movedCategory)) {
            throw new RequestArgumentNotValidException("Specified moved category is not valid.");
        }
        this.checkDuplicatedName(movedCategory.getName(), movedCategory.getOwneraccount(), null);
        movedCategory.setParentCategoryGuid(null);
        this.categoryDao.save((Object)movedCategory);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void setOrderOfToggledCategories(String categoryOwnerGuid, List<String> orderedCategoryGuids) {
        Account categoryOwner = this.findAccount(categoryOwnerGuid, "Category owner is not found.");
        List orderedCategories = this.categoryDao.findByGuidList(orderedCategoryGuids);
        if (orderedCategories.size() != orderedCategoryGuids.size()) {
            throw new RequestArgumentNotValidException("Some categories are not found or there are duplicated category guids.");
        }
        if (orderedCategories.stream().anyMatch(c -> !categoryOwnerGuid.equals(c.getOwneraccount().getGuid()))) {
            throw new RequestArgumentNotValidException("These categories belong to different accounts.");
        }
        if (orderedCategories.stream().anyMatch(c -> !c.isUsual())) {
            throw new RequestArgumentNotValidException("Some categories are not toggled ones.");
        }
        List allToggledCategories = this.categoryDao.findByOwneraccountAndIsUsualOrderByDisplayorderAsc(categoryOwner, true);
        List reorderedCategories = this.reorderToggledCategories(allToggledCategories, orderedCategoryGuids);
        this.categoryDao.save((Iterable)reorderedCategories);
    }

    private List<Category> reorderToggledCategories(List<Category> allToggledCategories, List<String> orderedCategoryGuids) {
        int assignedListStartIndex = 0;
        int unassignedListStartIndex = orderedCategoryGuids.size();
        for (Category category : allToggledCategories) {
            int position = orderedCategoryGuids.indexOf(category.getGuid());
            if (position >= 0) {
                category.setDisplayOrder(assignedListStartIndex + position);
                continue;
            }
            category.setDisplayOrder(unassignedListStartIndex);
            ++unassignedListStartIndex;
        }
        return allToggledCategories;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void toggleCategories(String categoryOwnerGuid, List<String> categoryGuids, boolean isToggled) {
        List setCategories = this.categoryDao.findByGuidList(categoryGuids);
        if (setCategories.stream().anyMatch(c -> !categoryOwnerGuid.equals(c.getOwneraccount().getGuid()))) {
            throw new RequestArgumentNotValidException("These categories belong to different accounts.");
        }
        if (setCategories.size() != categoryGuids.size()) {
            throw new ItemNotFoundException("Some categories are not found or there are duplicated category guids.");
        }
        Account categoryOwner = this.findAccount(categoryOwnerGuid);
        List currentToggledCategories = this.categoryDao.findByOwneraccountAndIsUsualOrderByDisplayorderAsc(categoryOwner, true);
        if (isToggled) {
            setCategories.forEach(c -> c.setUsual(true));
            this.categoryDao.save((Iterable)setCategories);
            ArrayList newlyToggledCategories = new ArrayList(setCategories);
            newlyToggledCategories.removeAll(currentToggledCategories);
            currentToggledCategories.addAll(newlyToggledCategories);
            List orderedCategoryGuids = currentToggledCategories.stream().map(c -> c.getGuid()).collect(Collectors.toList());
            List reorderedCategories = this.reorderToggledCategories(currentToggledCategories, orderedCategoryGuids);
            this.categoryDao.save((Iterable)reorderedCategories);
        } else {
            setCategories.forEach(c -> c.setUsual(false));
            this.categoryDao.save((Iterable)setCategories);
        }
    }

    public String getTypeAllCategoryGuidByAccount(String accountGuid) {
        Account account = this.findAccount(accountGuid);
        Category category = this.categoryDao.findFirstByOwneraccountAndCategorytype(account, CategoryType.ALL);
        return category.getGuid();
    }

    public int getLayerIndex(String categoryGuid) {
        int index = 0;
        Category category = this.findCategory(categoryGuid);
        String parentCategoryGuid = category.getParentCategoryGuid();
        while (!StringUtil.IsStringNullorEmpty((String)parentCategoryGuid)) {
            ++index;
            category = this.findCategory(parentCategoryGuid);
            parentCategoryGuid = category.getParentCategoryGuid();
        }
        return index;
    }

    public int getChildLayerCount(String categoryGuid) {
        int layerCount = 0;
        ArrayList childCategoryGuids = this.categoryDao.findGuidByParentCategoryGuid(categoryGuid);
        int childCound = childCategoryGuids.size();
        while (childCound > 0) {
            ++layerCount;
            ArrayList copyChildCategoryGuids = new ArrayList(childCategoryGuids);
            childCategoryGuids = new ArrayList();
            for (String guid : copyChildCategoryGuids) {
                List categoryGuids = this.categoryDao.findGuidByParentCategoryGuid(guid);
                childCategoryGuids.addAll(categoryGuids);
            }
            childCound = childCategoryGuids.size();
        }
        return layerCount;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void renameAllSecretaryCategoriesCreatedByAccount(String accountGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            throw new ItemNotFoundException("Account is not found.");
        }
        List categories = this.categoryDao.findBySecretaryaccountguid(accountGuid);
        if (CollectionUtils.isEmpty((Collection)categories)) {
            return;
        }
        for (Category category : categories) {
            String oldName = category.getName();
            String newName = "From " + account.getDisplayName();
            LOG.debug("categoryGuid:{}, oldName:{}, newName:{}", new Object[]{category.getGuid(), oldName, newName});
            category.setName(newName);
        }
        this.categoryDao.save((Iterable)categories);
    }
}

