/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.LoginfailedlinfoDao;
import com.penpower.worldcard.team.entity.Loginfailedlinfo;
import com.penpower.worldcard.team.enums.FailureType;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.LoginfailedlinfoService;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LoginfailedlinfoServiceImpl
implements LoginfailedlinfoService {
    private static final Logger LOG = LoggerFactory.getLogger(LoginfailedlinfoServiceImpl.class);
    @Autowired
    private LoginfailedlinfoDao loginfailedlinfoDao;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void increaseFailureCount(String ipAddress, String account, FailureType failureType) {
        Loginfailedlinfo loginfailedlinfo = this.loginfailedlinfoDao.findByIpaddressAndUseraccountAndFailuretype(ipAddress, account, failureType);
        LOG.debug("increase failure count :  find the loginfailedlinfo[ip={} , email={}]: {} ", new Object[]{ipAddress, account, loginfailedlinfo});
        if (loginfailedlinfo == null) {
            Loginfailedlinfo newLoginfailedlinfo = new Loginfailedlinfo();
            newLoginfailedlinfo.setGuid(UUIDGenerator.getRandomUUID());
            newLoginfailedlinfo.setFailurecount(1);
            newLoginfailedlinfo.setIpaddress(ipAddress);
            newLoginfailedlinfo.setUseraccount(account);
            newLoginfailedlinfo.setLastfailuretime(new DateTime());
            newLoginfailedlinfo.setFailuretype(failureType);
            this.loginfailedlinfoDao.save((Object)newLoginfailedlinfo);
        } else {
            int failureCount = loginfailedlinfo.getFailurecount() + 1;
            loginfailedlinfo.setFailurecount(failureCount);
            loginfailedlinfo.setLastfailuretime(new DateTime());
            loginfailedlinfo.setFailuretype(failureType);
            this.loginfailedlinfoDao.save((Object)loginfailedlinfo);
        }
    }

    public int maxFailureCountexceeded(String ipAddress, String account, FailureType failureType, String companyGuid) {
        Loginfailedlinfo loginfailedlinfo = this.loginfailedlinfoDao.findByIpaddressAndUseraccountAndFailuretype(ipAddress, account, failureType);
        if (loginfailedlinfo == null) {
            return -1;
        }
        int failureCount = loginfailedlinfo.getFailurecount();
        LOG.debug("failureCount : {} ", (Object)failureCount);
        int limitFailureCount = this.companyGlobalInfoService.getValueByKeyWithDefault("LOGIN_FAILURE_COUNT_LIMIT", 5, companyGuid);
        if (failureCount > limitFailureCount) {
            return 1;
        }
        if (failureCount == limitFailureCount) {
            return 0;
        }
        return -1;
    }

    public Loginfailedlinfo getLoginfailedlinfo(String ipAddress, String account, FailureType failureType) {
        Loginfailedlinfo loginfailedlinfo = this.loginfailedlinfoDao.findByIpaddressAndUseraccountAndFailuretype(ipAddress, account, failureType);
        return loginfailedlinfo;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void resetAccountLimit(String email, FailureType failureType) {
        LOG.debug("try to reset  resetAccountLimit :  , account[{}] : ", (Object)email);
        List loginfailedlinfos = this.loginfailedlinfoDao.findByUseraccountAndFailuretype(email, failureType);
        LOG.debug("loginfailedlinfo : {} ", (Object)loginfailedlinfos);
        if (loginfailedlinfos.size() == 0) {
            return;
        }
        for (Loginfailedlinfo loginfailedlinfo : loginfailedlinfos) {
            this.loginfailedlinfoDao.delete((Object)loginfailedlinfo);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void resetIpAddressLimit(String ipAddress, String account, FailureType failureType) {
        LOG.debug("try to reset ipaddress limit : ipaddress[{}] , account[{}] : ", (Object)ipAddress, (Object)account);
        Loginfailedlinfo loginfailedlinfo = this.loginfailedlinfoDao.findByIpaddressAndUseraccountAndFailuretype(ipAddress, account, failureType);
        LOG.debug("loginfailedlinfo : {} ", (Object)loginfailedlinfo);
        if (loginfailedlinfo == null) {
            return;
        }
        this.loginfailedlinfoDao.delete((Object)loginfailedlinfo);
    }
}

