/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.GlobalinfoDao;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.service.GlobalInfoService;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GlobalInfoServiceImpl
implements GlobalInfoService {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalInfoServiceImpl.class);
    @Autowired
    private GlobalinfoDao globalinfoDao;

    public List<Globalinfo> getAllProperties() {
        return this.globalinfoDao.findAll();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public Globalinfo createNewProperties(String key, String value) {
        Globalinfo globalInfo = this.globalinfoDao.findByConfigkey(key);
        if (globalInfo == null) {
            LOG.debug("create new properties : {} ", (Object)globalInfo);
            globalInfo = new Globalinfo();
            globalInfo.setGuid(UUIDGenerator.getRandomUUID());
            globalInfo.setConfigKey(key);
        }
        globalInfo.setConfigValue(value);
        Globalinfo result = (Globalinfo)this.globalinfoDao.saveAndFlush((Object)globalInfo);
        return result;
    }

    public String getPropertiesStringByKey(String key) {
        LOG.info("Find by ke : {} ", (Object)key);
        Globalinfo globalInfo = this.globalinfoDao.findByConfigkey(key);
        LOG.info("globalInfo : {} ", (Object)globalInfo);
        if (globalInfo != null) {
            return globalInfo.getConfigValue();
        }
        return "";
    }

    public Globalinfo getPropertiesByKey(String key) {
        Globalinfo globalInfo = this.globalinfoDao.findByConfigkey(key);
        return globalInfo;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void updatePropertyValue(String id, String value) {
        Globalinfo globalInfo = (Globalinfo)this.globalinfoDao.findOne((Serializable)((Object)id));
        globalInfo.setConfigValue(value);
        this.globalinfoDao.save((Object)globalInfo);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void deleteProperty(String guid) {
        this.globalinfoDao.delete((Serializable)((Object)guid));
    }
}

