/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.ForgetPasswordSessionDao;
import com.penpower.worldcard.team.entity.ForgetPasswordSession;
import com.penpower.worldcard.team.service.ForgetPasswordSessionService;
import com.penpower.worldcard.team.web.api.vo.Captcha;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ForgetPasswordSessionServiceImpl
implements ForgetPasswordSessionService {
    private static final Logger LOG = LoggerFactory.getLogger(ForgetPasswordSessionServiceImpl.class);
    private static List<Captcha> Captchas = new ArrayList();
    @Autowired
    private ForgetPasswordSessionDao forgetPasswordSessionDao;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public ForgetPasswordSession createNewSession(String email) {
        ForgetPasswordSession session = new ForgetPasswordSession();
        session.setEmail(email);
        session.setGuid(UUIDGenerator.getRandomUUID());
        session.setCreateDate(new DateTime());
        session.setToken(RandomStringUtils.randomAlphanumeric((int)25));
        ForgetPasswordSession newSession = (ForgetPasswordSession)this.forgetPasswordSessionDao.saveAndFlush((Object)session);
        return newSession;
    }

    public void addCaptcha(String imageCode, String guid) {
        for (int i = Captchas.size() - 1; i >= 0; --i) {
            Captcha captcha = (Captcha)Captchas.get(i);
            Period period = new Period((ReadableInstant)captcha.getCreateTime(), (ReadableInstant)DateTime.now());
            LOG.debug("addCaptcha period getSeconds ={}", (Object)period.getSeconds());
            if (captcha.getGuid().compareTo(guid) != 0) continue;
            Captchas.remove(i);
        }
        Captcha captcha = new Captcha(imageCode, guid);
        Captchas.add(captcha);
    }

    public void delCaptcha(String guid) {
        for (int i = Captchas.size() - 1; i >= 0; --i) {
            Captcha captcha = (Captcha)Captchas.get(i);
            if (captcha.getGuid().compareTo(guid) != 0) continue;
            Captchas.remove(i);
        }
    }

    public String getCaptcha(String guid) {
        for (Captcha captcha : Captchas) {
            if (captcha.getGuid().compareToIgnoreCase(guid) != 0) continue;
            return captcha.getImageCode();
        }
        return "";
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void removeAllSession(String email) {
        this.forgetPasswordSessionDao.deleteByEmail(email);
    }

    public ForgetPasswordSession getLatestSession(String email) {
        ForgetPasswordSession session = this.forgetPasswordSessionDao.findFirstByEmailOrderByCreatedateDesc(email);
        LOG.debug("find first session by email order by create date desc : {} ", (Object)session);
        return session;
    }
}

